import { Transport, TransportRequestOptions, TransportRequestOptionsWithMeta, TransportRequestOptionsWithOutMeta, TransportResult } from '@elastic/transport';
import * as T from '../types';
interface That {
    transport: Transport;
    acceptedParams: Record<string, {
        path: string[];
        body: string[];
        query: string[];
    }>;
}
export default class Esql {
    transport: Transport;
    acceptedParams: Record<string, {
        path: string[];
        body: string[];
        query: string[];
    }>;
    constructor(transport: Transport);
    /**
      * Run an async ES|QL query. Asynchronously run an ES|QL (Elasticsearch query language) query, monitor its progress, and retrieve results when they become available. The API accepts the same parameters and request body as the synchronous query API, along with additional async related properties.
      * @see {@link https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-esql-async-query | Elasticsearch API documentation}
      */
    asyncQuery(this: That, params: T.EsqlAsyncQueryRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.EsqlAsyncQueryResponse>;
    asyncQuery(this: That, params: T.EsqlAsyncQueryRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.EsqlAsyncQueryResponse, unknown>>;
    asyncQuery(this: That, params: T.EsqlAsyncQueryRequest, options?: TransportRequestOptions): Promise<T.EsqlAsyncQueryResponse>;
    /**
      * Delete an async ES|QL query. If the query is still running, it is cancelled. Otherwise, the stored results are deleted. If the Elasticsearch security features are enabled, only the following users can use this API to delete a query: * The authenticated user that submitted the original query request * Users with the `cancel_task` cluster privilege
      * @see {@link https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-esql-async-query-delete | Elasticsearch API documentation}
      */
    asyncQueryDelete(this: That, params: T.EsqlAsyncQueryDeleteRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.EsqlAsyncQueryDeleteResponse>;
    asyncQueryDelete(this: That, params: T.EsqlAsyncQueryDeleteRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.EsqlAsyncQueryDeleteResponse, unknown>>;
    asyncQueryDelete(this: That, params: T.EsqlAsyncQueryDeleteRequest, options?: TransportRequestOptions): Promise<T.EsqlAsyncQueryDeleteResponse>;
    /**
      * Get async ES|QL query results. Get the current status and available results or stored results for an ES|QL asynchronous query. If the Elasticsearch security features are enabled, only the user who first submitted the ES|QL query can retrieve the results using this API.
      * @see {@link https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-esql-async-query-get | Elasticsearch API documentation}
      */
    asyncQueryGet(this: That, params: T.EsqlAsyncQueryGetRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.EsqlAsyncQueryGetResponse>;
    asyncQueryGet(this: That, params: T.EsqlAsyncQueryGetRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.EsqlAsyncQueryGetResponse, unknown>>;
    asyncQueryGet(this: That, params: T.EsqlAsyncQueryGetRequest, options?: TransportRequestOptions): Promise<T.EsqlAsyncQueryGetResponse>;
    /**
      * Stop async ES|QL query. This API interrupts the query execution and returns the results so far. If the Elasticsearch security features are enabled, only the user who first submitted the ES|QL query can stop it.
      * @see {@link https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-esql-async-query-stop | Elasticsearch API documentation}
      */
    asyncQueryStop(this: That, params: T.EsqlAsyncQueryStopRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.EsqlAsyncQueryStopResponse>;
    asyncQueryStop(this: That, params: T.EsqlAsyncQueryStopRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.EsqlAsyncQueryStopResponse, unknown>>;
    asyncQueryStop(this: That, params: T.EsqlAsyncQueryStopRequest, options?: TransportRequestOptions): Promise<T.EsqlAsyncQueryStopResponse>;
    /**
      * Get a specific running ES|QL query information. Returns an object extended information about a running ES|QL query.
      */
    getQuery(this: That, params: T.EsqlGetQueryRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.EsqlGetQueryResponse>;
    getQuery(this: That, params: T.EsqlGetQueryRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.EsqlGetQueryResponse, unknown>>;
    getQuery(this: That, params: T.EsqlGetQueryRequest, options?: TransportRequestOptions): Promise<T.EsqlGetQueryResponse>;
    /**
      * Get running ES|QL queries information. Returns an object containing IDs and other information about the running ES|QL queries.
      */
    listQueries(this: That, params?: T.EsqlListQueriesRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.EsqlListQueriesResponse>;
    listQueries(this: That, params?: T.EsqlListQueriesRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.EsqlListQueriesResponse, unknown>>;
    listQueries(this: That, params?: T.EsqlListQueriesRequest, options?: TransportRequestOptions): Promise<T.EsqlListQueriesResponse>;
    /**
      * Run an ES|QL query. Get search results for an ES|QL (Elasticsearch query language) query.
      * @see {@link https://www.elastic.co/docs/explore-analyze/query-filter/languages/esql-rest | Elasticsearch API documentation}
      */
    query(this: That, params: T.EsqlQueryRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.EsqlQueryResponse>;
    query(this: That, params: T.EsqlQueryRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.EsqlQueryResponse, unknown>>;
    query(this: That, params: T.EsqlQueryRequest, options?: TransportRequestOptions): Promise<T.EsqlQueryResponse>;
}
export {};
