/**
 * We are still working on this type, it will arrive soon.
 * If it's critical for you, please open an issue.
 * https://github.com/elastic/elasticsearch-js
 */
export type TODO = Record<string, any>;
export interface BulkCreateOperation extends BulkWriteOperation {
}
export interface BulkDeleteOperation extends BulkOperationBase {
}
export type BulkFailureStoreStatus = 'not_applicable_or_unknown' | 'used' | 'not_enabled' | 'failed';
export interface BulkIndexOperation extends BulkWriteOperation {
}
export interface BulkOperationBase {
    /** The document ID. */
    _id?: Id;
    /** The name of the index or index alias to perform the action on. */
    _index?: IndexName;
    /** A custom value used to route operations to a specific shard. */
    routing?: Routing;
    if_primary_term?: long;
    if_seq_no?: SequenceNumber;
    version?: VersionNumber;
    version_type?: VersionType;
}
export interface BulkOperationContainer {
    /** Index the specified document.
      * If the document exists, it replaces the document and increments the version.
      * The following line must contain the source data to be indexed. */
    index?: BulkIndexOperation;
    /** Index the specified document if it does not already exist.
      * The following line must contain the source data to be indexed. */
    create?: BulkCreateOperation;
    /** Perform a partial document update.
      * The following line must contain the partial document and update options. */
    update?: BulkUpdateOperation;
    /** Remove the specified document from the index. */
    delete?: BulkDeleteOperation;
}
export type BulkOperationType = 'index' | 'create' | 'update' | 'delete';
export interface BulkRequest<TDocument = unknown, TPartialDocument = unknown> extends RequestBase {
    /** The name of the data stream, index, or index alias to perform bulk actions on. */
    index?: IndexName;
    /** True or false if to include the document source in the error message in case of parsing errors. */
    include_source_on_error?: boolean;
    /** If `true`, the response will include the ingest pipelines that were run for each index or create. */
    list_executed_pipelines?: boolean;
    /** The pipeline identifier to use to preprocess incoming documents.
      * If the index has a default ingest pipeline specified, setting the value to `_none` turns off the default ingest pipeline for this request.
      * If a final pipeline is configured, it will always run regardless of the value of this parameter. */
    pipeline?: string;
    /** If `true`, Elasticsearch refreshes the affected shards to make this operation visible to search.
      * If `wait_for`, wait for a refresh to make this operation visible to search.
      * If `false`, do nothing with refreshes.
      * Valid values: `true`, `false`, `wait_for`. */
    refresh?: Refresh;
    /** A custom value that is used to route operations to a specific shard. */
    routing?: Routing;
    /** Indicates whether to return the `_source` field (`true` or `false`) or contains a list of fields to return. */
    _source?: SearchSourceConfigParam;
    /** A comma-separated list of source fields to exclude from the response.
      * You can also use this parameter to exclude fields from the subset specified in `_source_includes` query parameter.
      * If the `_source` parameter is `false`, this parameter is ignored. */
    _source_excludes?: Fields;
    /** A comma-separated list of source fields to include in the response.
      * If this parameter is specified, only these source fields are returned.
      * You can exclude fields from this subset using the `_source_excludes` query parameter.
      * If the `_source` parameter is `false`, this parameter is ignored. */
    _source_includes?: Fields;
    /** The period each action waits for the following operations: automatic index creation, dynamic mapping updates, and waiting for active shards.
      * The default is `1m` (one minute), which guarantees Elasticsearch waits for at least the timeout before failing.
      * The actual wait time could be longer, particularly when multiple waits occur. */
    timeout?: Duration;
    /** The number of shard copies that must be active before proceeding with the operation.
      * Set to `all` or any positive integer up to the total number of shards in the index (`number_of_replicas+1`).
      * The default is `1`, which waits for each primary shard to be active. */
    wait_for_active_shards?: WaitForActiveShards;
    /** If `true`, the request's actions must target an index alias. */
    require_alias?: boolean;
    /** If `true`, the request's actions must target a data stream (existing or to be created). */
    require_data_stream?: boolean;
    operations?: (BulkOperationContainer | BulkUpdateAction<TDocument, TPartialDocument> | TDocument)[];
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
        include_source_on_error?: never;
        list_executed_pipelines?: never;
        pipeline?: never;
        refresh?: never;
        routing?: never;
        _source?: never;
        _source_excludes?: never;
        _source_includes?: never;
        timeout?: never;
        wait_for_active_shards?: never;
        require_alias?: never;
        require_data_stream?: never;
        operations?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
        include_source_on_error?: never;
        list_executed_pipelines?: never;
        pipeline?: never;
        refresh?: never;
        routing?: never;
        _source?: never;
        _source_excludes?: never;
        _source_includes?: never;
        timeout?: never;
        wait_for_active_shards?: never;
        require_alias?: never;
        require_data_stream?: never;
        operations?: never;
    };
}
export interface BulkResponse {
    /** If `true`, one or more of the operations in the bulk request did not complete successfully. */
    errors: boolean;
    /** The result of each operation in the bulk request, in the order they were submitted. */
    items: Partial<Record<BulkOperationType, BulkResponseItem>>[];
    /** The length of time, in milliseconds, it took to process the bulk request. */
    took: long;
    ingest_took?: long;
}
export interface BulkResponseItem {
    /** The document ID associated with the operation. */
    _id?: string | null;
    /** The name of the index associated with the operation.
      * If the operation targeted a data stream, this is the backing index into which the document was written. */
    _index: string;
    /** The HTTP status code returned for the operation. */
    status: integer;
    failure_store?: BulkFailureStoreStatus;
    /** Additional information about the failed operation.
      * The property is returned only for failed operations. */
    error?: ErrorCause;
    /** The primary term assigned to the document for the operation.
      * This property is returned only for successful operations. */
    _primary_term?: long;
    /** The result of the operation.
      * Successful values are `created`, `deleted`, and `updated`. */
    result?: string;
    /** The sequence number assigned to the document for the operation.
      * Sequence numbers are used to ensure an older version of a document doesn't overwrite a newer version. */
    _seq_no?: SequenceNumber;
    /** Shard information for the operation. */
    _shards?: ShardStatistics;
    /** The document version associated with the operation.
      * The document version is incremented each time the document is updated.
      * This property is returned only for successful actions. */
    _version?: VersionNumber;
    forced_refresh?: boolean;
    get?: InlineGet<Record<string, any>>;
}
export interface BulkUpdateAction<TDocument = unknown, TPartialDocument = unknown> {
    /** If true, the `result` in the response is set to 'noop' when no changes to the document occur. */
    detect_noop?: boolean;
    /** A partial update to an existing document. */
    doc?: TPartialDocument;
    /** Set to `true` to use the contents of `doc` as the value of `upsert`. */
    doc_as_upsert?: boolean;
    /** The script to run to update the document. */
    script?: Script | ScriptSource;
    /** Set to `true` to run the script whether or not the document exists. */
    scripted_upsert?: boolean;
    /** If `false`, source retrieval is turned off.
      * You can also specify a comma-separated list of the fields you want to retrieve. */
    _source?: SearchSourceConfig;
    /** If the document does not already exist, the contents of `upsert` are inserted as a new document.
      * If the document exists, the `script` is run. */
    upsert?: TDocument;
}
export interface BulkUpdateOperation extends BulkOperationBase {
    /** If `true`, the request's actions must target an index alias. */
    require_alias?: boolean;
    /** The number of times an update should be retried in the case of a version conflict. */
    retry_on_conflict?: integer;
}
export interface BulkWriteOperation extends BulkOperationBase {
    /** A map from the full name of fields to the name of dynamic templates.
      * It defaults to an empty map.
      * If a name matches a dynamic template, that template will be applied regardless of other match predicates defined in the template.
      * If a field is already defined in the mapping, then this parameter won't be used. */
    dynamic_templates?: Record<string, string>;
    /** The ID of the pipeline to use to preprocess incoming documents.
      * If the index has a default ingest pipeline specified, setting the value to `_none` turns off the default ingest pipeline for this request.
      * If a final pipeline is configured, it will always run regardless of the value of this parameter. */
    pipeline?: string;
    /** If `true`, the request's actions must target an index alias. */
    require_alias?: boolean;
}
export interface ClearScrollRequest extends RequestBase {
    /** A comma-separated list of scroll IDs to clear.
      * To clear all scroll IDs, use `_all`.
      * IMPORTANT: Scroll IDs can be long. It is recommended to specify scroll IDs in the request body parameter. */
    scroll_id?: ScrollIds;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        scroll_id?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        scroll_id?: never;
    };
}
export interface ClearScrollResponse {
    /** If `true`, the request succeeded.
      * This does not indicate whether any scrolling search requests were cleared. */
    succeeded: boolean;
    /** The number of scrolling search requests cleared. */
    num_freed: integer;
}
export interface ClosePointInTimeRequest extends RequestBase {
    /** The ID of the point-in-time. */
    id: Id;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        id?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        id?: never;
    };
}
export interface ClosePointInTimeResponse {
    /** If `true`, all search contexts associated with the point-in-time ID were successfully closed. */
    succeeded: boolean;
    /** The number of search contexts that were successfully closed. */
    num_freed: integer;
}
export interface CountRequest extends RequestBase {
    /** A comma-separated list of data streams, indices, and aliases to search.
      * It supports wildcards (`*`).
      * To search all data streams and indices, omit this parameter or use `*` or `_all`. */
    index?: Indices;
    /** If `false`, the request returns an error if any wildcard expression, index alias, or `_all` value targets only missing or closed indices.
      * This behavior applies even if the request targets other open indices.
      * For example, a request targeting `foo*,bar*` returns an error if an index starts with `foo` but no index starts with `bar`. */
    allow_no_indices?: boolean;
    /** The analyzer to use for the query string.
      * This parameter can be used only when the `q` query string parameter is specified. */
    analyzer?: string;
    /** If `true`, wildcard and prefix queries are analyzed.
      * This parameter can be used only when the `q` query string parameter is specified. */
    analyze_wildcard?: boolean;
    /** The default operator for query string query: `AND` or `OR`.
      * This parameter can be used only when the `q` query string parameter is specified. */
    default_operator?: QueryDslOperator;
    /** The field to use as a default when no field prefix is given in the query string.
      * This parameter can be used only when the `q` query string parameter is specified. */
    df?: string;
    /** The type of index that wildcard patterns can match.
      * If the request can target data streams, this argument determines whether wildcard expressions match hidden data streams.
      * It supports comma-separated values, such as `open,hidden`. */
    expand_wildcards?: ExpandWildcards;
    /** If `true`, concrete, expanded, or aliased indices are ignored when frozen. */
    ignore_throttled?: boolean;
    /** If `false`, the request returns an error if it targets a missing or closed index. */
    ignore_unavailable?: boolean;
    /** If `true`, format-based query failures (such as providing text to a numeric field) in the query string will be ignored.
      * This parameter can be used only when the `q` query string parameter is specified. */
    lenient?: boolean;
    /** The minimum `_score` value that documents must have to be included in the result. */
    min_score?: double;
    /** The node or shard the operation should be performed on.
      * By default, it is random. */
    preference?: string;
    /** A custom value used to route operations to a specific shard. */
    routing?: Routing;
    /** The maximum number of documents to collect for each shard.
      * If a query reaches this limit, Elasticsearch terminates the query early.
      * Elasticsearch collects documents before sorting.
      *
      * IMPORTANT: Use with caution.
      * Elasticsearch applies this parameter to each shard handling the request.
      * When possible, let Elasticsearch perform early termination automatically.
      * Avoid specifying this parameter for requests that target data streams with backing indices across multiple data tiers. */
    terminate_after?: long;
    /** The query in Lucene query string syntax. This parameter cannot be used with a request body. */
    q?: string;
    /** Defines the search query using Query DSL. A request body query cannot be used
      * with the `q` query string parameter. */
    query?: QueryDslQueryContainer;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
        allow_no_indices?: never;
        analyzer?: never;
        analyze_wildcard?: never;
        default_operator?: never;
        df?: never;
        expand_wildcards?: never;
        ignore_throttled?: never;
        ignore_unavailable?: never;
        lenient?: never;
        min_score?: never;
        preference?: never;
        routing?: never;
        terminate_after?: never;
        q?: never;
        query?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
        allow_no_indices?: never;
        analyzer?: never;
        analyze_wildcard?: never;
        default_operator?: never;
        df?: never;
        expand_wildcards?: never;
        ignore_throttled?: never;
        ignore_unavailable?: never;
        lenient?: never;
        min_score?: never;
        preference?: never;
        routing?: never;
        terminate_after?: never;
        q?: never;
        query?: never;
    };
}
export interface CountResponse {
    count: long;
    _shards: ShardStatistics;
}
export interface CreateRequest<TDocument = unknown> extends RequestBase {
    /** A unique identifier for the document.
      * To automatically generate a document ID, use the `POST /<target>/_doc/` request format. */
    id: Id;
    /** The name of the data stream or index to target.
      * If the target doesn't exist and matches the name or wildcard (`*`) pattern of an index template with a `data_stream` definition, this request creates the data stream.
      * If the target doesn't exist and doesn’t match a data stream template, this request creates the index. */
    index: IndexName;
    /** True or false if to include the document source in the error message in case of parsing errors. */
    include_source_on_error?: boolean;
    /** The ID of the pipeline to use to preprocess incoming documents.
      * If the index has a default ingest pipeline specified, setting the value to `_none` turns off the default ingest pipeline for this request.
      * If a final pipeline is configured, it will always run regardless of the value of this parameter. */
    pipeline?: string;
    /** If `true`, Elasticsearch refreshes the affected shards to make this operation visible to search.
      * If `wait_for`, it waits for a refresh to make this operation visible to search.
      * If `false`, it does nothing with refreshes. */
    refresh?: Refresh;
    /** If `true`, the destination must be an index alias. */
    require_alias?: boolean;
    /** If `true`, the request's actions must target a data stream (existing or to be created). */
    require_data_stream?: boolean;
    /** A custom value that is used to route operations to a specific shard. */
    routing?: Routing;
    /** The period the request waits for the following operations: automatic index creation, dynamic mapping updates, waiting for active shards.
      * Elasticsearch waits for at least the specified timeout period before failing.
      * The actual wait time could be longer, particularly when multiple waits occur.
      *
      * This parameter is useful for situations where the primary shard assigned to perform the operation might not be available when the operation runs.
      * Some reasons for this might be that the primary shard is currently recovering from a gateway or undergoing relocation.
      * By default, the operation will wait on the primary shard to become available for at least 1 minute before failing and responding with an error.
      * The actual wait time could be longer, particularly when multiple waits occur. */
    timeout?: Duration;
    /** The explicit version number for concurrency control.
      * It must be a non-negative long number. */
    version?: VersionNumber;
    /** The version type. */
    version_type?: VersionType;
    /** The number of shard copies that must be active before proceeding with the operation.
      * You can set it to `all` or any positive integer up to the total number of shards in the index (`number_of_replicas+1`).
      * The default value of `1` means it waits for each primary shard to be active. */
    wait_for_active_shards?: WaitForActiveShards;
    document?: TDocument;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        id?: never;
        index?: never;
        include_source_on_error?: never;
        pipeline?: never;
        refresh?: never;
        require_alias?: never;
        require_data_stream?: never;
        routing?: never;
        timeout?: never;
        version?: never;
        version_type?: never;
        wait_for_active_shards?: never;
        document?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        id?: never;
        index?: never;
        include_source_on_error?: never;
        pipeline?: never;
        refresh?: never;
        require_alias?: never;
        require_data_stream?: never;
        routing?: never;
        timeout?: never;
        version?: never;
        version_type?: never;
        wait_for_active_shards?: never;
        document?: never;
    };
}
export type CreateResponse = WriteResponseBase;
export interface DeleteRequest extends RequestBase {
    /** A unique identifier for the document. */
    id: Id;
    /** The name of the target index. */
    index: IndexName;
    /** Only perform the operation if the document has this primary term. */
    if_primary_term?: long;
    /** Only perform the operation if the document has this sequence number. */
    if_seq_no?: SequenceNumber;
    /** If `true`, Elasticsearch refreshes the affected shards to make this operation visible to search.
      * If `wait_for`, it waits for a refresh to make this operation visible to search.
      * If `false`, it does nothing with refreshes. */
    refresh?: Refresh;
    /** A custom value used to route operations to a specific shard. */
    routing?: Routing;
    /** The period to wait for active shards.
      *
      * This parameter is useful for situations where the primary shard assigned to perform the delete operation might not be available when the delete operation runs.
      * Some reasons for this might be that the primary shard is currently recovering from a store or undergoing relocation.
      * By default, the delete operation will wait on the primary shard to become available for up to 1 minute before failing and responding with an error. */
    timeout?: Duration;
    /** An explicit version number for concurrency control.
      * It must match the current version of the document for the request to succeed. */
    version?: VersionNumber;
    /** The version type. */
    version_type?: VersionType;
    /** The minimum number of shard copies that must be active before proceeding with the operation.
      * You can set it to `all` or any positive integer up to the total number of shards in the index (`number_of_replicas+1`).
      * The default value of `1` means it waits for each primary shard to be active. */
    wait_for_active_shards?: WaitForActiveShards;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        id?: never;
        index?: never;
        if_primary_term?: never;
        if_seq_no?: never;
        refresh?: never;
        routing?: never;
        timeout?: never;
        version?: never;
        version_type?: never;
        wait_for_active_shards?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        id?: never;
        index?: never;
        if_primary_term?: never;
        if_seq_no?: never;
        refresh?: never;
        routing?: never;
        timeout?: never;
        version?: never;
        version_type?: never;
        wait_for_active_shards?: never;
    };
}
export type DeleteResponse = WriteResponseBase;
export interface DeleteByQueryRequest extends RequestBase {
    /** A comma-separated list of data streams, indices, and aliases to search.
      * It supports wildcards (`*`).
      * To search all data streams or indices, omit this parameter or use `*` or `_all`. */
    index: Indices;
    /** If `false`, the request returns an error if any wildcard expression, index alias, or `_all` value targets only missing or closed indices.
      * This behavior applies even if the request targets other open indices.
      * For example, a request targeting `foo*,bar*` returns an error if an index starts with `foo` but no index starts with `bar`. */
    allow_no_indices?: boolean;
    /** Analyzer to use for the query string.
      * This parameter can be used only when the `q` query string parameter is specified. */
    analyzer?: string;
    /** If `true`, wildcard and prefix queries are analyzed.
      * This parameter can be used only when the `q` query string parameter is specified. */
    analyze_wildcard?: boolean;
    /** What to do if delete by query hits version conflicts: `abort` or `proceed`. */
    conflicts?: Conflicts;
    /** The default operator for query string query: `AND` or `OR`.
      * This parameter can be used only when the `q` query string parameter is specified. */
    default_operator?: QueryDslOperator;
    /** The field to use as default where no field prefix is given in the query string.
      * This parameter can be used only when the `q` query string parameter is specified. */
    df?: string;
    /** The type of index that wildcard patterns can match.
      * If the request can target data streams, this argument determines whether wildcard expressions match hidden data streams.
      * It supports comma-separated values, such as `open,hidden`. */
    expand_wildcards?: ExpandWildcards;
    /** Skips the specified number of documents. */
    from?: long;
    /** If `false`, the request returns an error if it targets a missing or closed index. */
    ignore_unavailable?: boolean;
    /** If `true`, format-based query failures (such as providing text to a numeric field) in the query string will be ignored.
      * This parameter can be used only when the `q` query string parameter is specified. */
    lenient?: boolean;
    /** The node or shard the operation should be performed on.
      * It is random by default. */
    preference?: string;
    /** If `true`, Elasticsearch refreshes all shards involved in the delete by query after the request completes.
      * This is different than the delete API's `refresh` parameter, which causes just the shard that received the delete request to be refreshed.
      * Unlike the delete API, it does not support `wait_for`. */
    refresh?: boolean;
    /** If `true`, the request cache is used for this request.
      * Defaults to the index-level setting. */
    request_cache?: boolean;
    /** The throttle for this request in sub-requests per second. */
    requests_per_second?: float;
    /** A custom value used to route operations to a specific shard. */
    routing?: Routing;
    /** A query in the Lucene query string syntax. */
    q?: string;
    /** The period to retain the search context for scrolling. */
    scroll?: Duration;
    /** The size of the scroll request that powers the operation. */
    scroll_size?: long;
    /** The explicit timeout for each search request.
      * It defaults to no timeout. */
    search_timeout?: Duration;
    /** The type of the search operation.
      * Available options include `query_then_fetch` and `dfs_query_then_fetch`. */
    search_type?: SearchType;
    /** The number of slices this task should be divided into. */
    slices?: Slices;
    /** A comma-separated list of `<field>:<direction>` pairs. */
    sort?: string[];
    /** The specific `tag` of the request for logging and statistical purposes. */
    stats?: string[];
    /** The maximum number of documents to collect for each shard.
      * If a query reaches this limit, Elasticsearch terminates the query early.
      * Elasticsearch collects documents before sorting.
      *
      * Use with caution.
      * Elasticsearch applies this parameter to each shard handling the request.
      * When possible, let Elasticsearch perform early termination automatically.
      * Avoid specifying this parameter for requests that target data streams with backing indices across multiple data tiers. */
    terminate_after?: long;
    /** The period each deletion request waits for active shards. */
    timeout?: Duration;
    /** If `true`, returns the document version as part of a hit. */
    version?: boolean;
    /** The number of shard copies that must be active before proceeding with the operation.
      * Set to `all` or any positive integer up to the total number of shards in the index (`number_of_replicas+1`).
      * The `timeout` value controls how long each write request waits for unavailable shards to become available. */
    wait_for_active_shards?: WaitForActiveShards;
    /** If `true`, the request blocks until the operation is complete.
      * If `false`, Elasticsearch performs some preflight checks, launches the request, and returns a task you can use to cancel or get the status of the task. Elasticsearch creates a record of this task as a document at `.tasks/task/${taskId}`. When you are done with a task, you should delete the task document so Elasticsearch can reclaim the space. */
    wait_for_completion?: boolean;
    /** The maximum number of documents to delete. */
    max_docs?: long;
    /** The documents to delete specified with Query DSL. */
    query?: QueryDslQueryContainer;
    /** Slice the request manually using the provided slice ID and total number of slices. */
    slice?: SlicedScroll;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
        allow_no_indices?: never;
        analyzer?: never;
        analyze_wildcard?: never;
        conflicts?: never;
        default_operator?: never;
        df?: never;
        expand_wildcards?: never;
        from?: never;
        ignore_unavailable?: never;
        lenient?: never;
        preference?: never;
        refresh?: never;
        request_cache?: never;
        requests_per_second?: never;
        routing?: never;
        q?: never;
        scroll?: never;
        scroll_size?: never;
        search_timeout?: never;
        search_type?: never;
        slices?: never;
        sort?: never;
        stats?: never;
        terminate_after?: never;
        timeout?: never;
        version?: never;
        wait_for_active_shards?: never;
        wait_for_completion?: never;
        max_docs?: never;
        query?: never;
        slice?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
        allow_no_indices?: never;
        analyzer?: never;
        analyze_wildcard?: never;
        conflicts?: never;
        default_operator?: never;
        df?: never;
        expand_wildcards?: never;
        from?: never;
        ignore_unavailable?: never;
        lenient?: never;
        preference?: never;
        refresh?: never;
        request_cache?: never;
        requests_per_second?: never;
        routing?: never;
        q?: never;
        scroll?: never;
        scroll_size?: never;
        search_timeout?: never;
        search_type?: never;
        slices?: never;
        sort?: never;
        stats?: never;
        terminate_after?: never;
        timeout?: never;
        version?: never;
        wait_for_active_shards?: never;
        wait_for_completion?: never;
        max_docs?: never;
        query?: never;
        slice?: never;
    };
}
export interface DeleteByQueryResponse {
    /** The number of scroll responses pulled back by the delete by query. */
    batches?: long;
    /** The number of documents that were successfully deleted. */
    deleted?: long;
    /** An array of failures if there were any unrecoverable errors during the process.
      * If this array is not empty, the request ended abnormally because of those failures.
      * Delete by query is implemented using batches and any failures cause the entire process to end but all failures in the current batch are collected into the array.
      * You can use the `conflicts` option to prevent reindex from ending on version conflicts. */
    failures?: BulkIndexByScrollFailure[];
    /** This field is always equal to zero for delete by query.
      * It exists only so that delete by query, update by query, and reindex APIs return responses with the same structure. */
    noops?: long;
    /** The number of requests per second effectively run during the delete by query. */
    requests_per_second?: float;
    /** The number of retries attempted by delete by query.
      * `bulk` is the number of bulk actions retried.
      * `search` is the number of search actions retried. */
    retries?: Retries;
    slice_id?: integer;
    task?: TaskId;
    throttled?: Duration;
    /** The number of milliseconds the request slept to conform to `requests_per_second`. */
    throttled_millis?: DurationValue<UnitMillis>;
    throttled_until?: Duration;
    /** This field should always be equal to zero in a `_delete_by_query` response.
      * It has meaning only when using the task API, where it indicates the next time (in milliseconds since epoch) a throttled request will be run again in order to conform to `requests_per_second`. */
    throttled_until_millis?: DurationValue<UnitMillis>;
    /** If `true`, some requests run during the delete by query operation timed out. */
    timed_out?: boolean;
    /** The number of milliseconds from start to end of the whole operation. */
    took?: DurationValue<UnitMillis>;
    /** The number of documents that were successfully processed. */
    total?: long;
    /** The number of version conflicts that the delete by query hit. */
    version_conflicts?: long;
}
export interface DeleteByQueryRethrottleRequest extends RequestBase {
    /** The ID for the task. */
    task_id: TaskId;
    /** The throttle for this request in sub-requests per second.
      * To disable throttling, set it to `-1`. */
    requests_per_second?: float;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        task_id?: never;
        requests_per_second?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        task_id?: never;
        requests_per_second?: never;
    };
}
export type DeleteByQueryRethrottleResponse = TasksTaskListResponseBase;
export interface DeleteScriptRequest extends RequestBase {
    /** The identifier for the stored script or search template. */
    id: Id;
    /** The period to wait for a connection to the master node.
      * If no response is received before the timeout expires, the request fails and returns an error.
      * It can also be set to `-1` to indicate that the request should never timeout. */
    master_timeout?: Duration;
    /** The period to wait for a response.
      * If no response is received before the timeout expires, the request fails and returns an error.
      * It can also be set to `-1` to indicate that the request should never timeout. */
    timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        id?: never;
        master_timeout?: never;
        timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        id?: never;
        master_timeout?: never;
        timeout?: never;
    };
}
export type DeleteScriptResponse = AcknowledgedResponseBase;
export interface ExistsRequest extends RequestBase {
    /** A unique document identifier. */
    id: Id;
    /** A comma-separated list of data streams, indices, and aliases.
      * It supports wildcards (`*`). */
    index: IndexName;
    /** The node or shard the operation should be performed on.
      * By default, the operation is randomized between the shard replicas.
      *
      * If it is set to `_local`, the operation will prefer to be run on a local allocated shard when possible.
      * If it is set to a custom value, the value is used to guarantee that the same shards will be used for the same custom value.
      * This can help with "jumping values" when hitting different shards in different refresh states.
      * A sample value can be something like the web session ID or the user name. */
    preference?: string;
    /** If `true`, the request is real-time as opposed to near-real-time. */
    realtime?: boolean;
    /** If `true`, the request refreshes the relevant shards before retrieving the document.
      * Setting it to `true` should be done after careful thought and verification that this does not cause a heavy load on the system (and slow down indexing). */
    refresh?: boolean;
    /** A custom value used to route operations to a specific shard. */
    routing?: Routing;
    /** Indicates whether to return the `_source` field (`true` or `false`) or lists the fields to return. */
    _source?: SearchSourceConfigParam;
    /** A comma-separated list of source fields to exclude from the response.
      * You can also use this parameter to exclude fields from the subset specified in `_source_includes` query parameter.
      * If the `_source` parameter is `false`, this parameter is ignored. */
    _source_excludes?: Fields;
    /** A comma-separated list of source fields to include in the response.
      * If this parameter is specified, only these source fields are returned.
      * You can exclude fields from this subset using the `_source_excludes` query parameter.
      * If the `_source` parameter is `false`, this parameter is ignored. */
    _source_includes?: Fields;
    /** A comma-separated list of stored fields to return as part of a hit.
      * If no fields are specified, no stored fields are included in the response.
      * If this field is specified, the `_source` parameter defaults to `false`. */
    stored_fields?: Fields;
    /** Explicit version number for concurrency control.
      * The specified version must match the current version of the document for the request to succeed. */
    version?: VersionNumber;
    /** The version type. */
    version_type?: VersionType;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        id?: never;
        index?: never;
        preference?: never;
        realtime?: never;
        refresh?: never;
        routing?: never;
        _source?: never;
        _source_excludes?: never;
        _source_includes?: never;
        stored_fields?: never;
        version?: never;
        version_type?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        id?: never;
        index?: never;
        preference?: never;
        realtime?: never;
        refresh?: never;
        routing?: never;
        _source?: never;
        _source_excludes?: never;
        _source_includes?: never;
        stored_fields?: never;
        version?: never;
        version_type?: never;
    };
}
export type ExistsResponse = boolean;
export interface ExistsSourceRequest extends RequestBase {
    /** A unique identifier for the document. */
    id: Id;
    /** A comma-separated list of data streams, indices, and aliases.
      * It supports wildcards (`*`). */
    index: IndexName;
    /** The node or shard the operation should be performed on.
      * By default, the operation is randomized between the shard replicas. */
    preference?: string;
    /** If `true`, the request is real-time as opposed to near-real-time. */
    realtime?: boolean;
    /** If `true`, the request refreshes the relevant shards before retrieving the document.
      * Setting it to `true` should be done after careful thought and verification that this does not cause a heavy load on the system (and slow down indexing). */
    refresh?: boolean;
    /** A custom value used to route operations to a specific shard. */
    routing?: Routing;
    /** Indicates whether to return the `_source` field (`true` or `false`) or lists the fields to return. */
    _source?: SearchSourceConfigParam;
    /** A comma-separated list of source fields to exclude in the response. */
    _source_excludes?: Fields;
    /** A comma-separated list of source fields to include in the response. */
    _source_includes?: Fields;
    /** The version number for concurrency control.
      * It must match the current version of the document for the request to succeed. */
    version?: VersionNumber;
    /** The version type. */
    version_type?: VersionType;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        id?: never;
        index?: never;
        preference?: never;
        realtime?: never;
        refresh?: never;
        routing?: never;
        _source?: never;
        _source_excludes?: never;
        _source_includes?: never;
        version?: never;
        version_type?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        id?: never;
        index?: never;
        preference?: never;
        realtime?: never;
        refresh?: never;
        routing?: never;
        _source?: never;
        _source_excludes?: never;
        _source_includes?: never;
        version?: never;
        version_type?: never;
    };
}
export type ExistsSourceResponse = boolean;
export interface ExplainExplanation {
    description: string;
    details: ExplainExplanationDetail[];
    value: float;
}
export interface ExplainExplanationDetail {
    description: string;
    details?: ExplainExplanationDetail[];
    value: float;
}
export interface ExplainRequest extends RequestBase {
    /** The document identifier. */
    id: Id;
    /** Index names that are used to limit the request.
      * Only a single index name can be provided to this parameter. */
    index: IndexName;
    /** The analyzer to use for the query string.
      * This parameter can be used only when the `q` query string parameter is specified. */
    analyzer?: string;
    /** If `true`, wildcard and prefix queries are analyzed.
      * This parameter can be used only when the `q` query string parameter is specified. */
    analyze_wildcard?: boolean;
    /** The default operator for query string query: `AND` or `OR`.
      * This parameter can be used only when the `q` query string parameter is specified. */
    default_operator?: QueryDslOperator;
    /** The field to use as default where no field prefix is given in the query string.
      * This parameter can be used only when the `q` query string parameter is specified. */
    df?: string;
    /** If `true`, format-based query failures (such as providing text to a numeric field) in the query string will be ignored.
      * This parameter can be used only when the `q` query string parameter is specified. */
    lenient?: boolean;
    /** The node or shard the operation should be performed on.
      * It is random by default. */
    preference?: string;
    /** A custom value used to route operations to a specific shard. */
    routing?: Routing;
    /** `True` or `false` to return the `_source` field or not or a list of fields to return. */
    _source?: SearchSourceConfigParam;
    /** A comma-separated list of source fields to exclude from the response.
      * You can also use this parameter to exclude fields from the subset specified in `_source_includes` query parameter.
      * If the `_source` parameter is `false`, this parameter is ignored. */
    _source_excludes?: Fields;
    /** A comma-separated list of source fields to include in the response.
      * If this parameter is specified, only these source fields are returned.
      * You can exclude fields from this subset using the `_source_excludes` query parameter.
      * If the `_source` parameter is `false`, this parameter is ignored. */
    _source_includes?: Fields;
    /** A comma-separated list of stored fields to return in the response. */
    stored_fields?: Fields;
    /** The query in the Lucene query string syntax. */
    q?: string;
    /** Defines the search definition using the Query DSL. */
    query?: QueryDslQueryContainer;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        id?: never;
        index?: never;
        analyzer?: never;
        analyze_wildcard?: never;
        default_operator?: never;
        df?: never;
        lenient?: never;
        preference?: never;
        routing?: never;
        _source?: never;
        _source_excludes?: never;
        _source_includes?: never;
        stored_fields?: never;
        q?: never;
        query?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        id?: never;
        index?: never;
        analyzer?: never;
        analyze_wildcard?: never;
        default_operator?: never;
        df?: never;
        lenient?: never;
        preference?: never;
        routing?: never;
        _source?: never;
        _source_excludes?: never;
        _source_includes?: never;
        stored_fields?: never;
        q?: never;
        query?: never;
    };
}
export interface ExplainResponse<TDocument = unknown> {
    _index: IndexName;
    _id: Id;
    matched: boolean;
    explanation?: ExplainExplanationDetail;
    get?: InlineGet<TDocument>;
}
export interface FieldCapsFieldCapability {
    /** Whether this field can be aggregated on all indices. */
    aggregatable: boolean;
    /** The list of indices where this field has the same type family, or null if all indices have the same type family for the field. */
    indices?: Indices;
    /** Merged metadata across all indices as a map of string keys to arrays of values. A value length of 1 indicates that all indices had the same value for this key, while a length of 2 or more indicates that not all indices had the same value for this key. */
    meta?: Metadata;
    /** The list of indices where this field is not aggregatable, or null if all indices have the same definition for the field. */
    non_aggregatable_indices?: Indices;
    /** The list of indices where this field is not searchable, or null if all indices have the same definition for the field. */
    non_searchable_indices?: Indices;
    /** Whether this field is indexed for search on all indices. */
    searchable: boolean;
    type: string;
    /** Whether this field is registered as a metadata field. */
    metadata_field?: boolean;
    /** Whether this field is used as a time series dimension.
      * @experimental */
    time_series_dimension?: boolean;
    /** Contains metric type if this fields is used as a time series
      * metrics, absent if the field is not used as metric.
      * @experimental */
    time_series_metric?: MappingTimeSeriesMetricType;
    /** If this list is present in response then some indices have the
      * field marked as a dimension and other indices, the ones in this list, do not.
      * @experimental */
    non_dimension_indices?: IndexName[];
    /** The list of indices where this field is present if these indices
      * don’t have the same `time_series_metric` value for this field.
      * @experimental */
    metric_conflicts_indices?: IndexName[];
}
export interface FieldCapsRequest extends RequestBase {
    /** A comma-separated list of data streams, indices, and aliases used to limit the request. Supports wildcards (*). To target all data streams and indices, omit this parameter or use * or _all. */
    index?: Indices;
    /** If false, the request returns an error if any wildcard expression, index alias,
      * or `_all` value targets only missing or closed indices. This behavior applies even if the request targets other open indices. For example, a request
      * targeting `foo*,bar*` returns an error if an index starts with foo but no index starts with bar. */
    allow_no_indices?: boolean;
    /** The type of index that wildcard patterns can match. If the request can target data streams, this argument determines whether wildcard expressions match hidden data streams. Supports comma-separated values, such as `open,hidden`. */
    expand_wildcards?: ExpandWildcards;
    /** If `true`, missing or closed indices are not included in the response. */
    ignore_unavailable?: boolean;
    /** If true, unmapped fields are included in the response. */
    include_unmapped?: boolean;
    /** A comma-separated list of filters to apply to the response. */
    filters?: string;
    /** A comma-separated list of field types to include.
      * Any fields that do not match one of these types will be excluded from the results.
      * It defaults to empty, meaning that all field types are returned. */
    types?: string[];
    /** If false, empty fields are not included in the response. */
    include_empty_fields?: boolean;
    /** A list of fields to retrieve capabilities for. Wildcard (`*`) expressions are supported. */
    fields?: Fields;
    /** Filter indices if the provided query rewrites to `match_none` on every shard.
      *
      * IMPORTANT: The filtering is done on a best-effort basis, it uses index statistics and mappings to rewrite queries to `match_none` instead of fully running the request.
      * For instance a range query over a date field can rewrite to `match_none` if all documents within a shard (including deleted documents) are outside of the provided range.
      * However, not all queries can rewrite to `match_none` so this API may return an index even if the provided filter matches no document. */
    index_filter?: QueryDslQueryContainer;
    /** Define ad-hoc runtime fields in the request similar to the way it is done in search requests.
      * These fields exist only as part of the query and take precedence over fields defined with the same name in the index mappings. */
    runtime_mappings?: MappingRuntimeFields;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
        allow_no_indices?: never;
        expand_wildcards?: never;
        ignore_unavailable?: never;
        include_unmapped?: never;
        filters?: never;
        types?: never;
        include_empty_fields?: never;
        fields?: never;
        index_filter?: never;
        runtime_mappings?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
        allow_no_indices?: never;
        expand_wildcards?: never;
        ignore_unavailable?: never;
        include_unmapped?: never;
        filters?: never;
        types?: never;
        include_empty_fields?: never;
        fields?: never;
        index_filter?: never;
        runtime_mappings?: never;
    };
}
export interface FieldCapsResponse {
    /** The list of indices where this field has the same type family, or null if all indices have the same type family for the field. */
    indices: Indices;
    fields: Record<Field, Record<string, FieldCapsFieldCapability>>;
}
export interface GetGetResult<TDocument = unknown> {
    /** The name of the index the document belongs to. */
    _index: IndexName;
    /** If the `stored_fields` parameter is set to `true` and `found` is `true`, it contains the document fields stored in the index. */
    fields?: Record<string, any>;
    _ignored?: string[];
    /** Indicates whether the document exists. */
    found: boolean;
    /** The unique identifier for the document. */
    _id: Id;
    /** The primary term assigned to the document for the indexing operation. */
    _primary_term?: long;
    /** The explicit routing, if set. */
    _routing?: string;
    /** The sequence number assigned to the document for the indexing operation.
      * Sequence numbers are used to ensure an older version of a document doesn't overwrite a newer version. */
    _seq_no?: SequenceNumber;
    /** If `found` is `true`, it contains the document data formatted in JSON.
      * If the `_source` parameter is set to `false` or the `stored_fields` parameter is set to `true`, it is excluded. */
    _source?: TDocument;
    /** The document version, which is ncremented each time the document is updated. */
    _version?: VersionNumber;
}
export interface GetRequest extends RequestBase {
    /** A unique document identifier. */
    id: Id;
    /** The name of the index that contains the document. */
    index: IndexName;
    /** Indicates whether the request forces synthetic `_source`.
      * Use this parameter to test if the mapping supports synthetic `_source` and to get a sense of the worst case performance.
      * Fetches with this parameter enabled will be slower than enabling synthetic source natively in the index. */
    force_synthetic_source?: boolean;
    /** The node or shard the operation should be performed on.
      * By default, the operation is randomized between the shard replicas.
      *
      * If it is set to `_local`, the operation will prefer to be run on a local allocated shard when possible.
      * If it is set to a custom value, the value is used to guarantee that the same shards will be used for the same custom value.
      * This can help with "jumping values" when hitting different shards in different refresh states.
      * A sample value can be something like the web session ID or the user name. */
    preference?: string;
    /** If `true`, the request is real-time as opposed to near-real-time. */
    realtime?: boolean;
    /** If `true`, the request refreshes the relevant shards before retrieving the document.
      * Setting it to `true` should be done after careful thought and verification that this does not cause a heavy load on the system (and slow down indexing). */
    refresh?: boolean;
    /** A custom value used to route operations to a specific shard. */
    routing?: Routing;
    /** Indicates whether to return the `_source` field (`true` or `false`) or lists the fields to return. */
    _source?: SearchSourceConfigParam;
    /** A comma-separated list of source fields to exclude from the response.
      * You can also use this parameter to exclude fields from the subset specified in `_source_includes` query parameter.
      * If the `_source` parameter is `false`, this parameter is ignored. */
    _source_excludes?: Fields;
    /** A comma-separated list of source fields to include in the response.
      * If this parameter is specified, only these source fields are returned.
      * You can exclude fields from this subset using the `_source_excludes` query parameter.
      * If the `_source` parameter is `false`, this parameter is ignored. */
    _source_includes?: Fields;
    /** A comma-separated list of stored fields to return as part of a hit.
      * If no fields are specified, no stored fields are included in the response.
      * If this field is specified, the `_source` parameter defaults to `false`.
      * Only leaf fields can be retrieved with the `stored_fields` option.
      * Object fields can't be returned; if specified, the request fails. */
    stored_fields?: Fields;
    /** The version number for concurrency control.
      * It must match the current version of the document for the request to succeed. */
    version?: VersionNumber;
    /** The version type. */
    version_type?: VersionType;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        id?: never;
        index?: never;
        force_synthetic_source?: never;
        preference?: never;
        realtime?: never;
        refresh?: never;
        routing?: never;
        _source?: never;
        _source_excludes?: never;
        _source_includes?: never;
        stored_fields?: never;
        version?: never;
        version_type?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        id?: never;
        index?: never;
        force_synthetic_source?: never;
        preference?: never;
        realtime?: never;
        refresh?: never;
        routing?: never;
        _source?: never;
        _source_excludes?: never;
        _source_includes?: never;
        stored_fields?: never;
        version?: never;
        version_type?: never;
    };
}
export type GetResponse<TDocument = unknown> = GetGetResult<TDocument>;
export interface GetScriptRequest extends RequestBase {
    /** The identifier for the stored script or search template. */
    id: Id;
    /** The period to wait for the master node.
      * If the master node is not available before the timeout expires, the request fails and returns an error.
      * It can also be set to `-1` to indicate that the request should never timeout. */
    master_timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        id?: never;
        master_timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        id?: never;
        master_timeout?: never;
    };
}
export interface GetScriptResponse {
    _id: Id;
    found: boolean;
    script?: StoredScript;
}
export interface GetScriptContextContext {
    methods: GetScriptContextContextMethod[];
    name: Name;
}
export interface GetScriptContextContextMethod {
    name: Name;
    return_type: string;
    params: GetScriptContextContextMethodParam[];
}
export interface GetScriptContextContextMethodParam {
    name: Name;
    type: string;
}
export interface GetScriptContextRequest extends RequestBase {
    /** All values in `body` will be added to the request body. */
    body?: string | {
        [key: string]: any;
    };
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    };
}
export interface GetScriptContextResponse {
    contexts: GetScriptContextContext[];
}
export interface GetScriptLanguagesLanguageContext {
    contexts: string[];
    language: ScriptLanguage;
}
export interface GetScriptLanguagesRequest extends RequestBase {
    /** All values in `body` will be added to the request body. */
    body?: string | {
        [key: string]: any;
    };
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    };
}
export interface GetScriptLanguagesResponse {
    language_contexts: GetScriptLanguagesLanguageContext[];
    types_allowed: string[];
}
export interface GetSourceRequest extends RequestBase {
    /** A unique document identifier. */
    id: Id;
    /** The name of the index that contains the document. */
    index: IndexName;
    /** The node or shard the operation should be performed on.
      * By default, the operation is randomized between the shard replicas. */
    preference?: string;
    /** If `true`, the request is real-time as opposed to near-real-time. */
    realtime?: boolean;
    /** If `true`, the request refreshes the relevant shards before retrieving the document.
      * Setting it to `true` should be done after careful thought and verification that this does not cause a heavy load on the system (and slow down indexing). */
    refresh?: boolean;
    /** A custom value used to route operations to a specific shard. */
    routing?: Routing;
    /** Indicates whether to return the `_source` field (`true` or `false`) or lists the fields to return. */
    _source?: SearchSourceConfigParam;
    /** A comma-separated list of source fields to exclude in the response. */
    _source_excludes?: Fields;
    /** A comma-separated list of source fields to include in the response. */
    _source_includes?: Fields;
    /** The version number for concurrency control.
      * It must match the current version of the document for the request to succeed. */
    version?: VersionNumber;
    /** The version type. */
    version_type?: VersionType;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        id?: never;
        index?: never;
        preference?: never;
        realtime?: never;
        refresh?: never;
        routing?: never;
        _source?: never;
        _source_excludes?: never;
        _source_includes?: never;
        version?: never;
        version_type?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        id?: never;
        index?: never;
        preference?: never;
        realtime?: never;
        refresh?: never;
        routing?: never;
        _source?: never;
        _source_excludes?: never;
        _source_includes?: never;
        version?: never;
        version_type?: never;
    };
}
export type GetSourceResponse<TDocument = unknown> = TDocument;
export interface HealthReportBaseIndicator {
    status: HealthReportIndicatorHealthStatus;
    symptom: string;
    impacts?: HealthReportImpact[];
    diagnosis?: HealthReportDiagnosis[];
}
export interface HealthReportDataStreamLifecycleDetails {
    stagnating_backing_indices_count: integer;
    total_backing_indices_in_error: integer;
    stagnating_backing_indices?: HealthReportStagnatingBackingIndices[];
}
export interface HealthReportDataStreamLifecycleIndicator extends HealthReportBaseIndicator {
    details?: HealthReportDataStreamLifecycleDetails;
}
export interface HealthReportDiagnosis {
    id: string;
    action: string;
    affected_resources: HealthReportDiagnosisAffectedResources;
    cause: string;
    help_url: string;
}
export interface HealthReportDiagnosisAffectedResources {
    indices?: Indices;
    nodes?: HealthReportIndicatorNode[];
    slm_policies?: string[];
    feature_states?: string[];
    snapshot_repositories?: string[];
}
export interface HealthReportDiskIndicator extends HealthReportBaseIndicator {
    details?: HealthReportDiskIndicatorDetails;
}
export interface HealthReportDiskIndicatorDetails {
    indices_with_readonly_block: long;
    nodes_with_enough_disk_space: long;
    nodes_over_high_watermark: long;
    nodes_over_flood_stage_watermark: long;
    nodes_with_unknown_disk_status: long;
}
export interface HealthReportFileSettingsIndicator extends HealthReportBaseIndicator {
    details?: HealthReportFileSettingsIndicatorDetails;
}
export interface HealthReportFileSettingsIndicatorDetails {
    failure_streak: long;
    most_recent_failure: string;
}
export interface HealthReportIlmIndicator extends HealthReportBaseIndicator {
    details?: HealthReportIlmIndicatorDetails;
}
export interface HealthReportIlmIndicatorDetails {
    ilm_status: LifecycleOperationMode;
    policies: long;
    stagnating_indices: integer;
}
export interface HealthReportImpact {
    description: string;
    id: string;
    impact_areas: HealthReportImpactArea[];
    severity: integer;
}
export type HealthReportImpactArea = 'search' | 'ingest' | 'backup' | 'deployment_management';
export type HealthReportIndicatorHealthStatus = 'green' | 'yellow' | 'red' | 'unknown' | 'unavailable';
export interface HealthReportIndicatorNode {
    name: string | null;
    node_id: string | null;
}
export interface HealthReportIndicators {
    master_is_stable?: HealthReportMasterIsStableIndicator;
    shards_availability?: HealthReportShardsAvailabilityIndicator;
    disk?: HealthReportDiskIndicator;
    repository_integrity?: HealthReportRepositoryIntegrityIndicator;
    data_stream_lifecycle?: HealthReportDataStreamLifecycleIndicator;
    ilm?: HealthReportIlmIndicator;
    slm?: HealthReportSlmIndicator;
    shards_capacity?: HealthReportShardsCapacityIndicator;
    file_settings?: HealthReportFileSettingsIndicator;
}
export interface HealthReportMasterIsStableIndicator extends HealthReportBaseIndicator {
    details?: HealthReportMasterIsStableIndicatorDetails;
}
export interface HealthReportMasterIsStableIndicatorClusterFormationNode {
    name?: string;
    node_id: string;
    cluster_formation_message: string;
}
export interface HealthReportMasterIsStableIndicatorDetails {
    current_master: HealthReportIndicatorNode;
    recent_masters: HealthReportIndicatorNode[];
    exception_fetching_history?: HealthReportMasterIsStableIndicatorExceptionFetchingHistory;
    cluster_formation?: HealthReportMasterIsStableIndicatorClusterFormationNode[];
}
export interface HealthReportMasterIsStableIndicatorExceptionFetchingHistory {
    message: string;
    stack_trace: string;
}
export interface HealthReportRepositoryIntegrityIndicator extends HealthReportBaseIndicator {
    details?: HealthReportRepositoryIntegrityIndicatorDetails;
}
export interface HealthReportRepositoryIntegrityIndicatorDetails {
    total_repositories?: long;
    corrupted_repositories?: long;
    corrupted?: string[];
}
export interface HealthReportRequest extends RequestBase {
    /** A feature of the cluster, as returned by the top-level health report API. */
    feature?: string | string[];
    /** Explicit operation timeout. */
    timeout?: Duration;
    /** Opt-in for more information about the health of the system. */
    verbose?: boolean;
    /** Limit the number of affected resources the health report API returns. */
    size?: integer;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        feature?: never;
        timeout?: never;
        verbose?: never;
        size?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        feature?: never;
        timeout?: never;
        verbose?: never;
        size?: never;
    };
}
export interface HealthReportResponse {
    cluster_name: string;
    indicators: HealthReportIndicators;
    status?: HealthReportIndicatorHealthStatus;
}
export interface HealthReportShardsAvailabilityIndicator extends HealthReportBaseIndicator {
    details?: HealthReportShardsAvailabilityIndicatorDetails;
}
export interface HealthReportShardsAvailabilityIndicatorDetails {
    creating_primaries: long;
    creating_replicas: long;
    initializing_primaries: long;
    initializing_replicas: long;
    restarting_primaries: long;
    restarting_replicas: long;
    started_primaries: long;
    started_replicas: long;
    unassigned_primaries: long;
    unassigned_replicas: long;
}
export interface HealthReportShardsCapacityIndicator extends HealthReportBaseIndicator {
    details?: HealthReportShardsCapacityIndicatorDetails;
}
export interface HealthReportShardsCapacityIndicatorDetails {
    data: HealthReportShardsCapacityIndicatorTierDetail;
    frozen: HealthReportShardsCapacityIndicatorTierDetail;
}
export interface HealthReportShardsCapacityIndicatorTierDetail {
    max_shards_in_cluster: integer;
    current_used_shards?: integer;
}
export interface HealthReportSlmIndicator extends HealthReportBaseIndicator {
    details?: HealthReportSlmIndicatorDetails;
}
export interface HealthReportSlmIndicatorDetails {
    slm_status: LifecycleOperationMode;
    policies: long;
    unhealthy_policies?: HealthReportSlmIndicatorUnhealthyPolicies;
}
export interface HealthReportSlmIndicatorUnhealthyPolicies {
    count: long;
    invocations_since_last_success?: Record<string, long>;
}
export interface HealthReportStagnatingBackingIndices {
    index_name: IndexName;
    first_occurrence_timestamp: long;
    retry_count: integer;
}
export interface IndexRequest<TDocument = unknown> extends RequestBase {
    /** A unique identifier for the document.
      * To automatically generate a document ID, use the `POST /<target>/_doc/` request format and omit this parameter. */
    id?: Id;
    /** The name of the data stream or index to target.
      * If the target doesn't exist and matches the name or wildcard (`*`) pattern of an index template with a `data_stream` definition, this request creates the data stream.
      * If the target doesn't exist and doesn't match a data stream template, this request creates the index.
      * You can check for existing targets with the resolve index API. */
    index: IndexName;
    /** Only perform the operation if the document has this primary term. */
    if_primary_term?: long;
    /** Only perform the operation if the document has this sequence number. */
    if_seq_no?: SequenceNumber;
    /** True or false if to include the document source in the error message in case of parsing errors. */
    include_source_on_error?: boolean;
    /** Set to `create` to only index the document if it does not already exist (put if absent).
      * If a document with the specified `_id` already exists, the indexing operation will fail.
      * The behavior is the same as using the `<index>/_create` endpoint.
      * If a document ID is specified, this paramater defaults to `index`.
      * Otherwise, it defaults to `create`.
      * If the request targets a data stream, an `op_type` of `create` is required. */
    op_type?: OpType;
    /** The ID of the pipeline to use to preprocess incoming documents.
      * If the index has a default ingest pipeline specified, then setting the value to `_none` disables the default ingest pipeline for this request.
      * If a final pipeline is configured it will always run, regardless of the value of this parameter. */
    pipeline?: string;
    /** If `true`, Elasticsearch refreshes the affected shards to make this operation visible to search.
      * If `wait_for`, it waits for a refresh to make this operation visible to search.
      * If `false`, it does nothing with refreshes. */
    refresh?: Refresh;
    /** A custom value that is used to route operations to a specific shard. */
    routing?: Routing;
    /** The period the request waits for the following operations: automatic index creation, dynamic mapping updates, waiting for active shards.
      *
      * This parameter is useful for situations where the primary shard assigned to perform the operation might not be available when the operation runs.
      * Some reasons for this might be that the primary shard is currently recovering from a gateway or undergoing relocation.
      * By default, the operation will wait on the primary shard to become available for at least 1 minute before failing and responding with an error.
      * The actual wait time could be longer, particularly when multiple waits occur. */
    timeout?: Duration;
    /** An explicit version number for concurrency control.
      * It must be a non-negative long number. */
    version?: VersionNumber;
    /** The version type. */
    version_type?: VersionType;
    /** The number of shard copies that must be active before proceeding with the operation.
      * You can set it to `all` or any positive integer up to the total number of shards in the index (`number_of_replicas+1`).
      * The default value of `1` means it waits for each primary shard to be active. */
    wait_for_active_shards?: WaitForActiveShards;
    /** If `true`, the destination must be an index alias. */
    require_alias?: boolean;
    /** If `true`, the request's actions must target a data stream (existing or to be created). */
    require_data_stream?: boolean;
    document?: TDocument;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        id?: never;
        index?: never;
        if_primary_term?: never;
        if_seq_no?: never;
        include_source_on_error?: never;
        op_type?: never;
        pipeline?: never;
        refresh?: never;
        routing?: never;
        timeout?: never;
        version?: never;
        version_type?: never;
        wait_for_active_shards?: never;
        require_alias?: never;
        require_data_stream?: never;
        document?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        id?: never;
        index?: never;
        if_primary_term?: never;
        if_seq_no?: never;
        include_source_on_error?: never;
        op_type?: never;
        pipeline?: never;
        refresh?: never;
        routing?: never;
        timeout?: never;
        version?: never;
        version_type?: never;
        wait_for_active_shards?: never;
        require_alias?: never;
        require_data_stream?: never;
        document?: never;
    };
}
export type IndexResponse = WriteResponseBase;
export interface InfoRequest extends RequestBase {
    /** All values in `body` will be added to the request body. */
    body?: string | {
        [key: string]: any;
    };
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    };
}
export interface InfoResponse {
    /** The responding cluster's name. */
    cluster_name: Name;
    cluster_uuid: Uuid;
    /** The responding node's name. */
    name: Name;
    tagline: string;
    /** The running version of Elasticsearch. */
    version: ElasticsearchVersionInfo;
}
export interface MgetMultiGetError {
    error: ErrorCause;
    _id: Id;
    _index: IndexName;
}
export interface MgetOperation {
    /** The unique document ID. */
    _id: Id;
    /** The index that contains the document. */
    _index?: IndexName;
    /** The key for the primary shard the document resides on. Required if routing is used during indexing. */
    routing?: Routing;
    /** If `false`, excludes all _source fields. */
    _source?: SearchSourceConfig;
    /** The stored fields you want to retrieve. */
    stored_fields?: Fields;
    version?: VersionNumber;
    version_type?: VersionType;
}
export interface MgetRequest extends RequestBase {
    /** Name of the index to retrieve documents from when `ids` are specified, or when a document in the `docs` array does not specify an index. */
    index?: IndexName;
    /** Should this request force synthetic _source?
      * Use this to test if the mapping supports synthetic _source and to get a sense of the worst case performance.
      * Fetches with this enabled will be slower the enabling synthetic source natively in the index. */
    force_synthetic_source?: boolean;
    /** Specifies the node or shard the operation should be performed on. Random by default. */
    preference?: string;
    /** If `true`, the request is real-time as opposed to near-real-time. */
    realtime?: boolean;
    /** If `true`, the request refreshes relevant shards before retrieving documents. */
    refresh?: boolean;
    /** Custom value used to route operations to a specific shard. */
    routing?: Routing;
    /** True or false to return the `_source` field or not, or a list of fields to return. */
    _source?: SearchSourceConfigParam;
    /** A comma-separated list of source fields to exclude from the response.
      * You can also use this parameter to exclude fields from the subset specified in `_source_includes` query parameter. */
    _source_excludes?: Fields;
    /** A comma-separated list of source fields to include in the response.
      * If this parameter is specified, only these source fields are returned. You can exclude fields from this subset using the `_source_excludes` query parameter.
      * If the `_source` parameter is `false`, this parameter is ignored. */
    _source_includes?: Fields;
    /** If `true`, retrieves the document fields stored in the index rather than the document `_source`. */
    stored_fields?: Fields;
    /** The documents you want to retrieve. Required if no index is specified in the request URI. */
    docs?: MgetOperation[];
    /** The IDs of the documents you want to retrieve. Allowed when the index is specified in the request URI. */
    ids?: Ids;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
        force_synthetic_source?: never;
        preference?: never;
        realtime?: never;
        refresh?: never;
        routing?: never;
        _source?: never;
        _source_excludes?: never;
        _source_includes?: never;
        stored_fields?: never;
        docs?: never;
        ids?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
        force_synthetic_source?: never;
        preference?: never;
        realtime?: never;
        refresh?: never;
        routing?: never;
        _source?: never;
        _source_excludes?: never;
        _source_includes?: never;
        stored_fields?: never;
        docs?: never;
        ids?: never;
    };
}
export interface MgetResponse<TDocument = unknown> {
    /** The response includes a docs array that contains the documents in the order specified in the request.
      * The structure of the returned documents is similar to that returned by the get API.
      * If there is a failure getting a particular document, the error is included in place of the document. */
    docs: MgetResponseItem<TDocument>[];
}
export type MgetResponseItem<TDocument = unknown> = GetGetResult<TDocument> | MgetMultiGetError;
export interface MsearchMultiSearchItem<TDocument = unknown> extends SearchResponseBody<TDocument> {
    status?: integer;
}
export interface MsearchMultiSearchResult<TDocument = unknown, TAggregations = Record<AggregateName, AggregationsAggregate>> {
    took: long;
    responses: MsearchResponseItem<TDocument>[];
}
export interface MsearchMultisearchHeader {
    allow_no_indices?: boolean;
    expand_wildcards?: ExpandWildcards;
    ignore_unavailable?: boolean;
    index?: Indices;
    preference?: string;
    request_cache?: boolean;
    routing?: Routing;
    search_type?: SearchType;
    ccs_minimize_roundtrips?: boolean;
    allow_partial_search_results?: boolean;
    ignore_throttled?: boolean;
}
export interface MsearchRequest extends RequestBase {
    /** Comma-separated list of data streams, indices, and index aliases to search. */
    index?: Indices;
    /** If false, the request returns an error if any wildcard expression, index alias, or _all value targets only missing or closed indices. This behavior applies even if the request targets other open indices. For example, a request targeting foo*,bar* returns an error if an index starts with foo but no index starts with bar. */
    allow_no_indices?: boolean;
    /** If true, network roundtrips between the coordinating node and remote clusters are minimized for cross-cluster search requests. */
    ccs_minimize_roundtrips?: boolean;
    /** Type of index that wildcard expressions can match. If the request can target data streams, this argument determines whether wildcard expressions match hidden data streams. */
    expand_wildcards?: ExpandWildcards;
    /** If true, concrete, expanded or aliased indices are ignored when frozen. */
    ignore_throttled?: boolean;
    /** If true, missing or closed indices are not included in the response. */
    ignore_unavailable?: boolean;
    /** Indicates whether hit.matched_queries should be rendered as a map that includes
      * the name of the matched query associated with its score (true)
      * or as an array containing the name of the matched queries (false)
      * This functionality reruns each named query on every hit in a search response.
      * Typically, this adds a small overhead to a request.
      * However, using computationally expensive named queries on a large number of hits may add significant overhead. */
    include_named_queries_score?: boolean;
    /** Maximum number of concurrent searches the multi search API can execute.
      * Defaults to `max(1, (# of data nodes * min(search thread pool size, 10)))`. */
    max_concurrent_searches?: integer;
    /** Maximum number of concurrent shard requests that each sub-search request executes per node. */
    max_concurrent_shard_requests?: integer;
    /** Defines a threshold that enforces a pre-filter roundtrip to prefilter search shards based on query rewriting if the number of shards the search request expands to exceeds the threshold. This filter roundtrip can limit the number of shards significantly if for instance a shard can not match any documents based on its rewrite method i.e., if date filters are mandatory to match but the shard bounds and the query are disjoint. */
    pre_filter_shard_size?: long;
    /** If true, hits.total are returned as an integer in the response. Defaults to false, which returns an object. */
    rest_total_hits_as_int?: boolean;
    /** Custom routing value used to route search operations to a specific shard. */
    routing?: Routing;
    /** Indicates whether global term and document frequencies should be used when scoring returned documents. */
    search_type?: SearchType;
    /** Specifies whether aggregation and suggester names should be prefixed by their respective types in the response. */
    typed_keys?: boolean;
    searches?: MsearchRequestItem[];
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
        allow_no_indices?: never;
        ccs_minimize_roundtrips?: never;
        expand_wildcards?: never;
        ignore_throttled?: never;
        ignore_unavailable?: never;
        include_named_queries_score?: never;
        max_concurrent_searches?: never;
        max_concurrent_shard_requests?: never;
        pre_filter_shard_size?: never;
        rest_total_hits_as_int?: never;
        routing?: never;
        search_type?: never;
        typed_keys?: never;
        searches?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
        allow_no_indices?: never;
        ccs_minimize_roundtrips?: never;
        expand_wildcards?: never;
        ignore_throttled?: never;
        ignore_unavailable?: never;
        include_named_queries_score?: never;
        max_concurrent_searches?: never;
        max_concurrent_shard_requests?: never;
        pre_filter_shard_size?: never;
        rest_total_hits_as_int?: never;
        routing?: never;
        search_type?: never;
        typed_keys?: never;
        searches?: never;
    };
}
export type MsearchRequestItem = MsearchMultisearchHeader | SearchSearchRequestBody;
export type MsearchResponse<TDocument = unknown, TAggregations = Record<AggregateName, AggregationsAggregate>> = MsearchMultiSearchResult<TDocument, TAggregations>;
export type MsearchResponseItem<TDocument = unknown> = MsearchMultiSearchItem<TDocument> | ErrorResponseBase;
export interface MsearchTemplateRequest extends RequestBase {
    /** A comma-separated list of data streams, indices, and aliases to search.
      * It supports wildcards (`*`).
      * To search all data streams and indices, omit this parameter or use `*`. */
    index?: Indices;
    /** If `true`, network round-trips are minimized for cross-cluster search requests. */
    ccs_minimize_roundtrips?: boolean;
    /** The maximum number of concurrent searches the API can run. */
    max_concurrent_searches?: long;
    /** The type of the search operation. */
    search_type?: SearchType;
    /** If `true`, the response returns `hits.total` as an integer.
      * If `false`, it returns `hits.total` as an object. */
    rest_total_hits_as_int?: boolean;
    /** If `true`, the response prefixes aggregation and suggester names with their respective types. */
    typed_keys?: boolean;
    search_templates?: MsearchTemplateRequestItem[];
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
        ccs_minimize_roundtrips?: never;
        max_concurrent_searches?: never;
        search_type?: never;
        rest_total_hits_as_int?: never;
        typed_keys?: never;
        search_templates?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
        ccs_minimize_roundtrips?: never;
        max_concurrent_searches?: never;
        search_type?: never;
        rest_total_hits_as_int?: never;
        typed_keys?: never;
        search_templates?: never;
    };
}
export type MsearchTemplateRequestItem = MsearchMultisearchHeader | MsearchTemplateTemplateConfig;
export type MsearchTemplateResponse<TDocument = unknown, TAggregations = Record<AggregateName, AggregationsAggregate>> = MsearchMultiSearchResult<TDocument, TAggregations>;
export interface MsearchTemplateTemplateConfig {
    /** If `true`, returns detailed information about score calculation as part of each hit. */
    explain?: boolean;
    /** The ID of the search template to use. If no `source` is specified,
      * this parameter is required. */
    id?: Id;
    /** Key-value pairs used to replace Mustache variables in the template.
      * The key is the variable name.
      * The value is the variable value. */
    params?: Record<string, any>;
    /** If `true`, the query execution is profiled. */
    profile?: boolean;
    /** An inline search template. Supports the same parameters as the search API's
      * request body. It also supports Mustache variables. If no `id` is specified, this
      * parameter is required. */
    source?: ScriptSource;
}
export interface MtermvectorsOperation {
    /** The ID of the document. */
    _id?: Id;
    /** The index of the document. */
    _index?: IndexName;
    /** An artificial document (a document not present in the index) for which you want to retrieve term vectors. */
    doc?: any;
    /** Comma-separated list or wildcard expressions of fields to include in the statistics.
      * Used as the default list unless a specific field list is provided in the `completion_fields` or `fielddata_fields` parameters. */
    fields?: Fields;
    /** If `true`, the response includes the document count, sum of document frequencies, and sum of total term frequencies. */
    field_statistics?: boolean;
    /** Filter terms based on their tf-idf scores. */
    filter?: TermvectorsFilter;
    /** If `true`, the response includes term offsets. */
    offsets?: boolean;
    /** If `true`, the response includes term payloads. */
    payloads?: boolean;
    /** If `true`, the response includes term positions. */
    positions?: boolean;
    /** Custom value used to route operations to a specific shard. */
    routing?: Routing;
    /** If true, the response includes term frequency and document frequency. */
    term_statistics?: boolean;
    /** If `true`, returns the document version as part of a hit. */
    version?: VersionNumber;
    /** Specific version type. */
    version_type?: VersionType;
}
export interface MtermvectorsRequest extends RequestBase {
    /** The name of the index that contains the documents. */
    index?: IndexName;
    /** A comma-separated list or wildcard expressions of fields to include in the statistics.
      * It is used as the default list unless a specific field list is provided in the `completion_fields` or `fielddata_fields` parameters. */
    fields?: Fields;
    /** If `true`, the response includes the document count, sum of document frequencies, and sum of total term frequencies. */
    field_statistics?: boolean;
    /** If `true`, the response includes term offsets. */
    offsets?: boolean;
    /** If `true`, the response includes term payloads. */
    payloads?: boolean;
    /** If `true`, the response includes term positions. */
    positions?: boolean;
    /** The node or shard the operation should be performed on.
      * It is random by default. */
    preference?: string;
    /** If true, the request is real-time as opposed to near-real-time. */
    realtime?: boolean;
    /** A custom value used to route operations to a specific shard. */
    routing?: Routing;
    /** If true, the response includes term frequency and document frequency. */
    term_statistics?: boolean;
    /** If `true`, returns the document version as part of a hit. */
    version?: VersionNumber;
    /** The version type. */
    version_type?: VersionType;
    /** An array of existing or artificial documents. */
    docs?: MtermvectorsOperation[];
    /** A simplified syntax to specify documents by their ID if they're in the same index. */
    ids?: Id[];
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
        fields?: never;
        field_statistics?: never;
        offsets?: never;
        payloads?: never;
        positions?: never;
        preference?: never;
        realtime?: never;
        routing?: never;
        term_statistics?: never;
        version?: never;
        version_type?: never;
        docs?: never;
        ids?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
        fields?: never;
        field_statistics?: never;
        offsets?: never;
        payloads?: never;
        positions?: never;
        preference?: never;
        realtime?: never;
        routing?: never;
        term_statistics?: never;
        version?: never;
        version_type?: never;
        docs?: never;
        ids?: never;
    };
}
export interface MtermvectorsResponse {
    docs: MtermvectorsTermVectorsResult[];
}
export interface MtermvectorsTermVectorsResult {
    _id?: Id;
    _index: IndexName;
    _version?: VersionNumber;
    took?: long;
    found?: boolean;
    term_vectors?: Record<Field, TermvectorsTermVector>;
    error?: ErrorCause;
}
export interface OpenPointInTimeRequest extends RequestBase {
    /** A comma-separated list of index names to open point in time; use `_all` or empty string to perform the operation on all indices */
    index: Indices;
    /** Extend the length of time that the point in time persists. */
    keep_alive: Duration;
    /** If `false`, the request returns an error if it targets a missing or closed index. */
    ignore_unavailable?: boolean;
    /** The node or shard the operation should be performed on.
      * By default, it is random. */
    preference?: string;
    /** A custom value that is used to route operations to a specific shard. */
    routing?: Routing;
    /** The type of index that wildcard patterns can match.
      * If the request can target data streams, this argument determines whether wildcard expressions match hidden data streams.
      * It supports comma-separated values, such as `open,hidden`. */
    expand_wildcards?: ExpandWildcards;
    /** Indicates whether the point in time tolerates unavailable shards or shard failures when initially creating the PIT.
      * If `false`, creating a point in time request when a shard is missing or unavailable will throw an exception.
      * If `true`, the point in time will contain all the shards that are available at the time of the request. */
    allow_partial_search_results?: boolean;
    /** Maximum number of concurrent shard requests that each sub-search request executes per node. */
    max_concurrent_shard_requests?: integer;
    /** Filter indices if the provided query rewrites to `match_none` on every shard. */
    index_filter?: QueryDslQueryContainer;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
        keep_alive?: never;
        ignore_unavailable?: never;
        preference?: never;
        routing?: never;
        expand_wildcards?: never;
        allow_partial_search_results?: never;
        max_concurrent_shard_requests?: never;
        index_filter?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
        keep_alive?: never;
        ignore_unavailable?: never;
        preference?: never;
        routing?: never;
        expand_wildcards?: never;
        allow_partial_search_results?: never;
        max_concurrent_shard_requests?: never;
        index_filter?: never;
    };
}
export interface OpenPointInTimeResponse {
    /** Shards used to create the PIT */
    _shards: ShardStatistics;
    id: Id;
}
export interface PingRequest extends RequestBase {
    /** All values in `body` will be added to the request body. */
    body?: string | {
        [key: string]: any;
    };
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    };
}
export type PingResponse = boolean;
export interface PutScriptRequest extends RequestBase {
    /** The identifier for the stored script or search template.
      * It must be unique within the cluster. */
    id: Id;
    /** The context in which the script or search template should run.
      * To prevent errors, the API immediately compiles the script or template in this context. */
    context?: Name;
    /** The period to wait for a connection to the master node.
      * If no response is received before the timeout expires, the request fails and returns an error.
      * It can also be set to `-1` to indicate that the request should never timeout. */
    master_timeout?: Duration;
    /** The period to wait for a response.
      * If no response is received before the timeout expires, the request fails and returns an error.
      * It can also be set to `-1` to indicate that the request should never timeout. */
    timeout?: Duration;
    /** The script or search template, its parameters, and its language. */
    script: StoredScript;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        id?: never;
        context?: never;
        master_timeout?: never;
        timeout?: never;
        script?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        id?: never;
        context?: never;
        master_timeout?: never;
        timeout?: never;
        script?: never;
    };
}
export type PutScriptResponse = AcknowledgedResponseBase;
export interface RankEvalDocumentRating {
    /** The document ID. */
    _id: Id;
    /** The document’s index. For data streams, this should be the document’s backing index. */
    _index: IndexName;
    /** The document’s relevance with regard to this search request. */
    rating: integer;
}
export interface RankEvalRankEvalHit {
    _id: Id;
    _index: IndexName;
    _score: double;
}
export interface RankEvalRankEvalHitItem {
    hit: RankEvalRankEvalHit;
    rating?: double | null;
}
export interface RankEvalRankEvalMetric {
    precision?: RankEvalRankEvalMetricPrecision;
    recall?: RankEvalRankEvalMetricRecall;
    mean_reciprocal_rank?: RankEvalRankEvalMetricMeanReciprocalRank;
    dcg?: RankEvalRankEvalMetricDiscountedCumulativeGain;
    expected_reciprocal_rank?: RankEvalRankEvalMetricExpectedReciprocalRank;
}
export interface RankEvalRankEvalMetricBase {
    /** Sets the maximum number of documents retrieved per query. This value will act in place of the usual size parameter in the query. */
    k?: integer;
}
export interface RankEvalRankEvalMetricDetail {
    /** The metric_score in the details section shows the contribution of this query to the global quality metric score */
    metric_score: double;
    /** The unrated_docs section contains an _index and _id entry for each document in the search result for this query that didn’t have a ratings value. This can be used to ask the user to supply ratings for these documents */
    unrated_docs: RankEvalUnratedDocument[];
    /** The hits section shows a grouping of the search results with their supplied ratings */
    hits: RankEvalRankEvalHitItem[];
    /** The metric_details give additional information about the calculated quality metric (e.g. how many of the retrieved documents were relevant). The content varies for each metric but allows for better interpretation of the results */
    metric_details: Record<string, Record<string, any>>;
}
export interface RankEvalRankEvalMetricDiscountedCumulativeGain extends RankEvalRankEvalMetricBase {
    /** If set to true, this metric will calculate the Normalized DCG. */
    normalize?: boolean;
}
export interface RankEvalRankEvalMetricExpectedReciprocalRank extends RankEvalRankEvalMetricBase {
    /** The highest relevance grade used in the user-supplied relevance judgments. */
    maximum_relevance: integer;
}
export interface RankEvalRankEvalMetricMeanReciprocalRank extends RankEvalRankEvalMetricRatingTreshold {
}
export interface RankEvalRankEvalMetricPrecision extends RankEvalRankEvalMetricRatingTreshold {
    /** Controls how unlabeled documents in the search results are counted. If set to true, unlabeled documents are ignored and neither count as relevant or irrelevant. Set to false (the default), they are treated as irrelevant. */
    ignore_unlabeled?: boolean;
}
export interface RankEvalRankEvalMetricRatingTreshold extends RankEvalRankEvalMetricBase {
    /** Sets the rating threshold above which documents are considered to be "relevant". */
    relevant_rating_threshold?: integer;
}
export interface RankEvalRankEvalMetricRecall extends RankEvalRankEvalMetricRatingTreshold {
}
export interface RankEvalRankEvalQuery {
    query: QueryDslQueryContainer;
    size?: integer;
}
export interface RankEvalRankEvalRequestItem {
    /** The search request’s ID, used to group result details later. */
    id: Id;
    /** The query being evaluated. */
    request?: RankEvalRankEvalQuery | QueryDslQueryContainer;
    /** List of document ratings */
    ratings: RankEvalDocumentRating[];
    /** The search template Id */
    template_id?: Id;
    /** The search template parameters. */
    params?: Record<string, any>;
}
export interface RankEvalRequest extends RequestBase {
    /** A  comma-separated list of data streams, indices, and index aliases used to limit the request.
      * Wildcard (`*`) expressions are supported.
      * To target all data streams and indices in a cluster, omit this parameter or use `_all` or `*`. */
    index?: Indices;
    /** If `false`, the request returns an error if any wildcard expression, index alias, or `_all` value targets only missing or closed indices. This behavior applies even if the request targets other open indices. For example, a request targeting `foo*,bar*` returns an error if an index starts with `foo` but no index starts with `bar`. */
    allow_no_indices?: boolean;
    /** Whether to expand wildcard expression to concrete indices that are open, closed or both. */
    expand_wildcards?: ExpandWildcards;
    /** If `true`, missing or closed indices are not included in the response. */
    ignore_unavailable?: boolean;
    /** Search operation type */
    search_type?: string;
    /** A set of typical search requests, together with their provided ratings. */
    requests: RankEvalRankEvalRequestItem[];
    /** Definition of the evaluation metric to calculate. */
    metric?: RankEvalRankEvalMetric;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
        allow_no_indices?: never;
        expand_wildcards?: never;
        ignore_unavailable?: never;
        search_type?: never;
        requests?: never;
        metric?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
        allow_no_indices?: never;
        expand_wildcards?: never;
        ignore_unavailable?: never;
        search_type?: never;
        requests?: never;
        metric?: never;
    };
}
export interface RankEvalResponse {
    /** The overall evaluation quality calculated by the defined metric */
    metric_score: double;
    /** The details section contains one entry for every query in the original requests section, keyed by the search request id */
    details: Record<Id, RankEvalRankEvalMetricDetail>;
    failures: Record<string, any>;
}
export interface RankEvalUnratedDocument {
    _id: Id;
    _index: IndexName;
}
export interface ReindexDestination {
    /** The name of the data stream, index, or index alias you are copying to. */
    index: IndexName;
    /** If it is `create`, the operation will only index documents that do not already exist (also known as "put if absent").
      *
      * IMPORTANT: To reindex to a data stream destination, this argument must be `create`. */
    op_type?: OpType;
    /** The name of the pipeline to use. */
    pipeline?: string;
    /** By default, a document's routing is preserved unless it's changed by the script.
      * If it is `keep`, the routing on the bulk request sent for each match is set to the routing on the match.
      * If it is `discard`, the routing on the bulk request sent for each match is set to `null`.
      * If it is `=value`, the routing on the bulk request sent for each match is set to all value specified after the equals sign (`=`). */
    routing?: Routing;
    /** The versioning to use for the indexing operation. */
    version_type?: VersionType;
}
export interface ReindexRemoteSource {
    /** The remote connection timeout. */
    connect_timeout?: Duration;
    /** An object containing the headers of the request. */
    headers?: Record<string, string>;
    /** The URL for the remote instance of Elasticsearch that you want to index from.
      * This information is required when you're indexing from remote. */
    host: Host;
    /** The username to use for authentication with the remote host. */
    username?: Username;
    /** The password to use for authentication with the remote host. */
    password?: Password;
    /** The remote socket read timeout. */
    socket_timeout?: Duration;
}
export interface ReindexRequest extends RequestBase {
    /** If `true`, the request refreshes affected shards to make this operation visible to search. */
    refresh?: boolean;
    /** The throttle for this request in sub-requests per second.
      * By default, there is no throttle. */
    requests_per_second?: float;
    /** The period of time that a consistent view of the index should be maintained for scrolled search. */
    scroll?: Duration;
    /** The number of slices this task should be divided into.
      * It defaults to one slice, which means the task isn't sliced into subtasks.
      *
      * Reindex supports sliced scroll to parallelize the reindexing process.
      * This parallelization can improve efficiency and provide a convenient way to break the request down into smaller parts.
      *
      * NOTE: Reindexing from remote clusters does not support manual or automatic slicing.
      *
      * If set to `auto`, Elasticsearch chooses the number of slices to use.
      * This setting will use one slice per shard, up to a certain limit.
      * If there are multiple sources, it will choose the number of slices based on the index or backing index with the smallest number of shards. */
    slices?: Slices;
    /** The period each indexing waits for automatic index creation, dynamic mapping updates, and waiting for active shards.
      * By default, Elasticsearch waits for at least one minute before failing.
      * The actual wait time could be longer, particularly when multiple waits occur. */
    timeout?: Duration;
    /** The number of shard copies that must be active before proceeding with the operation.
      * Set it to `all` or any positive integer up to the total number of shards in the index (`number_of_replicas+1`).
      * The default value is one, which means it waits for each primary shard to be active. */
    wait_for_active_shards?: WaitForActiveShards;
    /** If `true`, the request blocks until the operation is complete. */
    wait_for_completion?: boolean;
    /** If `true`, the destination must be an index alias. */
    require_alias?: boolean;
    /** Indicates whether to continue reindexing even when there are conflicts. */
    conflicts?: Conflicts;
    /** The destination you are copying to. */
    dest: ReindexDestination;
    /** The maximum number of documents to reindex.
      * By default, all documents are reindexed.
      * If it is a value less then or equal to `scroll_size`, a scroll will not be used to retrieve the results for the operation.
      *
      * If `conflicts` is set to `proceed`, the reindex operation could attempt to reindex more documents from the source than `max_docs` until it has successfully indexed `max_docs` documents into the target or it has gone through every document in the source query. */
    max_docs?: long;
    /** The script to run to update the document source or metadata when reindexing. */
    script?: Script | ScriptSource;
    size?: long;
    /** The source you are copying from. */
    source: ReindexSource;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        refresh?: never;
        requests_per_second?: never;
        scroll?: never;
        slices?: never;
        timeout?: never;
        wait_for_active_shards?: never;
        wait_for_completion?: never;
        require_alias?: never;
        conflicts?: never;
        dest?: never;
        max_docs?: never;
        script?: never;
        size?: never;
        source?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        refresh?: never;
        requests_per_second?: never;
        scroll?: never;
        slices?: never;
        timeout?: never;
        wait_for_active_shards?: never;
        wait_for_completion?: never;
        require_alias?: never;
        conflicts?: never;
        dest?: never;
        max_docs?: never;
        script?: never;
        size?: never;
        source?: never;
    };
}
export interface ReindexResponse {
    /** The number of scroll responses that were pulled back by the reindex. */
    batches?: long;
    /** The number of documents that were successfully created. */
    created?: long;
    /** The number of documents that were successfully deleted. */
    deleted?: long;
    /** If there were any unrecoverable errors during the process, it is an array of those failures.
      * If this array is not empty, the request ended because of those failures.
      * Reindex is implemented using batches and any failure causes the entire process to end but all failures in the current batch are collected into the array.
      * You can use the `conflicts` option to prevent the reindex from ending on version conflicts. */
    failures?: BulkIndexByScrollFailure[];
    /** The number of documents that were ignored because the script used for the reindex returned a `noop` value for `ctx.op`. */
    noops?: long;
    /** The number of retries attempted by reindex. */
    retries?: Retries;
    /** The number of requests per second effectively run during the reindex. */
    requests_per_second?: float;
    slice_id?: integer;
    task?: TaskId;
    /** The number of milliseconds the request slept to conform to `requests_per_second`. */
    throttled_millis?: EpochTime<UnitMillis>;
    /** This field should always be equal to zero in a reindex response.
      * It has meaning only when using the task API, where it indicates the next time (in milliseconds since epoch) that a throttled request will be run again in order to conform to `requests_per_second`. */
    throttled_until_millis?: EpochTime<UnitMillis>;
    /** If any of the requests that ran during the reindex timed out, it is `true`. */
    timed_out?: boolean;
    /** The total milliseconds the entire operation took. */
    took?: DurationValue<UnitMillis>;
    /** The number of documents that were successfully processed. */
    total?: long;
    /** The number of documents that were successfully updated.
      * That is to say, a document with the same ID already existed before the reindex updated it. */
    updated?: long;
    /** The number of version conflicts that occurred. */
    version_conflicts?: long;
}
export interface ReindexSource {
    /** The name of the data stream, index, or alias you are copying from.
      * It accepts a comma-separated list to reindex from multiple sources. */
    index: Indices;
    /** The documents to reindex, which is defined with Query DSL. */
    query?: QueryDslQueryContainer;
    /** A remote instance of Elasticsearch that you want to index from. */
    remote?: ReindexRemoteSource;
    /** The number of documents to index per batch.
      * Use it when you are indexing from remote to ensure that the batches fit within the on-heap buffer, which defaults to a maximum size of 100 MB. */
    size?: integer;
    /** Slice the reindex request manually using the provided slice ID and total number of slices. */
    slice?: SlicedScroll;
    /** A comma-separated list of `<field>:<direction>` pairs to sort by before indexing.
      * Use it in conjunction with `max_docs` to control what documents are reindexed.
      *
      * WARNING: Sort in reindex is deprecated.
      * Sorting in reindex was never guaranteed to index documents in order and prevents further development of reindex such as resilience and performance improvements.
      * If used in combination with `max_docs`, consider using a query filter instead. */
    sort?: Sort;
    /** If `true`, reindex all source fields.
      * Set it to a list to reindex select fields. */
    _source?: Fields;
    runtime_mappings?: MappingRuntimeFields;
}
export interface ReindexRethrottleReindexNode extends SpecUtilsBaseNode {
    tasks: Record<TaskId, ReindexRethrottleReindexTask>;
}
export interface ReindexRethrottleReindexStatus {
    /** The number of scroll responses pulled back by the reindex. */
    batches: long;
    /** The number of documents that were successfully created. */
    created: long;
    /** The number of documents that were successfully deleted. */
    deleted: long;
    /** The number of documents that were ignored because the script used for the reindex returned a `noop` value for `ctx.op`. */
    noops: long;
    /** The number of requests per second effectively executed during the reindex. */
    requests_per_second: float;
    /** The number of retries attempted by reindex. `bulk` is the number of bulk actions retried and `search` is the number of search actions retried. */
    retries: Retries;
    throttled?: Duration;
    /** Number of milliseconds the request slept to conform to `requests_per_second`. */
    throttled_millis: DurationValue<UnitMillis>;
    throttled_until?: Duration;
    /** This field should always be equal to zero in a `_reindex` response.
      * It only has meaning when using the Task API, where it indicates the next time (in milliseconds since epoch) a throttled request will be executed again in order to conform to `requests_per_second`. */
    throttled_until_millis: DurationValue<UnitMillis>;
    /** The number of documents that were successfully processed. */
    total: long;
    /** The number of documents that were successfully updated, for example, a document with same ID already existed prior to reindex updating it. */
    updated: long;
    /** The number of version conflicts that reindex hits. */
    version_conflicts: long;
}
export interface ReindexRethrottleReindexTask {
    action: string;
    cancellable: boolean;
    description: string;
    id: long;
    node: Name;
    running_time_in_nanos: DurationValue<UnitNanos>;
    start_time_in_millis: EpochTime<UnitMillis>;
    status: ReindexRethrottleReindexStatus;
    type: string;
    headers: HttpHeaders;
}
export interface ReindexRethrottleRequest extends RequestBase {
    /** The task identifier, which can be found by using the tasks API. */
    task_id: Id;
    /** The throttle for this request in sub-requests per second.
      * It can be either `-1` to turn off throttling or any decimal number like `1.7` or `12` to throttle to that level. */
    requests_per_second?: float;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        task_id?: never;
        requests_per_second?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        task_id?: never;
        requests_per_second?: never;
    };
}
export interface ReindexRethrottleResponse {
    nodes: Record<string, ReindexRethrottleReindexNode>;
}
export interface RenderSearchTemplateRequest extends RequestBase {
    /** The ID of the search template to render.
      * If no `source` is specified, this or the `id` request body parameter is required. */
    id?: Id;
    file?: string;
    /** Key-value pairs used to replace Mustache variables in the template.
      * The key is the variable name.
      * The value is the variable value. */
    params?: Record<string, any>;
    /** An inline search template.
      * It supports the same parameters as the search API's request body.
      * These parameters also support Mustache variables.
      * If no `id` or `<templated-id>` is specified, this parameter is required. */
    source?: ScriptSource;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        id?: never;
        file?: never;
        params?: never;
        source?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        id?: never;
        file?: never;
        params?: never;
        source?: never;
    };
}
export interface RenderSearchTemplateResponse {
    template_output: Record<string, any>;
}
export type ScriptsPainlessExecutePainlessContext = 'painless_test' | 'filter' | 'score' | 'boolean_field' | 'date_field' | 'double_field' | 'geo_point_field' | 'ip_field' | 'keyword_field' | 'long_field' | 'composite_field';
export interface ScriptsPainlessExecutePainlessContextSetup {
    /** Document that's temporarily indexed in-memory and accessible from the script. */
    document: any;
    /** Index containing a mapping that's compatible with the indexed document.
      * You may specify a remote index by prefixing the index with the remote cluster alias.
      * For example, `remote1:my_index` indicates that you want to run the painless script against the "my_index" index on the "remote1" cluster.
      * This request will be forwarded to the "remote1" cluster if you have configured a connection to that remote cluster.
      *
      * NOTE: Wildcards are not accepted in the index expression for this endpoint.
      * The expression `*:myindex` will return the error "No such remote cluster" and the expression `logs*` or `remote1:logs*` will return the error "index not found". */
    index: IndexName;
    /** Use this parameter to specify a query for computing a score. */
    query?: QueryDslQueryContainer;
}
export interface ScriptsPainlessExecuteRequest extends RequestBase {
    /** The context that the script should run in.
      * NOTE: Result ordering in the field contexts is not guaranteed. */
    context?: ScriptsPainlessExecutePainlessContext;
    /** Additional parameters for the `context`.
      * NOTE: This parameter is required for all contexts except `painless_test`, which is the default if no value is provided for `context`. */
    context_setup?: ScriptsPainlessExecutePainlessContextSetup;
    /** The Painless script to run. */
    script?: Script | ScriptSource;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        context?: never;
        context_setup?: never;
        script?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        context?: never;
        context_setup?: never;
        script?: never;
    };
}
export interface ScriptsPainlessExecuteResponse<TResult = unknown> {
    result: TResult;
}
export interface ScrollRequest extends RequestBase {
    /** The scroll ID */
    scroll_id?: ScrollId;
    /** If true, the API response’s hit.total property is returned as an integer. If false, the API response’s hit.total property is returned as an object. */
    rest_total_hits_as_int?: boolean;
    /** The period to retain the search context for scrolling. */
    scroll?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        scroll_id?: never;
        rest_total_hits_as_int?: never;
        scroll?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        scroll_id?: never;
        rest_total_hits_as_int?: never;
        scroll?: never;
    };
}
export type ScrollResponse<TDocument = unknown, TAggregations = Record<AggregateName, AggregationsAggregate>> = SearchResponseBody<TDocument, TAggregations>;
export interface SearchRequest extends RequestBase {
    /** A comma-separated list of data streams, indices, and aliases to search.
      * It supports wildcards (`*`).
      * To search all data streams and indices, omit this parameter or use `*` or `_all`. */
    index?: Indices;
    /** If `false`, the request returns an error if any wildcard expression, index alias, or `_all` value targets only missing or closed indices.
      * This behavior applies even if the request targets other open indices.
      * For example, a request targeting `foo*,bar*` returns an error if an index starts with `foo` but no index starts with `bar`. */
    allow_no_indices?: boolean;
    /** If `true` and there are shard request timeouts or shard failures, the request returns partial results.
      * If `false`, it returns an error with no partial results.
      *
      * To override the default behavior, you can set the `search.default_allow_partial_results` cluster setting to `false`. */
    allow_partial_search_results?: boolean;
    /** The analyzer to use for the query string.
      * This parameter can be used only when the `q` query string parameter is specified. */
    analyzer?: string;
    /** If `true`, wildcard and prefix queries are analyzed.
      * This parameter can be used only when the `q` query string parameter is specified. */
    analyze_wildcard?: boolean;
    /** The number of shard results that should be reduced at once on the coordinating node.
      * If the potential number of shards in the request can be large, this value should be used as a protection mechanism to reduce the memory overhead per search request. */
    batched_reduce_size?: long;
    /** If `true`, network round-trips between the coordinating node and the remote clusters are minimized when running cross-cluster search (CCS) requests. */
    ccs_minimize_roundtrips?: boolean;
    /** The default operator for the query string query: `AND` or `OR`.
      * This parameter can be used only when the `q` query string parameter is specified. */
    default_operator?: QueryDslOperator;
    /** The field to use as a default when no field prefix is given in the query string.
      * This parameter can be used only when the `q` query string parameter is specified. */
    df?: string;
    /** The type of index that wildcard patterns can match.
      * If the request can target data streams, this argument determines whether wildcard expressions match hidden data streams.
      * It supports comma-separated values such as `open,hidden`. */
    expand_wildcards?: ExpandWildcards;
    /** If `true`, concrete, expanded or aliased indices will be ignored when frozen. */
    ignore_throttled?: boolean;
    /** If `false`, the request returns an error if it targets a missing or closed index. */
    ignore_unavailable?: boolean;
    /** If `true`, the response includes the score contribution from any named queries.
      *
      * This functionality reruns each named query on every hit in a search response.
      * Typically, this adds a small overhead to a request.
      * However, using computationally expensive named queries on a large number of hits may add significant overhead. */
    include_named_queries_score?: boolean;
    /** If `true`, format-based query failures (such as providing text to a numeric field) in the query string will be ignored.
      * This parameter can be used only when the `q` query string parameter is specified. */
    lenient?: boolean;
    /** The number of concurrent shard requests per node that the search runs concurrently.
      * This value should be used to limit the impact of the search on the cluster in order to limit the number of concurrent shard requests. */
    max_concurrent_shard_requests?: integer;
    /** The nodes and shards used for the search.
      * By default, Elasticsearch selects from eligible nodes and shards using adaptive replica selection, accounting for allocation awareness.
      * Valid values are:
      *
      * * `_only_local` to run the search only on shards on the local node.
      * * `_local` to, if possible, run the search on shards on the local node, or if not, select shards using the default method.
      * * `_only_nodes:<node-id>,<node-id>` to run the search on only the specified nodes IDs. If suitable shards exist on more than one selected node, use shards on those nodes using the default method. If none of the specified nodes are available, select shards from any available node using the default method.
      * * `_prefer_nodes:<node-id>,<node-id>` to if possible, run the search on the specified nodes IDs. If not, select shards using the default method.
      * * `_shards:<shard>,<shard>` to run the search only on the specified shards. You can combine this value with other `preference` values. However, the `_shards` value must come first. For example: `_shards:2,3|_local`.
      * * `<custom-string>` (any string that does not start with `_`) to route searches with the same `<custom-string>` to the same shards in the same order. */
    preference?: string;
    /** A threshold that enforces a pre-filter roundtrip to prefilter search shards based on query rewriting if the number of shards the search request expands to exceeds the threshold.
      * This filter roundtrip can limit the number of shards significantly if for instance a shard can not match any documents based on its rewrite method (if date filters are mandatory to match but the shard bounds and the query are disjoint).
      * When unspecified, the pre-filter phase is executed if any of these conditions is met:
      *
      * * The request targets more than 128 shards.
      * * The request targets one or more read-only index.
      * * The primary sort of the query targets an indexed field. */
    pre_filter_shard_size?: long;
    /** If `true`, the caching of search results is enabled for requests where `size` is `0`.
      * It defaults to index level settings. */
    request_cache?: boolean;
    /** A custom value that is used to route operations to a specific shard. */
    routing?: Routing;
    /** The period to retain the search context for scrolling.
      * By default, this value cannot exceed `1d` (24 hours).
      * You can change this limit by using the `search.max_keep_alive` cluster-level setting. */
    scroll?: Duration;
    /** Indicates how distributed term frequencies are calculated for relevance scoring. */
    search_type?: SearchType;
    /** The field to use for suggestions. */
    suggest_field?: Field;
    /** The suggest mode.
      * This parameter can be used only when the `suggest_field` and `suggest_text` query string parameters are specified. */
    suggest_mode?: SuggestMode;
    /** The number of suggestions to return.
      * This parameter can be used only when the `suggest_field` and `suggest_text` query string parameters are specified. */
    suggest_size?: long;
    /** The source text for which the suggestions should be returned.
      * This parameter can be used only when the `suggest_field` and `suggest_text` query string parameters are specified. */
    suggest_text?: string;
    /** If `true`, aggregation and suggester names are be prefixed by their respective types in the response. */
    typed_keys?: boolean;
    /** Indicates whether `hits.total` should be rendered as an integer or an object in the rest search response. */
    rest_total_hits_as_int?: boolean;
    /** A comma-separated list of source fields to exclude from the response.
      * You can also use this parameter to exclude fields from the subset specified in `_source_includes` query parameter.
      * If the `_source` parameter is `false`, this parameter is ignored. */
    _source_excludes?: Fields;
    /** A comma-separated list of source fields to include in the response.
      * If this parameter is specified, only these source fields are returned.
      * You can exclude fields from this subset using the `_source_excludes` query parameter.
      * If the `_source` parameter is `false`, this parameter is ignored. */
    _source_includes?: Fields;
    /** A query in the Lucene query string syntax.
      * Query parameter searches do not support the full Elasticsearch Query DSL but are handy for testing.
      *
      * IMPORTANT: This parameter overrides the query parameter in the request body.
      * If both parameters are specified, documents matching the query request body parameter are not returned. */
    q?: string;
    /** Should this request force synthetic _source?
      * Use this to test if the mapping supports synthetic _source and to get a sense of the worst case performance.
      * Fetches with this enabled will be slower the enabling synthetic source natively in the index. */
    force_synthetic_source?: boolean;
    /** Defines the aggregations that are run as part of the search request. */
    aggregations?: Record<string, AggregationsAggregationContainer>;
    /** Defines the aggregations that are run as part of the search request.
      * @alias aggregations */
    aggs?: Record<string, AggregationsAggregationContainer>;
    /** Collapses search results the values of the specified field. */
    collapse?: SearchFieldCollapse;
    /** If `true`, the request returns detailed information about score computation as part of a hit. */
    explain?: boolean;
    /** Configuration of search extensions defined by Elasticsearch plugins. */
    ext?: Record<string, any>;
    /** The starting document offset, which must be non-negative.
      * By default, you cannot page through more than 10,000 hits using the `from` and `size` parameters.
      * To page through more hits, use the `search_after` parameter. */
    from?: integer;
    /** Specifies the highlighter to use for retrieving highlighted snippets from one or more fields in your search results. */
    highlight?: SearchHighlight;
    /** Number of hits matching the query to count accurately.
      * If `true`, the exact number of hits is returned at the cost of some performance.
      * If `false`, the  response does not include the total number of hits matching the query. */
    track_total_hits?: SearchTrackHits;
    /** Boost the `_score` of documents from specified indices.
      * The boost value is the factor by which scores are multiplied.
      * A boost value greater than `1.0` increases the score.
      * A boost value between `0` and `1.0` decreases the score. */
    indices_boost?: Partial<Record<IndexName, double>>[];
    /** An array of wildcard (`*`) field patterns.
      * The request returns doc values for field names matching these patterns in the `hits.fields` property of the response. */
    docvalue_fields?: (QueryDslFieldAndFormat | Field)[];
    /** The approximate kNN search to run. */
    knn?: KnnSearch | KnnSearch[];
    /** The Reciprocal Rank Fusion (RRF) to use.
      * @remarks This property is not supported on Elastic Cloud Serverless. */
    rank?: RankContainer;
    /** The minimum `_score` for matching documents.
      * Documents with a lower `_score` are not included in search results and results collected by aggregations. */
    min_score?: double;
    /** Use the `post_filter` parameter to filter search results.
      * The search hits are filtered after the aggregations are calculated.
      * A post filter has no impact on the aggregation results. */
    post_filter?: QueryDslQueryContainer;
    /** Set to `true` to return detailed timing information about the execution of individual components in a search request.
      * NOTE: This is a debugging tool and adds significant overhead to search execution. */
    profile?: boolean;
    /** The search definition using the Query DSL. */
    query?: QueryDslQueryContainer;
    /** Can be used to improve precision by reordering just the top (for example 100 - 500) documents returned by the `query` and `post_filter` phases. */
    rescore?: SearchRescore | SearchRescore[];
    /** A retriever is a specification to describe top documents returned from a search.
      * A retriever replaces other elements of the search API that also return top documents such as `query` and `knn`. */
    retriever?: RetrieverContainer;
    /** Retrieve a script evaluation (based on different fields) for each hit. */
    script_fields?: Record<string, ScriptField>;
    /** Used to retrieve the next page of hits using a set of sort values from the previous page. */
    search_after?: SortResults;
    /** The number of hits to return, which must not be negative.
      * By default, you cannot page through more than 10,000 hits using the `from` and `size` parameters.
      * To page through more hits, use the `search_after` property. */
    size?: integer;
    /** Split a scrolled search into multiple slices that can be consumed independently. */
    slice?: SlicedScroll;
    /** A comma-separated list of <field>:<direction> pairs. */
    sort?: Sort;
    /** The source fields that are returned for matching documents.
      * These fields are returned in the `hits._source` property of the search response.
      * If the `stored_fields` property is specified, the `_source` property defaults to `false`.
      * Otherwise, it defaults to `true`. */
    _source?: SearchSourceConfig;
    /** An array of wildcard (`*`) field patterns.
      * The request returns values for field names matching these patterns in the `hits.fields` property of the response. */
    fields?: (QueryDslFieldAndFormat | Field)[];
    /** Defines a suggester that provides similar looking terms based on a provided text. */
    suggest?: SearchSuggester;
    /** The maximum number of documents to collect for each shard.
      * If a query reaches this limit, Elasticsearch terminates the query early.
      * Elasticsearch collects documents before sorting.
      *
      * IMPORTANT: Use with caution.
      * Elasticsearch applies this property to each shard handling the request.
      * When possible, let Elasticsearch perform early termination automatically.
      * Avoid specifying this property for requests that target data streams with backing indices across multiple data tiers.
      *
      * If set to `0` (default), the query does not terminate early. */
    terminate_after?: long;
    /** The period of time to wait for a response from each shard.
      * If no response is received before the timeout expires, the request fails and returns an error.
      * Defaults to no timeout. */
    timeout?: string;
    /** If `true`, calculate and return document scores, even if the scores are not used for sorting. */
    track_scores?: boolean;
    /** If `true`, the request returns the document version as part of a hit. */
    version?: boolean;
    /** If `true`, the request returns sequence number and primary term of the last modification of each hit. */
    seq_no_primary_term?: boolean;
    /** A comma-separated list of stored fields to return as part of a hit.
      * If no fields are specified, no stored fields are included in the response.
      * If this field is specified, the `_source` property defaults to `false`.
      * You can pass `_source: true` to return both source fields and stored fields in the search response. */
    stored_fields?: Fields;
    /** Limit the search to a point in time (PIT).
      * If you provide a PIT, you cannot specify an `<index>` in the request path. */
    pit?: SearchPointInTimeReference;
    /** One or more runtime fields in the search request.
      * These fields take precedence over mapped fields with the same name. */
    runtime_mappings?: MappingRuntimeFields;
    /** The stats groups to associate with the search.
      * Each group maintains a statistics aggregation for its associated searches.
      * You can retrieve these stats using the indices stats API. */
    stats?: string[];
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
        allow_no_indices?: never;
        allow_partial_search_results?: never;
        analyzer?: never;
        analyze_wildcard?: never;
        batched_reduce_size?: never;
        ccs_minimize_roundtrips?: never;
        default_operator?: never;
        df?: never;
        expand_wildcards?: never;
        ignore_throttled?: never;
        ignore_unavailable?: never;
        include_named_queries_score?: never;
        lenient?: never;
        max_concurrent_shard_requests?: never;
        preference?: never;
        pre_filter_shard_size?: never;
        request_cache?: never;
        routing?: never;
        scroll?: never;
        search_type?: never;
        suggest_field?: never;
        suggest_mode?: never;
        suggest_size?: never;
        suggest_text?: never;
        typed_keys?: never;
        rest_total_hits_as_int?: never;
        _source_excludes?: never;
        _source_includes?: never;
        q?: never;
        force_synthetic_source?: never;
        aggregations?: never;
        aggs?: never;
        collapse?: never;
        explain?: never;
        ext?: never;
        from?: never;
        highlight?: never;
        track_total_hits?: never;
        indices_boost?: never;
        docvalue_fields?: never;
        knn?: never;
        rank?: never;
        min_score?: never;
        post_filter?: never;
        profile?: never;
        query?: never;
        rescore?: never;
        retriever?: never;
        script_fields?: never;
        search_after?: never;
        size?: never;
        slice?: never;
        sort?: never;
        _source?: never;
        fields?: never;
        suggest?: never;
        terminate_after?: never;
        timeout?: never;
        track_scores?: never;
        version?: never;
        seq_no_primary_term?: never;
        stored_fields?: never;
        pit?: never;
        runtime_mappings?: never;
        stats?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
        allow_no_indices?: never;
        allow_partial_search_results?: never;
        analyzer?: never;
        analyze_wildcard?: never;
        batched_reduce_size?: never;
        ccs_minimize_roundtrips?: never;
        default_operator?: never;
        df?: never;
        expand_wildcards?: never;
        ignore_throttled?: never;
        ignore_unavailable?: never;
        include_named_queries_score?: never;
        lenient?: never;
        max_concurrent_shard_requests?: never;
        preference?: never;
        pre_filter_shard_size?: never;
        request_cache?: never;
        routing?: never;
        scroll?: never;
        search_type?: never;
        suggest_field?: never;
        suggest_mode?: never;
        suggest_size?: never;
        suggest_text?: never;
        typed_keys?: never;
        rest_total_hits_as_int?: never;
        _source_excludes?: never;
        _source_includes?: never;
        q?: never;
        force_synthetic_source?: never;
        aggregations?: never;
        aggs?: never;
        collapse?: never;
        explain?: never;
        ext?: never;
        from?: never;
        highlight?: never;
        track_total_hits?: never;
        indices_boost?: never;
        docvalue_fields?: never;
        knn?: never;
        rank?: never;
        min_score?: never;
        post_filter?: never;
        profile?: never;
        query?: never;
        rescore?: never;
        retriever?: never;
        script_fields?: never;
        search_after?: never;
        size?: never;
        slice?: never;
        sort?: never;
        _source?: never;
        fields?: never;
        suggest?: never;
        terminate_after?: never;
        timeout?: never;
        track_scores?: never;
        version?: never;
        seq_no_primary_term?: never;
        stored_fields?: never;
        pit?: never;
        runtime_mappings?: never;
        stats?: never;
    };
}
export type SearchResponse<TDocument = unknown, TAggregations = Record<AggregateName, AggregationsAggregate>> = SearchResponseBody<TDocument, TAggregations>;
export interface SearchResponseBody<TDocument = unknown, TAggregations = Record<AggregateName, AggregationsAggregate>> {
    /** The number of milliseconds it took Elasticsearch to run the request.
      * This value is calculated by measuring the time elapsed between receipt of a request on the coordinating node and the time at which the coordinating node is ready to send the response.
      * It includes:
      *
      * * Communication time between the coordinating node and data nodes
      * * Time the request spends in the search thread pool, queued for execution
      * * Actual run time
      *
      * It does not include:
      *
      * * Time needed to send the request to Elasticsearch
      * * Time needed to serialize the JSON response
      * * Time needed to send the response to a client */
    took: long;
    /** If `true`, the request timed out before completion; returned results may be partial or empty. */
    timed_out: boolean;
    /** A count of shards used for the request. */
    _shards: ShardStatistics;
    /** The returned documents and metadata. */
    hits: SearchHitsMetadata<TDocument>;
    aggregations?: TAggregations;
    _clusters?: ClusterStatistics;
    fields?: Record<string, any>;
    max_score?: double;
    num_reduce_phases?: long;
    profile?: SearchProfile;
    pit_id?: Id;
    /** The identifier for the search and its search context.
      * You can use this scroll ID with the scroll API to retrieve the next batch of search results for the request.
      * This property is returned only if the `scroll` query parameter is specified in the request. */
    _scroll_id?: ScrollId;
    suggest?: Record<SuggestionName, SearchSuggest<TDocument>[]>;
    terminated_early?: boolean;
}
export interface SearchAggregationBreakdown {
    build_aggregation: long;
    build_aggregation_count: long;
    build_leaf_collector: long;
    build_leaf_collector_count: long;
    collect: long;
    collect_count: long;
    initialize: long;
    initialize_count: long;
    post_collection?: long;
    post_collection_count?: long;
    reduce: long;
    reduce_count: long;
}
export interface SearchAggregationProfile {
    breakdown: SearchAggregationBreakdown;
    description: string;
    time_in_nanos: DurationValue<UnitNanos>;
    type: string;
    debug?: SearchAggregationProfileDebug;
    children?: SearchAggregationProfile[];
}
export interface SearchAggregationProfileDebug {
    segments_with_multi_valued_ords?: integer;
    collection_strategy?: string;
    segments_with_single_valued_ords?: integer;
    total_buckets?: integer;
    built_buckets?: integer;
    result_strategy?: string;
    has_filter?: boolean;
    delegate?: string;
    delegate_debug?: SearchAggregationProfileDebug;
    chars_fetched?: integer;
    extract_count?: integer;
    extract_ns?: integer;
    values_fetched?: integer;
    collect_analyzed_ns?: integer;
    collect_analyzed_count?: integer;
    surviving_buckets?: integer;
    ordinals_collectors_used?: integer;
    ordinals_collectors_overhead_too_high?: integer;
    string_hashing_collectors_used?: integer;
    numeric_collectors_used?: integer;
    empty_collectors_used?: integer;
    deferred_aggregators?: string[];
    segments_with_doc_count_field?: integer;
    segments_with_deleted_docs?: integer;
    filters?: SearchAggregationProfileDelegateDebugFilter[];
    segments_counted?: integer;
    segments_collected?: integer;
    map_reducer?: string;
    brute_force_used?: integer;
    dynamic_pruning_attempted?: integer;
    dynamic_pruning_used?: integer;
    skipped_due_to_no_data?: integer;
}
export interface SearchAggregationProfileDelegateDebugFilter {
    results_from_metadata?: integer;
    query?: string;
    specialized_for?: string;
    segments_counted_in_constant_time?: integer;
}
export type SearchBoundaryScanner = 'chars' | 'sentence' | 'word';
export interface SearchCollector {
    name: string;
    reason: string;
    time_in_nanos: DurationValue<UnitNanos>;
    children?: SearchCollector[];
}
export interface SearchCompletionContext {
    /** The factor by which the score of the suggestion should be boosted.
      * The score is computed by multiplying the boost with the suggestion weight. */
    boost?: double;
    /** The value of the category to filter/boost on. */
    context: SearchContext;
    /** An array of precision values at which neighboring geohashes should be taken into account.
      * Precision value can be a distance value (`5m`, `10km`, etc.) or a raw geohash precision (`1`..`12`).
      * Defaults to generating neighbors for index time precision level. */
    neighbours?: GeoHashPrecision[];
    /** The precision of the geohash to encode the query geo point.
      * Can be specified as a distance value (`5m`, `10km`, etc.), or as a raw geohash precision (`1`..`12`).
      * Defaults to index time precision level. */
    precision?: GeoHashPrecision;
    /** Whether the category value should be treated as a prefix or not. */
    prefix?: boolean;
}
export interface SearchCompletionSuggest<TDocument = unknown> extends SearchSuggestBase {
    options: SearchCompletionSuggestOption<TDocument> | SearchCompletionSuggestOption<TDocument>[];
}
export interface SearchCompletionSuggestOption<TDocument = unknown> {
    collate_match?: boolean;
    contexts?: Record<string, SearchContext[]>;
    fields?: Record<string, any>;
    _id?: string;
    _index?: IndexName;
    _routing?: Routing;
    _score?: double;
    _source?: TDocument;
    text: string;
    score?: double;
}
export interface SearchCompletionSuggester extends SearchSuggesterBase {
    /** A value, geo point object, or a geo hash string to filter or boost the suggestion on. */
    contexts?: Record<Field, SearchCompletionContext | SearchContext | (SearchCompletionContext | SearchContext)[]>;
    /** Enables fuzziness, meaning you can have a typo in your search and still get results back. */
    fuzzy?: SearchSuggestFuzziness;
    /** A regex query that expresses a prefix as a regular expression. */
    regex?: SearchRegexOptions;
    /** Whether duplicate suggestions should be filtered out. */
    skip_duplicates?: boolean;
}
export type SearchContext = string | GeoLocation;
export interface SearchDfsKnnProfile {
    vector_operations_count?: long;
    query: SearchKnnQueryProfileResult[];
    rewrite_time: long;
    collector: SearchKnnCollectorResult[];
}
export interface SearchDfsProfile {
    statistics?: SearchDfsStatisticsProfile;
    knn?: SearchDfsKnnProfile[];
}
export interface SearchDfsStatisticsBreakdown {
    collection_statistics: long;
    collection_statistics_count: long;
    create_weight: long;
    create_weight_count: long;
    rewrite: long;
    rewrite_count: long;
    term_statistics: long;
    term_statistics_count: long;
}
export interface SearchDfsStatisticsProfile {
    type: string;
    description: string;
    time?: Duration;
    time_in_nanos: DurationValue<UnitNanos>;
    breakdown: SearchDfsStatisticsBreakdown;
    debug?: Record<string, any>;
    children?: SearchDfsStatisticsProfile[];
}
export interface SearchDirectGenerator {
    /** The field to fetch the candidate suggestions from.
      * Needs to be set globally or per suggestion. */
    field: Field;
    /** The maximum edit distance candidate suggestions can have in order to be considered as a suggestion.
      * Can only be `1` or `2`. */
    max_edits?: integer;
    /** A factor that is used to multiply with the shard_size in order to inspect more candidate spelling corrections on the shard level.
      * Can improve accuracy at the cost of performance. */
    max_inspections?: float;
    /** The maximum threshold in number of documents in which a suggest text token can exist in order to be included.
      * This can be used to exclude high frequency terms—which are usually spelled correctly—from being spellchecked.
      * Can be a relative percentage number (for example `0.4`) or an absolute number to represent document frequencies.
      * If a value higher than 1 is specified, then fractional can not be specified. */
    max_term_freq?: float;
    /** The minimal threshold in number of documents a suggestion should appear in.
      * This can improve quality by only suggesting high frequency terms.
      * Can be specified as an absolute number or as a relative percentage of number of documents.
      * If a value higher than 1 is specified, the number cannot be fractional. */
    min_doc_freq?: float;
    /** The minimum length a suggest text term must have in order to be included. */
    min_word_length?: integer;
    /** A filter (analyzer) that is applied to each of the generated tokens before they are passed to the actual phrase scorer. */
    post_filter?: string;
    /** A filter (analyzer) that is applied to each of the tokens passed to this candidate generator.
      * This filter is applied to the original token before candidates are generated. */
    pre_filter?: string;
    /** The number of minimal prefix characters that must match in order be a candidate suggestions.
      * Increasing this number improves spellcheck performance. */
    prefix_length?: integer;
    /** The maximum corrections to be returned per suggest text token. */
    size?: integer;
    /** Controls what suggestions are included on the suggestions generated on each shard. */
    suggest_mode?: SuggestMode;
}
export interface SearchFetchProfile {
    type: string;
    description: string;
    time_in_nanos: DurationValue<UnitNanos>;
    breakdown: SearchFetchProfileBreakdown;
    debug?: SearchFetchProfileDebug;
    children?: SearchFetchProfile[];
}
export interface SearchFetchProfileBreakdown {
    load_source?: integer;
    load_source_count?: integer;
    load_stored_fields?: integer;
    load_stored_fields_count?: integer;
    next_reader?: integer;
    next_reader_count?: integer;
    process_count?: integer;
    process?: integer;
}
export interface SearchFetchProfileDebug {
    stored_fields?: string[];
    fast_path?: integer;
}
export interface SearchFieldCollapse {
    /** The field to collapse the result set on */
    field: Field;
    /** The number of inner hits and their sort order */
    inner_hits?: SearchInnerHits | SearchInnerHits[];
    /** The number of concurrent requests allowed to retrieve the inner_hits per group */
    max_concurrent_group_searches?: integer;
    collapse?: SearchFieldCollapse;
}
export interface SearchFieldSuggester {
    /** Provides auto-complete/search-as-you-type functionality. */
    completion?: SearchCompletionSuggester;
    /** Provides access to word alternatives on a per token basis within a certain string distance. */
    phrase?: SearchPhraseSuggester;
    /** Suggests terms based on edit distance. */
    term?: SearchTermSuggester;
    /** Prefix used to search for suggestions. */
    prefix?: string;
    /** A prefix expressed as a regular expression. */
    regex?: string;
    /** The text to use as input for the suggester.
      * Needs to be set globally or per suggestion. */
    text?: string;
}
export interface SearchHighlight extends SearchHighlightBase {
    encoder?: SearchHighlighterEncoder;
    fields: Partial<Record<Field, SearchHighlightField>> | Partial<Record<Field, SearchHighlightField>>[];
}
export interface SearchHighlightBase {
    type?: SearchHighlighterType;
    /** A string that contains each boundary character. */
    boundary_chars?: string;
    /** How far to scan for boundary characters. */
    boundary_max_scan?: integer;
    /** Specifies how to break the highlighted fragments: chars, sentence, or word.
      * Only valid for the unified and fvh highlighters.
      * Defaults to `sentence` for the `unified` highlighter. Defaults to `chars` for the `fvh` highlighter. */
    boundary_scanner?: SearchBoundaryScanner;
    /** Controls which locale is used to search for sentence and word boundaries.
      * This parameter takes a form of a language tag, for example: `"en-US"`, `"fr-FR"`, `"ja-JP"`. */
    boundary_scanner_locale?: string;
    force_source?: boolean;
    /** Specifies how text should be broken up in highlight snippets: `simple` or `span`.
      * Only valid for the `plain` highlighter. */
    fragmenter?: SearchHighlighterFragmenter;
    /** The size of the highlighted fragment in characters. */
    fragment_size?: integer;
    highlight_filter?: boolean;
    /** Highlight matches for a query other than the search query.
      * This is especially useful if you use a rescore query because those are not taken into account by highlighting by default. */
    highlight_query?: QueryDslQueryContainer;
    max_fragment_length?: integer;
    /** If set to a non-negative value, highlighting stops at this defined maximum limit.
      * The rest of the text is not processed, thus not highlighted and no error is returned
      * The `max_analyzed_offset` query setting does not override the `index.highlight.max_analyzed_offset` setting, which prevails when it’s set to lower value than the query setting. */
    max_analyzed_offset?: integer;
    /** The amount of text you want to return from the beginning of the field if there are no matching fragments to highlight. */
    no_match_size?: integer;
    /** The maximum number of fragments to return.
      * If the number of fragments is set to `0`, no fragments are returned.
      * Instead, the entire field contents are highlighted and returned.
      * This can be handy when you need to highlight short texts such as a title or address, but fragmentation is not required.
      * If `number_of_fragments` is `0`, `fragment_size` is ignored. */
    number_of_fragments?: integer;
    options?: Record<string, any>;
    /** Sorts highlighted fragments by score when set to `score`.
      * By default, fragments will be output in the order they appear in the field (order: `none`).
      * Setting this option to `score` will output the most relevant fragments first.
      * Each highlighter applies its own logic to compute relevancy scores. */
    order?: SearchHighlighterOrder;
    /** Controls the number of matching phrases in a document that are considered.
      * Prevents the `fvh` highlighter from analyzing too many phrases and consuming too much memory.
      * When using `matched_fields`, `phrase_limit` phrases per matched field are considered. Raising the limit increases query time and consumes more memory.
      * Only supported by the `fvh` highlighter. */
    phrase_limit?: integer;
    /** Use in conjunction with `pre_tags` to define the HTML tags to use for the highlighted text.
      * By default, highlighted text is wrapped in `<em>` and `</em>` tags. */
    post_tags?: string[];
    /** Use in conjunction with `post_tags` to define the HTML tags to use for the highlighted text.
      * By default, highlighted text is wrapped in `<em>` and `</em>` tags. */
    pre_tags?: string[];
    /** By default, only fields that contains a query match are highlighted.
      * Set to `false` to highlight all fields. */
    require_field_match?: boolean;
    /** Set to `styled` to use the built-in tag schema. */
    tags_schema?: SearchHighlighterTagsSchema;
}
export interface SearchHighlightField extends SearchHighlightBase {
    fragment_offset?: integer;
    matched_fields?: Fields;
}
export type SearchHighlighterEncoder = 'default' | 'html';
export type SearchHighlighterFragmenter = 'simple' | 'span';
export type SearchHighlighterOrder = 'score';
export type SearchHighlighterTagsSchema = 'styled';
export type SearchHighlighterType = 'plain' | 'fvh' | 'unified' | string;
export interface SearchHit<TDocument = unknown> {
    _index: IndexName;
    _id?: Id;
    _score?: double | null;
    _explanation?: ExplainExplanation;
    fields?: Record<string, any>;
    highlight?: Record<string, string[]>;
    inner_hits?: Record<string, SearchInnerHitsResult>;
    matched_queries?: string[] | Record<string, double>;
    _nested?: SearchNestedIdentity;
    _ignored?: string[];
    ignored_field_values?: Record<string, any[]>;
    _shard?: string;
    _node?: string;
    _routing?: string;
    _source?: TDocument;
    _rank?: integer;
    _seq_no?: SequenceNumber;
    _primary_term?: long;
    _version?: VersionNumber;
    sort?: SortResults;
}
export interface SearchHitsMetadata<T = unknown> {
    /** Total hit count information, present only if `track_total_hits` wasn't `false` in the search request. */
    total?: SearchTotalHits | long;
    hits: SearchHit<T>[];
    max_score?: double | null;
}
export interface SearchInnerHits {
    /** The name for the particular inner hit definition in the response.
      * Useful when a search request contains multiple inner hits. */
    name?: Name;
    /** The maximum number of hits to return per `inner_hits`. */
    size?: integer;
    /** Inner hit starting document offset. */
    from?: integer;
    collapse?: SearchFieldCollapse;
    docvalue_fields?: (QueryDslFieldAndFormat | Field)[];
    explain?: boolean;
    highlight?: SearchHighlight;
    ignore_unmapped?: boolean;
    script_fields?: Record<Field, ScriptField>;
    seq_no_primary_term?: boolean;
    fields?: Field[];
    /** How the inner hits should be sorted per `inner_hits`.
      * By default, inner hits are sorted by score. */
    sort?: Sort;
    _source?: SearchSourceConfig;
    stored_fields?: Fields;
    track_scores?: boolean;
    version?: boolean;
}
export interface SearchInnerHitsResult {
    hits: SearchHitsMetadata<any>;
}
export interface SearchKnnCollectorResult {
    name: string;
    reason: string;
    time?: Duration;
    time_in_nanos: DurationValue<UnitNanos>;
    children?: SearchKnnCollectorResult[];
}
export interface SearchKnnQueryProfileBreakdown {
    advance: long;
    advance_count: long;
    build_scorer: long;
    build_scorer_count: long;
    compute_max_score: long;
    compute_max_score_count: long;
    count_weight: long;
    count_weight_count: long;
    create_weight: long;
    create_weight_count: long;
    match: long;
    match_count: long;
    next_doc: long;
    next_doc_count: long;
    score: long;
    score_count: long;
    set_min_competitive_score: long;
    set_min_competitive_score_count: long;
    shallow_advance: long;
    shallow_advance_count: long;
}
export interface SearchKnnQueryProfileResult {
    type: string;
    description: string;
    time?: Duration;
    time_in_nanos: DurationValue<UnitNanos>;
    breakdown: SearchKnnQueryProfileBreakdown;
    debug?: Record<string, any>;
    children?: SearchKnnQueryProfileResult[];
}
export interface SearchLaplaceSmoothingModel {
    /** A constant that is added to all counts to balance weights. */
    alpha: double;
}
export interface SearchLearningToRank {
    /** The unique identifier of the trained model uploaded to Elasticsearch */
    model_id: string;
    /** Named parameters to be passed to the query templates used for feature */
    params?: Record<string, any>;
}
export interface SearchLinearInterpolationSmoothingModel {
    bigram_lambda: double;
    trigram_lambda: double;
    unigram_lambda: double;
}
export interface SearchNestedIdentity {
    field: Field;
    offset: integer;
    _nested?: SearchNestedIdentity;
}
export interface SearchPhraseSuggest extends SearchSuggestBase {
    options: SearchPhraseSuggestOption | SearchPhraseSuggestOption[];
}
export interface SearchPhraseSuggestCollate {
    /** Parameters to use if the query is templated. */
    params?: Record<string, any>;
    /** Returns all suggestions with an extra `collate_match` option indicating whether the generated phrase matched any document. */
    prune?: boolean;
    /** A collate query that is run once for every suggestion. */
    query: SearchPhraseSuggestCollateQuery;
}
export interface SearchPhraseSuggestCollateQuery {
    /** The search template ID. */
    id?: Id;
    /** The query source. */
    source?: ScriptSource;
}
export interface SearchPhraseSuggestHighlight {
    /** Use in conjunction with `pre_tag` to define the HTML tags to use for the highlighted text. */
    post_tag: string;
    /** Use in conjunction with `post_tag` to define the HTML tags to use for the highlighted text. */
    pre_tag: string;
}
export interface SearchPhraseSuggestOption {
    text: string;
    score: double;
    highlighted?: string;
    collate_match?: boolean;
}
export interface SearchPhraseSuggester extends SearchSuggesterBase {
    /** Checks each suggestion against the specified query to prune suggestions for which no matching docs exist in the index. */
    collate?: SearchPhraseSuggestCollate;
    /** Defines a factor applied to the input phrases score, which is used as a threshold for other suggest candidates.
      * Only candidates that score higher than the threshold will be included in the result. */
    confidence?: double;
    /** A list of candidate generators that produce a list of possible terms per term in the given text. */
    direct_generator?: SearchDirectGenerator[];
    force_unigrams?: boolean;
    /** Sets max size of the n-grams (shingles) in the field.
      * If the field doesn’t contain n-grams (shingles), this should be omitted or set to `1`.
      * If the field uses a shingle filter, the `gram_size` is set to the `max_shingle_size` if not explicitly set. */
    gram_size?: integer;
    /** Sets up suggestion highlighting.
      * If not provided, no highlighted field is returned. */
    highlight?: SearchPhraseSuggestHighlight;
    /** The maximum percentage of the terms considered to be misspellings in order to form a correction.
      * This method accepts a float value in the range `[0..1)` as a fraction of the actual query terms or a number `>=1` as an absolute number of query terms. */
    max_errors?: double;
    /** The likelihood of a term being misspelled even if the term exists in the dictionary. */
    real_word_error_likelihood?: double;
    /** The separator that is used to separate terms in the bigram field.
      * If not set, the whitespace character is used as a separator. */
    separator?: string;
    /** Sets the maximum number of suggested terms to be retrieved from each individual shard. */
    shard_size?: integer;
    /** The smoothing model used to balance weight between infrequent grams (grams (shingles) are not existing in the index) and frequent grams (appear at least once in the index).
      * The default model is Stupid Backoff. */
    smoothing?: SearchSmoothingModelContainer;
    /** The text/query to provide suggestions for. */
    text?: string;
    token_limit?: integer;
}
export interface SearchPointInTimeReference {
    id: Id;
    keep_alive?: Duration;
}
export interface SearchProfile {
    shards: SearchShardProfile[];
}
export interface SearchQueryBreakdown {
    advance: long;
    advance_count: long;
    build_scorer: long;
    build_scorer_count: long;
    create_weight: long;
    create_weight_count: long;
    match: long;
    match_count: long;
    shallow_advance: long;
    shallow_advance_count: long;
    next_doc: long;
    next_doc_count: long;
    score: long;
    score_count: long;
    compute_max_score: long;
    compute_max_score_count: long;
    count_weight: long;
    count_weight_count: long;
    set_min_competitive_score: long;
    set_min_competitive_score_count: long;
}
export interface SearchQueryProfile {
    breakdown: SearchQueryBreakdown;
    description: string;
    time_in_nanos: DurationValue<UnitNanos>;
    type: string;
    children?: SearchQueryProfile[];
}
export interface SearchRegexOptions {
    /** Optional operators for the regular expression. */
    flags?: integer | string;
    /** Maximum number of automaton states required for the query. */
    max_determinized_states?: integer;
}
export interface SearchRescore {
    window_size?: integer;
    query?: SearchRescoreQuery;
    learning_to_rank?: SearchLearningToRank;
}
export interface SearchRescoreQuery {
    /** The query to use for rescoring.
      * This query is only run on the Top-K results returned by the `query` and `post_filter` phases. */
    rescore_query: QueryDslQueryContainer;
    /** Relative importance of the original query versus the rescore query. */
    query_weight?: double;
    /** Relative importance of the rescore query versus the original query. */
    rescore_query_weight?: double;
    /** Determines how scores are combined. */
    score_mode?: SearchScoreMode;
}
export type SearchScoreMode = 'avg' | 'max' | 'min' | 'multiply' | 'total';
export interface SearchSearchProfile {
    collector: SearchCollector[];
    query: SearchQueryProfile[];
    rewrite_time: long;
}
export interface SearchSearchRequestBody {
    /** Defines the aggregations that are run as part of the search request. */
    aggregations?: Record<string, AggregationsAggregationContainer>;
    /** Defines the aggregations that are run as part of the search request.
      * @alias aggregations */
    aggs?: Record<string, AggregationsAggregationContainer>;
    /** Collapses search results the values of the specified field. */
    collapse?: SearchFieldCollapse;
    /** If `true`, the request returns detailed information about score computation as part of a hit. */
    explain?: boolean;
    /** Configuration of search extensions defined by Elasticsearch plugins. */
    ext?: Record<string, any>;
    /** The starting document offset, which must be non-negative.
      * By default, you cannot page through more than 10,000 hits using the `from` and `size` parameters.
      * To page through more hits, use the `search_after` parameter. */
    from?: integer;
    /** Specifies the highlighter to use for retrieving highlighted snippets from one or more fields in your search results. */
    highlight?: SearchHighlight;
    /** Number of hits matching the query to count accurately.
      * If `true`, the exact number of hits is returned at the cost of some performance.
      * If `false`, the  response does not include the total number of hits matching the query. */
    track_total_hits?: SearchTrackHits;
    /** Boost the `_score` of documents from specified indices.
      * The boost value is the factor by which scores are multiplied.
      * A boost value greater than `1.0` increases the score.
      * A boost value between `0` and `1.0` decreases the score. */
    indices_boost?: Partial<Record<IndexName, double>>[];
    /** An array of wildcard (`*`) field patterns.
      * The request returns doc values for field names matching these patterns in the `hits.fields` property of the response. */
    docvalue_fields?: (QueryDslFieldAndFormat | Field)[];
    /** The approximate kNN search to run. */
    knn?: KnnSearch | KnnSearch[];
    /** The Reciprocal Rank Fusion (RRF) to use.
      * @remarks This property is not supported on Elastic Cloud Serverless. */
    rank?: RankContainer;
    /** The minimum `_score` for matching documents.
      * Documents with a lower `_score` are not included in search results or results collected by aggregations. */
    min_score?: double;
    /** Use the `post_filter` parameter to filter search results.
      * The search hits are filtered after the aggregations are calculated.
      * A post filter has no impact on the aggregation results. */
    post_filter?: QueryDslQueryContainer;
    /** Set to `true` to return detailed timing information about the execution of individual components in a search request.
      * NOTE: This is a debugging tool and adds significant overhead to search execution. */
    profile?: boolean;
    /** The search definition using the Query DSL. */
    query?: QueryDslQueryContainer;
    /** Can be used to improve precision by reordering just the top (for example 100 - 500) documents returned by the `query` and `post_filter` phases. */
    rescore?: SearchRescore | SearchRescore[];
    /** A retriever is a specification to describe top documents returned from a search.
      * A retriever replaces other elements of the search API that also return top documents such as `query` and `knn`. */
    retriever?: RetrieverContainer;
    /** Retrieve a script evaluation (based on different fields) for each hit. */
    script_fields?: Record<string, ScriptField>;
    /** Used to retrieve the next page of hits using a set of sort values from the previous page. */
    search_after?: SortResults;
    /** The number of hits to return, which must not be negative.
      * By default, you cannot page through more than 10,000 hits using the `from` and `size` parameters.
      * To page through more hits, use the `search_after` property. */
    size?: integer;
    /** Split a scrolled search into multiple slices that can be consumed independently. */
    slice?: SlicedScroll;
    /** A comma-separated list of <field>:<direction> pairs. */
    sort?: Sort;
    /** The source fields that are returned for matching documents.
      * These fields are returned in the `hits._source` property of the search response.
      * If the `stored_fields` property is specified, the `_source` property defaults to `false`.
      * Otherwise, it defaults to `true`. */
    _source?: SearchSourceConfig;
    /** An array of wildcard (`*`) field patterns.
      * The request returns values for field names matching these patterns in the `hits.fields` property of the response. */
    fields?: (QueryDslFieldAndFormat | Field)[];
    /** Defines a suggester that provides similar looking terms based on a provided text. */
    suggest?: SearchSuggester;
    /** The maximum number of documents to collect for each shard.
      * If a query reaches this limit, Elasticsearch terminates the query early.
      * Elasticsearch collects documents before sorting.
      *
      * IMPORTANT: Use with caution.
      * Elasticsearch applies this property to each shard handling the request.
      * When possible, let Elasticsearch perform early termination automatically.
      * Avoid specifying this property for requests that target data streams with backing indices across multiple data tiers.
      *
      * If set to `0` (default), the query does not terminate early. */
    terminate_after?: long;
    /** The period of time to wait for a response from each shard.
      * If no response is received before the timeout expires, the request fails and returns an error.
      * Defaults to no timeout. */
    timeout?: string;
    /** If `true`, calculate and return document scores, even if the scores are not used for sorting. */
    track_scores?: boolean;
    /** If `true`, the request returns the document version as part of a hit. */
    version?: boolean;
    /** If `true`, the request returns sequence number and primary term of the last modification of each hit. */
    seq_no_primary_term?: boolean;
    /** A comma-separated list of stored fields to return as part of a hit.
      * If no fields are specified, no stored fields are included in the response.
      * If this field is specified, the `_source` property defaults to `false`.
      * You can pass `_source: true` to return both source fields and stored fields in the search response. */
    stored_fields?: Fields;
    /** Limit the search to a point in time (PIT).
      * If you provide a PIT, you cannot specify an `<index>` in the request path. */
    pit?: SearchPointInTimeReference;
    /** One or more runtime fields in the search request.
      * These fields take precedence over mapped fields with the same name. */
    runtime_mappings?: MappingRuntimeFields;
    /** The stats groups to associate with the search.
      * Each group maintains a statistics aggregation for its associated searches.
      * You can retrieve these stats using the indices stats API. */
    stats?: string[];
}
export interface SearchShardProfile {
    aggregations: SearchAggregationProfile[];
    cluster: string;
    dfs?: SearchDfsProfile;
    fetch?: SearchFetchProfile;
    id: string;
    index: IndexName;
    node_id: NodeId;
    searches: SearchSearchProfile[];
    shard_id: integer;
}
export interface SearchSmoothingModelContainer {
    /** A smoothing model that uses an additive smoothing where a constant (typically `1.0` or smaller) is added to all counts to balance weights. */
    laplace?: SearchLaplaceSmoothingModel;
    /** A smoothing model that takes the weighted mean of the unigrams, bigrams, and trigrams based on user supplied weights (lambdas). */
    linear_interpolation?: SearchLinearInterpolationSmoothingModel;
    /** A simple backoff model that backs off to lower order n-gram models if the higher order count is `0` and discounts the lower order n-gram model by a constant factor. */
    stupid_backoff?: SearchStupidBackoffSmoothingModel;
}
export type SearchSourceConfig = boolean | SearchSourceFilter | Fields;
export type SearchSourceConfigParam = boolean | Fields;
export interface SearchSourceFilter {
    /** If `true`, vector fields are excluded from the returned source.
      *
      * This option takes precedence over `includes`: any vector field will
      * remain excluded even if it matches an `includes` rule. */
    exclude_vectors?: boolean;
    /** A list of fields to exclude from the returned source. */
    excludes?: Fields;
    /** A list of fields to exclude from the returned source.
      * @alias excludes */
    exclude?: Fields;
    /** A list of fields to include in the returned source. */
    includes?: Fields;
    /** A list of fields to include in the returned source.
      * @alias includes */
    include?: Fields;
}
export type SearchStringDistance = 'internal' | 'damerau_levenshtein' | 'levenshtein' | 'jaro_winkler' | 'ngram';
export interface SearchStupidBackoffSmoothingModel {
    /** A constant factor that the lower order n-gram model is discounted by. */
    discount: double;
}
export type SearchSuggest<TDocument = unknown> = SearchCompletionSuggest<TDocument> | SearchPhraseSuggest | SearchTermSuggest;
export interface SearchSuggestBase {
    length: integer;
    offset: integer;
    text: string;
}
export interface SearchSuggestFuzziness {
    /** The fuzziness factor. */
    fuzziness?: Fuzziness;
    /** Minimum length of the input before fuzzy suggestions are returned. */
    min_length?: integer;
    /** Minimum length of the input, which is not checked for fuzzy alternatives. */
    prefix_length?: integer;
    /** If set to `true`, transpositions are counted as one change instead of two. */
    transpositions?: boolean;
    /** If `true`, all measurements (like fuzzy edit distance, transpositions, and lengths) are measured in Unicode code points instead of in bytes.
      * This is slightly slower than raw bytes. */
    unicode_aware?: boolean;
}
export type SearchSuggestSort = 'score' | 'frequency';
export interface SearchSuggesterKeys {
    /** Global suggest text, to avoid repetition when the same text is used in several suggesters */
    text?: string;
}
export type SearchSuggester = SearchSuggesterKeys & {
    [property: string]: SearchFieldSuggester | string;
};
export interface SearchSuggesterBase {
    /** The field to fetch the candidate suggestions from.
      * Needs to be set globally or per suggestion. */
    field: Field;
    /** The analyzer to analyze the suggest text with.
      * Defaults to the search analyzer of the suggest field. */
    analyzer?: string;
    /** The maximum corrections to be returned per suggest text token. */
    size?: integer;
}
export interface SearchTermSuggest extends SearchSuggestBase {
    options: SearchTermSuggestOption | SearchTermSuggestOption[];
}
export interface SearchTermSuggestOption {
    text: string;
    score: double;
    freq: long;
    highlighted?: string;
    collate_match?: boolean;
}
export interface SearchTermSuggester extends SearchSuggesterBase {
    lowercase_terms?: boolean;
    /** The maximum edit distance candidate suggestions can have in order to be considered as a suggestion.
      * Can only be `1` or `2`. */
    max_edits?: integer;
    /** A factor that is used to multiply with the shard_size in order to inspect more candidate spelling corrections on the shard level.
      * Can improve accuracy at the cost of performance. */
    max_inspections?: integer;
    /** The maximum threshold in number of documents in which a suggest text token can exist in order to be included.
      * Can be a relative percentage number (for example `0.4`) or an absolute number to represent document frequencies.
      * If a value higher than 1 is specified, then fractional can not be specified. */
    max_term_freq?: float;
    /** The minimal threshold in number of documents a suggestion should appear in.
      * This can improve quality by only suggesting high frequency terms.
      * Can be specified as an absolute number or as a relative percentage of number of documents.
      * If a value higher than 1 is specified, then the number cannot be fractional. */
    min_doc_freq?: float;
    /** The minimum length a suggest text term must have in order to be included. */
    min_word_length?: integer;
    /** The number of minimal prefix characters that must match in order be a candidate for suggestions.
      * Increasing this number improves spellcheck performance. */
    prefix_length?: integer;
    /** Sets the maximum number of suggestions to be retrieved from each individual shard. */
    shard_size?: integer;
    /** Defines how suggestions should be sorted per suggest text term. */
    sort?: SearchSuggestSort;
    /** The string distance implementation to use for comparing how similar suggested terms are. */
    string_distance?: SearchStringDistance;
    /** Controls what suggestions are included or controls for what suggest text terms, suggestions should be suggested. */
    suggest_mode?: SuggestMode;
    /** The suggest text.
      * Needs to be set globally or per suggestion. */
    text?: string;
}
export interface SearchTotalHits {
    relation: SearchTotalHitsRelation;
    value: long;
}
export type SearchTotalHitsRelation = 'eq' | 'gte';
export type SearchTrackHits = boolean | integer;
export interface SearchMvtRequest extends RequestBase {
    /** Comma-separated list of data streams, indices, or aliases to search */
    index: Indices;
    /** Field containing geospatial data to return */
    field: Field;
    /** Zoom level for the vector tile to search */
    zoom: SearchMvtZoomLevel;
    /** X coordinate for the vector tile to search */
    x: SearchMvtCoordinate;
    /** Y coordinate for the vector tile to search */
    y: SearchMvtCoordinate;
    /** Sub-aggregations for the geotile_grid.
      *
      * It supports the following aggregation types:
      *
      * - `avg`
      * - `boxplot`
      * - `cardinality`
      * - `extended stats`
      * - `max`
      * - `median absolute deviation`
      * - `min`
      * - `percentile`
      * - `percentile-rank`
      * - `stats`
      * - `sum`
      * - `value count`
      *
      * The aggregation names can't start with `_mvt_`. The `_mvt_` prefix is reserved for internal aggregations. */
    aggs?: Record<string, AggregationsAggregationContainer>;
    /** The size, in pixels, of a clipping buffer outside the tile. This allows renderers
      * to avoid outline artifacts from geometries that extend past the extent of the tile. */
    buffer?: integer;
    /** If `false`, the meta layer's feature is the bounding box of the tile.
      * If `true`, the meta layer's feature is a bounding box resulting from a
      * `geo_bounds` aggregation. The aggregation runs on <field> values that intersect
      * the `<zoom>/<x>/<y>` tile with `wrap_longitude` set to `false`. The resulting
      * bounding box may be larger than the vector tile. */
    exact_bounds?: boolean;
    /** The size, in pixels, of a side of the tile. Vector tiles are square with equal sides. */
    extent?: integer;
    /** The fields to return in the `hits` layer.
      * It supports wildcards (`*`).
      * This parameter does not support fields with array values. Fields with array
      * values may return inconsistent results. */
    fields?: Fields;
    /** The aggregation used to create a grid for the `field`. */
    grid_agg?: SearchMvtGridAggregationType;
    /** Additional zoom levels available through the aggs layer. For example, if `<zoom>` is `7`
      * and `grid_precision` is `8`, you can zoom in up to level 15. Accepts 0-8. If 0, results
      * don't include the aggs layer. */
    grid_precision?: integer;
    /** Determines the geometry type for features in the aggs layer. In the aggs layer,
      * each feature represents a `geotile_grid` cell. If `grid, each feature is a polygon
      * of the cells bounding box. If `point`, each feature is a Point that is the centroid
      * of the cell. */
    grid_type?: SearchMvtGridType;
    /** The query DSL used to filter documents for the search. */
    query?: QueryDslQueryContainer;
    /** Defines one or more runtime fields in the search request. These fields take
      * precedence over mapped fields with the same name. */
    runtime_mappings?: MappingRuntimeFields;
    /** The maximum number of features to return in the hits layer. Accepts 0-10000.
      * If 0, results don't include the hits layer. */
    size?: integer;
    /** Sort the features in the hits layer. By default, the API calculates a bounding
      * box for each feature. It sorts features based on this box's diagonal length,
      * from longest to shortest. */
    sort?: Sort;
    /** The number of hits matching the query to count accurately. If `true`, the exact number
      * of hits is returned at the cost of some performance. If `false`, the response does
      * not include the total number of hits matching the query. */
    track_total_hits?: SearchTrackHits;
    /** If `true`, the hits and aggs layers will contain additional point features representing
      * suggested label positions for the original features.
      *
      * * `Point` and `MultiPoint` features will have one of the points selected.
      * * `Polygon` and `MultiPolygon` features will have a single point generated, either the centroid, if it is within the polygon, or another point within the polygon selected from the sorted triangle-tree.
      * * `LineString` features will likewise provide a roughly central point selected from the triangle-tree.
      * * The aggregation results will provide one central point for each aggregation bucket.
      *
      * All attributes from the original features will also be copied to the new label features.
      * In addition, the new features will be distinguishable using the tag `_mvt_label_position`. */
    with_labels?: boolean;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
        field?: never;
        zoom?: never;
        x?: never;
        y?: never;
        aggs?: never;
        buffer?: never;
        exact_bounds?: never;
        extent?: never;
        fields?: never;
        grid_agg?: never;
        grid_precision?: never;
        grid_type?: never;
        query?: never;
        runtime_mappings?: never;
        size?: never;
        sort?: never;
        track_total_hits?: never;
        with_labels?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
        field?: never;
        zoom?: never;
        x?: never;
        y?: never;
        aggs?: never;
        buffer?: never;
        exact_bounds?: never;
        extent?: never;
        fields?: never;
        grid_agg?: never;
        grid_precision?: never;
        grid_type?: never;
        query?: never;
        runtime_mappings?: never;
        size?: never;
        sort?: never;
        track_total_hits?: never;
        with_labels?: never;
    };
}
export type SearchMvtResponse = MapboxVectorTiles;
export type SearchMvtCoordinate = integer;
export type SearchMvtGridAggregationType = 'geotile' | 'geohex';
export type SearchMvtGridType = 'grid' | 'point' | 'centroid';
export type SearchMvtZoomLevel = integer;
export interface SearchShardsRequest extends RequestBase {
    /** A comma-separated list of data streams, indices, and aliases to search.
      * It supports wildcards (`*`).
      * To search all data streams and indices, omit this parameter or use `*` or `_all`. */
    index?: Indices;
    /** If `false`, the request returns an error if any wildcard expression, index alias, or `_all` value targets only missing or closed indices.
      * This behavior applies even if the request targets other open indices.
      * For example, a request targeting `foo*,bar*` returns an error if an index starts with `foo` but no index starts with `bar`. */
    allow_no_indices?: boolean;
    /** Type of index that wildcard patterns can match.
      * If the request can target data streams, this argument determines whether wildcard expressions match hidden data streams.
      * Supports comma-separated values, such as `open,hidden`. */
    expand_wildcards?: ExpandWildcards;
    /** If `false`, the request returns an error if it targets a missing or closed index. */
    ignore_unavailable?: boolean;
    /** If `true`, the request retrieves information from the local node only. */
    local?: boolean;
    /** The period to wait for a connection to the master node.
      * If the master node is not available before the timeout expires, the request fails and returns an error.
      * IT can also be set to `-1` to indicate that the request should never timeout. */
    master_timeout?: Duration;
    /** The node or shard the operation should be performed on.
      * It is random by default. */
    preference?: string;
    /** A custom value used to route operations to a specific shard. */
    routing?: Routing;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
        allow_no_indices?: never;
        expand_wildcards?: never;
        ignore_unavailable?: never;
        local?: never;
        master_timeout?: never;
        preference?: never;
        routing?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
        allow_no_indices?: never;
        expand_wildcards?: never;
        ignore_unavailable?: never;
        local?: never;
        master_timeout?: never;
        preference?: never;
        routing?: never;
    };
}
export interface SearchShardsResponse {
    nodes: Record<NodeId, SearchShardsSearchShardsNodeAttributes>;
    shards: NodeShard[][];
    indices: Record<IndexName, SearchShardsShardStoreIndex>;
}
export interface SearchShardsSearchShardsNodeAttributes {
    /** The human-readable identifier of the node. */
    name: NodeName;
    /** The ephemeral ID of the node. */
    ephemeral_id: Id;
    /** The host and port where transport HTTP connections are accepted. */
    transport_address: TransportAddress;
    external_id: string;
    /** Lists node attributes. */
    attributes: Record<string, string>;
    roles: NodeRoles;
    version: VersionString;
    min_index_version: integer;
    max_index_version: integer;
}
export interface SearchShardsShardStoreIndex {
    aliases?: Name[];
    filter?: QueryDslQueryContainer;
}
export interface SearchTemplateRequest extends RequestBase {
    /** A comma-separated list of data streams, indices, and aliases to search.
      * It supports wildcards (`*`). */
    index?: Indices;
    /** If `false`, the request returns an error if any wildcard expression, index alias, or `_all` value targets only missing or closed indices.
      * This behavior applies even if the request targets other open indices.
      * For example, a request targeting `foo*,bar*` returns an error if an index starts with `foo` but no index starts with `bar`. */
    allow_no_indices?: boolean;
    /** If `true`, network round-trips are minimized for cross-cluster search requests. */
    ccs_minimize_roundtrips?: boolean;
    /** The type of index that wildcard patterns can match.
      * If the request can target data streams, this argument determines whether wildcard expressions match hidden data streams.
      * Supports comma-separated values, such as `open,hidden`. */
    expand_wildcards?: ExpandWildcards;
    /** If `true`, specified concrete, expanded, or aliased indices are not included in the response when throttled. */
    ignore_throttled?: boolean;
    /** If `false`, the request returns an error if it targets a missing or closed index. */
    ignore_unavailable?: boolean;
    /** The node or shard the operation should be performed on.
      * It is random by default. */
    preference?: string;
    /** A custom value used to route operations to a specific shard. */
    routing?: Routing;
    /** Specifies how long a consistent view of the index
      * should be maintained for scrolled search. */
    scroll?: Duration;
    /** The type of the search operation. */
    search_type?: SearchType;
    /** If `true`, `hits.total` is rendered as an integer in the response.
      * If `false`, it is rendered as an object. */
    rest_total_hits_as_int?: boolean;
    /** If `true`, the response prefixes aggregation and suggester names with their respective types. */
    typed_keys?: boolean;
    /** If `true`, returns detailed information about score calculation as part of each hit.
      * If you specify both this and the `explain` query parameter, the API uses only the query parameter. */
    explain?: boolean;
    /** The ID of the search template to use. If no `source` is specified,
      * this parameter is required. */
    id?: Id;
    /** Key-value pairs used to replace Mustache variables in the template.
      * The key is the variable name.
      * The value is the variable value. */
    params?: Record<string, any>;
    /** If `true`, the query execution is profiled. */
    profile?: boolean;
    /** An inline search template. Supports the same parameters as the search API's
      * request body. It also supports Mustache variables. If no `id` is specified, this
      * parameter is required. */
    source?: ScriptSource;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
        allow_no_indices?: never;
        ccs_minimize_roundtrips?: never;
        expand_wildcards?: never;
        ignore_throttled?: never;
        ignore_unavailable?: never;
        preference?: never;
        routing?: never;
        scroll?: never;
        search_type?: never;
        rest_total_hits_as_int?: never;
        typed_keys?: never;
        explain?: never;
        id?: never;
        params?: never;
        profile?: never;
        source?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
        allow_no_indices?: never;
        ccs_minimize_roundtrips?: never;
        expand_wildcards?: never;
        ignore_throttled?: never;
        ignore_unavailable?: never;
        preference?: never;
        routing?: never;
        scroll?: never;
        search_type?: never;
        rest_total_hits_as_int?: never;
        typed_keys?: never;
        explain?: never;
        id?: never;
        params?: never;
        profile?: never;
        source?: never;
    };
}
export interface SearchTemplateResponse<TDocument = unknown> {
    took: long;
    timed_out: boolean;
    _shards: ShardStatistics;
    hits: SearchHitsMetadata<TDocument>;
    aggregations?: Record<AggregateName, AggregationsAggregate>;
    _clusters?: ClusterStatistics;
    fields?: Record<string, any>;
    max_score?: double;
    num_reduce_phases?: long;
    profile?: SearchProfile;
    pit_id?: Id;
    _scroll_id?: ScrollId;
    suggest?: Record<SuggestionName, SearchSuggest<TDocument>[]>;
    terminated_early?: boolean;
}
export interface TermsEnumRequest extends RequestBase {
    /** A comma-separated list of data streams, indices, and index aliases to search.
      * Wildcard (`*`) expressions are supported.
      * To search all data streams or indices, omit this parameter or use `*`  or `_all`. */
    index: IndexName;
    /** The string to match at the start of indexed terms. If not provided, all terms in the field are considered. */
    field: Field;
    /** The number of matching terms to return. */
    size?: integer;
    /** The maximum length of time to spend collecting results.
      * If the timeout is exceeded the `complete` flag set to `false` in the response and the results may be partial or empty. */
    timeout?: Duration;
    /** When `true`, the provided search string is matched against index terms without case sensitivity. */
    case_insensitive?: boolean;
    /** Filter an index shard if the provided query rewrites to `match_none`. */
    index_filter?: QueryDslQueryContainer;
    /** The string to match at the start of indexed terms.
      * If it is not provided, all terms in the field are considered.
      *
      * > info
      * > The prefix string cannot be larger than the largest possible keyword value, which is Lucene's term byte-length limit of 32766. */
    string?: string;
    /** The string after which terms in the index should be returned.
      * It allows for a form of pagination if the last result from one request is passed as the `search_after` parameter for a subsequent request. */
    search_after?: string;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
        field?: never;
        size?: never;
        timeout?: never;
        case_insensitive?: never;
        index_filter?: never;
        string?: never;
        search_after?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
        field?: never;
        size?: never;
        timeout?: never;
        case_insensitive?: never;
        index_filter?: never;
        string?: never;
        search_after?: never;
    };
}
export interface TermsEnumResponse {
    _shards: ShardStatistics;
    terms: string[];
    /** If `false`, the returned terms set may be incomplete and should be treated as approximate.
      * This can occur due to a few reasons, such as a request timeout or a node error. */
    complete: boolean;
}
export interface TermvectorsFieldStatistics {
    doc_count: integer;
    sum_doc_freq: long;
    sum_ttf: long;
}
export interface TermvectorsFilter {
    /** Ignore words which occur in more than this many docs.
      * Defaults to unbounded. */
    max_doc_freq?: integer;
    /** The maximum number of terms that must be returned per field. */
    max_num_terms?: integer;
    /** Ignore words with more than this frequency in the source doc.
      * It defaults to unbounded. */
    max_term_freq?: integer;
    /** The maximum word length above which words will be ignored.
      * Defaults to unbounded. */
    max_word_length?: integer;
    /** Ignore terms which do not occur in at least this many docs. */
    min_doc_freq?: integer;
    /** Ignore words with less than this frequency in the source doc. */
    min_term_freq?: integer;
    /** The minimum word length below which words will be ignored. */
    min_word_length?: integer;
}
export interface TermvectorsRequest<TDocument = unknown> extends RequestBase {
    /** The name of the index that contains the document. */
    index: IndexName;
    /** A unique identifier for the document. */
    id?: Id;
    /** The node or shard the operation should be performed on.
      * It is random by default. */
    preference?: string;
    /** If true, the request is real-time as opposed to near-real-time. */
    realtime?: boolean;
    /** An artificial document (a document not present in the index) for which you want to retrieve term vectors. */
    doc?: TDocument;
    /** Filter terms based on their tf-idf scores.
      * This could be useful in order find out a good characteristic vector of a document.
      * This feature works in a similar manner to the second phase of the More Like This Query. */
    filter?: TermvectorsFilter;
    /** Override the default per-field analyzer.
      * This is useful in order to generate term vectors in any fashion, especially when using artificial documents.
      * When providing an analyzer for a field that already stores term vectors, the term vectors will be regenerated. */
    per_field_analyzer?: Record<Field, string>;
    /** A list of fields to include in the statistics.
      * It is used as the default list unless a specific field list is provided in the `completion_fields` or `fielddata_fields` parameters. */
    fields?: Fields;
    /** If `true`, the response includes:
      *
      * * The document count (how many documents contain this field).
      * * The sum of document frequencies (the sum of document frequencies for all terms in this field).
      * * The sum of total term frequencies (the sum of total term frequencies of each term in this field). */
    field_statistics?: boolean;
    /** If `true`, the response includes term offsets. */
    offsets?: boolean;
    /** If `true`, the response includes term payloads. */
    payloads?: boolean;
    /** If `true`, the response includes term positions. */
    positions?: boolean;
    /** If `true`, the response includes:
      *
      * * The total term frequency (how often a term occurs in all documents).
      * * The document frequency (the number of documents containing the current term).
      *
      * By default these values are not returned since term statistics can have a serious performance impact. */
    term_statistics?: boolean;
    /** A custom value that is used to route operations to a specific shard. */
    routing?: Routing;
    /** If `true`, returns the document version as part of a hit. */
    version?: VersionNumber;
    /** The version type. */
    version_type?: VersionType;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
        id?: never;
        preference?: never;
        realtime?: never;
        doc?: never;
        filter?: never;
        per_field_analyzer?: never;
        fields?: never;
        field_statistics?: never;
        offsets?: never;
        payloads?: never;
        positions?: never;
        term_statistics?: never;
        routing?: never;
        version?: never;
        version_type?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
        id?: never;
        preference?: never;
        realtime?: never;
        doc?: never;
        filter?: never;
        per_field_analyzer?: never;
        fields?: never;
        field_statistics?: never;
        offsets?: never;
        payloads?: never;
        positions?: never;
        term_statistics?: never;
        routing?: never;
        version?: never;
        version_type?: never;
    };
}
export interface TermvectorsResponse {
    found: boolean;
    _id?: Id;
    _index: IndexName;
    term_vectors?: Record<Field, TermvectorsTermVector>;
    took: long;
    _version: VersionNumber;
}
export interface TermvectorsTerm {
    doc_freq?: integer;
    score?: double;
    term_freq: integer;
    tokens?: TermvectorsToken[];
    ttf?: integer;
}
export interface TermvectorsTermVector {
    field_statistics?: TermvectorsFieldStatistics;
    terms: Record<string, TermvectorsTerm>;
}
export interface TermvectorsToken {
    end_offset?: integer;
    payload?: string;
    position: integer;
    start_offset?: integer;
}
export interface UpdateRequest<TDocument = unknown, TPartialDocument = unknown> extends RequestBase {
    /** A unique identifier for the document to be updated. */
    id: Id;
    /** The name of the target index.
      * By default, the index is created automatically if it doesn't exist. */
    index: IndexName;
    /** Only perform the operation if the document has this primary term. */
    if_primary_term?: long;
    /** Only perform the operation if the document has this sequence number. */
    if_seq_no?: SequenceNumber;
    /** True or false if to include the document source in the error message in case of parsing errors. */
    include_source_on_error?: boolean;
    /** The script language. */
    lang?: string;
    /** If 'true', Elasticsearch refreshes the affected shards to make this operation visible to search.
      * If 'wait_for', it waits for a refresh to make this operation visible to search.
      * If 'false', it does nothing with refreshes. */
    refresh?: Refresh;
    /** If `true`, the destination must be an index alias. */
    require_alias?: boolean;
    /** The number of times the operation should be retried when a conflict occurs. */
    retry_on_conflict?: integer;
    /** A custom value used to route operations to a specific shard. */
    routing?: Routing;
    /** The period to wait for the following operations: dynamic mapping updates and waiting for active shards.
      * Elasticsearch waits for at least the timeout period before failing.
      * The actual wait time could be longer, particularly when multiple waits occur. */
    timeout?: Duration;
    /** The number of copies of each shard that must be active before proceeding with the operation.
      * Set to 'all' or any positive integer up to the total number of shards in the index (`number_of_replicas`+1).
      * The default value of `1` means it waits for each primary shard to be active. */
    wait_for_active_shards?: WaitForActiveShards;
    /** The source fields you want to exclude. */
    _source_excludes?: Fields;
    /** The source fields you want to retrieve. */
    _source_includes?: Fields;
    /** If `true`, the `result` in the response is set to `noop` (no operation) when there are no changes to the document. */
    detect_noop?: boolean;
    /** A partial update to an existing document.
      * If both `doc` and `script` are specified, `doc` is ignored. */
    doc?: TPartialDocument;
    /** If `true`, use the contents of 'doc' as the value of 'upsert'.
      * NOTE: Using ingest pipelines with `doc_as_upsert` is not supported. */
    doc_as_upsert?: boolean;
    /** The script to run to update the document. */
    script?: Script | ScriptSource;
    /** If `true`, run the script whether or not the document exists. */
    scripted_upsert?: boolean;
    /** If `false`, turn off source retrieval.
      * You can also specify a comma-separated list of the fields you want to retrieve. */
    _source?: SearchSourceConfig;
    /** If the document does not already exist, the contents of 'upsert' are inserted as a new document.
      * If the document exists, the 'script' is run. */
    upsert?: TDocument;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        id?: never;
        index?: never;
        if_primary_term?: never;
        if_seq_no?: never;
        include_source_on_error?: never;
        lang?: never;
        refresh?: never;
        require_alias?: never;
        retry_on_conflict?: never;
        routing?: never;
        timeout?: never;
        wait_for_active_shards?: never;
        _source_excludes?: never;
        _source_includes?: never;
        detect_noop?: never;
        doc?: never;
        doc_as_upsert?: never;
        script?: never;
        scripted_upsert?: never;
        _source?: never;
        upsert?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        id?: never;
        index?: never;
        if_primary_term?: never;
        if_seq_no?: never;
        include_source_on_error?: never;
        lang?: never;
        refresh?: never;
        require_alias?: never;
        retry_on_conflict?: never;
        routing?: never;
        timeout?: never;
        wait_for_active_shards?: never;
        _source_excludes?: never;
        _source_includes?: never;
        detect_noop?: never;
        doc?: never;
        doc_as_upsert?: never;
        script?: never;
        scripted_upsert?: never;
        _source?: never;
        upsert?: never;
    };
}
export type UpdateResponse<TDocument = unknown> = UpdateUpdateWriteResponseBase<TDocument>;
export interface UpdateUpdateWriteResponseBase<TDocument = unknown> extends WriteResponseBase {
    get?: InlineGet<TDocument>;
}
export interface UpdateByQueryRequest extends RequestBase {
    /** A comma-separated list of data streams, indices, and aliases to search.
      * It supports wildcards (`*`).
      * To search all data streams or indices, omit this parameter or use `*` or `_all`. */
    index: Indices;
    /** If `false`, the request returns an error if any wildcard expression, index alias, or `_all` value targets only missing or closed indices.
      * This behavior applies even if the request targets other open indices.
      * For example, a request targeting `foo*,bar*` returns an error if an index starts with `foo` but no index starts with `bar`. */
    allow_no_indices?: boolean;
    /** The analyzer to use for the query string.
      * This parameter can be used only when the `q` query string parameter is specified. */
    analyzer?: string;
    /** If `true`, wildcard and prefix queries are analyzed.
      * This parameter can be used only when the `q` query string parameter is specified. */
    analyze_wildcard?: boolean;
    /** The default operator for query string query: `AND` or `OR`.
      * This parameter can be used only when the `q` query string parameter is specified. */
    default_operator?: QueryDslOperator;
    /** The field to use as default where no field prefix is given in the query string.
      * This parameter can be used only when the `q` query string parameter is specified. */
    df?: string;
    /** The type of index that wildcard patterns can match.
      * If the request can target data streams, this argument determines whether wildcard expressions match hidden data streams.
      * It supports comma-separated values, such as `open,hidden`. */
    expand_wildcards?: ExpandWildcards;
    /** Skips the specified number of documents. */
    from?: long;
    /** If `false`, the request returns an error if it targets a missing or closed index. */
    ignore_unavailable?: boolean;
    /** If `true`, format-based query failures (such as providing text to a numeric field) in the query string will be ignored.
      * This parameter can be used only when the `q` query string parameter is specified. */
    lenient?: boolean;
    /** The ID of the pipeline to use to preprocess incoming documents.
      * If the index has a default ingest pipeline specified, then setting the value to `_none` disables the default ingest pipeline for this request.
      * If a final pipeline is configured it will always run, regardless of the value of this parameter. */
    pipeline?: string;
    /** The node or shard the operation should be performed on.
      * It is random by default. */
    preference?: string;
    /** A query in the Lucene query string syntax. */
    q?: string;
    /** If `true`, Elasticsearch refreshes affected shards to make the operation visible to search after the request completes.
      * This is different than the update API's `refresh` parameter, which causes just the shard that received the request to be refreshed. */
    refresh?: boolean;
    /** If `true`, the request cache is used for this request.
      * It defaults to the index-level setting. */
    request_cache?: boolean;
    /** The throttle for this request in sub-requests per second. */
    requests_per_second?: float;
    /** A custom value used to route operations to a specific shard. */
    routing?: Routing;
    /** The period to retain the search context for scrolling. */
    scroll?: Duration;
    /** The size of the scroll request that powers the operation. */
    scroll_size?: long;
    /** An explicit timeout for each search request.
      * By default, there is no timeout. */
    search_timeout?: Duration;
    /** The type of the search operation. Available options include `query_then_fetch` and `dfs_query_then_fetch`. */
    search_type?: SearchType;
    /** The number of slices this task should be divided into. */
    slices?: Slices;
    /** A comma-separated list of <field>:<direction> pairs. */
    sort?: string[];
    /** The specific `tag` of the request for logging and statistical purposes. */
    stats?: string[];
    /** The maximum number of documents to collect for each shard.
      * If a query reaches this limit, Elasticsearch terminates the query early.
      * Elasticsearch collects documents before sorting.
      *
      * IMPORTANT: Use with caution.
      * Elasticsearch applies this parameter to each shard handling the request.
      * When possible, let Elasticsearch perform early termination automatically.
      * Avoid specifying this parameter for requests that target data streams with backing indices across multiple data tiers. */
    terminate_after?: long;
    /** The period each update request waits for the following operations: dynamic mapping updates, waiting for active shards.
      * By default, it is one minute.
      * This guarantees Elasticsearch waits for at least the timeout before failing.
      * The actual wait time could be longer, particularly when multiple waits occur. */
    timeout?: Duration;
    /** If `true`, returns the document version as part of a hit. */
    version?: boolean;
    /** Should the document increment the version number (internal) on hit or not (reindex) */
    version_type?: boolean;
    /** The number of shard copies that must be active before proceeding with the operation.
      * Set to `all` or any positive integer up to the total number of shards in the index (`number_of_replicas+1`).
      * The `timeout` parameter controls how long each write request waits for unavailable shards to become available.
      * Both work exactly the way they work in the bulk API. */
    wait_for_active_shards?: WaitForActiveShards;
    /** If `true`, the request blocks until the operation is complete.
      * If `false`, Elasticsearch performs some preflight checks, launches the request, and returns a task ID that you can use to cancel or get the status of the task.
      * Elasticsearch creates a record of this task as a document at `.tasks/task/${taskId}`. */
    wait_for_completion?: boolean;
    /** The maximum number of documents to update. */
    max_docs?: long;
    /** The documents to update using the Query DSL. */
    query?: QueryDslQueryContainer;
    /** The script to run to update the document source or metadata when updating. */
    script?: Script | ScriptSource;
    /** Slice the request manually using the provided slice ID and total number of slices. */
    slice?: SlicedScroll;
    /** The preferred behavior when update by query hits version conflicts: `abort` or `proceed`. */
    conflicts?: Conflicts;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
        allow_no_indices?: never;
        analyzer?: never;
        analyze_wildcard?: never;
        default_operator?: never;
        df?: never;
        expand_wildcards?: never;
        from?: never;
        ignore_unavailable?: never;
        lenient?: never;
        pipeline?: never;
        preference?: never;
        q?: never;
        refresh?: never;
        request_cache?: never;
        requests_per_second?: never;
        routing?: never;
        scroll?: never;
        scroll_size?: never;
        search_timeout?: never;
        search_type?: never;
        slices?: never;
        sort?: never;
        stats?: never;
        terminate_after?: never;
        timeout?: never;
        version?: never;
        version_type?: never;
        wait_for_active_shards?: never;
        wait_for_completion?: never;
        max_docs?: never;
        query?: never;
        script?: never;
        slice?: never;
        conflicts?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
        allow_no_indices?: never;
        analyzer?: never;
        analyze_wildcard?: never;
        default_operator?: never;
        df?: never;
        expand_wildcards?: never;
        from?: never;
        ignore_unavailable?: never;
        lenient?: never;
        pipeline?: never;
        preference?: never;
        q?: never;
        refresh?: never;
        request_cache?: never;
        requests_per_second?: never;
        routing?: never;
        scroll?: never;
        scroll_size?: never;
        search_timeout?: never;
        search_type?: never;
        slices?: never;
        sort?: never;
        stats?: never;
        terminate_after?: never;
        timeout?: never;
        version?: never;
        version_type?: never;
        wait_for_active_shards?: never;
        wait_for_completion?: never;
        max_docs?: never;
        query?: never;
        script?: never;
        slice?: never;
        conflicts?: never;
    };
}
export interface UpdateByQueryResponse {
    /** The number of scroll responses pulled back by the update by query. */
    batches?: long;
    /** Array of failures if there were any unrecoverable errors during the process.
      * If this is non-empty then the request ended because of those failures.
      * Update by query is implemented using batches.
      * Any failure causes the entire process to end, but all failures in the current batch are collected into the array.
      * You can use the `conflicts` option to prevent reindex from ending when version conflicts occur. */
    failures?: BulkIndexByScrollFailure[];
    /** The number of documents that were ignored because the script used for the update by query returned a noop value for `ctx.op`. */
    noops?: long;
    /** The number of documents that were successfully deleted. */
    deleted?: long;
    /** The number of requests per second effectively run during the update by query. */
    requests_per_second?: float;
    /** The number of retries attempted by update by query.
      * `bulk` is the number of bulk actions retried.
      * `search` is the number of search actions retried. */
    retries?: Retries;
    task?: TaskId;
    /** If true, some requests timed out during the update by query. */
    timed_out?: boolean;
    /** The number of milliseconds from start to end of the whole operation. */
    took?: DurationValue<UnitMillis>;
    /** The number of documents that were successfully processed. */
    total?: long;
    /** The number of documents that were successfully updated. */
    updated?: long;
    /** The number of version conflicts that the update by query hit. */
    version_conflicts?: long;
    throttled?: Duration;
    /** The number of milliseconds the request slept to conform to `requests_per_second`. */
    throttled_millis?: DurationValue<UnitMillis>;
    throttled_until?: Duration;
    /** This field should always be equal to zero in an _update_by_query response.
      * It only has meaning when using the task API, where it indicates the next time (in milliseconds since epoch) a throttled request will be run again in order to conform to `requests_per_second`. */
    throttled_until_millis?: DurationValue<UnitMillis>;
}
export interface UpdateByQueryRethrottleRequest extends RequestBase {
    /** The ID for the task. */
    task_id: Id;
    /** The throttle for this request in sub-requests per second.
      * To turn off throttling, set it to `-1`. */
    requests_per_second?: float;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        task_id?: never;
        requests_per_second?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        task_id?: never;
        requests_per_second?: never;
    };
}
export interface UpdateByQueryRethrottleResponse {
    nodes: Record<string, UpdateByQueryRethrottleUpdateByQueryRethrottleNode>;
}
export interface UpdateByQueryRethrottleUpdateByQueryRethrottleNode extends SpecUtilsBaseNode {
    tasks: Record<TaskId, TasksTaskInfo>;
}
export interface SpecUtilsBaseNode {
    attributes: Record<string, string>;
    host: Host;
    ip: Ip;
    name: Name;
    roles?: NodeRoles;
    transport_address: TransportAddress;
}
export type SpecUtilsNullValue = null;
export type SpecUtilsPipeSeparatedFlags<T = unknown> = T | string;
export type SpecUtilsStringified<T = unknown> = T | string;
export type SpecUtilsWithNullValue<T = unknown> = T | SpecUtilsNullValue;
export interface AcknowledgedResponseBase {
    /** For a successful response, this value is always true. On failure, an exception is returned instead. */
    acknowledged: boolean;
}
export type AggregateName = string;
export interface BulkIndexByScrollFailure {
    cause: ErrorCause;
    id: Id;
    index: IndexName;
    status: integer;
}
export interface BulkStats {
    total_operations: long;
    total_time?: Duration;
    total_time_in_millis: DurationValue<UnitMillis>;
    total_size?: ByteSize;
    total_size_in_bytes: long;
    avg_time?: Duration;
    avg_time_in_millis: DurationValue<UnitMillis>;
    avg_size?: ByteSize;
    avg_size_in_bytes: long;
}
export type ByteSize = long | string;
export type Bytes = 'b' | 'kb' | 'mb' | 'gb' | 'tb' | 'pb';
export type CategoryId = string;
export type ClusterAlias = string;
export interface ClusterDetails {
    status: ClusterSearchStatus;
    indices: string;
    took?: DurationValue<UnitMillis>;
    timed_out: boolean;
    _shards?: ShardStatistics;
    failures?: ShardFailure[];
}
export type ClusterInfoTarget = '_all' | 'http' | 'ingest' | 'thread_pool' | 'script';
export type ClusterInfoTargets = ClusterInfoTarget | ClusterInfoTarget[];
export type ClusterSearchStatus = 'running' | 'successful' | 'partial' | 'skipped' | 'failed';
export interface ClusterStatistics {
    skipped: integer;
    successful: integer;
    total: integer;
    running: integer;
    partial: integer;
    failed: integer;
    details?: Record<ClusterAlias, ClusterDetails>;
}
export interface CompletionStats {
    /** Total amount, in bytes, of memory used for completion across all shards assigned to selected nodes. */
    size_in_bytes: long;
    /** Total amount of memory used for completion across all shards assigned to selected nodes. */
    size?: ByteSize;
    fields?: Record<Field, FieldSizeUsage>;
}
export type Conflicts = 'abort' | 'proceed';
export interface CoordsGeoBounds {
    top: double;
    bottom: double;
    left: double;
    right: double;
}
export type DFIIndependenceMeasure = 'standardized' | 'saturated' | 'chisquared';
export type DFRAfterEffect = 'no' | 'b' | 'l';
export type DFRBasicModel = 'be' | 'd' | 'g' | 'if' | 'in' | 'ine' | 'p';
export type DataStreamName = string;
export type DataStreamNames = DataStreamName | DataStreamName[];
export type DateFormat = string;
export type DateMath = string | Date;
export type DateTime = string | EpochTime<UnitMillis> | Date;
export type Distance = string;
export type DistanceUnit = 'in' | 'ft' | 'yd' | 'mi' | 'nmi' | 'km' | 'm' | 'cm' | 'mm';
export interface DocStats {
    /** Total number of non-deleted documents across all primary shards assigned to selected nodes.
      * This number is based on documents in Lucene segments and may include documents from nested fields. */
    count: long;
    /** Total number of deleted documents across all primary shards assigned to selected nodes.
      * This number is based on documents in Lucene segments.
      * Elasticsearch reclaims the disk space of deleted Lucene documents when a segment is merged. */
    deleted?: long;
    /** Returns the total size in bytes of all documents in this stats.
      * This value may be more reliable than store_stats.size_in_bytes in estimating the index size. */
    total_size_in_bytes: long;
    /** Human readable total_size_in_bytes */
    total_size?: ByteSize;
}
export type Duration = string | -1 | 0;
export type DurationLarge = string;
export type DurationValue<Unit = unknown> = Unit;
export interface ElasticsearchVersionInfo {
    /** The Elasticsearch Git commit's date. */
    build_date: DateTime;
    /** The build flavor. For example, `default`. */
    build_flavor: string;
    /** The Elasticsearch Git commit's SHA hash. */
    build_hash: string;
    /** Indicates whether the Elasticsearch build was a snapshot. */
    build_snapshot: boolean;
    /** The build type that corresponds to how Elasticsearch was installed.
      * For example, `docker`, `rpm`, or `tar`. */
    build_type: string;
    /** The version number of Elasticsearch's underlying Lucene software. */
    lucene_version: VersionString;
    /** The minimum index version with which the responding node can read from disk. */
    minimum_index_compatibility_version: VersionString;
    /** The minimum node version with which the responding node can communicate.
      * Also the minimum version from which you can perform a rolling upgrade. */
    minimum_wire_compatibility_version: VersionString;
    /** The Elasticsearch version number.
      *
      * ::: IMPORTANT: For Serverless deployments, this static value is always `8.11.0` and is used solely for backward compatibility with legacy clients.
      *  Serverless environments are versionless and automatically upgraded, so this value can be safely ignored. */
    number: string;
}
export interface ElasticsearchVersionMinInfo {
    build_flavor: string;
    minimum_index_compatibility_version: VersionString;
    minimum_wire_compatibility_version: VersionString;
    number: string;
}
export interface EmptyObject {
}
export type EpochTime<Unit = unknown> = Unit;
export interface ErrorCauseKeys {
    /** The type of error */
    type: string;
    /** A human-readable explanation of the error, in English. */
    reason?: string | null;
    /** The server stack trace. Present only if the `error_trace=true` parameter was sent with the request. */
    stack_trace?: string;
    caused_by?: ErrorCause;
    root_cause?: ErrorCause[];
    suppressed?: ErrorCause[];
}
export type ErrorCause = ErrorCauseKeys & {
    [property: string]: any;
};
export interface ErrorResponseBase {
    error: ErrorCause;
    status: integer;
}
export type ExpandWildcard = 'all' | 'open' | 'closed' | 'hidden' | 'none';
export type ExpandWildcards = ExpandWildcard | ExpandWildcard[];
export type Field = string;
export interface FieldMemoryUsage {
    memory_size?: ByteSize;
    memory_size_in_bytes: long;
}
export interface FieldSizeUsage {
    size?: ByteSize;
    size_in_bytes: long;
}
export interface FieldSort {
    missing?: AggregationsMissing;
    mode?: SortMode;
    nested?: NestedSortValue;
    order?: SortOrder;
    unmapped_type?: MappingFieldType;
    numeric_type?: FieldSortNumericType;
    format?: string;
}
export type FieldSortNumericType = 'long' | 'double' | 'date' | 'date_nanos';
export type FieldValue = long | double | string | boolean | null;
export interface FielddataStats {
    evictions?: long;
    memory_size?: ByteSize;
    memory_size_in_bytes: long;
    fields?: Record<Field, FieldMemoryUsage>;
    global_ordinals: GlobalOrdinalsStats;
}
export type Fields = Field | Field[];
export interface FlushStats {
    periodic: long;
    total: long;
    total_time?: Duration;
    total_time_in_millis: DurationValue<UnitMillis>;
}
export type Fuzziness = string | integer;
export type GeoBounds = CoordsGeoBounds | TopLeftBottomRightGeoBounds | TopRightBottomLeftGeoBounds | WktGeoBounds;
export interface GeoDistanceSortKeys {
    mode?: SortMode;
    distance_type?: GeoDistanceType;
    ignore_unmapped?: boolean;
    order?: SortOrder;
    unit?: DistanceUnit;
    nested?: NestedSortValue;
}
export type GeoDistanceSort = GeoDistanceSortKeys & {
    [property: string]: GeoLocation | GeoLocation[] | SortMode | GeoDistanceType | boolean | SortOrder | DistanceUnit | NestedSortValue;
};
export type GeoDistanceType = 'arc' | 'plane';
export type GeoHash = string;
export interface GeoHashLocation {
    geohash: GeoHash;
}
export type GeoHashPrecision = number | string;
export type GeoHexCell = string;
export interface GeoLine {
    /** Always `"LineString"` */
    type: string;
    /** Array of `[lon, lat]` coordinates */
    coordinates: double[][];
}
export type GeoLocation = LatLonGeoLocation | GeoHashLocation | double[] | string;
export type GeoShape = any;
export type GeoShapeRelation = 'intersects' | 'disjoint' | 'within' | 'contains';
export type GeoTile = string;
export type GeoTilePrecision = number;
export interface GetStats {
    current: long;
    exists_time?: Duration;
    exists_time_in_millis: DurationValue<UnitMillis>;
    exists_total: long;
    missing_time?: Duration;
    missing_time_in_millis: DurationValue<UnitMillis>;
    missing_total: long;
    time?: Duration;
    time_in_millis: DurationValue<UnitMillis>;
    total: long;
}
export interface GlobalOrdinalFieldStats {
    build_time_in_millis: UnitMillis;
    build_time?: string;
    shard_max_value_count: long;
}
export interface GlobalOrdinalsStats {
    build_time_in_millis: UnitMillis;
    build_time?: string;
    fields?: Record<Name, GlobalOrdinalFieldStats>;
}
export type GrokPattern = string;
export type HealthStatus = 'green' | 'GREEN' | 'yellow' | 'YELLOW' | 'red' | 'RED' | 'unknown' | 'unavailable';
export type Host = string;
export type HttpHeaders = Record<string, string | string[]>;
export type IBDistribution = 'll' | 'spl';
export type IBLambda = 'df' | 'ttf';
export type Id = string;
export type Ids = Id | Id[];
export type IndexAlias = string;
export type IndexName = string;
export type IndexPattern = string;
export type IndexPatterns = IndexPattern[];
export interface IndexingStats {
    index_current: long;
    delete_current: long;
    delete_time?: Duration;
    delete_time_in_millis: DurationValue<UnitMillis>;
    delete_total: long;
    is_throttled: boolean;
    noop_update_total: long;
    throttle_time?: Duration;
    throttle_time_in_millis: DurationValue<UnitMillis>;
    index_time?: Duration;
    index_time_in_millis: DurationValue<UnitMillis>;
    index_total: long;
    index_failed: long;
    types?: Record<string, IndexingStats>;
    write_load?: double;
    recent_write_load?: double;
    peak_write_load?: double;
}
export type Indices = IndexName | IndexName[];
export interface IndicesOptions {
    /** If false, the request returns an error if any wildcard expression, index alias, or `_all` value targets only
      * missing or closed indices. This behavior applies even if the request targets other open indices. For example,
      * a request targeting `foo*,bar*` returns an error if an index starts with `foo` but no index starts with `bar`. */
    allow_no_indices?: boolean;
    /** Type of index that wildcard patterns can match. If the request can target data streams, this argument
      * determines whether wildcard expressions match hidden data streams. Supports comma-separated values,
      * such as `open,hidden`. */
    expand_wildcards?: ExpandWildcards;
    /** If true, missing or closed indices are not included in the response. */
    ignore_unavailable?: boolean;
    /** If true, concrete, expanded or aliased indices are ignored when frozen. */
    ignore_throttled?: boolean;
}
export interface IndicesResponseBase extends AcknowledgedResponseBase {
    _shards?: ShardStatistics;
}
export interface InlineGetKeys<TDocument = unknown> {
    fields?: Record<string, any>;
    found: boolean;
    _seq_no?: SequenceNumber;
    _primary_term?: long;
    _routing?: Routing;
    _source?: TDocument;
}
export type InlineGet<TDocument = unknown> = InlineGetKeys<TDocument> & {
    [property: string]: any;
};
export interface InnerRetriever {
    retriever: RetrieverContainer;
    weight: float;
    normalizer: ScoreNormalizer;
}
export type Ip = string;
export interface KnnQuery extends QueryDslQueryBase {
    /** The name of the vector field to search against */
    field: Field;
    /** The query vector */
    query_vector?: QueryVector;
    /** The query vector builder. You must provide a query_vector_builder or query_vector, but not both. */
    query_vector_builder?: QueryVectorBuilder;
    /** The number of nearest neighbor candidates to consider per shard */
    num_candidates?: integer;
    /** The final number of nearest neighbors to return as top hits */
    k?: integer;
    /** Filters for the kNN search query */
    filter?: QueryDslQueryContainer | QueryDslQueryContainer[];
    /** The minimum similarity for a vector to be considered a match */
    similarity?: float;
    /** Apply oversampling and rescoring to quantized vectors */
    rescore_vector?: RescoreVector;
}
export interface KnnRetriever extends RetrieverBase {
    /** The name of the vector field to search against. */
    field: string;
    /** Query vector. Must have the same number of dimensions as the vector field you are searching against. You must provide a query_vector_builder or query_vector, but not both. */
    query_vector?: QueryVector;
    /** Defines a model to build a query vector. */
    query_vector_builder?: QueryVectorBuilder;
    /** Number of nearest neighbors to return as top hits. */
    k: integer;
    /** Number of nearest neighbor candidates to consider per shard. */
    num_candidates: integer;
    /** The minimum similarity required for a document to be considered a match. */
    similarity?: float;
    /** Apply oversampling and rescoring to quantized vectors */
    rescore_vector?: RescoreVector;
}
export interface KnnSearch {
    /** The name of the vector field to search against */
    field: Field;
    /** The query vector */
    query_vector?: QueryVector;
    /** The query vector builder. You must provide a query_vector_builder or query_vector, but not both. */
    query_vector_builder?: QueryVectorBuilder;
    /** The final number of nearest neighbors to return as top hits */
    k?: integer;
    /** The number of nearest neighbor candidates to consider per shard */
    num_candidates?: integer;
    /** Boost value to apply to kNN scores */
    boost?: float;
    /** Filters for the kNN search query */
    filter?: QueryDslQueryContainer | QueryDslQueryContainer[];
    /** The minimum similarity for a vector to be considered a match */
    similarity?: float;
    /** If defined, each search hit will contain inner hits. */
    inner_hits?: SearchInnerHits;
    /** Apply oversampling and rescoring to quantized vectors */
    rescore_vector?: RescoreVector;
}
export interface LatLonGeoLocation {
    /** Latitude */
    lat: double;
    /** Longitude */
    lon: double;
}
export type Level = 'cluster' | 'indices' | 'shards';
export type LifecycleOperationMode = 'RUNNING' | 'STOPPING' | 'STOPPED';
export interface LinearRetriever extends RetrieverBase {
    /** Inner retrievers. */
    retrievers?: InnerRetriever[];
    rank_window_size?: integer;
    query?: string;
    fields?: string[];
    normalizer?: ScoreNormalizer;
}
export type MapboxVectorTiles = ArrayBuffer;
export interface MergesStats {
    current: long;
    current_docs: long;
    current_size?: string;
    current_size_in_bytes: long;
    total: long;
    total_auto_throttle?: string;
    total_auto_throttle_in_bytes: long;
    total_docs: long;
    total_size?: string;
    total_size_in_bytes: long;
    total_stopped_time?: Duration;
    total_stopped_time_in_millis: DurationValue<UnitMillis>;
    total_throttled_time?: Duration;
    total_throttled_time_in_millis: DurationValue<UnitMillis>;
    total_time?: Duration;
    total_time_in_millis: DurationValue<UnitMillis>;
}
export type Metadata = Record<string, any>;
export type Metrics = string | string[];
export type MinimumShouldMatch = integer | string;
export type MultiTermQueryRewrite = string;
export type Name = string;
export type Names = Name | Name[];
export type Namespace = string;
export interface NestedSortValue {
    filter?: QueryDslQueryContainer;
    max_children?: integer;
    nested?: NestedSortValue;
    path: Field;
}
export interface NodeAttributes {
    /** Lists node attributes. */
    attributes: Record<string, string>;
    /** The ephemeral ID of the node. */
    ephemeral_id: Id;
    /** The unique identifier of the node. */
    id?: NodeId;
    /** The unique identifier of the node. */
    name: NodeName;
    /** The host and port where transport HTTP connections are accepted. */
    transport_address: TransportAddress;
}
export type NodeId = string;
export type NodeIds = NodeId | NodeId[];
export type NodeName = string;
export type NodeRole = 'master' | 'data' | 'data_cold' | 'data_content' | 'data_frozen' | 'data_hot' | 'data_warm' | 'client' | 'ingest' | 'ml' | 'voting_only' | 'transform' | 'remote_cluster_client' | 'coordinating_only';
export type NodeRoles = NodeRole[];
export interface NodeShard {
    state: IndicesStatsShardRoutingState;
    primary: boolean;
    node?: NodeName;
    shard: integer;
    index: IndexName;
    allocation_id?: Record<string, Id>;
    recovery_source?: Record<string, Id>;
    unassigned_info?: ClusterAllocationExplainUnassignedInformation;
    relocating_node?: NodeId | null;
    relocation_failure_info?: RelocationFailureInfo;
}
export interface NodeStatistics {
    failures?: ErrorCause[];
    /** Total number of nodes selected by the request. */
    total: integer;
    /** Number of nodes that responded successfully to the request. */
    successful: integer;
    /** Number of nodes that rejected the request or failed to respond. If this value is not 0, a reason for the rejection or failure is included in the response. */
    failed: integer;
}
export type Normalization = 'no' | 'h1' | 'h2' | 'h3' | 'z';
export type OpType = 'index' | 'create';
export type Password = string;
export type Percentage = string | float;
export interface PinnedRetriever extends RetrieverBase {
    /** Inner retriever. */
    retriever: RetrieverContainer;
    ids?: string[];
    docs?: SpecifiedDocument[];
    rank_window_size?: integer;
}
export type PipelineName = string;
export interface PluginStats {
    classname: string;
    description: string;
    elasticsearch_version: VersionString;
    extended_plugins: string[];
    has_native_controller: boolean;
    java_version: VersionString;
    name: Name;
    version: VersionString;
    licensed: boolean;
}
export type PropertyName = string;
export interface QueryCacheStats {
    /** Total number of entries added to the query cache across all shards assigned to selected nodes.
      * This number includes current and evicted entries. */
    cache_count: long;
    /** Total number of entries currently in the query cache across all shards assigned to selected nodes. */
    cache_size: long;
    /** Total number of query cache evictions across all shards assigned to selected nodes. */
    evictions: long;
    /** Total count of query cache hits across all shards assigned to selected nodes. */
    hit_count: long;
    /** Total amount of memory used for the query cache across all shards assigned to selected nodes. */
    memory_size?: ByteSize;
    /** Total amount, in bytes, of memory used for the query cache across all shards assigned to selected nodes. */
    memory_size_in_bytes: long;
    /** Total count of query cache misses across all shards assigned to selected nodes. */
    miss_count: long;
    /** Total count of hits and misses in the query cache across all shards assigned to selected nodes. */
    total_count: long;
}
export type QueryVector = float[];
export interface QueryVectorBuilder {
    text_embedding?: TextEmbedding;
}
export interface RRFRetriever extends RetrieverBase {
    /** A list of child retrievers to specify which sets of returned top documents will have the RRF formula applied to them. */
    retrievers: RetrieverContainer[];
    /** This value determines how much influence documents in individual result sets per query have over the final ranked result set. */
    rank_constant?: integer;
    /** This value determines the size of the individual result sets per query. */
    rank_window_size?: integer;
    query?: string;
    fields?: string[];
}
export interface RankBase {
}
export interface RankContainer {
    /** The reciprocal rank fusion parameters */
    rrf?: RrfRank;
}
export interface RecoveryStats {
    current_as_source: long;
    current_as_target: long;
    throttle_time?: Duration;
    throttle_time_in_millis: DurationValue<UnitMillis>;
}
export type Refresh = boolean | 'true' | 'false' | 'wait_for';
export interface RefreshStats {
    external_total: long;
    external_total_time_in_millis: DurationValue<UnitMillis>;
    listeners: long;
    total: long;
    total_time?: Duration;
    total_time_in_millis: DurationValue<UnitMillis>;
}
export type RelationName = string;
export interface RelocationFailureInfo {
    failed_attempts: integer;
}
export interface RequestBase extends SpecUtilsCommonQueryParameters {
}
export interface RequestCacheStats {
    evictions: long;
    hit_count: long;
    memory_size?: string;
    memory_size_in_bytes: long;
    miss_count: long;
}
export interface RescoreVector {
    /** Applies the specified oversample factor to k on the approximate kNN search */
    oversample: float;
}
export interface RescorerRetriever extends RetrieverBase {
    /** Inner retriever. */
    retriever: RetrieverContainer;
    rescore: SearchRescore | SearchRescore[];
}
export type Result = 'created' | 'updated' | 'deleted' | 'not_found' | 'noop';
export interface Retries {
    /** The number of bulk actions retried. */
    bulk: long;
    /** The number of search actions retried. */
    search: long;
}
export interface RetrieverBase {
    /** Query to filter the documents that can match. */
    filter?: QueryDslQueryContainer | QueryDslQueryContainer[];
    /** Minimum _score for matching documents. Documents with a lower _score are not included in the top documents. */
    min_score?: float;
    /** Retriever name. */
    _name?: string;
}
export interface RetrieverContainer {
    /** A retriever that replaces the functionality of a traditional query. */
    standard?: StandardRetriever;
    /** A retriever that replaces the functionality  of a knn search. */
    knn?: KnnRetriever;
    /** A retriever that produces top documents from reciprocal rank fusion (RRF). */
    rrf?: RRFRetriever;
    /** A retriever that reranks the top documents based on a reranking model using the InferenceAPI */
    text_similarity_reranker?: TextSimilarityReranker;
    /** A retriever that replaces the functionality of a rule query. */
    rule?: RuleRetriever;
    /** A retriever that re-scores only the results produced by its child retriever. */
    rescorer?: RescorerRetriever;
    /** A retriever that supports the combination of different retrievers through a weighted linear combination. */
    linear?: LinearRetriever;
    /** A pinned retriever applies pinned documents to the underlying retriever.
      * This retriever will rewrite to a PinnedQueryBuilder. */
    pinned?: PinnedRetriever;
}
export type Routing = string;
export interface RrfRank {
    /** How much influence documents in individual result sets per query have over the final ranked result set */
    rank_constant?: long;
    /** Size of the individual result sets per query */
    rank_window_size?: long;
}
export interface RuleRetriever extends RetrieverBase {
    /** The ruleset IDs containing the rules this retriever is evaluating against. */
    ruleset_ids: Id | Id[];
    /** The match criteria that will determine if a rule in the provided rulesets should be applied. */
    match_criteria: any;
    /** The retriever whose results rules should be applied to. */
    retriever: RetrieverContainer;
    /** This value determines the size of the individual result set. */
    rank_window_size?: integer;
}
export type ScalarValue = long | double | string | boolean | null;
export type ScoreNormalizer = 'none' | 'minmax' | 'l2_norm';
export interface ScoreSort {
    order?: SortOrder;
}
export interface Script {
    /** The script source. */
    source?: ScriptSource;
    /** The `id` for a stored script. */
    id?: Id;
    /** Specifies any named parameters that are passed into the script as variables.
      * Use parameters instead of hard-coded values to decrease compile time. */
    params?: Record<string, any>;
    /** Specifies the language the script is written in. */
    lang?: ScriptLanguage;
    options?: Record<string, string>;
}
export interface ScriptField {
    script: Script | ScriptSource;
    ignore_failure?: boolean;
}
export type ScriptLanguage = 'painless' | 'expression' | 'mustache' | 'java' | string;
export interface ScriptSort {
    order?: SortOrder;
    script: Script | ScriptSource;
    type?: ScriptSortType;
    mode?: SortMode;
    nested?: NestedSortValue;
}
export type ScriptSortType = 'string' | 'number' | 'version';
export type ScriptSource = string | SearchSearchRequestBody;
export interface ScriptTransform {
    lang?: string;
    params?: Record<string, any>;
    source?: ScriptSource;
    id?: string;
}
export type ScrollId = string;
export type ScrollIds = ScrollId | ScrollId[];
export interface SearchStats {
    fetch_current: long;
    fetch_time?: Duration;
    fetch_time_in_millis: DurationValue<UnitMillis>;
    fetch_total: long;
    open_contexts?: long;
    query_current: long;
    query_time?: Duration;
    query_time_in_millis: DurationValue<UnitMillis>;
    query_total: long;
    scroll_current: long;
    scroll_time?: Duration;
    scroll_time_in_millis: DurationValue<UnitMillis>;
    scroll_total: long;
    suggest_current: long;
    suggest_time?: Duration;
    suggest_time_in_millis: DurationValue<UnitMillis>;
    suggest_total: long;
    recent_search_load?: double;
    groups?: Record<string, SearchStats>;
}
export interface SearchTransform {
    request: WatcherSearchInputRequestDefinition;
    timeout: Duration;
}
export type SearchType = 'query_then_fetch' | 'dfs_query_then_fetch';
export interface SegmentsStats {
    /** Total number of segments across all shards assigned to selected nodes. */
    count: integer;
    /** Total amount of memory used for doc values across all shards assigned to selected nodes. */
    doc_values_memory?: ByteSize;
    /** Total amount, in bytes, of memory used for doc values across all shards assigned to selected nodes. */
    doc_values_memory_in_bytes: long;
    /** This object is not populated by the cluster stats API.
      * To get information on segment files, use the node stats API. */
    file_sizes: Record<string, IndicesStatsShardFileSizeInfo>;
    /** Total amount of memory used by fixed bit sets across all shards assigned to selected nodes.
      * Fixed bit sets are used for nested object field types and type filters for join fields. */
    fixed_bit_set?: ByteSize;
    /** Total amount of memory, in bytes, used by fixed bit sets across all shards assigned to selected nodes. */
    fixed_bit_set_memory_in_bytes: long;
    /** Total amount of memory used by all index writers across all shards assigned to selected nodes. */
    index_writer_memory?: ByteSize;
    /** Total amount, in bytes, of memory used by all index writers across all shards assigned to selected nodes. */
    index_writer_memory_in_bytes: long;
    /** Unix timestamp, in milliseconds, of the most recently retried indexing request. */
    max_unsafe_auto_id_timestamp: long;
    /** Total amount of memory used for segments across all shards assigned to selected nodes. */
    memory?: ByteSize;
    /** Total amount, in bytes, of memory used for segments across all shards assigned to selected nodes. */
    memory_in_bytes: long;
    /** Total amount of memory used for normalization factors across all shards assigned to selected nodes. */
    norms_memory?: ByteSize;
    /** Total amount, in bytes, of memory used for normalization factors across all shards assigned to selected nodes. */
    norms_memory_in_bytes: long;
    /** Total amount of memory used for points across all shards assigned to selected nodes. */
    points_memory?: ByteSize;
    /** Total amount, in bytes, of memory used for points across all shards assigned to selected nodes. */
    points_memory_in_bytes: long;
    /** Total amount, in bytes, of memory used for stored fields across all shards assigned to selected nodes. */
    stored_fields_memory_in_bytes: long;
    /** Total amount of memory used for stored fields across all shards assigned to selected nodes. */
    stored_fields_memory?: ByteSize;
    /** Total amount, in bytes, of memory used for terms across all shards assigned to selected nodes. */
    terms_memory_in_bytes: long;
    /** Total amount of memory used for terms across all shards assigned to selected nodes. */
    terms_memory?: ByteSize;
    /** Total amount of memory used for term vectors across all shards assigned to selected nodes. */
    term_vectors_memory?: ByteSize;
    /** Total amount, in bytes, of memory used for term vectors across all shards assigned to selected nodes. */
    term_vectors_memory_in_bytes: long;
    /** Total amount of memory used by all version maps across all shards assigned to selected nodes. */
    version_map_memory?: ByteSize;
    /** Total amount, in bytes, of memory used by all version maps across all shards assigned to selected nodes. */
    version_map_memory_in_bytes: long;
}
export type SequenceNumber = long;
export type Service = string;
export interface ShardFailure {
    index?: IndexName;
    node?: string;
    reason: ErrorCause;
    shard: integer;
    status?: string;
}
export interface ShardStatistics {
    /** The number of shards the operation or search attempted to run on but failed. */
    failed: uint;
    /** The number of shards the operation or search succeeded on. */
    successful: uint;
    /** The number of shards the operation or search will run on overall. */
    total: uint;
    failures?: ShardFailure[];
    skipped?: uint;
}
export interface ShardsOperationResponseBase {
    _shards?: ShardStatistics;
}
export interface SlicedScroll {
    field?: Field;
    id: Id;
    max: integer;
}
export type Slices = integer | SlicesCalculation;
export type SlicesCalculation = 'auto';
export type Sort = SortCombinations | SortCombinations[];
export type SortCombinations = Field | SortOptions;
export type SortMode = 'min' | 'max' | 'sum' | 'avg' | 'median';
export interface SortOptionsKeys {
    _score?: ScoreSort;
    _doc?: ScoreSort;
    _geo_distance?: GeoDistanceSort;
    _script?: ScriptSort;
}
export type SortOptions = SortOptionsKeys & {
    [property: string]: FieldSort | SortOrder | ScoreSort | GeoDistanceSort | ScriptSort;
};
export type SortOrder = 'asc' | 'desc';
export type SortResults = FieldValue[];
export interface SpecifiedDocument {
    index?: IndexName;
    id: Id;
}
export interface StandardRetriever extends RetrieverBase {
    /** Defines a query to retrieve a set of top documents. */
    query?: QueryDslQueryContainer;
    /** Defines a search after object parameter used for pagination. */
    search_after?: SortResults;
    /** Maximum number of documents to collect for each shard. */
    terminate_after?: integer;
    /** A sort object that that specifies the order of matching documents. */
    sort?: Sort;
    /** Collapses the top documents by a specified key into a single top document per key. */
    collapse?: SearchFieldCollapse;
}
export interface StoreStats {
    /** Total size of all shards assigned to selected nodes. */
    size?: ByteSize;
    /** Total size, in bytes, of all shards assigned to selected nodes. */
    size_in_bytes: long;
    /** A prediction of how much larger the shard stores will eventually grow due to ongoing peer recoveries, restoring snapshots, and similar activities. */
    reserved?: ByteSize;
    /** A prediction, in bytes, of how much larger the shard stores will eventually grow due to ongoing peer recoveries, restoring snapshots, and similar activities. */
    reserved_in_bytes: long;
    /** Total data set size of all shards assigned to selected nodes.
      * This includes the size of shards not stored fully on the nodes, such as the cache for partially mounted indices. */
    total_data_set_size?: ByteSize;
    /** Total data set size, in bytes, of all shards assigned to selected nodes.
      * This includes the size of shards not stored fully on the nodes, such as the cache for partially mounted indices. */
    total_data_set_size_in_bytes?: long;
}
export interface StoredScript {
    /** The language the script is written in.
      * For search templates, use `mustache`. */
    lang: ScriptLanguage;
    options?: Record<string, string>;
    /** The script source.
      * For search templates, an object containing the search template. */
    source: ScriptSource;
}
export type StreamResult = ArrayBuffer;
export type SuggestMode = 'missing' | 'popular' | 'always';
export type SuggestionName = string;
export interface TaskFailure {
    task_id: long;
    node_id: NodeId;
    status: string;
    reason: ErrorCause;
}
export type TaskId = string;
export interface TextEmbedding {
    model_id: string;
    model_text: string;
}
export interface TextSimilarityReranker extends RetrieverBase {
    /** The nested retriever which will produce the first-level results, that will later be used for reranking. */
    retriever: RetrieverContainer;
    /** This value determines how many documents we will consider from the nested retriever. */
    rank_window_size?: integer;
    /** Unique identifier of the inference endpoint created using the inference API. */
    inference_id?: string;
    /** The text snippet used as the basis for similarity comparison */
    inference_text: string;
    /** The document field to be used for text similarity comparisons. This field should contain the text that will be evaluated against the inference_text */
    field: string;
}
export type ThreadType = 'cpu' | 'wait' | 'block' | 'gpu' | 'mem';
export type TimeOfDay = string;
export type TimeUnit = 'nanos' | 'micros' | 'ms' | 's' | 'm' | 'h' | 'd';
export type TimeZone = string;
export interface TokenPruningConfig {
    /** Tokens whose frequency is more than this threshold times the average frequency of all tokens in the specified field are considered outliers and pruned. */
    tokens_freq_ratio_threshold?: integer;
    /** Tokens whose weight is less than this threshold are considered nonsignificant and pruned. */
    tokens_weight_threshold?: float;
    /** Whether to only score pruned tokens, vs only scoring kept tokens. */
    only_score_pruned_tokens?: boolean;
}
export interface TopLeftBottomRightGeoBounds {
    top_left: GeoLocation;
    bottom_right: GeoLocation;
}
export interface TopRightBottomLeftGeoBounds {
    top_right: GeoLocation;
    bottom_left: GeoLocation;
}
export interface TransformContainer {
    chain?: TransformContainer[];
    script?: ScriptTransform;
    search?: SearchTransform;
}
export interface TranslogStats {
    earliest_last_modified_age: long;
    operations: long;
    size?: string;
    size_in_bytes: long;
    uncommitted_operations: integer;
    uncommitted_size?: string;
    uncommitted_size_in_bytes: long;
}
export type TransportAddress = string;
export type UnitFloatMillis = double;
export type UnitMillis = long;
export type UnitNanos = long;
export type UnitSeconds = long;
export type Username = string;
export type Uuid = string;
export type VersionNumber = long;
export type VersionString = string;
export type VersionType = 'internal' | 'external' | 'external_gte' | 'force';
export type WaitForActiveShardOptions = 'all' | 'index-setting';
export type WaitForActiveShards = integer | WaitForActiveShardOptions;
export type WaitForEvents = 'immediate' | 'urgent' | 'high' | 'normal' | 'low' | 'languid';
export interface WarmerStats {
    current: long;
    total: long;
    total_time?: Duration;
    total_time_in_millis: DurationValue<UnitMillis>;
}
export interface WktGeoBounds {
    wkt: string;
}
export interface WriteResponseBase {
    /** The unique identifier for the added document. */
    _id: Id;
    /** The name of the index the document was added to. */
    _index: IndexName;
    /** The primary term assigned to the document for the indexing operation. */
    _primary_term?: long;
    /** The result of the indexing operation: `created` or `updated`. */
    result: Result;
    /** The sequence number assigned to the document for the indexing operation.
      * Sequence numbers are used to ensure an older version of a document doesn't overwrite a newer version. */
    _seq_no?: SequenceNumber;
    /** Information about the replication process of the operation. */
    _shards: ShardStatistics;
    /** The document version, which is incremented each time the document is updated. */
    _version: VersionNumber;
    forced_refresh?: boolean;
}
export type byte = number;
export type double = number;
export type float = number;
export type integer = number;
export type long = number;
export type short = number;
export type uint = number;
export type ulong = number;
export interface AggregationsAdjacencyMatrixAggregate extends AggregationsMultiBucketAggregateBase<AggregationsAdjacencyMatrixBucket> {
}
export interface AggregationsAdjacencyMatrixAggregation extends AggregationsBucketAggregationBase {
    /** Filters used to create buckets.
      * At least one filter is required. */
    filters?: Record<string, QueryDslQueryContainer>;
    /** Separator used to concatenate filter names. Defaults to &. */
    separator?: string;
}
export interface AggregationsAdjacencyMatrixBucketKeys extends AggregationsMultiBucketBase {
    key: string;
}
export type AggregationsAdjacencyMatrixBucket = AggregationsAdjacencyMatrixBucketKeys & {
    [property: string]: AggregationsAggregate | string | long;
};
export type AggregationsAggregate = AggregationsCardinalityAggregate | AggregationsHdrPercentilesAggregate | AggregationsHdrPercentileRanksAggregate | AggregationsTDigestPercentilesAggregate | AggregationsTDigestPercentileRanksAggregate | AggregationsPercentilesBucketAggregate | AggregationsMedianAbsoluteDeviationAggregate | AggregationsMinAggregate | AggregationsMaxAggregate | AggregationsSumAggregate | AggregationsAvgAggregate | AggregationsWeightedAvgAggregate | AggregationsValueCountAggregate | AggregationsSimpleValueAggregate | AggregationsDerivativeAggregate | AggregationsBucketMetricValueAggregate | AggregationsStatsAggregate | AggregationsStatsBucketAggregate | AggregationsExtendedStatsAggregate | AggregationsExtendedStatsBucketAggregate | AggregationsGeoBoundsAggregate | AggregationsGeoCentroidAggregate | AggregationsHistogramAggregate | AggregationsDateHistogramAggregate | AggregationsAutoDateHistogramAggregate | AggregationsVariableWidthHistogramAggregate | AggregationsStringTermsAggregate | AggregationsLongTermsAggregate | AggregationsDoubleTermsAggregate | AggregationsUnmappedTermsAggregate | AggregationsLongRareTermsAggregate | AggregationsStringRareTermsAggregate | AggregationsUnmappedRareTermsAggregate | AggregationsMultiTermsAggregate | AggregationsMissingAggregate | AggregationsNestedAggregate | AggregationsReverseNestedAggregate | AggregationsGlobalAggregate | AggregationsFilterAggregate | AggregationsChildrenAggregate | AggregationsParentAggregate | AggregationsSamplerAggregate | AggregationsUnmappedSamplerAggregate | AggregationsGeoHashGridAggregate | AggregationsGeoTileGridAggregate | AggregationsGeoHexGridAggregate | AggregationsRangeAggregate | AggregationsDateRangeAggregate | AggregationsGeoDistanceAggregate | AggregationsIpRangeAggregate | AggregationsIpPrefixAggregate | AggregationsFiltersAggregate | AggregationsAdjacencyMatrixAggregate | AggregationsSignificantLongTermsAggregate | AggregationsSignificantStringTermsAggregate | AggregationsUnmappedSignificantTermsAggregate | AggregationsCompositeAggregate | AggregationsFrequentItemSetsAggregate | AggregationsTimeSeriesAggregate | AggregationsScriptedMetricAggregate | AggregationsTopHitsAggregate | AggregationsInferenceAggregate | AggregationsStringStatsAggregate | AggregationsBoxPlotAggregate | AggregationsTopMetricsAggregate | AggregationsTTestAggregate | AggregationsRateAggregate | AggregationsCumulativeCardinalityAggregate | AggregationsMatrixStatsAggregate | AggregationsGeoLineAggregate;
export interface AggregationsAggregateBase {
    meta?: Metadata;
}
export type AggregationsAggregateOrder = Partial<Record<Field, SortOrder>> | Partial<Record<Field, SortOrder>>[];
export interface AggregationsAggregation {
}
export interface AggregationsAggregationContainer {
    /** Sub-aggregations for this aggregation.
      * Only applies to bucket aggregations. */
    aggregations?: Record<string, AggregationsAggregationContainer>;
    /** Sub-aggregations for this aggregation.
      * Only applies to bucket aggregations.
      * @alias aggregations */
    aggs?: Record<string, AggregationsAggregationContainer>;
    meta?: Metadata;
    /** A bucket aggregation returning a form of adjacency matrix.
      * The request provides a collection of named filter expressions, similar to the `filters` aggregation.
      * Each bucket in the response represents a non-empty cell in the matrix of intersecting filters. */
    adjacency_matrix?: AggregationsAdjacencyMatrixAggregation;
    /** A multi-bucket aggregation similar to the date histogram, except instead of providing an interval to use as the width of each bucket, a target number of buckets is provided. */
    auto_date_histogram?: AggregationsAutoDateHistogramAggregation;
    /** A single-value metrics aggregation that computes the average of numeric values that are extracted from the aggregated documents. */
    avg?: AggregationsAverageAggregation;
    /** A sibling pipeline aggregation which calculates the mean value of a specified metric in a sibling aggregation.
      * The specified metric must be numeric and the sibling aggregation must be a multi-bucket aggregation. */
    avg_bucket?: AggregationsAverageBucketAggregation;
    /** A metrics aggregation that computes a box plot of numeric values extracted from the aggregated documents. */
    boxplot?: AggregationsBoxplotAggregation;
    /** A parent pipeline aggregation which runs a script which can perform per bucket computations on metrics in the parent multi-bucket aggregation. */
    bucket_script?: AggregationsBucketScriptAggregation;
    /** A parent pipeline aggregation which runs a script to determine whether the current bucket will be retained in the parent multi-bucket aggregation. */
    bucket_selector?: AggregationsBucketSelectorAggregation;
    /** A parent pipeline aggregation which sorts the buckets of its parent multi-bucket aggregation. */
    bucket_sort?: AggregationsBucketSortAggregation;
    /** A sibling pipeline aggregation which runs a two sample Kolmogorov–Smirnov test ("K-S test") against a provided distribution and the distribution implied by the documents counts in the configured sibling aggregation.
      * @experimental */
    bucket_count_ks_test?: AggregationsBucketKsAggregation;
    /** A sibling pipeline aggregation which runs a correlation function on the configured sibling multi-bucket aggregation.
      * @experimental */
    bucket_correlation?: AggregationsBucketCorrelationAggregation;
    /** A single-value metrics aggregation that calculates an approximate count of distinct values. */
    cardinality?: AggregationsCardinalityAggregation;
    /** A multi-bucket aggregation that groups semi-structured text into buckets.
      * @experimental */
    categorize_text?: AggregationsCategorizeTextAggregation;
    /** A single bucket aggregation that selects child documents that have the specified type, as defined in a `join` field. */
    children?: AggregationsChildrenAggregation;
    /** A multi-bucket aggregation that creates composite buckets from different sources.
      * Unlike the other multi-bucket aggregations, you can use the `composite` aggregation to paginate *all* buckets from a multi-level aggregation efficiently. */
    composite?: AggregationsCompositeAggregation;
    /** A parent pipeline aggregation which calculates the cumulative cardinality in a parent `histogram` or `date_histogram` aggregation. */
    cumulative_cardinality?: AggregationsCumulativeCardinalityAggregation;
    /** A parent pipeline aggregation which calculates the cumulative sum of a specified metric in a parent `histogram` or `date_histogram` aggregation. */
    cumulative_sum?: AggregationsCumulativeSumAggregation;
    /** A multi-bucket values source based aggregation that can be applied on date values or date range values extracted from the documents.
      * It dynamically builds fixed size (interval) buckets over the values. */
    date_histogram?: AggregationsDateHistogramAggregation;
    /** A multi-bucket value source based aggregation that enables the user to define a set of date ranges - each representing a bucket. */
    date_range?: AggregationsDateRangeAggregation;
    /** A parent pipeline aggregation which calculates the derivative of a specified metric in a parent `histogram` or `date_histogram` aggregation. */
    derivative?: AggregationsDerivativeAggregation;
    /** A filtering aggregation used to limit any sub aggregations' processing to a sample of the top-scoring documents.
      * Similar to the `sampler` aggregation, but adds the ability to limit the number of matches that share a common value. */
    diversified_sampler?: AggregationsDiversifiedSamplerAggregation;
    /** A multi-value metrics aggregation that computes stats over numeric values extracted from the aggregated documents. */
    extended_stats?: AggregationsExtendedStatsAggregation;
    /** A sibling pipeline aggregation which calculates a variety of stats across all bucket of a specified metric in a sibling aggregation. */
    extended_stats_bucket?: AggregationsExtendedStatsBucketAggregation;
    /** A bucket aggregation which finds frequent item sets, a form of association rules mining that identifies items that often occur together. */
    frequent_item_sets?: AggregationsFrequentItemSetsAggregation;
    /** A single bucket aggregation that narrows the set of documents to those that match a query. */
    filter?: QueryDslQueryContainer;
    /** A multi-bucket aggregation where each bucket contains the documents that match a query. */
    filters?: AggregationsFiltersAggregation;
    /** A metric aggregation that computes the geographic bounding box containing all values for a Geopoint or Geoshape field. */
    geo_bounds?: AggregationsGeoBoundsAggregation;
    /** A metric aggregation that computes the weighted centroid from all coordinate values for geo fields. */
    geo_centroid?: AggregationsGeoCentroidAggregation;
    /** A multi-bucket aggregation that works on `geo_point` fields.
      * Evaluates the distance of each document value from an origin point and determines the buckets it belongs to, based on ranges defined in the request. */
    geo_distance?: AggregationsGeoDistanceAggregation;
    /** A multi-bucket aggregation that groups `geo_point` and `geo_shape` values into buckets that represent a grid.
      * Each cell is labeled using a geohash which is of user-definable precision. */
    geohash_grid?: AggregationsGeoHashGridAggregation;
    /** Aggregates all `geo_point` values within a bucket into a `LineString` ordered by the chosen sort field. */
    geo_line?: AggregationsGeoLineAggregation;
    /** A multi-bucket aggregation that groups `geo_point` and `geo_shape` values into buckets that represent a grid.
      * Each cell corresponds to a map tile as used by many online map sites. */
    geotile_grid?: AggregationsGeoTileGridAggregation;
    /** A multi-bucket aggregation that groups `geo_point` and `geo_shape` values into buckets that represent a grid.
      * Each cell corresponds to a H3 cell index and is labeled using the H3Index representation. */
    geohex_grid?: AggregationsGeohexGridAggregation;
    /** Defines a single bucket of all the documents within the search execution context.
      * This context is defined by the indices and the document types you’re searching on, but is not influenced by the search query itself. */
    global?: AggregationsGlobalAggregation;
    /** A multi-bucket values source based aggregation that can be applied on numeric values or numeric range values extracted from the documents.
      * It dynamically builds fixed size (interval) buckets over the values. */
    histogram?: AggregationsHistogramAggregation;
    /** A multi-bucket value source based aggregation that enables the user to define a set of IP ranges - each representing a bucket. */
    ip_range?: AggregationsIpRangeAggregation;
    /** A bucket aggregation that groups documents based on the network or sub-network of an IP address. */
    ip_prefix?: AggregationsIpPrefixAggregation;
    /** A parent pipeline aggregation which loads a pre-trained model and performs inference on the collated result fields from the parent bucket aggregation. */
    inference?: AggregationsInferenceAggregation;
    line?: AggregationsGeoLineAggregation;
    /** A numeric aggregation that computes the following statistics over a set of document fields: `count`, `mean`, `variance`, `skewness`, `kurtosis`, `covariance`, and `covariance`. */
    matrix_stats?: AggregationsMatrixStatsAggregation;
    /** A single-value metrics aggregation that returns the maximum value among the numeric values extracted from the aggregated documents. */
    max?: AggregationsMaxAggregation;
    /** A sibling pipeline aggregation which identifies the bucket(s) with the maximum value of a specified metric in a sibling aggregation and outputs both the value and the key(s) of the bucket(s). */
    max_bucket?: AggregationsMaxBucketAggregation;
    /** A single-value aggregation that approximates the median absolute deviation of its search results. */
    median_absolute_deviation?: AggregationsMedianAbsoluteDeviationAggregation;
    /** A single-value metrics aggregation that returns the minimum value among numeric values extracted from the aggregated documents. */
    min?: AggregationsMinAggregation;
    /** A sibling pipeline aggregation which identifies the bucket(s) with the minimum value of a specified metric in a sibling aggregation and outputs both the value and the key(s) of the bucket(s). */
    min_bucket?: AggregationsMinBucketAggregation;
    /** A field data based single bucket aggregation, that creates a bucket of all documents in the current document set context that are missing a field value (effectively, missing a field or having the configured NULL value set). */
    missing?: AggregationsMissingAggregation;
    moving_avg?: AggregationsMovingAverageAggregation;
    /** Given an ordered series of percentiles, "slides" a window across those percentiles and computes cumulative percentiles. */
    moving_percentiles?: AggregationsMovingPercentilesAggregation;
    /** Given an ordered series of data, "slides" a window across the data and runs a custom script on each window of data.
      * For convenience, a number of common functions are predefined such as `min`, `max`, and moving averages. */
    moving_fn?: AggregationsMovingFunctionAggregation;
    /** A multi-bucket value source based aggregation where buckets are dynamically built - one per unique set of values. */
    multi_terms?: AggregationsMultiTermsAggregation;
    /** A special single bucket aggregation that enables aggregating nested documents. */
    nested?: AggregationsNestedAggregation;
    /** A parent pipeline aggregation which calculates the specific normalized/rescaled value for a specific bucket value. */
    normalize?: AggregationsNormalizeAggregation;
    /** A special single bucket aggregation that selects parent documents that have the specified type, as defined in a `join` field. */
    parent?: AggregationsParentAggregation;
    /** A multi-value metrics aggregation that calculates one or more percentile ranks over numeric values extracted from the aggregated documents. */
    percentile_ranks?: AggregationsPercentileRanksAggregation;
    /** A multi-value metrics aggregation that calculates one or more percentiles over numeric values extracted from the aggregated documents. */
    percentiles?: AggregationsPercentilesAggregation;
    /** A sibling pipeline aggregation which calculates percentiles across all bucket of a specified metric in a sibling aggregation. */
    percentiles_bucket?: AggregationsPercentilesBucketAggregation;
    /** A multi-bucket value source based aggregation that enables the user to define a set of ranges - each representing a bucket. */
    range?: AggregationsRangeAggregation;
    /** A multi-bucket value source based aggregation which finds "rare" terms—terms that are at the long-tail of the distribution and are not frequent. */
    rare_terms?: AggregationsRareTermsAggregation;
    /** Calculates a rate of documents or a field in each bucket.
      * Can only be used inside a `date_histogram` or `composite` aggregation. */
    rate?: AggregationsRateAggregation;
    /** A special single bucket aggregation that enables aggregating on parent documents from nested documents.
      * Should only be defined inside a `nested` aggregation. */
    reverse_nested?: AggregationsReverseNestedAggregation;
    /** A single bucket aggregation that randomly includes documents in the aggregated results.
      * Sampling provides significant speed improvement at the cost of accuracy.
      * @remarks This property is not supported on Elastic Cloud Serverless.
      * @experimental */
    random_sampler?: AggregationsRandomSamplerAggregation;
    /** A filtering aggregation used to limit any sub aggregations' processing to a sample of the top-scoring documents. */
    sampler?: AggregationsSamplerAggregation;
    /** A metric aggregation that uses scripts to provide a metric output. */
    scripted_metric?: AggregationsScriptedMetricAggregation;
    /** An aggregation that subtracts values in a time series from themselves at different time lags or periods. */
    serial_diff?: AggregationsSerialDifferencingAggregation;
    /** Returns interesting or unusual occurrences of terms in a set. */
    significant_terms?: AggregationsSignificantTermsAggregation;
    /** Returns interesting or unusual occurrences of free-text terms in a set. */
    significant_text?: AggregationsSignificantTextAggregation;
    /** A multi-value metrics aggregation that computes stats over numeric values extracted from the aggregated documents. */
    stats?: AggregationsStatsAggregation;
    /** A sibling pipeline aggregation which calculates a variety of stats across all bucket of a specified metric in a sibling aggregation. */
    stats_bucket?: AggregationsStatsBucketAggregation;
    /** A multi-value metrics aggregation that computes statistics over string values extracted from the aggregated documents. */
    string_stats?: AggregationsStringStatsAggregation;
    /** A single-value metrics aggregation that sums numeric values that are extracted from the aggregated documents. */
    sum?: AggregationsSumAggregation;
    /** A sibling pipeline aggregation which calculates the sum of a specified metric across all buckets in a sibling aggregation. */
    sum_bucket?: AggregationsSumBucketAggregation;
    /** A multi-bucket value source based aggregation where buckets are dynamically built - one per unique value. */
    terms?: AggregationsTermsAggregation;
    /** The time series aggregation queries data created using a time series index.
      * This is typically data such as metrics or other data streams with a time component, and requires creating an index using the time series mode.
      * @experimental */
    time_series?: AggregationsTimeSeriesAggregation;
    /** A metric aggregation that returns the top matching documents per bucket. */
    top_hits?: AggregationsTopHitsAggregation;
    /** A metrics aggregation that performs a statistical hypothesis test in which the test statistic follows a Student’s t-distribution under the null hypothesis on numeric values extracted from the aggregated documents. */
    t_test?: AggregationsTTestAggregation;
    /** A metric aggregation that selects metrics from the document with the largest or smallest sort value. */
    top_metrics?: AggregationsTopMetricsAggregation;
    /** A single-value metrics aggregation that counts the number of values that are extracted from the aggregated documents. */
    value_count?: AggregationsValueCountAggregation;
    /** A single-value metrics aggregation that computes the weighted average of numeric values that are extracted from the aggregated documents. */
    weighted_avg?: AggregationsWeightedAverageAggregation;
    /** A multi-bucket aggregation similar to the histogram, except instead of providing an interval to use as the width of each bucket, a target number of buckets is provided. */
    variable_width_histogram?: AggregationsVariableWidthHistogramAggregation;
}
export interface AggregationsAggregationRange {
    /** Start of the range (inclusive). */
    from?: double | null;
    /** Custom key to return the range with. */
    key?: string;
    /** End of the range (exclusive). */
    to?: double | null;
}
export interface AggregationsArrayPercentilesItem {
    key: string;
    value: double | null;
    value_as_string?: string;
}
export interface AggregationsAutoDateHistogramAggregate extends AggregationsMultiBucketAggregateBase<AggregationsDateHistogramBucket> {
    interval: DurationLarge;
}
export interface AggregationsAutoDateHistogramAggregation extends AggregationsBucketAggregationBase {
    /** The target number of buckets. */
    buckets?: integer;
    /** The field on which to run the aggregation. */
    field?: Field;
    /** The date format used to format `key_as_string` in the response.
      * If no `format` is specified, the first date format specified in the field mapping is used. */
    format?: string;
    /** The minimum rounding interval.
      * This can make the collection process more efficient, as the aggregation will not attempt to round at any interval lower than `minimum_interval`. */
    minimum_interval?: AggregationsMinimumInterval;
    /** The value to apply to documents that do not have a value.
      * By default, documents without a value are ignored. */
    missing?: DateTime;
    /** Time zone specified as a ISO 8601 UTC offset. */
    offset?: string;
    params?: Record<string, any>;
    script?: Script | ScriptSource;
    /** Time zone ID. */
    time_zone?: TimeZone;
}
export interface AggregationsAverageAggregation extends AggregationsFormatMetricAggregationBase {
}
export interface AggregationsAverageBucketAggregation extends AggregationsPipelineAggregationBase {
}
export interface AggregationsAvgAggregate extends AggregationsSingleMetricAggregateBase {
}
export interface AggregationsBoxPlotAggregate extends AggregationsAggregateBase {
    min: double;
    max: double;
    q1: double;
    q2: double;
    q3: double;
    lower: double;
    upper: double;
    min_as_string?: string;
    max_as_string?: string;
    q1_as_string?: string;
    q2_as_string?: string;
    q3_as_string?: string;
    lower_as_string?: string;
    upper_as_string?: string;
}
export interface AggregationsBoxplotAggregation extends AggregationsMetricAggregationBase {
    /** Limits the maximum number of nodes used by the underlying TDigest algorithm to `20 * compression`, enabling control of memory usage and approximation error. */
    compression?: double;
    /** The default implementation of TDigest is optimized for performance, scaling to millions or even billions of sample values while maintaining acceptable accuracy levels (close to 1% relative error for millions of samples in some cases).
      * To use an implementation optimized for accuracy, set this parameter to high_accuracy instead. */
    execution_hint?: AggregationsTDigestExecutionHint;
}
export interface AggregationsBucketAggregationBase {
}
export interface AggregationsBucketCorrelationAggregation extends AggregationsBucketPathAggregation {
    /** The correlation function to execute. */
    function: AggregationsBucketCorrelationFunction;
}
export interface AggregationsBucketCorrelationFunction {
    /** The configuration to calculate a count correlation. This function is designed for determining the correlation of a term value and a given metric. */
    count_correlation: AggregationsBucketCorrelationFunctionCountCorrelation;
}
export interface AggregationsBucketCorrelationFunctionCountCorrelation {
    /** The indicator with which to correlate the configured `bucket_path` values. */
    indicator: AggregationsBucketCorrelationFunctionCountCorrelationIndicator;
}
export interface AggregationsBucketCorrelationFunctionCountCorrelationIndicator {
    /** The total number of documents that initially created the expectations. It’s required to be greater
      * than or equal to the sum of all values in the buckets_path as this is the originating superset of data
      * to which the term values are correlated. */
    doc_count: integer;
    /** An array of numbers with which to correlate the configured `bucket_path` values.
      * The length of this value must always equal the number of buckets returned by the `bucket_path`. */
    expectations: double[];
    /** An array of fractions to use when averaging and calculating variance. This should be used if
      * the pre-calculated data and the buckets_path have known gaps. The length of fractions, if provided,
      * must equal expectations. */
    fractions?: double[];
}
export interface AggregationsBucketKsAggregation extends AggregationsBucketPathAggregation {
    /** A list of string values indicating which K-S test alternative to calculate. The valid values
      * are: "greater", "less", "two_sided". This parameter is key for determining the K-S statistic used
      * when calculating the K-S test. Default value is all possible alternative hypotheses. */
    alternative?: string[];
    /** A list of doubles indicating the distribution of the samples with which to compare to the `buckets_path` results.
      * In typical usage this is the overall proportion of documents in each bucket, which is compared with the actual
      * document proportions in each bucket from the sibling aggregation counts. The default is to assume that overall
      * documents are uniformly distributed on these buckets, which they would be if one used equal percentiles of a
      * metric to define the bucket end points. */
    fractions?: double[];
    /** Indicates the sampling methodology when calculating the K-S test. Note, this is sampling of the returned values.
      * This determines the cumulative distribution function (CDF) points used comparing the two samples. Default is
      * `upper_tail`, which emphasizes the upper end of the CDF points. Valid options are: `upper_tail`, `uniform`,
      * and `lower_tail`. */
    sampling_method?: string;
}
export interface AggregationsBucketMetricValueAggregate extends AggregationsSingleMetricAggregateBase {
    keys: string[];
}
export interface AggregationsBucketPathAggregation {
    /** Path to the buckets that contain one set of values to correlate. */
    buckets_path?: AggregationsBucketsPath;
}
export interface AggregationsBucketScriptAggregation extends AggregationsPipelineAggregationBase {
    /** The script to run for this aggregation. */
    script?: Script | ScriptSource;
}
export interface AggregationsBucketSelectorAggregation extends AggregationsPipelineAggregationBase {
    /** The script to run for this aggregation. */
    script?: Script | ScriptSource;
}
export interface AggregationsBucketSortAggregation {
    /** Buckets in positions prior to `from` will be truncated. */
    from?: integer;
    /** The policy to apply when gaps are found in the data. */
    gap_policy?: AggregationsGapPolicy;
    /** The number of buckets to return.
      * Defaults to all buckets of the parent aggregation. */
    size?: integer;
    /** The list of fields to sort on. */
    sort?: Sort;
}
export type AggregationsBuckets<TBucket = unknown> = Record<string, TBucket> | TBucket[];
export type AggregationsBucketsPath = string | string[] | Record<string, string>;
export type AggregationsCalendarInterval = 'second' | '1s' | 'minute' | '1m' | 'hour' | '1h' | 'day' | '1d' | 'week' | '1w' | 'month' | '1M' | 'quarter' | '1q' | 'year' | '1y';
export interface AggregationsCardinalityAggregate extends AggregationsAggregateBase {
    value: long;
}
export interface AggregationsCardinalityAggregation extends AggregationsMetricAggregationBase {
    /** A unique count below which counts are expected to be close to accurate.
      * This allows to trade memory for accuracy. */
    precision_threshold?: integer;
    rehash?: boolean;
    /** Mechanism by which cardinality aggregations is run. */
    execution_hint?: AggregationsCardinalityExecutionMode;
}
export type AggregationsCardinalityExecutionMode = 'global_ordinals' | 'segment_ordinals' | 'direct' | 'save_memory_heuristic' | 'save_time_heuristic';
export interface AggregationsCategorizeTextAggregation {
    /** The semi-structured text field to categorize. */
    field: Field;
    /** The maximum number of unique tokens at any position up to max_matched_tokens. Must be larger than 1.
      * Smaller values use less memory and create fewer categories. Larger values will use more memory and
      * create narrower categories. Max allowed value is 100. */
    max_unique_tokens?: integer;
    /** The maximum number of token positions to match on before attempting to merge categories. Larger
      * values will use more memory and create narrower categories. Max allowed value is 100. */
    max_matched_tokens?: integer;
    /** The minimum percentage of tokens that must match for text to be added to the category bucket. Must
      * be between 1 and 100. The larger the value the narrower the categories. Larger values will increase memory
      * usage and create narrower categories. */
    similarity_threshold?: integer;
    /** This property expects an array of regular expressions. The expressions are used to filter out matching
      * sequences from the categorization field values. You can use this functionality to fine tune the categorization
      * by excluding sequences from consideration when categories are defined. For example, you can exclude SQL
      * statements that appear in your log files. This property cannot be used at the same time as categorization_analyzer.
      * If you only want to define simple regular expression filters that are applied prior to tokenization, setting
      * this property is the easiest method. If you also want to customize the tokenizer or post-tokenization filtering,
      * use the categorization_analyzer property instead and include the filters as pattern_replace character filters. */
    categorization_filters?: string[];
    /** The categorization analyzer specifies how the text is analyzed and tokenized before being categorized.
      * The syntax is very similar to that used to define the analyzer in the analyze API. This property
      * cannot be used at the same time as `categorization_filters`. */
    categorization_analyzer?: AggregationsCategorizeTextAnalyzer;
    /** The number of categorization buckets to return from each shard before merging all the results. */
    shard_size?: integer;
    /** The number of buckets to return. */
    size?: integer;
    /** The minimum number of documents in a bucket to be returned to the results. */
    min_doc_count?: integer;
    /** The minimum number of documents in a bucket to be returned from the shard before merging. */
    shard_min_doc_count?: integer;
}
export type AggregationsCategorizeTextAnalyzer = string | AggregationsCustomCategorizeTextAnalyzer;
export interface AggregationsChiSquareHeuristic {
    /** Set to `false` if you defined a custom background filter that represents a different set of documents that you want to compare to. */
    background_is_superset: boolean;
    /** Set to `false` to filter out the terms that appear less often in the subset than in documents outside the subset. */
    include_negatives: boolean;
}
export interface AggregationsChildrenAggregateKeys extends AggregationsSingleBucketAggregateBase {
}
export type AggregationsChildrenAggregate = AggregationsChildrenAggregateKeys & {
    [property: string]: AggregationsAggregate | long | Metadata;
};
export interface AggregationsChildrenAggregation extends AggregationsBucketAggregationBase {
    /** The child type that should be selected. */
    type?: RelationName;
}
export interface AggregationsCompositeAggregate extends AggregationsMultiBucketAggregateBase<AggregationsCompositeBucket> {
    after_key?: AggregationsCompositeAggregateKey;
}
export type AggregationsCompositeAggregateKey = Record<Field, FieldValue>;
export interface AggregationsCompositeAggregation extends AggregationsBucketAggregationBase {
    /** When paginating, use the `after_key` value returned in the previous response to retrieve the next page. */
    after?: AggregationsCompositeAggregateKey;
    /** The number of composite buckets that should be returned. */
    size?: integer;
    /** The value sources used to build composite buckets.
      * Keys are returned in the order of the `sources` definition. */
    sources?: Record<string, AggregationsCompositeAggregationSource>[];
}
export interface AggregationsCompositeAggregationBase {
    /** Either `field` or `script` must be present */
    field?: Field;
    missing_bucket?: boolean;
    missing_order?: AggregationsMissingOrder;
    /** Either `field` or `script` must be present */
    script?: Script | ScriptSource;
    value_type?: AggregationsValueType;
    order?: SortOrder;
}
export interface AggregationsCompositeAggregationSource {
    /** A terms aggregation. */
    terms?: AggregationsCompositeTermsAggregation;
    /** A histogram aggregation. */
    histogram?: AggregationsCompositeHistogramAggregation;
    /** A date histogram aggregation. */
    date_histogram?: AggregationsCompositeDateHistogramAggregation;
    /** A geotile grid aggregation. */
    geotile_grid?: AggregationsCompositeGeoTileGridAggregation;
}
export interface AggregationsCompositeBucketKeys extends AggregationsMultiBucketBase {
    key: AggregationsCompositeAggregateKey;
}
export type AggregationsCompositeBucket = AggregationsCompositeBucketKeys & {
    [property: string]: AggregationsAggregate | AggregationsCompositeAggregateKey | long;
};
export interface AggregationsCompositeDateHistogramAggregation extends AggregationsCompositeAggregationBase {
    format?: string;
    /** Either `calendar_interval` or `fixed_interval` must be present */
    calendar_interval?: DurationLarge;
    /** Either `calendar_interval` or `fixed_interval` must be present */
    fixed_interval?: DurationLarge;
    offset?: Duration;
    time_zone?: TimeZone;
}
export interface AggregationsCompositeGeoTileGridAggregation extends AggregationsCompositeAggregationBase {
    precision?: integer;
    bounds?: GeoBounds;
}
export interface AggregationsCompositeHistogramAggregation extends AggregationsCompositeAggregationBase {
    interval: double;
}
export interface AggregationsCompositeTermsAggregation extends AggregationsCompositeAggregationBase {
}
export interface AggregationsCumulativeCardinalityAggregate extends AggregationsAggregateBase {
    value: long;
    value_as_string?: string;
}
export interface AggregationsCumulativeCardinalityAggregation extends AggregationsPipelineAggregationBase {
}
export interface AggregationsCumulativeSumAggregation extends AggregationsPipelineAggregationBase {
}
export interface AggregationsCustomCategorizeTextAnalyzer {
    char_filter?: string[];
    tokenizer?: string;
    filter?: string[];
}
export interface AggregationsDateHistogramAggregate extends AggregationsMultiBucketAggregateBase<AggregationsDateHistogramBucket> {
}
export interface AggregationsDateHistogramAggregation extends AggregationsBucketAggregationBase {
    /** Calendar-aware interval.
      * Can be specified using the unit name, such as `month`, or as a single unit quantity, such as `1M`. */
    calendar_interval?: AggregationsCalendarInterval;
    /** Enables extending the bounds of the histogram beyond the data itself. */
    extended_bounds?: AggregationsExtendedBounds<AggregationsFieldDateMath>;
    /** Limits the histogram to specified bounds. */
    hard_bounds?: AggregationsExtendedBounds<AggregationsFieldDateMath>;
    /** The date field whose values are use to build a histogram. */
    field?: Field;
    /** Fixed intervals: a fixed number of SI units and never deviate, regardless of where they fall on the calendar. */
    fixed_interval?: Duration;
    /** The date format used to format `key_as_string` in the response.
      * If no `format` is specified, the first date format specified in the field mapping is used. */
    format?: string;
    interval?: Duration;
    /** Only returns buckets that have `min_doc_count` number of documents.
      * By default, all buckets between the first bucket that matches documents and the last one are returned. */
    min_doc_count?: integer;
    /** The value to apply to documents that do not have a value.
      * By default, documents without a value are ignored. */
    missing?: DateTime;
    /** Changes the start value of each bucket by the specified positive (`+`) or negative offset (`-`) duration. */
    offset?: Duration;
    /** The sort order of the returned buckets. */
    order?: AggregationsAggregateOrder;
    params?: Record<string, any>;
    script?: Script | ScriptSource;
    /** Time zone used for bucketing and rounding.
      * Defaults to Coordinated Universal Time (UTC). */
    time_zone?: TimeZone;
    /** Set to `true` to associate a unique string key with each bucket and return the ranges as a hash rather than an array. */
    keyed?: boolean;
}
export interface AggregationsDateHistogramBucketKeys extends AggregationsMultiBucketBase {
    key_as_string?: string;
    key: EpochTime<UnitMillis>;
}
export type AggregationsDateHistogramBucket = AggregationsDateHistogramBucketKeys & {
    [property: string]: AggregationsAggregate | string | EpochTime<UnitMillis> | long;
};
export interface AggregationsDateRangeAggregate extends AggregationsRangeAggregate {
}
export interface AggregationsDateRangeAggregation extends AggregationsBucketAggregationBase {
    /** The date field whose values are use to build ranges. */
    field?: Field;
    /** The date format used to format `from` and `to` in the response. */
    format?: string;
    /** The value to apply to documents that do not have a value.
      * By default, documents without a value are ignored. */
    missing?: AggregationsMissing;
    /** Array of date ranges. */
    ranges?: AggregationsDateRangeExpression[];
    /** Time zone used to convert dates from another time zone to UTC. */
    time_zone?: TimeZone;
    /** Set to `true` to associate a unique string key with each bucket and returns the ranges as a hash rather than an array. */
    keyed?: boolean;
}
export interface AggregationsDateRangeExpression {
    /** Start of the range (inclusive). */
    from?: AggregationsFieldDateMath;
    /** Custom key to return the range with. */
    key?: string;
    /** End of the range (exclusive). */
    to?: AggregationsFieldDateMath;
}
export interface AggregationsDerivativeAggregate extends AggregationsSingleMetricAggregateBase {
    normalized_value?: double;
    normalized_value_as_string?: string;
}
export interface AggregationsDerivativeAggregation extends AggregationsPipelineAggregationBase {
}
export interface AggregationsDiversifiedSamplerAggregation extends AggregationsBucketAggregationBase {
    /** The type of value used for de-duplication. */
    execution_hint?: AggregationsSamplerAggregationExecutionHint;
    /** Limits how many documents are permitted per choice of de-duplicating value. */
    max_docs_per_value?: integer;
    script?: Script | ScriptSource;
    /** Limits how many top-scoring documents are collected in the sample processed on each shard. */
    shard_size?: integer;
    /** The field used to provide values used for de-duplication. */
    field?: Field;
}
export interface AggregationsDoubleTermsAggregate extends AggregationsTermsAggregateBase<AggregationsDoubleTermsBucket> {
}
export interface AggregationsDoubleTermsBucketKeys extends AggregationsTermsBucketBase {
    key: double;
    key_as_string?: string;
}
export type AggregationsDoubleTermsBucket = AggregationsDoubleTermsBucketKeys & {
    [property: string]: AggregationsAggregate | double | string | long;
};
export interface AggregationsEwmaModelSettings {
    alpha?: float;
}
export interface AggregationsEwmaMovingAverageAggregation extends AggregationsMovingAverageAggregationBase {
    model: 'ewma';
    settings: AggregationsEwmaModelSettings;
}
export interface AggregationsExtendedBounds<T = unknown> {
    /** Maximum value for the bound. */
    max?: T;
    /** Minimum value for the bound. */
    min?: T;
}
export interface AggregationsExtendedStatsAggregate extends AggregationsStatsAggregate {
    sum_of_squares: double | null;
    variance: double | null;
    variance_population: double | null;
    variance_sampling: double | null;
    std_deviation: double | null;
    std_deviation_population: double | null;
    std_deviation_sampling: double | null;
    std_deviation_bounds?: AggregationsStandardDeviationBounds;
    sum_of_squares_as_string?: string;
    variance_as_string?: string;
    variance_population_as_string?: string;
    variance_sampling_as_string?: string;
    std_deviation_as_string?: string;
    std_deviation_bounds_as_string?: AggregationsStandardDeviationBoundsAsString;
}
export interface AggregationsExtendedStatsAggregation extends AggregationsFormatMetricAggregationBase {
    /** The number of standard deviations above/below the mean to display. */
    sigma?: double;
}
export interface AggregationsExtendedStatsBucketAggregate extends AggregationsExtendedStatsAggregate {
}
export interface AggregationsExtendedStatsBucketAggregation extends AggregationsPipelineAggregationBase {
    /** The number of standard deviations above/below the mean to display. */
    sigma?: double;
}
export type AggregationsFieldDateMath = DateMath | double;
export interface AggregationsFilterAggregateKeys extends AggregationsSingleBucketAggregateBase {
}
export type AggregationsFilterAggregate = AggregationsFilterAggregateKeys & {
    [property: string]: AggregationsAggregate | long | Metadata;
};
export interface AggregationsFiltersAggregate extends AggregationsMultiBucketAggregateBase<AggregationsFiltersBucket> {
}
export interface AggregationsFiltersAggregation extends AggregationsBucketAggregationBase {
    /** Collection of queries from which to build buckets. */
    filters?: AggregationsBuckets<QueryDslQueryContainer>;
    /** Set to `true` to add a bucket to the response which will contain all documents that do not match any of the given filters. */
    other_bucket?: boolean;
    /** The key with which the other bucket is returned. */
    other_bucket_key?: string;
    /** By default, the named filters aggregation returns the buckets as an object.
      * Set to `false` to return the buckets as an array of objects. */
    keyed?: boolean;
}
export interface AggregationsFiltersBucketKeys extends AggregationsMultiBucketBase {
    key?: string;
}
export type AggregationsFiltersBucket = AggregationsFiltersBucketKeys & {
    [property: string]: AggregationsAggregate | string | long;
};
export interface AggregationsFormatMetricAggregationBase extends AggregationsMetricAggregationBase {
    format?: string;
}
export interface AggregationsFormattableMetricAggregation extends AggregationsMetricAggregationBase {
    format?: string;
}
export interface AggregationsFrequentItemSetsAggregate extends AggregationsMultiBucketAggregateBase<AggregationsFrequentItemSetsBucket> {
}
export interface AggregationsFrequentItemSetsAggregation {
    /** Fields to analyze. */
    fields: AggregationsFrequentItemSetsField[];
    /** The minimum size of one item set. */
    minimum_set_size?: integer;
    /** The minimum support of one item set. */
    minimum_support?: double;
    /** The number of top item sets to return. */
    size?: integer;
    /** Query that filters documents from analysis. */
    filter?: QueryDslQueryContainer;
}
export interface AggregationsFrequentItemSetsBucketKeys extends AggregationsMultiBucketBase {
    key: Record<Field, string[]>;
    support: double;
}
export type AggregationsFrequentItemSetsBucket = AggregationsFrequentItemSetsBucketKeys & {
    [property: string]: AggregationsAggregate | Record<Field, string[]> | double | long;
};
export interface AggregationsFrequentItemSetsField {
    field: Field;
    /** Values to exclude.
      * Can be regular expression strings or arrays of strings of exact terms. */
    exclude?: AggregationsTermsExclude;
    /** Values to include.
      * Can be regular expression strings or arrays of strings of exact terms. */
    include?: AggregationsTermsInclude;
}
export type AggregationsGapPolicy = 'skip' | 'insert_zeros' | 'keep_values';
export interface AggregationsGeoBoundsAggregate extends AggregationsAggregateBase {
    bounds?: GeoBounds;
}
export interface AggregationsGeoBoundsAggregation extends AggregationsMetricAggregationBase {
    /** Specifies whether the bounding box should be allowed to overlap the international date line. */
    wrap_longitude?: boolean;
}
export interface AggregationsGeoCentroidAggregate extends AggregationsAggregateBase {
    count: long;
    location?: GeoLocation;
}
export interface AggregationsGeoCentroidAggregation extends AggregationsMetricAggregationBase {
    count?: long;
    location?: GeoLocation;
}
export interface AggregationsGeoDistanceAggregate extends AggregationsRangeAggregate {
}
export interface AggregationsGeoDistanceAggregation extends AggregationsBucketAggregationBase {
    /** The distance calculation type. */
    distance_type?: GeoDistanceType;
    /** A field of type `geo_point` used to evaluate the distance. */
    field?: Field;
    /** The origin  used to evaluate the distance. */
    origin?: GeoLocation;
    /** An array of ranges used to bucket documents. */
    ranges?: AggregationsAggregationRange[];
    /** The distance unit. */
    unit?: DistanceUnit;
}
export interface AggregationsGeoHashGridAggregate extends AggregationsMultiBucketAggregateBase<AggregationsGeoHashGridBucket> {
}
export interface AggregationsGeoHashGridAggregation extends AggregationsBucketAggregationBase {
    /** The bounding box to filter the points in each bucket. */
    bounds?: GeoBounds;
    /** Field containing indexed `geo_point` or `geo_shape` values.
      * If the field contains an array, `geohash_grid` aggregates all array values. */
    field?: Field;
    /** The string length of the geohashes used to define cells/buckets in the results. */
    precision?: GeoHashPrecision;
    /** Allows for more accurate counting of the top cells returned in the final result the aggregation.
      * Defaults to returning `max(10,(size x number-of-shards))` buckets from each shard. */
    shard_size?: integer;
    /** The maximum number of geohash buckets to return. */
    size?: integer;
}
export interface AggregationsGeoHashGridBucketKeys extends AggregationsMultiBucketBase {
    key: GeoHash;
}
export type AggregationsGeoHashGridBucket = AggregationsGeoHashGridBucketKeys & {
    [property: string]: AggregationsAggregate | GeoHash | long;
};
export interface AggregationsGeoHexGridAggregate extends AggregationsMultiBucketAggregateBase<AggregationsGeoHexGridBucket> {
}
export interface AggregationsGeoHexGridBucketKeys extends AggregationsMultiBucketBase {
    key: GeoHexCell;
}
export type AggregationsGeoHexGridBucket = AggregationsGeoHexGridBucketKeys & {
    [property: string]: AggregationsAggregate | GeoHexCell | long;
};
export interface AggregationsGeoLineAggregate extends AggregationsAggregateBase {
    type: string;
    geometry: GeoLine;
    properties: any;
}
export interface AggregationsGeoLineAggregation {
    /** The name of the geo_point field. */
    point: AggregationsGeoLinePoint;
    /** The name of the numeric field to use as the sort key for ordering the points.
      * When the `geo_line` aggregation is nested inside a `time_series` aggregation, this field defaults to `@timestamp`, and any other value will result in error. */
    sort: AggregationsGeoLineSort;
    /** When `true`, returns an additional array of the sort values in the feature properties. */
    include_sort?: boolean;
    /** The order in which the line is sorted (ascending or descending). */
    sort_order?: SortOrder;
    /** The maximum length of the line represented in the aggregation.
      * Valid sizes are between 1 and 10000. */
    size?: integer;
}
export interface AggregationsGeoLinePoint {
    /** The name of the geo_point field. */
    field: Field;
}
export interface AggregationsGeoLineSort {
    /** The name of the numeric field to use as the sort key for ordering the points. */
    field: Field;
}
export interface AggregationsGeoTileGridAggregate extends AggregationsMultiBucketAggregateBase<AggregationsGeoTileGridBucket> {
}
export interface AggregationsGeoTileGridAggregation extends AggregationsBucketAggregationBase {
    /** Field containing indexed `geo_point` or `geo_shape` values.
      * If the field contains an array, `geotile_grid` aggregates all array values. */
    field?: Field;
    /** Integer zoom of the key used to define cells/buckets in the results.
      * Values outside of the range [0,29] will be rejected. */
    precision?: GeoTilePrecision;
    /** Allows for more accurate counting of the top cells returned in the final result the aggregation.
      * Defaults to returning `max(10,(size x number-of-shards))` buckets from each shard. */
    shard_size?: integer;
    /** The maximum number of buckets to return. */
    size?: integer;
    /** A bounding box to filter the geo-points or geo-shapes in each bucket. */
    bounds?: GeoBounds;
}
export interface AggregationsGeoTileGridBucketKeys extends AggregationsMultiBucketBase {
    key: GeoTile;
}
export type AggregationsGeoTileGridBucket = AggregationsGeoTileGridBucketKeys & {
    [property: string]: AggregationsAggregate | GeoTile | long;
};
export interface AggregationsGeohexGridAggregation extends AggregationsBucketAggregationBase {
    /** Field containing indexed `geo_point` or `geo_shape` values.
      * If the field contains an array, `geohex_grid` aggregates all array values. */
    field: Field;
    /** Integer zoom of the key used to defined cells or buckets
      * in the results. Value should be between 0-15. */
    precision?: integer;
    /** Bounding box used to filter the geo-points in each bucket. */
    bounds?: GeoBounds;
    /** Maximum number of buckets to return. */
    size?: integer;
    /** Number of buckets returned from each shard. */
    shard_size?: integer;
}
export interface AggregationsGlobalAggregateKeys extends AggregationsSingleBucketAggregateBase {
}
export type AggregationsGlobalAggregate = AggregationsGlobalAggregateKeys & {
    [property: string]: AggregationsAggregate | long | Metadata;
};
export interface AggregationsGlobalAggregation extends AggregationsBucketAggregationBase {
}
export interface AggregationsGoogleNormalizedDistanceHeuristic {
    /** Set to `false` if you defined a custom background filter that represents a different set of documents that you want to compare to. */
    background_is_superset?: boolean;
}
export interface AggregationsHdrMethod {
    /** Specifies the resolution of values for the histogram in number of significant digits. */
    number_of_significant_value_digits?: integer;
}
export interface AggregationsHdrPercentileRanksAggregate extends AggregationsPercentilesAggregateBase {
}
export interface AggregationsHdrPercentilesAggregate extends AggregationsPercentilesAggregateBase {
}
export interface AggregationsHistogramAggregate extends AggregationsMultiBucketAggregateBase<AggregationsHistogramBucket> {
}
export interface AggregationsHistogramAggregation extends AggregationsBucketAggregationBase {
    /** Enables extending the bounds of the histogram beyond the data itself. */
    extended_bounds?: AggregationsExtendedBounds<double>;
    /** Limits the range of buckets in the histogram.
      * It is particularly useful in the case of open data ranges that can result in a very large number of buckets. */
    hard_bounds?: AggregationsExtendedBounds<double>;
    /** The name of the field to aggregate on. */
    field?: Field;
    /** The interval for the buckets.
      * Must be a positive decimal. */
    interval?: double;
    /** Only returns buckets that have `min_doc_count` number of documents.
      * By default, the response will fill gaps in the histogram with empty buckets. */
    min_doc_count?: integer;
    /** The value to apply to documents that do not have a value.
      * By default, documents without a value are ignored. */
    missing?: double;
    /** By default, the bucket keys start with 0 and then continue in even spaced steps of `interval`.
      * The bucket boundaries can be shifted by using the `offset` option. */
    offset?: double;
    /** The sort order of the returned buckets.
      * By default, the returned buckets are sorted by their key ascending. */
    order?: AggregationsAggregateOrder;
    script?: Script | ScriptSource;
    format?: string;
    /** If `true`, returns buckets as a hash instead of an array, keyed by the bucket keys. */
    keyed?: boolean;
}
export interface AggregationsHistogramBucketKeys extends AggregationsMultiBucketBase {
    key_as_string?: string;
    key: double;
}
export type AggregationsHistogramBucket = AggregationsHistogramBucketKeys & {
    [property: string]: AggregationsAggregate | string | double | long;
};
export interface AggregationsHoltLinearModelSettings {
    alpha?: float;
    beta?: float;
}
export interface AggregationsHoltMovingAverageAggregation extends AggregationsMovingAverageAggregationBase {
    model: 'holt';
    settings: AggregationsHoltLinearModelSettings;
}
export interface AggregationsHoltWintersModelSettings {
    alpha?: float;
    beta?: float;
    gamma?: float;
    pad?: boolean;
    period?: integer;
    type?: AggregationsHoltWintersType;
}
export interface AggregationsHoltWintersMovingAverageAggregation extends AggregationsMovingAverageAggregationBase {
    model: 'holt_winters';
    settings: AggregationsHoltWintersModelSettings;
}
export type AggregationsHoltWintersType = 'add' | 'mult';
export interface AggregationsInferenceAggregateKeys extends AggregationsAggregateBase {
    value?: FieldValue;
    feature_importance?: AggregationsInferenceFeatureImportance[];
    top_classes?: AggregationsInferenceTopClassEntry[];
    warning?: string;
}
export type AggregationsInferenceAggregate = AggregationsInferenceAggregateKeys & {
    [property: string]: any;
};
export interface AggregationsInferenceAggregation extends AggregationsPipelineAggregationBase {
    /** The ID or alias for the trained model. */
    model_id: Name;
    /** Contains the inference type and its options. */
    inference_config?: AggregationsInferenceConfigContainer;
}
export interface AggregationsInferenceClassImportance {
    class_name: string;
    importance: double;
}
export interface AggregationsInferenceConfigContainer {
    /** Regression configuration for inference. */
    regression?: MlRegressionInferenceOptions;
    /** Classification configuration for inference. */
    classification?: MlClassificationInferenceOptions;
}
export interface AggregationsInferenceFeatureImportance {
    feature_name: string;
    importance?: double;
    classes?: AggregationsInferenceClassImportance[];
}
export interface AggregationsInferenceTopClassEntry {
    class_name: FieldValue;
    class_probability: double;
    class_score: double;
}
export interface AggregationsIpPrefixAggregate extends AggregationsMultiBucketAggregateBase<AggregationsIpPrefixBucket> {
}
export interface AggregationsIpPrefixAggregation extends AggregationsBucketAggregationBase {
    /** The IP address field to aggregation on. The field mapping type must be `ip`. */
    field: Field;
    /** Length of the network prefix. For IPv4 addresses the accepted range is [0, 32].
      * For IPv6 addresses the accepted range is [0, 128]. */
    prefix_length: integer;
    /** Defines whether the prefix applies to IPv6 addresses. */
    is_ipv6?: boolean;
    /** Defines whether the prefix length is appended to IP address keys in the response. */
    append_prefix_length?: boolean;
    /** Defines whether buckets are returned as a hash rather than an array in the response. */
    keyed?: boolean;
    /** Minimum number of documents in a bucket for it to be included in the response. */
    min_doc_count?: long;
}
export interface AggregationsIpPrefixBucketKeys extends AggregationsMultiBucketBase {
    is_ipv6: boolean;
    key: string;
    prefix_length: integer;
    netmask?: string;
}
export type AggregationsIpPrefixBucket = AggregationsIpPrefixBucketKeys & {
    [property: string]: AggregationsAggregate | boolean | string | integer | long;
};
export interface AggregationsIpRangeAggregate extends AggregationsMultiBucketAggregateBase<AggregationsIpRangeBucket> {
}
export interface AggregationsIpRangeAggregation extends AggregationsBucketAggregationBase {
    /** The date field whose values are used to build ranges. */
    field?: Field;
    /** Array of IP ranges. */
    ranges?: AggregationsIpRangeAggregationRange[];
}
export interface AggregationsIpRangeAggregationRange {
    /** Start of the range. */
    from?: string | null;
    /** IP range defined as a CIDR mask. */
    mask?: string;
    /** End of the range. */
    to?: string | null;
}
export interface AggregationsIpRangeBucketKeys extends AggregationsMultiBucketBase {
    key?: string;
    from?: string;
    to?: string;
}
export type AggregationsIpRangeBucket = AggregationsIpRangeBucketKeys & {
    [property: string]: AggregationsAggregate | string | long;
};
export type AggregationsKeyedPercentiles = Record<string, string | long | null>;
export interface AggregationsLinearMovingAverageAggregation extends AggregationsMovingAverageAggregationBase {
    model: 'linear';
    settings: EmptyObject;
}
export interface AggregationsLongRareTermsAggregate extends AggregationsMultiBucketAggregateBase<AggregationsLongRareTermsBucket> {
}
export interface AggregationsLongRareTermsBucketKeys extends AggregationsMultiBucketBase {
    key: long;
    key_as_string?: string;
}
export type AggregationsLongRareTermsBucket = AggregationsLongRareTermsBucketKeys & {
    [property: string]: AggregationsAggregate | long | string;
};
export interface AggregationsLongTermsAggregate extends AggregationsTermsAggregateBase<AggregationsLongTermsBucket> {
}
export interface AggregationsLongTermsBucketKeys extends AggregationsTermsBucketBase {
    key: long;
    key_as_string?: string;
}
export type AggregationsLongTermsBucket = AggregationsLongTermsBucketKeys & {
    [property: string]: AggregationsAggregate | long | string;
};
export interface AggregationsMatrixAggregation {
    /** An array of fields for computing the statistics. */
    fields?: Fields;
    /** The value to apply to documents that do not have a value.
      * By default, documents without a value are ignored. */
    missing?: Record<Field, double>;
}
export interface AggregationsMatrixStatsAggregate extends AggregationsAggregateBase {
    doc_count: long;
    fields?: AggregationsMatrixStatsFields[];
}
export interface AggregationsMatrixStatsAggregation extends AggregationsMatrixAggregation {
    /** Array value the aggregation will use for array or multi-valued fields. */
    mode?: SortMode;
}
export interface AggregationsMatrixStatsFields {
    name: Field;
    count: long;
    mean: double;
    variance: double;
    skewness: double;
    kurtosis: double;
    covariance: Record<Field, double>;
    correlation: Record<Field, double>;
}
export interface AggregationsMaxAggregate extends AggregationsSingleMetricAggregateBase {
}
export interface AggregationsMaxAggregation extends AggregationsFormatMetricAggregationBase {
}
export interface AggregationsMaxBucketAggregation extends AggregationsPipelineAggregationBase {
}
export interface AggregationsMedianAbsoluteDeviationAggregate extends AggregationsSingleMetricAggregateBase {
}
export interface AggregationsMedianAbsoluteDeviationAggregation extends AggregationsFormatMetricAggregationBase {
    /** Limits the maximum number of nodes used by the underlying TDigest algorithm to `20 * compression`, enabling control of memory usage and approximation error. */
    compression?: double;
    /** The default implementation of TDigest is optimized for performance, scaling to millions or even billions of sample values while maintaining acceptable accuracy levels (close to 1% relative error for millions of samples in some cases).
      * To use an implementation optimized for accuracy, set this parameter to high_accuracy instead. */
    execution_hint?: AggregationsTDigestExecutionHint;
}
export interface AggregationsMetricAggregationBase {
    /** The field on which to run the aggregation. */
    field?: Field;
    /** The value to apply to documents that do not have a value.
      * By default, documents without a value are ignored. */
    missing?: AggregationsMissing;
    script?: Script | ScriptSource;
}
export interface AggregationsMinAggregate extends AggregationsSingleMetricAggregateBase {
}
export interface AggregationsMinAggregation extends AggregationsFormatMetricAggregationBase {
}
export interface AggregationsMinBucketAggregation extends AggregationsPipelineAggregationBase {
}
export type AggregationsMinimumInterval = 'second' | 'minute' | 'hour' | 'day' | 'month' | 'year';
export type AggregationsMissing = string | integer | double | boolean;
export interface AggregationsMissingAggregateKeys extends AggregationsSingleBucketAggregateBase {
}
export type AggregationsMissingAggregate = AggregationsMissingAggregateKeys & {
    [property: string]: AggregationsAggregate | long | Metadata;
};
export interface AggregationsMissingAggregation extends AggregationsBucketAggregationBase {
    /** The name of the field. */
    field?: Field;
    missing?: AggregationsMissing;
}
export type AggregationsMissingOrder = 'first' | 'last' | 'default';
export type AggregationsMovingAverageAggregation = AggregationsLinearMovingAverageAggregation | AggregationsSimpleMovingAverageAggregation | AggregationsEwmaMovingAverageAggregation | AggregationsHoltMovingAverageAggregation | AggregationsHoltWintersMovingAverageAggregation;
export interface AggregationsMovingAverageAggregationBase extends AggregationsPipelineAggregationBase {
    minimize?: boolean;
    predict?: integer;
    window?: integer;
}
export interface AggregationsMovingFunctionAggregation extends AggregationsPipelineAggregationBase {
    /** The script that should be executed on each window of data. */
    script?: string;
    /** By default, the window consists of the last n values excluding the current bucket.
      * Increasing `shift` by 1, moves the starting window position by 1 to the right. */
    shift?: integer;
    /** The size of window to "slide" across the histogram. */
    window?: integer;
}
export interface AggregationsMovingPercentilesAggregation extends AggregationsPipelineAggregationBase {
    /** The size of window to "slide" across the histogram. */
    window?: integer;
    /** By default, the window consists of the last n values excluding the current bucket.
      * Increasing `shift` by 1, moves the starting window position by 1 to the right. */
    shift?: integer;
    keyed?: boolean;
}
export interface AggregationsMultiBucketAggregateBase<TBucket = unknown> extends AggregationsAggregateBase {
    buckets: AggregationsBuckets<TBucket>;
}
export interface AggregationsMultiBucketBase {
    doc_count: long;
}
export interface AggregationsMultiTermLookup {
    /** A fields from which to retrieve terms. */
    field: Field;
    /** The value to apply to documents that do not have a value.
      * By default, documents without a value are ignored. */
    missing?: AggregationsMissing;
}
export interface AggregationsMultiTermsAggregate extends AggregationsTermsAggregateBase<AggregationsMultiTermsBucket> {
}
export interface AggregationsMultiTermsAggregation extends AggregationsBucketAggregationBase {
    /** Specifies the strategy for data collection. */
    collect_mode?: AggregationsTermsAggregationCollectMode;
    /** Specifies the sort order of the buckets.
      * Defaults to sorting by descending document count. */
    order?: AggregationsAggregateOrder;
    /** The minimum number of documents in a bucket for it to be returned. */
    min_doc_count?: long;
    /** The minimum number of documents in a bucket on each shard for it to be returned. */
    shard_min_doc_count?: long;
    /** The number of candidate terms produced by each shard.
      * By default, `shard_size` will be automatically estimated based on the number of shards and the `size` parameter. */
    shard_size?: integer;
    /** Calculates the doc count error on per term basis. */
    show_term_doc_count_error?: boolean;
    /** The number of term buckets should be returned out of the overall terms list. */
    size?: integer;
    /** The field from which to generate sets of terms. */
    terms: AggregationsMultiTermLookup[];
}
export interface AggregationsMultiTermsBucketKeys extends AggregationsMultiBucketBase {
    key: FieldValue[];
    key_as_string?: string;
    doc_count_error_upper_bound?: long;
}
export type AggregationsMultiTermsBucket = AggregationsMultiTermsBucketKeys & {
    [property: string]: AggregationsAggregate | FieldValue[] | string | long;
};
export interface AggregationsMutualInformationHeuristic {
    /** Set to `false` if you defined a custom background filter that represents a different set of documents that you want to compare to. */
    background_is_superset?: boolean;
    /** Set to `false` to filter out the terms that appear less often in the subset than in documents outside the subset. */
    include_negatives?: boolean;
}
export interface AggregationsNestedAggregateKeys extends AggregationsSingleBucketAggregateBase {
}
export type AggregationsNestedAggregate = AggregationsNestedAggregateKeys & {
    [property: string]: AggregationsAggregate | long | Metadata;
};
export interface AggregationsNestedAggregation extends AggregationsBucketAggregationBase {
    /** The path to the field of type `nested`. */
    path?: Field;
}
export interface AggregationsNormalizeAggregation extends AggregationsPipelineAggregationBase {
    /** The specific method to apply. */
    method?: AggregationsNormalizeMethod;
}
export type AggregationsNormalizeMethod = 'rescale_0_1' | 'rescale_0_100' | 'percent_of_sum' | 'mean' | 'z-score' | 'softmax';
export interface AggregationsParentAggregateKeys extends AggregationsSingleBucketAggregateBase {
}
export type AggregationsParentAggregate = AggregationsParentAggregateKeys & {
    [property: string]: AggregationsAggregate | long | Metadata;
};
export interface AggregationsParentAggregation extends AggregationsBucketAggregationBase {
    /** The child type that should be selected. */
    type?: RelationName;
}
export interface AggregationsPercentageScoreHeuristic {
}
export interface AggregationsPercentileRanksAggregation extends AggregationsFormatMetricAggregationBase {
    /** By default, the aggregation associates a unique string key with each bucket and returns the ranges as a hash rather than an array.
      * Set to `false` to disable this behavior. */
    keyed?: boolean;
    /** An array of values for which to calculate the percentile ranks. */
    values?: double[] | null;
    /** Uses the alternative High Dynamic Range Histogram algorithm to calculate percentile ranks. */
    hdr?: AggregationsHdrMethod;
    /** Sets parameters for the default TDigest algorithm used to calculate percentile ranks. */
    tdigest?: AggregationsTDigest;
}
export type AggregationsPercentiles = AggregationsKeyedPercentiles | AggregationsArrayPercentilesItem[];
export interface AggregationsPercentilesAggregateBase extends AggregationsAggregateBase {
    values: AggregationsPercentiles;
}
export interface AggregationsPercentilesAggregation extends AggregationsFormatMetricAggregationBase {
    /** By default, the aggregation associates a unique string key with each bucket and returns the ranges as a hash rather than an array.
      * Set to `false` to disable this behavior. */
    keyed?: boolean;
    /** The percentiles to calculate. */
    percents?: double[];
    /** Uses the alternative High Dynamic Range Histogram algorithm to calculate percentiles. */
    hdr?: AggregationsHdrMethod;
    /** Sets parameters for the default TDigest algorithm used to calculate percentiles. */
    tdigest?: AggregationsTDigest;
}
export interface AggregationsPercentilesBucketAggregate extends AggregationsPercentilesAggregateBase {
}
export interface AggregationsPercentilesBucketAggregation extends AggregationsPipelineAggregationBase {
    /** The list of percentiles to calculate. */
    percents?: double[];
}
export interface AggregationsPipelineAggregationBase extends AggregationsBucketPathAggregation {
    /** `DecimalFormat` pattern for the output value.
      * If specified, the formatted value is returned in the aggregation’s `value_as_string` property. */
    format?: string;
    /** Policy to apply when gaps are found in the data. */
    gap_policy?: AggregationsGapPolicy;
}
export interface AggregationsRandomSamplerAggregation extends AggregationsBucketAggregationBase {
    /** The probability that a document will be included in the aggregated data.
      * Must be greater than 0, less than 0.5, or exactly 1.
      * The lower the probability, the fewer documents are matched. */
    probability: double;
    /** The seed to generate the random sampling of documents.
      * When a seed is provided, the random subset of documents is the same between calls. */
    seed?: integer;
    /** When combined with seed, setting shard_seed ensures 100% consistent sampling over shards where data is exactly the same.
      * @remarks This property is not supported on Elastic Cloud Serverless. */
    shard_seed?: integer;
}
export interface AggregationsRangeAggregate extends AggregationsMultiBucketAggregateBase<AggregationsRangeBucket> {
}
export interface AggregationsRangeAggregation extends AggregationsBucketAggregationBase {
    /** The date field whose values are use to build ranges. */
    field?: Field;
    /** The value to apply to documents that do not have a value.
      * By default, documents without a value are ignored. */
    missing?: integer;
    /** An array of ranges used to bucket documents. */
    ranges?: AggregationsAggregationRange[];
    script?: Script | ScriptSource;
    /** Set to `true` to associate a unique string key with each bucket and return the ranges as a hash rather than an array. */
    keyed?: boolean;
    format?: string;
}
export interface AggregationsRangeBucketKeys extends AggregationsMultiBucketBase {
    from?: double;
    to?: double;
    from_as_string?: string;
    to_as_string?: string;
    /** The bucket key. Present if the aggregation is _not_ keyed */
    key?: string;
}
export type AggregationsRangeBucket = AggregationsRangeBucketKeys & {
    [property: string]: AggregationsAggregate | double | string | long;
};
export interface AggregationsRareTermsAggregation extends AggregationsBucketAggregationBase {
    /** Terms that should be excluded from the aggregation. */
    exclude?: AggregationsTermsExclude;
    /** The field from which to return rare terms. */
    field?: Field;
    /** Terms that should be included in the aggregation. */
    include?: AggregationsTermsInclude;
    /** The maximum number of documents a term should appear in. */
    max_doc_count?: long;
    /** The value to apply to documents that do not have a value.
      * By default, documents without a value are ignored. */
    missing?: AggregationsMissing;
    /** The precision of the internal CuckooFilters.
      * Smaller precision leads to better approximation, but higher memory usage. */
    precision?: double;
    value_type?: string;
}
export interface AggregationsRateAggregate extends AggregationsAggregateBase {
    value: double;
    value_as_string?: string;
}
export interface AggregationsRateAggregation extends AggregationsFormatMetricAggregationBase {
    /** The interval used to calculate the rate.
      * By default, the interval of the `date_histogram` is used. */
    unit?: AggregationsCalendarInterval;
    /** How the rate is calculated. */
    mode?: AggregationsRateMode;
}
export type AggregationsRateMode = 'sum' | 'value_count';
export interface AggregationsReverseNestedAggregateKeys extends AggregationsSingleBucketAggregateBase {
}
export type AggregationsReverseNestedAggregate = AggregationsReverseNestedAggregateKeys & {
    [property: string]: AggregationsAggregate | long | Metadata;
};
export interface AggregationsReverseNestedAggregation extends AggregationsBucketAggregationBase {
    /** Defines the nested object field that should be joined back to.
      * The default is empty, which means that it joins back to the root/main document level. */
    path?: Field;
}
export interface AggregationsSamplerAggregateKeys extends AggregationsSingleBucketAggregateBase {
}
export type AggregationsSamplerAggregate = AggregationsSamplerAggregateKeys & {
    [property: string]: AggregationsAggregate | long | Metadata;
};
export interface AggregationsSamplerAggregation extends AggregationsBucketAggregationBase {
    /** Limits how many top-scoring documents are collected in the sample processed on each shard. */
    shard_size?: integer;
}
export type AggregationsSamplerAggregationExecutionHint = 'map' | 'global_ordinals' | 'bytes_hash';
export interface AggregationsScriptedHeuristic {
    script: Script | ScriptSource;
}
export interface AggregationsScriptedMetricAggregate extends AggregationsAggregateBase {
    value: any;
}
export interface AggregationsScriptedMetricAggregation extends AggregationsMetricAggregationBase {
    /** Runs once on each shard after document collection is complete.
      * Allows the aggregation to consolidate the state returned from each shard. */
    combine_script?: Script | ScriptSource;
    /** Runs prior to any collection of documents.
      * Allows the aggregation to set up any initial state. */
    init_script?: Script | ScriptSource;
    /** Run once per document collected.
      * If no `combine_script` is specified, the resulting state needs to be stored in the `state` object. */
    map_script?: Script | ScriptSource;
    /** A global object with script parameters for `init`, `map` and `combine` scripts.
      * It is shared between the scripts. */
    params?: Record<string, any>;
    /** Runs once on the coordinating node after all shards have returned their results.
      * The script is provided with access to a variable `states`, which is an array of the result of the `combine_script` on each shard. */
    reduce_script?: Script | ScriptSource;
}
export interface AggregationsSerialDifferencingAggregation extends AggregationsPipelineAggregationBase {
    /** The historical bucket to subtract from the current value.
      * Must be a positive, non-zero integer. */
    lag?: integer;
}
export interface AggregationsSignificantLongTermsAggregate extends AggregationsSignificantTermsAggregateBase<AggregationsSignificantLongTermsBucket> {
}
export interface AggregationsSignificantLongTermsBucketKeys extends AggregationsSignificantTermsBucketBase {
    key: long;
    key_as_string?: string;
}
export type AggregationsSignificantLongTermsBucket = AggregationsSignificantLongTermsBucketKeys & {
    [property: string]: AggregationsAggregate | long | string | double;
};
export interface AggregationsSignificantStringTermsAggregate extends AggregationsSignificantTermsAggregateBase<AggregationsSignificantStringTermsBucket> {
}
export interface AggregationsSignificantStringTermsBucketKeys extends AggregationsSignificantTermsBucketBase {
    key: string;
}
export type AggregationsSignificantStringTermsBucket = AggregationsSignificantStringTermsBucketKeys & {
    [property: string]: AggregationsAggregate | string | double | long;
};
export interface AggregationsSignificantTermsAggregateBase<T = unknown> extends AggregationsMultiBucketAggregateBase<T> {
    bg_count?: long;
    doc_count?: long;
}
export interface AggregationsSignificantTermsAggregation extends AggregationsBucketAggregationBase {
    /** A background filter that can be used to focus in on significant terms within a narrower context, instead of the entire index. */
    background_filter?: QueryDslQueryContainer;
    /** Use Chi square, as described in "Information Retrieval", Manning et al., Chapter 13.5.2, as the significance score. */
    chi_square?: AggregationsChiSquareHeuristic;
    /** Terms to exclude. */
    exclude?: AggregationsTermsExclude;
    /** Mechanism by which the aggregation should be executed: using field values directly or using global ordinals. */
    execution_hint?: AggregationsTermsAggregationExecutionHint;
    /** The field from which to return significant terms. */
    field?: Field;
    /** Use Google normalized distance as described in "The Google Similarity Distance", Cilibrasi and Vitanyi, 2007, as the significance score. */
    gnd?: AggregationsGoogleNormalizedDistanceHeuristic;
    /** Terms to include. */
    include?: AggregationsTermsInclude;
    /** Use JLH score as the significance score. */
    jlh?: EmptyObject;
    /** Only return terms that are found in more than `min_doc_count` hits. */
    min_doc_count?: long;
    /** Use mutual information as described in "Information Retrieval", Manning et al., Chapter 13.5.1, as the significance score. */
    mutual_information?: AggregationsMutualInformationHeuristic;
    /** A simple calculation of the number of documents in the foreground sample with a term divided by the number of documents in the background with the term. */
    percentage?: AggregationsPercentageScoreHeuristic;
    /** Customized score, implemented via a script. */
    script_heuristic?: AggregationsScriptedHeuristic;
    /** Regulates the certainty a shard has if the term should actually be added to the candidate list or not with respect to the `min_doc_count`.
      * Terms will only be considered if their local shard frequency within the set is higher than the `shard_min_doc_count`. */
    shard_min_doc_count?: long;
    /** Can be used to control the volumes of candidate terms produced by each shard.
      * By default, `shard_size` will be automatically estimated based on the number of shards and the `size` parameter. */
    shard_size?: integer;
    /** The number of buckets returned out of the overall terms list. */
    size?: integer;
}
export interface AggregationsSignificantTermsBucketBase extends AggregationsMultiBucketBase {
    score: double;
    bg_count: long;
}
export interface AggregationsSignificantTextAggregation extends AggregationsBucketAggregationBase {
    /** A background filter that can be used to focus in on significant terms within a narrower context, instead of the entire index. */
    background_filter?: QueryDslQueryContainer;
    /** Use Chi square, as described in "Information Retrieval", Manning et al., Chapter 13.5.2, as the significance score. */
    chi_square?: AggregationsChiSquareHeuristic;
    /** Values to exclude. */
    exclude?: AggregationsTermsExclude;
    /** Determines whether the aggregation will use field values directly or global ordinals. */
    execution_hint?: AggregationsTermsAggregationExecutionHint;
    /** The field from which to return significant text. */
    field?: Field;
    /** Whether to out duplicate text to deal with noisy data. */
    filter_duplicate_text?: boolean;
    /** Use Google normalized distance as described in "The Google Similarity Distance", Cilibrasi and Vitanyi, 2007, as the significance score. */
    gnd?: AggregationsGoogleNormalizedDistanceHeuristic;
    /** Values to include. */
    include?: AggregationsTermsInclude;
    /** Use JLH score as the significance score. */
    jlh?: EmptyObject;
    /** Only return values that are found in more than `min_doc_count` hits. */
    min_doc_count?: long;
    /** Use mutual information as described in "Information Retrieval", Manning et al., Chapter 13.5.1, as the significance score. */
    mutual_information?: AggregationsMutualInformationHeuristic;
    /** A simple calculation of the number of documents in the foreground sample with a term divided by the number of documents in the background with the term. */
    percentage?: AggregationsPercentageScoreHeuristic;
    /** Customized score, implemented via a script. */
    script_heuristic?: AggregationsScriptedHeuristic;
    /** Regulates the certainty a shard has if the values should actually be added to the candidate list or not with respect to the min_doc_count.
      * Values will only be considered if their local shard frequency within the set is higher than the `shard_min_doc_count`. */
    shard_min_doc_count?: long;
    /** The number of candidate terms produced by each shard.
      * By default, `shard_size` will be automatically estimated based on the number of shards and the `size` parameter. */
    shard_size?: integer;
    /** The number of buckets returned out of the overall terms list. */
    size?: integer;
    /** Overrides the JSON `_source` fields from which text will be analyzed. */
    source_fields?: Fields;
}
export interface AggregationsSimpleMovingAverageAggregation extends AggregationsMovingAverageAggregationBase {
    model: 'simple';
    settings: EmptyObject;
}
export interface AggregationsSimpleValueAggregate extends AggregationsSingleMetricAggregateBase {
}
export interface AggregationsSingleBucketAggregateBase extends AggregationsAggregateBase {
    doc_count: long;
}
export interface AggregationsSingleMetricAggregateBase extends AggregationsAggregateBase {
    /** The metric value. A missing value generally means that there was no data to aggregate,
      * unless specified otherwise. */
    value: double | null;
    value_as_string?: string;
}
export interface AggregationsStandardDeviationBounds {
    upper: double | null;
    lower: double | null;
    upper_population: double | null;
    lower_population: double | null;
    upper_sampling: double | null;
    lower_sampling: double | null;
}
export interface AggregationsStandardDeviationBoundsAsString {
    upper: string;
    lower: string;
    upper_population: string;
    lower_population: string;
    upper_sampling: string;
    lower_sampling: string;
}
export interface AggregationsStatsAggregate extends AggregationsAggregateBase {
    count: long;
    min: double | null;
    max: double | null;
    avg: double | null;
    sum: double;
    min_as_string?: string;
    max_as_string?: string;
    avg_as_string?: string;
    sum_as_string?: string;
}
export interface AggregationsStatsAggregation extends AggregationsFormatMetricAggregationBase {
}
export interface AggregationsStatsBucketAggregate extends AggregationsStatsAggregate {
}
export interface AggregationsStatsBucketAggregation extends AggregationsPipelineAggregationBase {
}
export interface AggregationsStringRareTermsAggregate extends AggregationsMultiBucketAggregateBase<AggregationsStringRareTermsBucket> {
}
export interface AggregationsStringRareTermsBucketKeys extends AggregationsMultiBucketBase {
    key: string;
}
export type AggregationsStringRareTermsBucket = AggregationsStringRareTermsBucketKeys & {
    [property: string]: AggregationsAggregate | string | long;
};
export interface AggregationsStringStatsAggregate extends AggregationsAggregateBase {
    count: long;
    min_length: integer | null;
    max_length: integer | null;
    avg_length: double | null;
    entropy: double | null;
    distribution?: Record<string, double> | null;
    min_length_as_string?: string;
    max_length_as_string?: string;
    avg_length_as_string?: string;
}
export interface AggregationsStringStatsAggregation extends AggregationsMetricAggregationBase {
    /** Shows the probability distribution for all characters. */
    show_distribution?: boolean;
}
export interface AggregationsStringTermsAggregate extends AggregationsTermsAggregateBase<AggregationsStringTermsBucket> {
}
export interface AggregationsStringTermsBucketKeys extends AggregationsTermsBucketBase {
    key: FieldValue;
}
export type AggregationsStringTermsBucket = AggregationsStringTermsBucketKeys & {
    [property: string]: AggregationsAggregate | FieldValue | long;
};
export interface AggregationsSumAggregate extends AggregationsSingleMetricAggregateBase {
}
export interface AggregationsSumAggregation extends AggregationsFormatMetricAggregationBase {
}
export interface AggregationsSumBucketAggregation extends AggregationsPipelineAggregationBase {
}
export interface AggregationsTDigest {
    /** Limits the maximum number of nodes used by the underlying TDigest algorithm to `20 * compression`, enabling control of memory usage and approximation error. */
    compression?: integer;
    /** The default implementation of TDigest is optimized for performance, scaling to millions or even billions of sample values while maintaining acceptable accuracy levels (close to 1% relative error for millions of samples in some cases).
      * To use an implementation optimized for accuracy, set this parameter to high_accuracy instead. */
    execution_hint?: AggregationsTDigestExecutionHint;
}
export type AggregationsTDigestExecutionHint = 'default' | 'high_accuracy';
export interface AggregationsTDigestPercentileRanksAggregate extends AggregationsPercentilesAggregateBase {
}
export interface AggregationsTDigestPercentilesAggregate extends AggregationsPercentilesAggregateBase {
}
export interface AggregationsTTestAggregate extends AggregationsAggregateBase {
    value: double | null;
    value_as_string?: string;
}
export interface AggregationsTTestAggregation {
    /** Test population A. */
    a?: AggregationsTestPopulation;
    /** Test population B. */
    b?: AggregationsTestPopulation;
    /** The type of test. */
    type?: AggregationsTTestType;
}
export type AggregationsTTestType = 'paired' | 'homoscedastic' | 'heteroscedastic';
export interface AggregationsTermsAggregateBase<TBucket = unknown> extends AggregationsMultiBucketAggregateBase<TBucket> {
    doc_count_error_upper_bound?: long;
    sum_other_doc_count?: long;
}
export interface AggregationsTermsAggregation extends AggregationsBucketAggregationBase {
    /** Determines how child aggregations should be calculated: breadth-first or depth-first. */
    collect_mode?: AggregationsTermsAggregationCollectMode;
    /** Values to exclude.
      * Accepts regular expressions and partitions. */
    exclude?: AggregationsTermsExclude;
    /** Determines whether the aggregation will use field values directly or global ordinals. */
    execution_hint?: AggregationsTermsAggregationExecutionHint;
    /** The field from which to return terms. */
    field?: Field;
    /** Values to include.
      * Accepts regular expressions and partitions. */
    include?: AggregationsTermsInclude;
    /** Only return values that are found in more than `min_doc_count` hits. */
    min_doc_count?: integer;
    /** The value to apply to documents that do not have a value.
      * By default, documents without a value are ignored. */
    missing?: AggregationsMissing;
    missing_order?: AggregationsMissingOrder;
    missing_bucket?: boolean;
    /** Coerced unmapped fields into the specified type. */
    value_type?: string;
    /** Specifies the sort order of the buckets.
      * Defaults to sorting by descending document count. */
    order?: AggregationsAggregateOrder;
    script?: Script | ScriptSource;
    /** Regulates the certainty a shard has if the term should actually be added to the candidate list or not with respect to the `min_doc_count`.
      * Terms will only be considered if their local shard frequency within the set is higher than the `shard_min_doc_count`. */
    shard_min_doc_count?: long;
    /** The number of candidate terms produced by each shard.
      * By default, `shard_size` will be automatically estimated based on the number of shards and the `size` parameter. */
    shard_size?: integer;
    /** Set to `true` to return the `doc_count_error_upper_bound`, which is an upper bound to the error on the `doc_count` returned by each shard. */
    show_term_doc_count_error?: boolean;
    /** The number of buckets returned out of the overall terms list. */
    size?: integer;
    format?: string;
}
export type AggregationsTermsAggregationCollectMode = 'depth_first' | 'breadth_first';
export type AggregationsTermsAggregationExecutionHint = 'map' | 'global_ordinals' | 'global_ordinals_hash' | 'global_ordinals_low_cardinality';
export interface AggregationsTermsBucketBase extends AggregationsMultiBucketBase {
    doc_count_error_upper_bound?: long;
}
export type AggregationsTermsExclude = string | string[];
export type AggregationsTermsInclude = string | string[] | AggregationsTermsPartition;
export interface AggregationsTermsPartition {
    /** The number of partitions. */
    num_partitions: long;
    /** The partition number for this request. */
    partition: long;
}
export interface AggregationsTestPopulation {
    /** The field to aggregate. */
    field: Field;
    script?: Script | ScriptSource;
    /** A filter used to define a set of records to run unpaired t-test on. */
    filter?: QueryDslQueryContainer;
}
export interface AggregationsTimeSeriesAggregate extends AggregationsMultiBucketAggregateBase<AggregationsTimeSeriesBucket> {
}
export interface AggregationsTimeSeriesAggregation extends AggregationsBucketAggregationBase {
    /** The maximum number of results to return. */
    size?: integer;
    /** Set to `true` to associate a unique string key with each bucket and returns the ranges as a hash rather than an array. */
    keyed?: boolean;
}
export interface AggregationsTimeSeriesBucketKeys extends AggregationsMultiBucketBase {
    key: Record<Field, FieldValue>;
}
export type AggregationsTimeSeriesBucket = AggregationsTimeSeriesBucketKeys & {
    [property: string]: AggregationsAggregate | Record<Field, FieldValue> | long;
};
export interface AggregationsTopHitsAggregate extends AggregationsAggregateBase {
    hits: SearchHitsMetadata<any>;
}
export interface AggregationsTopHitsAggregation extends AggregationsMetricAggregationBase {
    /** Fields for which to return doc values. */
    docvalue_fields?: (QueryDslFieldAndFormat | Field)[];
    /** If `true`, returns detailed information about score computation as part of a hit. */
    explain?: boolean;
    /** Array of wildcard (*) patterns. The request returns values for field names
      * matching these patterns in the hits.fields property of the response. */
    fields?: (QueryDslFieldAndFormat | Field)[];
    /** Starting document offset. */
    from?: integer;
    /** Specifies the highlighter to use for retrieving highlighted snippets from one or more fields in the search results. */
    highlight?: SearchHighlight;
    /** Returns the result of one or more script evaluations for each hit. */
    script_fields?: Record<string, ScriptField>;
    /** The maximum number of top matching hits to return per bucket. */
    size?: integer;
    /** Sort order of the top matching hits.
      * By default, the hits are sorted by the score of the main query. */
    sort?: Sort;
    /** Selects the fields of the source that are returned. */
    _source?: SearchSourceConfig;
    /** Returns values for the specified stored fields (fields that use the `store` mapping option). */
    stored_fields?: Fields;
    /** If `true`, calculates and returns document scores, even if the scores are not used for sorting. */
    track_scores?: boolean;
    /** If `true`, returns document version as part of a hit. */
    version?: boolean;
    /** If `true`, returns sequence number and primary term of the last modification of each hit. */
    seq_no_primary_term?: boolean;
}
export interface AggregationsTopMetrics {
    sort: (FieldValue | null)[];
    metrics: Record<string, FieldValue | null>;
}
export interface AggregationsTopMetricsAggregate extends AggregationsAggregateBase {
    top: AggregationsTopMetrics[];
}
export interface AggregationsTopMetricsAggregation extends AggregationsMetricAggregationBase {
    /** The fields of the top document to return. */
    metrics?: AggregationsTopMetricsValue | AggregationsTopMetricsValue[];
    /** The number of top documents from which to return metrics. */
    size?: integer;
    /** The sort order of the documents. */
    sort?: Sort;
}
export interface AggregationsTopMetricsValue {
    /** A field to return as a metric. */
    field: Field;
}
export interface AggregationsUnmappedRareTermsAggregate extends AggregationsMultiBucketAggregateBase<void> {
}
export interface AggregationsUnmappedSamplerAggregateKeys extends AggregationsSingleBucketAggregateBase {
}
export type AggregationsUnmappedSamplerAggregate = AggregationsUnmappedSamplerAggregateKeys & {
    [property: string]: AggregationsAggregate | long | Metadata;
};
export interface AggregationsUnmappedSignificantTermsAggregate extends AggregationsSignificantTermsAggregateBase<void> {
}
export interface AggregationsUnmappedTermsAggregate extends AggregationsTermsAggregateBase<void> {
}
export interface AggregationsValueCountAggregate extends AggregationsSingleMetricAggregateBase {
}
export interface AggregationsValueCountAggregation extends AggregationsFormattableMetricAggregation {
}
export type AggregationsValueType = 'string' | 'long' | 'double' | 'number' | 'date' | 'date_nanos' | 'ip' | 'numeric' | 'geo_point' | 'boolean';
export interface AggregationsVariableWidthHistogramAggregate extends AggregationsMultiBucketAggregateBase<AggregationsVariableWidthHistogramBucket> {
}
export interface AggregationsVariableWidthHistogramAggregation {
    /** The name of the field. */
    field?: Field;
    /** The target number of buckets. */
    buckets?: integer;
    /** The number of buckets that the coordinating node will request from each shard.
      * Defaults to `buckets * 50`. */
    shard_size?: integer;
    /** Specifies the number of individual documents that will be stored in memory on a shard before the initial bucketing algorithm is run.
      * Defaults to `min(10 * shard_size, 50000)`. */
    initial_buffer?: integer;
    script?: Script | ScriptSource;
}
export interface AggregationsVariableWidthHistogramBucketKeys extends AggregationsMultiBucketBase {
    min: double;
    key: double;
    max: double;
    min_as_string?: string;
    key_as_string?: string;
    max_as_string?: string;
}
export type AggregationsVariableWidthHistogramBucket = AggregationsVariableWidthHistogramBucketKeys & {
    [property: string]: AggregationsAggregate | double | string | long;
};
export interface AggregationsWeightedAverageAggregation {
    /** A numeric response formatter. */
    format?: string;
    /** Configuration for the field that provides the values. */
    value?: AggregationsWeightedAverageValue;
    value_type?: AggregationsValueType;
    /** Configuration for the field or script that provides the weights. */
    weight?: AggregationsWeightedAverageValue;
}
export interface AggregationsWeightedAverageValue {
    /** The field from which to extract the values or weights. */
    field?: Field;
    /** A value or weight to use if the field is missing. */
    missing?: double;
    script?: Script | ScriptSource;
}
export interface AggregationsWeightedAvgAggregate extends AggregationsSingleMetricAggregateBase {
}
export type AnalysisAnalyzer = AnalysisCustomAnalyzer | AnalysisFingerprintAnalyzer | AnalysisKeywordAnalyzer | AnalysisNoriAnalyzer | AnalysisPatternAnalyzer | AnalysisSimpleAnalyzer | AnalysisStandardAnalyzer | AnalysisStopAnalyzer | AnalysisWhitespaceAnalyzer | AnalysisIcuAnalyzer | AnalysisKuromojiAnalyzer | AnalysisSnowballAnalyzer | AnalysisArabicAnalyzer | AnalysisArmenianAnalyzer | AnalysisBasqueAnalyzer | AnalysisBengaliAnalyzer | AnalysisBrazilianAnalyzer | AnalysisBulgarianAnalyzer | AnalysisCatalanAnalyzer | AnalysisChineseAnalyzer | AnalysisCjkAnalyzer | AnalysisCzechAnalyzer | AnalysisDanishAnalyzer | AnalysisDutchAnalyzer | AnalysisEnglishAnalyzer | AnalysisEstonianAnalyzer | AnalysisFinnishAnalyzer | AnalysisFrenchAnalyzer | AnalysisGalicianAnalyzer | AnalysisGermanAnalyzer | AnalysisGreekAnalyzer | AnalysisHindiAnalyzer | AnalysisHungarianAnalyzer | AnalysisIndonesianAnalyzer | AnalysisIrishAnalyzer | AnalysisItalianAnalyzer | AnalysisLatvianAnalyzer | AnalysisLithuanianAnalyzer | AnalysisNorwegianAnalyzer | AnalysisPersianAnalyzer | AnalysisPortugueseAnalyzer | AnalysisRomanianAnalyzer | AnalysisRussianAnalyzer | AnalysisSerbianAnalyzer | AnalysisSoraniAnalyzer | AnalysisSpanishAnalyzer | AnalysisSwedishAnalyzer | AnalysisTurkishAnalyzer | AnalysisThaiAnalyzer;
export interface AnalysisApostropheTokenFilter extends AnalysisTokenFilterBase {
    type: 'apostrophe';
}
export interface AnalysisArabicAnalyzer {
    type: 'arabic';
    stopwords?: AnalysisStopWords;
    stopwords_path?: string;
    stem_exclusion?: string[];
}
export interface AnalysisArabicNormalizationTokenFilter extends AnalysisTokenFilterBase {
    type: 'arabic_normalization';
}
export interface AnalysisArabicStemTokenFilter extends AnalysisTokenFilterBase {
    type: 'arabic_stem';
}
export interface AnalysisArmenianAnalyzer {
    type: 'armenian';
    stopwords?: AnalysisStopWords;
    stopwords_path?: string;
    stem_exclusion?: string[];
}
export interface AnalysisAsciiFoldingTokenFilter extends AnalysisTokenFilterBase {
    type: 'asciifolding';
    /** If `true`, emit both original tokens and folded tokens. Defaults to `false`. */
    preserve_original?: SpecUtilsStringified<boolean>;
}
export interface AnalysisBasqueAnalyzer {
    type: 'basque';
    stopwords?: AnalysisStopWords;
    stopwords_path?: string;
    stem_exclusion?: string[];
}
export interface AnalysisBengaliAnalyzer {
    type: 'bengali';
    stopwords?: AnalysisStopWords;
    stopwords_path?: string;
    stem_exclusion?: string[];
}
export interface AnalysisBengaliNormalizationTokenFilter extends AnalysisTokenFilterBase {
    type: 'bengali_normalization';
}
export interface AnalysisBrazilianAnalyzer {
    type: 'brazilian';
    stopwords?: AnalysisStopWords;
    stopwords_path?: string;
}
export interface AnalysisBrazilianStemTokenFilter extends AnalysisTokenFilterBase {
    type: 'brazilian_stem';
}
export interface AnalysisBulgarianAnalyzer {
    type: 'bulgarian';
    stopwords?: AnalysisStopWords;
    stopwords_path?: string;
    stem_exclusion?: string[];
}
export interface AnalysisCatalanAnalyzer {
    type: 'catalan';
    stopwords?: AnalysisStopWords;
    stopwords_path?: string;
    stem_exclusion?: string[];
}
export type AnalysisCharFilter = string | AnalysisCharFilterDefinition;
export interface AnalysisCharFilterBase {
    version?: VersionString;
}
export type AnalysisCharFilterDefinition = AnalysisHtmlStripCharFilter | AnalysisMappingCharFilter | AnalysisPatternReplaceCharFilter | AnalysisIcuNormalizationCharFilter | AnalysisKuromojiIterationMarkCharFilter;
export interface AnalysisCharGroupTokenizer extends AnalysisTokenizerBase {
    type: 'char_group';
    tokenize_on_chars: string[];
    max_token_length?: integer;
}
export interface AnalysisChineseAnalyzer {
    type: 'chinese';
    stopwords?: AnalysisStopWords;
    stopwords_path?: string;
}
export interface AnalysisCjkAnalyzer {
    type: 'cjk';
    stopwords?: AnalysisStopWords;
    stopwords_path?: string;
}
export type AnalysisCjkBigramIgnoredScript = 'han' | 'hangul' | 'hiragana' | 'katakana';
export interface AnalysisCjkBigramTokenFilter extends AnalysisTokenFilterBase {
    type: 'cjk_bigram';
    /** Array of character scripts for which to disable bigrams. */
    ignored_scripts?: AnalysisCjkBigramIgnoredScript[];
    /** If `true`, emit tokens in both bigram and unigram form. If `false`, a CJK character is output in unigram form when it has no adjacent characters. Defaults to `false`. */
    output_unigrams?: boolean;
}
export interface AnalysisCjkWidthTokenFilter extends AnalysisTokenFilterBase {
    type: 'cjk_width';
}
export interface AnalysisClassicTokenFilter extends AnalysisTokenFilterBase {
    type: 'classic';
}
export interface AnalysisClassicTokenizer extends AnalysisTokenizerBase {
    type: 'classic';
    max_token_length?: integer;
}
export interface AnalysisCommonGramsTokenFilter extends AnalysisTokenFilterBase {
    type: 'common_grams';
    /** A list of tokens. The filter generates bigrams for these tokens.
      * Either this or the `common_words_path` parameter is required. */
    common_words?: string[];
    /** Path to a file containing a list of tokens. The filter generates bigrams for these tokens.
      * This path must be absolute or relative to the `config` location. The file must be UTF-8 encoded. Each token in the file must be separated by a line break.
      * Either this or the `common_words` parameter is required. */
    common_words_path?: string;
    /** If `true`, matches for common words matching are case-insensitive. Defaults to `false`. */
    ignore_case?: boolean;
    /** If `true`, the filter excludes the following tokens from the output:
      * - Unigrams for common words
      * - Unigrams for terms followed by common words
      * Defaults to `false`. We recommend enabling this parameter for search analyzers. */
    query_mode?: boolean;
}
export interface AnalysisCompoundWordTokenFilterBase extends AnalysisTokenFilterBase {
    /** Maximum subword character length. Longer subword tokens are excluded from the output. Defaults to `15`. */
    max_subword_size?: integer;
    /** Minimum subword character length. Shorter subword tokens are excluded from the output. Defaults to `2`. */
    min_subword_size?: integer;
    /** Minimum word character length. Shorter word tokens are excluded from the output. Defaults to `5`. */
    min_word_size?: integer;
    /** If `true`, only include the longest matching subword. Defaults to `false`. */
    only_longest_match?: boolean;
    /** A list of subwords to look for in the token stream. If found, the subword is included in the token output.
      * Either this parameter or `word_list_path` must be specified. */
    word_list?: string[];
    /** Path to a file that contains a list of subwords to find in the token stream. If found, the subword is included in the token output.
      * This path must be absolute or relative to the config location, and the file must be UTF-8 encoded. Each token in the file must be separated by a line break.
      * Either this parameter or `word_list` must be specified. */
    word_list_path?: string;
}
export interface AnalysisConditionTokenFilter extends AnalysisTokenFilterBase {
    type: 'condition';
    /** Array of token filters. If a token matches the predicate script in the `script` parameter, these filters are applied to the token in the order provided. */
    filter: string[];
    /** Predicate script used to apply token filters. If a token matches this script, the filters in the `filter` parameter are applied to the token. */
    script: Script | ScriptSource;
}
export interface AnalysisCustomAnalyzer {
    type: 'custom';
    char_filter?: string | string[];
    filter?: string | string[];
    position_increment_gap?: integer;
    position_offset_gap?: integer;
    tokenizer: string;
}
export interface AnalysisCustomNormalizer {
    type: 'custom';
    char_filter?: string[];
    filter?: string[];
}
export interface AnalysisCzechAnalyzer {
    type: 'czech';
    stopwords?: AnalysisStopWords;
    stopwords_path?: string;
    stem_exclusion?: string[];
}
export interface AnalysisCzechStemTokenFilter extends AnalysisTokenFilterBase {
    type: 'czech_stem';
}
export interface AnalysisDanishAnalyzer {
    type: 'danish';
    stopwords?: AnalysisStopWords;
    stopwords_path?: string;
}
export interface AnalysisDecimalDigitTokenFilter extends AnalysisTokenFilterBase {
    type: 'decimal_digit';
}
export type AnalysisDelimitedPayloadEncoding = 'int' | 'float' | 'identity';
export interface AnalysisDelimitedPayloadTokenFilter extends AnalysisTokenFilterBase {
    type: 'delimited_payload';
    /** Character used to separate tokens from payloads. Defaults to `|`. */
    delimiter?: string;
    /** Data type for the stored payload. */
    encoding?: AnalysisDelimitedPayloadEncoding;
}
export interface AnalysisDictionaryDecompounderTokenFilter extends AnalysisCompoundWordTokenFilterBase {
    type: 'dictionary_decompounder';
}
export interface AnalysisDutchAnalyzer {
    type: 'dutch';
    stopwords?: AnalysisStopWords;
    stopwords_path?: string;
    stem_exclusion?: string[];
}
export interface AnalysisDutchStemTokenFilter extends AnalysisTokenFilterBase {
    type: 'dutch_stem';
}
export type AnalysisEdgeNGramSide = 'front' | 'back';
export interface AnalysisEdgeNGramTokenFilter extends AnalysisTokenFilterBase {
    type: 'edge_ngram';
    /** Maximum character length of a gram. For custom token filters, defaults to `2`. For the built-in edge_ngram filter, defaults to `1`. */
    max_gram?: integer;
    /** Minimum character length of a gram. Defaults to `1`. */
    min_gram?: integer;
    /** Indicates whether to truncate tokens from the `front` or `back`. Defaults to `front`. */
    side?: AnalysisEdgeNGramSide;
    /** Emits original token when set to `true`. Defaults to `false`. */
    preserve_original?: SpecUtilsStringified<boolean>;
}
export interface AnalysisEdgeNGramTokenizer extends AnalysisTokenizerBase {
    type: 'edge_ngram';
    custom_token_chars?: string;
    max_gram?: integer;
    min_gram?: integer;
    token_chars?: AnalysisTokenChar[];
}
export interface AnalysisElisionTokenFilter extends AnalysisTokenFilterBase {
    type: 'elision';
    /** List of elisions to remove.
      * To be removed, the elision must be at the beginning of a token and be immediately followed by an apostrophe. Both the elision and apostrophe are removed.
      * For custom `elision` filters, either this parameter or `articles_path` must be specified. */
    articles?: string[];
    /** Path to a file that contains a list of elisions to remove.
      * This path must be absolute or relative to the `config` location, and the file must be UTF-8 encoded. Each elision in the file must be separated by a line break.
      * To be removed, the elision must be at the beginning of a token and be immediately followed by an apostrophe. Both the elision and apostrophe are removed.
      * For custom `elision` filters, either this parameter or `articles` must be specified. */
    articles_path?: string;
    /** If `true`, elision matching is case insensitive. If `false`, elision matching is case sensitive. Defaults to `false`. */
    articles_case?: SpecUtilsStringified<boolean>;
}
export interface AnalysisEnglishAnalyzer {
    type: 'english';
    stopwords?: AnalysisStopWords;
    stopwords_path?: string;
    stem_exclusion?: string[];
}
export interface AnalysisEstonianAnalyzer {
    type: 'estonian';
    stopwords?: AnalysisStopWords;
    stopwords_path?: string;
}
export interface AnalysisFingerprintAnalyzer {
    type: 'fingerprint';
    version?: VersionString;
    /** The maximum token size to emit. Tokens larger than this size will be discarded.
      * Defaults to `255` */
    max_output_size?: integer;
    /** The character to use to concatenate the terms.
      * Defaults to a space. */
    separator?: string;
    /** A pre-defined stop words list like `_english_` or an array containing a list of stop words.
      * Defaults to `_none_`. */
    stopwords?: AnalysisStopWords;
    /** The path to a file containing stop words. */
    stopwords_path?: string;
}
export interface AnalysisFingerprintTokenFilter extends AnalysisTokenFilterBase {
    type: 'fingerprint';
    /** Maximum character length, including whitespace, of the output token. Defaults to `255`. Concatenated tokens longer than this will result in no token output. */
    max_output_size?: integer;
    /** Character to use to concatenate the token stream input. Defaults to a space. */
    separator?: string;
}
export interface AnalysisFinnishAnalyzer {
    type: 'finnish';
    stopwords?: AnalysisStopWords;
    stopwords_path?: string;
    stem_exclusion?: string[];
}
export interface AnalysisFlattenGraphTokenFilter extends AnalysisTokenFilterBase {
    type: 'flatten_graph';
}
export interface AnalysisFrenchAnalyzer {
    type: 'french';
    stopwords?: AnalysisStopWords;
    stopwords_path?: string;
    stem_exclusion?: string[];
}
export interface AnalysisFrenchStemTokenFilter extends AnalysisTokenFilterBase {
    type: 'french_stem';
}
export interface AnalysisGalicianAnalyzer {
    type: 'galician';
    stopwords?: AnalysisStopWords;
    stopwords_path?: string;
    stem_exclusion?: string[];
}
export interface AnalysisGermanAnalyzer {
    type: 'german';
    stopwords?: AnalysisStopWords;
    stopwords_path?: string;
    stem_exclusion?: string[];
}
export interface AnalysisGermanNormalizationTokenFilter extends AnalysisTokenFilterBase {
    type: 'german_normalization';
}
export interface AnalysisGermanStemTokenFilter extends AnalysisTokenFilterBase {
    type: 'german_stem';
}
export interface AnalysisGreekAnalyzer {
    type: 'greek';
    stopwords?: AnalysisStopWords;
    stopwords_path?: string;
}
export interface AnalysisHindiAnalyzer {
    type: 'hindi';
    stopwords?: AnalysisStopWords;
    stopwords_path?: string;
    stem_exclusion?: string[];
}
export interface AnalysisHindiNormalizationTokenFilter extends AnalysisTokenFilterBase {
    type: 'hindi_normalization';
}
export interface AnalysisHtmlStripCharFilter extends AnalysisCharFilterBase {
    type: 'html_strip';
    escaped_tags?: string[];
}
export interface AnalysisHungarianAnalyzer {
    type: 'hungarian';
    stopwords?: AnalysisStopWords;
    stopwords_path?: string;
    stem_exclusion?: string[];
}
export interface AnalysisHunspellTokenFilter extends AnalysisTokenFilterBase {
    type: 'hunspell';
    /** If `true`, duplicate tokens are removed from the filter’s output. Defaults to `true`. */
    dedup?: boolean;
    /** One or more `.dic` files (e.g, `en_US.dic`, my_custom.dic) to use for the Hunspell dictionary.
      * By default, the `hunspell` filter uses all `.dic` files in the `<$ES_PATH_CONF>/hunspell/<locale>` directory specified using the `lang`, `language`, or `locale` parameter. */
    dictionary?: string;
    /** Locale directory used to specify the `.aff` and `.dic` files for a Hunspell dictionary. */
    locale: string;
    /** Locale directory used to specify the `.aff` and `.dic` files for a Hunspell dictionary.
      * @alias locale */
    lang: string;
    /** Locale directory used to specify the `.aff` and `.dic` files for a Hunspell dictionary.
      * @alias locale */
    language: string;
    /** If `true`, only the longest stemmed version of each token is included in the output. If `false`, all stemmed versions of the token are included. Defaults to `false`. */
    longest_only?: boolean;
}
export interface AnalysisHyphenationDecompounderTokenFilter extends AnalysisCompoundWordTokenFilterBase {
    type: 'hyphenation_decompounder';
    /** Path to an Apache FOP (Formatting Objects Processor) XML hyphenation pattern file.
      * This path must be absolute or relative to the `config` location. Only FOP v1.2 compatible files are supported. */
    hyphenation_patterns_path: string;
    /** If `true`, do not match sub tokens in tokens that are in the word list. Defaults to `false`. */
    no_sub_matches?: boolean;
    /** If `true`, do not allow overlapping tokens. Defaults to `false`. */
    no_overlapping_matches?: boolean;
}
export interface AnalysisIcuAnalyzer {
    type: 'icu_analyzer';
    method: AnalysisIcuNormalizationType;
    mode: AnalysisIcuNormalizationMode;
}
export type AnalysisIcuCollationAlternate = 'shifted' | 'non-ignorable';
export type AnalysisIcuCollationCaseFirst = 'lower' | 'upper';
export type AnalysisIcuCollationDecomposition = 'no' | 'identical';
export type AnalysisIcuCollationStrength = 'primary' | 'secondary' | 'tertiary' | 'quaternary' | 'identical';
export interface AnalysisIcuCollationTokenFilter extends AnalysisTokenFilterBase {
    type: 'icu_collation';
    alternate?: AnalysisIcuCollationAlternate;
    caseFirst?: AnalysisIcuCollationCaseFirst;
    caseLevel?: boolean;
    country?: string;
    decomposition?: AnalysisIcuCollationDecomposition;
    hiraganaQuaternaryMode?: boolean;
    language?: string;
    numeric?: boolean;
    rules?: string;
    strength?: AnalysisIcuCollationStrength;
    variableTop?: string;
    variant?: string;
}
export interface AnalysisIcuFoldingTokenFilter extends AnalysisTokenFilterBase {
    type: 'icu_folding';
    unicode_set_filter: string;
}
export interface AnalysisIcuNormalizationCharFilter extends AnalysisCharFilterBase {
    type: 'icu_normalizer';
    mode?: AnalysisIcuNormalizationMode;
    name?: AnalysisIcuNormalizationType;
    unicode_set_filter?: string;
}
export type AnalysisIcuNormalizationMode = 'decompose' | 'compose';
export interface AnalysisIcuNormalizationTokenFilter extends AnalysisTokenFilterBase {
    type: 'icu_normalizer';
    name: AnalysisIcuNormalizationType;
}
export type AnalysisIcuNormalizationType = 'nfc' | 'nfkc' | 'nfkc_cf';
export interface AnalysisIcuTokenizer extends AnalysisTokenizerBase {
    type: 'icu_tokenizer';
    rule_files: string;
}
export type AnalysisIcuTransformDirection = 'forward' | 'reverse';
export interface AnalysisIcuTransformTokenFilter extends AnalysisTokenFilterBase {
    type: 'icu_transform';
    dir?: AnalysisIcuTransformDirection;
    id: string;
}
export interface AnalysisIndicNormalizationTokenFilter extends AnalysisTokenFilterBase {
    type: 'indic_normalization';
}
export interface AnalysisIndonesianAnalyzer {
    type: 'indonesian';
    stopwords?: AnalysisStopWords;
    stopwords_path?: string;
    stem_exclusion?: string[];
}
export interface AnalysisIrishAnalyzer {
    type: 'irish';
    stopwords?: AnalysisStopWords;
    stopwords_path?: string;
    stem_exclusion?: string[];
}
export interface AnalysisItalianAnalyzer {
    type: 'italian';
    stopwords?: AnalysisStopWords;
    stopwords_path?: string;
    stem_exclusion?: string[];
}
export interface AnalysisJaStopTokenFilter extends AnalysisTokenFilterBase {
    type: 'ja_stop';
    stopwords?: AnalysisStopWords;
}
export interface AnalysisKStemTokenFilter extends AnalysisTokenFilterBase {
    type: 'kstem';
}
export type AnalysisKeepTypesMode = 'include' | 'exclude';
export interface AnalysisKeepTypesTokenFilter extends AnalysisTokenFilterBase {
    type: 'keep_types';
    /** Indicates whether to keep or remove the specified token types. */
    mode?: AnalysisKeepTypesMode;
    /** List of token types to keep or remove. */
    types: string[];
}
export interface AnalysisKeepWordsTokenFilter extends AnalysisTokenFilterBase {
    type: 'keep';
    /** List of words to keep. Only tokens that match words in this list are included in the output.
      * Either this parameter or `keep_words_path` must be specified. */
    keep_words?: string[];
    /** If `true`, lowercase all keep words. Defaults to `false`. */
    keep_words_case?: boolean;
    /** Path to a file that contains a list of words to keep. Only tokens that match words in this list are included in the output.
      * This path must be absolute or relative to the `config` location, and the file must be UTF-8 encoded. Each word in the file must be separated by a line break.
      * Either this parameter or `keep_words` must be specified. */
    keep_words_path?: string;
}
export interface AnalysisKeywordAnalyzer {
    type: 'keyword';
    version?: VersionString;
}
export interface AnalysisKeywordMarkerTokenFilter extends AnalysisTokenFilterBase {
    type: 'keyword_marker';
    /** If `true`, matching for the `keywords` and `keywords_path` parameters ignores letter case. Defaults to `false`. */
    ignore_case?: boolean;
    /** Array of keywords. Tokens that match these keywords are not stemmed.
      * This parameter, `keywords_path`, or `keywords_pattern` must be specified. You cannot specify this parameter and `keywords_pattern`. */
    keywords?: string | string[];
    /** Path to a file that contains a list of keywords. Tokens that match these keywords are not stemmed.
      * This path must be absolute or relative to the `config` location, and the file must be UTF-8 encoded. Each word in the file must be separated by a line break.
      * This parameter, `keywords`, or `keywords_pattern` must be specified. You cannot specify this parameter and `keywords_pattern`. */
    keywords_path?: string;
    /** Java regular expression used to match tokens. Tokens that match this expression are marked as keywords and not stemmed.
      * This parameter, `keywords`, or `keywords_path` must be specified. You cannot specify this parameter and `keywords` or `keywords_pattern`. */
    keywords_pattern?: string;
}
export interface AnalysisKeywordRepeatTokenFilter extends AnalysisTokenFilterBase {
    type: 'keyword_repeat';
}
export interface AnalysisKeywordTokenizer extends AnalysisTokenizerBase {
    type: 'keyword';
    buffer_size?: integer;
}
export interface AnalysisKuromojiAnalyzer {
    type: 'kuromoji';
    mode: AnalysisKuromojiTokenizationMode;
    user_dictionary?: string;
}
export interface AnalysisKuromojiIterationMarkCharFilter extends AnalysisCharFilterBase {
    type: 'kuromoji_iteration_mark';
    normalize_kana: boolean;
    normalize_kanji: boolean;
}
export interface AnalysisKuromojiPartOfSpeechTokenFilter extends AnalysisTokenFilterBase {
    type: 'kuromoji_part_of_speech';
    stoptags: string[];
}
export interface AnalysisKuromojiReadingFormTokenFilter extends AnalysisTokenFilterBase {
    type: 'kuromoji_readingform';
    use_romaji: boolean;
}
export interface AnalysisKuromojiStemmerTokenFilter extends AnalysisTokenFilterBase {
    type: 'kuromoji_stemmer';
    minimum_length: integer;
}
export type AnalysisKuromojiTokenizationMode = 'normal' | 'search' | 'extended';
export interface AnalysisKuromojiTokenizer extends AnalysisTokenizerBase {
    type: 'kuromoji_tokenizer';
    discard_punctuation?: boolean;
    mode: AnalysisKuromojiTokenizationMode;
    nbest_cost?: integer;
    nbest_examples?: string;
    user_dictionary?: string;
    user_dictionary_rules?: string[];
    discard_compound_token?: boolean;
}
export interface AnalysisLatvianAnalyzer {
    type: 'latvian';
    stopwords?: AnalysisStopWords;
    stopwords_path?: string;
    stem_exclusion?: string[];
}
export interface AnalysisLengthTokenFilter extends AnalysisTokenFilterBase {
    type: 'length';
    /** Maximum character length of a token. Longer tokens are excluded from the output. Defaults to `Integer.MAX_VALUE`, which is `2^31-1` or `2147483647`. */
    max?: integer;
    /** Minimum character length of a token. Shorter tokens are excluded from the output. Defaults to `0`. */
    min?: integer;
}
export interface AnalysisLetterTokenizer extends AnalysisTokenizerBase {
    type: 'letter';
}
export interface AnalysisLimitTokenCountTokenFilter extends AnalysisTokenFilterBase {
    type: 'limit';
    /** If `true`, the limit filter exhausts the token stream, even if the `max_token_count` has already been reached. Defaults to `false`. */
    consume_all_tokens?: boolean;
    /** Maximum number of tokens to keep. Once this limit is reached, any remaining tokens are excluded from the output. Defaults to `1`. */
    max_token_count?: SpecUtilsStringified<integer>;
}
export interface AnalysisLithuanianAnalyzer {
    type: 'lithuanian';
    stopwords?: AnalysisStopWords;
    stopwords_path?: string;
    stem_exclusion?: string[];
}
export interface AnalysisLowercaseNormalizer {
    type: 'lowercase';
}
export interface AnalysisLowercaseTokenFilter extends AnalysisTokenFilterBase {
    type: 'lowercase';
    /** Language-specific lowercase token filter to use. */
    language?: AnalysisLowercaseTokenFilterLanguages;
}
export type AnalysisLowercaseTokenFilterLanguages = 'greek' | 'irish' | 'turkish';
export interface AnalysisLowercaseTokenizer extends AnalysisTokenizerBase {
    type: 'lowercase';
}
export interface AnalysisMappingCharFilter extends AnalysisCharFilterBase {
    type: 'mapping';
    mappings?: string[];
    mappings_path?: string;
}
export interface AnalysisMinHashTokenFilter extends AnalysisTokenFilterBase {
    type: 'min_hash';
    /** Number of buckets to which hashes are assigned. Defaults to `512`. */
    bucket_count?: integer;
    /** Number of ways to hash each token in the stream. Defaults to `1`. */
    hash_count?: integer;
    /** Number of hashes to keep from each bucket. Defaults to `1`.
      * Hashes are retained by ascending size, starting with the bucket’s smallest hash first. */
    hash_set_size?: integer;
    /** If `true`, the filter fills empty buckets with the value of the first non-empty bucket to its circular right if the `hash_set_size` is `1`. If the `bucket_count` argument is greater than 1, this parameter defaults to `true`. Otherwise, this parameter defaults to `false`. */
    with_rotation?: boolean;
}
export interface AnalysisMultiplexerTokenFilter extends AnalysisTokenFilterBase {
    type: 'multiplexer';
    /** A list of token filters to apply to incoming tokens. */
    filters: string[];
    /** If `true` (the default) then emit the original token in addition to the filtered tokens. */
    preserve_original?: SpecUtilsStringified<boolean>;
}
export interface AnalysisNGramTokenFilter extends AnalysisTokenFilterBase {
    type: 'ngram';
    /** Maximum length of characters in a gram. Defaults to `2`. */
    max_gram?: integer;
    /** Minimum length of characters in a gram. Defaults to `1`. */
    min_gram?: integer;
    /** Emits original token when set to `true`. Defaults to `false`. */
    preserve_original?: SpecUtilsStringified<boolean>;
}
export interface AnalysisNGramTokenizer extends AnalysisTokenizerBase {
    type: 'ngram';
    custom_token_chars?: string;
    max_gram?: integer;
    min_gram?: integer;
    token_chars?: AnalysisTokenChar[];
}
export interface AnalysisNoriAnalyzer {
    type: 'nori';
    version?: VersionString;
    decompound_mode?: AnalysisNoriDecompoundMode;
    stoptags?: string[];
    user_dictionary?: string;
}
export type AnalysisNoriDecompoundMode = 'discard' | 'none' | 'mixed';
export interface AnalysisNoriPartOfSpeechTokenFilter extends AnalysisTokenFilterBase {
    type: 'nori_part_of_speech';
    /** An array of part-of-speech tags that should be removed. */
    stoptags?: string[];
}
export interface AnalysisNoriTokenizer extends AnalysisTokenizerBase {
    type: 'nori_tokenizer';
    decompound_mode?: AnalysisNoriDecompoundMode;
    discard_punctuation?: boolean;
    user_dictionary?: string;
    user_dictionary_rules?: string[];
}
export type AnalysisNormalizer = AnalysisLowercaseNormalizer | AnalysisCustomNormalizer;
export interface AnalysisNorwegianAnalyzer {
    type: 'norwegian';
    stopwords?: AnalysisStopWords;
    stopwords_path?: string;
    stem_exclusion?: string[];
}
export interface AnalysisPathHierarchyTokenizer extends AnalysisTokenizerBase {
    type: 'path_hierarchy';
    buffer_size?: SpecUtilsStringified<integer>;
    delimiter?: string;
    replacement?: string;
    reverse?: SpecUtilsStringified<boolean>;
    skip?: SpecUtilsStringified<integer>;
}
export interface AnalysisPatternAnalyzer {
    type: 'pattern';
    version?: VersionString;
    /** Java regular expression flags. Flags should be pipe-separated, eg "CASE_INSENSITIVE|COMMENTS". */
    flags?: string;
    /** Should terms be lowercased or not.
      * Defaults to `true`. */
    lowercase?: boolean;
    /** A Java regular expression.
      * Defaults to `\W+`. */
    pattern?: string;
    /** A pre-defined stop words list like `_english_` or an array containing a list of stop words.
      * Defaults to `_none_`. */
    stopwords?: AnalysisStopWords;
    /** The path to a file containing stop words. */
    stopwords_path?: string;
}
export interface AnalysisPatternCaptureTokenFilter extends AnalysisTokenFilterBase {
    type: 'pattern_capture';
    /** A list of regular expressions to match. */
    patterns: string[];
    /** If set to `true` (the default) it will emit the original token. */
    preserve_original?: SpecUtilsStringified<boolean>;
}
export interface AnalysisPatternReplaceCharFilter extends AnalysisCharFilterBase {
    type: 'pattern_replace';
    flags?: string;
    pattern: string;
    replacement?: string;
}
export interface AnalysisPatternReplaceTokenFilter extends AnalysisTokenFilterBase {
    type: 'pattern_replace';
    /** If `true`, all substrings matching the pattern parameter’s regular expression are replaced. If `false`, the filter replaces only the first matching substring in each token. Defaults to `true`. */
    all?: boolean;
    flags?: string;
    /** Regular expression, written in Java’s regular expression syntax. The filter replaces token substrings matching this pattern with the substring in the `replacement` parameter. */
    pattern: string;
    /** Replacement substring. Defaults to an empty substring (`""`). */
    replacement?: string;
}
export interface AnalysisPatternTokenizer extends AnalysisTokenizerBase {
    type: 'pattern';
    flags?: string;
    group?: integer;
    pattern?: string;
}
export interface AnalysisPersianAnalyzer {
    type: 'persian';
    stopwords?: AnalysisStopWords;
    stopwords_path?: string;
}
export interface AnalysisPersianNormalizationTokenFilter extends AnalysisTokenFilterBase {
    type: 'persian_normalization';
}
export interface AnalysisPersianStemTokenFilter extends AnalysisTokenFilterBase {
    type: 'persian_stem';
}
export type AnalysisPhoneticEncoder = 'metaphone' | 'double_metaphone' | 'soundex' | 'refined_soundex' | 'caverphone1' | 'caverphone2' | 'cologne' | 'nysiis' | 'koelnerphonetik' | 'haasephonetik' | 'beider_morse' | 'daitch_mokotoff';
export type AnalysisPhoneticLanguage = 'any' | 'common' | 'cyrillic' | 'english' | 'french' | 'german' | 'hebrew' | 'hungarian' | 'polish' | 'romanian' | 'russian' | 'spanish';
export type AnalysisPhoneticNameType = 'generic' | 'ashkenazi' | 'sephardic';
export type AnalysisPhoneticRuleType = 'approx' | 'exact';
export interface AnalysisPhoneticTokenFilter extends AnalysisTokenFilterBase {
    type: 'phonetic';
    encoder: AnalysisPhoneticEncoder;
    languageset?: AnalysisPhoneticLanguage | AnalysisPhoneticLanguage[];
    max_code_len?: integer;
    name_type?: AnalysisPhoneticNameType;
    replace?: boolean;
    rule_type?: AnalysisPhoneticRuleType;
}
export interface AnalysisPorterStemTokenFilter extends AnalysisTokenFilterBase {
    type: 'porter_stem';
}
export interface AnalysisPortugueseAnalyzer {
    type: 'portuguese';
    stopwords?: AnalysisStopWords;
    stopwords_path?: string;
    stem_exclusion?: string[];
}
export interface AnalysisPredicateTokenFilter extends AnalysisTokenFilterBase {
    type: 'predicate_token_filter';
    /** Script containing a condition used to filter incoming tokens. Only tokens that match this script are included in the output. */
    script: Script | ScriptSource;
}
export interface AnalysisRemoveDuplicatesTokenFilter extends AnalysisTokenFilterBase {
    type: 'remove_duplicates';
}
export interface AnalysisReverseTokenFilter extends AnalysisTokenFilterBase {
    type: 'reverse';
}
export interface AnalysisRomanianAnalyzer {
    type: 'romanian';
    stopwords?: AnalysisStopWords;
    stopwords_path?: string;
    stem_exclusion?: string[];
}
export interface AnalysisRussianAnalyzer {
    type: 'russian';
    stopwords?: AnalysisStopWords;
    stopwords_path?: string;
    stem_exclusion?: string[];
}
export interface AnalysisRussianStemTokenFilter extends AnalysisTokenFilterBase {
    type: 'russian_stem';
}
export interface AnalysisScandinavianFoldingTokenFilter extends AnalysisTokenFilterBase {
    type: 'scandinavian_folding';
}
export interface AnalysisScandinavianNormalizationTokenFilter extends AnalysisTokenFilterBase {
    type: 'scandinavian_normalization';
}
export interface AnalysisSerbianAnalyzer {
    type: 'serbian';
    stopwords?: AnalysisStopWords;
    stopwords_path?: string;
    stem_exclusion?: string[];
}
export interface AnalysisSerbianNormalizationTokenFilter extends AnalysisTokenFilterBase {
    type: 'serbian_normalization';
}
export interface AnalysisShingleTokenFilter extends AnalysisTokenFilterBase {
    type: 'shingle';
    /** String used in shingles as a replacement for empty positions that do not contain a token. This filler token is only used in shingles, not original unigrams. Defaults to an underscore (`_`). */
    filler_token?: string;
    /** Maximum number of tokens to concatenate when creating shingles. Defaults to `2`. */
    max_shingle_size?: SpecUtilsStringified<integer>;
    /** Minimum number of tokens to concatenate when creating shingles. Defaults to `2`. */
    min_shingle_size?: SpecUtilsStringified<integer>;
    /** If `true`, the output includes the original input tokens. If `false`, the output only includes shingles; the original input tokens are removed. Defaults to `true`. */
    output_unigrams?: boolean;
    /** If `true`, the output includes the original input tokens only if no shingles are produced; if shingles are produced, the output only includes shingles. Defaults to `false`. */
    output_unigrams_if_no_shingles?: boolean;
    /** Separator used to concatenate adjacent tokens to form a shingle. Defaults to a space (`" "`). */
    token_separator?: string;
}
export interface AnalysisSimpleAnalyzer {
    type: 'simple';
    version?: VersionString;
}
export interface AnalysisSimplePatternSplitTokenizer extends AnalysisTokenizerBase {
    type: 'simple_pattern_split';
    pattern?: string;
}
export interface AnalysisSimplePatternTokenizer extends AnalysisTokenizerBase {
    type: 'simple_pattern';
    pattern?: string;
}
export interface AnalysisSnowballAnalyzer {
    type: 'snowball';
    version?: VersionString;
    language: AnalysisSnowballLanguage;
    stopwords?: AnalysisStopWords;
}
export type AnalysisSnowballLanguage = 'Arabic' | 'Armenian' | 'Basque' | 'Catalan' | 'Danish' | 'Dutch' | 'English' | 'Estonian' | 'Finnish' | 'French' | 'German' | 'German2' | 'Hungarian' | 'Italian' | 'Irish' | 'Kp' | 'Lithuanian' | 'Lovins' | 'Norwegian' | 'Porter' | 'Portuguese' | 'Romanian' | 'Russian' | 'Serbian' | 'Spanish' | 'Swedish' | 'Turkish';
export interface AnalysisSnowballTokenFilter extends AnalysisTokenFilterBase {
    type: 'snowball';
    /** Controls the language used by the stemmer. */
    language?: AnalysisSnowballLanguage;
}
export interface AnalysisSoraniAnalyzer {
    type: 'sorani';
    stopwords?: AnalysisStopWords;
    stopwords_path?: string;
    stem_exclusion?: string[];
}
export interface AnalysisSoraniNormalizationTokenFilter extends AnalysisTokenFilterBase {
    type: 'sorani_normalization';
}
export interface AnalysisSpanishAnalyzer {
    type: 'spanish';
    stopwords?: AnalysisStopWords;
    stopwords_path?: string;
    stem_exclusion?: string[];
}
export interface AnalysisStandardAnalyzer {
    type: 'standard';
    /** The maximum token length. If a token is seen that exceeds this length then it is split at `max_token_length` intervals.
      * Defaults to `255`. */
    max_token_length?: integer;
    /** A pre-defined stop words list like `_english_` or an array containing a list of stop words.
      * Defaults to `_none_`. */
    stopwords?: AnalysisStopWords;
    /** The path to a file containing stop words. */
    stopwords_path?: string;
}
export interface AnalysisStandardTokenizer extends AnalysisTokenizerBase {
    type: 'standard';
    max_token_length?: integer;
}
export interface AnalysisStemmerOverrideTokenFilter extends AnalysisTokenFilterBase {
    type: 'stemmer_override';
    /** A list of mapping rules to use. */
    rules?: string[];
    /** A path (either relative to `config` location, or absolute) to a list of mappings. */
    rules_path?: string;
}
export interface AnalysisStemmerTokenFilter extends AnalysisTokenFilterBase {
    type: 'stemmer';
    language?: string;
    /** @alias language */
    name?: string;
}
export interface AnalysisStopAnalyzer {
    type: 'stop';
    version?: VersionString;
    /** A pre-defined stop words list like `_english_` or an array containing a list of stop words.
      * Defaults to `_none_`. */
    stopwords?: AnalysisStopWords;
    /** The path to a file containing stop words. */
    stopwords_path?: string;
}
export interface AnalysisStopTokenFilter extends AnalysisTokenFilterBase {
    type: 'stop';
    /** If `true`, stop word matching is case insensitive. For example, if `true`, a stop word of the matches and removes `The`, `THE`, or `the`. Defaults to `false`. */
    ignore_case?: boolean;
    /** If `true`, the last token of a stream is removed if it’s a stop word. Defaults to `true`. */
    remove_trailing?: boolean;
    /** Language value, such as `_arabic_` or `_thai_`. Defaults to `_english_`. */
    stopwords?: AnalysisStopWords;
    /** Path to a file that contains a list of stop words to remove.
      * This path must be absolute or relative to the `config` location, and the file must be UTF-8 encoded. Each stop word in the file must be separated by a line break. */
    stopwords_path?: string;
}
export type AnalysisStopWordLanguage = '_arabic_' | '_armenian_' | '_basque_' | '_bengali_' | '_brazilian_' | '_bulgarian_' | '_catalan_' | '_cjk_' | '_czech_' | '_danish_' | '_dutch_' | '_english_' | '_estonian_' | '_finnish_' | '_french_' | '_galician_' | '_german_' | '_greek_' | '_hindi_' | '_hungarian_' | '_indonesian_' | '_irish_' | '_italian_' | '_latvian_' | '_lithuanian_' | '_norwegian_' | '_persian_' | '_portuguese_' | '_romanian_' | '_russian_' | '_serbian_' | '_sorani_' | '_spanish_' | '_swedish_' | '_thai_' | '_turkish_' | '_none_';
export type AnalysisStopWords = AnalysisStopWordLanguage | string[];
export interface AnalysisSwedishAnalyzer {
    type: 'swedish';
    stopwords?: AnalysisStopWords;
    stopwords_path?: string;
    stem_exclusion?: string[];
}
export type AnalysisSynonymFormat = 'solr' | 'wordnet';
export interface AnalysisSynonymGraphTokenFilter extends AnalysisSynonymTokenFilterBase {
    type: 'synonym_graph';
}
export interface AnalysisSynonymTokenFilter extends AnalysisSynonymTokenFilterBase {
    type: 'synonym';
}
export interface AnalysisSynonymTokenFilterBase extends AnalysisTokenFilterBase {
    /** Expands definitions for equivalent synonym rules. Defaults to `true`. */
    expand?: boolean;
    /** Sets the synonym rules format. */
    format?: AnalysisSynonymFormat;
    /** If `true` ignores errors while parsing the synonym rules. It is important to note that only those synonym rules which cannot get parsed are ignored. Defaults to the value of the `updateable` setting. */
    lenient?: boolean;
    /** Used to define inline synonyms. */
    synonyms?: string[];
    /** Used to provide a synonym file. This path must be absolute or relative to the `config` location. */
    synonyms_path?: string;
    /** Provide a synonym set created via Synonyms Management APIs. */
    synonyms_set?: string;
    /** Controls the tokenizers that will be used to tokenize the synonym, this parameter is for backwards compatibility for indices that created before 6.0. */
    tokenizer?: string;
    /** If `true` allows reloading search analyzers to pick up changes to synonym files. Only to be used for search analyzers. Defaults to `false`. */
    updateable?: boolean;
}
export interface AnalysisThaiAnalyzer {
    type: 'thai';
    stopwords?: AnalysisStopWords;
    stopwords_path?: string;
}
export interface AnalysisThaiTokenizer extends AnalysisTokenizerBase {
    type: 'thai';
}
export type AnalysisTokenChar = 'letter' | 'digit' | 'whitespace' | 'punctuation' | 'symbol' | 'custom';
export type AnalysisTokenFilter = string | AnalysisTokenFilterDefinition;
export interface AnalysisTokenFilterBase {
    version?: VersionString;
}
export type AnalysisTokenFilterDefinition = AnalysisApostropheTokenFilter | AnalysisArabicStemTokenFilter | AnalysisArabicNormalizationTokenFilter | AnalysisAsciiFoldingTokenFilter | AnalysisBengaliNormalizationTokenFilter | AnalysisBrazilianStemTokenFilter | AnalysisCjkBigramTokenFilter | AnalysisCjkWidthTokenFilter | AnalysisClassicTokenFilter | AnalysisCommonGramsTokenFilter | AnalysisConditionTokenFilter | AnalysisCzechStemTokenFilter | AnalysisDecimalDigitTokenFilter | AnalysisDelimitedPayloadTokenFilter | AnalysisDutchStemTokenFilter | AnalysisEdgeNGramTokenFilter | AnalysisElisionTokenFilter | AnalysisFingerprintTokenFilter | AnalysisFlattenGraphTokenFilter | AnalysisFrenchStemTokenFilter | AnalysisGermanNormalizationTokenFilter | AnalysisGermanStemTokenFilter | AnalysisHindiNormalizationTokenFilter | AnalysisHunspellTokenFilter | AnalysisHyphenationDecompounderTokenFilter | AnalysisIndicNormalizationTokenFilter | AnalysisKeepTypesTokenFilter | AnalysisKeepWordsTokenFilter | AnalysisKeywordMarkerTokenFilter | AnalysisKeywordRepeatTokenFilter | AnalysisKStemTokenFilter | AnalysisLengthTokenFilter | AnalysisLimitTokenCountTokenFilter | AnalysisLowercaseTokenFilter | AnalysisMinHashTokenFilter | AnalysisMultiplexerTokenFilter | AnalysisNGramTokenFilter | AnalysisNoriPartOfSpeechTokenFilter | AnalysisPatternCaptureTokenFilter | AnalysisPatternReplaceTokenFilter | AnalysisPersianNormalizationTokenFilter | AnalysisPersianStemTokenFilter | AnalysisPorterStemTokenFilter | AnalysisPredicateTokenFilter | AnalysisRemoveDuplicatesTokenFilter | AnalysisReverseTokenFilter | AnalysisRussianStemTokenFilter | AnalysisScandinavianFoldingTokenFilter | AnalysisScandinavianNormalizationTokenFilter | AnalysisSerbianNormalizationTokenFilter | AnalysisShingleTokenFilter | AnalysisSnowballTokenFilter | AnalysisSoraniNormalizationTokenFilter | AnalysisStemmerOverrideTokenFilter | AnalysisStemmerTokenFilter | AnalysisStopTokenFilter | AnalysisSynonymGraphTokenFilter | AnalysisSynonymTokenFilter | AnalysisTrimTokenFilter | AnalysisTruncateTokenFilter | AnalysisUniqueTokenFilter | AnalysisUppercaseTokenFilter | AnalysisWordDelimiterGraphTokenFilter | AnalysisWordDelimiterTokenFilter | AnalysisJaStopTokenFilter | AnalysisKuromojiStemmerTokenFilter | AnalysisKuromojiReadingFormTokenFilter | AnalysisKuromojiPartOfSpeechTokenFilter | AnalysisIcuCollationTokenFilter | AnalysisIcuFoldingTokenFilter | AnalysisIcuNormalizationTokenFilter | AnalysisIcuTransformTokenFilter | AnalysisPhoneticTokenFilter | AnalysisDictionaryDecompounderTokenFilter;
export type AnalysisTokenizer = string | AnalysisTokenizerDefinition;
export interface AnalysisTokenizerBase {
    version?: VersionString;
}
export type AnalysisTokenizerDefinition = AnalysisCharGroupTokenizer | AnalysisClassicTokenizer | AnalysisEdgeNGramTokenizer | AnalysisKeywordTokenizer | AnalysisLetterTokenizer | AnalysisLowercaseTokenizer | AnalysisNGramTokenizer | AnalysisPathHierarchyTokenizer | AnalysisPatternTokenizer | AnalysisSimplePatternTokenizer | AnalysisSimplePatternSplitTokenizer | AnalysisStandardTokenizer | AnalysisThaiTokenizer | AnalysisUaxEmailUrlTokenizer | AnalysisWhitespaceTokenizer | AnalysisIcuTokenizer | AnalysisKuromojiTokenizer | AnalysisNoriTokenizer;
export interface AnalysisTrimTokenFilter extends AnalysisTokenFilterBase {
    type: 'trim';
}
export interface AnalysisTruncateTokenFilter extends AnalysisTokenFilterBase {
    type: 'truncate';
    /** Character limit for each token. Tokens exceeding this limit are truncated. Defaults to `10`. */
    length?: integer;
}
export interface AnalysisTurkishAnalyzer {
    type: 'turkish';
    stopwords?: AnalysisStopWords;
    stopwords_path?: string;
    stem_exclusion?: string[];
}
export interface AnalysisUaxEmailUrlTokenizer extends AnalysisTokenizerBase {
    type: 'uax_url_email';
    max_token_length?: integer;
}
export interface AnalysisUniqueTokenFilter extends AnalysisTokenFilterBase {
    type: 'unique';
    /** If `true`, only remove duplicate tokens in the same position. Defaults to `false`. */
    only_on_same_position?: boolean;
}
export interface AnalysisUppercaseTokenFilter extends AnalysisTokenFilterBase {
    type: 'uppercase';
}
export interface AnalysisWhitespaceAnalyzer {
    type: 'whitespace';
    version?: VersionString;
}
export interface AnalysisWhitespaceTokenizer extends AnalysisTokenizerBase {
    type: 'whitespace';
    max_token_length?: integer;
}
export interface AnalysisWordDelimiterGraphTokenFilter extends AnalysisWordDelimiterTokenFilterBase {
    type: 'word_delimiter_graph';
    /** If `true`, the filter adjusts the offsets of split or catenated tokens to better reflect their actual position in the token stream. Defaults to `true`. */
    adjust_offsets?: boolean;
    /** If `true`, the filter skips tokens with a keyword attribute of true. Defaults to `false`. */
    ignore_keywords?: boolean;
}
export interface AnalysisWordDelimiterTokenFilter extends AnalysisWordDelimiterTokenFilterBase {
    type: 'word_delimiter';
}
export interface AnalysisWordDelimiterTokenFilterBase extends AnalysisTokenFilterBase {
    /** If `true`, the filter produces catenated tokens for chains of alphanumeric characters separated by non-alphabetic delimiters. Defaults to `false`. */
    catenate_all?: boolean;
    /** If `true`, the filter produces catenated tokens for chains of numeric characters separated by non-alphabetic delimiters. Defaults to `false`. */
    catenate_numbers?: boolean;
    /** If `true`, the filter produces catenated tokens for chains of alphabetical characters separated by non-alphabetic delimiters. Defaults to `false`. */
    catenate_words?: boolean;
    /** If `true`, the filter includes tokens consisting of only numeric characters in the output. If `false`, the filter excludes these tokens from the output. Defaults to `true`. */
    generate_number_parts?: boolean;
    /** If `true`, the filter includes tokens consisting of only alphabetical characters in the output. If `false`, the filter excludes these tokens from the output. Defaults to `true`. */
    generate_word_parts?: boolean;
    /** If `true`, the filter includes the original version of any split tokens in the output. This original version includes non-alphanumeric delimiters. Defaults to `false`. */
    preserve_original?: SpecUtilsStringified<boolean>;
    /** Array of tokens the filter won’t split. */
    protected_words?: string[];
    /** Path to a file that contains a list of tokens the filter won’t split.
      * This path must be absolute or relative to the `config` location, and the file must be UTF-8 encoded. Each token in the file must be separated by a line break. */
    protected_words_path?: string;
    /** If `true`, the filter splits tokens at letter case transitions. For example: camelCase -> [ camel, Case ]. Defaults to `true`. */
    split_on_case_change?: boolean;
    /** If `true`, the filter splits tokens at letter-number transitions. For example: j2se -> [ j, 2, se ]. Defaults to `true`. */
    split_on_numerics?: boolean;
    /** If `true`, the filter removes the English possessive (`'s`) from the end of each token. For example: O'Neil's -> [ O, Neil ]. Defaults to `true`. */
    stem_english_possessive?: boolean;
    /** Array of custom type mappings for characters. This allows you to map non-alphanumeric characters as numeric or alphanumeric to avoid splitting on those characters. */
    type_table?: string[];
    /** Path to a file that contains custom type mappings for characters. This allows you to map non-alphanumeric characters as numeric or alphanumeric to avoid splitting on those characters. */
    type_table_path?: string;
}
export interface MappingAggregateMetricDoubleProperty extends MappingPropertyBase {
    type: 'aggregate_metric_double';
    default_metric: string;
    ignore_malformed?: boolean;
    metrics: string[];
    time_series_metric?: MappingTimeSeriesMetricType;
}
export interface MappingAllField {
    analyzer: string;
    enabled: boolean;
    omit_norms: boolean;
    search_analyzer: string;
    similarity: string;
    store: boolean;
    store_term_vector_offsets: boolean;
    store_term_vector_payloads: boolean;
    store_term_vector_positions: boolean;
    store_term_vectors: boolean;
}
export interface MappingBinaryProperty extends MappingDocValuesPropertyBase {
    type: 'binary';
}
export interface MappingBooleanProperty extends MappingDocValuesPropertyBase {
    boost?: double;
    fielddata?: IndicesNumericFielddata;
    index?: boolean;
    null_value?: boolean;
    ignore_malformed?: boolean;
    script?: Script | ScriptSource;
    on_script_error?: MappingOnScriptError;
    /** For internal use by Elastic only. Marks the field as a time series dimension. Defaults to false.
      * @experimental */
    time_series_dimension?: boolean;
    type: 'boolean';
}
export interface MappingByteNumberProperty extends MappingNumberPropertyBase {
    type: 'byte';
    null_value?: byte;
}
export interface MappingChunkingSettings {
    /** The chunking strategy: `sentence` or `word`. */
    strategy: string;
    /** The maximum size of a chunk in words.
      * This value cannot be higher than `300` or lower than `20` (for `sentence` strategy) or `10` (for `word` strategy). */
    max_chunk_size: integer;
    /** The number of overlapping words for chunks.
      * It is applicable only to a `word` chunking strategy.
      * This value cannot be higher than half the `max_chunk_size` value. */
    overlap?: integer;
    /** The number of overlapping sentences for chunks.
      * It is applicable only for a `sentence` chunking strategy.
      * It can be either `1` or `0`. */
    sentence_overlap?: integer;
}
export interface MappingCompletionProperty extends MappingDocValuesPropertyBase {
    analyzer?: string;
    contexts?: MappingSuggestContext[];
    max_input_length?: integer;
    preserve_position_increments?: boolean;
    preserve_separators?: boolean;
    search_analyzer?: string;
    type: 'completion';
}
export interface MappingCompositeSubField {
    type: MappingRuntimeFieldType;
}
export interface MappingConstantKeywordProperty extends MappingPropertyBase {
    value?: any;
    type: 'constant_keyword';
}
export interface MappingCorePropertyBase extends MappingPropertyBase {
    copy_to?: Fields;
    store?: boolean;
}
export interface MappingCountedKeywordProperty extends MappingPropertyBase {
    type: 'counted_keyword';
    index?: boolean;
}
export interface MappingDataStreamTimestamp {
    enabled: boolean;
}
export interface MappingDateNanosProperty extends MappingDocValuesPropertyBase {
    boost?: double;
    format?: string;
    ignore_malformed?: boolean;
    index?: boolean;
    script?: Script | ScriptSource;
    on_script_error?: MappingOnScriptError;
    null_value?: DateTime;
    precision_step?: integer;
    type: 'date_nanos';
}
export interface MappingDateProperty extends MappingDocValuesPropertyBase {
    boost?: double;
    fielddata?: IndicesNumericFielddata;
    format?: string;
    ignore_malformed?: boolean;
    index?: boolean;
    script?: Script | ScriptSource;
    on_script_error?: MappingOnScriptError;
    null_value?: DateTime;
    precision_step?: integer;
    locale?: string;
    type: 'date';
}
export interface MappingDateRangeProperty extends MappingRangePropertyBase {
    format?: string;
    type: 'date_range';
}
export type MappingDenseVectorElementType = 'bit' | 'byte' | 'float';
export interface MappingDenseVectorIndexOptions {
    /** The confidence interval to use when quantizing the vectors. Can be any value between and including `0.90` and
      * `1.0` or exactly `0`. When the value is `0`, this indicates that dynamic quantiles should be calculated for
      * optimized quantization. When between `0.90` and `1.0`, this value restricts the values used when calculating
      * the quantization thresholds.
      *
      * For example, a value of `0.95` will only use the middle `95%` of the values when calculating the quantization
      * thresholds (e.g. the highest and lowest `2.5%` of values will be ignored).
      *
      * Defaults to `1/(dims + 1)` for `int8` quantized vectors and `0` for `int4` for dynamic quantile calculation.
      *
      * Only applicable to `int8_hnsw`, `int4_hnsw`, `int8_flat`, and `int4_flat` index types. */
    confidence_interval?: float;
    /** The number of candidates to track while assembling the list of nearest neighbors for each new node.
      *
      * Only applicable to `hnsw`, `int8_hnsw`, `bbq_hnsw`, and `int4_hnsw` index types. */
    ef_construction?: integer;
    /** The number of neighbors each node will be connected to in the HNSW graph.
      *
      * Only applicable to `hnsw`, `int8_hnsw`, `bbq_hnsw`, and `int4_hnsw` index types. */
    m?: integer;
    /** The type of kNN algorithm to use. */
    type: MappingDenseVectorIndexOptionsType;
    /** The rescore vector options. This is only applicable to `bbq_hnsw`, `int4_hnsw`, `int8_hnsw`, `bbq_flat`, `int4_flat`, and `int8_flat` index types. */
    rescore_vector?: MappingDenseVectorIndexOptionsRescoreVector;
}
export interface MappingDenseVectorIndexOptionsRescoreVector {
    /** The oversampling factor to use when searching for the nearest neighbor. This is only applicable to the quantized formats: `bbq_*`, `int4_*`, and `int8_*`.
      * When provided, `oversample * k` vectors will be gathered and then their scores will be re-computed with the original vectors.
      *
      * valid values are between `1.0` and `10.0` (inclusive), or `0` exactly to disable oversampling. */
    oversample: float;
}
export type MappingDenseVectorIndexOptionsType = 'bbq_flat' | 'bbq_hnsw' | 'flat' | 'hnsw' | 'int4_flat' | 'int4_hnsw' | 'int8_flat' | 'int8_hnsw';
export interface MappingDenseVectorProperty extends MappingPropertyBase {
    type: 'dense_vector';
    /** Number of vector dimensions. Can't exceed `4096`. If `dims` is not specified, it will be set to the length of
      * the first vector added to the field. */
    dims?: integer;
    /** The data type used to encode vectors. The supported data types are `float` (default), `byte`, and `bit`. */
    element_type?: MappingDenseVectorElementType;
    /** If `true`, you can search this field using the kNN search API. */
    index?: boolean;
    /** An optional section that configures the kNN indexing algorithm. The HNSW algorithm has two internal parameters
      * that influence how the data structure is built. These can be adjusted to improve the accuracy of results, at the
      * expense of slower indexing speed.
      *
      * This parameter can only be specified when `index` is `true`. */
    index_options?: MappingDenseVectorIndexOptions;
    /** The vector similarity metric to use in kNN search.
      *
      * Documents are ranked by their vector field's similarity to the query vector. The `_score` of each document will
      * be derived from the similarity, in a way that ensures scores are positive and that a larger score corresponds
      * to a higher ranking.
      *
      * Defaults to `l2_norm` when `element_type` is `bit` otherwise defaults to `cosine`.
      *
      * `bit` vectors only support `l2_norm` as their similarity metric.
      *
      * This parameter can only be specified when `index` is `true`. */
    similarity?: MappingDenseVectorSimilarity;
}
export type MappingDenseVectorSimilarity = 'cosine' | 'dot_product' | 'l2_norm' | 'max_inner_product';
export interface MappingDocValuesPropertyBase extends MappingCorePropertyBase {
    doc_values?: boolean;
}
export interface MappingDoubleNumberProperty extends MappingNumberPropertyBase {
    type: 'double';
    null_value?: double;
}
export interface MappingDoubleRangeProperty extends MappingRangePropertyBase {
    type: 'double_range';
}
export type MappingDynamicMapping = boolean | 'strict' | 'runtime' | 'true' | 'false';
export interface MappingDynamicProperty extends MappingDocValuesPropertyBase {
    type: '{dynamic_type}';
    enabled?: boolean;
    null_value?: FieldValue;
    boost?: double;
    coerce?: boolean;
    script?: Script | ScriptSource;
    on_script_error?: MappingOnScriptError;
    ignore_malformed?: boolean;
    time_series_metric?: MappingTimeSeriesMetricType;
    analyzer?: string;
    eager_global_ordinals?: boolean;
    index?: boolean;
    index_options?: MappingIndexOptions;
    index_phrases?: boolean;
    index_prefixes?: MappingTextIndexPrefixes | null;
    norms?: boolean;
    position_increment_gap?: integer;
    search_analyzer?: string;
    search_quote_analyzer?: string;
    term_vector?: MappingTermVectorOption;
    format?: string;
    precision_step?: integer;
    locale?: string;
}
export interface MappingDynamicTemplate {
    mapping?: MappingProperty;
    runtime?: MappingRuntimeField;
    match?: string | string[];
    path_match?: string | string[];
    unmatch?: string | string[];
    path_unmatch?: string | string[];
    match_mapping_type?: string | string[];
    unmatch_mapping_type?: string | string[];
    match_pattern?: MappingMatchType;
}
export interface MappingFieldAliasProperty extends MappingPropertyBase {
    path?: Field;
    type: 'alias';
}
export interface MappingFieldMapping {
    full_name: string;
    mapping: Partial<Record<Field, MappingProperty>>;
}
export interface MappingFieldNamesField {
    enabled: boolean;
}
export type MappingFieldType = 'none' | 'geo_point' | 'geo_shape' | 'ip' | 'binary' | 'keyword' | 'text' | 'search_as_you_type' | 'date' | 'date_nanos' | 'boolean' | 'completion' | 'nested' | 'object' | 'passthrough' | 'version' | 'murmur3' | 'token_count' | 'percolator' | 'integer' | 'long' | 'short' | 'byte' | 'float' | 'half_float' | 'scaled_float' | 'double' | 'integer_range' | 'float_range' | 'long_range' | 'double_range' | 'date_range' | 'ip_range' | 'alias' | 'join' | 'rank_feature' | 'rank_features' | 'flattened' | 'shape' | 'histogram' | 'constant_keyword' | 'counted_keyword' | 'aggregate_metric_double' | 'dense_vector' | 'semantic_text' | 'sparse_vector' | 'match_only_text' | 'icu_collation_keyword';
export interface MappingFlattenedProperty extends MappingPropertyBase {
    boost?: double;
    depth_limit?: integer;
    doc_values?: boolean;
    eager_global_ordinals?: boolean;
    index?: boolean;
    index_options?: MappingIndexOptions;
    null_value?: string;
    similarity?: string;
    split_queries_on_whitespace?: boolean;
    time_series_dimensions?: string[];
    type: 'flattened';
}
export interface MappingFloatNumberProperty extends MappingNumberPropertyBase {
    type: 'float';
    null_value?: float;
}
export interface MappingFloatRangeProperty extends MappingRangePropertyBase {
    type: 'float_range';
}
export type MappingGeoOrientation = 'right' | 'RIGHT' | 'counterclockwise' | 'ccw' | 'left' | 'LEFT' | 'clockwise' | 'cw';
export type MappingGeoPointMetricType = 'gauge' | 'counter' | 'position';
export interface MappingGeoPointProperty extends MappingDocValuesPropertyBase {
    ignore_malformed?: boolean;
    ignore_z_value?: boolean;
    null_value?: GeoLocation;
    index?: boolean;
    on_script_error?: MappingOnScriptError;
    script?: Script | ScriptSource;
    type: 'geo_point';
    time_series_metric?: MappingGeoPointMetricType;
}
export interface MappingGeoShapeProperty extends MappingDocValuesPropertyBase {
    coerce?: boolean;
    ignore_malformed?: boolean;
    ignore_z_value?: boolean;
    index?: boolean;
    orientation?: MappingGeoOrientation;
    strategy?: MappingGeoStrategy;
    type: 'geo_shape';
}
export type MappingGeoStrategy = 'recursive' | 'term';
export interface MappingHalfFloatNumberProperty extends MappingNumberPropertyBase {
    type: 'half_float';
    null_value?: float;
}
export interface MappingHistogramProperty extends MappingPropertyBase {
    ignore_malformed?: boolean;
    type: 'histogram';
}
export interface MappingIcuCollationProperty extends MappingDocValuesPropertyBase {
    type: 'icu_collation_keyword';
    norms?: boolean;
    index_options?: MappingIndexOptions;
    /** Should the field be searchable? */
    index?: boolean;
    /** Accepts a string value which is substituted for any explicit null values. Defaults to null, which means the field is treated as missing. */
    null_value?: string;
    rules?: string;
    language?: string;
    country?: string;
    variant?: string;
    strength?: AnalysisIcuCollationStrength;
    decomposition?: AnalysisIcuCollationDecomposition;
    alternate?: AnalysisIcuCollationAlternate;
    case_level?: boolean;
    case_first?: AnalysisIcuCollationCaseFirst;
    numeric?: boolean;
    variable_top?: string;
    hiragana_quaternary_mode?: boolean;
}
export interface MappingIndexField {
    enabled: boolean;
}
export type MappingIndexOptions = 'docs' | 'freqs' | 'positions' | 'offsets';
export interface MappingIntegerNumberProperty extends MappingNumberPropertyBase {
    type: 'integer';
    null_value?: integer;
}
export interface MappingIntegerRangeProperty extends MappingRangePropertyBase {
    type: 'integer_range';
}
export interface MappingIpProperty extends MappingDocValuesPropertyBase {
    boost?: double;
    index?: boolean;
    ignore_malformed?: boolean;
    null_value?: string;
    on_script_error?: MappingOnScriptError;
    script?: Script | ScriptSource;
    /** For internal use by Elastic only. Marks the field as a time series dimension. Defaults to false.
      * @experimental */
    time_series_dimension?: boolean;
    type: 'ip';
}
export interface MappingIpRangeProperty extends MappingRangePropertyBase {
    type: 'ip_range';
}
export interface MappingJoinProperty extends MappingPropertyBase {
    relations?: Record<RelationName, RelationName | RelationName[]>;
    eager_global_ordinals?: boolean;
    type: 'join';
}
export interface MappingKeywordProperty extends MappingDocValuesPropertyBase {
    boost?: double;
    eager_global_ordinals?: boolean;
    index?: boolean;
    index_options?: MappingIndexOptions;
    script?: Script | ScriptSource;
    on_script_error?: MappingOnScriptError;
    normalizer?: string;
    norms?: boolean;
    null_value?: string;
    similarity?: string | null;
    split_queries_on_whitespace?: boolean;
    /** For internal use by Elastic only. Marks the field as a time series dimension. Defaults to false.
      * @experimental */
    time_series_dimension?: boolean;
    type: 'keyword';
}
export interface MappingLongNumberProperty extends MappingNumberPropertyBase {
    type: 'long';
    null_value?: long;
}
export interface MappingLongRangeProperty extends MappingRangePropertyBase {
    type: 'long_range';
}
export interface MappingMatchOnlyTextProperty {
    type: 'match_only_text';
    /** Multi-fields allow the same string value to be indexed in multiple ways for different purposes, such as one
      * field for search and a multi-field for sorting and aggregations, or the same string value analyzed by different analyzers. */
    fields?: Record<PropertyName, MappingProperty>;
    /** Metadata about the field. */
    meta?: Record<string, string>;
    /** Allows you to copy the values of multiple fields into a group
      * field, which can then be queried as a single field. */
    copy_to?: Fields;
}
export type MappingMatchType = 'simple' | 'regex';
export interface MappingMurmur3HashProperty extends MappingDocValuesPropertyBase {
    type: 'murmur3';
}
export interface MappingNestedProperty extends MappingCorePropertyBase {
    enabled?: boolean;
    include_in_parent?: boolean;
    include_in_root?: boolean;
    type: 'nested';
}
export interface MappingNumberPropertyBase extends MappingDocValuesPropertyBase {
    boost?: double;
    coerce?: boolean;
    ignore_malformed?: boolean;
    index?: boolean;
    on_script_error?: MappingOnScriptError;
    script?: Script | ScriptSource;
    /** For internal use by Elastic only. Marks the field as a time series dimension. Defaults to false.
      * @experimental */
    time_series_metric?: MappingTimeSeriesMetricType;
    /** For internal use by Elastic only. Marks the field as a time series dimension. Defaults to false.
      * @experimental */
    time_series_dimension?: boolean;
}
export interface MappingObjectProperty extends MappingCorePropertyBase {
    enabled?: boolean;
    subobjects?: MappingSubobjects;
    type?: 'object';
}
export type MappingOnScriptError = 'fail' | 'continue';
export interface MappingPassthroughObjectProperty extends MappingCorePropertyBase {
    type?: 'passthrough';
    enabled?: boolean;
    priority?: integer;
    time_series_dimension?: boolean;
}
export interface MappingPercolatorProperty extends MappingPropertyBase {
    type: 'percolator';
}
export interface MappingPointProperty extends MappingDocValuesPropertyBase {
    ignore_malformed?: boolean;
    ignore_z_value?: boolean;
    null_value?: string;
    type: 'point';
}
export type MappingProperty = MappingBinaryProperty | MappingBooleanProperty | MappingDynamicProperty | MappingJoinProperty | MappingKeywordProperty | MappingMatchOnlyTextProperty | MappingPercolatorProperty | MappingRankFeatureProperty | MappingRankFeaturesProperty | MappingSearchAsYouTypeProperty | MappingTextProperty | MappingVersionProperty | MappingWildcardProperty | MappingDateNanosProperty | MappingDateProperty | MappingAggregateMetricDoubleProperty | MappingDenseVectorProperty | MappingFlattenedProperty | MappingNestedProperty | MappingObjectProperty | MappingPassthroughObjectProperty | MappingRankVectorProperty | MappingSemanticTextProperty | MappingSparseVectorProperty | MappingCompletionProperty | MappingConstantKeywordProperty | MappingCountedKeywordProperty | MappingFieldAliasProperty | MappingHistogramProperty | MappingIpProperty | MappingMurmur3HashProperty | MappingTokenCountProperty | MappingGeoPointProperty | MappingGeoShapeProperty | MappingPointProperty | MappingShapeProperty | MappingByteNumberProperty | MappingDoubleNumberProperty | MappingFloatNumberProperty | MappingHalfFloatNumberProperty | MappingIntegerNumberProperty | MappingLongNumberProperty | MappingScaledFloatNumberProperty | MappingShortNumberProperty | MappingUnsignedLongNumberProperty | MappingDateRangeProperty | MappingDoubleRangeProperty | MappingFloatRangeProperty | MappingIntegerRangeProperty | MappingIpRangeProperty | MappingLongRangeProperty | MappingIcuCollationProperty;
export interface MappingPropertyBase {
    /** Metadata about the field. */
    meta?: Record<string, string>;
    properties?: Record<PropertyName, MappingProperty>;
    ignore_above?: integer;
    dynamic?: MappingDynamicMapping;
    fields?: Record<PropertyName, MappingProperty>;
    synthetic_source_keep?: MappingSyntheticSourceKeepEnum;
}
export interface MappingRangePropertyBase extends MappingDocValuesPropertyBase {
    boost?: double;
    coerce?: boolean;
    index?: boolean;
}
export interface MappingRankFeatureProperty extends MappingPropertyBase {
    positive_score_impact?: boolean;
    type: 'rank_feature';
}
export interface MappingRankFeaturesProperty extends MappingPropertyBase {
    positive_score_impact?: boolean;
    type: 'rank_features';
}
export type MappingRankVectorElementType = 'byte' | 'float' | 'bit';
export interface MappingRankVectorProperty extends MappingPropertyBase {
    type: 'rank_vectors';
    element_type?: MappingRankVectorElementType;
    dims?: integer;
}
export interface MappingRoutingField {
    required: boolean;
}
export interface MappingRuntimeField {
    /** For type `composite` */
    fields?: Record<string, MappingCompositeSubField>;
    /** For type `lookup` */
    fetch_fields?: (MappingRuntimeFieldFetchFields | Field)[];
    /** A custom format for `date` type runtime fields. */
    format?: string;
    /** For type `lookup` */
    input_field?: Field;
    /** For type `lookup` */
    target_field?: Field;
    /** For type `lookup` */
    target_index?: IndexName;
    /** Painless script executed at query time. */
    script?: Script | ScriptSource;
    /** Field type, which can be: `boolean`, `composite`, `date`, `double`, `geo_point`, `ip`,`keyword`, `long`, or `lookup`. */
    type: MappingRuntimeFieldType;
}
export interface MappingRuntimeFieldFetchFields {
    field: Field;
    format?: string;
}
export type MappingRuntimeFieldType = 'boolean' | 'composite' | 'date' | 'double' | 'geo_point' | 'geo_shape' | 'ip' | 'keyword' | 'long' | 'lookup';
export type MappingRuntimeFields = Record<Field, MappingRuntimeField>;
export interface MappingScaledFloatNumberProperty extends MappingNumberPropertyBase {
    type: 'scaled_float';
    null_value?: double;
    scaling_factor?: double;
}
export interface MappingSearchAsYouTypeProperty extends MappingCorePropertyBase {
    analyzer?: string;
    index?: boolean;
    index_options?: MappingIndexOptions;
    max_shingle_size?: integer;
    norms?: boolean;
    search_analyzer?: string;
    search_quote_analyzer?: string;
    similarity?: string | null;
    term_vector?: MappingTermVectorOption;
    type: 'search_as_you_type';
}
export interface MappingSemanticTextProperty {
    type: 'semantic_text';
    meta?: Record<string, string>;
    /** Inference endpoint that will be used to generate embeddings for the field.
      * This parameter cannot be updated. Use the Create inference API to create the endpoint.
      * If `search_inference_id` is specified, the inference endpoint will only be used at index time. */
    inference_id?: Id;
    /** Inference endpoint that will be used to generate embeddings at query time.
      * You can update this parameter by using the Update mapping API. Use the Create inference API to create the endpoint.
      * If not specified, the inference endpoint defined by inference_id will be used at both index and query time. */
    search_inference_id?: Id;
    /** Settings for chunking text into smaller passages. If specified, these will override the
      * chunking settings sent in the inference endpoint associated with inference_id. If chunking settings are updated,
      * they will not be applied to existing documents until they are reindexed. */
    chunking_settings?: MappingChunkingSettings;
}
export interface MappingShapeProperty extends MappingDocValuesPropertyBase {
    coerce?: boolean;
    ignore_malformed?: boolean;
    ignore_z_value?: boolean;
    orientation?: MappingGeoOrientation;
    type: 'shape';
}
export interface MappingShortNumberProperty extends MappingNumberPropertyBase {
    type: 'short';
    null_value?: short;
}
export interface MappingSizeField {
    enabled: boolean;
}
export interface MappingSourceField {
    compress?: boolean;
    compress_threshold?: string;
    enabled?: boolean;
    excludes?: string[];
    includes?: string[];
    mode?: MappingSourceFieldMode;
}
export type MappingSourceFieldMode = 'disabled' | 'stored' | 'synthetic';
export interface MappingSparseVectorIndexOptions {
    /** Whether to perform pruning, omitting the non-significant tokens from the query to improve query performance.
      * If prune is true but the pruning_config is not specified, pruning will occur but default values will be used.
      * Default: false */
    prune?: boolean;
    /** Optional pruning configuration.
      * If enabled, this will omit non-significant tokens from the query in order to improve query performance.
      * This is only used if prune is set to true.
      * If prune is set to true but pruning_config is not specified, default values will be used. */
    pruning_config?: TokenPruningConfig;
}
export interface MappingSparseVectorProperty extends MappingPropertyBase {
    store?: boolean;
    type: 'sparse_vector';
    /** Additional index options for the sparse vector field that controls the
      * token pruning behavior of the sparse vector field. */
    index_options?: MappingSparseVectorIndexOptions;
}
export type MappingSubobjects = boolean | 'true' | 'false' | 'auto';
export interface MappingSuggestContext {
    name: Name;
    path?: Field;
    type: string;
    precision?: integer | string;
}
export type MappingSyntheticSourceKeepEnum = 'none' | 'arrays' | 'all';
export type MappingTermVectorOption = 'no' | 'yes' | 'with_offsets' | 'with_positions' | 'with_positions_offsets' | 'with_positions_offsets_payloads' | 'with_positions_payloads';
export interface MappingTextIndexPrefixes {
    max_chars: integer;
    min_chars: integer;
}
export interface MappingTextProperty extends MappingCorePropertyBase {
    analyzer?: string;
    boost?: double;
    eager_global_ordinals?: boolean;
    fielddata?: boolean;
    fielddata_frequency_filter?: IndicesFielddataFrequencyFilter;
    index?: boolean;
    index_options?: MappingIndexOptions;
    index_phrases?: boolean;
    index_prefixes?: MappingTextIndexPrefixes | null;
    norms?: boolean;
    position_increment_gap?: integer;
    search_analyzer?: string;
    search_quote_analyzer?: string;
    similarity?: string | null;
    term_vector?: MappingTermVectorOption;
    type: 'text';
}
export type MappingTimeSeriesMetricType = 'gauge' | 'counter' | 'summary' | 'histogram' | 'position';
export interface MappingTokenCountProperty extends MappingDocValuesPropertyBase {
    analyzer?: string;
    boost?: double;
    index?: boolean;
    null_value?: double;
    enable_position_increments?: boolean;
    type: 'token_count';
}
export interface MappingTypeMapping {
    all_field?: MappingAllField;
    date_detection?: boolean;
    dynamic?: MappingDynamicMapping;
    dynamic_date_formats?: string[];
    dynamic_templates?: Partial<Record<string, MappingDynamicTemplate>>[];
    _field_names?: MappingFieldNamesField;
    index_field?: MappingIndexField;
    _meta?: Metadata;
    numeric_detection?: boolean;
    properties?: Record<PropertyName, MappingProperty>;
    _routing?: MappingRoutingField;
    _size?: MappingSizeField;
    _source?: MappingSourceField;
    runtime?: Record<string, MappingRuntimeField>;
    enabled?: boolean;
    subobjects?: MappingSubobjects;
    _data_stream_timestamp?: MappingDataStreamTimestamp;
}
export interface MappingUnsignedLongNumberProperty extends MappingNumberPropertyBase {
    type: 'unsigned_long';
    null_value?: ulong;
}
export interface MappingVersionProperty extends MappingDocValuesPropertyBase {
    type: 'version';
}
export interface MappingWildcardProperty extends MappingDocValuesPropertyBase {
    type: 'wildcard';
    null_value?: string;
}
export interface QueryDslBoolQuery extends QueryDslQueryBase {
    /** The clause (query) must appear in matching documents.
      * However, unlike `must`, the score of the query will be ignored. */
    filter?: QueryDslQueryContainer | QueryDslQueryContainer[];
    /** Specifies the number or percentage of `should` clauses returned documents must match. */
    minimum_should_match?: MinimumShouldMatch;
    /** The clause (query) must appear in matching documents and will contribute to the score. */
    must?: QueryDslQueryContainer | QueryDslQueryContainer[];
    /** The clause (query) must not appear in the matching documents.
      * Because scoring is ignored, a score of `0` is returned for all documents. */
    must_not?: QueryDslQueryContainer | QueryDslQueryContainer[];
    /** The clause (query) should appear in the matching document. */
    should?: QueryDslQueryContainer | QueryDslQueryContainer[];
}
export interface QueryDslBoostingQuery extends QueryDslQueryBase {
    /** Floating point number between 0 and 1.0 used to decrease the relevance scores of documents matching the `negative` query. */
    negative_boost: double;
    /** Query used to decrease the relevance score of matching documents. */
    negative: QueryDslQueryContainer;
    /** Any returned documents must match this query. */
    positive: QueryDslQueryContainer;
}
export type QueryDslChildScoreMode = 'none' | 'avg' | 'sum' | 'max' | 'min';
export type QueryDslCombinedFieldsOperator = 'or' | 'and';
export interface QueryDslCombinedFieldsQuery extends QueryDslQueryBase {
    /** List of fields to search. Field wildcard patterns are allowed. Only `text` fields are supported, and they must all have the same search `analyzer`. */
    fields: Field[];
    /** Text to search for in the provided `fields`.
      * The `combined_fields` query analyzes the provided text before performing a search. */
    query: string;
    /** If true, match phrase queries are automatically created for multi-term synonyms. */
    auto_generate_synonyms_phrase_query?: boolean;
    /** Boolean logic used to interpret text in the query value. */
    operator?: QueryDslCombinedFieldsOperator;
    /** Minimum number of clauses that must match for a document to be returned. */
    minimum_should_match?: MinimumShouldMatch;
    /** Indicates whether no documents are returned if the analyzer removes all tokens, such as when using a `stop` filter. */
    zero_terms_query?: QueryDslCombinedFieldsZeroTerms;
}
export type QueryDslCombinedFieldsZeroTerms = 'none' | 'all';
export interface QueryDslCommonTermsQuery extends QueryDslQueryBase {
    analyzer?: string;
    cutoff_frequency?: double;
    high_freq_operator?: QueryDslOperator;
    low_freq_operator?: QueryDslOperator;
    minimum_should_match?: MinimumShouldMatch;
    query: string;
}
export interface QueryDslConstantScoreQuery extends QueryDslQueryBase {
    /** Filter query you wish to run. Any returned documents must match this query.
      * Filter queries do not calculate relevance scores.
      * To speed up performance, Elasticsearch automatically caches frequently used filter queries. */
    filter: QueryDslQueryContainer;
}
export interface QueryDslDateDecayFunctionKeys extends QueryDslDecayFunctionBase<DateMath, Duration> {
}
export type QueryDslDateDecayFunction = QueryDslDateDecayFunctionKeys & {
    [property: string]: QueryDslDecayPlacement | QueryDslMultiValueMode;
};
export interface QueryDslDateDistanceFeatureQuery extends QueryDslDistanceFeatureQueryBase<DateMath, Duration> {
}
export interface QueryDslDateRangeQuery extends QueryDslRangeQueryBase<DateMath> {
    /** Date format used to convert `date` values in the query. */
    format?: DateFormat;
    /** Coordinated Universal Time (UTC) offset or IANA time zone used to convert `date` values in the query to UTC. */
    time_zone?: TimeZone;
}
export type QueryDslDecayFunction = QueryDslUntypedDecayFunction | QueryDslDateDecayFunction | QueryDslNumericDecayFunction | QueryDslGeoDecayFunction;
export interface QueryDslDecayFunctionBase<TOrigin = unknown, TScale = unknown> {
    /** Determines how the distance is calculated when a field used for computing the decay contains multiple values. */
    multi_value_mode?: QueryDslMultiValueMode;
}
export interface QueryDslDecayPlacement<TOrigin = unknown, TScale = unknown> {
    /** Defines how documents are scored at the distance given at scale. */
    decay?: double;
    /** If defined, the decay function will only compute the decay function for documents with a distance greater than the defined `offset`. */
    offset?: TScale;
    /** Defines the distance from origin + offset at which the computed score will equal `decay` parameter. */
    scale?: TScale;
    /** The point of origin used for calculating distance. Must be given as a number for numeric field, date for date fields and geo point for geo fields. */
    origin?: TOrigin;
}
export interface QueryDslDisMaxQuery extends QueryDslQueryBase {
    /** One or more query clauses.
      * Returned documents must match one or more of these queries.
      * If a document matches multiple queries, Elasticsearch uses the highest relevance score. */
    queries: QueryDslQueryContainer[];
    /** Floating point number between 0 and 1.0 used to increase the relevance scores of documents matching multiple query clauses. */
    tie_breaker?: double;
}
export type QueryDslDistanceFeatureQuery = QueryDslUntypedDistanceFeatureQuery | QueryDslGeoDistanceFeatureQuery | QueryDslDateDistanceFeatureQuery;
export interface QueryDslDistanceFeatureQueryBase<TOrigin = unknown, TDistance = unknown> extends QueryDslQueryBase {
    /** Date or point of origin used to calculate distances.
      * If the `field` value is a `date` or `date_nanos` field, the `origin` value must be a date.
      * Date Math, such as `now-1h`, is supported.
      * If the field value is a `geo_point` field, the `origin` value must be a geopoint. */
    origin: TOrigin;
    /** Distance from the `origin` at which relevance scores receive half of the `boost` value.
      * If the `field` value is a `date` or `date_nanos` field, the `pivot` value must be a time unit, such as `1h` or `10d`. If the `field` value is a `geo_point` field, the `pivot` value must be a distance unit, such as `1km` or `12m`. */
    pivot: TDistance;
    /** Name of the field used to calculate distances. This field must meet the following criteria:
      * be a `date`, `date_nanos` or `geo_point` field;
      * have an `index` mapping parameter value of `true`, which is the default;
      * have an `doc_values` mapping parameter value of `true`, which is the default. */
    field: Field;
}
export interface QueryDslExistsQuery extends QueryDslQueryBase {
    /** Name of the field you wish to search. */
    field: Field;
}
export interface QueryDslFieldAndFormat {
    /** A wildcard pattern. The request returns values for field names matching this pattern. */
    field: Field;
    /** The format in which the values are returned. */
    format?: string;
    include_unmapped?: boolean;
}
export interface QueryDslFieldLookup {
    /** `id` of the document. */
    id: Id;
    /** Index from which to retrieve the document. */
    index?: IndexName;
    /** Name of the field. */
    path?: Field;
    /** Custom routing value. */
    routing?: Routing;
}
export type QueryDslFieldValueFactorModifier = 'none' | 'log' | 'log1p' | 'log2p' | 'ln' | 'ln1p' | 'ln2p' | 'square' | 'sqrt' | 'reciprocal';
export interface QueryDslFieldValueFactorScoreFunction {
    /** Field to be extracted from the document. */
    field: Field;
    /** Optional factor to multiply the field value with. */
    factor?: double;
    /** Value used if the document doesn’t have that field.
      * The modifier and factor are still applied to it as though it were read from the document. */
    missing?: double;
    /** Modifier to apply to the field value. */
    modifier?: QueryDslFieldValueFactorModifier;
}
export type QueryDslFunctionBoostMode = 'multiply' | 'replace' | 'sum' | 'avg' | 'max' | 'min';
export interface QueryDslFunctionScoreContainer {
    /** Function that scores a document with a exponential decay, depending on the distance of a numeric field value of the document from an origin. */
    exp?: QueryDslDecayFunction;
    /** Function that scores a document with a normal decay, depending on the distance of a numeric field value of the document from an origin. */
    gauss?: QueryDslDecayFunction;
    /** Function that scores a document with a linear decay, depending on the distance of a numeric field value of the document from an origin. */
    linear?: QueryDslDecayFunction;
    /** Function allows you to use a field from a document to influence the score.
      * It’s similar to using the script_score function, however, it avoids the overhead of scripting. */
    field_value_factor?: QueryDslFieldValueFactorScoreFunction;
    /** Generates scores that are uniformly distributed from 0 up to but not including 1.
      * In case you want scores to be reproducible, it is possible to provide a `seed` and `field`. */
    random_score?: QueryDslRandomScoreFunction;
    /** Enables you to wrap another query and customize the scoring of it optionally with a computation derived from other numeric field values in the doc using a script expression. */
    script_score?: QueryDslScriptScoreFunction;
    filter?: QueryDslQueryContainer;
    weight?: double;
}
export type QueryDslFunctionScoreMode = 'multiply' | 'sum' | 'avg' | 'first' | 'max' | 'min';
export interface QueryDslFunctionScoreQuery extends QueryDslQueryBase {
    /** Defines how he newly computed score is combined with the score of the query */
    boost_mode?: QueryDslFunctionBoostMode;
    /** One or more functions that compute a new score for each document returned by the query. */
    functions?: QueryDslFunctionScoreContainer[];
    /** Restricts the new score to not exceed the provided limit. */
    max_boost?: double;
    /** Excludes documents that do not meet the provided score threshold. */
    min_score?: double;
    /** A query that determines the documents for which a new score is computed. */
    query?: QueryDslQueryContainer;
    /** Specifies how the computed scores are combined */
    score_mode?: QueryDslFunctionScoreMode;
}
export interface QueryDslFuzzyQuery extends QueryDslQueryBase {
    /** Maximum number of variations created. */
    max_expansions?: integer;
    /** Number of beginning characters left unchanged when creating expansions. */
    prefix_length?: integer;
    /** Number of beginning characters left unchanged when creating expansions. */
    rewrite?: MultiTermQueryRewrite;
    /** Indicates whether edits include transpositions of two adjacent characters (for example `ab` to `ba`). */
    transpositions?: boolean;
    /** Maximum edit distance allowed for matching. */
    fuzziness?: Fuzziness;
    /** Term you wish to find in the provided field. */
    value: string | double | boolean;
}
export interface QueryDslGeoBoundingBoxQueryKeys extends QueryDslQueryBase {
    type?: QueryDslGeoExecution;
    /** Set to `IGNORE_MALFORMED` to accept geo points with invalid latitude or longitude.
      * Set to `COERCE` to also try to infer correct latitude or longitude. */
    validation_method?: QueryDslGeoValidationMethod;
    /** Set to `true` to ignore an unmapped field and not match any documents for this query.
      * Set to `false` to throw an exception if the field is not mapped. */
    ignore_unmapped?: boolean;
}
export type QueryDslGeoBoundingBoxQuery = QueryDslGeoBoundingBoxQueryKeys & {
    [property: string]: GeoBounds | QueryDslGeoExecution | QueryDslGeoValidationMethod | boolean | float | string;
};
export interface QueryDslGeoDecayFunctionKeys extends QueryDslDecayFunctionBase<GeoLocation, Distance> {
}
export type QueryDslGeoDecayFunction = QueryDslGeoDecayFunctionKeys & {
    [property: string]: QueryDslDecayPlacement | QueryDslMultiValueMode;
};
export interface QueryDslGeoDistanceFeatureQuery extends QueryDslDistanceFeatureQueryBase<GeoLocation, Distance> {
}
export interface QueryDslGeoDistanceQueryKeys extends QueryDslQueryBase {
    /** The radius of the circle centred on the specified location.
      * Points which fall into this circle are considered to be matches. */
    distance: Distance;
    /** How to compute the distance.
      * Set to `plane` for a faster calculation that's inaccurate on long distances and close to the poles. */
    distance_type?: GeoDistanceType;
    /** Set to `IGNORE_MALFORMED` to accept geo points with invalid latitude or longitude.
      * Set to `COERCE` to also try to infer correct latitude or longitude. */
    validation_method?: QueryDslGeoValidationMethod;
    /** Set to `true` to ignore an unmapped field and not match any documents for this query.
      * Set to `false` to throw an exception if the field is not mapped. */
    ignore_unmapped?: boolean;
}
export type QueryDslGeoDistanceQuery = QueryDslGeoDistanceQueryKeys & {
    [property: string]: GeoLocation | Distance | GeoDistanceType | QueryDslGeoValidationMethod | boolean | float | string;
};
export type QueryDslGeoExecution = 'memory' | 'indexed';
export interface QueryDslGeoGridQuery extends QueryDslQueryBase {
    geotile?: GeoTile;
    geohash?: GeoHash;
    geohex?: GeoHexCell;
}
export interface QueryDslGeoPolygonPoints {
    points: GeoLocation[];
}
export interface QueryDslGeoPolygonQueryKeys extends QueryDslQueryBase {
    validation_method?: QueryDslGeoValidationMethod;
    ignore_unmapped?: boolean;
}
export type QueryDslGeoPolygonQuery = QueryDslGeoPolygonQueryKeys & {
    [property: string]: QueryDslGeoPolygonPoints | QueryDslGeoValidationMethod | boolean | float | string;
};
export interface QueryDslGeoShapeFieldQuery {
    shape?: GeoShape;
    /** Query using an indexed shape retrieved from the the specified document and path. */
    indexed_shape?: QueryDslFieldLookup;
    /** Spatial relation operator used to search a geo field. */
    relation?: GeoShapeRelation;
}
export interface QueryDslGeoShapeQueryKeys extends QueryDslQueryBase {
    /** Set to `true` to ignore an unmapped field and not match any documents for this query.
      * Set to `false` to throw an exception if the field is not mapped. */
    ignore_unmapped?: boolean;
}
export type QueryDslGeoShapeQuery = QueryDslGeoShapeQueryKeys & {
    [property: string]: QueryDslGeoShapeFieldQuery | boolean | float | string;
};
export type QueryDslGeoValidationMethod = 'coerce' | 'ignore_malformed' | 'strict';
export interface QueryDslHasChildQuery extends QueryDslQueryBase {
    /** Indicates whether to ignore an unmapped `type` and not return any documents instead of an error. */
    ignore_unmapped?: boolean;
    /** If defined, each search hit will contain inner hits. */
    inner_hits?: SearchInnerHits;
    /** Maximum number of child documents that match the query allowed for a returned parent document.
      * If the parent document exceeds this limit, it is excluded from the search results. */
    max_children?: integer;
    /** Minimum number of child documents that match the query required to match the query for a returned parent document.
      * If the parent document does not meet this limit, it is excluded from the search results. */
    min_children?: integer;
    /** Query you wish to run on child documents of the `type` field.
      * If a child document matches the search, the query returns the parent document. */
    query: QueryDslQueryContainer;
    /** Indicates how scores for matching child documents affect the root parent document’s relevance score. */
    score_mode?: QueryDslChildScoreMode;
    /** Name of the child relationship mapped for the `join` field. */
    type: RelationName;
}
export interface QueryDslHasParentQuery extends QueryDslQueryBase {
    /** Indicates whether to ignore an unmapped `parent_type` and not return any documents instead of an error.
      * You can use this parameter to query multiple indices that may not contain the `parent_type`. */
    ignore_unmapped?: boolean;
    /** If defined, each search hit will contain inner hits. */
    inner_hits?: SearchInnerHits;
    /** Name of the parent relationship mapped for the `join` field. */
    parent_type: RelationName;
    /** Query you wish to run on parent documents of the `parent_type` field.
      * If a parent document matches the search, the query returns its child documents. */
    query: QueryDslQueryContainer;
    /** Indicates whether the relevance score of a matching parent document is aggregated into its child documents. */
    score?: boolean;
}
export interface QueryDslIdsQuery extends QueryDslQueryBase {
    /** An array of document IDs. */
    values?: Ids;
}
export interface QueryDslIntervalsAllOf {
    /** An array of rules to combine. All rules must produce a match in a document for the overall source to match. */
    intervals: QueryDslIntervalsContainer[];
    /** Maximum number of positions between the matching terms.
      * Intervals produced by the rules further apart than this are not considered matches. */
    max_gaps?: integer;
    /** If `true`, intervals produced by the rules should appear in the order in which they are specified. */
    ordered?: boolean;
    /** Rule used to filter returned intervals. */
    filter?: QueryDslIntervalsFilter;
}
export interface QueryDslIntervalsAnyOf {
    /** An array of rules to match. */
    intervals: QueryDslIntervalsContainer[];
    /** Rule used to filter returned intervals. */
    filter?: QueryDslIntervalsFilter;
}
export interface QueryDslIntervalsContainer {
    /** Returns matches that span a combination of other rules. */
    all_of?: QueryDslIntervalsAllOf;
    /** Returns intervals produced by any of its sub-rules. */
    any_of?: QueryDslIntervalsAnyOf;
    /** Matches analyzed text. */
    fuzzy?: QueryDslIntervalsFuzzy;
    /** Matches analyzed text. */
    match?: QueryDslIntervalsMatch;
    /** Matches terms that start with a specified set of characters. */
    prefix?: QueryDslIntervalsPrefix;
    range?: QueryDslIntervalsRange;
    regexp?: QueryDslIntervalsRegexp;
    /** Matches terms using a wildcard pattern. */
    wildcard?: QueryDslIntervalsWildcard;
}
export interface QueryDslIntervalsFilter {
    /** Query used to return intervals that follow an interval from the `filter` rule. */
    after?: QueryDslIntervalsContainer;
    /** Query used to return intervals that occur before an interval from the `filter` rule. */
    before?: QueryDslIntervalsContainer;
    /** Query used to return intervals contained by an interval from the `filter` rule. */
    contained_by?: QueryDslIntervalsContainer;
    /** Query used to return intervals that contain an interval from the `filter` rule. */
    containing?: QueryDslIntervalsContainer;
    /** Query used to return intervals that are **not** contained by an interval from the `filter` rule. */
    not_contained_by?: QueryDslIntervalsContainer;
    /** Query used to return intervals that do **not** contain an interval from the `filter` rule. */
    not_containing?: QueryDslIntervalsContainer;
    /** Query used to return intervals that do **not** overlap with an interval from the `filter` rule. */
    not_overlapping?: QueryDslIntervalsContainer;
    /** Query used to return intervals that overlap with an interval from the `filter` rule. */
    overlapping?: QueryDslIntervalsContainer;
    /** Script used to return matching documents.
      * This script must return a boolean value: `true` or `false`. */
    script?: Script | ScriptSource;
}
export interface QueryDslIntervalsFuzzy {
    /** Analyzer used to normalize the term. */
    analyzer?: string;
    /** Maximum edit distance allowed for matching. */
    fuzziness?: Fuzziness;
    /** Number of beginning characters left unchanged when creating expansions. */
    prefix_length?: integer;
    /** The term to match. */
    term: string;
    /** Indicates whether edits include transpositions of two adjacent characters (for example, `ab` to `ba`). */
    transpositions?: boolean;
    /** If specified, match intervals from this field rather than the top-level field.
      * The `term` is normalized using the search analyzer from this field, unless `analyzer` is specified separately. */
    use_field?: Field;
}
export interface QueryDslIntervalsMatch {
    /** Analyzer used to analyze terms in the query. */
    analyzer?: string;
    /** Maximum number of positions between the matching terms.
      * Terms further apart than this are not considered matches. */
    max_gaps?: integer;
    /** If `true`, matching terms must appear in their specified order. */
    ordered?: boolean;
    /** Text you wish to find in the provided field. */
    query: string;
    /** If specified, match intervals from this field rather than the top-level field.
      * The `term` is normalized using the search analyzer from this field, unless `analyzer` is specified separately. */
    use_field?: Field;
    /** An optional interval filter. */
    filter?: QueryDslIntervalsFilter;
}
export interface QueryDslIntervalsPrefix {
    /** Analyzer used to analyze the `prefix`. */
    analyzer?: string;
    /** Beginning characters of terms you wish to find in the top-level field. */
    prefix: string;
    /** If specified, match intervals from this field rather than the top-level field.
      * The `prefix` is normalized using the search analyzer from this field, unless `analyzer` is specified separately. */
    use_field?: Field;
}
export interface QueryDslIntervalsQuery extends QueryDslQueryBase {
    /** Returns matches that span a combination of other rules. */
    all_of?: QueryDslIntervalsAllOf;
    /** Returns intervals produced by any of its sub-rules. */
    any_of?: QueryDslIntervalsAnyOf;
    /** Matches terms that are similar to the provided term, within an edit distance defined by `fuzziness`. */
    fuzzy?: QueryDslIntervalsFuzzy;
    /** Matches analyzed text. */
    match?: QueryDslIntervalsMatch;
    /** Matches terms that start with a specified set of characters. */
    prefix?: QueryDslIntervalsPrefix;
    range?: QueryDslIntervalsRange;
    regexp?: QueryDslIntervalsRegexp;
    /** Matches terms using a wildcard pattern. */
    wildcard?: QueryDslIntervalsWildcard;
}
export interface QueryDslIntervalsRange {
    /** Analyzer used to analyze the `prefix`. */
    analyzer?: string;
    /** Lower term, either gte or gt must be provided. */
    gte?: string;
    /** Lower term, either gte or gt must be provided. */
    gt?: string;
    /** Upper term, either lte or lt must be provided. */
    lte?: string;
    /** Upper term, either lte or lt must be provided. */
    lt?: string;
    /** If specified, match intervals from this field rather than the top-level field.
      * The `prefix` is normalized using the search analyzer from this field, unless `analyzer` is specified separately. */
    use_field?: Field;
}
export interface QueryDslIntervalsRegexp {
    /** Analyzer used to analyze the `prefix`. */
    analyzer?: string;
    /** Regex pattern. */
    pattern: string;
    /** If specified, match intervals from this field rather than the top-level field.
      * The `prefix` is normalized using the search analyzer from this field, unless `analyzer` is specified separately. */
    use_field?: Field;
}
export interface QueryDslIntervalsWildcard {
    /** Analyzer used to analyze the `pattern`.
      * Defaults to the top-level field's analyzer. */
    analyzer?: string;
    /** Wildcard pattern used to find matching terms. */
    pattern: string;
    /** If specified, match intervals from this field rather than the top-level field.
      * The `pattern` is normalized using the search analyzer from this field, unless `analyzer` is specified separately. */
    use_field?: Field;
}
export type QueryDslLike = string | QueryDslLikeDocument;
export interface QueryDslLikeDocument {
    /** A document not present in the index. */
    doc?: any;
    fields?: Field[];
    /** ID of a document. */
    _id?: Id;
    /** Index of a document. */
    _index?: IndexName;
    /** Overrides the default analyzer. */
    per_field_analyzer?: Record<Field, string>;
    routing?: Routing;
    version?: VersionNumber;
    version_type?: VersionType;
}
export interface QueryDslMatchAllQuery extends QueryDslQueryBase {
}
export interface QueryDslMatchBoolPrefixQuery extends QueryDslQueryBase {
    /** Analyzer used to convert the text in the query value into tokens. */
    analyzer?: string;
    /** Maximum edit distance allowed for matching.
      * Can be applied to the term subqueries constructed for all terms but the final term. */
    fuzziness?: Fuzziness;
    /** Method used to rewrite the query.
      * Can be applied to the term subqueries constructed for all terms but the final term. */
    fuzzy_rewrite?: MultiTermQueryRewrite;
    /** If `true`, edits for fuzzy matching include transpositions of two adjacent characters (for example, `ab` to `ba`).
      * Can be applied to the term subqueries constructed for all terms but the final term. */
    fuzzy_transpositions?: boolean;
    /** Maximum number of terms to which the query will expand.
      * Can be applied to the term subqueries constructed for all terms but the final term. */
    max_expansions?: integer;
    /** Minimum number of clauses that must match for a document to be returned.
      * Applied to the constructed bool query. */
    minimum_should_match?: MinimumShouldMatch;
    /** Boolean logic used to interpret text in the query value.
      * Applied to the constructed bool query. */
    operator?: QueryDslOperator;
    /** Number of beginning characters left unchanged for fuzzy matching.
      * Can be applied to the term subqueries constructed for all terms but the final term. */
    prefix_length?: integer;
    /** Terms you wish to find in the provided field.
      * The last term is used in a prefix query. */
    query: string;
}
export interface QueryDslMatchNoneQuery extends QueryDslQueryBase {
}
export interface QueryDslMatchPhrasePrefixQuery extends QueryDslQueryBase {
    /** Analyzer used to convert text in the query value into tokens. */
    analyzer?: string;
    /** Maximum number of terms to which the last provided term of the query value will expand. */
    max_expansions?: integer;
    /** Text you wish to find in the provided field. */
    query: string;
    /** Maximum number of positions allowed between matching tokens. */
    slop?: integer;
    /** Indicates whether no documents are returned if the analyzer removes all tokens, such as when using a `stop` filter. */
    zero_terms_query?: QueryDslZeroTermsQuery;
}
export interface QueryDslMatchPhraseQuery extends QueryDslQueryBase {
    /** Analyzer used to convert the text in the query value into tokens. */
    analyzer?: string;
    /** Query terms that are analyzed and turned into a phrase query. */
    query: string;
    /** Maximum number of positions allowed between matching tokens. */
    slop?: integer;
    /** Indicates whether no documents are returned if the `analyzer` removes all tokens, such as when using a `stop` filter. */
    zero_terms_query?: QueryDslZeroTermsQuery;
}
export interface QueryDslMatchQuery extends QueryDslQueryBase {
    /** Analyzer used to convert the text in the query value into tokens. */
    analyzer?: string;
    /** If `true`, match phrase queries are automatically created for multi-term synonyms. */
    auto_generate_synonyms_phrase_query?: boolean;
    cutoff_frequency?: double;
    /** Maximum edit distance allowed for matching. */
    fuzziness?: Fuzziness;
    /** Method used to rewrite the query. */
    fuzzy_rewrite?: MultiTermQueryRewrite;
    /** If `true`, edits for fuzzy matching include transpositions of two adjacent characters (for example, `ab` to `ba`). */
    fuzzy_transpositions?: boolean;
    /** If `true`, format-based errors, such as providing a text query value for a numeric field, are ignored. */
    lenient?: boolean;
    /** Maximum number of terms to which the query will expand. */
    max_expansions?: integer;
    /** Minimum number of clauses that must match for a document to be returned. */
    minimum_should_match?: MinimumShouldMatch;
    /** Boolean logic used to interpret text in the query value. */
    operator?: QueryDslOperator;
    /** Number of beginning characters left unchanged for fuzzy matching. */
    prefix_length?: integer;
    /** Text, number, boolean value or date you wish to find in the provided field. */
    query: string | float | boolean;
    /** Indicates whether no documents are returned if the `analyzer` removes all tokens, such as when using a `stop` filter. */
    zero_terms_query?: QueryDslZeroTermsQuery;
}
export interface QueryDslMoreLikeThisQuery extends QueryDslQueryBase {
    /** The analyzer that is used to analyze the free form text.
      * Defaults to the analyzer associated with the first field in fields. */
    analyzer?: string;
    /** Each term in the formed query could be further boosted by their tf-idf score.
      * This sets the boost factor to use when using this feature.
      * Defaults to deactivated (0). */
    boost_terms?: double;
    /** Controls whether the query should fail (throw an exception) if any of the specified fields are not of the supported types (`text` or `keyword`). */
    fail_on_unsupported_field?: boolean;
    /** A list of fields to fetch and analyze the text from.
      * Defaults to the `index.query.default_field` index setting, which has a default value of `*`. */
    fields?: Field[];
    /** Specifies whether the input documents should also be included in the search results returned. */
    include?: boolean;
    /** Specifies free form text and/or a single or multiple documents for which you want to find similar documents. */
    like: QueryDslLike | QueryDslLike[];
    /** The maximum document frequency above which the terms are ignored from the input document. */
    max_doc_freq?: integer;
    /** The maximum number of query terms that can be selected. */
    max_query_terms?: integer;
    /** The maximum word length above which the terms are ignored.
      * Defaults to unbounded (`0`). */
    max_word_length?: integer;
    /** The minimum document frequency below which the terms are ignored from the input document. */
    min_doc_freq?: integer;
    /** After the disjunctive query has been formed, this parameter controls the number of terms that must match. */
    minimum_should_match?: MinimumShouldMatch;
    /** The minimum term frequency below which the terms are ignored from the input document. */
    min_term_freq?: integer;
    /** The minimum word length below which the terms are ignored. */
    min_word_length?: integer;
    routing?: Routing;
    /** An array of stop words.
      * Any word in this set is ignored. */
    stop_words?: AnalysisStopWords;
    /** Used in combination with `like` to exclude documents that match a set of terms. */
    unlike?: QueryDslLike | QueryDslLike[];
    version?: VersionNumber;
    version_type?: VersionType;
}
export interface QueryDslMultiMatchQuery extends QueryDslQueryBase {
    /** Analyzer used to convert the text in the query value into tokens. */
    analyzer?: string;
    /** If `true`, match phrase queries are automatically created for multi-term synonyms. */
    auto_generate_synonyms_phrase_query?: boolean;
    cutoff_frequency?: double;
    /** The fields to be queried.
      * Defaults to the `index.query.default_field` index settings, which in turn defaults to `*`. */
    fields?: Fields;
    /** Maximum edit distance allowed for matching. */
    fuzziness?: Fuzziness;
    /** Method used to rewrite the query. */
    fuzzy_rewrite?: MultiTermQueryRewrite;
    /** If `true`, edits for fuzzy matching include transpositions of two adjacent characters (for example, `ab` to `ba`).
      * Can be applied to the term subqueries constructed for all terms but the final term. */
    fuzzy_transpositions?: boolean;
    /** If `true`, format-based errors, such as providing a text query value for a numeric field, are ignored. */
    lenient?: boolean;
    /** Maximum number of terms to which the query will expand. */
    max_expansions?: integer;
    /** Minimum number of clauses that must match for a document to be returned. */
    minimum_should_match?: MinimumShouldMatch;
    /** Boolean logic used to interpret text in the query value. */
    operator?: QueryDslOperator;
    /** Number of beginning characters left unchanged for fuzzy matching. */
    prefix_length?: integer;
    /** Text, number, boolean value or date you wish to find in the provided field. */
    query: string;
    /** Maximum number of positions allowed between matching tokens. */
    slop?: integer;
    /** Determines how scores for each per-term blended query and scores across groups are combined. */
    tie_breaker?: double;
    /** How `the` multi_match query is executed internally. */
    type?: QueryDslTextQueryType;
    /** Indicates whether no documents are returned if the `analyzer` removes all tokens, such as when using a `stop` filter. */
    zero_terms_query?: QueryDslZeroTermsQuery;
}
export type QueryDslMultiValueMode = 'min' | 'max' | 'avg' | 'sum';
export interface QueryDslNestedQuery extends QueryDslQueryBase {
    /** Indicates whether to ignore an unmapped path and not return any documents instead of an error. */
    ignore_unmapped?: boolean;
    /** If defined, each search hit will contain inner hits. */
    inner_hits?: SearchInnerHits;
    /** Path to the nested object you wish to search. */
    path: Field;
    /** Query you wish to run on nested objects in the path. */
    query: QueryDslQueryContainer;
    /** How scores for matching child objects affect the root parent document’s relevance score. */
    score_mode?: QueryDslChildScoreMode;
}
export interface QueryDslNumberRangeQuery extends QueryDslRangeQueryBase<double> {
}
export interface QueryDslNumericDecayFunctionKeys extends QueryDslDecayFunctionBase<double, double> {
}
export type QueryDslNumericDecayFunction = QueryDslNumericDecayFunctionKeys & {
    [property: string]: QueryDslDecayPlacement | QueryDslMultiValueMode;
};
export type QueryDslOperator = 'and' | 'AND' | 'or' | 'OR';
export interface QueryDslParentIdQuery extends QueryDslQueryBase {
    /** ID of the parent document. */
    id?: Id;
    /** Indicates whether to ignore an unmapped `type` and not return any documents instead of an error. */
    ignore_unmapped?: boolean;
    /** Name of the child relationship mapped for the `join` field. */
    type?: RelationName;
}
export interface QueryDslPercolateQuery extends QueryDslQueryBase {
    /** The source of the document being percolated. */
    document?: any;
    /** An array of sources of the documents being percolated. */
    documents?: any[];
    /** Field that holds the indexed queries. The field must use the `percolator` mapping type. */
    field: Field;
    /** The ID of a stored document to percolate. */
    id?: Id;
    /** The index of a stored document to percolate. */
    index?: IndexName;
    /** The suffix used for the `_percolator_document_slot` field when multiple `percolate` queries are specified. */
    name?: string;
    /** Preference used to fetch document to percolate. */
    preference?: string;
    /** Routing used to fetch document to percolate. */
    routing?: Routing;
    /** The expected version of a stored document to percolate. */
    version?: VersionNumber;
}
export interface QueryDslPinnedDoc {
    /** The unique document ID. */
    _id: Id;
    /** The index that contains the document. */
    _index?: IndexName;
}
export interface QueryDslPinnedQuery extends QueryDslQueryBase {
    /** Any choice of query used to rank documents which will be ranked below the "pinned" documents. */
    organic: QueryDslQueryContainer;
    /** Document IDs listed in the order they are to appear in results.
      * Required if `docs` is not specified. */
    ids?: Id[];
    /** Documents listed in the order they are to appear in results.
      * Required if `ids` is not specified. */
    docs?: QueryDslPinnedDoc[];
}
export interface QueryDslPrefixQuery extends QueryDslQueryBase {
    /** Method used to rewrite the query. */
    rewrite?: MultiTermQueryRewrite;
    /** Beginning characters of terms you wish to find in the provided field. */
    value: string;
    /** Allows ASCII case insensitive matching of the value with the indexed field values when set to `true`.
      * Default is `false` which means the case sensitivity of matching depends on the underlying field’s mapping. */
    case_insensitive?: boolean;
}
export interface QueryDslQueryBase {
    /** Floating point number used to decrease or increase the relevance scores of the query.
      * Boost values are relative to the default value of 1.0.
      * A boost value between 0 and 1.0 decreases the relevance score.
      * A value greater than 1.0 increases the relevance score. */
    boost?: float;
    _name?: string;
}
export interface QueryDslQueryContainer {
    /** matches documents matching boolean combinations of other queries. */
    bool?: QueryDslBoolQuery;
    /** Returns documents matching a `positive` query while reducing the relevance score of documents that also match a `negative` query. */
    boosting?: QueryDslBoostingQuery;
    common?: Partial<Record<Field, QueryDslCommonTermsQuery | string>>;
    /** The `combined_fields` query supports searching multiple text fields as if their contents had been indexed into one combined field. */
    combined_fields?: QueryDslCombinedFieldsQuery;
    /** Wraps a filter query and returns every matching document with a relevance score equal to the `boost` parameter value. */
    constant_score?: QueryDslConstantScoreQuery;
    /** Returns documents matching one or more wrapped queries, called query clauses or clauses.
      * If a returned document matches multiple query clauses, the `dis_max` query assigns the document the highest relevance score from any matching clause, plus a tie breaking increment for any additional matching subqueries. */
    dis_max?: QueryDslDisMaxQuery;
    /** Boosts the relevance score of documents closer to a provided origin date or point.
      * For example, you can use this query to give more weight to documents closer to a certain date or location. */
    distance_feature?: QueryDslDistanceFeatureQuery;
    /** Returns documents that contain an indexed value for a field. */
    exists?: QueryDslExistsQuery;
    /** The `function_score` enables you to modify the score of documents that are retrieved by a query. */
    function_score?: QueryDslFunctionScoreQuery | QueryDslFunctionScoreContainer[];
    /** Returns documents that contain terms similar to the search term, as measured by a Levenshtein edit distance. */
    fuzzy?: Partial<Record<Field, QueryDslFuzzyQuery | string | double | boolean>>;
    /** Matches geo_point and geo_shape values that intersect a bounding box. */
    geo_bounding_box?: QueryDslGeoBoundingBoxQuery;
    /** Matches `geo_point` and `geo_shape` values within a given distance of a geopoint. */
    geo_distance?: QueryDslGeoDistanceQuery;
    /** Matches `geo_point` and `geo_shape` values that intersect a grid cell from a GeoGrid aggregation. */
    geo_grid?: Partial<Record<Field, QueryDslGeoGridQuery>>;
    geo_polygon?: QueryDslGeoPolygonQuery;
    /** Filter documents indexed using either the `geo_shape` or the `geo_point` type. */
    geo_shape?: QueryDslGeoShapeQuery;
    /** Returns parent documents whose joined child documents match a provided query. */
    has_child?: QueryDslHasChildQuery;
    /** Returns child documents whose joined parent document matches a provided query. */
    has_parent?: QueryDslHasParentQuery;
    /** Returns documents based on their IDs.
      * This query uses document IDs stored in the `_id` field. */
    ids?: QueryDslIdsQuery;
    /** Returns documents based on the order and proximity of matching terms. */
    intervals?: Partial<Record<Field, QueryDslIntervalsQuery>>;
    /** Finds the k nearest vectors to a query vector, as measured by a similarity
      * metric. knn query finds nearest vectors through approximate search on indexed
      * dense_vectors. */
    knn?: KnnQuery;
    /** Returns documents that match a provided text, number, date or boolean value.
      * The provided text is analyzed before matching. */
    match?: Partial<Record<Field, QueryDslMatchQuery | string | float | boolean>>;
    /** Matches all documents, giving them all a `_score` of 1.0. */
    match_all?: QueryDslMatchAllQuery;
    /** Analyzes its input and constructs a `bool` query from the terms.
      * Each term except the last is used in a `term` query.
      * The last term is used in a prefix query. */
    match_bool_prefix?: Partial<Record<Field, QueryDslMatchBoolPrefixQuery | string>>;
    /** Matches no documents. */
    match_none?: QueryDslMatchNoneQuery;
    /** Analyzes the text and creates a phrase query out of the analyzed text. */
    match_phrase?: Partial<Record<Field, QueryDslMatchPhraseQuery | string>>;
    /** Returns documents that contain the words of a provided text, in the same order as provided.
      * The last term of the provided text is treated as a prefix, matching any words that begin with that term. */
    match_phrase_prefix?: Partial<Record<Field, QueryDslMatchPhrasePrefixQuery | string>>;
    /** Returns documents that are "like" a given set of documents. */
    more_like_this?: QueryDslMoreLikeThisQuery;
    /** Enables you to search for a provided text, number, date or boolean value across multiple fields.
      * The provided text is analyzed before matching. */
    multi_match?: QueryDslMultiMatchQuery;
    /** Wraps another query to search nested fields.
      * If an object matches the search, the nested query returns the root parent document. */
    nested?: QueryDslNestedQuery;
    /** Returns child documents joined to a specific parent document. */
    parent_id?: QueryDslParentIdQuery;
    /** Matches queries stored in an index. */
    percolate?: QueryDslPercolateQuery;
    /** Promotes selected documents to rank higher than those matching a given query. */
    pinned?: QueryDslPinnedQuery;
    /** Returns documents that contain a specific prefix in a provided field. */
    prefix?: Partial<Record<Field, QueryDslPrefixQuery | string>>;
    /** Returns documents based on a provided query string, using a parser with a strict syntax. */
    query_string?: QueryDslQueryStringQuery;
    /** Returns documents that contain terms within a provided range. */
    range?: Partial<Record<Field, QueryDslRangeQuery>>;
    /** Boosts the relevance score of documents based on the numeric value of a `rank_feature` or `rank_features` field. */
    rank_feature?: QueryDslRankFeatureQuery;
    /** Returns documents that contain terms matching a regular expression. */
    regexp?: Partial<Record<Field, QueryDslRegexpQuery | string>>;
    rule?: QueryDslRuleQuery;
    /** Filters documents based on a provided script.
      * The script query is typically used in a filter context. */
    script?: QueryDslScriptQuery;
    /** Uses a script to provide a custom score for returned documents. */
    script_score?: QueryDslScriptScoreQuery;
    /** A semantic query to semantic_text field types */
    semantic?: QueryDslSemanticQuery;
    /** Queries documents that contain fields indexed using the `shape` type. */
    shape?: QueryDslShapeQuery;
    /** Returns documents based on a provided query string, using a parser with a limited but fault-tolerant syntax. */
    simple_query_string?: QueryDslSimpleQueryStringQuery;
    /** Returns matches which enclose another span query. */
    span_containing?: QueryDslSpanContainingQuery;
    /** Wrapper to allow span queries to participate in composite single-field span queries by _lying_ about their search field. */
    span_field_masking?: QueryDslSpanFieldMaskingQuery;
    /** Matches spans near the beginning of a field. */
    span_first?: QueryDslSpanFirstQuery;
    /** Allows you to wrap a multi term query (one of `wildcard`, `fuzzy`, `prefix`, `range`, or `regexp` query) as a `span` query, so it can be nested. */
    span_multi?: QueryDslSpanMultiTermQuery;
    /** Matches spans which are near one another.
      * You can specify `slop`, the maximum number of intervening unmatched positions, as well as whether matches are required to be in-order. */
    span_near?: QueryDslSpanNearQuery;
    /** Removes matches which overlap with another span query or which are within x tokens before (controlled by the parameter `pre`) or y tokens after (controlled by the parameter `post`) another span query. */
    span_not?: QueryDslSpanNotQuery;
    /** Matches the union of its span clauses. */
    span_or?: QueryDslSpanOrQuery;
    /** Matches spans containing a term. */
    span_term?: Partial<Record<Field, QueryDslSpanTermQuery | FieldValue>>;
    /** Returns matches which are enclosed inside another span query. */
    span_within?: QueryDslSpanWithinQuery;
    /** Using input query vectors or a natural language processing model to convert a query into a list of token-weight pairs, queries against a sparse vector field. */
    sparse_vector?: QueryDslSparseVectorQuery;
    /** Returns documents that contain an exact term in a provided field.
      * To return a document, the query term must exactly match the queried field's value, including whitespace and capitalization. */
    term?: Partial<Record<Field, QueryDslTermQuery | FieldValue>>;
    /** Returns documents that contain one or more exact terms in a provided field.
      * To return a document, one or more terms must exactly match a field value, including whitespace and capitalization. */
    terms?: QueryDslTermsQuery;
    /** Returns documents that contain a minimum number of exact terms in a provided field.
      * To return a document, a required number of terms must exactly match the field values, including whitespace and capitalization. */
    terms_set?: Partial<Record<Field, QueryDslTermsSetQuery>>;
    /** Uses a natural language processing model to convert the query text into a list of token-weight pairs which are then used in a query against a sparse vector or rank features field. */
    text_expansion?: Partial<Record<Field, QueryDslTextExpansionQuery>>;
    /** Supports returning text_expansion query results by sending in precomputed tokens with the query. */
    weighted_tokens?: Partial<Record<Field, QueryDslWeightedTokensQuery>>;
    /** Returns documents that contain terms matching a wildcard pattern. */
    wildcard?: Partial<Record<Field, QueryDslWildcardQuery | string>>;
    /** A query that accepts any other query as base64 encoded string. */
    wrapper?: QueryDslWrapperQuery;
    type?: QueryDslTypeQuery;
}
export interface QueryDslQueryStringQuery extends QueryDslQueryBase {
    /** If `true`, the wildcard characters `*` and `?` are allowed as the first character of the query string. */
    allow_leading_wildcard?: boolean;
    /** Analyzer used to convert text in the query string into tokens. */
    analyzer?: string;
    /** If `true`, the query attempts to analyze wildcard terms in the query string. */
    analyze_wildcard?: boolean;
    /** If `true`, match phrase queries are automatically created for multi-term synonyms. */
    auto_generate_synonyms_phrase_query?: boolean;
    /** Default field to search if no field is provided in the query string.
      * Supports wildcards (`*`).
      * Defaults to the `index.query.default_field` index setting, which has a default value of `*`. */
    default_field?: Field;
    /** Default boolean logic used to interpret text in the query string if no operators are specified. */
    default_operator?: QueryDslOperator;
    /** If `true`, enable position increments in queries constructed from a `query_string` search. */
    enable_position_increments?: boolean;
    escape?: boolean;
    /** Array of fields to search. Supports wildcards (`*`). */
    fields?: Field[];
    /** Maximum edit distance allowed for fuzzy matching. */
    fuzziness?: Fuzziness;
    /** Maximum number of terms to which the query expands for fuzzy matching. */
    fuzzy_max_expansions?: integer;
    /** Number of beginning characters left unchanged for fuzzy matching. */
    fuzzy_prefix_length?: integer;
    /** Method used to rewrite the query. */
    fuzzy_rewrite?: MultiTermQueryRewrite;
    /** If `true`, edits for fuzzy matching include transpositions of two adjacent characters (for example, `ab` to `ba`). */
    fuzzy_transpositions?: boolean;
    /** If `true`, format-based errors, such as providing a text value for a numeric field, are ignored. */
    lenient?: boolean;
    /** Maximum number of automaton states required for the query. */
    max_determinized_states?: integer;
    /** Minimum number of clauses that must match for a document to be returned. */
    minimum_should_match?: MinimumShouldMatch;
    /** Maximum number of positions allowed between matching tokens for phrases. */
    phrase_slop?: double;
    /** Query string you wish to parse and use for search. */
    query: string;
    /** Analyzer used to convert quoted text in the query string into tokens.
      * For quoted text, this parameter overrides the analyzer specified in the `analyzer` parameter. */
    quote_analyzer?: string;
    /** Suffix appended to quoted text in the query string.
      * You can use this suffix to use a different analysis method for exact matches. */
    quote_field_suffix?: string;
    /** Method used to rewrite the query. */
    rewrite?: MultiTermQueryRewrite;
    /** How to combine the queries generated from the individual search terms in the resulting `dis_max` query. */
    tie_breaker?: double;
    /** Coordinated Universal Time (UTC) offset or IANA time zone used to convert date values in the query string to UTC. */
    time_zone?: TimeZone;
    /** Determines how the query matches and scores documents. */
    type?: QueryDslTextQueryType;
}
export interface QueryDslRandomScoreFunction {
    field?: Field;
    seed?: long | string;
}
export type QueryDslRangeQuery = QueryDslUntypedRangeQuery | QueryDslDateRangeQuery | QueryDslNumberRangeQuery | QueryDslTermRangeQuery;
export interface QueryDslRangeQueryBase<T = unknown> extends QueryDslQueryBase {
    /** Indicates how the range query matches values for `range` fields. */
    relation?: QueryDslRangeRelation;
    /** Greater than. */
    gt?: T;
    /** Greater than or equal to. */
    gte?: T;
    /** Less than. */
    lt?: T;
    /** Less than or equal to. */
    lte?: T;
}
export type QueryDslRangeRelation = 'within' | 'contains' | 'intersects';
export interface QueryDslRankFeatureFunction {
}
export interface QueryDslRankFeatureFunctionLinear {
}
export interface QueryDslRankFeatureFunctionLogarithm {
    /** Configurable scaling factor. */
    scaling_factor: float;
}
export interface QueryDslRankFeatureFunctionSaturation {
    /** Configurable pivot value so that the result will be less than 0.5. */
    pivot?: float;
}
export interface QueryDslRankFeatureFunctionSigmoid {
    /** Configurable pivot value so that the result will be less than 0.5. */
    pivot: float;
    /** Configurable Exponent. */
    exponent: float;
}
export interface QueryDslRankFeatureQuery extends QueryDslQueryBase {
    /** `rank_feature` or `rank_features` field used to boost relevance scores. */
    field: Field;
    /** Saturation function used to boost relevance scores based on the value of the rank feature `field`. */
    saturation?: QueryDslRankFeatureFunctionSaturation;
    /** Logarithmic function used to boost relevance scores based on the value of the rank feature `field`. */
    log?: QueryDslRankFeatureFunctionLogarithm;
    /** Linear function used to boost relevance scores based on the value of the rank feature `field`. */
    linear?: QueryDslRankFeatureFunctionLinear;
    /** Sigmoid function used to boost relevance scores based on the value of the rank feature `field`. */
    sigmoid?: QueryDslRankFeatureFunctionSigmoid;
}
export interface QueryDslRegexpQuery extends QueryDslQueryBase {
    /** Allows case insensitive matching of the regular expression value with the indexed field values when set to `true`.
      * When `false`, case sensitivity of matching depends on the underlying field’s mapping. */
    case_insensitive?: boolean;
    /** Enables optional operators for the regular expression. */
    flags?: string;
    /** Maximum number of automaton states required for the query. */
    max_determinized_states?: integer;
    /** Method used to rewrite the query. */
    rewrite?: MultiTermQueryRewrite;
    /** Regular expression for terms you wish to find in the provided field. */
    value: string;
}
export interface QueryDslRuleQuery extends QueryDslQueryBase {
    organic: QueryDslQueryContainer;
    ruleset_ids?: Id | Id[];
    ruleset_id?: string;
    match_criteria: any;
}
export interface QueryDslScriptQuery extends QueryDslQueryBase {
    /** Contains a script to run as a query.
      * This script must return a boolean value, `true` or `false`. */
    script: Script | ScriptSource;
}
export interface QueryDslScriptScoreFunction {
    /** A script that computes a score. */
    script: Script | ScriptSource;
}
export interface QueryDslScriptScoreQuery extends QueryDslQueryBase {
    /** Documents with a score lower than this floating point number are excluded from the search results. */
    min_score?: float;
    /** Query used to return documents. */
    query: QueryDslQueryContainer;
    /** Script used to compute the score of documents returned by the query.
      * Important: final relevance scores from the `script_score` query cannot be negative. */
    script: Script | ScriptSource;
}
export interface QueryDslSemanticQuery extends QueryDslQueryBase {
    /** The field to query, which must be a semantic_text field type */
    field: string;
    /** The query text */
    query: string;
}
export interface QueryDslShapeFieldQuery {
    /** Queries using a pre-indexed shape. */
    indexed_shape?: QueryDslFieldLookup;
    /** Spatial relation between the query shape and the document shape. */
    relation?: GeoShapeRelation;
    /** Queries using an inline shape definition in GeoJSON or Well Known Text (WKT) format. */
    shape?: GeoShape;
}
export interface QueryDslShapeQueryKeys extends QueryDslQueryBase {
    /** When set to `true` the query ignores an unmapped field and will not match any documents. */
    ignore_unmapped?: boolean;
}
export type QueryDslShapeQuery = QueryDslShapeQueryKeys & {
    [property: string]: QueryDslShapeFieldQuery | boolean | float | string;
};
export type QueryDslSimpleQueryStringFlag = 'NONE' | 'AND' | 'NOT' | 'OR' | 'PREFIX' | 'PHRASE' | 'PRECEDENCE' | 'ESCAPE' | 'WHITESPACE' | 'FUZZY' | 'NEAR' | 'SLOP' | 'ALL';
export type QueryDslSimpleQueryStringFlags = SpecUtilsPipeSeparatedFlags<QueryDslSimpleQueryStringFlag>;
export interface QueryDslSimpleQueryStringQuery extends QueryDslQueryBase {
    /** Analyzer used to convert text in the query string into tokens. */
    analyzer?: string;
    /** If `true`, the query attempts to analyze wildcard terms in the query string. */
    analyze_wildcard?: boolean;
    /** If `true`, the parser creates a match_phrase query for each multi-position token. */
    auto_generate_synonyms_phrase_query?: boolean;
    /** Default boolean logic used to interpret text in the query string if no operators are specified. */
    default_operator?: QueryDslOperator;
    /** Array of fields you wish to search.
      * Accepts wildcard expressions.
      * You also can boost relevance scores for matches to particular fields using a caret (`^`) notation.
      * Defaults to the `index.query.default_field index` setting, which has a default value of `*`. */
    fields?: Field[];
    /** List of enabled operators for the simple query string syntax. */
    flags?: QueryDslSimpleQueryStringFlags;
    /** Maximum number of terms to which the query expands for fuzzy matching. */
    fuzzy_max_expansions?: integer;
    /** Number of beginning characters left unchanged for fuzzy matching. */
    fuzzy_prefix_length?: integer;
    /** If `true`, edits for fuzzy matching include transpositions of two adjacent characters (for example, `ab` to `ba`). */
    fuzzy_transpositions?: boolean;
    /** If `true`, format-based errors, such as providing a text value for a numeric field, are ignored. */
    lenient?: boolean;
    /** Minimum number of clauses that must match for a document to be returned. */
    minimum_should_match?: MinimumShouldMatch;
    /** Query string in the simple query string syntax you wish to parse and use for search. */
    query: string;
    /** Suffix appended to quoted text in the query string. */
    quote_field_suffix?: string;
}
export interface QueryDslSpanContainingQuery extends QueryDslQueryBase {
    /** Can be any span query.
      * Matching spans from `big` that contain matches from `little` are returned. */
    big: QueryDslSpanQuery;
    /** Can be any span query.
      * Matching spans from `big` that contain matches from `little` are returned. */
    little: QueryDslSpanQuery;
}
export interface QueryDslSpanFieldMaskingQuery extends QueryDslQueryBase {
    field: Field;
    query: QueryDslSpanQuery;
}
export interface QueryDslSpanFirstQuery extends QueryDslQueryBase {
    /** Controls the maximum end position permitted in a match. */
    end: integer;
    /** Can be any other span type query. */
    match: QueryDslSpanQuery;
}
export type QueryDslSpanGapQuery = Partial<Record<Field, integer>>;
export interface QueryDslSpanMultiTermQuery extends QueryDslQueryBase {
    /** Should be a multi term query (one of `wildcard`, `fuzzy`, `prefix`, `range`, or `regexp` query). */
    match: QueryDslQueryContainer;
}
export interface QueryDslSpanNearQuery extends QueryDslQueryBase {
    /** Array of one or more other span type queries. */
    clauses: QueryDslSpanQuery[];
    /** Controls whether matches are required to be in-order. */
    in_order?: boolean;
    /** Controls the maximum number of intervening unmatched positions permitted. */
    slop?: integer;
}
export interface QueryDslSpanNotQuery extends QueryDslQueryBase {
    /** The number of tokens from within the include span that can’t have overlap with the exclude span.
      * Equivalent to setting both `pre` and `post`. */
    dist?: integer;
    /** Span query whose matches must not overlap those returned. */
    exclude: QueryDslSpanQuery;
    /** Span query whose matches are filtered. */
    include: QueryDslSpanQuery;
    /** The number of tokens after the include span that can’t have overlap with the exclude span. */
    post?: integer;
    /** The number of tokens before the include span that can’t have overlap with the exclude span. */
    pre?: integer;
}
export interface QueryDslSpanOrQuery extends QueryDslQueryBase {
    /** Array of one or more other span type queries. */
    clauses: QueryDslSpanQuery[];
}
export interface QueryDslSpanQuery {
    /** Accepts a list of span queries, but only returns those spans which also match a second span query. */
    span_containing?: QueryDslSpanContainingQuery;
    /** Allows queries like `span_near` or `span_or` across different fields. */
    span_field_masking?: QueryDslSpanFieldMaskingQuery;
    /** Accepts another span query whose matches must appear within the first N positions of the field. */
    span_first?: QueryDslSpanFirstQuery;
    span_gap?: QueryDslSpanGapQuery;
    /** Wraps a `term`, `range`, `prefix`, `wildcard`, `regexp`, or `fuzzy` query. */
    span_multi?: QueryDslSpanMultiTermQuery;
    /** Accepts multiple span queries whose matches must be within the specified distance of each other, and possibly in the same order. */
    span_near?: QueryDslSpanNearQuery;
    /** Wraps another span query, and excludes any documents which match that query. */
    span_not?: QueryDslSpanNotQuery;
    /** Combines multiple span queriesandreturns documents which match any of the specified queries. */
    span_or?: QueryDslSpanOrQuery;
    /** The equivalent of the `term` query but for use with other span queries. */
    span_term?: Partial<Record<Field, QueryDslSpanTermQuery | FieldValue>>;
    /** The result from a single span query is returned as long is its span falls within the spans returned by a list of other span queries. */
    span_within?: QueryDslSpanWithinQuery;
}
export interface QueryDslSpanTermQuery extends QueryDslQueryBase {
    value: FieldValue;
    /** @alias value */
    term: FieldValue;
}
export interface QueryDslSpanWithinQuery extends QueryDslQueryBase {
    /** Can be any span query.
      * Matching spans from `little` that are enclosed within `big` are returned. */
    big: QueryDslSpanQuery;
    /** Can be any span query.
      * Matching spans from `little` that are enclosed within `big` are returned. */
    little: QueryDslSpanQuery;
}
export interface QueryDslSparseVectorQuery extends QueryDslQueryBase {
    /** The name of the field that contains the token-weight pairs to be searched against.
      * This field must be a mapped sparse_vector field. */
    field: Field;
    /** Dictionary of precomputed sparse vectors and their associated weights.
      * Only one of inference_id or query_vector may be supplied in a request. */
    query_vector?: Record<string, float>;
    /** The inference ID to use to convert the query text into token-weight pairs.
      * It must be the same inference ID that was used to create the tokens from the input text.
      * Only one of inference_id and query_vector is allowed.
      * If inference_id is specified, query must also be specified.
      * Only one of inference_id or query_vector may be supplied in a request. */
    inference_id?: Id;
    /** The query text you want to use for search.
      * If inference_id is specified, query must also be specified. */
    query?: string;
    /** Whether to perform pruning, omitting the non-significant tokens from the query to improve query performance.
      * If prune is true but the pruning_config is not specified, pruning will occur but default values will be used.
      * Default: false */
    prune?: boolean;
    /** Optional pruning configuration.
      * If enabled, this will omit non-significant tokens from the query in order to improve query performance.
      * This is only used if prune is set to true.
      * If prune is set to true but pruning_config is not specified, default values will be used. */
    pruning_config?: TokenPruningConfig;
}
export interface QueryDslTermQuery extends QueryDslQueryBase {
    /** Term you wish to find in the provided field. */
    value: FieldValue;
    /** Allows ASCII case insensitive matching of the value with the indexed field values when set to `true`.
      * When `false`, the case sensitivity of matching depends on the underlying field’s mapping. */
    case_insensitive?: boolean;
}
export interface QueryDslTermRangeQuery extends QueryDslRangeQueryBase<string> {
}
export interface QueryDslTermsLookup {
    index: IndexName;
    id: Id;
    path: Field;
    routing?: Routing;
}
export interface QueryDslTermsQueryKeys extends QueryDslQueryBase {
}
export type QueryDslTermsQuery = QueryDslTermsQueryKeys & {
    [property: string]: QueryDslTermsQueryField | float | string;
};
export type QueryDslTermsQueryField = FieldValue[] | QueryDslTermsLookup;
export interface QueryDslTermsSetQuery extends QueryDslQueryBase {
    /** Specification describing number of matching terms required to return a document. */
    minimum_should_match?: MinimumShouldMatch;
    /** Numeric field containing the number of matching terms required to return a document. */
    minimum_should_match_field?: Field;
    /** Custom script containing the number of matching terms required to return a document. */
    minimum_should_match_script?: Script | ScriptSource;
    /** Array of terms you wish to find in the provided field. */
    terms: FieldValue[];
}
export interface QueryDslTextExpansionQuery extends QueryDslQueryBase {
    /** The text expansion NLP model to use */
    model_id: string;
    /** The query text */
    model_text: string;
    /** Token pruning configurations
      * @experimental */
    pruning_config?: TokenPruningConfig;
}
export type QueryDslTextQueryType = 'best_fields' | 'most_fields' | 'cross_fields' | 'phrase' | 'phrase_prefix' | 'bool_prefix';
export interface QueryDslTypeQuery extends QueryDslQueryBase {
    value: string;
}
export interface QueryDslUntypedDecayFunctionKeys extends QueryDslDecayFunctionBase<any, any> {
}
export type QueryDslUntypedDecayFunction = QueryDslUntypedDecayFunctionKeys & {
    [property: string]: QueryDslDecayPlacement | QueryDslMultiValueMode;
};
export interface QueryDslUntypedDistanceFeatureQuery extends QueryDslDistanceFeatureQueryBase<any, any> {
}
export interface QueryDslUntypedRangeQuery extends QueryDslRangeQueryBase<any> {
    /** Date format used to convert `date` values in the query. */
    format?: DateFormat;
    /** Coordinated Universal Time (UTC) offset or IANA time zone used to convert `date` values in the query to UTC. */
    time_zone?: TimeZone;
}
export interface QueryDslWeightedTokensQuery extends QueryDslQueryBase {
    /** The tokens representing this query */
    tokens: Record<string, float> | Record<string, float>[];
    /** Token pruning configurations */
    pruning_config?: TokenPruningConfig;
}
export interface QueryDslWildcardQuery extends QueryDslQueryBase {
    /** Allows case insensitive matching of the pattern with the indexed field values when set to true. Default is false which means the case sensitivity of matching depends on the underlying field’s mapping. */
    case_insensitive?: boolean;
    /** Method used to rewrite the query. */
    rewrite?: MultiTermQueryRewrite;
    /** Wildcard pattern for terms you wish to find in the provided field. Required, when wildcard is not set. */
    value?: string;
    /** Wildcard pattern for terms you wish to find in the provided field. Required, when value is not set. */
    wildcard?: string;
}
export interface QueryDslWrapperQuery extends QueryDslQueryBase {
    /** A base64 encoded query.
      * The binary data format can be any of JSON, YAML, CBOR or SMILE encodings */
    query: string;
}
export type QueryDslZeroTermsQuery = 'all' | 'none';
export interface AsyncSearchAsyncSearch<TDocument = unknown, TAggregations = Record<AggregateName, AggregationsAggregate>> {
    /** Partial aggregations results, coming from the shards that have already completed running the query. */
    aggregations?: TAggregations;
    _clusters?: ClusterStatistics;
    fields?: Record<string, any>;
    hits: SearchHitsMetadata<TDocument>;
    max_score?: double;
    /** Indicates how many reductions of the results have been performed.
      * If this number increases compared to the last retrieved results for a get asynch search request, you can expect additional results included in the search response. */
    num_reduce_phases?: long;
    profile?: SearchProfile;
    pit_id?: Id;
    _scroll_id?: ScrollId;
    /** Indicates how many shards have run the query.
      * Note that in order for shard results to be included in the search response, they need to be reduced first. */
    _shards: ShardStatistics;
    suggest?: Record<SuggestionName, SearchSuggest<TDocument>[]>;
    terminated_early?: boolean;
    timed_out: boolean;
    took: long;
}
export interface AsyncSearchAsyncSearchDocumentResponseBase<TDocument = unknown, TAggregations = Record<AggregateName, AggregationsAggregate>> extends AsyncSearchAsyncSearchResponseBase {
    response: AsyncSearchAsyncSearch<TDocument, TAggregations>;
}
export interface AsyncSearchAsyncSearchResponseBase {
    id?: Id;
    /** When the query is no longer running, this property indicates whether the search failed or was successfully completed on all shards.
      * While the query is running, `is_partial` is always set to `true`. */
    is_partial: boolean;
    /** Indicates whether the search is still running or has completed.
      *
      * > info
      * > If the search failed after some shards returned their results or the node that is coordinating the async search dies, results may be partial even though `is_running` is `false`. */
    is_running: boolean;
    /** Indicates when the async search will expire. */
    expiration_time?: DateTime;
    expiration_time_in_millis: EpochTime<UnitMillis>;
    start_time?: DateTime;
    start_time_in_millis: EpochTime<UnitMillis>;
    /** Indicates when the async search completed.
      * It is present only when the search has completed. */
    completion_time?: DateTime;
    completion_time_in_millis?: EpochTime<UnitMillis>;
}
export interface AsyncSearchDeleteRequest extends RequestBase {
    /** A unique identifier for the async search. */
    id: Id;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        id?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        id?: never;
    };
}
export type AsyncSearchDeleteResponse = AcknowledgedResponseBase;
export interface AsyncSearchGetRequest extends RequestBase {
    /** A unique identifier for the async search. */
    id: Id;
    /** The length of time that the async search should be available in the cluster.
      * When not specified, the `keep_alive` set with the corresponding submit async request will be used.
      * Otherwise, it is possible to override the value and extend the validity of the request.
      * When this period expires, the search, if still running, is cancelled.
      * If the search is completed, its saved results are deleted. */
    keep_alive?: Duration;
    /** Specify whether aggregation and suggester names should be prefixed by their respective types in the response */
    typed_keys?: boolean;
    /** Specifies to wait for the search to be completed up until the provided timeout.
      * Final results will be returned if available before the timeout expires, otherwise the currently available results will be returned once the timeout expires.
      * By default no timeout is set meaning that the currently available results will be returned without any additional wait. */
    wait_for_completion_timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        id?: never;
        keep_alive?: never;
        typed_keys?: never;
        wait_for_completion_timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        id?: never;
        keep_alive?: never;
        typed_keys?: never;
        wait_for_completion_timeout?: never;
    };
}
export type AsyncSearchGetResponse<TDocument = unknown, TAggregations = Record<AggregateName, AggregationsAggregate>> = AsyncSearchAsyncSearchDocumentResponseBase<TDocument, TAggregations>;
export interface AsyncSearchStatusRequest extends RequestBase {
    /** A unique identifier for the async search. */
    id: Id;
    /** The length of time that the async search needs to be available.
      * Ongoing async searches and any saved search results are deleted after this period. */
    keep_alive?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        id?: never;
        keep_alive?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        id?: never;
        keep_alive?: never;
    };
}
export type AsyncSearchStatusResponse = AsyncSearchStatusStatusResponseBase;
export interface AsyncSearchStatusStatusResponseBase extends AsyncSearchAsyncSearchResponseBase {
    /** The number of shards that have run the query so far. */
    _shards: ShardStatistics;
    /** Metadata about clusters involved in the cross-cluster search.
      * It is not shown for local-only searches. */
    _clusters?: ClusterStatistics;
    /** If the async search completed, this field shows the status code of the search.
      * For example, `200` indicates that the async search was successfully completed.
      * `503` indicates that the async search was completed with an error. */
    completion_status?: integer;
}
export interface AsyncSearchSubmitRequest extends RequestBase {
    /** A comma-separated list of index names to search; use `_all` or empty string to perform the operation on all indices */
    index?: Indices;
    /** Blocks and waits until the search is completed up to a certain timeout.
      * When the async search completes within the timeout, the response won’t include the ID as the results are not stored in the cluster. */
    wait_for_completion_timeout?: Duration;
    /** Specifies how long the async search needs to be available.
      * Ongoing async searches and any saved search results are deleted after this period. */
    keep_alive?: Duration;
    /** If `true`, results are stored for later retrieval when the search completes within the `wait_for_completion_timeout`. */
    keep_on_completion?: boolean;
    /** Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified) */
    allow_no_indices?: boolean;
    /** Indicate if an error should be returned if there is a partial search failure or timeout */
    allow_partial_search_results?: boolean;
    /** The analyzer to use for the query string */
    analyzer?: string;
    /** Specify whether wildcard and prefix queries should be analyzed (default: false) */
    analyze_wildcard?: boolean;
    /** Affects how often partial results become available, which happens whenever shard results are reduced.
      * A partial reduction is performed every time the coordinating node has received a certain number of new shard responses (5 by default). */
    batched_reduce_size?: long;
    /** The default value is the only supported value. */
    ccs_minimize_roundtrips?: boolean;
    /** The default operator for query string query (AND or OR) */
    default_operator?: QueryDslOperator;
    /** The field to use as default where no field prefix is given in the query string */
    df?: string;
    /** Whether to expand wildcard expression to concrete indices that are open, closed or both. */
    expand_wildcards?: ExpandWildcards;
    /** Whether specified concrete, expanded or aliased indices should be ignored when throttled */
    ignore_throttled?: boolean;
    /** Whether specified concrete indices should be ignored when unavailable (missing or closed) */
    ignore_unavailable?: boolean;
    /** Specify whether format-based query failures (such as providing text to a numeric field) should be ignored */
    lenient?: boolean;
    /** The number of concurrent shard requests per node this search executes concurrently. This value should be used to limit the impact of the search on the cluster in order to limit the number of concurrent shard requests */
    max_concurrent_shard_requests?: integer;
    /** Specify the node or shard the operation should be performed on (default: random) */
    preference?: string;
    /** Specify if request cache should be used for this request or not, defaults to true */
    request_cache?: boolean;
    /** A comma-separated list of specific routing values */
    routing?: Routing;
    /** Search operation type */
    search_type?: SearchType;
    /** Specifies which field to use for suggestions. */
    suggest_field?: Field;
    /** Specify suggest mode */
    suggest_mode?: SuggestMode;
    /** How many suggestions to return in response */
    suggest_size?: long;
    /** The source text for which the suggestions should be returned. */
    suggest_text?: string;
    /** Specify whether aggregation and suggester names should be prefixed by their respective types in the response */
    typed_keys?: boolean;
    /** Indicates whether hits.total should be rendered as an integer or an object in the rest search response */
    rest_total_hits_as_int?: boolean;
    /** A list of fields to exclude from the returned _source field */
    _source_excludes?: Fields;
    /** A list of fields to extract and return from the _source field */
    _source_includes?: Fields;
    /** Query in the Lucene query string syntax */
    q?: string;
    aggregations?: Record<string, AggregationsAggregationContainer>;
    /** @alias aggregations */
    aggs?: Record<string, AggregationsAggregationContainer>;
    collapse?: SearchFieldCollapse;
    /** If true, returns detailed information about score computation as part of a hit. */
    explain?: boolean;
    /** Configuration of search extensions defined by Elasticsearch plugins. */
    ext?: Record<string, any>;
    /** Starting document offset. By default, you cannot page through more than 10,000
      * hits using the from and size parameters. To page through more hits, use the
      * search_after parameter. */
    from?: integer;
    highlight?: SearchHighlight;
    /** Number of hits matching the query to count accurately. If true, the exact
      * number of hits is returned at the cost of some performance. If false, the
      * response does not include the total number of hits matching the query.
      * Defaults to 10,000 hits. */
    track_total_hits?: SearchTrackHits;
    /** Boosts the _score of documents from specified indices. */
    indices_boost?: Partial<Record<IndexName, double>>[];
    /** Array of wildcard (*) patterns. The request returns doc values for field
      * names matching these patterns in the hits.fields property of the response. */
    docvalue_fields?: (QueryDslFieldAndFormat | Field)[];
    /** Defines the approximate kNN search to run. */
    knn?: KnnSearch | KnnSearch[];
    /** Minimum _score for matching documents. Documents with a lower _score are
      * not included in search results and results collected by aggregations. */
    min_score?: double;
    post_filter?: QueryDslQueryContainer;
    profile?: boolean;
    /** Defines the search definition using the Query DSL. */
    query?: QueryDslQueryContainer;
    rescore?: SearchRescore | SearchRescore[];
    /** Retrieve a script evaluation (based on different fields) for each hit. */
    script_fields?: Record<string, ScriptField>;
    search_after?: SortResults;
    /** The number of hits to return. By default, you cannot page through more
      * than 10,000 hits using the from and size parameters. To page through more
      * hits, use the search_after parameter. */
    size?: integer;
    slice?: SlicedScroll;
    sort?: Sort;
    /** Indicates which source fields are returned for matching documents. These
      * fields are returned in the hits._source property of the search response. */
    _source?: SearchSourceConfig;
    /** Array of wildcard (*) patterns. The request returns values for field names
      * matching these patterns in the hits.fields property of the response. */
    fields?: (QueryDslFieldAndFormat | Field)[];
    suggest?: SearchSuggester;
    /** Maximum number of documents to collect for each shard. If a query reaches this
      * limit, Elasticsearch terminates the query early. Elasticsearch collects documents
      * before sorting. Defaults to 0, which does not terminate query execution early. */
    terminate_after?: long;
    /** Specifies the period of time to wait for a response from each shard. If no response
      * is received before the timeout expires, the request fails and returns an error.
      * Defaults to no timeout. */
    timeout?: string;
    /** If true, calculate and return document scores, even if the scores are not used for sorting. */
    track_scores?: boolean;
    /** If true, returns document version as part of a hit. */
    version?: boolean;
    /** If true, returns sequence number and primary term of the last modification
      * of each hit. See Optimistic concurrency control. */
    seq_no_primary_term?: boolean;
    /** List of stored fields to return as part of a hit. If no fields are specified,
      * no stored fields are included in the response. If this field is specified, the _source
      * parameter defaults to false. You can pass _source: true to return both source fields
      * and stored fields in the search response. */
    stored_fields?: Fields;
    /** Limits the search to a point in time (PIT). If you provide a PIT, you
      * cannot specify an <index> in the request path. */
    pit?: SearchPointInTimeReference;
    /** Defines one or more runtime fields in the search request. These fields take
      * precedence over mapped fields with the same name. */
    runtime_mappings?: MappingRuntimeFields;
    /** Stats groups to associate with the search. Each group maintains a statistics
      * aggregation for its associated searches. You can retrieve these stats using
      * the indices stats API. */
    stats?: string[];
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
        wait_for_completion_timeout?: never;
        keep_alive?: never;
        keep_on_completion?: never;
        allow_no_indices?: never;
        allow_partial_search_results?: never;
        analyzer?: never;
        analyze_wildcard?: never;
        batched_reduce_size?: never;
        ccs_minimize_roundtrips?: never;
        default_operator?: never;
        df?: never;
        expand_wildcards?: never;
        ignore_throttled?: never;
        ignore_unavailable?: never;
        lenient?: never;
        max_concurrent_shard_requests?: never;
        preference?: never;
        request_cache?: never;
        routing?: never;
        search_type?: never;
        suggest_field?: never;
        suggest_mode?: never;
        suggest_size?: never;
        suggest_text?: never;
        typed_keys?: never;
        rest_total_hits_as_int?: never;
        _source_excludes?: never;
        _source_includes?: never;
        q?: never;
        aggregations?: never;
        aggs?: never;
        collapse?: never;
        explain?: never;
        ext?: never;
        from?: never;
        highlight?: never;
        track_total_hits?: never;
        indices_boost?: never;
        docvalue_fields?: never;
        knn?: never;
        min_score?: never;
        post_filter?: never;
        profile?: never;
        query?: never;
        rescore?: never;
        script_fields?: never;
        search_after?: never;
        size?: never;
        slice?: never;
        sort?: never;
        _source?: never;
        fields?: never;
        suggest?: never;
        terminate_after?: never;
        timeout?: never;
        track_scores?: never;
        version?: never;
        seq_no_primary_term?: never;
        stored_fields?: never;
        pit?: never;
        runtime_mappings?: never;
        stats?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
        wait_for_completion_timeout?: never;
        keep_alive?: never;
        keep_on_completion?: never;
        allow_no_indices?: never;
        allow_partial_search_results?: never;
        analyzer?: never;
        analyze_wildcard?: never;
        batched_reduce_size?: never;
        ccs_minimize_roundtrips?: never;
        default_operator?: never;
        df?: never;
        expand_wildcards?: never;
        ignore_throttled?: never;
        ignore_unavailable?: never;
        lenient?: never;
        max_concurrent_shard_requests?: never;
        preference?: never;
        request_cache?: never;
        routing?: never;
        search_type?: never;
        suggest_field?: never;
        suggest_mode?: never;
        suggest_size?: never;
        suggest_text?: never;
        typed_keys?: never;
        rest_total_hits_as_int?: never;
        _source_excludes?: never;
        _source_includes?: never;
        q?: never;
        aggregations?: never;
        aggs?: never;
        collapse?: never;
        explain?: never;
        ext?: never;
        from?: never;
        highlight?: never;
        track_total_hits?: never;
        indices_boost?: never;
        docvalue_fields?: never;
        knn?: never;
        min_score?: never;
        post_filter?: never;
        profile?: never;
        query?: never;
        rescore?: never;
        script_fields?: never;
        search_after?: never;
        size?: never;
        slice?: never;
        sort?: never;
        _source?: never;
        fields?: never;
        suggest?: never;
        terminate_after?: never;
        timeout?: never;
        track_scores?: never;
        version?: never;
        seq_no_primary_term?: never;
        stored_fields?: never;
        pit?: never;
        runtime_mappings?: never;
        stats?: never;
    };
}
export type AsyncSearchSubmitResponse<TDocument = unknown, TAggregations = Record<AggregateName, AggregationsAggregate>> = AsyncSearchAsyncSearchDocumentResponseBase<TDocument, TAggregations>;
export interface AutoscalingAutoscalingPolicy {
    roles: string[];
    /** Decider settings. */
    deciders: Record<string, any>;
}
export interface AutoscalingDeleteAutoscalingPolicyRequest extends RequestBase {
    /** the name of the autoscaling policy */
    name: Name;
    /** Period to wait for a connection to the master node.
      * If no response is received before the timeout expires, the request fails and returns an error. */
    master_timeout?: Duration;
    /** Period to wait for a response. If no response is received before the timeout expires, the request fails and returns an error. */
    timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        name?: never;
        master_timeout?: never;
        timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        name?: never;
        master_timeout?: never;
        timeout?: never;
    };
}
export type AutoscalingDeleteAutoscalingPolicyResponse = AcknowledgedResponseBase;
export interface AutoscalingGetAutoscalingCapacityAutoscalingCapacity {
    node: AutoscalingGetAutoscalingCapacityAutoscalingResources;
    total: AutoscalingGetAutoscalingCapacityAutoscalingResources;
}
export interface AutoscalingGetAutoscalingCapacityAutoscalingDecider {
    required_capacity: AutoscalingGetAutoscalingCapacityAutoscalingCapacity;
    reason_summary?: string;
    reason_details?: any;
}
export interface AutoscalingGetAutoscalingCapacityAutoscalingDeciders {
    required_capacity: AutoscalingGetAutoscalingCapacityAutoscalingCapacity;
    current_capacity: AutoscalingGetAutoscalingCapacityAutoscalingCapacity;
    current_nodes: AutoscalingGetAutoscalingCapacityAutoscalingNode[];
    deciders: Record<string, AutoscalingGetAutoscalingCapacityAutoscalingDecider>;
}
export interface AutoscalingGetAutoscalingCapacityAutoscalingNode {
    name: NodeName;
}
export interface AutoscalingGetAutoscalingCapacityAutoscalingResources {
    storage: integer;
    memory: integer;
}
export interface AutoscalingGetAutoscalingCapacityRequest extends RequestBase {
    /** Period to wait for a connection to the master node.
      * If no response is received before the timeout expires, the request fails and returns an error. */
    master_timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        master_timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        master_timeout?: never;
    };
}
export interface AutoscalingGetAutoscalingCapacityResponse {
    policies: Record<string, AutoscalingGetAutoscalingCapacityAutoscalingDeciders>;
}
export interface AutoscalingGetAutoscalingPolicyRequest extends RequestBase {
    /** the name of the autoscaling policy */
    name: Name;
    /** Period to wait for a connection to the master node.
      * If no response is received before the timeout expires, the request fails and returns an error. */
    master_timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        name?: never;
        master_timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        name?: never;
        master_timeout?: never;
    };
}
export type AutoscalingGetAutoscalingPolicyResponse = AutoscalingAutoscalingPolicy;
export interface AutoscalingPutAutoscalingPolicyRequest extends RequestBase {
    /** the name of the autoscaling policy */
    name: Name;
    /** Period to wait for a connection to the master node.
      * If no response is received before the timeout expires, the request fails and returns an error. */
    master_timeout?: Duration;
    /** Period to wait for a response. If no response is received before the timeout expires, the request fails and returns an error. */
    timeout?: Duration;
    policy?: AutoscalingAutoscalingPolicy;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        name?: never;
        master_timeout?: never;
        timeout?: never;
        policy?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        name?: never;
        master_timeout?: never;
        timeout?: never;
        policy?: never;
    };
}
export type AutoscalingPutAutoscalingPolicyResponse = AcknowledgedResponseBase;
export type CatCatAnomalyDetectorColumn = 'assignment_explanation' | 'ae' | 'buckets.count' | 'bc' | 'bucketsCount' | 'buckets.time.exp_avg' | 'btea' | 'bucketsTimeExpAvg' | 'buckets.time.exp_avg_hour' | 'bteah' | 'bucketsTimeExpAvgHour' | 'buckets.time.max' | 'btmax' | 'bucketsTimeMax' | 'buckets.time.min' | 'btmin' | 'bucketsTimeMin' | 'buckets.time.total' | 'btt' | 'bucketsTimeTotal' | 'data.buckets' | 'db' | 'dataBuckets' | 'data.earliest_record' | 'der' | 'dataEarliestRecord' | 'data.empty_buckets' | 'deb' | 'dataEmptyBuckets' | 'data.input_bytes' | 'dib' | 'dataInputBytes' | 'data.input_fields' | 'dif' | 'dataInputFields' | 'data.input_records' | 'dir' | 'dataInputRecords' | 'data.invalid_dates' | 'did' | 'dataInvalidDates' | 'data.last' | 'dl' | 'dataLast' | 'data.last_empty_bucket' | 'dleb' | 'dataLastEmptyBucket' | 'data.last_sparse_bucket' | 'dlsb' | 'dataLastSparseBucket' | 'data.latest_record' | 'dlr' | 'dataLatestRecord' | 'data.missing_fields' | 'dmf' | 'dataMissingFields' | 'data.out_of_order_timestamps' | 'doot' | 'dataOutOfOrderTimestamps' | 'data.processed_fields' | 'dpf' | 'dataProcessedFields' | 'data.processed_records' | 'dpr' | 'dataProcessedRecords' | 'data.sparse_buckets' | 'dsb' | 'dataSparseBuckets' | 'forecasts.memory.avg' | 'fmavg' | 'forecastsMemoryAvg' | 'forecasts.memory.max' | 'fmmax' | 'forecastsMemoryMax' | 'forecasts.memory.min' | 'fmmin' | 'forecastsMemoryMin' | 'forecasts.memory.total' | 'fmt' | 'forecastsMemoryTotal' | 'forecasts.records.avg' | 'fravg' | 'forecastsRecordsAvg' | 'forecasts.records.max' | 'frmax' | 'forecastsRecordsMax' | 'forecasts.records.min' | 'frmin' | 'forecastsRecordsMin' | 'forecasts.records.total' | 'frt' | 'forecastsRecordsTotal' | 'forecasts.time.avg' | 'ftavg' | 'forecastsTimeAvg' | 'forecasts.time.max' | 'ftmax' | 'forecastsTimeMax' | 'forecasts.time.min' | 'ftmin' | 'forecastsTimeMin' | 'forecasts.time.total' | 'ftt' | 'forecastsTimeTotal' | 'forecasts.total' | 'ft' | 'forecastsTotal' | 'id' | 'model.bucket_allocation_failures' | 'mbaf' | 'modelBucketAllocationFailures' | 'model.by_fields' | 'mbf' | 'modelByFields' | 'model.bytes' | 'mb' | 'modelBytes' | 'model.bytes_exceeded' | 'mbe' | 'modelBytesExceeded' | 'model.categorization_status' | 'mcs' | 'modelCategorizationStatus' | 'model.categorized_doc_count' | 'mcdc' | 'modelCategorizedDocCount' | 'model.dead_category_count' | 'mdcc' | 'modelDeadCategoryCount' | 'model.failed_category_count' | 'mdcc' | 'modelFailedCategoryCount' | 'model.frequent_category_count' | 'mfcc' | 'modelFrequentCategoryCount' | 'model.log_time' | 'mlt' | 'modelLogTime' | 'model.memory_limit' | 'mml' | 'modelMemoryLimit' | 'model.memory_status' | 'mms' | 'modelMemoryStatus' | 'model.over_fields' | 'mof' | 'modelOverFields' | 'model.partition_fields' | 'mpf' | 'modelPartitionFields' | 'model.rare_category_count' | 'mrcc' | 'modelRareCategoryCount' | 'model.timestamp' | 'mt' | 'modelTimestamp' | 'model.total_category_count' | 'mtcc' | 'modelTotalCategoryCount' | 'node.address' | 'na' | 'nodeAddress' | 'node.ephemeral_id' | 'ne' | 'nodeEphemeralId' | 'node.id' | 'ni' | 'nodeId' | 'node.name' | 'nn' | 'nodeName' | 'opened_time' | 'ot' | 'state' | 's';
export type CatCatAnonalyDetectorColumns = CatCatAnomalyDetectorColumn | CatCatAnomalyDetectorColumn[];
export type CatCatDatafeedColumn = 'ae' | 'assignment_explanation' | 'bc' | 'buckets.count' | 'bucketsCount' | 'id' | 'na' | 'node.address' | 'nodeAddress' | 'ne' | 'node.ephemeral_id' | 'nodeEphemeralId' | 'ni' | 'node.id' | 'nodeId' | 'nn' | 'node.name' | 'nodeName' | 'sba' | 'search.bucket_avg' | 'searchBucketAvg' | 'sc' | 'search.count' | 'searchCount' | 'seah' | 'search.exp_avg_hour' | 'searchExpAvgHour' | 'st' | 'search.time' | 'searchTime' | 's' | 'state';
export type CatCatDatafeedColumns = CatCatDatafeedColumn | CatCatDatafeedColumn[];
export type CatCatDfaColumn = 'assignment_explanation' | 'ae' | 'create_time' | 'ct' | 'createTime' | 'description' | 'd' | 'dest_index' | 'di' | 'destIndex' | 'failure_reason' | 'fr' | 'failureReason' | 'id' | 'model_memory_limit' | 'mml' | 'modelMemoryLimit' | 'node.address' | 'na' | 'nodeAddress' | 'node.ephemeral_id' | 'ne' | 'nodeEphemeralId' | 'node.id' | 'ni' | 'nodeId' | 'node.name' | 'nn' | 'nodeName' | 'progress' | 'p' | 'source_index' | 'si' | 'sourceIndex' | 'state' | 's' | 'type' | 't' | 'version' | 'v';
export type CatCatDfaColumns = CatCatDfaColumn | CatCatDfaColumn[];
export type CatCatNodeColumn = 'build' | 'b' | 'completion.size' | 'cs' | 'completionSize' | 'cpu' | 'disk.avail' | 'd' | 'disk' | 'diskAvail' | 'disk.total' | 'dt' | 'diskTotal' | 'disk.used' | 'du' | 'diskUsed' | 'disk.used_percent' | 'dup' | 'diskUsedPercent' | 'fielddata.evictions' | 'fe' | 'fielddataEvictions' | 'fielddata.memory_size' | 'fm' | 'fielddataMemory' | 'file_desc.current' | 'fdc' | 'fileDescriptorCurrent' | 'file_desc.max' | 'fdm' | 'fileDescriptorMax' | 'file_desc.percent' | 'fdp' | 'fileDescriptorPercent' | 'flush.total' | 'ft' | 'flushTotal' | 'flush.total_time' | 'ftt' | 'flushTotalTime' | 'get.current' | 'gc' | 'getCurrent' | 'get.exists_time' | 'geti' | 'getExistsTime' | 'get.exists_total' | 'geto' | 'getExistsTotal' | 'get.missing_time' | 'gmti' | 'getMissingTime' | 'get.missing_total' | 'gmto' | 'getMissingTotal' | 'get.time' | 'gti' | 'getTime' | 'get.total' | 'gto' | 'getTotal' | 'heap.current' | 'hc' | 'heapCurrent' | 'heap.max' | 'hm' | 'heapMax' | 'heap.percent' | 'hp' | 'heapPercent' | 'http_address' | 'http' | 'id' | 'nodeId' | 'indexing.delete_current' | 'idc' | 'indexingDeleteCurrent' | 'indexing.delete_time' | 'idti' | 'indexingDeleteTime' | 'indexing.delete_total' | 'idto' | 'indexingDeleteTotal' | 'indexing.index_current' | 'iic' | 'indexingIndexCurrent' | 'indexing.index_failed' | 'iif' | 'indexingIndexFailed' | 'indexing.index_failed_due_to_version_conflict' | 'iifvc' | 'indexingIndexFailedDueToVersionConflict' | 'indexing.index_time' | 'iiti' | 'indexingIndexTime' | 'indexing.index_total' | 'iito' | 'indexingIndexTotal' | 'ip' | 'i' | 'jdk' | 'j' | 'load_1m' | 'l' | 'load_5m' | 'l' | 'load_15m' | 'l' | 'mappings.total_count' | 'mtc' | 'mappingsTotalCount' | 'mappings.total_estimated_overhead_in_bytes' | 'mteo' | 'mappingsTotalEstimatedOverheadInBytes' | 'master' | 'm' | 'merges.current' | 'mc' | 'mergesCurrent' | 'merges.current_docs' | 'mcd' | 'mergesCurrentDocs' | 'merges.current_size' | 'mcs' | 'mergesCurrentSize' | 'merges.total' | 'mt' | 'mergesTotal' | 'merges.total_docs' | 'mtd' | 'mergesTotalDocs' | 'merges.total_size' | 'mts' | 'mergesTotalSize' | 'merges.total_time' | 'mtt' | 'mergesTotalTime' | 'name' | 'n' | 'node.role' | 'r' | 'role' | 'nodeRole' | 'pid' | 'p' | 'port' | 'po' | 'query_cache.memory_size' | 'qcm' | 'queryCacheMemory' | 'query_cache.evictions' | 'qce' | 'queryCacheEvictions' | 'query_cache.hit_count' | 'qchc' | 'queryCacheHitCount' | 'query_cache.miss_count' | 'qcmc' | 'queryCacheMissCount' | 'ram.current' | 'rc' | 'ramCurrent' | 'ram.max' | 'rm' | 'ramMax' | 'ram.percent' | 'rp' | 'ramPercent' | 'refresh.total' | 'rto' | 'refreshTotal' | 'refresh.time' | 'rti' | 'refreshTime' | 'request_cache.memory_size' | 'rcm' | 'requestCacheMemory' | 'request_cache.evictions' | 'rce' | 'requestCacheEvictions' | 'request_cache.hit_count' | 'rchc' | 'requestCacheHitCount' | 'request_cache.miss_count' | 'rcmc' | 'requestCacheMissCount' | 'script.compilations' | 'scrcc' | 'scriptCompilations' | 'script.cache_evictions' | 'scrce' | 'scriptCacheEvictions' | 'search.fetch_current' | 'sfc' | 'searchFetchCurrent' | 'search.fetch_time' | 'sfti' | 'searchFetchTime' | 'search.fetch_total' | 'sfto' | 'searchFetchTotal' | 'search.open_contexts' | 'so' | 'searchOpenContexts' | 'search.query_current' | 'sqc' | 'searchQueryCurrent' | 'search.query_time' | 'sqti' | 'searchQueryTime' | 'search.query_total' | 'sqto' | 'searchQueryTotal' | 'search.scroll_current' | 'scc' | 'searchScrollCurrent' | 'search.scroll_time' | 'scti' | 'searchScrollTime' | 'search.scroll_total' | 'scto' | 'searchScrollTotal' | 'segments.count' | 'sc' | 'segmentsCount' | 'segments.fixed_bitset_memory' | 'sfbm' | 'fixedBitsetMemory' | 'segments.index_writer_memory' | 'siwm' | 'segmentsIndexWriterMemory' | 'segments.memory' | 'sm' | 'segmentsMemory' | 'segments.version_map_memory' | 'svmm' | 'segmentsVersionMapMemory' | 'shard_stats.total_count' | 'sstc' | 'shards' | 'shardStatsTotalCount' | 'suggest.current' | 'suc' | 'suggestCurrent' | 'suggest.time' | 'suti' | 'suggestTime' | 'suggest.total' | 'suto' | 'suggestTotal' | 'uptime' | 'u' | 'version' | 'v' | string;
export type CatCatNodeColumns = CatCatNodeColumn | CatCatNodeColumn[];
export type CatCatRecoveryColumn = 'index' | 'i' | 'idx' | 'shard' | 's' | 'sh' | 'time' | 't' | 'ti' | 'primaryOrReplica' | 'type' | 'stage' | 'st' | 'source_host' | 'shost' | 'source_node' | 'snode' | 'target_host' | 'thost' | 'target_node' | 'tnode' | 'repository' | 'tnode' | 'snapshot' | 'snap' | 'files' | 'f' | 'files_recovered' | 'fr' | 'files_percent' | 'fp' | 'files_total' | 'tf' | 'bytes' | 'b' | 'bytes_recovered' | 'br' | 'bytes_percent' | 'bp' | 'bytes_total' | 'tb' | 'translog_ops' | 'to' | 'translog_ops_recovered' | 'tor' | 'translog_ops_percent' | 'top' | 'start_time' | 'start' | 'start_time_millis' | 'start_millis' | 'stop_time' | 'stop' | 'stop_time_millis' | 'stop_millis' | string;
export type CatCatRecoveryColumns = CatCatRecoveryColumn | CatCatRecoveryColumn[];
export interface CatCatRequestBase extends RequestBase, SpecUtilsCommonCatQueryParameters {
}
export type CatCatSegmentsColumn = 'index' | 'i' | 'idx' | 'shard' | 's' | 'sh' | 'prirep' | 'p' | 'pr' | 'primaryOrReplica' | 'ip' | 'segment' | 'generation' | 'docs.count' | 'docs.deleted' | 'size' | 'size.memory' | 'committed' | 'searchable' | 'version' | 'compound' | 'id' | string;
export type CatCatSegmentsColumns = CatCatSegmentsColumn | CatCatSegmentsColumn[];
export type CatCatShardColumn = 'completion.size' | 'cs' | 'completionSize' | 'dataset.size' | 'dense_vector.value_count' | 'dvc' | 'denseVectorCount' | 'docs' | 'd' | 'dc' | 'fielddata.evictions' | 'fe' | 'fielddataEvictions' | 'fielddata.memory_size' | 'fm' | 'fielddataMemory' | 'flush.total' | 'ft' | 'flushTotal' | 'flush.total_time' | 'ftt' | 'flushTotalTime' | 'get.current' | 'gc' | 'getCurrent' | 'get.exists_time' | 'geti' | 'getExistsTime' | 'get.exists_total' | 'geto' | 'getExistsTotal' | 'get.missing_time' | 'gmti' | 'getMissingTime' | 'get.missing_total' | 'gmto' | 'getMissingTotal' | 'get.time' | 'gti' | 'getTime' | 'get.total' | 'gto' | 'getTotal' | 'id' | 'index' | 'i' | 'idx' | 'indexing.delete_current' | 'idc' | 'indexingDeleteCurrent' | 'indexing.delete_time' | 'idti' | 'indexingDeleteTime' | 'indexing.delete_total' | 'idto' | 'indexingDeleteTotal' | 'indexing.index_current' | 'iic' | 'indexingIndexCurrent' | 'indexing.index_failed_due_to_version_conflict' | 'iifvc' | 'indexingIndexFailedDueToVersionConflict' | 'indexing.index_failed' | 'iif' | 'indexingIndexFailed' | 'indexing.index_time' | 'iiti' | 'indexingIndexTime' | 'indexing.index_total' | 'iito' | 'indexingIndexTotal' | 'ip' | 'merges.current' | 'mc' | 'mergesCurrent' | 'merges.current_docs' | 'mcd' | 'mergesCurrentDocs' | 'merges.current_size' | 'mcs' | 'mergesCurrentSize' | 'merges.total' | 'mt' | 'mergesTotal' | 'merges.total_docs' | 'mtd' | 'mergesTotalDocs' | 'merges.total_size' | 'mts' | 'mergesTotalSize' | 'merges.total_time' | 'mtt' | 'mergesTotalTime' | 'node' | 'n' | 'prirep' | 'p' | 'pr' | 'primaryOrReplica' | 'query_cache.evictions' | 'qce' | 'queryCacheEvictions' | 'query_cache.memory_size' | 'qcm' | 'queryCacheMemory' | 'recoverysource.type' | 'rs' | 'refresh.time' | 'rti' | 'refreshTime' | 'refresh.total' | 'rto' | 'refreshTotal' | 'search.fetch_current' | 'sfc' | 'searchFetchCurrent' | 'search.fetch_time' | 'sfti' | 'searchFetchTime' | 'search.fetch_total' | 'sfto' | 'searchFetchTotal' | 'search.open_contexts' | 'so' | 'searchOpenContexts' | 'search.query_current' | 'sqc' | 'searchQueryCurrent' | 'search.query_time' | 'sqti' | 'searchQueryTime' | 'search.query_total' | 'sqto' | 'searchQueryTotal' | 'search.scroll_current' | 'scc' | 'searchScrollCurrent' | 'search.scroll_time' | 'scti' | 'searchScrollTime' | 'search.scroll_total' | 'scto' | 'searchScrollTotal' | 'segments.count' | 'sc' | 'segmentsCount' | 'segments.fixed_bitset_memory' | 'sfbm' | 'fixedBitsetMemory' | 'segments.index_writer_memory' | 'siwm' | 'segmentsIndexWriterMemory' | 'segments.memory' | 'sm' | 'segmentsMemory' | 'segments.version_map_memory' | 'svmm' | 'segmentsVersionMapMemory' | 'seq_no.global_checkpoint' | 'sqg' | 'globalCheckpoint' | 'seq_no.local_checkpoint' | 'sql' | 'localCheckpoint' | 'seq_no.max' | 'sqm' | 'maxSeqNo' | 'shard' | 's' | 'sh' | 'dsparse_vector.value_count' | 'svc' | 'sparseVectorCount' | 'state' | 'st' | 'store' | 'sto' | 'suggest.current' | 'suc' | 'suggestCurrent' | 'suggest.time' | 'suti' | 'suggestTime' | 'suggest.total' | 'suto' | 'suggestTotal' | 'sync_id' | 'unassigned.at' | 'ua' | 'unassigned.details' | 'ud' | 'unassigned.for' | 'uf' | 'unassigned.reason' | 'ur' | string;
export type CatCatShardColumns = CatCatShardColumn | CatCatShardColumn[];
export type CatCatSnapshotsColumn = 'id' | 'snapshot' | 'repository' | 're' | 'repo' | 'status' | 's' | 'start_epoch' | 'ste' | 'startEpoch' | 'start_time' | 'sti' | 'startTime' | 'end_epoch' | 'ete' | 'endEpoch' | 'end_time' | 'eti' | 'endTime' | 'duration' | 'dur' | 'indices' | 'i' | 'successful_shards' | 'ss' | 'failed_shards' | 'fs' | 'total_shards' | 'ts' | 'reason' | 'r' | string;
export type CatCatSnapshotsColumns = CatCatSnapshotsColumn | CatCatSnapshotsColumn[];
export type CatCatThreadPoolColumn = 'active' | 'a' | 'completed' | 'c' | 'core' | 'cr' | 'ephemeral_id' | 'eid' | 'host' | 'h' | 'ip' | 'i' | 'keep_alive' | 'k' | 'largest' | 'l' | 'max' | 'mx' | 'name' | 'node_id' | 'id' | 'node_name' | 'pid' | 'p' | 'pool_size' | 'psz' | 'port' | 'po' | 'queue' | 'q' | 'queue_size' | 'qs' | 'rejected' | 'r' | 'size' | 'sz' | 'type' | 't' | string;
export type CatCatThreadPoolColumns = CatCatThreadPoolColumn | CatCatThreadPoolColumn[];
export type CatCatTrainedModelsColumn = 'create_time' | 'ct' | 'created_by' | 'c' | 'createdBy' | 'data_frame_analytics_id' | 'df' | 'dataFrameAnalytics' | 'dfid' | 'description' | 'd' | 'heap_size' | 'hs' | 'modelHeapSize' | 'id' | 'ingest.count' | 'ic' | 'ingestCount' | 'ingest.current' | 'icurr' | 'ingestCurrent' | 'ingest.failed' | 'if' | 'ingestFailed' | 'ingest.pipelines' | 'ip' | 'ingestPipelines' | 'ingest.time' | 'it' | 'ingestTime' | 'license' | 'l' | 'operations' | 'o' | 'modelOperations' | 'version' | 'v';
export type CatCatTrainedModelsColumns = CatCatTrainedModelsColumn | CatCatTrainedModelsColumn[];
export type CatCatTransformColumn = 'changes_last_detection_time' | 'cldt' | 'checkpoint' | 'cp' | 'checkpoint_duration_time_exp_avg' | 'cdtea' | 'checkpointTimeExpAvg' | 'checkpoint_progress' | 'c' | 'checkpointProgress' | 'create_time' | 'ct' | 'createTime' | 'delete_time' | 'dtime' | 'description' | 'd' | 'dest_index' | 'di' | 'destIndex' | 'documents_deleted' | 'docd' | 'documents_indexed' | 'doci' | 'docs_per_second' | 'dps' | 'documents_processed' | 'docp' | 'frequency' | 'f' | 'id' | 'index_failure' | 'if' | 'index_time' | 'itime' | 'index_total' | 'it' | 'indexed_documents_exp_avg' | 'idea' | 'last_search_time' | 'lst' | 'lastSearchTime' | 'max_page_search_size' | 'mpsz' | 'pages_processed' | 'pp' | 'pipeline' | 'p' | 'processed_documents_exp_avg' | 'pdea' | 'processing_time' | 'pt' | 'reason' | 'r' | 'search_failure' | 'sf' | 'search_time' | 'stime' | 'search_total' | 'st' | 'source_index' | 'si' | 'sourceIndex' | 'state' | 's' | 'transform_type' | 'tt' | 'trigger_count' | 'tc' | 'version' | 'v';
export type CatCatTransformColumns = CatCatTransformColumn | CatCatTransformColumn[];
export interface CatAliasesAliasesRecord {
    /** alias name */
    alias?: string;
    /** alias name
      * @alias alias */
    a?: string;
    /** index alias points to */
    index?: IndexName;
    /** index alias points to
      * @alias index */
    i?: IndexName;
    /** index alias points to
      * @alias index */
    idx?: IndexName;
    /** filter */
    filter?: string;
    /** filter
      * @alias filter */
    f?: string;
    /** filter
      * @alias filter */
    fi?: string;
    /** index routing */
    'routing.index'?: string;
    /** index routing
      * @alias 'routing.index' */
    ri?: string;
    /** index routing
      * @alias 'routing.index' */
    routingIndex?: string;
    /** search routing */
    'routing.search'?: string;
    /** search routing
      * @alias 'routing.search' */
    rs?: string;
    /** search routing
      * @alias 'routing.search' */
    routingSearch?: string;
    /** write index */
    is_write_index?: string;
    /** write index
      * @alias is_write_index */
    w?: string;
    /** write index
      * @alias is_write_index */
    isWriteIndex?: string;
}
export interface CatAliasesRequest extends CatCatRequestBase {
    /** A comma-separated list of aliases to retrieve. Supports wildcards (`*`).  To retrieve all aliases, omit this parameter or use `*` or `_all`. */
    name?: Names;
    /** List of columns to appear in the response. Supports simple wildcards. */
    h?: Names;
    /** List of columns that determine how the table should be sorted.
      * Sorting defaults to ascending and can be changed by setting `:asc`
      * or `:desc` as a suffix to the column name. */
    s?: Names;
    /** The type of index that wildcard patterns can match.
      * If the request can target data streams, this argument determines whether wildcard expressions match hidden data streams.
      * It supports comma-separated values, such as `open,hidden`. */
    expand_wildcards?: ExpandWildcards;
    /** The period to wait for a connection to the master node.
      * If the master node is not available before the timeout expires, the request fails and returns an error.
      * To indicated that the request should never timeout, you can set it to `-1`. */
    master_timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        name?: never;
        h?: never;
        s?: never;
        expand_wildcards?: never;
        master_timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        name?: never;
        h?: never;
        s?: never;
        expand_wildcards?: never;
        master_timeout?: never;
    };
}
export type CatAliasesResponse = CatAliasesAliasesRecord[];
export interface CatAllocationAllocationRecord {
    /** Number of primary and replica shards assigned to the node. */
    shards?: string;
    /** Number of primary and replica shards assigned to the node.
      * @alias shards */
    s?: string;
    /** Amount of shards that are scheduled to be moved elsewhere in the cluster or -1 other than desired balance allocator is used */
    'shards.undesired'?: string | null;
    /** Sum of index write load forecasts */
    'write_load.forecast'?: SpecUtilsStringified<double> | null;
    /** Sum of index write load forecasts
      * @alias 'write_load.forecast' */
    wlf?: SpecUtilsStringified<double> | null;
    /** Sum of index write load forecasts
      * @alias 'write_load.forecast' */
    writeLoadForecast?: SpecUtilsStringified<double> | null;
    /** Sum of shard size forecasts */
    'disk.indices.forecast'?: ByteSize | null;
    /** Sum of shard size forecasts
      * @alias 'disk.indices.forecast' */
    dif?: ByteSize | null;
    /** Sum of shard size forecasts
      * @alias 'disk.indices.forecast' */
    diskIndicesForecast?: ByteSize | null;
    /** Disk space used by the node’s shards. Does not include disk space for the translog or unassigned shards.
      * IMPORTANT: This metric double-counts disk space for hard-linked files, such as those created when shrinking, splitting, or cloning an index. */
    'disk.indices'?: ByteSize | null;
    /** Disk space used by the node’s shards. Does not include disk space for the translog or unassigned shards.
      * IMPORTANT: This metric double-counts disk space for hard-linked files, such as those created when shrinking, splitting, or cloning an index.
      * @alias 'disk.indices' */
    di?: ByteSize | null;
    /** Disk space used by the node’s shards. Does not include disk space for the translog or unassigned shards.
      * IMPORTANT: This metric double-counts disk space for hard-linked files, such as those created when shrinking, splitting, or cloning an index.
      * @alias 'disk.indices' */
    diskIndices?: ByteSize | null;
    /** Total disk space in use.
      * Elasticsearch retrieves this metric from the node’s operating system (OS).
      * The metric includes disk space for: Elasticsearch, including the translog and unassigned shards; the node’s operating system; any other applications or files on the node.
      * Unlike `disk.indices`, this metric does not double-count disk space for hard-linked files. */
    'disk.used'?: ByteSize | null;
    /** Total disk space in use.
      * Elasticsearch retrieves this metric from the node’s operating system (OS).
      * The metric includes disk space for: Elasticsearch, including the translog and unassigned shards; the node’s operating system; any other applications or files on the node.
      * Unlike `disk.indices`, this metric does not double-count disk space for hard-linked files.
      * @alias 'disk.used' */
    du?: ByteSize | null;
    /** Total disk space in use.
      * Elasticsearch retrieves this metric from the node’s operating system (OS).
      * The metric includes disk space for: Elasticsearch, including the translog and unassigned shards; the node’s operating system; any other applications or files on the node.
      * Unlike `disk.indices`, this metric does not double-count disk space for hard-linked files.
      * @alias 'disk.used' */
    diskUsed?: ByteSize | null;
    /** Free disk space available to Elasticsearch.
      * Elasticsearch retrieves this metric from the node’s operating system.
      * Disk-based shard allocation uses this metric to assign shards to nodes based on available disk space. */
    'disk.avail'?: ByteSize | null;
    /** Free disk space available to Elasticsearch.
      * Elasticsearch retrieves this metric from the node’s operating system.
      * Disk-based shard allocation uses this metric to assign shards to nodes based on available disk space.
      * @alias 'disk.avail' */
    da?: ByteSize | null;
    /** Free disk space available to Elasticsearch.
      * Elasticsearch retrieves this metric from the node’s operating system.
      * Disk-based shard allocation uses this metric to assign shards to nodes based on available disk space.
      * @alias 'disk.avail' */
    diskAvail?: ByteSize | null;
    /** Total disk space for the node, including in-use and available space. */
    'disk.total'?: ByteSize | null;
    /** Total disk space for the node, including in-use and available space.
      * @alias 'disk.total' */
    dt?: ByteSize | null;
    /** Total disk space for the node, including in-use and available space.
      * @alias 'disk.total' */
    diskTotal?: ByteSize | null;
    /** Total percentage of disk space in use. Calculated as `disk.used / disk.total`. */
    'disk.percent'?: Percentage | null;
    /** Total percentage of disk space in use. Calculated as `disk.used / disk.total`.
      * @alias 'disk.percent' */
    dp?: Percentage | null;
    /** Total percentage of disk space in use. Calculated as `disk.used / disk.total`.
      * @alias 'disk.percent' */
    diskPercent?: Percentage | null;
    /** Network host for the node. Set using the `network.host` setting. */
    host?: Host | null;
    /** Network host for the node. Set using the `network.host` setting.
      * @alias host */
    h?: Host | null;
    /** IP address and port for the node. */
    ip?: Ip | null;
    /** Name for the node. Set using the `node.name` setting. */
    node?: string;
    /** Name for the node. Set using the `node.name` setting.
      * @alias node */
    n?: string;
    /** Node roles */
    'node.role'?: string | null;
    /** Node roles
      * @alias 'node.role' */
    r?: string | null;
    /** Node roles
      * @alias 'node.role' */
    role?: string | null;
    /** Node roles
      * @alias 'node.role' */
    nodeRole?: string | null;
}
export interface CatAllocationRequest extends CatCatRequestBase {
    /** A comma-separated list of node identifiers or names used to limit the returned information. */
    node_id?: NodeIds;
    /** The unit used to display byte values. */
    bytes?: Bytes;
    /** List of columns to appear in the response. Supports simple wildcards. */
    h?: Names;
    /** List of columns that determine how the table should be sorted.
      * Sorting defaults to ascending and can be changed by setting `:asc`
      * or `:desc` as a suffix to the column name. */
    s?: Names;
    /** If `true`, the request computes the list of selected nodes from the
      * local cluster state. If `false` the list of selected nodes are computed
      * from the cluster state of the master node. In both cases the coordinating
      * node will send requests for further information to each selected node. */
    local?: boolean;
    /** Period to wait for a connection to the master node. */
    master_timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        node_id?: never;
        bytes?: never;
        h?: never;
        s?: never;
        local?: never;
        master_timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        node_id?: never;
        bytes?: never;
        h?: never;
        s?: never;
        local?: never;
        master_timeout?: never;
    };
}
export type CatAllocationResponse = CatAllocationAllocationRecord[];
export interface CatComponentTemplatesComponentTemplate {
    name: string;
    version: string | null;
    alias_count: string;
    mapping_count: string;
    settings_count: string;
    metadata_count: string;
    included_in: string;
}
export interface CatComponentTemplatesRequest extends CatCatRequestBase {
    /** The name of the component template.
      * It accepts wildcard expressions.
      * If it is omitted, all component templates are returned. */
    name?: string;
    /** List of columns to appear in the response. Supports simple wildcards. */
    h?: Names;
    /** List of columns that determine how the table should be sorted.
      * Sorting defaults to ascending and can be changed by setting `:asc`
      * or `:desc` as a suffix to the column name. */
    s?: Names;
    /** If `true`, the request computes the list of selected nodes from the
      * local cluster state. If `false` the list of selected nodes are computed
      * from the cluster state of the master node. In both cases the coordinating
      * node will send requests for further information to each selected node. */
    local?: boolean;
    /** The period to wait for a connection to the master node. */
    master_timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        name?: never;
        h?: never;
        s?: never;
        local?: never;
        master_timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        name?: never;
        h?: never;
        s?: never;
        local?: never;
        master_timeout?: never;
    };
}
export type CatComponentTemplatesResponse = CatComponentTemplatesComponentTemplate[];
export interface CatCountCountRecord {
    /** seconds since 1970-01-01 00:00:00 */
    epoch?: SpecUtilsStringified<EpochTime<UnitSeconds>>;
    /** seconds since 1970-01-01 00:00:00
      * @alias epoch */
    t?: SpecUtilsStringified<EpochTime<UnitSeconds>>;
    /** seconds since 1970-01-01 00:00:00
      * @alias epoch */
    time?: SpecUtilsStringified<EpochTime<UnitSeconds>>;
    /** time in HH:MM:SS */
    timestamp?: TimeOfDay;
    /** time in HH:MM:SS
      * @alias timestamp */
    ts?: TimeOfDay;
    /** time in HH:MM:SS
      * @alias timestamp */
    hms?: TimeOfDay;
    /** time in HH:MM:SS
      * @alias timestamp */
    hhmmss?: TimeOfDay;
    /** the document count */
    count?: string;
    /** the document count
      * @alias count */
    dc?: string;
    /** the document count
      * @alias count */
    'docs.count'?: string;
    /** the document count
      * @alias count */
    docsCount?: string;
}
export interface CatCountRequest extends CatCatRequestBase {
    /** A comma-separated list of data streams, indices, and aliases used to limit the request.
      * It supports wildcards (`*`).
      * To target all data streams and indices, omit this parameter or use `*` or `_all`. */
    index?: Indices;
    /** List of columns to appear in the response. Supports simple wildcards. */
    h?: Names;
    /** List of columns that determine how the table should be sorted.
      * Sorting defaults to ascending and can be changed by setting `:asc`
      * or `:desc` as a suffix to the column name. */
    s?: Names;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
        h?: never;
        s?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
        h?: never;
        s?: never;
    };
}
export type CatCountResponse = CatCountCountRecord[];
export interface CatFielddataFielddataRecord {
    /** node id */
    id?: string;
    /** host name */
    host?: string;
    /** host name
      * @alias host */
    h?: string;
    /** ip address */
    ip?: string;
    /** node name */
    node?: string;
    /** node name
      * @alias node */
    n?: string;
    /** field name */
    field?: string;
    /** field name
      * @alias field */
    f?: string;
    /** field data usage */
    size?: string;
}
export interface CatFielddataRequest extends CatCatRequestBase {
    /** Comma-separated list of fields used to limit returned information.
      * To retrieve all fields, omit this parameter. */
    fields?: Fields;
    /** The unit used to display byte values. */
    bytes?: Bytes;
    /** List of columns to appear in the response. Supports simple wildcards. */
    h?: Names;
    /** List of columns that determine how the table should be sorted.
      * Sorting defaults to ascending and can be changed by setting `:asc`
      * or `:desc` as a suffix to the column name. */
    s?: Names;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        fields?: never;
        bytes?: never;
        h?: never;
        s?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        fields?: never;
        bytes?: never;
        h?: never;
        s?: never;
    };
}
export type CatFielddataResponse = CatFielddataFielddataRecord[];
export interface CatHealthHealthRecord {
    /** seconds since 1970-01-01 00:00:00 */
    epoch?: SpecUtilsStringified<EpochTime<UnitSeconds>>;
    /** seconds since 1970-01-01 00:00:00
      * @alias epoch */
    time?: SpecUtilsStringified<EpochTime<UnitSeconds>>;
    /** time in HH:MM:SS */
    timestamp?: TimeOfDay;
    /** time in HH:MM:SS
      * @alias timestamp */
    ts?: TimeOfDay;
    /** time in HH:MM:SS
      * @alias timestamp */
    hms?: TimeOfDay;
    /** time in HH:MM:SS
      * @alias timestamp */
    hhmmss?: TimeOfDay;
    /** cluster name */
    cluster?: string;
    /** cluster name
      * @alias cluster */
    cl?: string;
    /** health status */
    status?: string;
    /** health status
      * @alias status */
    st?: string;
    /** total number of nodes */
    'node.total'?: string;
    /** total number of nodes
      * @alias 'node.total' */
    nt?: string;
    /** total number of nodes
      * @alias 'node.total' */
    nodeTotal?: string;
    /** number of nodes that can store data */
    'node.data'?: string;
    /** number of nodes that can store data
      * @alias 'node.data' */
    nd?: string;
    /** number of nodes that can store data
      * @alias 'node.data' */
    nodeData?: string;
    /** total number of shards */
    shards?: string;
    /** total number of shards
      * @alias shards */
    t?: string;
    /** total number of shards
      * @alias shards */
    sh?: string;
    /** total number of shards
      * @alias shards */
    'shards.total'?: string;
    /** total number of shards
      * @alias shards */
    shardsTotal?: string;
    /** number of primary shards */
    pri?: string;
    /** number of primary shards
      * @alias pri */
    p?: string;
    /** number of primary shards
      * @alias pri */
    'shards.primary'?: string;
    /** number of primary shards
      * @alias pri */
    shardsPrimary?: string;
    /** number of relocating nodes */
    relo?: string;
    /** number of relocating nodes
      * @alias relo */
    r?: string;
    /** number of relocating nodes
      * @alias relo */
    'shards.relocating'?: string;
    /** number of relocating nodes
      * @alias relo */
    shardsRelocating?: string;
    /** number of initializing nodes */
    init?: string;
    /** number of initializing nodes
      * @alias init */
    i?: string;
    /** number of initializing nodes
      * @alias init */
    'shards.initializing'?: string;
    /** number of initializing nodes
      * @alias init */
    shardsInitializing?: string;
    /** number of unassigned primary shards */
    'unassign.pri'?: string;
    /** number of unassigned primary shards
      * @alias 'unassign.pri' */
    up?: string;
    /** number of unassigned primary shards
      * @alias 'unassign.pri' */
    'shards.unassigned.primary'?: string;
    /** number of unassigned primary shards
      * @alias 'unassign.pri' */
    shardsUnassignedPrimary?: string;
    /** number of unassigned shards */
    unassign?: string;
    /** number of unassigned shards
      * @alias unassign */
    u?: string;
    /** number of unassigned shards
      * @alias unassign */
    'shards.unassigned'?: string;
    /** number of unassigned shards
      * @alias unassign */
    shardsUnassigned?: string;
    /** number of pending tasks */
    pending_tasks?: string;
    /** number of pending tasks
      * @alias pending_tasks */
    pt?: string;
    /** number of pending tasks
      * @alias pending_tasks */
    pendingTasks?: string;
    /** wait time of longest task pending */
    max_task_wait_time?: string;
    /** wait time of longest task pending
      * @alias max_task_wait_time */
    mtwt?: string;
    /** wait time of longest task pending
      * @alias max_task_wait_time */
    maxTaskWaitTime?: string;
    /** active number of shards in percent */
    active_shards_percent?: string;
    /** active number of shards in percent
      * @alias active_shards_percent */
    asp?: string;
    /** active number of shards in percent
      * @alias active_shards_percent */
    activeShardsPercent?: string;
}
export interface CatHealthRequest extends CatCatRequestBase {
    /** The unit used to display time values. */
    time?: TimeUnit;
    /** If true, returns `HH:MM:SS` and Unix epoch timestamps. */
    ts?: boolean;
    /** List of columns to appear in the response. Supports simple wildcards. */
    h?: Names;
    /** List of columns that determine how the table should be sorted.
      * Sorting defaults to ascending and can be changed by setting `:asc`
      * or `:desc` as a suffix to the column name. */
    s?: Names;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        time?: never;
        ts?: never;
        h?: never;
        s?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        time?: never;
        ts?: never;
        h?: never;
        s?: never;
    };
}
export type CatHealthResponse = CatHealthHealthRecord[];
export interface CatHelpRequest {
    /** All values in `body` will be added to the request body. */
    body?: string | {
        [key: string]: any;
    };
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    };
}
export interface CatHelpResponse {
}
export interface CatIndicesIndicesRecord {
    /** current health status */
    health?: string;
    /** current health status
      * @alias health */
    h?: string;
    /** open/close status */
    status?: string;
    /** open/close status
      * @alias status */
    s?: string;
    /** index name */
    index?: string;
    /** index name
      * @alias index */
    i?: string;
    /** index name
      * @alias index */
    idx?: string;
    /** index uuid */
    uuid?: string;
    /** index uuid
      * @alias uuid */
    id?: string;
    /** number of primary shards */
    pri?: string;
    /** number of primary shards
      * @alias pri */
    p?: string;
    /** number of primary shards
      * @alias pri */
    'shards.primary'?: string;
    /** number of primary shards
      * @alias pri */
    shardsPrimary?: string;
    /** number of replica shards */
    rep?: string;
    /** number of replica shards
      * @alias rep */
    r?: string;
    /** number of replica shards
      * @alias rep */
    'shards.replica'?: string;
    /** number of replica shards
      * @alias rep */
    shardsReplica?: string;
    /** available docs */
    'docs.count'?: string | null;
    /** available docs
      * @alias 'docs.count' */
    dc?: string | null;
    /** available docs
      * @alias 'docs.count' */
    docsCount?: string | null;
    /** deleted docs */
    'docs.deleted'?: string | null;
    /** deleted docs
      * @alias 'docs.deleted' */
    dd?: string | null;
    /** deleted docs
      * @alias 'docs.deleted' */
    docsDeleted?: string | null;
    /** index creation date (millisecond value) */
    'creation.date'?: string;
    /** index creation date (millisecond value)
      * @alias 'creation.date' */
    cd?: string;
    /** index creation date (as string) */
    'creation.date.string'?: string;
    /** index creation date (as string)
      * @alias 'creation.date.string' */
    cds?: string;
    /** store size of primaries & replicas */
    'store.size'?: string | null;
    /** store size of primaries & replicas
      * @alias 'store.size' */
    ss?: string | null;
    /** store size of primaries & replicas
      * @alias 'store.size' */
    storeSize?: string | null;
    /** store size of primaries */
    'pri.store.size'?: string | null;
    /** total size of dataset (including the cache for partially mounted indices) */
    'dataset.size'?: string | null;
    /** size of completion */
    'completion.size'?: string;
    /** size of completion
      * @alias 'completion.size' */
    cs?: string;
    /** size of completion
      * @alias 'completion.size' */
    completionSize?: string;
    /** size of completion */
    'pri.completion.size'?: string;
    /** used fielddata cache */
    'fielddata.memory_size'?: string;
    /** used fielddata cache
      * @alias 'fielddata.memory_size' */
    fm?: string;
    /** used fielddata cache
      * @alias 'fielddata.memory_size' */
    fielddataMemory?: string;
    /** used fielddata cache */
    'pri.fielddata.memory_size'?: string;
    /** fielddata evictions */
    'fielddata.evictions'?: string;
    /** fielddata evictions
      * @alias 'fielddata.evictions' */
    fe?: string;
    /** fielddata evictions
      * @alias 'fielddata.evictions' */
    fielddataEvictions?: string;
    /** fielddata evictions */
    'pri.fielddata.evictions'?: string;
    /** used query cache */
    'query_cache.memory_size'?: string;
    /** used query cache
      * @alias 'query_cache.memory_size' */
    qcm?: string;
    /** used query cache
      * @alias 'query_cache.memory_size' */
    queryCacheMemory?: string;
    /** used query cache */
    'pri.query_cache.memory_size'?: string;
    /** query cache evictions */
    'query_cache.evictions'?: string;
    /** query cache evictions
      * @alias 'query_cache.evictions' */
    qce?: string;
    /** query cache evictions
      * @alias 'query_cache.evictions' */
    queryCacheEvictions?: string;
    /** query cache evictions */
    'pri.query_cache.evictions'?: string;
    /** used request cache */
    'request_cache.memory_size'?: string;
    /** used request cache
      * @alias 'request_cache.memory_size' */
    rcm?: string;
    /** used request cache
      * @alias 'request_cache.memory_size' */
    requestCacheMemory?: string;
    /** used request cache */
    'pri.request_cache.memory_size'?: string;
    /** request cache evictions */
    'request_cache.evictions'?: string;
    /** request cache evictions
      * @alias 'request_cache.evictions' */
    rce?: string;
    /** request cache evictions
      * @alias 'request_cache.evictions' */
    requestCacheEvictions?: string;
    /** request cache evictions */
    'pri.request_cache.evictions'?: string;
    /** request cache hit count */
    'request_cache.hit_count'?: string;
    /** request cache hit count
      * @alias 'request_cache.hit_count' */
    rchc?: string;
    /** request cache hit count
      * @alias 'request_cache.hit_count' */
    requestCacheHitCount?: string;
    /** request cache hit count */
    'pri.request_cache.hit_count'?: string;
    /** request cache miss count */
    'request_cache.miss_count'?: string;
    /** request cache miss count
      * @alias 'request_cache.miss_count' */
    rcmc?: string;
    /** request cache miss count
      * @alias 'request_cache.miss_count' */
    requestCacheMissCount?: string;
    /** request cache miss count */
    'pri.request_cache.miss_count'?: string;
    /** number of flushes */
    'flush.total'?: string;
    /** number of flushes
      * @alias 'flush.total' */
    ft?: string;
    /** number of flushes
      * @alias 'flush.total' */
    flushTotal?: string;
    /** number of flushes */
    'pri.flush.total'?: string;
    /** time spent in flush */
    'flush.total_time'?: string;
    /** time spent in flush
      * @alias 'flush.total_time' */
    ftt?: string;
    /** time spent in flush
      * @alias 'flush.total_time' */
    flushTotalTime?: string;
    /** time spent in flush */
    'pri.flush.total_time'?: string;
    /** number of current get ops */
    'get.current'?: string;
    /** number of current get ops
      * @alias 'get.current' */
    gc?: string;
    /** number of current get ops
      * @alias 'get.current' */
    getCurrent?: string;
    /** number of current get ops */
    'pri.get.current'?: string;
    /** time spent in get */
    'get.time'?: string;
    /** time spent in get
      * @alias 'get.time' */
    gti?: string;
    /** time spent in get
      * @alias 'get.time' */
    getTime?: string;
    /** time spent in get */
    'pri.get.time'?: string;
    /** number of get ops */
    'get.total'?: string;
    /** number of get ops
      * @alias 'get.total' */
    gto?: string;
    /** number of get ops
      * @alias 'get.total' */
    getTotal?: string;
    /** number of get ops */
    'pri.get.total'?: string;
    /** time spent in successful gets */
    'get.exists_time'?: string;
    /** time spent in successful gets
      * @alias 'get.exists_time' */
    geti?: string;
    /** time spent in successful gets
      * @alias 'get.exists_time' */
    getExistsTime?: string;
    /** time spent in successful gets */
    'pri.get.exists_time'?: string;
    /** number of successful gets */
    'get.exists_total'?: string;
    /** number of successful gets
      * @alias 'get.exists_total' */
    geto?: string;
    /** number of successful gets
      * @alias 'get.exists_total' */
    getExistsTotal?: string;
    /** number of successful gets */
    'pri.get.exists_total'?: string;
    /** time spent in failed gets */
    'get.missing_time'?: string;
    /** time spent in failed gets
      * @alias 'get.missing_time' */
    gmti?: string;
    /** time spent in failed gets
      * @alias 'get.missing_time' */
    getMissingTime?: string;
    /** time spent in failed gets */
    'pri.get.missing_time'?: string;
    /** number of failed gets */
    'get.missing_total'?: string;
    /** number of failed gets
      * @alias 'get.missing_total' */
    gmto?: string;
    /** number of failed gets
      * @alias 'get.missing_total' */
    getMissingTotal?: string;
    /** number of failed gets */
    'pri.get.missing_total'?: string;
    /** number of current deletions */
    'indexing.delete_current'?: string;
    /** number of current deletions
      * @alias 'indexing.delete_current' */
    idc?: string;
    /** number of current deletions
      * @alias 'indexing.delete_current' */
    indexingDeleteCurrent?: string;
    /** number of current deletions */
    'pri.indexing.delete_current'?: string;
    /** time spent in deletions */
    'indexing.delete_time'?: string;
    /** time spent in deletions
      * @alias 'indexing.delete_time' */
    idti?: string;
    /** time spent in deletions
      * @alias 'indexing.delete_time' */
    indexingDeleteTime?: string;
    /** time spent in deletions */
    'pri.indexing.delete_time'?: string;
    /** number of delete ops */
    'indexing.delete_total'?: string;
    /** number of delete ops
      * @alias 'indexing.delete_total' */
    idto?: string;
    /** number of delete ops
      * @alias 'indexing.delete_total' */
    indexingDeleteTotal?: string;
    /** number of delete ops */
    'pri.indexing.delete_total'?: string;
    /** number of current indexing ops */
    'indexing.index_current'?: string;
    /** number of current indexing ops
      * @alias 'indexing.index_current' */
    iic?: string;
    /** number of current indexing ops
      * @alias 'indexing.index_current' */
    indexingIndexCurrent?: string;
    /** number of current indexing ops */
    'pri.indexing.index_current'?: string;
    /** time spent in indexing */
    'indexing.index_time'?: string;
    /** time spent in indexing
      * @alias 'indexing.index_time' */
    iiti?: string;
    /** time spent in indexing
      * @alias 'indexing.index_time' */
    indexingIndexTime?: string;
    /** time spent in indexing */
    'pri.indexing.index_time'?: string;
    /** number of indexing ops */
    'indexing.index_total'?: string;
    /** number of indexing ops
      * @alias 'indexing.index_total' */
    iito?: string;
    /** number of indexing ops
      * @alias 'indexing.index_total' */
    indexingIndexTotal?: string;
    /** number of indexing ops */
    'pri.indexing.index_total'?: string;
    /** number of failed indexing ops */
    'indexing.index_failed'?: string;
    /** number of failed indexing ops
      * @alias 'indexing.index_failed' */
    iif?: string;
    /** number of failed indexing ops
      * @alias 'indexing.index_failed' */
    indexingIndexFailed?: string;
    /** number of failed indexing ops */
    'pri.indexing.index_failed'?: string;
    /** number of current merges */
    'merges.current'?: string;
    /** number of current merges
      * @alias 'merges.current' */
    mc?: string;
    /** number of current merges
      * @alias 'merges.current' */
    mergesCurrent?: string;
    /** number of current merges */
    'pri.merges.current'?: string;
    /** number of current merging docs */
    'merges.current_docs'?: string;
    /** number of current merging docs
      * @alias 'merges.current_docs' */
    mcd?: string;
    /** number of current merging docs
      * @alias 'merges.current_docs' */
    mergesCurrentDocs?: string;
    /** number of current merging docs */
    'pri.merges.current_docs'?: string;
    /** size of current merges */
    'merges.current_size'?: string;
    /** size of current merges
      * @alias 'merges.current_size' */
    mcs?: string;
    /** size of current merges
      * @alias 'merges.current_size' */
    mergesCurrentSize?: string;
    /** size of current merges */
    'pri.merges.current_size'?: string;
    /** number of completed merge ops */
    'merges.total'?: string;
    /** number of completed merge ops
      * @alias 'merges.total' */
    mt?: string;
    /** number of completed merge ops
      * @alias 'merges.total' */
    mergesTotal?: string;
    /** number of completed merge ops */
    'pri.merges.total'?: string;
    /** docs merged */
    'merges.total_docs'?: string;
    /** docs merged
      * @alias 'merges.total_docs' */
    mtd?: string;
    /** docs merged
      * @alias 'merges.total_docs' */
    mergesTotalDocs?: string;
    /** docs merged */
    'pri.merges.total_docs'?: string;
    /** size merged */
    'merges.total_size'?: string;
    /** size merged
      * @alias 'merges.total_size' */
    mts?: string;
    /** size merged
      * @alias 'merges.total_size' */
    mergesTotalSize?: string;
    /** size merged */
    'pri.merges.total_size'?: string;
    /** time spent in merges */
    'merges.total_time'?: string;
    /** time spent in merges
      * @alias 'merges.total_time' */
    mtt?: string;
    /** time spent in merges
      * @alias 'merges.total_time' */
    mergesTotalTime?: string;
    /** time spent in merges */
    'pri.merges.total_time'?: string;
    /** total refreshes */
    'refresh.total'?: string;
    /** total refreshes
      * @alias 'refresh.total' */
    rto?: string;
    /** total refreshes
      * @alias 'refresh.total' */
    refreshTotal?: string;
    /** total refreshes */
    'pri.refresh.total'?: string;
    /** time spent in refreshes */
    'refresh.time'?: string;
    /** time spent in refreshes
      * @alias 'refresh.time' */
    rti?: string;
    /** time spent in refreshes
      * @alias 'refresh.time' */
    refreshTime?: string;
    /** time spent in refreshes */
    'pri.refresh.time'?: string;
    /** total external refreshes */
    'refresh.external_total'?: string;
    /** total external refreshes
      * @alias 'refresh.external_total' */
    reto?: string;
    /** total external refreshes */
    'pri.refresh.external_total'?: string;
    /** time spent in external refreshes */
    'refresh.external_time'?: string;
    /** time spent in external refreshes
      * @alias 'refresh.external_time' */
    reti?: string;
    /** time spent in external refreshes */
    'pri.refresh.external_time'?: string;
    /** number of pending refresh listeners */
    'refresh.listeners'?: string;
    /** number of pending refresh listeners
      * @alias 'refresh.listeners' */
    rli?: string;
    /** number of pending refresh listeners
      * @alias 'refresh.listeners' */
    refreshListeners?: string;
    /** number of pending refresh listeners */
    'pri.refresh.listeners'?: string;
    /** current fetch phase ops */
    'search.fetch_current'?: string;
    /** current fetch phase ops
      * @alias 'search.fetch_current' */
    sfc?: string;
    /** current fetch phase ops
      * @alias 'search.fetch_current' */
    searchFetchCurrent?: string;
    /** current fetch phase ops */
    'pri.search.fetch_current'?: string;
    /** time spent in fetch phase */
    'search.fetch_time'?: string;
    /** time spent in fetch phase
      * @alias 'search.fetch_time' */
    sfti?: string;
    /** time spent in fetch phase
      * @alias 'search.fetch_time' */
    searchFetchTime?: string;
    /** time spent in fetch phase */
    'pri.search.fetch_time'?: string;
    /** total fetch ops */
    'search.fetch_total'?: string;
    /** total fetch ops
      * @alias 'search.fetch_total' */
    sfto?: string;
    /** total fetch ops
      * @alias 'search.fetch_total' */
    searchFetchTotal?: string;
    /** total fetch ops */
    'pri.search.fetch_total'?: string;
    /** open search contexts */
    'search.open_contexts'?: string;
    /** open search contexts
      * @alias 'search.open_contexts' */
    so?: string;
    /** open search contexts
      * @alias 'search.open_contexts' */
    searchOpenContexts?: string;
    /** open search contexts */
    'pri.search.open_contexts'?: string;
    /** current query phase ops */
    'search.query_current'?: string;
    /** current query phase ops
      * @alias 'search.query_current' */
    sqc?: string;
    /** current query phase ops
      * @alias 'search.query_current' */
    searchQueryCurrent?: string;
    /** current query phase ops */
    'pri.search.query_current'?: string;
    /** time spent in query phase */
    'search.query_time'?: string;
    /** time spent in query phase
      * @alias 'search.query_time' */
    sqti?: string;
    /** time spent in query phase
      * @alias 'search.query_time' */
    searchQueryTime?: string;
    /** time spent in query phase */
    'pri.search.query_time'?: string;
    /** total query phase ops */
    'search.query_total'?: string;
    /** total query phase ops
      * @alias 'search.query_total' */
    sqto?: string;
    /** total query phase ops
      * @alias 'search.query_total' */
    searchQueryTotal?: string;
    /** total query phase ops */
    'pri.search.query_total'?: string;
    /** open scroll contexts */
    'search.scroll_current'?: string;
    /** open scroll contexts
      * @alias 'search.scroll_current' */
    scc?: string;
    /** open scroll contexts
      * @alias 'search.scroll_current' */
    searchScrollCurrent?: string;
    /** open scroll contexts */
    'pri.search.scroll_current'?: string;
    /** time scroll contexts held open */
    'search.scroll_time'?: string;
    /** time scroll contexts held open
      * @alias 'search.scroll_time' */
    scti?: string;
    /** time scroll contexts held open
      * @alias 'search.scroll_time' */
    searchScrollTime?: string;
    /** time scroll contexts held open */
    'pri.search.scroll_time'?: string;
    /** completed scroll contexts */
    'search.scroll_total'?: string;
    /** completed scroll contexts
      * @alias 'search.scroll_total' */
    scto?: string;
    /** completed scroll contexts
      * @alias 'search.scroll_total' */
    searchScrollTotal?: string;
    /** completed scroll contexts */
    'pri.search.scroll_total'?: string;
    /** number of segments */
    'segments.count'?: string;
    /** number of segments
      * @alias 'segments.count' */
    sc?: string;
    /** number of segments
      * @alias 'segments.count' */
    segmentsCount?: string;
    /** number of segments */
    'pri.segments.count'?: string;
    /** memory used by segments */
    'segments.memory'?: string;
    /** memory used by segments
      * @alias 'segments.memory' */
    sm?: string;
    /** memory used by segments
      * @alias 'segments.memory' */
    segmentsMemory?: string;
    /** memory used by segments */
    'pri.segments.memory'?: string;
    /** memory used by index writer */
    'segments.index_writer_memory'?: string;
    /** memory used by index writer
      * @alias 'segments.index_writer_memory' */
    siwm?: string;
    /** memory used by index writer
      * @alias 'segments.index_writer_memory' */
    segmentsIndexWriterMemory?: string;
    /** memory used by index writer */
    'pri.segments.index_writer_memory'?: string;
    /** memory used by version map */
    'segments.version_map_memory'?: string;
    /** memory used by version map
      * @alias 'segments.version_map_memory' */
    svmm?: string;
    /** memory used by version map
      * @alias 'segments.version_map_memory' */
    segmentsVersionMapMemory?: string;
    /** memory used by version map */
    'pri.segments.version_map_memory'?: string;
    /** memory used by fixed bit sets for nested object field types and export type filters for types referred in _parent fields */
    'segments.fixed_bitset_memory'?: string;
    /** memory used by fixed bit sets for nested object field types and export type filters for types referred in _parent fields
      * @alias 'segments.fixed_bitset_memory' */
    sfbm?: string;
    /** memory used by fixed bit sets for nested object field types and export type filters for types referred in _parent fields
      * @alias 'segments.fixed_bitset_memory' */
    fixedBitsetMemory?: string;
    /** memory used by fixed bit sets for nested object field types and export type filters for types referred in _parent fields */
    'pri.segments.fixed_bitset_memory'?: string;
    /** current warmer ops */
    'warmer.current'?: string;
    /** current warmer ops
      * @alias 'warmer.current' */
    wc?: string;
    /** current warmer ops
      * @alias 'warmer.current' */
    warmerCurrent?: string;
    /** current warmer ops */
    'pri.warmer.current'?: string;
    /** total warmer ops */
    'warmer.total'?: string;
    /** total warmer ops
      * @alias 'warmer.total' */
    wto?: string;
    /** total warmer ops
      * @alias 'warmer.total' */
    warmerTotal?: string;
    /** total warmer ops */
    'pri.warmer.total'?: string;
    /** time spent in warmers */
    'warmer.total_time'?: string;
    /** time spent in warmers
      * @alias 'warmer.total_time' */
    wtt?: string;
    /** time spent in warmers
      * @alias 'warmer.total_time' */
    warmerTotalTime?: string;
    /** time spent in warmers */
    'pri.warmer.total_time'?: string;
    /** number of current suggest ops */
    'suggest.current'?: string;
    /** number of current suggest ops
      * @alias 'suggest.current' */
    suc?: string;
    /** number of current suggest ops
      * @alias 'suggest.current' */
    suggestCurrent?: string;
    /** number of current suggest ops */
    'pri.suggest.current'?: string;
    /** time spend in suggest */
    'suggest.time'?: string;
    /** time spend in suggest
      * @alias 'suggest.time' */
    suti?: string;
    /** time spend in suggest
      * @alias 'suggest.time' */
    suggestTime?: string;
    /** time spend in suggest */
    'pri.suggest.time'?: string;
    /** number of suggest ops */
    'suggest.total'?: string;
    /** number of suggest ops
      * @alias 'suggest.total' */
    suto?: string;
    /** number of suggest ops
      * @alias 'suggest.total' */
    suggestTotal?: string;
    /** number of suggest ops */
    'pri.suggest.total'?: string;
    /** total used memory */
    'memory.total'?: string;
    /** total used memory
      * @alias 'memory.total' */
    tm?: string;
    /** total used memory
      * @alias 'memory.total' */
    memoryTotal?: string;
    /** total user memory */
    'pri.memory.total'?: string;
    /** indicates if the index is search throttled */
    'search.throttled'?: string;
    /** indicates if the index is search throttled
      * @alias 'search.throttled' */
    sth?: string;
    /** number of bulk shard ops */
    'bulk.total_operations'?: string;
    /** number of bulk shard ops
      * @alias 'bulk.total_operations' */
    bto?: string;
    /** number of bulk shard ops
      * @alias 'bulk.total_operations' */
    bulkTotalOperation?: string;
    /** number of bulk shard ops */
    'pri.bulk.total_operations'?: string;
    /** time spend in shard bulk */
    'bulk.total_time'?: string;
    /** time spend in shard bulk
      * @alias 'bulk.total_time' */
    btti?: string;
    /** time spend in shard bulk
      * @alias 'bulk.total_time' */
    bulkTotalTime?: string;
    /** time spend in shard bulk */
    'pri.bulk.total_time'?: string;
    /** total size in bytes of shard bulk */
    'bulk.total_size_in_bytes'?: string;
    /** total size in bytes of shard bulk
      * @alias 'bulk.total_size_in_bytes' */
    btsi?: string;
    /** total size in bytes of shard bulk
      * @alias 'bulk.total_size_in_bytes' */
    bulkTotalSizeInBytes?: string;
    /** total size in bytes of shard bulk */
    'pri.bulk.total_size_in_bytes'?: string;
    /** average time spend in shard bulk */
    'bulk.avg_time'?: string;
    /** average time spend in shard bulk
      * @alias 'bulk.avg_time' */
    bati?: string;
    /** average time spend in shard bulk
      * @alias 'bulk.avg_time' */
    bulkAvgTime?: string;
    /** average time spend in shard bulk */
    'pri.bulk.avg_time'?: string;
    /** average size in bytes of shard bulk */
    'bulk.avg_size_in_bytes'?: string;
    /** average size in bytes of shard bulk
      * @alias 'bulk.avg_size_in_bytes' */
    basi?: string;
    /** average size in bytes of shard bulk
      * @alias 'bulk.avg_size_in_bytes' */
    bulkAvgSizeInBytes?: string;
    /** average size in bytes of shard bulk */
    'pri.bulk.avg_size_in_bytes'?: string;
}
export interface CatIndicesRequest extends CatCatRequestBase {
    /** Comma-separated list of data streams, indices, and aliases used to limit the request.
      * Supports wildcards (`*`). To target all data streams and indices, omit this parameter or use `*` or `_all`. */
    index?: Indices;
    /** The unit used to display byte values. */
    bytes?: Bytes;
    /** The type of index that wildcard patterns can match. */
    expand_wildcards?: ExpandWildcards;
    /** The health status used to limit returned indices. By default, the response includes indices of any health status. */
    health?: HealthStatus;
    /** If true, the response includes information from segments that are not loaded into memory. */
    include_unloaded_segments?: boolean;
    /** If true, the response only includes information from primary shards. */
    pri?: boolean;
    /** The unit used to display time values. */
    time?: TimeUnit;
    /** Period to wait for a connection to the master node. */
    master_timeout?: Duration;
    /** List of columns to appear in the response. Supports simple wildcards. */
    h?: Names;
    /** List of columns that determine how the table should be sorted.
      * Sorting defaults to ascending and can be changed by setting `:asc`
      * or `:desc` as a suffix to the column name. */
    s?: Names;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
        bytes?: never;
        expand_wildcards?: never;
        health?: never;
        include_unloaded_segments?: never;
        pri?: never;
        time?: never;
        master_timeout?: never;
        h?: never;
        s?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
        bytes?: never;
        expand_wildcards?: never;
        health?: never;
        include_unloaded_segments?: never;
        pri?: never;
        time?: never;
        master_timeout?: never;
        h?: never;
        s?: never;
    };
}
export type CatIndicesResponse = CatIndicesIndicesRecord[];
export interface CatMasterMasterRecord {
    /** node id */
    id?: string;
    /** host name */
    host?: string;
    /** host name
      * @alias host */
    h?: string;
    /** ip address */
    ip?: string;
    /** node name */
    node?: string;
    /** node name
      * @alias node */
    n?: string;
}
export interface CatMasterRequest extends CatCatRequestBase {
    /** List of columns to appear in the response. Supports simple wildcards. */
    h?: Names;
    /** List of columns that determine how the table should be sorted.
      * Sorting defaults to ascending and can be changed by setting `:asc`
      * or `:desc` as a suffix to the column name. */
    s?: Names;
    /** If `true`, the request computes the list of selected nodes from the
      * local cluster state. If `false` the list of selected nodes are computed
      * from the cluster state of the master node. In both cases the coordinating
      * node will send requests for further information to each selected node. */
    local?: boolean;
    /** Period to wait for a connection to the master node. */
    master_timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        h?: never;
        s?: never;
        local?: never;
        master_timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        h?: never;
        s?: never;
        local?: never;
        master_timeout?: never;
    };
}
export type CatMasterResponse = CatMasterMasterRecord[];
export interface CatMlDataFrameAnalyticsDataFrameAnalyticsRecord {
    /** The identifier for the job. */
    id?: Id;
    /** The type of analysis that the job performs. */
    type?: string;
    /** The type of analysis that the job performs.
      * @alias type */
    t?: string;
    /** The time when the job was created. */
    create_time?: string;
    /** The time when the job was created.
      * @alias create_time */
    ct?: string;
    /** The time when the job was created.
      * @alias create_time */
    createTime?: string;
    /** The version of Elasticsearch when the job was created. */
    version?: VersionString;
    /** The version of Elasticsearch when the job was created.
      * @alias version */
    v?: VersionString;
    /** The name of the source index. */
    source_index?: IndexName;
    /** The name of the source index.
      * @alias source_index */
    si?: IndexName;
    /** The name of the source index.
      * @alias source_index */
    sourceIndex?: IndexName;
    /** The name of the destination index. */
    dest_index?: IndexName;
    /** The name of the destination index.
      * @alias dest_index */
    di?: IndexName;
    /** The name of the destination index.
      * @alias dest_index */
    destIndex?: IndexName;
    /** A description of the job. */
    description?: string;
    /** A description of the job.
      * @alias description */
    d?: string;
    /** The approximate maximum amount of memory resources that are permitted for the job. */
    model_memory_limit?: string;
    /** The approximate maximum amount of memory resources that are permitted for the job.
      * @alias model_memory_limit */
    mml?: string;
    /** The approximate maximum amount of memory resources that are permitted for the job.
      * @alias model_memory_limit */
    modelMemoryLimit?: string;
    /** The current status of the job. */
    state?: string;
    /** The current status of the job.
      * @alias state */
    s?: string;
    /** Messages about the reason why the job failed. */
    failure_reason?: string;
    /** Messages about the reason why the job failed.
      * @alias failure_reason */
    fr?: string;
    /** Messages about the reason why the job failed.
      * @alias failure_reason */
    failureReason?: string;
    /** The progress report for the job by phase. */
    progress?: string;
    /** The progress report for the job by phase.
      * @alias progress */
    p?: string;
    /** Messages related to the selection of a node. */
    assignment_explanation?: string;
    /** Messages related to the selection of a node.
      * @alias assignment_explanation */
    ae?: string;
    /** Messages related to the selection of a node.
      * @alias assignment_explanation */
    assignmentExplanation?: string;
    /** The unique identifier of the assigned node. */
    'node.id'?: Id;
    /** The unique identifier of the assigned node.
      * @alias 'node.id' */
    ni?: Id;
    /** The unique identifier of the assigned node.
      * @alias 'node.id' */
    nodeId?: Id;
    /** The name of the assigned node. */
    'node.name'?: Name;
    /** The name of the assigned node.
      * @alias 'node.name' */
    nn?: Name;
    /** The name of the assigned node.
      * @alias 'node.name' */
    nodeName?: Name;
    /** The ephemeral identifier of the assigned node. */
    'node.ephemeral_id'?: Id;
    /** The ephemeral identifier of the assigned node.
      * @alias 'node.ephemeral_id' */
    ne?: Id;
    /** The ephemeral identifier of the assigned node.
      * @alias 'node.ephemeral_id' */
    nodeEphemeralId?: Id;
    /** The network address of the assigned node. */
    'node.address'?: string;
    /** The network address of the assigned node.
      * @alias 'node.address' */
    na?: string;
    /** The network address of the assigned node.
      * @alias 'node.address' */
    nodeAddress?: string;
}
export interface CatMlDataFrameAnalyticsRequest extends CatCatRequestBase {
    /** The ID of the data frame analytics to fetch */
    id?: Id;
    /** Whether to ignore if a wildcard expression matches no configs. (This includes `_all` string or when no configs have been specified) */
    allow_no_match?: boolean;
    /** The unit in which to display byte values */
    bytes?: Bytes;
    /** Comma-separated list of column names to display. */
    h?: CatCatDfaColumns;
    /** Comma-separated list of column names or column aliases used to sort the
      * response. */
    s?: CatCatDfaColumns;
    /** Unit used to display time values. */
    time?: TimeUnit;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        id?: never;
        allow_no_match?: never;
        bytes?: never;
        h?: never;
        s?: never;
        time?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        id?: never;
        allow_no_match?: never;
        bytes?: never;
        h?: never;
        s?: never;
        time?: never;
    };
}
export type CatMlDataFrameAnalyticsResponse = CatMlDataFrameAnalyticsDataFrameAnalyticsRecord[];
export interface CatMlDatafeedsDatafeedsRecord {
    /** The datafeed identifier. */
    id?: string;
    /** The status of the datafeed. */
    state?: MlDatafeedState;
    /** The status of the datafeed.
      * @alias state */
    s?: MlDatafeedState;
    /** For started datafeeds only, contains messages relating to the selection of a node. */
    assignment_explanation?: string;
    /** For started datafeeds only, contains messages relating to the selection of a node.
      * @alias assignment_explanation */
    ae?: string;
    /** The number of buckets processed. */
    'buckets.count'?: string;
    /** The number of buckets processed.
      * @alias 'buckets.count' */
    bc?: string;
    /** The number of buckets processed.
      * @alias 'buckets.count' */
    bucketsCount?: string;
    /** The number of searches run by the datafeed. */
    'search.count'?: string;
    /** The number of searches run by the datafeed.
      * @alias 'search.count' */
    sc?: string;
    /** The number of searches run by the datafeed.
      * @alias 'search.count' */
    searchCount?: string;
    /** The total time the datafeed spent searching, in milliseconds. */
    'search.time'?: string;
    /** The total time the datafeed spent searching, in milliseconds.
      * @alias 'search.time' */
    st?: string;
    /** The total time the datafeed spent searching, in milliseconds.
      * @alias 'search.time' */
    searchTime?: string;
    /** The average search time per bucket, in milliseconds. */
    'search.bucket_avg'?: string;
    /** The average search time per bucket, in milliseconds.
      * @alias 'search.bucket_avg' */
    sba?: string;
    /** The average search time per bucket, in milliseconds.
      * @alias 'search.bucket_avg' */
    searchBucketAvg?: string;
    /** The exponential average search time per hour, in milliseconds. */
    'search.exp_avg_hour'?: string;
    /** The exponential average search time per hour, in milliseconds.
      * @alias 'search.exp_avg_hour' */
    seah?: string;
    /** The exponential average search time per hour, in milliseconds.
      * @alias 'search.exp_avg_hour' */
    searchExpAvgHour?: string;
    /** The unique identifier of the assigned node.
      * For started datafeeds only, this information pertains to the node upon which the datafeed is started. */
    'node.id'?: string;
    /** The unique identifier of the assigned node.
      * For started datafeeds only, this information pertains to the node upon which the datafeed is started.
      * @alias 'node.id' */
    ni?: string;
    /** The unique identifier of the assigned node.
      * For started datafeeds only, this information pertains to the node upon which the datafeed is started.
      * @alias 'node.id' */
    nodeId?: string;
    /** The name of the assigned node.
      * For started datafeeds only, this information pertains to the node upon which the datafeed is started. */
    'node.name'?: string;
    /** The name of the assigned node.
      * For started datafeeds only, this information pertains to the node upon which the datafeed is started.
      * @alias 'node.name' */
    nn?: string;
    /** The name of the assigned node.
      * For started datafeeds only, this information pertains to the node upon which the datafeed is started.
      * @alias 'node.name' */
    nodeName?: string;
    /** The ephemeral identifier of the assigned node.
      * For started datafeeds only, this information pertains to the node upon which the datafeed is started. */
    'node.ephemeral_id'?: string;
    /** The ephemeral identifier of the assigned node.
      * For started datafeeds only, this information pertains to the node upon which the datafeed is started.
      * @alias 'node.ephemeral_id' */
    ne?: string;
    /** The ephemeral identifier of the assigned node.
      * For started datafeeds only, this information pertains to the node upon which the datafeed is started.
      * @alias 'node.ephemeral_id' */
    nodeEphemeralId?: string;
    /** The network address of the assigned node.
      * For started datafeeds only, this information pertains to the node upon which the datafeed is started. */
    'node.address'?: string;
    /** The network address of the assigned node.
      * For started datafeeds only, this information pertains to the node upon which the datafeed is started.
      * @alias 'node.address' */
    na?: string;
    /** The network address of the assigned node.
      * For started datafeeds only, this information pertains to the node upon which the datafeed is started.
      * @alias 'node.address' */
    nodeAddress?: string;
}
export interface CatMlDatafeedsRequest extends CatCatRequestBase {
    /** A numerical character string that uniquely identifies the datafeed. */
    datafeed_id?: Id;
    /** Specifies what to do when the request:
      *
      * * Contains wildcard expressions and there are no datafeeds that match.
      * * Contains the `_all` string or no identifiers and there are no matches.
      * * Contains wildcard expressions and there are only partial matches.
      *
      * If `true`, the API returns an empty datafeeds array when there are no matches and the subset of results when
      * there are partial matches. If `false`, the API returns a 404 status code when there are no matches or only
      * partial matches. */
    allow_no_match?: boolean;
    /** Comma-separated list of column names to display. */
    h?: CatCatDatafeedColumns;
    /** Comma-separated list of column names or column aliases used to sort the response. */
    s?: CatCatDatafeedColumns;
    /** The unit used to display time values. */
    time?: TimeUnit;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        datafeed_id?: never;
        allow_no_match?: never;
        h?: never;
        s?: never;
        time?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        datafeed_id?: never;
        allow_no_match?: never;
        h?: never;
        s?: never;
        time?: never;
    };
}
export type CatMlDatafeedsResponse = CatMlDatafeedsDatafeedsRecord[];
export interface CatMlJobsJobsRecord {
    /** The anomaly detection job identifier. */
    id?: Id;
    /** The status of the anomaly detection job. */
    state?: MlJobState;
    /** The status of the anomaly detection job.
      * @alias state */
    s?: MlJobState;
    /** For open jobs only, the amount of time the job has been opened. */
    opened_time?: string;
    /** For open jobs only, the amount of time the job has been opened.
      * @alias opened_time */
    ot?: string;
    /** For open anomaly detection jobs only, contains messages relating to the selection of a node to run the job. */
    assignment_explanation?: string;
    /** For open anomaly detection jobs only, contains messages relating to the selection of a node to run the job.
      * @alias assignment_explanation */
    ae?: string;
    /** The number of input documents that have been processed by the anomaly detection job.
      * This value includes documents with missing fields, since they are nonetheless analyzed.
      * If you use datafeeds and have aggregations in your search query, the `processed_record_count` is the number of aggregation results processed, not the number of Elasticsearch documents. */
    'data.processed_records'?: string;
    /** The number of input documents that have been processed by the anomaly detection job.
      * This value includes documents with missing fields, since they are nonetheless analyzed.
      * If you use datafeeds and have aggregations in your search query, the `processed_record_count` is the number of aggregation results processed, not the number of Elasticsearch documents.
      * @alias 'data.processed_records' */
    dpr?: string;
    /** The number of input documents that have been processed by the anomaly detection job.
      * This value includes documents with missing fields, since they are nonetheless analyzed.
      * If you use datafeeds and have aggregations in your search query, the `processed_record_count` is the number of aggregation results processed, not the number of Elasticsearch documents.
      * @alias 'data.processed_records' */
    dataProcessedRecords?: string;
    /** The total number of fields in all the documents that have been processed by the anomaly detection job.
      * Only fields that are specified in the detector configuration object contribute to this count.
      * The timestamp is not included in this count. */
    'data.processed_fields'?: string;
    /** The total number of fields in all the documents that have been processed by the anomaly detection job.
      * Only fields that are specified in the detector configuration object contribute to this count.
      * The timestamp is not included in this count.
      * @alias 'data.processed_fields' */
    dpf?: string;
    /** The total number of fields in all the documents that have been processed by the anomaly detection job.
      * Only fields that are specified in the detector configuration object contribute to this count.
      * The timestamp is not included in this count.
      * @alias 'data.processed_fields' */
    dataProcessedFields?: string;
    /** The number of bytes of input data posted to the anomaly detection job. */
    'data.input_bytes'?: ByteSize;
    /** The number of bytes of input data posted to the anomaly detection job.
      * @alias 'data.input_bytes' */
    dib?: ByteSize;
    /** The number of bytes of input data posted to the anomaly detection job.
      * @alias 'data.input_bytes' */
    dataInputBytes?: ByteSize;
    /** The number of input documents posted to the anomaly detection job. */
    'data.input_records'?: string;
    /** The number of input documents posted to the anomaly detection job.
      * @alias 'data.input_records' */
    dir?: string;
    /** The number of input documents posted to the anomaly detection job.
      * @alias 'data.input_records' */
    dataInputRecords?: string;
    /** The total number of fields in input documents posted to the anomaly detection job.
      * This count includes fields that are not used in the analysis.
      * However, be aware that if you are using a datafeed, it extracts only the required fields from the documents it retrieves before posting them to the job. */
    'data.input_fields'?: string;
    /** The total number of fields in input documents posted to the anomaly detection job.
      * This count includes fields that are not used in the analysis.
      * However, be aware that if you are using a datafeed, it extracts only the required fields from the documents it retrieves before posting them to the job.
      * @alias 'data.input_fields' */
    dif?: string;
    /** The total number of fields in input documents posted to the anomaly detection job.
      * This count includes fields that are not used in the analysis.
      * However, be aware that if you are using a datafeed, it extracts only the required fields from the documents it retrieves before posting them to the job.
      * @alias 'data.input_fields' */
    dataInputFields?: string;
    /** The number of input documents with either a missing date field or a date that could not be parsed. */
    'data.invalid_dates'?: string;
    /** The number of input documents with either a missing date field or a date that could not be parsed.
      * @alias 'data.invalid_dates' */
    did?: string;
    /** The number of input documents with either a missing date field or a date that could not be parsed.
      * @alias 'data.invalid_dates' */
    dataInvalidDates?: string;
    /** The number of input documents that are missing a field that the anomaly detection job is configured to analyze.
      * Input documents with missing fields are still processed because it is possible that not all fields are missing.
      * If you are using datafeeds or posting data to the job in JSON format, a high `missing_field_count` is often not an indication of data issues.
      * It is not necessarily a cause for concern. */
    'data.missing_fields'?: string;
    /** The number of input documents that are missing a field that the anomaly detection job is configured to analyze.
      * Input documents with missing fields are still processed because it is possible that not all fields are missing.
      * If you are using datafeeds or posting data to the job in JSON format, a high `missing_field_count` is often not an indication of data issues.
      * It is not necessarily a cause for concern.
      * @alias 'data.missing_fields' */
    dmf?: string;
    /** The number of input documents that are missing a field that the anomaly detection job is configured to analyze.
      * Input documents with missing fields are still processed because it is possible that not all fields are missing.
      * If you are using datafeeds or posting data to the job in JSON format, a high `missing_field_count` is often not an indication of data issues.
      * It is not necessarily a cause for concern.
      * @alias 'data.missing_fields' */
    dataMissingFields?: string;
    /** The number of input documents that have a timestamp chronologically preceding the start of the current anomaly detection bucket offset by the latency window.
      * This information is applicable only when you provide data to the anomaly detection job by using the post data API.
      * These out of order documents are discarded, since jobs require time series data to be in ascending chronological order. */
    'data.out_of_order_timestamps'?: string;
    /** The number of input documents that have a timestamp chronologically preceding the start of the current anomaly detection bucket offset by the latency window.
      * This information is applicable only when you provide data to the anomaly detection job by using the post data API.
      * These out of order documents are discarded, since jobs require time series data to be in ascending chronological order.
      * @alias 'data.out_of_order_timestamps' */
    doot?: string;
    /** The number of input documents that have a timestamp chronologically preceding the start of the current anomaly detection bucket offset by the latency window.
      * This information is applicable only when you provide data to the anomaly detection job by using the post data API.
      * These out of order documents are discarded, since jobs require time series data to be in ascending chronological order.
      * @alias 'data.out_of_order_timestamps' */
    dataOutOfOrderTimestamps?: string;
    /** The number of buckets which did not contain any data.
      * If your data contains many empty buckets, consider increasing your `bucket_span` or using functions that are tolerant to gaps in data such as mean, `non_null_sum` or `non_zero_count`. */
    'data.empty_buckets'?: string;
    /** The number of buckets which did not contain any data.
      * If your data contains many empty buckets, consider increasing your `bucket_span` or using functions that are tolerant to gaps in data such as mean, `non_null_sum` or `non_zero_count`.
      * @alias 'data.empty_buckets' */
    deb?: string;
    /** The number of buckets which did not contain any data.
      * If your data contains many empty buckets, consider increasing your `bucket_span` or using functions that are tolerant to gaps in data such as mean, `non_null_sum` or `non_zero_count`.
      * @alias 'data.empty_buckets' */
    dataEmptyBuckets?: string;
    /** The number of buckets that contained few data points compared to the expected number of data points.
      * If your data contains many sparse buckets, consider using a longer `bucket_span`. */
    'data.sparse_buckets'?: string;
    /** The number of buckets that contained few data points compared to the expected number of data points.
      * If your data contains many sparse buckets, consider using a longer `bucket_span`.
      * @alias 'data.sparse_buckets' */
    dsb?: string;
    /** The number of buckets that contained few data points compared to the expected number of data points.
      * If your data contains many sparse buckets, consider using a longer `bucket_span`.
      * @alias 'data.sparse_buckets' */
    dataSparseBuckets?: string;
    /** The total number of buckets processed. */
    'data.buckets'?: string;
    /** The total number of buckets processed.
      * @alias 'data.buckets' */
    db?: string;
    /** The total number of buckets processed.
      * @alias 'data.buckets' */
    dataBuckets?: string;
    /** The timestamp of the earliest chronologically input document. */
    'data.earliest_record'?: string;
    /** The timestamp of the earliest chronologically input document.
      * @alias 'data.earliest_record' */
    der?: string;
    /** The timestamp of the earliest chronologically input document.
      * @alias 'data.earliest_record' */
    dataEarliestRecord?: string;
    /** The timestamp of the latest chronologically input document. */
    'data.latest_record'?: string;
    /** The timestamp of the latest chronologically input document.
      * @alias 'data.latest_record' */
    dlr?: string;
    /** The timestamp of the latest chronologically input document.
      * @alias 'data.latest_record' */
    dataLatestRecord?: string;
    /** The timestamp at which data was last analyzed, according to server time. */
    'data.last'?: string;
    /** The timestamp at which data was last analyzed, according to server time.
      * @alias 'data.last' */
    dl?: string;
    /** The timestamp at which data was last analyzed, according to server time.
      * @alias 'data.last' */
    dataLast?: string;
    /** The timestamp of the last bucket that did not contain any data. */
    'data.last_empty_bucket'?: string;
    /** The timestamp of the last bucket that did not contain any data.
      * @alias 'data.last_empty_bucket' */
    dleb?: string;
    /** The timestamp of the last bucket that did not contain any data.
      * @alias 'data.last_empty_bucket' */
    dataLastEmptyBucket?: string;
    /** The timestamp of the last bucket that was considered sparse. */
    'data.last_sparse_bucket'?: string;
    /** The timestamp of the last bucket that was considered sparse.
      * @alias 'data.last_sparse_bucket' */
    dlsb?: string;
    /** The timestamp of the last bucket that was considered sparse.
      * @alias 'data.last_sparse_bucket' */
    dataLastSparseBucket?: string;
    /** The number of bytes of memory used by the models.
      * This is the maximum value since the last time the model was persisted.
      * If the job is closed, this value indicates the latest size. */
    'model.bytes'?: ByteSize;
    /** The number of bytes of memory used by the models.
      * This is the maximum value since the last time the model was persisted.
      * If the job is closed, this value indicates the latest size.
      * @alias 'model.bytes' */
    mb?: ByteSize;
    /** The number of bytes of memory used by the models.
      * This is the maximum value since the last time the model was persisted.
      * If the job is closed, this value indicates the latest size.
      * @alias 'model.bytes' */
    modelBytes?: ByteSize;
    /** The status of the mathematical models. */
    'model.memory_status'?: MlMemoryStatus;
    /** The status of the mathematical models.
      * @alias 'model.memory_status' */
    mms?: MlMemoryStatus;
    /** The status of the mathematical models.
      * @alias 'model.memory_status' */
    modelMemoryStatus?: MlMemoryStatus;
    /** The number of bytes over the high limit for memory usage at the last allocation failure. */
    'model.bytes_exceeded'?: ByteSize;
    /** The number of bytes over the high limit for memory usage at the last allocation failure.
      * @alias 'model.bytes_exceeded' */
    mbe?: ByteSize;
    /** The number of bytes over the high limit for memory usage at the last allocation failure.
      * @alias 'model.bytes_exceeded' */
    modelBytesExceeded?: ByteSize;
    /** The upper limit for model memory usage, checked on increasing values. */
    'model.memory_limit'?: string;
    /** The upper limit for model memory usage, checked on increasing values.
      * @alias 'model.memory_limit' */
    mml?: string;
    /** The upper limit for model memory usage, checked on increasing values.
      * @alias 'model.memory_limit' */
    modelMemoryLimit?: string;
    /** The number of `by` field values that were analyzed by the models.
      * This value is cumulative for all detectors in the job. */
    'model.by_fields'?: string;
    /** The number of `by` field values that were analyzed by the models.
      * This value is cumulative for all detectors in the job.
      * @alias 'model.by_fields' */
    mbf?: string;
    /** The number of `by` field values that were analyzed by the models.
      * This value is cumulative for all detectors in the job.
      * @alias 'model.by_fields' */
    modelByFields?: string;
    /** The number of `over` field values that were analyzed by the models.
      * This value is cumulative for all detectors in the job. */
    'model.over_fields'?: string;
    /** The number of `over` field values that were analyzed by the models.
      * This value is cumulative for all detectors in the job.
      * @alias 'model.over_fields' */
    mof?: string;
    /** The number of `over` field values that were analyzed by the models.
      * This value is cumulative for all detectors in the job.
      * @alias 'model.over_fields' */
    modelOverFields?: string;
    /** The number of `partition` field values that were analyzed by the models.
      * This value is cumulative for all detectors in the job. */
    'model.partition_fields'?: string;
    /** The number of `partition` field values that were analyzed by the models.
      * This value is cumulative for all detectors in the job.
      * @alias 'model.partition_fields' */
    mpf?: string;
    /** The number of `partition` field values that were analyzed by the models.
      * This value is cumulative for all detectors in the job.
      * @alias 'model.partition_fields' */
    modelPartitionFields?: string;
    /** The number of buckets for which new entities in incoming data were not processed due to insufficient model memory.
      * This situation is also signified by a `hard_limit: memory_status` property value. */
    'model.bucket_allocation_failures'?: string;
    /** The number of buckets for which new entities in incoming data were not processed due to insufficient model memory.
      * This situation is also signified by a `hard_limit: memory_status` property value.
      * @alias 'model.bucket_allocation_failures' */
    mbaf?: string;
    /** The number of buckets for which new entities in incoming data were not processed due to insufficient model memory.
      * This situation is also signified by a `hard_limit: memory_status` property value.
      * @alias 'model.bucket_allocation_failures' */
    modelBucketAllocationFailures?: string;
    /** The status of categorization for the job. */
    'model.categorization_status'?: MlCategorizationStatus;
    /** The status of categorization for the job.
      * @alias 'model.categorization_status' */
    mcs?: MlCategorizationStatus;
    /** The status of categorization for the job.
      * @alias 'model.categorization_status' */
    modelCategorizationStatus?: MlCategorizationStatus;
    /** The number of documents that have had a field categorized. */
    'model.categorized_doc_count'?: string;
    /** The number of documents that have had a field categorized.
      * @alias 'model.categorized_doc_count' */
    mcdc?: string;
    /** The number of documents that have had a field categorized.
      * @alias 'model.categorized_doc_count' */
    modelCategorizedDocCount?: string;
    /** The number of categories created by categorization. */
    'model.total_category_count'?: string;
    /** The number of categories created by categorization.
      * @alias 'model.total_category_count' */
    mtcc?: string;
    /** The number of categories created by categorization.
      * @alias 'model.total_category_count' */
    modelTotalCategoryCount?: string;
    /** The number of categories that match more than 1% of categorized documents. */
    'model.frequent_category_count'?: string;
    /** The number of categories that match more than 1% of categorized documents.
      * @alias 'model.frequent_category_count' */
    modelFrequentCategoryCount?: string;
    /** The number of categories that match just one categorized document. */
    'model.rare_category_count'?: string;
    /** The number of categories that match just one categorized document.
      * @alias 'model.rare_category_count' */
    mrcc?: string;
    /** The number of categories that match just one categorized document.
      * @alias 'model.rare_category_count' */
    modelRareCategoryCount?: string;
    /** The number of categories created by categorization that will never be assigned again because another category’s definition makes it a superset of the dead category.
      * Dead categories are a side effect of the way categorization has no prior training. */
    'model.dead_category_count'?: string;
    /** The number of categories created by categorization that will never be assigned again because another category’s definition makes it a superset of the dead category.
      * Dead categories are a side effect of the way categorization has no prior training.
      * @alias 'model.dead_category_count' */
    mdcc?: string;
    /** The number of categories created by categorization that will never be assigned again because another category’s definition makes it a superset of the dead category.
      * Dead categories are a side effect of the way categorization has no prior training.
      * @alias 'model.dead_category_count' */
    modelDeadCategoryCount?: string;
    /** The number of times that categorization wanted to create a new category but couldn’t because the job had hit its `model_memory_limit`.
      * This count does not track which specific categories failed to be created.
      * Therefore you cannot use this value to determine the number of unique categories that were missed. */
    'model.failed_category_count'?: string;
    /** The number of times that categorization wanted to create a new category but couldn’t because the job had hit its `model_memory_limit`.
      * This count does not track which specific categories failed to be created.
      * Therefore you cannot use this value to determine the number of unique categories that were missed.
      * @alias 'model.failed_category_count' */
    mfcc?: string;
    /** The number of times that categorization wanted to create a new category but couldn’t because the job had hit its `model_memory_limit`.
      * This count does not track which specific categories failed to be created.
      * Therefore you cannot use this value to determine the number of unique categories that were missed.
      * @alias 'model.failed_category_count' */
    modelFailedCategoryCount?: string;
    /** The timestamp when the model stats were gathered, according to server time. */
    'model.log_time'?: string;
    /** The timestamp when the model stats were gathered, according to server time.
      * @alias 'model.log_time' */
    mlt?: string;
    /** The timestamp when the model stats were gathered, according to server time.
      * @alias 'model.log_time' */
    modelLogTime?: string;
    /** The timestamp of the last record when the model stats were gathered. */
    'model.timestamp'?: string;
    /** The timestamp of the last record when the model stats were gathered.
      * @alias 'model.timestamp' */
    mt?: string;
    /** The timestamp of the last record when the model stats were gathered.
      * @alias 'model.timestamp' */
    modelTimestamp?: string;
    /** The number of individual forecasts currently available for the job.
      * A value of one or more indicates that forecasts exist. */
    'forecasts.total'?: string;
    /** The number of individual forecasts currently available for the job.
      * A value of one or more indicates that forecasts exist.
      * @alias 'forecasts.total' */
    ft?: string;
    /** The number of individual forecasts currently available for the job.
      * A value of one or more indicates that forecasts exist.
      * @alias 'forecasts.total' */
    forecastsTotal?: string;
    /** The minimum memory usage in bytes for forecasts related to the anomaly detection job. */
    'forecasts.memory.min'?: string;
    /** The minimum memory usage in bytes for forecasts related to the anomaly detection job.
      * @alias 'forecasts.memory.min' */
    fmmin?: string;
    /** The minimum memory usage in bytes for forecasts related to the anomaly detection job.
      * @alias 'forecasts.memory.min' */
    forecastsMemoryMin?: string;
    /** The maximum memory usage in bytes for forecasts related to the anomaly detection job. */
    'forecasts.memory.max'?: string;
    /** The maximum memory usage in bytes for forecasts related to the anomaly detection job.
      * @alias 'forecasts.memory.max' */
    fmmax?: string;
    /** The maximum memory usage in bytes for forecasts related to the anomaly detection job.
      * @alias 'forecasts.memory.max' */
    forecastsMemoryMax?: string;
    /** The average memory usage in bytes for forecasts related to the anomaly detection job. */
    'forecasts.memory.avg'?: string;
    /** The average memory usage in bytes for forecasts related to the anomaly detection job.
      * @alias 'forecasts.memory.avg' */
    fmavg?: string;
    /** The average memory usage in bytes for forecasts related to the anomaly detection job.
      * @alias 'forecasts.memory.avg' */
    forecastsMemoryAvg?: string;
    /** The total memory usage in bytes for forecasts related to the anomaly detection job. */
    'forecasts.memory.total'?: string;
    /** The total memory usage in bytes for forecasts related to the anomaly detection job.
      * @alias 'forecasts.memory.total' */
    fmt?: string;
    /** The total memory usage in bytes for forecasts related to the anomaly detection job.
      * @alias 'forecasts.memory.total' */
    forecastsMemoryTotal?: string;
    /** The minimum number of `model_forecast` documents written for forecasts related to the anomaly detection job. */
    'forecasts.records.min'?: string;
    /** The minimum number of `model_forecast` documents written for forecasts related to the anomaly detection job.
      * @alias 'forecasts.records.min' */
    frmin?: string;
    /** The minimum number of `model_forecast` documents written for forecasts related to the anomaly detection job.
      * @alias 'forecasts.records.min' */
    forecastsRecordsMin?: string;
    /** The maximum number of `model_forecast` documents written for forecasts related to the anomaly detection job. */
    'forecasts.records.max'?: string;
    /** The maximum number of `model_forecast` documents written for forecasts related to the anomaly detection job.
      * @alias 'forecasts.records.max' */
    frmax?: string;
    /** The maximum number of `model_forecast` documents written for forecasts related to the anomaly detection job.
      * @alias 'forecasts.records.max' */
    forecastsRecordsMax?: string;
    /** The average number of `model_forecast` documents written for forecasts related to the anomaly detection job. */
    'forecasts.records.avg'?: string;
    /** The average number of `model_forecast` documents written for forecasts related to the anomaly detection job.
      * @alias 'forecasts.records.avg' */
    fravg?: string;
    /** The average number of `model_forecast` documents written for forecasts related to the anomaly detection job.
      * @alias 'forecasts.records.avg' */
    forecastsRecordsAvg?: string;
    /** The total number of `model_forecast` documents written for forecasts related to the anomaly detection job. */
    'forecasts.records.total'?: string;
    /** The total number of `model_forecast` documents written for forecasts related to the anomaly detection job.
      * @alias 'forecasts.records.total' */
    frt?: string;
    /** The total number of `model_forecast` documents written for forecasts related to the anomaly detection job.
      * @alias 'forecasts.records.total' */
    forecastsRecordsTotal?: string;
    /** The minimum runtime in milliseconds for forecasts related to the anomaly detection job. */
    'forecasts.time.min'?: string;
    /** The minimum runtime in milliseconds for forecasts related to the anomaly detection job.
      * @alias 'forecasts.time.min' */
    ftmin?: string;
    /** The minimum runtime in milliseconds for forecasts related to the anomaly detection job.
      * @alias 'forecasts.time.min' */
    forecastsTimeMin?: string;
    /** The maximum runtime in milliseconds for forecasts related to the anomaly detection job. */
    'forecasts.time.max'?: string;
    /** The maximum runtime in milliseconds for forecasts related to the anomaly detection job.
      * @alias 'forecasts.time.max' */
    ftmax?: string;
    /** The maximum runtime in milliseconds for forecasts related to the anomaly detection job.
      * @alias 'forecasts.time.max' */
    forecastsTimeMax?: string;
    /** The average runtime in milliseconds for forecasts related to the anomaly detection job. */
    'forecasts.time.avg'?: string;
    /** The average runtime in milliseconds for forecasts related to the anomaly detection job.
      * @alias 'forecasts.time.avg' */
    ftavg?: string;
    /** The average runtime in milliseconds for forecasts related to the anomaly detection job.
      * @alias 'forecasts.time.avg' */
    forecastsTimeAvg?: string;
    /** The total runtime in milliseconds for forecasts related to the anomaly detection job. */
    'forecasts.time.total'?: string;
    /** The total runtime in milliseconds for forecasts related to the anomaly detection job.
      * @alias 'forecasts.time.total' */
    ftt?: string;
    /** The total runtime in milliseconds for forecasts related to the anomaly detection job.
      * @alias 'forecasts.time.total' */
    forecastsTimeTotal?: string;
    /** The uniqe identifier of the assigned node. */
    'node.id'?: NodeId;
    /** The uniqe identifier of the assigned node.
      * @alias 'node.id' */
    ni?: NodeId;
    /** The uniqe identifier of the assigned node.
      * @alias 'node.id' */
    nodeId?: NodeId;
    /** The name of the assigned node. */
    'node.name'?: string;
    /** The name of the assigned node.
      * @alias 'node.name' */
    nn?: string;
    /** The name of the assigned node.
      * @alias 'node.name' */
    nodeName?: string;
    /** The ephemeral identifier of the assigned node. */
    'node.ephemeral_id'?: NodeId;
    /** The ephemeral identifier of the assigned node.
      * @alias 'node.ephemeral_id' */
    ne?: NodeId;
    /** The ephemeral identifier of the assigned node.
      * @alias 'node.ephemeral_id' */
    nodeEphemeralId?: NodeId;
    /** The network address of the assigned node. */
    'node.address'?: string;
    /** The network address of the assigned node.
      * @alias 'node.address' */
    na?: string;
    /** The network address of the assigned node.
      * @alias 'node.address' */
    nodeAddress?: string;
    /** The number of bucket results produced by the job. */
    'buckets.count'?: string;
    /** The number of bucket results produced by the job.
      * @alias 'buckets.count' */
    bc?: string;
    /** The number of bucket results produced by the job.
      * @alias 'buckets.count' */
    bucketsCount?: string;
    /** The sum of all bucket processing times, in milliseconds. */
    'buckets.time.total'?: string;
    /** The sum of all bucket processing times, in milliseconds.
      * @alias 'buckets.time.total' */
    btt?: string;
    /** The sum of all bucket processing times, in milliseconds.
      * @alias 'buckets.time.total' */
    bucketsTimeTotal?: string;
    /** The minimum of all bucket processing times, in milliseconds. */
    'buckets.time.min'?: string;
    /** The minimum of all bucket processing times, in milliseconds.
      * @alias 'buckets.time.min' */
    btmin?: string;
    /** The minimum of all bucket processing times, in milliseconds.
      * @alias 'buckets.time.min' */
    bucketsTimeMin?: string;
    /** The maximum of all bucket processing times, in milliseconds. */
    'buckets.time.max'?: string;
    /** The maximum of all bucket processing times, in milliseconds.
      * @alias 'buckets.time.max' */
    btmax?: string;
    /** The maximum of all bucket processing times, in milliseconds.
      * @alias 'buckets.time.max' */
    bucketsTimeMax?: string;
    /** The exponential moving average of all bucket processing times, in milliseconds. */
    'buckets.time.exp_avg'?: string;
    /** The exponential moving average of all bucket processing times, in milliseconds.
      * @alias 'buckets.time.exp_avg' */
    btea?: string;
    /** The exponential moving average of all bucket processing times, in milliseconds.
      * @alias 'buckets.time.exp_avg' */
    bucketsTimeExpAvg?: string;
    /** The exponential moving average of bucket processing times calculated in a one hour time window, in milliseconds. */
    'buckets.time.exp_avg_hour'?: string;
    /** The exponential moving average of bucket processing times calculated in a one hour time window, in milliseconds.
      * @alias 'buckets.time.exp_avg_hour' */
    bteah?: string;
    /** The exponential moving average of bucket processing times calculated in a one hour time window, in milliseconds.
      * @alias 'buckets.time.exp_avg_hour' */
    bucketsTimeExpAvgHour?: string;
}
export interface CatMlJobsRequest extends CatCatRequestBase {
    /** Identifier for the anomaly detection job. */
    job_id?: Id;
    /** Specifies what to do when the request:
      *
      * * Contains wildcard expressions and there are no jobs that match.
      * * Contains the `_all` string or no identifiers and there are no matches.
      * * Contains wildcard expressions and there are only partial matches.
      *
      * If `true`, the API returns an empty jobs array when there are no matches and the subset of results when there
      * are partial matches. If `false`, the API returns a 404 status code when there are no matches or only partial
      * matches. */
    allow_no_match?: boolean;
    /** The unit used to display byte values. */
    bytes?: Bytes;
    /** Comma-separated list of column names to display. */
    h?: CatCatAnonalyDetectorColumns;
    /** Comma-separated list of column names or column aliases used to sort the response. */
    s?: CatCatAnonalyDetectorColumns;
    /** The unit used to display time values. */
    time?: TimeUnit;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        job_id?: never;
        allow_no_match?: never;
        bytes?: never;
        h?: never;
        s?: never;
        time?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        job_id?: never;
        allow_no_match?: never;
        bytes?: never;
        h?: never;
        s?: never;
        time?: never;
    };
}
export type CatMlJobsResponse = CatMlJobsJobsRecord[];
export interface CatMlTrainedModelsRequest extends CatCatRequestBase {
    /** A unique identifier for the trained model. */
    model_id?: Id;
    /** Specifies what to do when the request: contains wildcard expressions and there are no models that match; contains the `_all` string or no identifiers and there are no matches; contains wildcard expressions and there are only partial matches.
      * If `true`, the API returns an empty array when there are no matches and the subset of results when there are partial matches.
      * If `false`, the API returns a 404 status code when there are no matches or only partial matches. */
    allow_no_match?: boolean;
    /** The unit used to display byte values. */
    bytes?: Bytes;
    /** A comma-separated list of column names to display. */
    h?: CatCatTrainedModelsColumns;
    /** A comma-separated list of column names or aliases used to sort the response. */
    s?: CatCatTrainedModelsColumns;
    /** Skips the specified number of transforms. */
    from?: integer;
    /** The maximum number of transforms to display. */
    size?: integer;
    /** Unit used to display time values. */
    time?: TimeUnit;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        model_id?: never;
        allow_no_match?: never;
        bytes?: never;
        h?: never;
        s?: never;
        from?: never;
        size?: never;
        time?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        model_id?: never;
        allow_no_match?: never;
        bytes?: never;
        h?: never;
        s?: never;
        from?: never;
        size?: never;
        time?: never;
    };
}
export type CatMlTrainedModelsResponse = CatMlTrainedModelsTrainedModelsRecord[];
export interface CatMlTrainedModelsTrainedModelsRecord {
    /** The model identifier. */
    id?: Id;
    /** Information about the creator of the model. */
    created_by?: string;
    /** Information about the creator of the model.
      * @alias created_by */
    c?: string;
    /** Information about the creator of the model.
      * @alias created_by */
    createdBy?: string;
    /** The estimated heap size to keep the model in memory. */
    heap_size?: ByteSize;
    /** The estimated heap size to keep the model in memory.
      * @alias heap_size */
    hs?: ByteSize;
    /** The estimated heap size to keep the model in memory.
      * @alias heap_size */
    modelHeapSize?: ByteSize;
    /** The estimated number of operations to use the model.
      * This number helps to measure the computational complexity of the model. */
    operations?: string;
    /** The estimated number of operations to use the model.
      * This number helps to measure the computational complexity of the model.
      * @alias operations */
    o?: string;
    /** The estimated number of operations to use the model.
      * This number helps to measure the computational complexity of the model.
      * @alias operations */
    modelOperations?: string;
    /** The license level of the model. */
    license?: string;
    /** The license level of the model.
      * @alias license */
    l?: string;
    /** The time the model was created. */
    create_time?: DateTime;
    /** The time the model was created.
      * @alias create_time */
    ct?: DateTime;
    /** The version of Elasticsearch when the model was created. */
    version?: VersionString;
    /** The version of Elasticsearch when the model was created.
      * @alias version */
    v?: VersionString;
    /** A description of the model. */
    description?: string;
    /** A description of the model.
      * @alias description */
    d?: string;
    /** The number of pipelines that are referencing the model. */
    'ingest.pipelines'?: string;
    /** The number of pipelines that are referencing the model.
      * @alias 'ingest.pipelines' */
    ip?: string;
    /** The number of pipelines that are referencing the model.
      * @alias 'ingest.pipelines' */
    ingestPipelines?: string;
    /** The total number of documents that are processed by the model. */
    'ingest.count'?: string;
    /** The total number of documents that are processed by the model.
      * @alias 'ingest.count' */
    ic?: string;
    /** The total number of documents that are processed by the model.
      * @alias 'ingest.count' */
    ingestCount?: string;
    /** The total time spent processing documents with thie model. */
    'ingest.time'?: string;
    /** The total time spent processing documents with thie model.
      * @alias 'ingest.time' */
    it?: string;
    /** The total time spent processing documents with thie model.
      * @alias 'ingest.time' */
    ingestTime?: string;
    /** The total number of documents that are currently being handled by the model. */
    'ingest.current'?: string;
    /** The total number of documents that are currently being handled by the model.
      * @alias 'ingest.current' */
    icurr?: string;
    /** The total number of documents that are currently being handled by the model.
      * @alias 'ingest.current' */
    ingestCurrent?: string;
    /** The total number of failed ingest attempts with the model. */
    'ingest.failed'?: string;
    /** The total number of failed ingest attempts with the model.
      * @alias 'ingest.failed' */
    if?: string;
    /** The total number of failed ingest attempts with the model.
      * @alias 'ingest.failed' */
    ingestFailed?: string;
    /** The identifier for the data frame analytics job that created the model.
      * Only displayed if the job is still available. */
    'data_frame.id'?: string;
    /** The identifier for the data frame analytics job that created the model.
      * Only displayed if the job is still available.
      * @alias 'data_frame.id' */
    dfid?: string;
    /** The identifier for the data frame analytics job that created the model.
      * Only displayed if the job is still available.
      * @alias 'data_frame.id' */
    dataFrameAnalytics?: string;
    /** The time the data frame analytics job was created. */
    'data_frame.create_time'?: string;
    /** The time the data frame analytics job was created.
      * @alias 'data_frame.create_time' */
    dft?: string;
    /** The time the data frame analytics job was created.
      * @alias 'data_frame.create_time' */
    dataFrameAnalyticsTime?: string;
    /** The source index used to train in the data frame analysis. */
    'data_frame.source_index'?: string;
    /** The source index used to train in the data frame analysis.
      * @alias 'data_frame.source_index' */
    dfsi?: string;
    /** The source index used to train in the data frame analysis.
      * @alias 'data_frame.source_index' */
    dataFrameAnalyticsSrcIndex?: string;
    /** The analysis used by the data frame to build the model. */
    'data_frame.analysis'?: string;
    /** The analysis used by the data frame to build the model.
      * @alias 'data_frame.analysis' */
    dfa?: string;
    /** The analysis used by the data frame to build the model.
      * @alias 'data_frame.analysis' */
    dataFrameAnalyticsAnalysis?: string;
    type?: string;
}
export interface CatNodeattrsNodeAttributesRecord {
    /** The node name. */
    node?: string;
    /** The unique node identifier. */
    id?: string;
    /** The process identifier. */
    pid?: string;
    /** The host name. */
    host?: string;
    /** The host name.
      * @alias host */
    h?: string;
    /** The IP address. */
    ip?: string;
    /** The IP address.
      * @alias ip */
    i?: string;
    /** The bound transport port. */
    port?: string;
    /** The attribute name. */
    attr?: string;
    /** The attribute value. */
    value?: string;
}
export interface CatNodeattrsRequest extends CatCatRequestBase {
    /** List of columns to appear in the response. Supports simple wildcards. */
    h?: Names;
    /** List of columns that determine how the table should be sorted.
      * Sorting defaults to ascending and can be changed by setting `:asc`
      * or `:desc` as a suffix to the column name. */
    s?: Names;
    /** If `true`, the request computes the list of selected nodes from the
      * local cluster state. If `false` the list of selected nodes are computed
      * from the cluster state of the master node. In both cases the coordinating
      * node will send requests for further information to each selected node. */
    local?: boolean;
    /** Period to wait for a connection to the master node. */
    master_timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        h?: never;
        s?: never;
        local?: never;
        master_timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        h?: never;
        s?: never;
        local?: never;
        master_timeout?: never;
    };
}
export type CatNodeattrsResponse = CatNodeattrsNodeAttributesRecord[];
export interface CatNodesNodesRecord {
    /** The unique node identifier. */
    id?: Id;
    /** The unique node identifier.
      * @alias id */
    nodeId?: Id;
    /** The process identifier. */
    pid?: string;
    /** The process identifier.
      * @alias pid */
    p?: string;
    /** The IP address. */
    ip?: string;
    /** The IP address.
      * @alias ip */
    i?: string;
    /** The bound transport port. */
    port?: string;
    /** The bound transport port.
      * @alias port */
    po?: string;
    /** The bound HTTP address. */
    http_address?: string;
    /** The bound HTTP address.
      * @alias http_address */
    http?: string;
    /** The Elasticsearch version. */
    version?: VersionString;
    /** The Elasticsearch version.
      * @alias version */
    v?: VersionString;
    /** The Elasticsearch distribution flavor. */
    flavor?: string;
    /** The Elasticsearch distribution flavor.
      * @alias flavor */
    f?: string;
    /** The Elasticsearch distribution type. */
    type?: string;
    /** The Elasticsearch distribution type.
      * @alias type */
    t?: string;
    /** The Elasticsearch build hash. */
    build?: string;
    /** The Elasticsearch build hash.
      * @alias build */
    b?: string;
    /** The Java version. */
    jdk?: string;
    /** The Java version.
      * @alias jdk */
    j?: string;
    /** The total disk space. */
    'disk.total'?: ByteSize;
    /** The total disk space.
      * @alias 'disk.total' */
    dt?: ByteSize;
    /** The total disk space.
      * @alias 'disk.total' */
    diskTotal?: ByteSize;
    /** The used disk space. */
    'disk.used'?: ByteSize;
    /** The used disk space.
      * @alias 'disk.used' */
    du?: ByteSize;
    /** The used disk space.
      * @alias 'disk.used' */
    diskUsed?: ByteSize;
    /** The available disk space. */
    'disk.avail'?: ByteSize;
    /** The available disk space.
      * @alias 'disk.avail' */
    d?: ByteSize;
    /** The available disk space.
      * @alias 'disk.avail' */
    da?: ByteSize;
    /** The available disk space.
      * @alias 'disk.avail' */
    disk?: ByteSize;
    /** The available disk space.
      * @alias 'disk.avail' */
    diskAvail?: ByteSize;
    /** The used disk space percentage. */
    'disk.used_percent'?: Percentage;
    /** The used disk space percentage.
      * @alias 'disk.used_percent' */
    dup?: Percentage;
    /** The used disk space percentage.
      * @alias 'disk.used_percent' */
    diskUsedPercent?: Percentage;
    /** The used heap. */
    'heap.current'?: string;
    /** The used heap.
      * @alias 'heap.current' */
    hc?: string;
    /** The used heap.
      * @alias 'heap.current' */
    heapCurrent?: string;
    /** The used heap ratio. */
    'heap.percent'?: Percentage;
    /** The used heap ratio.
      * @alias 'heap.percent' */
    hp?: Percentage;
    /** The used heap ratio.
      * @alias 'heap.percent' */
    heapPercent?: Percentage;
    /** The maximum configured heap. */
    'heap.max'?: string;
    /** The maximum configured heap.
      * @alias 'heap.max' */
    hm?: string;
    /** The maximum configured heap.
      * @alias 'heap.max' */
    heapMax?: string;
    /** The used machine memory. */
    'ram.current'?: string;
    /** The used machine memory.
      * @alias 'ram.current' */
    rc?: string;
    /** The used machine memory.
      * @alias 'ram.current' */
    ramCurrent?: string;
    /** The used machine memory ratio. */
    'ram.percent'?: Percentage;
    /** The used machine memory ratio.
      * @alias 'ram.percent' */
    rp?: Percentage;
    /** The used machine memory ratio.
      * @alias 'ram.percent' */
    ramPercent?: Percentage;
    /** The total machine memory. */
    'ram.max'?: string;
    /** The total machine memory.
      * @alias 'ram.max' */
    rn?: string;
    /** The total machine memory.
      * @alias 'ram.max' */
    ramMax?: string;
    /** The used file descriptors. */
    'file_desc.current'?: string;
    /** The used file descriptors.
      * @alias 'file_desc.current' */
    fdc?: string;
    /** The used file descriptors.
      * @alias 'file_desc.current' */
    fileDescriptorCurrent?: string;
    /** The used file descriptor ratio. */
    'file_desc.percent'?: Percentage;
    /** The used file descriptor ratio.
      * @alias 'file_desc.percent' */
    fdp?: Percentage;
    /** The used file descriptor ratio.
      * @alias 'file_desc.percent' */
    fileDescriptorPercent?: Percentage;
    /** The maximum number of file descriptors. */
    'file_desc.max'?: string;
    /** The maximum number of file descriptors.
      * @alias 'file_desc.max' */
    fdm?: string;
    /** The maximum number of file descriptors.
      * @alias 'file_desc.max' */
    fileDescriptorMax?: string;
    /** The recent system CPU usage as a percentage. */
    cpu?: string;
    /** The load average for the most recent minute. */
    load_1m?: string;
    /** The load average for the last five minutes. */
    load_5m?: string;
    /** The load average for the last fifteen minutes. */
    load_15m?: string;
    /** The load average for the last fifteen minutes.
      * @alias load_15m */
    l?: string;
    /** The node uptime. */
    uptime?: string;
    /** The node uptime.
      * @alias uptime */
    u?: string;
    /** The roles of the node.
      * Returned values include `c`(cold node), `d`(data node), `f`(frozen node), `h`(hot node), `i`(ingest node), `l`(machine learning node), `m` (master eligible node), `r`(remote cluster client node), `s`(content node), `t`(transform node), `v`(voting-only node), `w`(warm node),and `-`(coordinating node only). */
    'node.role'?: string;
    /** The roles of the node.
      * Returned values include `c`(cold node), `d`(data node), `f`(frozen node), `h`(hot node), `i`(ingest node), `l`(machine learning node), `m` (master eligible node), `r`(remote cluster client node), `s`(content node), `t`(transform node), `v`(voting-only node), `w`(warm node),and `-`(coordinating node only).
      * @alias 'node.role' */
    r?: string;
    /** The roles of the node.
      * Returned values include `c`(cold node), `d`(data node), `f`(frozen node), `h`(hot node), `i`(ingest node), `l`(machine learning node), `m` (master eligible node), `r`(remote cluster client node), `s`(content node), `t`(transform node), `v`(voting-only node), `w`(warm node),and `-`(coordinating node only).
      * @alias 'node.role' */
    role?: string;
    /** The roles of the node.
      * Returned values include `c`(cold node), `d`(data node), `f`(frozen node), `h`(hot node), `i`(ingest node), `l`(machine learning node), `m` (master eligible node), `r`(remote cluster client node), `s`(content node), `t`(transform node), `v`(voting-only node), `w`(warm node),and `-`(coordinating node only).
      * @alias 'node.role' */
    nodeRole?: string;
    /** Indicates whether the node is the elected master node.
      * Returned values include `*`(elected master) and `-`(not elected master). */
    master?: string;
    /** Indicates whether the node is the elected master node.
      * Returned values include `*`(elected master) and `-`(not elected master).
      * @alias master */
    m?: string;
    /** The node name. */
    name?: Name;
    /** The node name.
      * @alias name */
    n?: Name;
    /** The size of completion. */
    'completion.size'?: string;
    /** The size of completion.
      * @alias 'completion.size' */
    cs?: string;
    /** The size of completion.
      * @alias 'completion.size' */
    completionSize?: string;
    /** The used fielddata cache. */
    'fielddata.memory_size'?: string;
    /** The used fielddata cache.
      * @alias 'fielddata.memory_size' */
    fm?: string;
    /** The used fielddata cache.
      * @alias 'fielddata.memory_size' */
    fielddataMemory?: string;
    /** The fielddata evictions. */
    'fielddata.evictions'?: string;
    /** The fielddata evictions.
      * @alias 'fielddata.evictions' */
    fe?: string;
    /** The fielddata evictions.
      * @alias 'fielddata.evictions' */
    fielddataEvictions?: string;
    /** The used query cache. */
    'query_cache.memory_size'?: string;
    /** The used query cache.
      * @alias 'query_cache.memory_size' */
    qcm?: string;
    /** The used query cache.
      * @alias 'query_cache.memory_size' */
    queryCacheMemory?: string;
    /** The query cache evictions. */
    'query_cache.evictions'?: string;
    /** The query cache evictions.
      * @alias 'query_cache.evictions' */
    qce?: string;
    /** The query cache evictions.
      * @alias 'query_cache.evictions' */
    queryCacheEvictions?: string;
    /** The query cache hit counts. */
    'query_cache.hit_count'?: string;
    /** The query cache hit counts.
      * @alias 'query_cache.hit_count' */
    qchc?: string;
    /** The query cache hit counts.
      * @alias 'query_cache.hit_count' */
    queryCacheHitCount?: string;
    /** The query cache miss counts. */
    'query_cache.miss_count'?: string;
    /** The query cache miss counts.
      * @alias 'query_cache.miss_count' */
    qcmc?: string;
    /** The query cache miss counts.
      * @alias 'query_cache.miss_count' */
    queryCacheMissCount?: string;
    /** The used request cache. */
    'request_cache.memory_size'?: string;
    /** The used request cache.
      * @alias 'request_cache.memory_size' */
    rcm?: string;
    /** The used request cache.
      * @alias 'request_cache.memory_size' */
    requestCacheMemory?: string;
    /** The request cache evictions. */
    'request_cache.evictions'?: string;
    /** The request cache evictions.
      * @alias 'request_cache.evictions' */
    rce?: string;
    /** The request cache evictions.
      * @alias 'request_cache.evictions' */
    requestCacheEvictions?: string;
    /** The request cache hit counts. */
    'request_cache.hit_count'?: string;
    /** The request cache hit counts.
      * @alias 'request_cache.hit_count' */
    rchc?: string;
    /** The request cache hit counts.
      * @alias 'request_cache.hit_count' */
    requestCacheHitCount?: string;
    /** The request cache miss counts. */
    'request_cache.miss_count'?: string;
    /** The request cache miss counts.
      * @alias 'request_cache.miss_count' */
    rcmc?: string;
    /** The request cache miss counts.
      * @alias 'request_cache.miss_count' */
    requestCacheMissCount?: string;
    /** The number of flushes. */
    'flush.total'?: string;
    /** The number of flushes.
      * @alias 'flush.total' */
    ft?: string;
    /** The number of flushes.
      * @alias 'flush.total' */
    flushTotal?: string;
    /** The time spent in flush. */
    'flush.total_time'?: string;
    /** The time spent in flush.
      * @alias 'flush.total_time' */
    ftt?: string;
    /** The time spent in flush.
      * @alias 'flush.total_time' */
    flushTotalTime?: string;
    /** The number of current get ops. */
    'get.current'?: string;
    /** The number of current get ops.
      * @alias 'get.current' */
    gc?: string;
    /** The number of current get ops.
      * @alias 'get.current' */
    getCurrent?: string;
    /** The time spent in get. */
    'get.time'?: string;
    /** The time spent in get.
      * @alias 'get.time' */
    gti?: string;
    /** The time spent in get.
      * @alias 'get.time' */
    getTime?: string;
    /** The number of get ops. */
    'get.total'?: string;
    /** The number of get ops.
      * @alias 'get.total' */
    gto?: string;
    /** The number of get ops.
      * @alias 'get.total' */
    getTotal?: string;
    /** The time spent in successful gets. */
    'get.exists_time'?: string;
    /** The time spent in successful gets.
      * @alias 'get.exists_time' */
    geti?: string;
    /** The time spent in successful gets.
      * @alias 'get.exists_time' */
    getExistsTime?: string;
    /** The number of successful get operations. */
    'get.exists_total'?: string;
    /** The number of successful get operations.
      * @alias 'get.exists_total' */
    geto?: string;
    /** The number of successful get operations.
      * @alias 'get.exists_total' */
    getExistsTotal?: string;
    /** The time spent in failed gets. */
    'get.missing_time'?: string;
    /** The time spent in failed gets.
      * @alias 'get.missing_time' */
    gmti?: string;
    /** The time spent in failed gets.
      * @alias 'get.missing_time' */
    getMissingTime?: string;
    /** The number of failed gets. */
    'get.missing_total'?: string;
    /** The number of failed gets.
      * @alias 'get.missing_total' */
    gmto?: string;
    /** The number of failed gets.
      * @alias 'get.missing_total' */
    getMissingTotal?: string;
    /** The number of current deletions. */
    'indexing.delete_current'?: string;
    /** The number of current deletions.
      * @alias 'indexing.delete_current' */
    idc?: string;
    /** The number of current deletions.
      * @alias 'indexing.delete_current' */
    indexingDeleteCurrent?: string;
    /** The time spent in deletions. */
    'indexing.delete_time'?: string;
    /** The time spent in deletions.
      * @alias 'indexing.delete_time' */
    idti?: string;
    /** The time spent in deletions.
      * @alias 'indexing.delete_time' */
    indexingDeleteTime?: string;
    /** The number of delete operations. */
    'indexing.delete_total'?: string;
    /** The number of delete operations.
      * @alias 'indexing.delete_total' */
    idto?: string;
    /** The number of delete operations.
      * @alias 'indexing.delete_total' */
    indexingDeleteTotal?: string;
    /** The number of current indexing operations. */
    'indexing.index_current'?: string;
    /** The number of current indexing operations.
      * @alias 'indexing.index_current' */
    iic?: string;
    /** The number of current indexing operations.
      * @alias 'indexing.index_current' */
    indexingIndexCurrent?: string;
    /** The time spent in indexing. */
    'indexing.index_time'?: string;
    /** The time spent in indexing.
      * @alias 'indexing.index_time' */
    iiti?: string;
    /** The time spent in indexing.
      * @alias 'indexing.index_time' */
    indexingIndexTime?: string;
    /** The number of indexing operations. */
    'indexing.index_total'?: string;
    /** The number of indexing operations.
      * @alias 'indexing.index_total' */
    iito?: string;
    /** The number of indexing operations.
      * @alias 'indexing.index_total' */
    indexingIndexTotal?: string;
    /** The number of failed indexing operations. */
    'indexing.index_failed'?: string;
    /** The number of failed indexing operations.
      * @alias 'indexing.index_failed' */
    iif?: string;
    /** The number of failed indexing operations.
      * @alias 'indexing.index_failed' */
    indexingIndexFailed?: string;
    /** The number of current merges. */
    'merges.current'?: string;
    /** The number of current merges.
      * @alias 'merges.current' */
    mc?: string;
    /** The number of current merges.
      * @alias 'merges.current' */
    mergesCurrent?: string;
    /** The number of current merging docs. */
    'merges.current_docs'?: string;
    /** The number of current merging docs.
      * @alias 'merges.current_docs' */
    mcd?: string;
    /** The number of current merging docs.
      * @alias 'merges.current_docs' */
    mergesCurrentDocs?: string;
    /** The size of current merges. */
    'merges.current_size'?: string;
    /** The size of current merges.
      * @alias 'merges.current_size' */
    mcs?: string;
    /** The size of current merges.
      * @alias 'merges.current_size' */
    mergesCurrentSize?: string;
    /** The number of completed merge operations. */
    'merges.total'?: string;
    /** The number of completed merge operations.
      * @alias 'merges.total' */
    mt?: string;
    /** The number of completed merge operations.
      * @alias 'merges.total' */
    mergesTotal?: string;
    /** The docs merged. */
    'merges.total_docs'?: string;
    /** The docs merged.
      * @alias 'merges.total_docs' */
    mtd?: string;
    /** The docs merged.
      * @alias 'merges.total_docs' */
    mergesTotalDocs?: string;
    /** The size merged. */
    'merges.total_size'?: string;
    /** The size merged.
      * @alias 'merges.total_size' */
    mts?: string;
    /** The size merged.
      * @alias 'merges.total_size' */
    mergesTotalSize?: string;
    /** The time spent in merges. */
    'merges.total_time'?: string;
    /** The time spent in merges.
      * @alias 'merges.total_time' */
    mtt?: string;
    /** The time spent in merges.
      * @alias 'merges.total_time' */
    mergesTotalTime?: string;
    /** The total refreshes. */
    'refresh.total'?: string;
    /** The time spent in refreshes. */
    'refresh.time'?: string;
    /** The total external refreshes. */
    'refresh.external_total'?: string;
    /** The total external refreshes.
      * @alias 'refresh.external_total' */
    rto?: string;
    /** The total external refreshes.
      * @alias 'refresh.external_total' */
    refreshTotal?: string;
    /** The time spent in external refreshes. */
    'refresh.external_time'?: string;
    /** The time spent in external refreshes.
      * @alias 'refresh.external_time' */
    rti?: string;
    /** The time spent in external refreshes.
      * @alias 'refresh.external_time' */
    refreshTime?: string;
    /** The number of pending refresh listeners. */
    'refresh.listeners'?: string;
    /** The number of pending refresh listeners.
      * @alias 'refresh.listeners' */
    rli?: string;
    /** The number of pending refresh listeners.
      * @alias 'refresh.listeners' */
    refreshListeners?: string;
    /** The total script compilations. */
    'script.compilations'?: string;
    /** The total script compilations.
      * @alias 'script.compilations' */
    scrcc?: string;
    /** The total script compilations.
      * @alias 'script.compilations' */
    scriptCompilations?: string;
    /** The total compiled scripts evicted from the cache. */
    'script.cache_evictions'?: string;
    /** The total compiled scripts evicted from the cache.
      * @alias 'script.cache_evictions' */
    scrce?: string;
    /** The total compiled scripts evicted from the cache.
      * @alias 'script.cache_evictions' */
    scriptCacheEvictions?: string;
    /** The script cache compilation limit triggered. */
    'script.compilation_limit_triggered'?: string;
    /** The script cache compilation limit triggered.
      * @alias 'script.compilation_limit_triggered' */
    scrclt?: string;
    /** The script cache compilation limit triggered.
      * @alias 'script.compilation_limit_triggered' */
    scriptCacheCompilationLimitTriggered?: string;
    /** The current fetch phase operations. */
    'search.fetch_current'?: string;
    /** The current fetch phase operations.
      * @alias 'search.fetch_current' */
    sfc?: string;
    /** The current fetch phase operations.
      * @alias 'search.fetch_current' */
    searchFetchCurrent?: string;
    /** The time spent in fetch phase. */
    'search.fetch_time'?: string;
    /** The time spent in fetch phase.
      * @alias 'search.fetch_time' */
    sfti?: string;
    /** The time spent in fetch phase.
      * @alias 'search.fetch_time' */
    searchFetchTime?: string;
    /** The total fetch operations. */
    'search.fetch_total'?: string;
    /** The total fetch operations.
      * @alias 'search.fetch_total' */
    sfto?: string;
    /** The total fetch operations.
      * @alias 'search.fetch_total' */
    searchFetchTotal?: string;
    /** The open search contexts. */
    'search.open_contexts'?: string;
    /** The open search contexts.
      * @alias 'search.open_contexts' */
    so?: string;
    /** The open search contexts.
      * @alias 'search.open_contexts' */
    searchOpenContexts?: string;
    /** The current query phase operations. */
    'search.query_current'?: string;
    /** The current query phase operations.
      * @alias 'search.query_current' */
    sqc?: string;
    /** The current query phase operations.
      * @alias 'search.query_current' */
    searchQueryCurrent?: string;
    /** The time spent in query phase. */
    'search.query_time'?: string;
    /** The time spent in query phase.
      * @alias 'search.query_time' */
    sqti?: string;
    /** The time spent in query phase.
      * @alias 'search.query_time' */
    searchQueryTime?: string;
    /** The total query phase operations. */
    'search.query_total'?: string;
    /** The total query phase operations.
      * @alias 'search.query_total' */
    sqto?: string;
    /** The total query phase operations.
      * @alias 'search.query_total' */
    searchQueryTotal?: string;
    /** The open scroll contexts. */
    'search.scroll_current'?: string;
    /** The open scroll contexts.
      * @alias 'search.scroll_current' */
    scc?: string;
    /** The open scroll contexts.
      * @alias 'search.scroll_current' */
    searchScrollCurrent?: string;
    /** The time scroll contexts held open. */
    'search.scroll_time'?: string;
    /** The time scroll contexts held open.
      * @alias 'search.scroll_time' */
    scti?: string;
    /** The time scroll contexts held open.
      * @alias 'search.scroll_time' */
    searchScrollTime?: string;
    /** The completed scroll contexts. */
    'search.scroll_total'?: string;
    /** The completed scroll contexts.
      * @alias 'search.scroll_total' */
    scto?: string;
    /** The completed scroll contexts.
      * @alias 'search.scroll_total' */
    searchScrollTotal?: string;
    /** The number of segments. */
    'segments.count'?: string;
    /** The number of segments.
      * @alias 'segments.count' */
    sc?: string;
    /** The number of segments.
      * @alias 'segments.count' */
    segmentsCount?: string;
    /** The memory used by segments. */
    'segments.memory'?: string;
    /** The memory used by segments.
      * @alias 'segments.memory' */
    sm?: string;
    /** The memory used by segments.
      * @alias 'segments.memory' */
    segmentsMemory?: string;
    /** The memory used by the index writer. */
    'segments.index_writer_memory'?: string;
    /** The memory used by the index writer.
      * @alias 'segments.index_writer_memory' */
    siwm?: string;
    /** The memory used by the index writer.
      * @alias 'segments.index_writer_memory' */
    segmentsIndexWriterMemory?: string;
    /** The memory used by the version map. */
    'segments.version_map_memory'?: string;
    /** The memory used by the version map.
      * @alias 'segments.version_map_memory' */
    svmm?: string;
    /** The memory used by the version map.
      * @alias 'segments.version_map_memory' */
    segmentsVersionMapMemory?: string;
    /** The memory used by fixed bit sets for nested object field types and export type filters for types referred in _parent fields. */
    'segments.fixed_bitset_memory'?: string;
    /** The memory used by fixed bit sets for nested object field types and export type filters for types referred in _parent fields.
      * @alias 'segments.fixed_bitset_memory' */
    sfbm?: string;
    /** The memory used by fixed bit sets for nested object field types and export type filters for types referred in _parent fields.
      * @alias 'segments.fixed_bitset_memory' */
    fixedBitsetMemory?: string;
    /** The number of current suggest operations. */
    'suggest.current'?: string;
    /** The number of current suggest operations.
      * @alias 'suggest.current' */
    suc?: string;
    /** The number of current suggest operations.
      * @alias 'suggest.current' */
    suggestCurrent?: string;
    /** The time spend in suggest. */
    'suggest.time'?: string;
    /** The time spend in suggest.
      * @alias 'suggest.time' */
    suti?: string;
    /** The time spend in suggest.
      * @alias 'suggest.time' */
    suggestTime?: string;
    /** The number of suggest operations. */
    'suggest.total'?: string;
    /** The number of suggest operations.
      * @alias 'suggest.total' */
    suto?: string;
    /** The number of suggest operations.
      * @alias 'suggest.total' */
    suggestTotal?: string;
    /** The number of bulk shard operations. */
    'bulk.total_operations'?: string;
    /** The number of bulk shard operations.
      * @alias 'bulk.total_operations' */
    bto?: string;
    /** The number of bulk shard operations.
      * @alias 'bulk.total_operations' */
    bulkTotalOperations?: string;
    /** The time spend in shard bulk. */
    'bulk.total_time'?: string;
    /** The time spend in shard bulk.
      * @alias 'bulk.total_time' */
    btti?: string;
    /** The time spend in shard bulk.
      * @alias 'bulk.total_time' */
    bulkTotalTime?: string;
    /** The total size in bytes of shard bulk. */
    'bulk.total_size_in_bytes'?: string;
    /** The total size in bytes of shard bulk.
      * @alias 'bulk.total_size_in_bytes' */
    btsi?: string;
    /** The total size in bytes of shard bulk.
      * @alias 'bulk.total_size_in_bytes' */
    bulkTotalSizeInBytes?: string;
    /** The average time spend in shard bulk. */
    'bulk.avg_time'?: string;
    /** The average time spend in shard bulk.
      * @alias 'bulk.avg_time' */
    bati?: string;
    /** The average time spend in shard bulk.
      * @alias 'bulk.avg_time' */
    bulkAvgTime?: string;
    /** The average size in bytes of shard bulk. */
    'bulk.avg_size_in_bytes'?: string;
    /** The average size in bytes of shard bulk.
      * @alias 'bulk.avg_size_in_bytes' */
    basi?: string;
    /** The average size in bytes of shard bulk.
      * @alias 'bulk.avg_size_in_bytes' */
    bulkAvgSizeInBytes?: string;
}
export interface CatNodesRequest extends CatCatRequestBase {
    /** The unit used to display byte values. */
    bytes?: Bytes;
    /** If `true`, return the full node ID. If `false`, return the shortened node ID. */
    full_id?: boolean | string;
    /** If true, the response includes information from segments that are not loaded into memory. */
    include_unloaded_segments?: boolean;
    /** A comma-separated list of columns names to display.
      * It supports simple wildcards. */
    h?: CatCatNodeColumns;
    /** A comma-separated list of column names or aliases that determines the sort order.
      * Sorting defaults to ascending and can be changed by setting `:asc`
      * or `:desc` as a suffix to the column name. */
    s?: Names;
    /** The period to wait for a connection to the master node. */
    master_timeout?: Duration;
    /** The unit used to display time values. */
    time?: TimeUnit;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        bytes?: never;
        full_id?: never;
        include_unloaded_segments?: never;
        h?: never;
        s?: never;
        master_timeout?: never;
        time?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        bytes?: never;
        full_id?: never;
        include_unloaded_segments?: never;
        h?: never;
        s?: never;
        master_timeout?: never;
        time?: never;
    };
}
export type CatNodesResponse = CatNodesNodesRecord[];
export interface CatPendingTasksPendingTasksRecord {
    /** The task insertion order. */
    insertOrder?: string;
    /** The task insertion order.
      * @alias insertOrder */
    o?: string;
    /** Indicates how long the task has been in queue. */
    timeInQueue?: string;
    /** Indicates how long the task has been in queue.
      * @alias timeInQueue */
    t?: string;
    /** The task priority. */
    priority?: string;
    /** The task priority.
      * @alias priority */
    p?: string;
    /** The task source. */
    source?: string;
    /** The task source.
      * @alias source */
    s?: string;
}
export interface CatPendingTasksRequest extends CatCatRequestBase {
    /** List of columns to appear in the response. Supports simple wildcards. */
    h?: Names;
    /** List of columns that determine how the table should be sorted.
      * Sorting defaults to ascending and can be changed by setting `:asc`
      * or `:desc` as a suffix to the column name. */
    s?: Names;
    /** If `true`, the request computes the list of selected nodes from the
      * local cluster state. If `false` the list of selected nodes are computed
      * from the cluster state of the master node. In both cases the coordinating
      * node will send requests for further information to each selected node. */
    local?: boolean;
    /** Period to wait for a connection to the master node. */
    master_timeout?: Duration;
    /** Unit used to display time values. */
    time?: TimeUnit;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        h?: never;
        s?: never;
        local?: never;
        master_timeout?: never;
        time?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        h?: never;
        s?: never;
        local?: never;
        master_timeout?: never;
        time?: never;
    };
}
export type CatPendingTasksResponse = CatPendingTasksPendingTasksRecord[];
export interface CatPluginsPluginsRecord {
    /** The unique node identifier. */
    id?: NodeId;
    /** The node name. */
    name?: Name;
    /** The node name.
      * @alias name */
    n?: Name;
    /** The component name. */
    component?: string;
    /** The component name.
      * @alias component */
    c?: string;
    /** The component version. */
    version?: VersionString;
    /** The component version.
      * @alias version */
    v?: VersionString;
    /** The plugin details. */
    description?: string;
    /** The plugin details.
      * @alias description */
    d?: string;
    /** The plugin type. */
    type?: string;
    /** The plugin type.
      * @alias type */
    t?: string;
}
export interface CatPluginsRequest extends CatCatRequestBase {
    /** List of columns to appear in the response. Supports simple wildcards. */
    h?: Names;
    /** List of columns that determine how the table should be sorted.
      * Sorting defaults to ascending and can be changed by setting `:asc`
      * or `:desc` as a suffix to the column name. */
    s?: Names;
    /** Include bootstrap plugins in the response */
    include_bootstrap?: boolean;
    /** If `true`, the request computes the list of selected nodes from the
      * local cluster state. If `false` the list of selected nodes are computed
      * from the cluster state of the master node. In both cases the coordinating
      * node will send requests for further information to each selected node. */
    local?: boolean;
    /** Period to wait for a connection to the master node. */
    master_timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        h?: never;
        s?: never;
        include_bootstrap?: never;
        local?: never;
        master_timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        h?: never;
        s?: never;
        include_bootstrap?: never;
        local?: never;
        master_timeout?: never;
    };
}
export type CatPluginsResponse = CatPluginsPluginsRecord[];
export interface CatRecoveryRecoveryRecord {
    /** The index name. */
    index?: IndexName;
    /** The index name.
      * @alias index */
    i?: IndexName;
    /** The index name.
      * @alias index */
    idx?: IndexName;
    /** The shard name. */
    shard?: string;
    /** The shard name.
      * @alias shard */
    s?: string;
    /** The shard name.
      * @alias shard */
    sh?: string;
    /** The recovery start time. */
    start_time?: DateTime;
    /** The recovery start time.
      * @alias start_time */
    start?: DateTime;
    /** The recovery start time in epoch milliseconds. */
    start_time_millis?: EpochTime<UnitMillis>;
    /** The recovery start time in epoch milliseconds.
      * @alias start_time_millis */
    start_millis?: EpochTime<UnitMillis>;
    /** The recovery stop time. */
    stop_time?: DateTime;
    /** The recovery stop time.
      * @alias stop_time */
    stop?: DateTime;
    /** The recovery stop time in epoch milliseconds. */
    stop_time_millis?: EpochTime<UnitMillis>;
    /** The recovery stop time in epoch milliseconds.
      * @alias stop_time_millis */
    stop_millis?: EpochTime<UnitMillis>;
    /** The recovery time. */
    time?: Duration;
    /** The recovery time.
      * @alias time */
    t?: Duration;
    /** The recovery time.
      * @alias time */
    ti?: Duration;
    /** The recovery type. */
    type?: string;
    /** The recovery type.
      * @alias type */
    ty?: string;
    /** The recovery stage. */
    stage?: string;
    /** The recovery stage.
      * @alias stage */
    st?: string;
    /** The source host. */
    source_host?: string;
    /** The source host.
      * @alias source_host */
    shost?: string;
    /** The source node name. */
    source_node?: string;
    /** The source node name.
      * @alias source_node */
    snode?: string;
    /** The target host. */
    target_host?: string;
    /** The target host.
      * @alias target_host */
    thost?: string;
    /** The target node name. */
    target_node?: string;
    /** The target node name.
      * @alias target_node */
    tnode?: string;
    /** The repository name. */
    repository?: string;
    /** The repository name.
      * @alias repository */
    rep?: string;
    /** The snapshot name. */
    snapshot?: string;
    /** The snapshot name.
      * @alias snapshot */
    snap?: string;
    /** The number of files to recover. */
    files?: string;
    /** The number of files to recover.
      * @alias files */
    f?: string;
    /** The files recovered. */
    files_recovered?: string;
    /** The files recovered.
      * @alias files_recovered */
    fr?: string;
    /** The ratio of files recovered. */
    files_percent?: Percentage;
    /** The ratio of files recovered.
      * @alias files_percent */
    fp?: Percentage;
    /** The total number of files. */
    files_total?: string;
    /** The total number of files.
      * @alias files_total */
    tf?: string;
    /** The number of bytes to recover. */
    bytes?: string;
    /** The number of bytes to recover.
      * @alias bytes */
    b?: string;
    /** The bytes recovered. */
    bytes_recovered?: string;
    /** The bytes recovered.
      * @alias bytes_recovered */
    br?: string;
    /** The ratio of bytes recovered. */
    bytes_percent?: Percentage;
    /** The ratio of bytes recovered.
      * @alias bytes_percent */
    bp?: Percentage;
    /** The total number of bytes. */
    bytes_total?: string;
    /** The total number of bytes.
      * @alias bytes_total */
    tb?: string;
    /** The number of translog operations to recover. */
    translog_ops?: string;
    /** The number of translog operations to recover.
      * @alias translog_ops */
    to?: string;
    /** The translog operations recovered. */
    translog_ops_recovered?: string;
    /** The translog operations recovered.
      * @alias translog_ops_recovered */
    tor?: string;
    /** The ratio of translog operations recovered. */
    translog_ops_percent?: Percentage;
    /** The ratio of translog operations recovered.
      * @alias translog_ops_percent */
    top?: Percentage;
}
export interface CatRecoveryRequest extends CatCatRequestBase {
    /** A comma-separated list of data streams, indices, and aliases used to limit the request.
      * Supports wildcards (`*`). To target all data streams and indices, omit this parameter or use `*` or `_all`. */
    index?: Indices;
    /** If `true`, the response only includes ongoing shard recoveries. */
    active_only?: boolean;
    /** The unit used to display byte values. */
    bytes?: Bytes;
    /** If `true`, the response includes detailed information about shard recoveries. */
    detailed?: boolean;
    /** A comma-separated list of columns names to display.
      * It supports simple wildcards. */
    h?: CatCatRecoveryColumns;
    /** A comma-separated list of column names or aliases that determines the sort order.
      * Sorting defaults to ascending and can be changed by setting `:asc`
      * or `:desc` as a suffix to the column name. */
    s?: Names;
    /** The unit used to display time values. */
    time?: TimeUnit;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
        active_only?: never;
        bytes?: never;
        detailed?: never;
        h?: never;
        s?: never;
        time?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
        active_only?: never;
        bytes?: never;
        detailed?: never;
        h?: never;
        s?: never;
        time?: never;
    };
}
export type CatRecoveryResponse = CatRecoveryRecoveryRecord[];
export interface CatRepositoriesRepositoriesRecord {
    /** The unique repository identifier. */
    id?: string;
    /** The unique repository identifier.
      * @alias id */
    repoId?: string;
    /** The repository type. */
    type?: string;
    /** The repository type.
      * @alias type */
    t?: string;
}
export interface CatRepositoriesRequest extends CatCatRequestBase {
    /** List of columns to appear in the response. Supports simple wildcards. */
    h?: Names;
    /** List of columns that determine how the table should be sorted.
      * Sorting defaults to ascending and can be changed by setting `:asc`
      * or `:desc` as a suffix to the column name. */
    s?: Names;
    /** If `true`, the request computes the list of selected nodes from the
      * local cluster state. If `false` the list of selected nodes are computed
      * from the cluster state of the master node. In both cases the coordinating
      * node will send requests for further information to each selected node. */
    local?: boolean;
    /** Period to wait for a connection to the master node. */
    master_timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        h?: never;
        s?: never;
        local?: never;
        master_timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        h?: never;
        s?: never;
        local?: never;
        master_timeout?: never;
    };
}
export type CatRepositoriesResponse = CatRepositoriesRepositoriesRecord[];
export interface CatSegmentsRequest extends CatCatRequestBase {
    /** A comma-separated list of data streams, indices, and aliases used to limit the request.
      * Supports wildcards (`*`).
      * To target all data streams and indices, omit this parameter or use `*` or `_all`. */
    index?: Indices;
    /** The unit used to display byte values. */
    bytes?: Bytes;
    /** A comma-separated list of columns names to display.
      * It supports simple wildcards. */
    h?: CatCatSegmentsColumns;
    /** A comma-separated list of column names or aliases that determines the sort order.
      * Sorting defaults to ascending and can be changed by setting `:asc`
      * or `:desc` as a suffix to the column name. */
    s?: Names;
    /** If `true`, the request computes the list of selected nodes from the
      * local cluster state. If `false` the list of selected nodes are computed
      * from the cluster state of the master node. In both cases the coordinating
      * node will send requests for further information to each selected node. */
    local?: boolean;
    /** Period to wait for a connection to the master node. */
    master_timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
        bytes?: never;
        h?: never;
        s?: never;
        local?: never;
        master_timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
        bytes?: never;
        h?: never;
        s?: never;
        local?: never;
        master_timeout?: never;
    };
}
export type CatSegmentsResponse = CatSegmentsSegmentsRecord[];
export interface CatSegmentsSegmentsRecord {
    /** The index name. */
    index?: IndexName;
    /** The index name.
      * @alias index */
    i?: IndexName;
    /** The index name.
      * @alias index */
    idx?: IndexName;
    /** The shard name. */
    shard?: string;
    /** The shard name.
      * @alias shard */
    s?: string;
    /** The shard name.
      * @alias shard */
    sh?: string;
    /** The shard type: `primary` or `replica`. */
    prirep?: string;
    /** The shard type: `primary` or `replica`.
      * @alias prirep */
    p?: string;
    /** The shard type: `primary` or `replica`.
      * @alias prirep */
    pr?: string;
    /** The shard type: `primary` or `replica`.
      * @alias prirep */
    primaryOrReplica?: string;
    /** The IP address of the node where it lives. */
    ip?: string;
    /** The unique identifier of the node where it lives. */
    id?: NodeId;
    /** The segment name, which is derived from the segment generation and used internally to create file names in the directory of the shard. */
    segment?: string;
    /** The segment name, which is derived from the segment generation and used internally to create file names in the directory of the shard.
      * @alias segment */
    seg?: string;
    /** The segment generation number.
      * Elasticsearch increments this generation number for each segment written then uses this number to derive the segment name. */
    generation?: string;
    /** The segment generation number.
      * Elasticsearch increments this generation number for each segment written then uses this number to derive the segment name.
      * @alias generation */
    g?: string;
    /** The segment generation number.
      * Elasticsearch increments this generation number for each segment written then uses this number to derive the segment name.
      * @alias generation */
    gen?: string;
    /** The number of documents in the segment.
      * This excludes deleted documents and counts any nested documents separately from their parents.
      * It also excludes documents which were indexed recently and do not yet belong to a segment. */
    'docs.count'?: string;
    /** The number of documents in the segment.
      * This excludes deleted documents and counts any nested documents separately from their parents.
      * It also excludes documents which were indexed recently and do not yet belong to a segment.
      * @alias 'docs.count' */
    dc?: string;
    /** The number of documents in the segment.
      * This excludes deleted documents and counts any nested documents separately from their parents.
      * It also excludes documents which were indexed recently and do not yet belong to a segment.
      * @alias 'docs.count' */
    docsCount?: string;
    /** The number of deleted documents in the segment, which might be higher or lower than the number of delete operations you have performed.
      * This number excludes deletes that were performed recently and do not yet belong to a segment.
      * Deleted documents are cleaned up by the automatic merge process if it makes sense to do so.
      * Also, Elasticsearch creates extra deleted documents to internally track the recent history of operations on a shard. */
    'docs.deleted'?: string;
    /** The number of deleted documents in the segment, which might be higher or lower than the number of delete operations you have performed.
      * This number excludes deletes that were performed recently and do not yet belong to a segment.
      * Deleted documents are cleaned up by the automatic merge process if it makes sense to do so.
      * Also, Elasticsearch creates extra deleted documents to internally track the recent history of operations on a shard.
      * @alias 'docs.deleted' */
    dd?: string;
    /** The number of deleted documents in the segment, which might be higher or lower than the number of delete operations you have performed.
      * This number excludes deletes that were performed recently and do not yet belong to a segment.
      * Deleted documents are cleaned up by the automatic merge process if it makes sense to do so.
      * Also, Elasticsearch creates extra deleted documents to internally track the recent history of operations on a shard.
      * @alias 'docs.deleted' */
    docsDeleted?: string;
    /** The segment size in bytes. */
    size?: ByteSize;
    /** The segment size in bytes.
      * @alias size */
    si?: ByteSize;
    /** The segment memory in bytes.
      * A value of `-1` indicates Elasticsearch was unable to compute this number. */
    'size.memory'?: ByteSize;
    /** The segment memory in bytes.
      * A value of `-1` indicates Elasticsearch was unable to compute this number.
      * @alias 'size.memory' */
    sm?: ByteSize;
    /** The segment memory in bytes.
      * A value of `-1` indicates Elasticsearch was unable to compute this number.
      * @alias 'size.memory' */
    sizeMemory?: ByteSize;
    /** If `true`, the segment is synced to disk.
      * Segments that are synced can survive a hard reboot.
      * If `false`, the data from uncommitted segments is also stored in the transaction log so that Elasticsearch is able to replay changes on the next start. */
    committed?: string;
    /** If `true`, the segment is synced to disk.
      * Segments that are synced can survive a hard reboot.
      * If `false`, the data from uncommitted segments is also stored in the transaction log so that Elasticsearch is able to replay changes on the next start.
      * @alias committed */
    ic?: string;
    /** If `true`, the segment is synced to disk.
      * Segments that are synced can survive a hard reboot.
      * If `false`, the data from uncommitted segments is also stored in the transaction log so that Elasticsearch is able to replay changes on the next start.
      * @alias committed */
    isCommitted?: string;
    /** If `true`, the segment is searchable.
      * If `false`, the segment has most likely been written to disk but needs a refresh to be searchable. */
    searchable?: string;
    /** If `true`, the segment is searchable.
      * If `false`, the segment has most likely been written to disk but needs a refresh to be searchable.
      * @alias searchable */
    is?: string;
    /** If `true`, the segment is searchable.
      * If `false`, the segment has most likely been written to disk but needs a refresh to be searchable.
      * @alias searchable */
    isSearchable?: string;
    /** The version of Lucene used to write the segment. */
    version?: VersionString;
    /** The version of Lucene used to write the segment.
      * @alias version */
    v?: VersionString;
    /** If `true`, the segment is stored in a compound file.
      * This means Lucene merged all files from the segment in a single file to save file descriptors. */
    compound?: string;
    /** If `true`, the segment is stored in a compound file.
      * This means Lucene merged all files from the segment in a single file to save file descriptors.
      * @alias compound */
    ico?: string;
    /** If `true`, the segment is stored in a compound file.
      * This means Lucene merged all files from the segment in a single file to save file descriptors.
      * @alias compound */
    isCompound?: string;
}
export interface CatShardsRequest extends CatCatRequestBase {
    /** A comma-separated list of data streams, indices, and aliases used to limit the request.
      * Supports wildcards (`*`).
      * To target all data streams and indices, omit this parameter or use `*` or `_all`. */
    index?: Indices;
    /** The unit used to display byte values. */
    bytes?: Bytes;
    /** List of columns to appear in the response. Supports simple wildcards. */
    h?: CatCatShardColumns;
    /** A comma-separated list of column names or aliases that determines the sort order.
      * Sorting defaults to ascending and can be changed by setting `:asc`
      * or `:desc` as a suffix to the column name. */
    s?: Names;
    /** The period to wait for a connection to the master node. */
    master_timeout?: Duration;
    /** The unit used to display time values. */
    time?: TimeUnit;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
        bytes?: never;
        h?: never;
        s?: never;
        master_timeout?: never;
        time?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
        bytes?: never;
        h?: never;
        s?: never;
        master_timeout?: never;
        time?: never;
    };
}
export type CatShardsResponse = CatShardsShardsRecord[];
export interface CatShardsShardsRecord {
    /** The index name. */
    index?: string;
    /** The index name.
      * @alias index */
    i?: string;
    /** The index name.
      * @alias index */
    idx?: string;
    /** The shard name. */
    shard?: string;
    /** The shard name.
      * @alias shard */
    s?: string;
    /** The shard name.
      * @alias shard */
    sh?: string;
    /** The shard type: `primary` or `replica`. */
    prirep?: string;
    /** The shard type: `primary` or `replica`.
      * @alias prirep */
    p?: string;
    /** The shard type: `primary` or `replica`.
      * @alias prirep */
    pr?: string;
    /** The shard type: `primary` or `replica`.
      * @alias prirep */
    primaryOrReplica?: string;
    /** The shard state.
      * Returned values include:
      * `INITIALIZING`: The shard is recovering from a peer shard or gateway.
      * `RELOCATING`: The shard is relocating.
      * `STARTED`: The shard has started.
      * `UNASSIGNED`: The shard is not assigned to any node. */
    state?: string;
    /** The shard state.
      * Returned values include:
      * `INITIALIZING`: The shard is recovering from a peer shard or gateway.
      * `RELOCATING`: The shard is relocating.
      * `STARTED`: The shard has started.
      * `UNASSIGNED`: The shard is not assigned to any node.
      * @alias state */
    st?: string;
    /** The number of documents in the shard. */
    docs?: string | null;
    /** The number of documents in the shard.
      * @alias docs */
    d?: string | null;
    /** The number of documents in the shard.
      * @alias docs */
    dc?: string | null;
    /** The disk space used by the shard. */
    store?: string | null;
    /** The disk space used by the shard.
      * @alias store */
    sto?: string | null;
    /** total size of dataset (including the cache for partially mounted indices) */
    dataset?: string | null;
    /** The IP address of the node. */
    ip?: string | null;
    /** The unique identifier for the node. */
    id?: string;
    /** The name of node. */
    node?: string | null;
    /** The name of node.
      * @alias node */
    n?: string | null;
    /** The sync identifier. */
    sync_id?: string;
    /** The reason for the last change to the state of an unassigned shard.
      * It does not explain why the shard is currently unassigned; use the cluster allocation explain API for that information.
      * Returned values include:
      * `ALLOCATION_FAILED`: Unassigned as a result of a failed allocation of the shard.
      * `CLUSTER_RECOVERED`: Unassigned as a result of a full cluster recovery.
      * `DANGLING_INDEX_IMPORTED`: Unassigned as a result of importing a dangling index.
      * `EXISTING_INDEX_RESTORED`: Unassigned as a result of restoring into a closed index.
      * `FORCED_EMPTY_PRIMARY`: The shard’s allocation was last modified by forcing an empty primary using the cluster reroute API.
      * `INDEX_CLOSED`: Unassigned because the index was closed.
      * `INDEX_CREATED`: Unassigned as a result of an API creation of an index.
      * `INDEX_REOPENED`: Unassigned as a result of opening a closed index.
      * `MANUAL_ALLOCATION`: The shard’s allocation was last modified by the cluster reroute API.
      * `NEW_INDEX_RESTORED`: Unassigned as a result of restoring into a new index.
      * `NODE_LEFT`: Unassigned as a result of the node hosting it leaving the cluster.
      * `NODE_RESTARTING`: Similar to `NODE_LEFT`, except that the node was registered as restarting using the node shutdown API.
      * `PRIMARY_FAILED`: The shard was initializing as a replica, but the primary shard failed before the initialization completed.
      * `REALLOCATED_REPLICA`: A better replica location is identified and causes the existing replica allocation to be cancelled.
      * `REINITIALIZED`: When a shard moves from started back to initializing.
      * `REPLICA_ADDED`: Unassigned as a result of explicit addition of a replica.
      * `REROUTE_CANCELLED`: Unassigned as a result of explicit cancel reroute command. */
    'unassigned.reason'?: string;
    /** The reason for the last change to the state of an unassigned shard.
      * It does not explain why the shard is currently unassigned; use the cluster allocation explain API for that information.
      * Returned values include:
      * `ALLOCATION_FAILED`: Unassigned as a result of a failed allocation of the shard.
      * `CLUSTER_RECOVERED`: Unassigned as a result of a full cluster recovery.
      * `DANGLING_INDEX_IMPORTED`: Unassigned as a result of importing a dangling index.
      * `EXISTING_INDEX_RESTORED`: Unassigned as a result of restoring into a closed index.
      * `FORCED_EMPTY_PRIMARY`: The shard’s allocation was last modified by forcing an empty primary using the cluster reroute API.
      * `INDEX_CLOSED`: Unassigned because the index was closed.
      * `INDEX_CREATED`: Unassigned as a result of an API creation of an index.
      * `INDEX_REOPENED`: Unassigned as a result of opening a closed index.
      * `MANUAL_ALLOCATION`: The shard’s allocation was last modified by the cluster reroute API.
      * `NEW_INDEX_RESTORED`: Unassigned as a result of restoring into a new index.
      * `NODE_LEFT`: Unassigned as a result of the node hosting it leaving the cluster.
      * `NODE_RESTARTING`: Similar to `NODE_LEFT`, except that the node was registered as restarting using the node shutdown API.
      * `PRIMARY_FAILED`: The shard was initializing as a replica, but the primary shard failed before the initialization completed.
      * `REALLOCATED_REPLICA`: A better replica location is identified and causes the existing replica allocation to be cancelled.
      * `REINITIALIZED`: When a shard moves from started back to initializing.
      * `REPLICA_ADDED`: Unassigned as a result of explicit addition of a replica.
      * `REROUTE_CANCELLED`: Unassigned as a result of explicit cancel reroute command.
      * @alias 'unassigned.reason' */
    ur?: string;
    /** The time at which the shard became unassigned in Coordinated Universal Time (UTC). */
    'unassigned.at'?: string;
    /** The time at which the shard became unassigned in Coordinated Universal Time (UTC).
      * @alias 'unassigned.at' */
    ua?: string;
    /** The time at which the shard was requested to be unassigned in Coordinated Universal Time (UTC). */
    'unassigned.for'?: string;
    /** The time at which the shard was requested to be unassigned in Coordinated Universal Time (UTC).
      * @alias 'unassigned.for' */
    uf?: string;
    /** Additional details as to why the shard became unassigned.
      * It does not explain why the shard is not assigned; use the cluster allocation explain API for that information. */
    'unassigned.details'?: string;
    /** Additional details as to why the shard became unassigned.
      * It does not explain why the shard is not assigned; use the cluster allocation explain API for that information.
      * @alias 'unassigned.details' */
    ud?: string;
    /** The type of recovery source. */
    'recoverysource.type'?: string;
    /** The type of recovery source.
      * @alias 'recoverysource.type' */
    rs?: string;
    /** The size of completion. */
    'completion.size'?: string;
    /** The size of completion.
      * @alias 'completion.size' */
    cs?: string;
    /** The size of completion.
      * @alias 'completion.size' */
    completionSize?: string;
    /** The used fielddata cache memory. */
    'fielddata.memory_size'?: string;
    /** The used fielddata cache memory.
      * @alias 'fielddata.memory_size' */
    fm?: string;
    /** The used fielddata cache memory.
      * @alias 'fielddata.memory_size' */
    fielddataMemory?: string;
    /** The fielddata cache evictions. */
    'fielddata.evictions'?: string;
    /** The fielddata cache evictions.
      * @alias 'fielddata.evictions' */
    fe?: string;
    /** The fielddata cache evictions.
      * @alias 'fielddata.evictions' */
    fielddataEvictions?: string;
    /** The used query cache memory. */
    'query_cache.memory_size'?: string;
    /** The used query cache memory.
      * @alias 'query_cache.memory_size' */
    qcm?: string;
    /** The used query cache memory.
      * @alias 'query_cache.memory_size' */
    queryCacheMemory?: string;
    /** The query cache evictions. */
    'query_cache.evictions'?: string;
    /** The query cache evictions.
      * @alias 'query_cache.evictions' */
    qce?: string;
    /** The query cache evictions.
      * @alias 'query_cache.evictions' */
    queryCacheEvictions?: string;
    /** The number of flushes. */
    'flush.total'?: string;
    /** The number of flushes.
      * @alias 'flush.total' */
    ft?: string;
    /** The number of flushes.
      * @alias 'flush.total' */
    flushTotal?: string;
    /** The time spent in flush. */
    'flush.total_time'?: string;
    /** The time spent in flush.
      * @alias 'flush.total_time' */
    ftt?: string;
    /** The time spent in flush.
      * @alias 'flush.total_time' */
    flushTotalTime?: string;
    /** The number of current get operations. */
    'get.current'?: string;
    /** The number of current get operations.
      * @alias 'get.current' */
    gc?: string;
    /** The number of current get operations.
      * @alias 'get.current' */
    getCurrent?: string;
    /** The time spent in get operations. */
    'get.time'?: string;
    /** The time spent in get operations.
      * @alias 'get.time' */
    gti?: string;
    /** The time spent in get operations.
      * @alias 'get.time' */
    getTime?: string;
    /** The number of get operations. */
    'get.total'?: string;
    /** The number of get operations.
      * @alias 'get.total' */
    gto?: string;
    /** The number of get operations.
      * @alias 'get.total' */
    getTotal?: string;
    /** The time spent in successful get operations. */
    'get.exists_time'?: string;
    /** The time spent in successful get operations.
      * @alias 'get.exists_time' */
    geti?: string;
    /** The time spent in successful get operations.
      * @alias 'get.exists_time' */
    getExistsTime?: string;
    /** The number of successful get operations. */
    'get.exists_total'?: string;
    /** The number of successful get operations.
      * @alias 'get.exists_total' */
    geto?: string;
    /** The number of successful get operations.
      * @alias 'get.exists_total' */
    getExistsTotal?: string;
    /** The time spent in failed get operations. */
    'get.missing_time'?: string;
    /** The time spent in failed get operations.
      * @alias 'get.missing_time' */
    gmti?: string;
    /** The time spent in failed get operations.
      * @alias 'get.missing_time' */
    getMissingTime?: string;
    /** The number of failed get operations. */
    'get.missing_total'?: string;
    /** The number of failed get operations.
      * @alias 'get.missing_total' */
    gmto?: string;
    /** The number of failed get operations.
      * @alias 'get.missing_total' */
    getMissingTotal?: string;
    /** The number of current deletion operations. */
    'indexing.delete_current'?: string;
    /** The number of current deletion operations.
      * @alias 'indexing.delete_current' */
    idc?: string;
    /** The number of current deletion operations.
      * @alias 'indexing.delete_current' */
    indexingDeleteCurrent?: string;
    /** The time spent in deletion operations. */
    'indexing.delete_time'?: string;
    /** The time spent in deletion operations.
      * @alias 'indexing.delete_time' */
    idti?: string;
    /** The time spent in deletion operations.
      * @alias 'indexing.delete_time' */
    indexingDeleteTime?: string;
    /** The number of delete operations. */
    'indexing.delete_total'?: string;
    /** The number of delete operations.
      * @alias 'indexing.delete_total' */
    idto?: string;
    /** The number of delete operations.
      * @alias 'indexing.delete_total' */
    indexingDeleteTotal?: string;
    /** The number of current indexing operations. */
    'indexing.index_current'?: string;
    /** The number of current indexing operations.
      * @alias 'indexing.index_current' */
    iic?: string;
    /** The number of current indexing operations.
      * @alias 'indexing.index_current' */
    indexingIndexCurrent?: string;
    /** The time spent in indexing operations. */
    'indexing.index_time'?: string;
    /** The time spent in indexing operations.
      * @alias 'indexing.index_time' */
    iiti?: string;
    /** The time spent in indexing operations.
      * @alias 'indexing.index_time' */
    indexingIndexTime?: string;
    /** The number of indexing operations. */
    'indexing.index_total'?: string;
    /** The number of indexing operations.
      * @alias 'indexing.index_total' */
    iito?: string;
    /** The number of indexing operations.
      * @alias 'indexing.index_total' */
    indexingIndexTotal?: string;
    /** The number of failed indexing operations. */
    'indexing.index_failed'?: string;
    /** The number of failed indexing operations.
      * @alias 'indexing.index_failed' */
    iif?: string;
    /** The number of failed indexing operations.
      * @alias 'indexing.index_failed' */
    indexingIndexFailed?: string;
    /** The number of current merge operations. */
    'merges.current'?: string;
    /** The number of current merge operations.
      * @alias 'merges.current' */
    mc?: string;
    /** The number of current merge operations.
      * @alias 'merges.current' */
    mergesCurrent?: string;
    /** The number of current merging documents. */
    'merges.current_docs'?: string;
    /** The number of current merging documents.
      * @alias 'merges.current_docs' */
    mcd?: string;
    /** The number of current merging documents.
      * @alias 'merges.current_docs' */
    mergesCurrentDocs?: string;
    /** The size of current merge operations. */
    'merges.current_size'?: string;
    /** The size of current merge operations.
      * @alias 'merges.current_size' */
    mcs?: string;
    /** The size of current merge operations.
      * @alias 'merges.current_size' */
    mergesCurrentSize?: string;
    /** The number of completed merge operations. */
    'merges.total'?: string;
    /** The number of completed merge operations.
      * @alias 'merges.total' */
    mt?: string;
    /** The number of completed merge operations.
      * @alias 'merges.total' */
    mergesTotal?: string;
    /** The nuber of merged documents. */
    'merges.total_docs'?: string;
    /** The nuber of merged documents.
      * @alias 'merges.total_docs' */
    mtd?: string;
    /** The nuber of merged documents.
      * @alias 'merges.total_docs' */
    mergesTotalDocs?: string;
    /** The size of current merges. */
    'merges.total_size'?: string;
    /** The size of current merges.
      * @alias 'merges.total_size' */
    mts?: string;
    /** The size of current merges.
      * @alias 'merges.total_size' */
    mergesTotalSize?: string;
    /** The time spent merging documents. */
    'merges.total_time'?: string;
    /** The time spent merging documents.
      * @alias 'merges.total_time' */
    mtt?: string;
    /** The time spent merging documents.
      * @alias 'merges.total_time' */
    mergesTotalTime?: string;
    /** The total number of refreshes. */
    'refresh.total'?: string;
    /** The time spent in refreshes. */
    'refresh.time'?: string;
    /** The total nunber of external refreshes. */
    'refresh.external_total'?: string;
    /** The total nunber of external refreshes.
      * @alias 'refresh.external_total' */
    rto?: string;
    /** The total nunber of external refreshes.
      * @alias 'refresh.external_total' */
    refreshTotal?: string;
    /** The time spent in external refreshes. */
    'refresh.external_time'?: string;
    /** The time spent in external refreshes.
      * @alias 'refresh.external_time' */
    rti?: string;
    /** The time spent in external refreshes.
      * @alias 'refresh.external_time' */
    refreshTime?: string;
    /** The number of pending refresh listeners. */
    'refresh.listeners'?: string;
    /** The number of pending refresh listeners.
      * @alias 'refresh.listeners' */
    rli?: string;
    /** The number of pending refresh listeners.
      * @alias 'refresh.listeners' */
    refreshListeners?: string;
    /** The current fetch phase operations. */
    'search.fetch_current'?: string;
    /** The current fetch phase operations.
      * @alias 'search.fetch_current' */
    sfc?: string;
    /** The current fetch phase operations.
      * @alias 'search.fetch_current' */
    searchFetchCurrent?: string;
    /** The time spent in fetch phase. */
    'search.fetch_time'?: string;
    /** The time spent in fetch phase.
      * @alias 'search.fetch_time' */
    sfti?: string;
    /** The time spent in fetch phase.
      * @alias 'search.fetch_time' */
    searchFetchTime?: string;
    /** The total number of fetch operations. */
    'search.fetch_total'?: string;
    /** The total number of fetch operations.
      * @alias 'search.fetch_total' */
    sfto?: string;
    /** The total number of fetch operations.
      * @alias 'search.fetch_total' */
    searchFetchTotal?: string;
    /** The number of open search contexts. */
    'search.open_contexts'?: string;
    /** The number of open search contexts.
      * @alias 'search.open_contexts' */
    so?: string;
    /** The number of open search contexts.
      * @alias 'search.open_contexts' */
    searchOpenContexts?: string;
    /** The current query phase operations. */
    'search.query_current'?: string;
    /** The current query phase operations.
      * @alias 'search.query_current' */
    sqc?: string;
    /** The current query phase operations.
      * @alias 'search.query_current' */
    searchQueryCurrent?: string;
    /** The time spent in query phase. */
    'search.query_time'?: string;
    /** The time spent in query phase.
      * @alias 'search.query_time' */
    sqti?: string;
    /** The time spent in query phase.
      * @alias 'search.query_time' */
    searchQueryTime?: string;
    /** The total number of query phase operations. */
    'search.query_total'?: string;
    /** The total number of query phase operations.
      * @alias 'search.query_total' */
    sqto?: string;
    /** The total number of query phase operations.
      * @alias 'search.query_total' */
    searchQueryTotal?: string;
    /** The open scroll contexts. */
    'search.scroll_current'?: string;
    /** The open scroll contexts.
      * @alias 'search.scroll_current' */
    scc?: string;
    /** The open scroll contexts.
      * @alias 'search.scroll_current' */
    searchScrollCurrent?: string;
    /** The time scroll contexts were held open. */
    'search.scroll_time'?: string;
    /** The time scroll contexts were held open.
      * @alias 'search.scroll_time' */
    scti?: string;
    /** The time scroll contexts were held open.
      * @alias 'search.scroll_time' */
    searchScrollTime?: string;
    /** The number of completed scroll contexts. */
    'search.scroll_total'?: string;
    /** The number of completed scroll contexts.
      * @alias 'search.scroll_total' */
    scto?: string;
    /** The number of completed scroll contexts.
      * @alias 'search.scroll_total' */
    searchScrollTotal?: string;
    /** The number of segments. */
    'segments.count'?: string;
    /** The number of segments.
      * @alias 'segments.count' */
    sc?: string;
    /** The number of segments.
      * @alias 'segments.count' */
    segmentsCount?: string;
    /** The memory used by segments. */
    'segments.memory'?: string;
    /** The memory used by segments.
      * @alias 'segments.memory' */
    sm?: string;
    /** The memory used by segments.
      * @alias 'segments.memory' */
    segmentsMemory?: string;
    /** The memory used by the index writer. */
    'segments.index_writer_memory'?: string;
    /** The memory used by the index writer.
      * @alias 'segments.index_writer_memory' */
    siwm?: string;
    /** The memory used by the index writer.
      * @alias 'segments.index_writer_memory' */
    segmentsIndexWriterMemory?: string;
    /** The memory used by the version map. */
    'segments.version_map_memory'?: string;
    /** The memory used by the version map.
      * @alias 'segments.version_map_memory' */
    svmm?: string;
    /** The memory used by the version map.
      * @alias 'segments.version_map_memory' */
    segmentsVersionMapMemory?: string;
    /** The memory used by fixed bit sets for nested object field types and export type filters for types referred in `_parent` fields. */
    'segments.fixed_bitset_memory'?: string;
    /** The memory used by fixed bit sets for nested object field types and export type filters for types referred in `_parent` fields.
      * @alias 'segments.fixed_bitset_memory' */
    sfbm?: string;
    /** The memory used by fixed bit sets for nested object field types and export type filters for types referred in `_parent` fields.
      * @alias 'segments.fixed_bitset_memory' */
    fixedBitsetMemory?: string;
    /** The maximum sequence number. */
    'seq_no.max'?: string;
    /** The maximum sequence number.
      * @alias 'seq_no.max' */
    sqm?: string;
    /** The maximum sequence number.
      * @alias 'seq_no.max' */
    maxSeqNo?: string;
    /** The local checkpoint. */
    'seq_no.local_checkpoint'?: string;
    /** The local checkpoint.
      * @alias 'seq_no.local_checkpoint' */
    sql?: string;
    /** The local checkpoint.
      * @alias 'seq_no.local_checkpoint' */
    localCheckpoint?: string;
    /** The global checkpoint. */
    'seq_no.global_checkpoint'?: string;
    /** The global checkpoint.
      * @alias 'seq_no.global_checkpoint' */
    sqg?: string;
    /** The global checkpoint.
      * @alias 'seq_no.global_checkpoint' */
    globalCheckpoint?: string;
    /** The number of current warmer operations. */
    'warmer.current'?: string;
    /** The number of current warmer operations.
      * @alias 'warmer.current' */
    wc?: string;
    /** The number of current warmer operations.
      * @alias 'warmer.current' */
    warmerCurrent?: string;
    /** The total number of warmer operations. */
    'warmer.total'?: string;
    /** The total number of warmer operations.
      * @alias 'warmer.total' */
    wto?: string;
    /** The total number of warmer operations.
      * @alias 'warmer.total' */
    warmerTotal?: string;
    /** The time spent in warmer operations. */
    'warmer.total_time'?: string;
    /** The time spent in warmer operations.
      * @alias 'warmer.total_time' */
    wtt?: string;
    /** The time spent in warmer operations.
      * @alias 'warmer.total_time' */
    warmerTotalTime?: string;
    /** The shard data path. */
    'path.data'?: string;
    /** The shard data path.
      * @alias 'path.data' */
    pd?: string;
    /** The shard data path.
      * @alias 'path.data' */
    dataPath?: string;
    /** The shard state path. */
    'path.state'?: string;
    /** The shard state path.
      * @alias 'path.state' */
    ps?: string;
    /** The shard state path.
      * @alias 'path.state' */
    statsPath?: string;
    /** The number of bulk shard operations. */
    'bulk.total_operations'?: string;
    /** The number of bulk shard operations.
      * @alias 'bulk.total_operations' */
    bto?: string;
    /** The number of bulk shard operations.
      * @alias 'bulk.total_operations' */
    bulkTotalOperations?: string;
    /** The time spent in shard bulk operations. */
    'bulk.total_time'?: string;
    /** The time spent in shard bulk operations.
      * @alias 'bulk.total_time' */
    btti?: string;
    /** The time spent in shard bulk operations.
      * @alias 'bulk.total_time' */
    bulkTotalTime?: string;
    /** The total size in bytes of shard bulk operations. */
    'bulk.total_size_in_bytes'?: string;
    /** The total size in bytes of shard bulk operations.
      * @alias 'bulk.total_size_in_bytes' */
    btsi?: string;
    /** The total size in bytes of shard bulk operations.
      * @alias 'bulk.total_size_in_bytes' */
    bulkTotalSizeInBytes?: string;
    /** The average time spent in shard bulk operations. */
    'bulk.avg_time'?: string;
    /** The average time spent in shard bulk operations.
      * @alias 'bulk.avg_time' */
    bati?: string;
    /** The average time spent in shard bulk operations.
      * @alias 'bulk.avg_time' */
    bulkAvgTime?: string;
    /** The average size in bytes of shard bulk operations. */
    'bulk.avg_size_in_bytes'?: string;
    /** The average size in bytes of shard bulk operations.
      * @alias 'bulk.avg_size_in_bytes' */
    basi?: string;
    /** The average size in bytes of shard bulk operations.
      * @alias 'bulk.avg_size_in_bytes' */
    bulkAvgSizeInBytes?: string;
}
export interface CatSnapshotsRequest extends CatCatRequestBase {
    /** A comma-separated list of snapshot repositories used to limit the request.
      * Accepts wildcard expressions.
      * `_all` returns all repositories.
      * If any repository fails during the request, Elasticsearch returns an error. */
    repository?: Names;
    /** If `true`, the response does not include information from unavailable snapshots. */
    ignore_unavailable?: boolean;
    /** A comma-separated list of columns names to display.
      * It supports simple wildcards. */
    h?: CatCatSnapshotsColumns;
    /** List of columns that determine how the table should be sorted.
      * Sorting defaults to ascending and can be changed by setting `:asc`
      * or `:desc` as a suffix to the column name. */
    s?: Names;
    /** Period to wait for a connection to the master node. */
    master_timeout?: Duration;
    /** Unit used to display time values. */
    time?: TimeUnit;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        repository?: never;
        ignore_unavailable?: never;
        h?: never;
        s?: never;
        master_timeout?: never;
        time?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        repository?: never;
        ignore_unavailable?: never;
        h?: never;
        s?: never;
        master_timeout?: never;
        time?: never;
    };
}
export type CatSnapshotsResponse = CatSnapshotsSnapshotsRecord[];
export interface CatSnapshotsSnapshotsRecord {
    /** The unique identifier for the snapshot. */
    id?: string;
    /** The unique identifier for the snapshot.
      * @alias id */
    snapshot?: string;
    /** The repository name. */
    repository?: string;
    /** The repository name.
      * @alias repository */
    re?: string;
    /** The repository name.
      * @alias repository */
    repo?: string;
    /** The state of the snapshot process.
      * Returned values include:
      * `FAILED`: The snapshot process failed.
      * `INCOMPATIBLE`: The snapshot process is incompatible with the current cluster version.
      * `IN_PROGRESS`: The snapshot process started but has not completed.
      * `PARTIAL`: The snapshot process completed with a partial success.
      * `SUCCESS`: The snapshot process completed with a full success. */
    status?: string;
    /** The state of the snapshot process.
      * Returned values include:
      * `FAILED`: The snapshot process failed.
      * `INCOMPATIBLE`: The snapshot process is incompatible with the current cluster version.
      * `IN_PROGRESS`: The snapshot process started but has not completed.
      * `PARTIAL`: The snapshot process completed with a partial success.
      * `SUCCESS`: The snapshot process completed with a full success.
      * @alias status */
    s?: string;
    /** The Unix epoch time (seconds since 1970-01-01 00:00:00) at which the snapshot process started. */
    start_epoch?: SpecUtilsStringified<EpochTime<UnitSeconds>>;
    /** The Unix epoch time (seconds since 1970-01-01 00:00:00) at which the snapshot process started.
      * @alias start_epoch */
    ste?: SpecUtilsStringified<EpochTime<UnitSeconds>>;
    /** The Unix epoch time (seconds since 1970-01-01 00:00:00) at which the snapshot process started.
      * @alias start_epoch */
    startEpoch?: SpecUtilsStringified<EpochTime<UnitSeconds>>;
    /** The time (HH:MM:SS) at which the snapshot process started. */
    start_time?: WatcherScheduleTimeOfDay;
    /** The time (HH:MM:SS) at which the snapshot process started.
      * @alias start_time */
    sti?: WatcherScheduleTimeOfDay;
    /** The time (HH:MM:SS) at which the snapshot process started.
      * @alias start_time */
    startTime?: WatcherScheduleTimeOfDay;
    /** The Unix epoch time (seconds since 1970-01-01 00:00:00) at which the snapshot process ended. */
    end_epoch?: SpecUtilsStringified<EpochTime<UnitSeconds>>;
    /** The Unix epoch time (seconds since 1970-01-01 00:00:00) at which the snapshot process ended.
      * @alias end_epoch */
    ete?: SpecUtilsStringified<EpochTime<UnitSeconds>>;
    /** The Unix epoch time (seconds since 1970-01-01 00:00:00) at which the snapshot process ended.
      * @alias end_epoch */
    endEpoch?: SpecUtilsStringified<EpochTime<UnitSeconds>>;
    /** The time (HH:MM:SS) at which the snapshot process ended. */
    end_time?: TimeOfDay;
    /** The time (HH:MM:SS) at which the snapshot process ended.
      * @alias end_time */
    eti?: TimeOfDay;
    /** The time (HH:MM:SS) at which the snapshot process ended.
      * @alias end_time */
    endTime?: TimeOfDay;
    /** The time it took the snapshot process to complete, in time units. */
    duration?: Duration;
    /** The time it took the snapshot process to complete, in time units.
      * @alias duration */
    dur?: Duration;
    /** The number of indices in the snapshot. */
    indices?: string;
    /** The number of indices in the snapshot.
      * @alias indices */
    i?: string;
    /** The number of successful shards in the snapshot. */
    successful_shards?: string;
    /** The number of successful shards in the snapshot.
      * @alias successful_shards */
    ss?: string;
    /** The number of failed shards in the snapshot. */
    failed_shards?: string;
    /** The number of failed shards in the snapshot.
      * @alias failed_shards */
    fs?: string;
    /** The total number of shards in the snapshot. */
    total_shards?: string;
    /** The total number of shards in the snapshot.
      * @alias total_shards */
    ts?: string;
    /** The reason for any snapshot failures. */
    reason?: string;
    /** The reason for any snapshot failures.
      * @alias reason */
    r?: string;
}
export interface CatTasksRequest extends CatCatRequestBase {
    /** The task action names, which are used to limit the response. */
    actions?: string[];
    /** If `true`, the response includes detailed information about shard recoveries. */
    detailed?: boolean;
    /** Unique node identifiers, which are used to limit the response. */
    nodes?: string[];
    /** The parent task identifier, which is used to limit the response. */
    parent_task_id?: string;
    /** List of columns to appear in the response. Supports simple wildcards. */
    h?: Names;
    /** List of columns that determine how the table should be sorted.
      * Sorting defaults to ascending and can be changed by setting `:asc`
      * or `:desc` as a suffix to the column name. */
    s?: Names;
    /** Unit used to display time values. */
    time?: TimeUnit;
    /** Period to wait for a response.
      * If no response is received before the timeout expires, the request fails and returns an error. */
    timeout?: Duration;
    /** If `true`, the request blocks until the task has completed. */
    wait_for_completion?: boolean;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        actions?: never;
        detailed?: never;
        nodes?: never;
        parent_task_id?: never;
        h?: never;
        s?: never;
        time?: never;
        timeout?: never;
        wait_for_completion?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        actions?: never;
        detailed?: never;
        nodes?: never;
        parent_task_id?: never;
        h?: never;
        s?: never;
        time?: never;
        timeout?: never;
        wait_for_completion?: never;
    };
}
export type CatTasksResponse = CatTasksTasksRecord[];
export interface CatTasksTasksRecord {
    /** The identifier of the task with the node. */
    id?: Id;
    /** The task action. */
    action?: string;
    /** The task action.
      * @alias action */
    ac?: string;
    /** The unique task identifier. */
    task_id?: Id;
    /** The unique task identifier.
      * @alias task_id */
    ti?: Id;
    /** The parent task identifier. */
    parent_task_id?: string;
    /** The parent task identifier.
      * @alias parent_task_id */
    pti?: string;
    /** The task type. */
    type?: string;
    /** The task type.
      * @alias type */
    ty?: string;
    /** The start time in milliseconds. */
    start_time?: string;
    /** The start time in milliseconds.
      * @alias start_time */
    start?: string;
    /** The start time in `HH:MM:SS` format. */
    timestamp?: string;
    /** The start time in `HH:MM:SS` format.
      * @alias timestamp */
    ts?: string;
    /** The start time in `HH:MM:SS` format.
      * @alias timestamp */
    hms?: string;
    /** The start time in `HH:MM:SS` format.
      * @alias timestamp */
    hhmmss?: string;
    /** The running time in nanoseconds. */
    running_time_ns?: string;
    /** The running time. */
    running_time?: string;
    /** The running time.
      * @alias running_time */
    time?: string;
    /** The unique node identifier. */
    node_id?: NodeId;
    /** The unique node identifier.
      * @alias node_id */
    ni?: NodeId;
    /** The IP address for the node. */
    ip?: string;
    /** The IP address for the node.
      * @alias ip */
    i?: string;
    /** The bound transport port for the node. */
    port?: string;
    /** The bound transport port for the node.
      * @alias port */
    po?: string;
    /** The node name. */
    node?: string;
    /** The node name.
      * @alias node */
    n?: string;
    /** The Elasticsearch version. */
    version?: VersionString;
    /** The Elasticsearch version.
      * @alias version */
    v?: VersionString;
    /** The X-Opaque-ID header. */
    x_opaque_id?: string;
    /** The X-Opaque-ID header.
      * @alias x_opaque_id */
    x?: string;
    /** The task action description. */
    description?: string;
    /** The task action description.
      * @alias description */
    desc?: string;
}
export interface CatTemplatesRequest extends CatCatRequestBase {
    /** The name of the template to return.
      * Accepts wildcard expressions. If omitted, all templates are returned. */
    name?: Name;
    /** List of columns to appear in the response. Supports simple wildcards. */
    h?: Names;
    /** List of columns that determine how the table should be sorted.
      * Sorting defaults to ascending and can be changed by setting `:asc`
      * or `:desc` as a suffix to the column name. */
    s?: Names;
    /** If `true`, the request computes the list of selected nodes from the
      * local cluster state. If `false` the list of selected nodes are computed
      * from the cluster state of the master node. In both cases the coordinating
      * node will send requests for further information to each selected node. */
    local?: boolean;
    /** Period to wait for a connection to the master node. */
    master_timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        name?: never;
        h?: never;
        s?: never;
        local?: never;
        master_timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        name?: never;
        h?: never;
        s?: never;
        local?: never;
        master_timeout?: never;
    };
}
export type CatTemplatesResponse = CatTemplatesTemplatesRecord[];
export interface CatTemplatesTemplatesRecord {
    /** The template name. */
    name?: Name;
    /** The template name.
      * @alias name */
    n?: Name;
    /** The template index patterns. */
    index_patterns?: string;
    /** The template index patterns.
      * @alias index_patterns */
    t?: string;
    /** The template application order or priority number. */
    order?: string;
    /** The template application order or priority number.
      * @alias order */
    o?: string;
    /** The template application order or priority number.
      * @alias order */
    p?: string;
    /** The template version. */
    version?: VersionString | null;
    /** The template version.
      * @alias version */
    v?: VersionString | null;
    /** The component templates that comprise the index template. */
    composed_of?: string;
    /** The component templates that comprise the index template.
      * @alias composed_of */
    c?: string;
}
export interface CatThreadPoolRequest extends CatCatRequestBase {
    /** A comma-separated list of thread pool names used to limit the request.
      * Accepts wildcard expressions. */
    thread_pool_patterns?: Names;
    /** List of columns to appear in the response. Supports simple wildcards. */
    h?: CatCatThreadPoolColumns;
    /** A comma-separated list of column names or aliases that determines the sort order.
      * Sorting defaults to ascending and can be changed by setting `:asc`
      * or `:desc` as a suffix to the column name. */
    s?: Names;
    /** The unit used to display time values. */
    time?: TimeUnit;
    /** If `true`, the request computes the list of selected nodes from the
      * local cluster state. If `false` the list of selected nodes are computed
      * from the cluster state of the master node. In both cases the coordinating
      * node will send requests for further information to each selected node. */
    local?: boolean;
    /** The period to wait for a connection to the master node. */
    master_timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        thread_pool_patterns?: never;
        h?: never;
        s?: never;
        time?: never;
        local?: never;
        master_timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        thread_pool_patterns?: never;
        h?: never;
        s?: never;
        time?: never;
        local?: never;
        master_timeout?: never;
    };
}
export type CatThreadPoolResponse = CatThreadPoolThreadPoolRecord[];
export interface CatThreadPoolThreadPoolRecord {
    /** The node name. */
    node_name?: string;
    /** The node name.
      * @alias node_name */
    nn?: string;
    /** The persistent node identifier. */
    node_id?: NodeId;
    /** The persistent node identifier.
      * @alias node_id */
    id?: NodeId;
    /** The ephemeral node identifier. */
    ephemeral_node_id?: string;
    /** The ephemeral node identifier.
      * @alias ephemeral_node_id */
    eid?: string;
    /** The process identifier. */
    pid?: string;
    /** The process identifier.
      * @alias pid */
    p?: string;
    /** The host name for the current node. */
    host?: string;
    /** The host name for the current node.
      * @alias host */
    h?: string;
    /** The IP address for the current node. */
    ip?: string;
    /** The IP address for the current node.
      * @alias ip */
    i?: string;
    /** The bound transport port for the current node. */
    port?: string;
    /** The bound transport port for the current node.
      * @alias port */
    po?: string;
    /** The thread pool name. */
    name?: string;
    /** The thread pool name.
      * @alias name */
    n?: string;
    /** The thread pool type.
      * Returned values include `fixed`, `fixed_auto_queue_size`, `direct`, and `scaling`. */
    type?: string;
    /** The thread pool type.
      * Returned values include `fixed`, `fixed_auto_queue_size`, `direct`, and `scaling`.
      * @alias type */
    t?: string;
    /** The number of active threads in the current thread pool. */
    active?: string;
    /** The number of active threads in the current thread pool.
      * @alias active */
    a?: string;
    /** The number of threads in the current thread pool. */
    pool_size?: string;
    /** The number of threads in the current thread pool.
      * @alias pool_size */
    psz?: string;
    /** The number of tasks currently in queue. */
    queue?: string;
    /** The number of tasks currently in queue.
      * @alias queue */
    q?: string;
    /** The maximum number of tasks permitted in the queue. */
    queue_size?: string;
    /** The maximum number of tasks permitted in the queue.
      * @alias queue_size */
    qs?: string;
    /** The number of rejected tasks. */
    rejected?: string;
    /** The number of rejected tasks.
      * @alias rejected */
    r?: string;
    /** The highest number of active threads in the current thread pool. */
    largest?: string;
    /** The highest number of active threads in the current thread pool.
      * @alias largest */
    l?: string;
    /** The number of completed tasks. */
    completed?: string;
    /** The number of completed tasks.
      * @alias completed */
    c?: string;
    /** The core number of active threads allowed in a scaling thread pool. */
    core?: string | null;
    /** The core number of active threads allowed in a scaling thread pool.
      * @alias core */
    cr?: string | null;
    /** The maximum number of active threads allowed in a scaling thread pool. */
    max?: string | null;
    /** The maximum number of active threads allowed in a scaling thread pool.
      * @alias max */
    mx?: string | null;
    /** The number of active threads allowed in a fixed thread pool. */
    size?: string | null;
    /** The number of active threads allowed in a fixed thread pool.
      * @alias size */
    sz?: string | null;
    /** The thread keep alive time. */
    keep_alive?: string | null;
    /** The thread keep alive time.
      * @alias keep_alive */
    ka?: string | null;
}
export interface CatTransformsRequest extends CatCatRequestBase {
    /** A transform identifier or a wildcard expression.
      * If you do not specify one of these options, the API returns information for all transforms. */
    transform_id?: Id;
    /** Specifies what to do when the request: contains wildcard expressions and there are no transforms that match; contains the `_all` string or no identifiers and there are no matches; contains wildcard expressions and there are only partial matches.
      * If `true`, it returns an empty transforms array when there are no matches and the subset of results when there are partial matches.
      * If `false`, the request returns a 404 status code when there are no matches or only partial matches. */
    allow_no_match?: boolean;
    /** Skips the specified number of transforms. */
    from?: integer;
    /** Comma-separated list of column names to display. */
    h?: CatCatTransformColumns;
    /** Comma-separated list of column names or column aliases used to sort the response. */
    s?: CatCatTransformColumns;
    /** The unit used to display time values. */
    time?: TimeUnit;
    /** The maximum number of transforms to obtain. */
    size?: integer;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        transform_id?: never;
        allow_no_match?: never;
        from?: never;
        h?: never;
        s?: never;
        time?: never;
        size?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        transform_id?: never;
        allow_no_match?: never;
        from?: never;
        h?: never;
        s?: never;
        time?: never;
        size?: never;
    };
}
export type CatTransformsResponse = CatTransformsTransformsRecord[];
export interface CatTransformsTransformsRecord {
    /** The transform identifier. */
    id?: Id;
    /** The status of the transform.
      * Returned values include:
      * `aborting`: The transform is aborting.
      * `failed: The transform failed. For more information about the failure, check the `reason` field.
      * `indexing`: The transform is actively processing data and creating new documents.
      * `started`: The transform is running but not actively indexing data.
      * `stopped`: The transform is stopped.
      * `stopping`: The transform is stopping. */
    state?: string;
    /** The status of the transform.
      * Returned values include:
      * `aborting`: The transform is aborting.
      * `failed: The transform failed. For more information about the failure, check the `reason` field.
      * `indexing`: The transform is actively processing data and creating new documents.
      * `started`: The transform is running but not actively indexing data.
      * `stopped`: The transform is stopped.
      * `stopping`: The transform is stopping.
      * @alias state */
    s?: string;
    /** The sequence number for the checkpoint. */
    checkpoint?: string;
    /** The sequence number for the checkpoint.
      * @alias checkpoint */
    c?: string;
    /** The number of documents that have been processed from the source index of the transform. */
    documents_processed?: string;
    /** The number of documents that have been processed from the source index of the transform.
      * @alias documents_processed */
    docp?: string;
    /** The number of documents that have been processed from the source index of the transform.
      * @alias documents_processed */
    documentsProcessed?: string;
    /** The progress of the next checkpoint that is currently in progress. */
    checkpoint_progress?: string | null;
    /** The progress of the next checkpoint that is currently in progress.
      * @alias checkpoint_progress */
    cp?: string | null;
    /** The progress of the next checkpoint that is currently in progress.
      * @alias checkpoint_progress */
    checkpointProgress?: string | null;
    /** The timestamp of the last search in the source indices.
      * This field is shown only if the transform is running. */
    last_search_time?: string | null;
    /** The timestamp of the last search in the source indices.
      * This field is shown only if the transform is running.
      * @alias last_search_time */
    lst?: string | null;
    /** The timestamp of the last search in the source indices.
      * This field is shown only if the transform is running.
      * @alias last_search_time */
    lastSearchTime?: string | null;
    /** The timestamp when changes were last detected in the source indices. */
    changes_last_detection_time?: string | null;
    /** The timestamp when changes were last detected in the source indices.
      * @alias changes_last_detection_time */
    cldt?: string | null;
    /** The time the transform was created. */
    create_time?: string;
    /** The time the transform was created.
      * @alias create_time */
    ct?: string;
    /** The time the transform was created.
      * @alias create_time */
    createTime?: string;
    /** The version of Elasticsearch that existed on the node when the transform was created. */
    version?: VersionString;
    /** The version of Elasticsearch that existed on the node when the transform was created.
      * @alias version */
    v?: VersionString;
    /** The source indices for the transform. */
    source_index?: string;
    /** The source indices for the transform.
      * @alias source_index */
    si?: string;
    /** The source indices for the transform.
      * @alias source_index */
    sourceIndex?: string;
    /** The destination index for the transform. */
    dest_index?: string;
    /** The destination index for the transform.
      * @alias dest_index */
    di?: string;
    /** The destination index for the transform.
      * @alias dest_index */
    destIndex?: string;
    /** The unique identifier for the ingest pipeline. */
    pipeline?: string;
    /** The unique identifier for the ingest pipeline.
      * @alias pipeline */
    p?: string;
    /** The description of the transform. */
    description?: string;
    /** The description of the transform.
      * @alias description */
    d?: string;
    /** The type of transform: `batch` or `continuous`. */
    transform_type?: string;
    /** The type of transform: `batch` or `continuous`.
      * @alias transform_type */
    tt?: string;
    /** The interval between checks for changes in the source indices when the transform is running continuously. */
    frequency?: string;
    /** The interval between checks for changes in the source indices when the transform is running continuously.
      * @alias frequency */
    f?: string;
    /** The initial page size that is used for the composite aggregation for each checkpoint. */
    max_page_search_size?: string;
    /** The initial page size that is used for the composite aggregation for each checkpoint.
      * @alias max_page_search_size */
    mpsz?: string;
    /** The number of input documents per second. */
    docs_per_second?: string;
    /** The number of input documents per second.
      * @alias docs_per_second */
    dps?: string;
    /** If a transform has a `failed` state, these details describe the reason for failure. */
    reason?: string;
    /** If a transform has a `failed` state, these details describe the reason for failure.
      * @alias reason */
    r?: string;
    /** The total number of search operations on the source index for the transform. */
    search_total?: string;
    /** The total number of search operations on the source index for the transform.
      * @alias search_total */
    st?: string;
    /** The total number of search failures. */
    search_failure?: string;
    /** The total number of search failures.
      * @alias search_failure */
    sf?: string;
    /** The total amount of search time, in milliseconds. */
    search_time?: string;
    /** The total amount of search time, in milliseconds.
      * @alias search_time */
    stime?: string;
    /** The total number of index operations done by the transform. */
    index_total?: string;
    /** The total number of index operations done by the transform.
      * @alias index_total */
    it?: string;
    /** The total number of indexing failures. */
    index_failure?: string;
    /** The total number of indexing failures.
      * @alias index_failure */
    if?: string;
    /** The total time spent indexing documents, in milliseconds. */
    index_time?: string;
    /** The total time spent indexing documents, in milliseconds.
      * @alias index_time */
    itime?: string;
    /** The number of documents that have been indexed into the destination index for the transform. */
    documents_indexed?: string;
    /** The number of documents that have been indexed into the destination index for the transform.
      * @alias documents_indexed */
    doci?: string;
    /** The total time spent deleting documents, in milliseconds. */
    delete_time?: string;
    /** The total time spent deleting documents, in milliseconds.
      * @alias delete_time */
    dtime?: string;
    /** The number of documents deleted from the destination index due to the retention policy for the transform. */
    documents_deleted?: string;
    /** The number of documents deleted from the destination index due to the retention policy for the transform.
      * @alias documents_deleted */
    docd?: string;
    /** The number of times the transform has been triggered by the scheduler.
      * For example, the scheduler triggers the transform indexer to check for updates or ingest new data at an interval specified in the `frequency` property. */
    trigger_count?: string;
    /** The number of times the transform has been triggered by the scheduler.
      * For example, the scheduler triggers the transform indexer to check for updates or ingest new data at an interval specified in the `frequency` property.
      * @alias trigger_count */
    tc?: string;
    /** The number of search or bulk index operations processed.
      * Documents are processed in batches instead of individually. */
    pages_processed?: string;
    /** The number of search or bulk index operations processed.
      * Documents are processed in batches instead of individually.
      * @alias pages_processed */
    pp?: string;
    /** The total time spent processing results, in milliseconds. */
    processing_time?: string;
    /** The total time spent processing results, in milliseconds.
      * @alias processing_time */
    pt?: string;
    /** The exponential moving average of the duration of the checkpoint, in milliseconds. */
    checkpoint_duration_time_exp_avg?: string;
    /** The exponential moving average of the duration of the checkpoint, in milliseconds.
      * @alias checkpoint_duration_time_exp_avg */
    cdtea?: string;
    /** The exponential moving average of the duration of the checkpoint, in milliseconds.
      * @alias checkpoint_duration_time_exp_avg */
    checkpointTimeExpAvg?: string;
    /** The exponential moving average of the number of new documents that have been indexed. */
    indexed_documents_exp_avg?: string;
    /** The exponential moving average of the number of new documents that have been indexed.
      * @alias indexed_documents_exp_avg */
    idea?: string;
    /** The exponential moving average of the number of documents that have been processed. */
    processed_documents_exp_avg?: string;
    /** The exponential moving average of the number of documents that have been processed.
      * @alias processed_documents_exp_avg */
    pdea?: string;
}
export interface CcrFollowIndexStats {
    /** The name of the follower index. */
    index: IndexName;
    /** An array of shard-level following task statistics. */
    shards: CcrShardStats[];
}
export interface CcrReadException {
    /** The exception that caused the read to fail. */
    exception: ErrorCause;
    /** The starting sequence number of the batch requested from the leader. */
    from_seq_no: SequenceNumber;
    /** The number of times the batch has been retried. */
    retries: integer;
}
export interface CcrShardStats {
    /** The total of transferred bytes read from the leader.
      * This is only an estimate and does not account for compression if enabled. */
    bytes_read: long;
    /** The number of failed reads. */
    failed_read_requests: long;
    /** The number of failed bulk write requests on the follower. */
    failed_write_requests: long;
    fatal_exception?: ErrorCause;
    /** The index aliases version the follower is synced up to. */
    follower_aliases_version: VersionNumber;
    /** The current global checkpoint on the follower.
      * The difference between the `leader_global_checkpoint` and the `follower_global_checkpoint` is an indication of how much the follower is lagging the leader. */
    follower_global_checkpoint: long;
    /** The name of the follower index. */
    follower_index: string;
    /** The mapping version the follower is synced up to. */
    follower_mapping_version: VersionNumber;
    /** The current maximum sequence number on the follower. */
    follower_max_seq_no: SequenceNumber;
    /** The index settings version the follower is synced up to. */
    follower_settings_version: VersionNumber;
    /** The starting sequence number of the last batch of operations requested from the leader. */
    last_requested_seq_no: SequenceNumber;
    /** The current global checkpoint on the leader known to the follower task. */
    leader_global_checkpoint: long;
    /** The name of the index in the leader cluster being followed. */
    leader_index: string;
    /** The current maximum sequence number on the leader known to the follower task. */
    leader_max_seq_no: SequenceNumber;
    /** The total number of operations read from the leader. */
    operations_read: long;
    /** The number of operations written on the follower. */
    operations_written: long;
    /** The number of active read requests from the follower. */
    outstanding_read_requests: integer;
    /** The number of active bulk write requests on the follower. */
    outstanding_write_requests: integer;
    /** An array of objects representing failed reads. */
    read_exceptions: CcrReadException[];
    /** The remote cluster containing the leader index. */
    remote_cluster: string;
    /** The numerical shard ID, with values from 0 to one less than the number of replicas. */
    shard_id: integer;
    /** The number of successful fetches. */
    successful_read_requests: long;
    /** The number of bulk write requests run on the follower. */
    successful_write_requests: long;
    time_since_last_read?: Duration;
    /** The number of milliseconds since a read request was sent to the leader.
      * When the follower is caught up to the leader, this number will increase up to the configured `read_poll_timeout` at which point another read request will be sent to the leader. */
    time_since_last_read_millis: DurationValue<UnitMillis>;
    total_read_remote_exec_time?: Duration;
    /** The total time reads spent running on the remote cluster. */
    total_read_remote_exec_time_millis: DurationValue<UnitMillis>;
    total_read_time?: Duration;
    /** The total time reads were outstanding, measured from the time a read was sent to the leader to the time a reply was returned to the follower. */
    total_read_time_millis: DurationValue<UnitMillis>;
    total_write_time?: Duration;
    /** The total time spent writing on the follower. */
    total_write_time_millis: DurationValue<UnitMillis>;
    /** The number of write operations queued on the follower. */
    write_buffer_operation_count: long;
    /** The total number of bytes of operations currently queued for writing. */
    write_buffer_size_in_bytes: ByteSize;
}
export interface CcrDeleteAutoFollowPatternRequest extends RequestBase {
    /** The auto-follow pattern collection to delete. */
    name: Name;
    /** The period to wait for a connection to the master node.
      * If the master node is not available before the timeout expires, the request fails and returns an error.
      * It can also be set to `-1` to indicate that the request should never timeout. */
    master_timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        name?: never;
        master_timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        name?: never;
        master_timeout?: never;
    };
}
export type CcrDeleteAutoFollowPatternResponse = AcknowledgedResponseBase;
export interface CcrFollowRequest extends RequestBase {
    /** The name of the follower index. */
    index: IndexName;
    /** Period to wait for a connection to the master node. */
    master_timeout?: Duration;
    /** Specifies the number of shards to wait on being active before responding. This defaults to waiting on none of the shards to be
      * active.
      * A shard must be restored from the leader index before being active. Restoring a follower shard requires transferring all the
      * remote Lucene segment files to the follower index. */
    wait_for_active_shards?: WaitForActiveShards;
    /** If the leader index is part of a data stream, the name to which the local data stream for the followed index should be renamed. */
    data_stream_name?: string;
    /** The name of the index in the leader cluster to follow. */
    leader_index: IndexName;
    /** The maximum number of outstanding reads requests from the remote cluster. */
    max_outstanding_read_requests?: long;
    /** The maximum number of outstanding write requests on the follower. */
    max_outstanding_write_requests?: integer;
    /** The maximum number of operations to pull per read from the remote cluster. */
    max_read_request_operation_count?: integer;
    /** The maximum size in bytes of per read of a batch of operations pulled from the remote cluster. */
    max_read_request_size?: ByteSize;
    /** The maximum time to wait before retrying an operation that failed exceptionally. An exponential backoff strategy is employed when
      * retrying. */
    max_retry_delay?: Duration;
    /** The maximum number of operations that can be queued for writing. When this limit is reached, reads from the remote cluster will be
      * deferred until the number of queued operations goes below the limit. */
    max_write_buffer_count?: integer;
    /** The maximum total bytes of operations that can be queued for writing. When this limit is reached, reads from the remote cluster will
      * be deferred until the total bytes of queued operations goes below the limit. */
    max_write_buffer_size?: ByteSize;
    /** The maximum number of operations per bulk write request executed on the follower. */
    max_write_request_operation_count?: integer;
    /** The maximum total bytes of operations per bulk write request executed on the follower. */
    max_write_request_size?: ByteSize;
    /** The maximum time to wait for new operations on the remote cluster when the follower index is synchronized with the leader index.
      * When the timeout has elapsed, the poll for operations will return to the follower so that it can update some statistics.
      * Then the follower will immediately attempt to read from the leader again. */
    read_poll_timeout?: Duration;
    /** The remote cluster containing the leader index. */
    remote_cluster: string;
    /** Settings to override from the leader index. */
    settings?: IndicesIndexSettings;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
        master_timeout?: never;
        wait_for_active_shards?: never;
        data_stream_name?: never;
        leader_index?: never;
        max_outstanding_read_requests?: never;
        max_outstanding_write_requests?: never;
        max_read_request_operation_count?: never;
        max_read_request_size?: never;
        max_retry_delay?: never;
        max_write_buffer_count?: never;
        max_write_buffer_size?: never;
        max_write_request_operation_count?: never;
        max_write_request_size?: never;
        read_poll_timeout?: never;
        remote_cluster?: never;
        settings?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
        master_timeout?: never;
        wait_for_active_shards?: never;
        data_stream_name?: never;
        leader_index?: never;
        max_outstanding_read_requests?: never;
        max_outstanding_write_requests?: never;
        max_read_request_operation_count?: never;
        max_read_request_size?: never;
        max_retry_delay?: never;
        max_write_buffer_count?: never;
        max_write_buffer_size?: never;
        max_write_request_operation_count?: never;
        max_write_request_size?: never;
        read_poll_timeout?: never;
        remote_cluster?: never;
        settings?: never;
    };
}
export interface CcrFollowResponse {
    follow_index_created: boolean;
    follow_index_shards_acked: boolean;
    index_following_started: boolean;
}
export interface CcrFollowInfoFollowerIndex {
    /** The name of the follower index. */
    follower_index: IndexName;
    /** The name of the index in the leader cluster that is followed. */
    leader_index: IndexName;
    /** An object that encapsulates cross-cluster replication parameters. If the follower index's status is paused, this object is omitted. */
    parameters?: CcrFollowInfoFollowerIndexParameters;
    /** The remote cluster that contains the leader index. */
    remote_cluster: Name;
    /** The status of the index following: `active` or `paused`. */
    status: CcrFollowInfoFollowerIndexStatus;
}
export interface CcrFollowInfoFollowerIndexParameters {
    /** The maximum number of outstanding reads requests from the remote cluster. */
    max_outstanding_read_requests?: long;
    /** The maximum number of outstanding write requests on the follower. */
    max_outstanding_write_requests?: integer;
    /** The maximum number of operations to pull per read from the remote cluster. */
    max_read_request_operation_count?: integer;
    /** The maximum size in bytes of per read of a batch of operations pulled from the remote cluster. */
    max_read_request_size?: ByteSize;
    /** The maximum time to wait before retrying an operation that failed exceptionally. An exponential backoff strategy is employed when
      * retrying. */
    max_retry_delay?: Duration;
    /** The maximum number of operations that can be queued for writing. When this limit is reached, reads from the remote cluster will be
      * deferred until the number of queued operations goes below the limit. */
    max_write_buffer_count?: integer;
    /** The maximum total bytes of operations that can be queued for writing. When this limit is reached, reads from the remote cluster will
      * be deferred until the total bytes of queued operations goes below the limit. */
    max_write_buffer_size?: ByteSize;
    /** The maximum number of operations per bulk write request executed on the follower. */
    max_write_request_operation_count?: integer;
    /** The maximum total bytes of operations per bulk write request executed on the follower. */
    max_write_request_size?: ByteSize;
    /** The maximum time to wait for new operations on the remote cluster when the follower index is synchronized with the leader index.
      * When the timeout has elapsed, the poll for operations will return to the follower so that it can update some statistics.
      * Then the follower will immediately attempt to read from the leader again. */
    read_poll_timeout?: Duration;
}
export type CcrFollowInfoFollowerIndexStatus = 'active' | 'paused';
export interface CcrFollowInfoRequest extends RequestBase {
    /** A comma-delimited list of follower index patterns. */
    index: Indices;
    /** The period to wait for a connection to the master node.
      * If the master node is not available before the timeout expires, the request fails and returns an error.
      * It can also be set to `-1` to indicate that the request should never timeout. */
    master_timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
        master_timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
        master_timeout?: never;
    };
}
export interface CcrFollowInfoResponse {
    follower_indices: CcrFollowInfoFollowerIndex[];
}
export interface CcrFollowStatsRequest extends RequestBase {
    /** A comma-delimited list of index patterns. */
    index: Indices;
    /** The period to wait for a response.
      * If no response is received before the timeout expires, the request fails and returns an error. */
    timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
        timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
        timeout?: never;
    };
}
export interface CcrFollowStatsResponse {
    /** An array of follower index statistics. */
    indices: CcrFollowIndexStats[];
}
export interface CcrForgetFollowerRequest extends RequestBase {
    /** the name of the leader index for which specified follower retention leases should be removed */
    index: IndexName;
    /** Period to wait for a response. If no response is received before the timeout expires, the request fails and returns an error. */
    timeout?: Duration;
    follower_cluster?: string;
    follower_index?: IndexName;
    follower_index_uuid?: Uuid;
    leader_remote_cluster?: string;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
        timeout?: never;
        follower_cluster?: never;
        follower_index?: never;
        follower_index_uuid?: never;
        leader_remote_cluster?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
        timeout?: never;
        follower_cluster?: never;
        follower_index?: never;
        follower_index_uuid?: never;
        leader_remote_cluster?: never;
    };
}
export interface CcrForgetFollowerResponse {
    _shards: ShardStatistics;
}
export interface CcrGetAutoFollowPatternAutoFollowPattern {
    name: Name;
    pattern: CcrGetAutoFollowPatternAutoFollowPatternSummary;
}
export interface CcrGetAutoFollowPatternAutoFollowPatternSummary {
    active: boolean;
    /** The remote cluster containing the leader indices to match against. */
    remote_cluster: string;
    /** The name of follower index. */
    follow_index_pattern?: IndexPattern;
    /** An array of simple index patterns to match against indices in the remote cluster specified by the remote_cluster field. */
    leader_index_patterns: IndexPatterns;
    /** An array of simple index patterns that can be used to exclude indices from being auto-followed. */
    leader_index_exclusion_patterns: IndexPatterns;
    /** The maximum number of outstanding reads requests from the remote cluster. */
    max_outstanding_read_requests: integer;
}
export interface CcrGetAutoFollowPatternRequest extends RequestBase {
    /** The auto-follow pattern collection that you want to retrieve.
      * If you do not specify a name, the API returns information for all collections. */
    name?: Name;
    /** The period to wait for a connection to the master node.
      * If the master node is not available before the timeout expires, the request fails and returns an error.
      * It can also be set to `-1` to indicate that the request should never timeout. */
    master_timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        name?: never;
        master_timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        name?: never;
        master_timeout?: never;
    };
}
export interface CcrGetAutoFollowPatternResponse {
    patterns: CcrGetAutoFollowPatternAutoFollowPattern[];
}
export interface CcrPauseAutoFollowPatternRequest extends RequestBase {
    /** The name of the auto-follow pattern to pause. */
    name: Name;
    /** The period to wait for a connection to the master node.
      * If the master node is not available before the timeout expires, the request fails and returns an error.
      * It can also be set to `-1` to indicate that the request should never timeout. */
    master_timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        name?: never;
        master_timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        name?: never;
        master_timeout?: never;
    };
}
export type CcrPauseAutoFollowPatternResponse = AcknowledgedResponseBase;
export interface CcrPauseFollowRequest extends RequestBase {
    /** The name of the follower index. */
    index: IndexName;
    /** The period to wait for a connection to the master node.
      * If the master node is not available before the timeout expires, the request fails and returns an error.
      * It can also be set to `-1` to indicate that the request should never timeout. */
    master_timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
        master_timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
        master_timeout?: never;
    };
}
export type CcrPauseFollowResponse = AcknowledgedResponseBase;
export interface CcrPutAutoFollowPatternRequest extends RequestBase {
    /** The name of the collection of auto-follow patterns. */
    name: Name;
    /** Period to wait for a connection to the master node. */
    master_timeout?: Duration;
    /** The remote cluster containing the leader indices to match against. */
    remote_cluster: string;
    /** The name of follower index. The template {{leader_index}} can be used to derive the name of the follower index from the name of the leader index. When following a data stream, use {{leader_index}}; CCR does not support changes to the names of a follower data stream’s backing indices. */
    follow_index_pattern?: IndexPattern;
    /** An array of simple index patterns to match against indices in the remote cluster specified by the remote_cluster field. */
    leader_index_patterns?: IndexPatterns;
    /** An array of simple index patterns that can be used to exclude indices from being auto-followed. Indices in the remote cluster whose names are matching one or more leader_index_patterns and one or more leader_index_exclusion_patterns won’t be followed. */
    leader_index_exclusion_patterns?: IndexPatterns;
    /** The maximum number of outstanding reads requests from the remote cluster. */
    max_outstanding_read_requests?: integer;
    /** Settings to override from the leader index. Note that certain settings can not be overrode (e.g., index.number_of_shards). */
    settings?: Record<string, any>;
    /** The maximum number of outstanding reads requests from the remote cluster. */
    max_outstanding_write_requests?: integer;
    /** The maximum time to wait for new operations on the remote cluster when the follower index is synchronized with the leader index. When the timeout has elapsed, the poll for operations will return to the follower so that it can update some statistics. Then the follower will immediately attempt to read from the leader again. */
    read_poll_timeout?: Duration;
    /** The maximum number of operations to pull per read from the remote cluster. */
    max_read_request_operation_count?: integer;
    /** The maximum size in bytes of per read of a batch of operations pulled from the remote cluster. */
    max_read_request_size?: ByteSize;
    /** The maximum time to wait before retrying an operation that failed exceptionally. An exponential backoff strategy is employed when retrying. */
    max_retry_delay?: Duration;
    /** The maximum number of operations that can be queued for writing. When this limit is reached, reads from the remote cluster will be deferred until the number of queued operations goes below the limit. */
    max_write_buffer_count?: integer;
    /** The maximum total bytes of operations that can be queued for writing. When this limit is reached, reads from the remote cluster will be deferred until the total bytes of queued operations goes below the limit. */
    max_write_buffer_size?: ByteSize;
    /** The maximum number of operations per bulk write request executed on the follower. */
    max_write_request_operation_count?: integer;
    /** The maximum total bytes of operations per bulk write request executed on the follower. */
    max_write_request_size?: ByteSize;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        name?: never;
        master_timeout?: never;
        remote_cluster?: never;
        follow_index_pattern?: never;
        leader_index_patterns?: never;
        leader_index_exclusion_patterns?: never;
        max_outstanding_read_requests?: never;
        settings?: never;
        max_outstanding_write_requests?: never;
        read_poll_timeout?: never;
        max_read_request_operation_count?: never;
        max_read_request_size?: never;
        max_retry_delay?: never;
        max_write_buffer_count?: never;
        max_write_buffer_size?: never;
        max_write_request_operation_count?: never;
        max_write_request_size?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        name?: never;
        master_timeout?: never;
        remote_cluster?: never;
        follow_index_pattern?: never;
        leader_index_patterns?: never;
        leader_index_exclusion_patterns?: never;
        max_outstanding_read_requests?: never;
        settings?: never;
        max_outstanding_write_requests?: never;
        read_poll_timeout?: never;
        max_read_request_operation_count?: never;
        max_read_request_size?: never;
        max_retry_delay?: never;
        max_write_buffer_count?: never;
        max_write_buffer_size?: never;
        max_write_request_operation_count?: never;
        max_write_request_size?: never;
    };
}
export type CcrPutAutoFollowPatternResponse = AcknowledgedResponseBase;
export interface CcrResumeAutoFollowPatternRequest extends RequestBase {
    /** The name of the auto-follow pattern to resume. */
    name: Name;
    /** The period to wait for a connection to the master node.
      * If the master node is not available before the timeout expires, the request fails and returns an error.
      * It can also be set to `-1` to indicate that the request should never timeout. */
    master_timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        name?: never;
        master_timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        name?: never;
        master_timeout?: never;
    };
}
export type CcrResumeAutoFollowPatternResponse = AcknowledgedResponseBase;
export interface CcrResumeFollowRequest extends RequestBase {
    /** The name of the follow index to resume following. */
    index: IndexName;
    /** Period to wait for a connection to the master node. */
    master_timeout?: Duration;
    max_outstanding_read_requests?: long;
    max_outstanding_write_requests?: long;
    max_read_request_operation_count?: long;
    max_read_request_size?: string;
    max_retry_delay?: Duration;
    max_write_buffer_count?: long;
    max_write_buffer_size?: string;
    max_write_request_operation_count?: long;
    max_write_request_size?: string;
    read_poll_timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
        master_timeout?: never;
        max_outstanding_read_requests?: never;
        max_outstanding_write_requests?: never;
        max_read_request_operation_count?: never;
        max_read_request_size?: never;
        max_retry_delay?: never;
        max_write_buffer_count?: never;
        max_write_buffer_size?: never;
        max_write_request_operation_count?: never;
        max_write_request_size?: never;
        read_poll_timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
        master_timeout?: never;
        max_outstanding_read_requests?: never;
        max_outstanding_write_requests?: never;
        max_read_request_operation_count?: never;
        max_read_request_size?: never;
        max_retry_delay?: never;
        max_write_buffer_count?: never;
        max_write_buffer_size?: never;
        max_write_request_operation_count?: never;
        max_write_request_size?: never;
        read_poll_timeout?: never;
    };
}
export type CcrResumeFollowResponse = AcknowledgedResponseBase;
export interface CcrStatsAutoFollowStats {
    auto_followed_clusters: CcrStatsAutoFollowedCluster[];
    /** The number of indices that the auto-follow coordinator failed to automatically follow.
      * The causes of recent failures are captured in the logs of the elected master node and in the `auto_follow_stats.recent_auto_follow_errors` field. */
    number_of_failed_follow_indices: long;
    /** The number of times that the auto-follow coordinator failed to retrieve the cluster state from a remote cluster registered in a collection of auto-follow patterns. */
    number_of_failed_remote_cluster_state_requests: long;
    /** The number of indices that the auto-follow coordinator successfully followed. */
    number_of_successful_follow_indices: long;
    /** An array of objects representing failures by the auto-follow coordinator. */
    recent_auto_follow_errors: ErrorCause[];
}
export interface CcrStatsAutoFollowedCluster {
    cluster_name: Name;
    last_seen_metadata_version: VersionNumber;
    time_since_last_check_millis: DurationValue<UnitMillis>;
}
export interface CcrStatsFollowStats {
    indices: CcrFollowIndexStats[];
}
export interface CcrStatsRequest extends RequestBase {
    /** The period to wait for a connection to the master node.
      * If the master node is not available before the timeout expires, the request fails and returns an error.
      * It can also be set to `-1` to indicate that the request should never timeout. */
    master_timeout?: Duration;
    /** The period to wait for a response. If no response is received before the timeout expires, the request fails and returns an error. */
    timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        master_timeout?: never;
        timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        master_timeout?: never;
        timeout?: never;
    };
}
export interface CcrStatsResponse {
    /** Statistics for the auto-follow coordinator. */
    auto_follow_stats: CcrStatsAutoFollowStats;
    /** Shard-level statistics for follower indices. */
    follow_stats: CcrStatsFollowStats;
}
export interface CcrUnfollowRequest extends RequestBase {
    /** The name of the follower index. */
    index: IndexName;
    /** The period to wait for a connection to the master node.
      * If the master node is not available before the timeout expires, the request fails and returns an error.
      * It can also be set to `-1` to indicate that the request should never timeout. */
    master_timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
        master_timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
        master_timeout?: never;
    };
}
export type CcrUnfollowResponse = AcknowledgedResponseBase;
export interface ClusterComponentTemplate {
    name: Name;
    component_template: ClusterComponentTemplateNode;
}
export interface ClusterComponentTemplateNode {
    template: ClusterComponentTemplateSummary;
    version?: VersionNumber;
    _meta?: Metadata;
    deprecated?: boolean;
}
export interface ClusterComponentTemplateSummary {
    _meta?: Metadata;
    version?: VersionNumber;
    settings?: Record<IndexName, IndicesIndexSettings>;
    mappings?: MappingTypeMapping;
    aliases?: Record<string, IndicesAliasDefinition>;
    lifecycle?: IndicesDataStreamLifecycleWithRollover;
    data_stream_options?: IndicesDataStreamOptionsTemplate | null;
}
export interface ClusterAllocationExplainAllocationDecision {
    decider: string;
    decision: ClusterAllocationExplainAllocationExplainDecision;
    explanation: string;
}
export type ClusterAllocationExplainAllocationExplainDecision = 'NO' | 'YES' | 'THROTTLE' | 'ALWAYS';
export interface ClusterAllocationExplainAllocationStore {
    allocation_id: string;
    found: boolean;
    in_sync: boolean;
    matching_size_in_bytes: long;
    matching_sync_id: boolean;
    store_exception: string;
}
export interface ClusterAllocationExplainClusterInfo {
    nodes: Record<string, ClusterAllocationExplainNodeDiskUsage>;
    shard_sizes: Record<string, long>;
    shard_data_set_sizes?: Record<string, string>;
    shard_paths: Record<string, string>;
    reserved_sizes: ClusterAllocationExplainReservedSize[];
}
export interface ClusterAllocationExplainCurrentNode {
    id: Id;
    name: Name;
    roles: NodeRoles;
    attributes: Record<string, string>;
    transport_address: TransportAddress;
    weight_ranking: integer;
}
export type ClusterAllocationExplainDecision = 'yes' | 'no' | 'worse_balance' | 'throttled' | 'awaiting_info' | 'allocation_delayed' | 'no_valid_shard_copy' | 'no_attempt';
export interface ClusterAllocationExplainDiskUsage {
    path: string;
    total_bytes: long;
    used_bytes: long;
    free_bytes: long;
    free_disk_percent: double;
    used_disk_percent: double;
}
export interface ClusterAllocationExplainNodeAllocationExplanation {
    deciders: ClusterAllocationExplainAllocationDecision[];
    node_attributes: Record<string, string>;
    node_decision: ClusterAllocationExplainDecision;
    node_id: Id;
    node_name: Name;
    roles: NodeRoles;
    store?: ClusterAllocationExplainAllocationStore;
    transport_address: TransportAddress;
    weight_ranking: integer;
}
export interface ClusterAllocationExplainNodeDiskUsage {
    node_name: Name;
    least_available: ClusterAllocationExplainDiskUsage;
    most_available: ClusterAllocationExplainDiskUsage;
}
export interface ClusterAllocationExplainRequest extends RequestBase {
    /** If true, returns information about disk usage and shard sizes. */
    include_disk_info?: boolean;
    /** If true, returns YES decisions in explanation. */
    include_yes_decisions?: boolean;
    /** Period to wait for a connection to the master node. */
    master_timeout?: Duration;
    /** Specifies the node ID or the name of the node to only explain a shard that is currently located on the specified node. */
    current_node?: string;
    /** Specifies the name of the index that you would like an explanation for. */
    index?: IndexName;
    /** If true, returns explanation for the primary shard for the given shard ID. */
    primary?: boolean;
    /** Specifies the ID of the shard that you would like an explanation for. */
    shard?: integer;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        include_disk_info?: never;
        include_yes_decisions?: never;
        master_timeout?: never;
        current_node?: never;
        index?: never;
        primary?: never;
        shard?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        include_disk_info?: never;
        include_yes_decisions?: never;
        master_timeout?: never;
        current_node?: never;
        index?: never;
        primary?: never;
        shard?: never;
    };
}
export interface ClusterAllocationExplainReservedSize {
    node_id: Id;
    path: string;
    total: long;
    shards: string[];
}
export interface ClusterAllocationExplainResponse {
    allocate_explanation?: string;
    allocation_delay?: Duration;
    allocation_delay_in_millis?: DurationValue<UnitMillis>;
    can_allocate?: ClusterAllocationExplainDecision;
    can_move_to_other_node?: ClusterAllocationExplainDecision;
    can_rebalance_cluster?: ClusterAllocationExplainDecision;
    can_rebalance_cluster_decisions?: ClusterAllocationExplainAllocationDecision[];
    can_rebalance_to_other_node?: ClusterAllocationExplainDecision;
    can_remain_decisions?: ClusterAllocationExplainAllocationDecision[];
    can_remain_on_current_node?: ClusterAllocationExplainDecision;
    cluster_info?: ClusterAllocationExplainClusterInfo;
    configured_delay?: Duration;
    configured_delay_in_millis?: DurationValue<UnitMillis>;
    current_node?: ClusterAllocationExplainCurrentNode;
    current_state: string;
    index: IndexName;
    move_explanation?: string;
    node_allocation_decisions?: ClusterAllocationExplainNodeAllocationExplanation[];
    primary: boolean;
    rebalance_explanation?: string;
    remaining_delay?: Duration;
    remaining_delay_in_millis?: DurationValue<UnitMillis>;
    shard: integer;
    unassigned_info?: ClusterAllocationExplainUnassignedInformation;
    note?: string;
}
export interface ClusterAllocationExplainUnassignedInformation {
    at: DateTime;
    last_allocation_status?: string;
    reason: ClusterAllocationExplainUnassignedInformationReason;
    details?: string;
    failed_allocation_attempts?: integer;
    delayed?: boolean;
    allocation_status?: string;
}
export type ClusterAllocationExplainUnassignedInformationReason = 'INDEX_CREATED' | 'CLUSTER_RECOVERED' | 'INDEX_REOPENED' | 'DANGLING_INDEX_IMPORTED' | 'NEW_INDEX_RESTORED' | 'EXISTING_INDEX_RESTORED' | 'REPLICA_ADDED' | 'ALLOCATION_FAILED' | 'NODE_LEFT' | 'REROUTE_CANCELLED' | 'REINITIALIZED' | 'REALLOCATED_REPLICA' | 'PRIMARY_FAILED' | 'FORCED_EMPTY_PRIMARY' | 'MANUAL_ALLOCATION';
export interface ClusterDeleteComponentTemplateRequest extends RequestBase {
    /** Comma-separated list or wildcard expression of component template names used to limit the request. */
    name: Names;
    /** Period to wait for a connection to the master node.
      * If no response is received before the timeout expires, the request fails and returns an error. */
    master_timeout?: Duration;
    /** Period to wait for a response.
      * If no response is received before the timeout expires, the request fails and returns an error. */
    timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        name?: never;
        master_timeout?: never;
        timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        name?: never;
        master_timeout?: never;
        timeout?: never;
    };
}
export type ClusterDeleteComponentTemplateResponse = AcknowledgedResponseBase;
export interface ClusterDeleteVotingConfigExclusionsRequest extends RequestBase {
    /** Period to wait for a connection to the master node. */
    master_timeout?: Duration;
    /** Specifies whether to wait for all excluded nodes to be removed from the
      * cluster before clearing the voting configuration exclusions list.
      * Defaults to true, meaning that all excluded nodes must be removed from
      * the cluster before this API takes any action. If set to false then the
      * voting configuration exclusions list is cleared even if some excluded
      * nodes are still in the cluster. */
    wait_for_removal?: boolean;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        master_timeout?: never;
        wait_for_removal?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        master_timeout?: never;
        wait_for_removal?: never;
    };
}
export type ClusterDeleteVotingConfigExclusionsResponse = boolean;
export interface ClusterExistsComponentTemplateRequest extends RequestBase {
    /** Comma-separated list of component template names used to limit the request.
      * Wildcard (*) expressions are supported. */
    name: Names;
    /** Period to wait for a connection to the master node. If no response is
      * received before the timeout expires, the request fails and returns an
      * error. */
    master_timeout?: Duration;
    /** If true, the request retrieves information from the local node only.
      * Defaults to false, which means information is retrieved from the master node. */
    local?: boolean;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        name?: never;
        master_timeout?: never;
        local?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        name?: never;
        master_timeout?: never;
        local?: never;
    };
}
export type ClusterExistsComponentTemplateResponse = boolean;
export interface ClusterGetComponentTemplateRequest extends RequestBase {
    /** Comma-separated list of component template names used to limit the request.
      * Wildcard (`*`) expressions are supported. */
    name?: Name;
    /** If `true`, returns settings in flat format. */
    flat_settings?: boolean;
    /** Filter out results, for example to filter out sensitive information. Supports wildcards or full settings keys */
    settings_filter?: string | string[];
    /** Return all default configurations for the component template (default: false) */
    include_defaults?: boolean;
    /** If `true`, the request retrieves information from the local node only.
      * If `false`, information is retrieved from the master node. */
    local?: boolean;
    /** Period to wait for a connection to the master node.
      * If no response is received before the timeout expires, the request fails and returns an error. */
    master_timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        name?: never;
        flat_settings?: never;
        settings_filter?: never;
        include_defaults?: never;
        local?: never;
        master_timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        name?: never;
        flat_settings?: never;
        settings_filter?: never;
        include_defaults?: never;
        local?: never;
        master_timeout?: never;
    };
}
export interface ClusterGetComponentTemplateResponse {
    component_templates: ClusterComponentTemplate[];
}
export interface ClusterGetSettingsRequest extends RequestBase {
    /** If `true`, returns settings in flat format. */
    flat_settings?: boolean;
    /** If `true`, returns default cluster settings from the local node. */
    include_defaults?: boolean;
    /** Period to wait for a connection to the master node.
      * If no response is received before the timeout expires, the request fails and returns an error. */
    master_timeout?: Duration;
    /** Period to wait for a response.
      * If no response is received before the timeout expires, the request fails and returns an error. */
    timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        flat_settings?: never;
        include_defaults?: never;
        master_timeout?: never;
        timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        flat_settings?: never;
        include_defaults?: never;
        master_timeout?: never;
        timeout?: never;
    };
}
export interface ClusterGetSettingsResponse {
    /** The settings that persist after the cluster restarts. */
    persistent: Record<string, any>;
    /** The settings that do not persist after the cluster restarts. */
    transient: Record<string, any>;
    /** The default setting values. */
    defaults?: Record<string, any>;
}
export interface ClusterHealthHealthResponseBody {
    /** The number of active primary shards. */
    active_primary_shards: integer;
    /** The total number of active primary and replica shards. */
    active_shards: integer;
    /** The ratio of active shards in the cluster expressed as a string formatted percentage. */
    active_shards_percent?: string;
    /** The ratio of active shards in the cluster expressed as a percentage. */
    active_shards_percent_as_number: double;
    /** The name of the cluster. */
    cluster_name: Name;
    /** The number of shards whose allocation has been delayed by the timeout settings. */
    delayed_unassigned_shards: integer;
    indices?: Record<IndexName, ClusterHealthIndexHealthStats>;
    /** The number of shards that are under initialization. */
    initializing_shards: integer;
    /** The number of nodes that are dedicated data nodes. */
    number_of_data_nodes: integer;
    /** The number of unfinished fetches. */
    number_of_in_flight_fetch: integer;
    /** The number of nodes within the cluster. */
    number_of_nodes: integer;
    /** The number of cluster-level changes that have not yet been executed. */
    number_of_pending_tasks: integer;
    /** The number of shards that are under relocation. */
    relocating_shards: integer;
    status: HealthStatus;
    /** The time since the earliest initiated task is waiting for being performed. */
    task_max_waiting_in_queue?: Duration;
    /** The time expressed in milliseconds since the earliest initiated task is waiting for being performed. */
    task_max_waiting_in_queue_millis: DurationValue<UnitMillis>;
    /** If false the response returned within the period of time that is specified by the timeout parameter (30s by default) */
    timed_out: boolean;
    /** The number of primary shards that are not allocated. */
    unassigned_primary_shards: integer;
    /** The number of shards that are not allocated. */
    unassigned_shards: integer;
}
export interface ClusterHealthIndexHealthStats {
    active_primary_shards: integer;
    active_shards: integer;
    initializing_shards: integer;
    number_of_replicas: integer;
    number_of_shards: integer;
    relocating_shards: integer;
    shards?: Record<string, ClusterHealthShardHealthStats>;
    status: HealthStatus;
    unassigned_shards: integer;
    unassigned_primary_shards: integer;
}
export interface ClusterHealthRequest extends RequestBase {
    /** Comma-separated list of data streams, indices, and index aliases used to limit the request. Wildcard expressions (`*`) are supported. To target all data streams and indices in a cluster, omit this parameter or use _all or `*`. */
    index?: Indices;
    /** Whether to expand wildcard expression to concrete indices that are open, closed or both. */
    expand_wildcards?: ExpandWildcards;
    /** Can be one of cluster, indices or shards. Controls the details level of the health information returned. */
    level?: Level;
    /** If true, the request retrieves information from the local node only. Defaults to false, which means information is retrieved from the master node. */
    local?: boolean;
    /** Period to wait for a connection to the master node. If no response is received before the timeout expires, the request fails and returns an error. */
    master_timeout?: Duration;
    /** Period to wait for a response. If no response is received before the timeout expires, the request fails and returns an error. */
    timeout?: Duration;
    /** A number controlling to how many active shards to wait for, all to wait for all shards in the cluster to be active, or 0 to not wait. */
    wait_for_active_shards?: WaitForActiveShards;
    /** Can be one of immediate, urgent, high, normal, low, languid. Wait until all currently queued events with the given priority are processed. */
    wait_for_events?: WaitForEvents;
    /** The request waits until the specified number N of nodes is available. It also accepts >=N, <=N, >N and <N. Alternatively, it is possible to use ge(N), le(N), gt(N) and lt(N) notation. */
    wait_for_nodes?: ClusterHealthWaitForNodes;
    /** A boolean value which controls whether to wait (until the timeout provided) for the cluster to have no shard initializations. Defaults to false, which means it will not wait for initializing shards. */
    wait_for_no_initializing_shards?: boolean;
    /** A boolean value which controls whether to wait (until the timeout provided) for the cluster to have no shard relocations. Defaults to false, which means it will not wait for relocating shards. */
    wait_for_no_relocating_shards?: boolean;
    /** One of green, yellow or red. Will wait (until the timeout provided) until the status of the cluster changes to the one provided or better, i.e. green > yellow > red. By default, will not wait for any status. */
    wait_for_status?: HealthStatus;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
        expand_wildcards?: never;
        level?: never;
        local?: never;
        master_timeout?: never;
        timeout?: never;
        wait_for_active_shards?: never;
        wait_for_events?: never;
        wait_for_nodes?: never;
        wait_for_no_initializing_shards?: never;
        wait_for_no_relocating_shards?: never;
        wait_for_status?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
        expand_wildcards?: never;
        level?: never;
        local?: never;
        master_timeout?: never;
        timeout?: never;
        wait_for_active_shards?: never;
        wait_for_events?: never;
        wait_for_nodes?: never;
        wait_for_no_initializing_shards?: never;
        wait_for_no_relocating_shards?: never;
        wait_for_status?: never;
    };
}
export type ClusterHealthResponse = ClusterHealthHealthResponseBody;
export interface ClusterHealthShardHealthStats {
    active_shards: integer;
    initializing_shards: integer;
    primary_active: boolean;
    relocating_shards: integer;
    status: HealthStatus;
    unassigned_shards: integer;
    unassigned_primary_shards: integer;
}
export type ClusterHealthWaitForNodes = string | integer;
export interface ClusterInfoRequest extends RequestBase {
    /** Limits the information returned to the specific target. Supports a comma-separated list, such as http,ingest. */
    target: ClusterInfoTargets;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        target?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        target?: never;
    };
}
export interface ClusterInfoResponse {
    cluster_name: Name;
    http?: NodesHttp;
    ingest?: NodesIngest;
    thread_pool?: Record<string, NodesThreadCount>;
    script?: NodesScripting;
}
export interface ClusterPendingTasksPendingTask {
    /** Indicates whether the pending tasks are currently executing or not. */
    executing: boolean;
    /** The number that represents when the task has been inserted into the task queue. */
    insert_order: integer;
    /** The priority of the pending task.
      * The valid priorities in descending priority order are: `IMMEDIATE` > `URGENT` > `HIGH` > `NORMAL` > `LOW` > `LANGUID`. */
    priority: string;
    /** A general description of the cluster task that may include a reason and origin. */
    source: string;
    /** The time since the task is waiting for being performed. */
    time_in_queue?: Duration;
    /** The time expressed in milliseconds since the task is waiting for being performed. */
    time_in_queue_millis: DurationValue<UnitMillis>;
}
export interface ClusterPendingTasksRequest extends RequestBase {
    /** If `true`, the request retrieves information from the local node only.
      * If `false`, information is retrieved from the master node. */
    local?: boolean;
    /** Period to wait for a connection to the master node.
      * If no response is received before the timeout expires, the request fails and returns an error. */
    master_timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        local?: never;
        master_timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        local?: never;
        master_timeout?: never;
    };
}
export interface ClusterPendingTasksResponse {
    tasks: ClusterPendingTasksPendingTask[];
}
export interface ClusterPostVotingConfigExclusionsRequest extends RequestBase {
    /** A comma-separated list of the names of the nodes to exclude from the
      * voting configuration. If specified, you may not also specify node_ids. */
    node_names?: Names;
    /** A comma-separated list of the persistent ids of the nodes to exclude
      * from the voting configuration. If specified, you may not also specify node_names. */
    node_ids?: Ids;
    /** Period to wait for a connection to the master node. */
    master_timeout?: Duration;
    /** When adding a voting configuration exclusion, the API waits for the
      * specified nodes to be excluded from the voting configuration before
      * returning. If the timeout expires before the appropriate condition
      * is satisfied, the request fails and returns an error. */
    timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        node_names?: never;
        node_ids?: never;
        master_timeout?: never;
        timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        node_names?: never;
        node_ids?: never;
        master_timeout?: never;
        timeout?: never;
    };
}
export type ClusterPostVotingConfigExclusionsResponse = boolean;
export interface ClusterPutComponentTemplateRequest extends RequestBase {
    /** Name of the component template to create.
      * Elasticsearch includes the following built-in component templates: `logs-mappings`; `logs-settings`; `metrics-mappings`; `metrics-settings`;`synthetics-mapping`; `synthetics-settings`.
      * Elastic Agent uses these templates to configure backing indices for its data streams.
      * If you use Elastic Agent and want to overwrite one of these templates, set the `version` for your replacement template higher than the current version.
      * If you don’t use Elastic Agent and want to disable all built-in component and index templates, set `stack.templates.enabled` to `false` using the cluster update settings API. */
    name: Name;
    /** If `true`, this request cannot replace or update existing component templates. */
    create?: boolean;
    /** User defined reason for create the component template. */
    cause?: string;
    /** Period to wait for a connection to the master node.
      * If no response is received before the timeout expires, the request fails and returns an error. */
    master_timeout?: Duration;
    /** The template to be applied which includes mappings, settings, or aliases configuration. */
    template: IndicesIndexState;
    /** Version number used to manage component templates externally.
      * This number isn't automatically generated or incremented by Elasticsearch.
      * To unset a version, replace the template without specifying a version. */
    version?: VersionNumber;
    /** Optional user metadata about the component template.
      * It may have any contents. This map is not automatically generated by Elasticsearch.
      * This information is stored in the cluster state, so keeping it short is preferable.
      * To unset `_meta`, replace the template without specifying this information. */
    _meta?: Metadata;
    /** Marks this index template as deprecated. When creating or updating a non-deprecated index template
      * that uses deprecated components, Elasticsearch will emit a deprecation warning. */
    deprecated?: boolean;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        name?: never;
        create?: never;
        cause?: never;
        master_timeout?: never;
        template?: never;
        version?: never;
        _meta?: never;
        deprecated?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        name?: never;
        create?: never;
        cause?: never;
        master_timeout?: never;
        template?: never;
        version?: never;
        _meta?: never;
        deprecated?: never;
    };
}
export type ClusterPutComponentTemplateResponse = AcknowledgedResponseBase;
export interface ClusterPutSettingsRequest extends RequestBase {
    /** Return settings in flat format (default: false) */
    flat_settings?: boolean;
    /** Explicit operation timeout for connection to master node */
    master_timeout?: Duration;
    /** Explicit operation timeout */
    timeout?: Duration;
    /** The settings that persist after the cluster restarts. */
    persistent?: Record<string, any>;
    /** The settings that do not persist after the cluster restarts. */
    transient?: Record<string, any>;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        flat_settings?: never;
        master_timeout?: never;
        timeout?: never;
        persistent?: never;
        transient?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        flat_settings?: never;
        master_timeout?: never;
        timeout?: never;
        persistent?: never;
        transient?: never;
    };
}
export interface ClusterPutSettingsResponse {
    acknowledged: boolean;
    persistent: Record<string, any>;
    transient: Record<string, any>;
}
export type ClusterRemoteInfoClusterRemoteInfo = ClusterRemoteInfoClusterRemoteSniffInfo | ClusterRemoteInfoClusterRemoteProxyInfo;
export interface ClusterRemoteInfoClusterRemoteProxyInfo {
    /** The connection mode for the remote cluster. */
    mode: 'proxy';
    /** If it is `true`, there is at least one open connection to the remote cluster.
      * If it is `false`, it means that the cluster no longer has an open connection to the remote cluster.
      * It does not necessarily mean that the remote cluster is down or unavailable, just that at some point a connection was lost. */
    connected: boolean;
    /** The initial connect timeout for remote cluster connections. */
    initial_connect_timeout: Duration;
    /** If `true`, cross-cluster search skips the remote cluster when its nodes are unavailable during the search and ignores errors returned by the remote cluster. */
    skip_unavailable: boolean;
    /** The address for remote connections when proxy mode is configured. */
    proxy_address: string;
    server_name: string;
    /** The number of open socket connections to the remote cluster when proxy mode is configured. */
    num_proxy_sockets_connected: integer;
    /** The maximum number of socket connections to the remote cluster when proxy mode is configured. */
    max_proxy_socket_connections: integer;
    /** This field is present and has a value of `::es_redacted::` only when the remote cluster is configured with the API key based model. Otherwise, the field is not present. */
    cluster_credentials?: string;
}
export interface ClusterRemoteInfoClusterRemoteSniffInfo {
    /** The connection mode for the remote cluster. */
    mode: 'sniff';
    /** If it is `true`, there is at least one open connection to the remote cluster.
      * If it is `false`, it means that the cluster no longer has an open connection to the remote cluster.
      * It does not necessarily mean that the remote cluster is down or unavailable, just that at some point a connection was lost. */
    connected: boolean;
    /** The maximum number of connections maintained for the remote cluster when sniff mode is configured. */
    max_connections_per_cluster: integer;
    /** The number of connected nodes in the remote cluster when sniff mode is configured. */
    num_nodes_connected: long;
    /** The initial connect timeout for remote cluster connections. */
    initial_connect_timeout: Duration;
    /** If `true`, cross-cluster search skips the remote cluster when its nodes are unavailable during the search and ignores errors returned by the remote cluster. */
    skip_unavailable: boolean;
    /** The initial seed transport addresses of the remote cluster when sniff mode is configured. */
    seeds: string[];
}
export interface ClusterRemoteInfoRequest extends RequestBase {
    /** All values in `body` will be added to the request body. */
    body?: string | {
        [key: string]: any;
    };
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    };
}
export type ClusterRemoteInfoResponse = Record<string, ClusterRemoteInfoClusterRemoteInfo>;
export interface ClusterRerouteCommand {
    /** Cancel allocation of a shard (or recovery). Accepts index and shard for index name and shard number, and node for the node to cancel the shard allocation on. This can be used to force resynchronization of existing replicas from the primary shard by cancelling them and allowing them to be reinitialized through the standard recovery process. By default only replica shard allocations can be cancelled. If it is necessary to cancel the allocation of a primary shard then the allow_primary flag must also be included in the request. */
    cancel?: ClusterRerouteCommandCancelAction;
    /** Move a started shard from one node to another node. Accepts index and shard for index name and shard number, from_node for the node to move the shard from, and to_node for the node to move the shard to. */
    move?: ClusterRerouteCommandMoveAction;
    /** Allocate an unassigned replica shard to a node. Accepts index and shard for index name and shard number, and node to allocate the shard to. Takes allocation deciders into account. */
    allocate_replica?: ClusterRerouteCommandAllocateReplicaAction;
    /** Allocate a primary shard to a node that holds a stale copy. Accepts the index and shard for index name and shard number, and node to allocate the shard to. Using this command may lead to data loss for the provided shard id. If a node which has the good copy of the data rejoins the cluster later on, that data will be deleted or overwritten with the data of the stale copy that was forcefully allocated with this command. To ensure that these implications are well-understood, this command requires the flag accept_data_loss to be explicitly set to true. */
    allocate_stale_primary?: ClusterRerouteCommandAllocatePrimaryAction;
    /** Allocate an empty primary shard to a node. Accepts the index and shard for index name and shard number, and node to allocate the shard to. Using this command leads to a complete loss of all data that was indexed into this shard, if it was previously started. If a node which has a copy of the data rejoins the cluster later on, that data will be deleted. To ensure that these implications are well-understood, this command requires the flag accept_data_loss to be explicitly set to true. */
    allocate_empty_primary?: ClusterRerouteCommandAllocatePrimaryAction;
}
export interface ClusterRerouteCommandAllocatePrimaryAction {
    index: IndexName;
    shard: integer;
    node: string;
    /** If a node which has a copy of the data rejoins the cluster later on, that data will be deleted. To ensure that these implications are well-understood, this command requires the flag accept_data_loss to be explicitly set to true */
    accept_data_loss: boolean;
}
export interface ClusterRerouteCommandAllocateReplicaAction {
    index: IndexName;
    shard: integer;
    node: string;
}
export interface ClusterRerouteCommandCancelAction {
    index: IndexName;
    shard: integer;
    node: string;
    allow_primary?: boolean;
}
export interface ClusterRerouteCommandMoveAction {
    index: IndexName;
    shard: integer;
    /** The node to move the shard from */
    from_node: string;
    /** The node to move the shard to */
    to_node: string;
}
export interface ClusterRerouteRequest extends RequestBase {
    /** If true, then the request simulates the operation.
      * It will calculate the result of applying the commands to the current cluster state and return the resulting cluster state after the commands (and rebalancing) have been applied; it will not actually perform the requested changes. */
    dry_run?: boolean;
    /** If true, then the response contains an explanation of why the commands can or cannot run. */
    explain?: boolean;
    /** Limits the information returned to the specified metrics. */
    metric?: Metrics;
    /** If true, then retries allocation of shards that are blocked due to too many subsequent allocation failures. */
    retry_failed?: boolean;
    /** Period to wait for a connection to the master node. If no response is received before the timeout expires, the request fails and returns an error. */
    master_timeout?: Duration;
    /** Period to wait for a response. If no response is received before the timeout expires, the request fails and returns an error. */
    timeout?: Duration;
    /** Defines the commands to perform. */
    commands?: ClusterRerouteCommand[];
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        dry_run?: never;
        explain?: never;
        metric?: never;
        retry_failed?: never;
        master_timeout?: never;
        timeout?: never;
        commands?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        dry_run?: never;
        explain?: never;
        metric?: never;
        retry_failed?: never;
        master_timeout?: never;
        timeout?: never;
        commands?: never;
    };
}
export interface ClusterRerouteRerouteDecision {
    decider: string;
    decision: string;
    explanation: string;
}
export interface ClusterRerouteRerouteExplanation {
    command: string;
    decisions: ClusterRerouteRerouteDecision[];
    parameters: ClusterRerouteRerouteParameters;
}
export interface ClusterRerouteRerouteParameters {
    allow_primary: boolean;
    index: IndexName;
    node: NodeName;
    shard: integer;
    from_node?: NodeName;
    to_node?: NodeName;
}
export interface ClusterRerouteResponse {
    acknowledged: boolean;
    explanations?: ClusterRerouteRerouteExplanation[];
    /** There aren't any guarantees on the output/structure of the raw cluster state.
      * Here you will find the internal representation of the cluster, which can
      * differ from the external representation. */
    state?: any;
}
export interface ClusterStateRequest extends RequestBase {
    /** Limit the information returned to the specified metrics */
    metric?: Metrics;
    /** A comma-separated list of index names; use `_all` or empty string to perform the operation on all indices */
    index?: Indices;
    /** Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified) */
    allow_no_indices?: boolean;
    /** Whether to expand wildcard expression to concrete indices that are open, closed or both. */
    expand_wildcards?: ExpandWildcards;
    /** Return settings in flat format (default: false) */
    flat_settings?: boolean;
    /** Whether specified concrete indices should be ignored when unavailable (missing or closed) */
    ignore_unavailable?: boolean;
    /** Return local information, do not retrieve the state from master node (default: false) */
    local?: boolean;
    /** Specify timeout for connection to master */
    master_timeout?: Duration;
    /** Wait for the metadata version to be equal or greater than the specified metadata version */
    wait_for_metadata_version?: VersionNumber;
    /** The maximum time to wait for wait_for_metadata_version before timing out */
    wait_for_timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        metric?: never;
        index?: never;
        allow_no_indices?: never;
        expand_wildcards?: never;
        flat_settings?: never;
        ignore_unavailable?: never;
        local?: never;
        master_timeout?: never;
        wait_for_metadata_version?: never;
        wait_for_timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        metric?: never;
        index?: never;
        allow_no_indices?: never;
        expand_wildcards?: never;
        flat_settings?: never;
        ignore_unavailable?: never;
        local?: never;
        master_timeout?: never;
        wait_for_metadata_version?: never;
        wait_for_timeout?: never;
    };
}
export type ClusterStateResponse = any;
export interface ClusterStatsCCSStats {
    /** Contains remote cluster settings and metrics collected from them.
      * The keys are cluster names, and the values are per-cluster data.
      * Only present if `include_remotes` option is set to true. */
    clusters?: Record<string, ClusterStatsRemoteClusterInfo>;
    /** Information about cross-cluster search usage. */
    _search: ClusterStatsCCSUsageStats;
    /** Information about ES|QL cross-cluster query usage. */
    _esql?: ClusterStatsCCSUsageStats;
}
export interface ClusterStatsCCSUsageClusterStats {
    /** The total number of successful (not skipped) cross-cluster search requests that were executed against this cluster. This may include requests where partial results were returned, but not requests in which the cluster has been skipped entirely. */
    total: integer;
    /** The total number of cross-cluster search requests for which this cluster was skipped. */
    skipped: integer;
    /** Statistics about the time taken to execute requests against this cluster. */
    took: ClusterStatsCCSUsageTimeValue;
}
export interface ClusterStatsCCSUsageStats {
    /** The total number of cross-cluster search requests that have been executed by the cluster. */
    total: integer;
    /** The total number of cross-cluster search requests that have been successfully executed by the cluster. */
    success: integer;
    /** The total number of cross-cluster search requests (successful or failed) that had at least one remote cluster skipped. */
    skipped: integer;
    /** Statistics about the time taken to execute cross-cluster search requests. */
    took: ClusterStatsCCSUsageTimeValue;
    /** Statistics about the time taken to execute cross-cluster search requests for which the `ccs_minimize_roundtrips` setting was set to `true`. */
    took_mrt_true?: ClusterStatsCCSUsageTimeValue;
    /** Statistics about the time taken to execute cross-cluster search requests for which the `ccs_minimize_roundtrips` setting was set to `false`. */
    took_mrt_false?: ClusterStatsCCSUsageTimeValue;
    /** The maximum number of remote clusters that were queried in a single cross-cluster search request. */
    remotes_per_search_max: integer;
    /** The average number of remote clusters that were queried in a single cross-cluster search request. */
    remotes_per_search_avg: double;
    /** Statistics about the reasons for cross-cluster search request failures. The keys are the failure reason names and the values are the number of requests that failed for that reason. */
    failure_reasons: Record<string, integer>;
    /** The keys are the names of the search feature, and the values are the number of requests that used that feature. Single request can use more than one feature (e.g. both `async` and `wildcard`). */
    features: Record<string, integer>;
    /** Statistics about the clients that executed cross-cluster search requests. The keys are the names of the clients, and the values are the number of requests that were executed by that client. Only known clients (such as `kibana` or `elasticsearch`) are counted. */
    clients: Record<string, integer>;
    /** Statistics about the clusters that were queried in cross-cluster search requests. The keys are cluster names, and the values are per-cluster telemetry data. This also includes the local cluster itself, which uses the name `(local)`. */
    clusters: Record<string, ClusterStatsCCSUsageClusterStats>;
}
export interface ClusterStatsCCSUsageTimeValue {
    /** The maximum time taken to execute a request, in milliseconds. */
    max: DurationValue<UnitMillis>;
    /** The average time taken to execute a request, in milliseconds. */
    avg: DurationValue<UnitMillis>;
    /** The 90th percentile of the time taken to execute requests, in milliseconds. */
    p90: DurationValue<UnitMillis>;
}
export interface ClusterStatsCharFilterTypes {
    /** Contains statistics about analyzer types used in selected nodes. */
    analyzer_types: ClusterStatsFieldTypes[];
    /** Contains statistics about built-in analyzers used in selected nodes. */
    built_in_analyzers: ClusterStatsFieldTypes[];
    /** Contains statistics about built-in character filters used in selected nodes. */
    built_in_char_filters: ClusterStatsFieldTypes[];
    /** Contains statistics about built-in token filters used in selected nodes. */
    built_in_filters: ClusterStatsFieldTypes[];
    /** Contains statistics about built-in tokenizers used in selected nodes. */
    built_in_tokenizers: ClusterStatsFieldTypes[];
    /** Contains statistics about character filter types used in selected nodes. */
    char_filter_types: ClusterStatsFieldTypes[];
    /** Contains statistics about token filter types used in selected nodes. */
    filter_types: ClusterStatsFieldTypes[];
    /** Contains statistics about tokenizer types used in selected nodes. */
    tokenizer_types: ClusterStatsFieldTypes[];
    /** Contains statistics about synonyms types used in selected nodes. */
    synonyms: Record<Name, ClusterStatsSynonymsStats>;
}
export interface ClusterStatsClusterFileSystem {
    path?: string;
    mount?: string;
    type?: string;
    /** Total number of bytes available to JVM in file stores across all selected nodes.
      * Depending on operating system or process-level restrictions, this number may be less than `nodes.fs.free_in_byes`.
      * This is the actual amount of free disk space the selected Elasticsearch nodes can use. */
    available_in_bytes?: long;
    /** Total number of bytes available to JVM in file stores across all selected nodes.
      * Depending on operating system or process-level restrictions, this number may be less than `nodes.fs.free_in_byes`.
      * This is the actual amount of free disk space the selected Elasticsearch nodes can use. */
    available?: ByteSize;
    /** Total number, in bytes, of unallocated bytes in file stores across all selected nodes. */
    free_in_bytes?: long;
    /** Total number of unallocated bytes in file stores across all selected nodes. */
    free?: ByteSize;
    /** Total size, in bytes, of all file stores across all selected nodes. */
    total_in_bytes?: long;
    /** Total size of all file stores across all selected nodes. */
    total?: ByteSize;
    low_watermark_free_space?: ByteSize;
    low_watermark_free_space_in_bytes?: long;
    high_watermark_free_space?: ByteSize;
    high_watermark_free_space_in_bytes?: long;
    flood_stage_free_space?: ByteSize;
    flood_stage_free_space_in_bytes?: long;
    frozen_flood_stage_free_space?: ByteSize;
    frozen_flood_stage_free_space_in_bytes?: long;
}
export interface ClusterStatsClusterIndices {
    /** Contains statistics about analyzers and analyzer components used in selected nodes. */
    analysis?: ClusterStatsCharFilterTypes;
    /** Contains statistics about memory used for completion in selected nodes. */
    completion: CompletionStats;
    /** Total number of indices with shards assigned to selected nodes. */
    count: long;
    /** Contains counts for documents in selected nodes. */
    docs: DocStats;
    /** Contains statistics about the field data cache of selected nodes. */
    fielddata: FielddataStats;
    /** Contains statistics about the query cache of selected nodes. */
    query_cache: QueryCacheStats;
    /** Holds a snapshot of the search usage statistics.
      * Used to hold the stats for a single node that's part of a ClusterStatsNodeResponse, as well as to
      * accumulate stats for the entire cluster and return them as part of the ClusterStatsResponse. */
    search: ClusterStatsSearchUsageStats;
    /** Contains statistics about segments in selected nodes. */
    segments: SegmentsStats;
    /** Contains statistics about indices with shards assigned to selected nodes. */
    shards: ClusterStatsClusterIndicesShards;
    /** Contains statistics about the size of shards assigned to selected nodes. */
    store: StoreStats;
    /** Contains statistics about field mappings in selected nodes. */
    mappings?: ClusterStatsFieldTypesMappings;
    /** Contains statistics about analyzers and analyzer components used in selected nodes. */
    versions?: ClusterStatsIndicesVersions[];
    /** Contains statistics about indexed dense vector */
    dense_vector: ClusterStatsDenseVectorStats;
    /** Contains statistics about indexed sparse vector */
    sparse_vector: ClusterStatsSparseVectorStats;
}
export interface ClusterStatsClusterIndicesShards {
    /** Contains statistics about shards assigned to selected nodes. */
    index?: ClusterStatsClusterIndicesShardsIndex;
    /** Number of primary shards assigned to selected nodes. */
    primaries?: double;
    /** Ratio of replica shards to primary shards across all selected nodes. */
    replication?: double;
    /** Total number of shards assigned to selected nodes. */
    total?: double;
}
export interface ClusterStatsClusterIndicesShardsIndex {
    /** Contains statistics about the number of primary shards assigned to selected nodes. */
    primaries: ClusterStatsClusterShardMetrics;
    /** Contains statistics about the number of replication shards assigned to selected nodes. */
    replication: ClusterStatsClusterShardMetrics;
    /** Contains statistics about the number of shards assigned to selected nodes. */
    shards: ClusterStatsClusterShardMetrics;
}
export interface ClusterStatsClusterIngest {
    number_of_pipelines: integer;
    processor_stats: Record<string, ClusterStatsClusterProcessor>;
}
export interface ClusterStatsClusterJvm {
    /** Uptime duration, in milliseconds, since JVM last started. */
    max_uptime_in_millis: DurationValue<UnitMillis>;
    /** Uptime duration since JVM last started. */
    max_uptime?: Duration;
    /** Contains statistics about memory used by selected nodes. */
    mem: ClusterStatsClusterJvmMemory;
    /** Number of active threads in use by JVM across all selected nodes. */
    threads: long;
    /** Contains statistics about the JVM versions used by selected nodes. */
    versions: ClusterStatsClusterJvmVersion[];
}
export interface ClusterStatsClusterJvmMemory {
    /** Maximum amount of memory, in bytes, available for use by the heap across all selected nodes. */
    heap_max_in_bytes: long;
    /** Maximum amount of memory available for use by the heap across all selected nodes. */
    heap_max?: ByteSize;
    /** Memory, in bytes, currently in use by the heap across all selected nodes. */
    heap_used_in_bytes: long;
    /** Memory currently in use by the heap across all selected nodes. */
    heap_used?: ByteSize;
}
export interface ClusterStatsClusterJvmVersion {
    /** Always `true`. All distributions come with a bundled Java Development Kit (JDK). */
    bundled_jdk: boolean;
    /** Total number of selected nodes using JVM. */
    count: integer;
    /** If `true`, a bundled JDK is in use by JVM. */
    using_bundled_jdk: boolean;
    /** Version of JVM used by one or more selected nodes. */
    version: VersionString;
    /** Name of the JVM. */
    vm_name: string;
    /** Vendor of the JVM. */
    vm_vendor: string;
    /** Full version number of JVM.
      * The full version number includes a plus sign (+) followed by the build number. */
    vm_version: VersionString;
}
export interface ClusterStatsClusterNetworkTypes {
    /** Contains statistics about the HTTP network types used by selected nodes. */
    http_types: Record<string, integer>;
    /** Contains statistics about the transport network types used by selected nodes. */
    transport_types: Record<string, integer>;
}
export interface ClusterStatsClusterNodeCount {
    total: integer;
    coordinating_only?: integer;
    data?: integer;
    data_cold?: integer;
    data_content?: integer;
    data_frozen?: integer;
    data_hot?: integer;
    data_warm?: integer;
    index?: integer;
    ingest?: integer;
    master?: integer;
    ml?: integer;
    remote_cluster_client?: integer;
    search?: integer;
    transform?: integer;
    voting_only?: integer;
}
export interface ClusterStatsClusterNodes {
    /** Contains counts for nodes selected by the request’s node filters. */
    count: ClusterStatsClusterNodeCount;
    /** Contains statistics about the discovery types used by selected nodes. */
    discovery_types: Record<string, integer>;
    /** Contains statistics about file stores by selected nodes. */
    fs: ClusterStatsClusterFileSystem;
    indexing_pressure: ClusterStatsIndexingPressure;
    ingest: ClusterStatsClusterIngest;
    /** Contains statistics about the Java Virtual Machines (JVMs) used by selected nodes. */
    jvm: ClusterStatsClusterJvm;
    /** Contains statistics about the transport and HTTP networks used by selected nodes. */
    network_types: ClusterStatsClusterNetworkTypes;
    /** Contains statistics about the operating systems used by selected nodes. */
    os: ClusterStatsClusterOperatingSystem;
    /** Contains statistics about Elasticsearch distributions installed on selected nodes. */
    packaging_types: ClusterStatsNodePackagingType[];
    /** Contains statistics about installed plugins and modules by selected nodes.
      * If no plugins or modules are installed, this array is empty. */
    plugins: PluginStats[];
    /** Contains statistics about processes used by selected nodes. */
    process: ClusterStatsClusterProcess;
    /** Array of Elasticsearch versions used on selected nodes. */
    versions: VersionString[];
}
export interface ClusterStatsClusterOperatingSystem {
    /** Number of processors used to calculate thread pool size across all selected nodes.
      * This number can be set with the processors setting of a node and defaults to the number of processors reported by the operating system.
      * In both cases, this number will never be larger than 32. */
    allocated_processors: integer;
    /** Contains statistics about processor architectures (for example, x86_64 or aarch64) used by selected nodes. */
    architectures?: ClusterStatsClusterOperatingSystemArchitecture[];
    /** Number of processors available to JVM across all selected nodes. */
    available_processors: integer;
    /** Contains statistics about memory used by selected nodes. */
    mem: ClusterStatsOperatingSystemMemoryInfo;
    /** Contains statistics about operating systems used by selected nodes. */
    names: ClusterStatsClusterOperatingSystemName[];
    /** Contains statistics about operating systems used by selected nodes. */
    pretty_names: ClusterStatsClusterOperatingSystemPrettyName[];
}
export interface ClusterStatsClusterOperatingSystemArchitecture {
    /** Name of an architecture used by one or more selected nodes. */
    arch: string;
    /** Number of selected nodes using the architecture. */
    count: integer;
}
export interface ClusterStatsClusterOperatingSystemName {
    /** Number of selected nodes using the operating system. */
    count: integer;
    /** Name of an operating system used by one or more selected nodes. */
    name: Name;
}
export interface ClusterStatsClusterOperatingSystemPrettyName {
    /** Number of selected nodes using the operating system. */
    count: integer;
    /** Human-readable name of an operating system used by one or more selected nodes. */
    pretty_name: Name;
}
export interface ClusterStatsClusterProcess {
    /** Contains statistics about CPU used by selected nodes. */
    cpu: ClusterStatsClusterProcessCpu;
    /** Contains statistics about open file descriptors in selected nodes. */
    open_file_descriptors: ClusterStatsClusterProcessOpenFileDescriptors;
}
export interface ClusterStatsClusterProcessCpu {
    /** Percentage of CPU used across all selected nodes.
      * Returns `-1` if not supported. */
    percent: integer;
}
export interface ClusterStatsClusterProcessOpenFileDescriptors {
    /** Average number of concurrently open file descriptors.
      * Returns `-1` if not supported. */
    avg: long;
    /** Maximum number of concurrently open file descriptors allowed across all selected nodes.
      * Returns `-1` if not supported. */
    max: long;
    /** Minimum number of concurrently open file descriptors across all selected nodes.
      * Returns -1 if not supported. */
    min: long;
}
export interface ClusterStatsClusterProcessor {
    count: long;
    current: long;
    failed: long;
    time?: Duration;
    time_in_millis: DurationValue<UnitMillis>;
}
export interface ClusterStatsClusterShardMetrics {
    /** Mean number of shards in an index, counting only shards assigned to selected nodes. */
    avg: double;
    /** Maximum number of shards in an index, counting only shards assigned to selected nodes. */
    max: double;
    /** Minimum number of shards in an index, counting only shards assigned to selected nodes. */
    min: double;
}
export interface ClusterStatsClusterSnapshotStats {
    current_counts: ClusterStatsSnapshotCurrentCounts;
    repositories: Record<Name, ClusterStatsPerRepositoryStats>;
}
export interface ClusterStatsDenseVectorOffHeapStats {
    total_size_bytes: long;
    total_size?: ByteSize;
    total_veb_size_bytes: long;
    total_veb_size?: ByteSize;
    total_vec_size_bytes: long;
    total_vec_size?: ByteSize;
    total_veq_size_bytes: long;
    total_veq_size?: ByteSize;
    total_vex_size_bytes: long;
    total_vex_size?: ByteSize;
    fielddata?: Record<string, Record<string, long>>;
}
export interface ClusterStatsDenseVectorStats {
    value_count: long;
    off_heap?: ClusterStatsDenseVectorOffHeapStats;
}
export interface ClusterStatsFieldTypes {
    /** The name for the field type in selected nodes. */
    name: Name;
    /** The number of occurrences of the field type in selected nodes. */
    count: integer;
    /** The number of indices containing the field type in selected nodes. */
    index_count: integer;
    /** For dense_vector field types, number of indexed vector types in selected nodes. */
    indexed_vector_count?: integer;
    /** For dense_vector field types, the maximum dimension of all indexed vector types in selected nodes. */
    indexed_vector_dim_max?: integer;
    /** For dense_vector field types, the minimum dimension of all indexed vector types in selected nodes. */
    indexed_vector_dim_min?: integer;
    /** The number of fields that declare a script. */
    script_count?: integer;
    /** For dense_vector field types, count of mappings by index type */
    vector_index_type_count?: Record<Name, integer>;
    /** For dense_vector field types, count of mappings by similarity */
    vector_similarity_type_count?: Record<Name, integer>;
    /** For dense_vector field types, count of mappings by element type */
    vector_element_type_count?: Record<Name, integer>;
}
export interface ClusterStatsFieldTypesMappings {
    /** Contains statistics about field data types used in selected nodes. */
    field_types: ClusterStatsFieldTypes[];
    /** Contains statistics about runtime field data types used in selected nodes. */
    runtime_field_types: ClusterStatsRuntimeFieldTypes[];
    /** Total number of fields in all non-system indices. */
    total_field_count?: long;
    /** Total number of fields in all non-system indices, accounting for mapping deduplication. */
    total_deduplicated_field_count?: long;
    /** Total size of all mappings after deduplication and compression. */
    total_deduplicated_mapping_size?: ByteSize;
    /** Total size of all mappings, in bytes, after deduplication and compression. */
    total_deduplicated_mapping_size_in_bytes?: long;
    /** Source mode usage count. */
    source_modes: Record<Name, integer>;
}
export interface ClusterStatsIndexingPressure {
    memory: NodesIndexingPressureMemory;
}
export interface ClusterStatsIndicesVersions {
    index_count: integer;
    primary_shard_count: integer;
    total_primary_bytes: long;
    total_primary_size?: ByteSize;
    version: VersionString;
}
export interface ClusterStatsNodePackagingType {
    /** Number of selected nodes using the distribution flavor and file type. */
    count: integer;
    /** Type of Elasticsearch distribution. This is always `default`. */
    flavor: string;
    /** File type (such as `tar` or `zip`) used for the distribution package. */
    type: string;
}
export interface ClusterStatsOperatingSystemMemoryInfo {
    /** Total amount, in bytes, of memory across all selected nodes, but using the value specified using the `es.total_memory_bytes` system property instead of measured total memory for those nodes where that system property was set. */
    adjusted_total_in_bytes?: long;
    /** Total amount of memory across all selected nodes, but using the value specified using the `es.total_memory_bytes` system property instead of measured total memory for those nodes where that system property was set. */
    adjusted_total?: ByteSize;
    /** Amount, in bytes, of free physical memory across all selected nodes. */
    free_in_bytes: long;
    /** Amount of free physical memory across all selected nodes. */
    free?: ByteSize;
    /** Percentage of free physical memory across all selected nodes. */
    free_percent: integer;
    /** Total amount, in bytes, of physical memory across all selected nodes. */
    total_in_bytes: long;
    /** Total amount of physical memory across all selected nodes. */
    total?: ByteSize;
    /** Amount, in bytes, of physical memory in use across all selected nodes. */
    used_in_bytes: long;
    /** Amount of physical memory in use across all selected nodes. */
    used?: ByteSize;
    /** Percentage of physical memory in use across all selected nodes. */
    used_percent: integer;
}
export interface ClusterStatsPerRepositoryStats {
    type: string;
    oldest_start_time_millis: UnitMillis;
    oldest_start_time?: DateFormat;
    current_counts: ClusterStatsRepositoryStatsCurrentCounts;
}
export interface ClusterStatsRemoteClusterInfo {
    /** The UUID of the remote cluster. */
    cluster_uuid: string;
    /** The connection mode used to communicate with the remote cluster. */
    mode: string;
    /** The `skip_unavailable` setting used for this remote cluster. */
    skip_unavailable: boolean;
    /** Transport compression setting used for this remote cluster. */
    'transport.compress': string;
    /** Health status of the cluster, based on the state of its primary and replica shards. */
    status: HealthStatus;
    /** The list of Elasticsearch versions used by the nodes on the remote cluster. */
    version: VersionString[];
    /** The total count of nodes in the remote cluster. */
    nodes_count: integer;
    /** The total number of shards in the remote cluster. */
    shards_count: integer;
    /** The total number of indices in the remote cluster. */
    indices_count: integer;
    /** Total data set size, in bytes, of all shards assigned to selected nodes. */
    indices_total_size_in_bytes: long;
    /** Total data set size of all shards assigned to selected nodes, as a human-readable string. */
    indices_total_size?: string;
    /** Maximum amount of memory, in bytes, available for use by the heap across the nodes of the remote cluster. */
    max_heap_in_bytes: long;
    /** Maximum amount of memory available for use by the heap across the nodes of the remote cluster, as a human-readable string. */
    max_heap?: string;
    /** Total amount, in bytes, of physical memory across the nodes of the remote cluster. */
    mem_total_in_bytes: long;
    /** Total amount of physical memory across the nodes of the remote cluster, as a human-readable string. */
    mem_total?: string;
}
export interface ClusterStatsRepositoryStatsCurrentCounts {
    snapshots: integer;
    clones: integer;
    finalizations: integer;
    deletions: integer;
    snapshot_deletions: integer;
    active_deletions: integer;
    shards: ClusterStatsRepositoryStatsShards;
}
export interface ClusterStatsRepositoryStatsShards {
    total: integer;
    complete: integer;
    incomplete: integer;
    states: Record<ClusterStatsShardState, integer>;
}
export interface ClusterStatsRequest extends RequestBase {
    /** Comma-separated list of node filters used to limit returned information. Defaults to all nodes in the cluster. */
    node_id?: NodeIds;
    /** Include remote cluster data into the response */
    include_remotes?: boolean;
    /** Period to wait for each node to respond.
      * If a node does not respond before its timeout expires, the response does not include its stats.
      * However, timed out nodes are included in the response’s `_nodes.failed` property. Defaults to no timeout. */
    timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        node_id?: never;
        include_remotes?: never;
        timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        node_id?: never;
        include_remotes?: never;
        timeout?: never;
    };
}
export type ClusterStatsResponse = ClusterStatsStatsResponseBase;
export interface ClusterStatsRuntimeFieldTypes {
    /** Maximum number of characters for a single runtime field script. */
    chars_max: integer;
    /** Total number of characters for the scripts that define the current runtime field data type. */
    chars_total: integer;
    /** Number of runtime fields mapped to the field data type in selected nodes. */
    count: integer;
    /** Maximum number of accesses to doc_values for a single runtime field script */
    doc_max: integer;
    /** Total number of accesses to doc_values for the scripts that define the current runtime field data type. */
    doc_total: integer;
    /** Number of indices containing a mapping of the runtime field data type in selected nodes. */
    index_count: integer;
    /** Script languages used for the runtime fields scripts. */
    lang: string[];
    /** Maximum number of lines for a single runtime field script. */
    lines_max: integer;
    /** Total number of lines for the scripts that define the current runtime field data type. */
    lines_total: integer;
    /** Field data type used in selected nodes. */
    name: Name;
    /** Number of runtime fields that don’t declare a script. */
    scriptless_count: integer;
    /** Number of runtime fields that shadow an indexed field. */
    shadowed_count: integer;
    /** Maximum number of accesses to _source for a single runtime field script. */
    source_max: integer;
    /** Total number of accesses to _source for the scripts that define the current runtime field data type. */
    source_total: integer;
}
export interface ClusterStatsSearchUsageStats {
    total: long;
    queries: Record<Name, long>;
    rescorers: Record<Name, long>;
    sections: Record<Name, long>;
    retrievers: Record<Name, long>;
}
export type ClusterStatsShardState = 'INIT' | 'SUCCESS' | 'FAILED' | 'ABORTED' | 'MISSING' | 'WAITING' | 'QUEUED' | 'PAUSED_FOR_NODE_REMOVAL';
export interface ClusterStatsSnapshotCurrentCounts {
    /** Snapshots currently in progress */
    snapshots: integer;
    /** Incomplete shard snapshots */
    shard_snapshots: integer;
    /** Snapshots deletions in progress */
    snapshot_deletions: integer;
    /** Sum of snapshots and snapshot_deletions */
    concurrent_operations: integer;
    /** Cleanups in progress, not counted in concurrent_operations as they are not concurrent */
    cleanups: integer;
}
export interface ClusterStatsSparseVectorStats {
    value_count: long;
}
export interface ClusterStatsStatsResponseBase extends NodesNodesResponseBase {
    /** Name of the cluster, based on the cluster name setting. */
    cluster_name: Name;
    /** Unique identifier for the cluster. */
    cluster_uuid: Uuid;
    /** Contains statistics about indices with shards assigned to selected nodes. */
    indices: ClusterStatsClusterIndices;
    /** Contains statistics about nodes selected by the request’s node filters. */
    nodes: ClusterStatsClusterNodes;
    /** Contains stats on repository feature usage exposed in cluster stats for telemetry. */
    repositories: Record<Name, Record<Name, long>>;
    /** Contains stats cluster snapshots. */
    snapshots: ClusterStatsClusterSnapshotStats;
    /** Health status of the cluster, based on the state of its primary and replica shards. */
    status?: HealthStatus;
    /** Unix timestamp, in milliseconds, for the last time the cluster statistics were refreshed. */
    timestamp: long;
    /** Cross-cluster stats */
    ccs: ClusterStatsCCSStats;
}
export interface ClusterStatsSynonymsStats {
    count: integer;
    index_count: integer;
}
export interface ConnectorConnector {
    api_key_id?: string;
    api_key_secret_id?: string;
    configuration: ConnectorConnectorConfiguration;
    custom_scheduling: ConnectorConnectorCustomScheduling;
    deleted: boolean;
    description?: string;
    error?: string | null;
    features?: ConnectorConnectorFeatures;
    filtering: ConnectorFilteringConfig[];
    id?: Id;
    index_name?: IndexName | null;
    is_native: boolean;
    language?: string;
    last_access_control_sync_error?: string;
    last_access_control_sync_scheduled_at?: DateTime;
    last_access_control_sync_status?: ConnectorSyncStatus;
    last_deleted_document_count?: long;
    last_incremental_sync_scheduled_at?: DateTime;
    last_indexed_document_count?: long;
    last_seen?: DateTime;
    last_sync_error?: string;
    last_sync_scheduled_at?: DateTime;
    last_sync_status?: ConnectorSyncStatus;
    last_synced?: DateTime;
    name?: string;
    pipeline?: ConnectorIngestPipelineParams;
    scheduling: ConnectorSchedulingConfiguration;
    service_type?: string;
    status: ConnectorConnectorStatus;
    sync_cursor?: any;
    sync_now: boolean;
}
export interface ConnectorConnectorConfigProperties {
    category?: string;
    default_value: ScalarValue;
    depends_on: ConnectorDependency[];
    display: ConnectorDisplayType;
    label: string;
    options: ConnectorSelectOption[];
    order?: integer;
    placeholder?: string;
    required: boolean;
    sensitive: boolean;
    tooltip?: string | null;
    type?: ConnectorConnectorFieldType;
    ui_restrictions?: string[];
    validations?: ConnectorValidation[];
    value: any;
}
export type ConnectorConnectorConfiguration = Record<string, ConnectorConnectorConfigProperties>;
export type ConnectorConnectorCustomScheduling = Record<string, ConnectorCustomScheduling>;
export interface ConnectorConnectorFeatures {
    /** Indicates whether document-level security is enabled. */
    document_level_security?: ConnectorFeatureEnabled;
    /** Indicates whether incremental syncs are enabled. */
    incremental_sync?: ConnectorFeatureEnabled;
    /** Indicates whether managed connector API keys are enabled. */
    native_connector_api_keys?: ConnectorFeatureEnabled;
    sync_rules?: ConnectorSyncRulesFeature;
}
export type ConnectorConnectorFieldType = 'str' | 'int' | 'list' | 'bool';
export interface ConnectorConnectorScheduling {
    enabled: boolean;
    /** The interval is expressed using the crontab syntax */
    interval: string;
}
export type ConnectorConnectorStatus = 'created' | 'needs_configuration' | 'configured' | 'connected' | 'error';
export interface ConnectorConnectorSyncJob {
    cancelation_requested_at?: DateTime;
    canceled_at?: DateTime;
    completed_at?: DateTime;
    connector: ConnectorSyncJobConnectorReference;
    created_at: DateTime;
    deleted_document_count: long;
    error?: string;
    id: Id;
    indexed_document_count: long;
    indexed_document_volume: long;
    job_type: ConnectorSyncJobType;
    last_seen?: DateTime;
    metadata: Record<string, any>;
    started_at?: DateTime;
    status: ConnectorSyncStatus;
    total_document_count: long;
    trigger_method: ConnectorSyncJobTriggerMethod;
    worker_hostname?: string;
}
export interface ConnectorCustomScheduling {
    configuration_overrides: ConnectorCustomSchedulingConfigurationOverrides;
    enabled: boolean;
    interval: string;
    last_synced?: DateTime;
    name: string;
}
export interface ConnectorCustomSchedulingConfigurationOverrides {
    max_crawl_depth?: integer;
    sitemap_discovery_disabled?: boolean;
    domain_allowlist?: string[];
    sitemap_urls?: string[];
    seed_urls?: string[];
}
export interface ConnectorDependency {
    field: string;
    value: ScalarValue;
}
export type ConnectorDisplayType = 'textbox' | 'textarea' | 'numeric' | 'toggle' | 'dropdown';
export interface ConnectorFeatureEnabled {
    enabled: boolean;
}
export interface ConnectorFilteringAdvancedSnippet {
    created_at?: DateTime;
    updated_at?: DateTime;
    value: any;
}
export interface ConnectorFilteringConfig {
    active: ConnectorFilteringRules;
    domain?: string;
    draft: ConnectorFilteringRules;
}
export type ConnectorFilteringPolicy = 'exclude' | 'include';
export interface ConnectorFilteringRule {
    created_at?: DateTime;
    field: Field;
    id: Id;
    order: integer;
    policy: ConnectorFilteringPolicy;
    rule: ConnectorFilteringRuleRule;
    updated_at?: DateTime;
    value: string;
}
export type ConnectorFilteringRuleRule = 'contains' | 'ends_with' | 'equals' | 'regex' | 'starts_with' | '>' | '<';
export interface ConnectorFilteringRules {
    advanced_snippet: ConnectorFilteringAdvancedSnippet;
    rules: ConnectorFilteringRule[];
    validation: ConnectorFilteringRulesValidation;
}
export interface ConnectorFilteringRulesValidation {
    errors: ConnectorFilteringValidation[];
    state: ConnectorFilteringValidationState;
}
export interface ConnectorFilteringValidation {
    ids: Id[];
    messages: string[];
}
export type ConnectorFilteringValidationState = 'edited' | 'invalid' | 'valid';
export interface ConnectorGreaterThanValidation {
    type: 'greater_than';
    constraint: double;
}
export interface ConnectorIncludedInValidation {
    type: 'included_in';
    constraint: ScalarValue[];
}
export interface ConnectorIngestPipelineParams {
    extract_binary_content: boolean;
    name: string;
    reduce_whitespace: boolean;
    run_ml_inference: boolean;
}
export interface ConnectorLessThanValidation {
    type: 'less_than';
    constraint: double;
}
export interface ConnectorListTypeValidation {
    type: 'list_type';
    constraint: string;
}
export interface ConnectorRegexValidation {
    type: 'regex';
    constraint: string;
}
export interface ConnectorSchedulingConfiguration {
    access_control?: ConnectorConnectorScheduling;
    full?: ConnectorConnectorScheduling;
    incremental?: ConnectorConnectorScheduling;
}
export interface ConnectorSelectOption {
    label: string;
    value: ScalarValue;
}
export interface ConnectorSyncJobConnectorReference {
    configuration: ConnectorConnectorConfiguration;
    filtering: ConnectorFilteringRules;
    id: Id;
    index_name: string;
    language?: string;
    pipeline?: ConnectorIngestPipelineParams;
    service_type: string;
    sync_cursor?: any;
}
export type ConnectorSyncJobTriggerMethod = 'on_demand' | 'scheduled';
export type ConnectorSyncJobType = 'full' | 'incremental' | 'access_control';
export interface ConnectorSyncRulesFeature {
    /** Indicates whether advanced sync rules are enabled. */
    advanced?: ConnectorFeatureEnabled;
    /** Indicates whether basic sync rules are enabled. */
    basic?: ConnectorFeatureEnabled;
}
export type ConnectorSyncStatus = 'canceling' | 'canceled' | 'completed' | 'error' | 'in_progress' | 'pending' | 'suspended';
export type ConnectorValidation = ConnectorLessThanValidation | ConnectorGreaterThanValidation | ConnectorListTypeValidation | ConnectorIncludedInValidation | ConnectorRegexValidation;
export interface ConnectorCheckInRequest extends RequestBase {
    /** The unique identifier of the connector to be checked in */
    connector_id: Id;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        connector_id?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        connector_id?: never;
    };
}
export interface ConnectorCheckInResponse {
    result: Result;
}
export interface ConnectorDeleteRequest extends RequestBase {
    /** The unique identifier of the connector to be deleted */
    connector_id: Id;
    /** A flag indicating if associated sync jobs should be also removed. Defaults to false. */
    delete_sync_jobs?: boolean;
    /** A flag indicating if the connector should be hard deleted. */
    hard?: boolean;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        connector_id?: never;
        delete_sync_jobs?: never;
        hard?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        connector_id?: never;
        delete_sync_jobs?: never;
        hard?: never;
    };
}
export type ConnectorDeleteResponse = AcknowledgedResponseBase;
export interface ConnectorGetRequest extends RequestBase {
    /** The unique identifier of the connector */
    connector_id: Id;
    /** A flag to indicate if the desired connector should be fetched, even if it was soft-deleted. */
    include_deleted?: boolean;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        connector_id?: never;
        include_deleted?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        connector_id?: never;
        include_deleted?: never;
    };
}
export type ConnectorGetResponse = ConnectorConnector;
export interface ConnectorLastSyncRequest extends RequestBase {
    /** The unique identifier of the connector to be updated */
    connector_id: Id;
    last_access_control_sync_error?: string;
    last_access_control_sync_scheduled_at?: DateTime;
    last_access_control_sync_status?: ConnectorSyncStatus;
    last_deleted_document_count?: long;
    last_incremental_sync_scheduled_at?: DateTime;
    last_indexed_document_count?: long;
    last_seen?: DateTime;
    last_sync_error?: string;
    last_sync_scheduled_at?: DateTime;
    last_sync_status?: ConnectorSyncStatus;
    last_synced?: DateTime;
    sync_cursor?: any;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        connector_id?: never;
        last_access_control_sync_error?: never;
        last_access_control_sync_scheduled_at?: never;
        last_access_control_sync_status?: never;
        last_deleted_document_count?: never;
        last_incremental_sync_scheduled_at?: never;
        last_indexed_document_count?: never;
        last_seen?: never;
        last_sync_error?: never;
        last_sync_scheduled_at?: never;
        last_sync_status?: never;
        last_synced?: never;
        sync_cursor?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        connector_id?: never;
        last_access_control_sync_error?: never;
        last_access_control_sync_scheduled_at?: never;
        last_access_control_sync_status?: never;
        last_deleted_document_count?: never;
        last_incremental_sync_scheduled_at?: never;
        last_indexed_document_count?: never;
        last_seen?: never;
        last_sync_error?: never;
        last_sync_scheduled_at?: never;
        last_sync_status?: never;
        last_synced?: never;
        sync_cursor?: never;
    };
}
export interface ConnectorLastSyncResponse {
    result: Result;
}
export interface ConnectorListRequest extends RequestBase {
    /** Starting offset (default: 0) */
    from?: integer;
    /** Specifies a max number of results to get */
    size?: integer;
    /** A comma-separated list of connector index names to fetch connector documents for */
    index_name?: Indices;
    /** A comma-separated list of connector names to fetch connector documents for */
    connector_name?: Names;
    /** A comma-separated list of connector service types to fetch connector documents for */
    service_type?: Names;
    /** A flag to indicate if the desired connector should be fetched, even if it was soft-deleted. */
    include_deleted?: boolean;
    /** A wildcard query string that filters connectors with matching name, description or index name */
    query?: string;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        from?: never;
        size?: never;
        index_name?: never;
        connector_name?: never;
        service_type?: never;
        include_deleted?: never;
        query?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        from?: never;
        size?: never;
        index_name?: never;
        connector_name?: never;
        service_type?: never;
        include_deleted?: never;
        query?: never;
    };
}
export interface ConnectorListResponse {
    count: long;
    results: ConnectorConnector[];
}
export interface ConnectorPostRequest extends RequestBase {
    description?: string;
    index_name?: IndexName;
    is_native?: boolean;
    language?: string;
    name?: string;
    service_type?: string;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        description?: never;
        index_name?: never;
        is_native?: never;
        language?: never;
        name?: never;
        service_type?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        description?: never;
        index_name?: never;
        is_native?: never;
        language?: never;
        name?: never;
        service_type?: never;
    };
}
export interface ConnectorPostResponse {
    result: Result;
    id: Id;
}
export interface ConnectorPutRequest extends RequestBase {
    /** The unique identifier of the connector to be created or updated. ID is auto-generated if not provided. */
    connector_id?: Id;
    description?: string;
    index_name?: IndexName;
    is_native?: boolean;
    language?: string;
    name?: string;
    service_type?: string;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        connector_id?: never;
        description?: never;
        index_name?: never;
        is_native?: never;
        language?: never;
        name?: never;
        service_type?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        connector_id?: never;
        description?: never;
        index_name?: never;
        is_native?: never;
        language?: never;
        name?: never;
        service_type?: never;
    };
}
export interface ConnectorPutResponse {
    result: Result;
    id: Id;
}
export interface ConnectorSyncJobCancelRequest extends RequestBase {
    /** The unique identifier of the connector sync job */
    connector_sync_job_id: Id;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        connector_sync_job_id?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        connector_sync_job_id?: never;
    };
}
export interface ConnectorSyncJobCancelResponse {
    result: Result;
}
export interface ConnectorSyncJobCheckInRequest extends RequestBase {
    /** The unique identifier of the connector sync job to be checked in. */
    connector_sync_job_id: Id;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        connector_sync_job_id?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        connector_sync_job_id?: never;
    };
}
export interface ConnectorSyncJobCheckInResponse {
}
export interface ConnectorSyncJobClaimRequest extends RequestBase {
    /** The unique identifier of the connector sync job. */
    connector_sync_job_id: Id;
    /** The cursor object from the last incremental sync job.
      * This should reference the `sync_cursor` field in the connector state for which the job runs. */
    sync_cursor?: any;
    /** The host name of the current system that will run the job. */
    worker_hostname: string;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        connector_sync_job_id?: never;
        sync_cursor?: never;
        worker_hostname?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        connector_sync_job_id?: never;
        sync_cursor?: never;
        worker_hostname?: never;
    };
}
export interface ConnectorSyncJobClaimResponse {
}
export interface ConnectorSyncJobDeleteRequest extends RequestBase {
    /** The unique identifier of the connector sync job to be deleted */
    connector_sync_job_id: Id;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        connector_sync_job_id?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        connector_sync_job_id?: never;
    };
}
export type ConnectorSyncJobDeleteResponse = AcknowledgedResponseBase;
export interface ConnectorSyncJobErrorRequest extends RequestBase {
    /** The unique identifier for the connector sync job. */
    connector_sync_job_id: Id;
    /** The error for the connector sync job error field. */
    error: string;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        connector_sync_job_id?: never;
        error?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        connector_sync_job_id?: never;
        error?: never;
    };
}
export interface ConnectorSyncJobErrorResponse {
}
export interface ConnectorSyncJobGetRequest extends RequestBase {
    /** The unique identifier of the connector sync job */
    connector_sync_job_id: Id;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        connector_sync_job_id?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        connector_sync_job_id?: never;
    };
}
export type ConnectorSyncJobGetResponse = ConnectorConnectorSyncJob;
export interface ConnectorSyncJobListRequest extends RequestBase {
    /** Starting offset (default: 0) */
    from?: integer;
    /** Specifies a max number of results to get */
    size?: integer;
    /** A sync job status to fetch connector sync jobs for */
    status?: ConnectorSyncStatus;
    /** A connector id to fetch connector sync jobs for */
    connector_id?: Id;
    /** A comma-separated list of job types to fetch the sync jobs for */
    job_type?: ConnectorSyncJobType | ConnectorSyncJobType[];
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        from?: never;
        size?: never;
        status?: never;
        connector_id?: never;
        job_type?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        from?: never;
        size?: never;
        status?: never;
        connector_id?: never;
        job_type?: never;
    };
}
export interface ConnectorSyncJobListResponse {
    count: long;
    results: ConnectorConnectorSyncJob[];
}
export interface ConnectorSyncJobPostRequest extends RequestBase {
    /** The id of the associated connector */
    id: Id;
    job_type?: ConnectorSyncJobType;
    trigger_method?: ConnectorSyncJobTriggerMethod;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        id?: never;
        job_type?: never;
        trigger_method?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        id?: never;
        job_type?: never;
        trigger_method?: never;
    };
}
export interface ConnectorSyncJobPostResponse {
    id: Id;
}
export interface ConnectorSyncJobUpdateStatsRequest extends RequestBase {
    /** The unique identifier of the connector sync job. */
    connector_sync_job_id: Id;
    /** The number of documents the sync job deleted. */
    deleted_document_count: long;
    /** The number of documents the sync job indexed. */
    indexed_document_count: long;
    /** The total size of the data (in MiB) the sync job indexed. */
    indexed_document_volume: long;
    /** The timestamp to use in the `last_seen` property for the connector sync job. */
    last_seen?: Duration;
    /** The connector-specific metadata. */
    metadata?: Metadata;
    /** The total number of documents in the target index after the sync job finished. */
    total_document_count?: integer;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        connector_sync_job_id?: never;
        deleted_document_count?: never;
        indexed_document_count?: never;
        indexed_document_volume?: never;
        last_seen?: never;
        metadata?: never;
        total_document_count?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        connector_sync_job_id?: never;
        deleted_document_count?: never;
        indexed_document_count?: never;
        indexed_document_volume?: never;
        last_seen?: never;
        metadata?: never;
        total_document_count?: never;
    };
}
export interface ConnectorSyncJobUpdateStatsResponse {
}
export interface ConnectorUpdateActiveFilteringRequest extends RequestBase {
    /** The unique identifier of the connector to be updated */
    connector_id: Id;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        connector_id?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        connector_id?: never;
    };
}
export interface ConnectorUpdateActiveFilteringResponse {
    result: Result;
}
export interface ConnectorUpdateApiKeyIdRequest extends RequestBase {
    /** The unique identifier of the connector to be updated */
    connector_id: Id;
    api_key_id?: string;
    api_key_secret_id?: string;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        connector_id?: never;
        api_key_id?: never;
        api_key_secret_id?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        connector_id?: never;
        api_key_id?: never;
        api_key_secret_id?: never;
    };
}
export interface ConnectorUpdateApiKeyIdResponse {
    result: Result;
}
export interface ConnectorUpdateConfigurationRequest extends RequestBase {
    /** The unique identifier of the connector to be updated */
    connector_id: Id;
    configuration?: ConnectorConnectorConfiguration;
    values?: Record<string, any>;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        connector_id?: never;
        configuration?: never;
        values?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        connector_id?: never;
        configuration?: never;
        values?: never;
    };
}
export interface ConnectorUpdateConfigurationResponse {
    result: Result;
}
export interface ConnectorUpdateErrorRequest extends RequestBase {
    /** The unique identifier of the connector to be updated */
    connector_id: Id;
    error: SpecUtilsWithNullValue<string>;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        connector_id?: never;
        error?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        connector_id?: never;
        error?: never;
    };
}
export interface ConnectorUpdateErrorResponse {
    result: Result;
}
export interface ConnectorUpdateFeaturesRequest extends RequestBase {
    /** The unique identifier of the connector to be updated. */
    connector_id: Id;
    features: ConnectorConnectorFeatures;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        connector_id?: never;
        features?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        connector_id?: never;
        features?: never;
    };
}
export interface ConnectorUpdateFeaturesResponse {
    result: Result;
}
export interface ConnectorUpdateFilteringRequest extends RequestBase {
    /** The unique identifier of the connector to be updated */
    connector_id: Id;
    filtering?: ConnectorFilteringConfig[];
    rules?: ConnectorFilteringRule[];
    advanced_snippet?: ConnectorFilteringAdvancedSnippet;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        connector_id?: never;
        filtering?: never;
        rules?: never;
        advanced_snippet?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        connector_id?: never;
        filtering?: never;
        rules?: never;
        advanced_snippet?: never;
    };
}
export interface ConnectorUpdateFilteringResponse {
    result: Result;
}
export interface ConnectorUpdateFilteringValidationRequest extends RequestBase {
    /** The unique identifier of the connector to be updated */
    connector_id: Id;
    validation: ConnectorFilteringRulesValidation;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        connector_id?: never;
        validation?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        connector_id?: never;
        validation?: never;
    };
}
export interface ConnectorUpdateFilteringValidationResponse {
    result: Result;
}
export interface ConnectorUpdateIndexNameRequest extends RequestBase {
    /** The unique identifier of the connector to be updated */
    connector_id: Id;
    index_name: SpecUtilsWithNullValue<IndexName>;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        connector_id?: never;
        index_name?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        connector_id?: never;
        index_name?: never;
    };
}
export interface ConnectorUpdateIndexNameResponse {
    result: Result;
}
export interface ConnectorUpdateNameRequest extends RequestBase {
    /** The unique identifier of the connector to be updated */
    connector_id: Id;
    name?: string;
    description?: string;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        connector_id?: never;
        name?: never;
        description?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        connector_id?: never;
        name?: never;
        description?: never;
    };
}
export interface ConnectorUpdateNameResponse {
    result: Result;
}
export interface ConnectorUpdateNativeRequest extends RequestBase {
    /** The unique identifier of the connector to be updated */
    connector_id: Id;
    is_native: boolean;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        connector_id?: never;
        is_native?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        connector_id?: never;
        is_native?: never;
    };
}
export interface ConnectorUpdateNativeResponse {
    result: Result;
}
export interface ConnectorUpdatePipelineRequest extends RequestBase {
    /** The unique identifier of the connector to be updated */
    connector_id: Id;
    pipeline: ConnectorIngestPipelineParams;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        connector_id?: never;
        pipeline?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        connector_id?: never;
        pipeline?: never;
    };
}
export interface ConnectorUpdatePipelineResponse {
    result: Result;
}
export interface ConnectorUpdateSchedulingRequest extends RequestBase {
    /** The unique identifier of the connector to be updated */
    connector_id: Id;
    scheduling: ConnectorSchedulingConfiguration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        connector_id?: never;
        scheduling?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        connector_id?: never;
        scheduling?: never;
    };
}
export interface ConnectorUpdateSchedulingResponse {
    result: Result;
}
export interface ConnectorUpdateServiceTypeRequest extends RequestBase {
    /** The unique identifier of the connector to be updated */
    connector_id: Id;
    service_type: string;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        connector_id?: never;
        service_type?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        connector_id?: never;
        service_type?: never;
    };
}
export interface ConnectorUpdateServiceTypeResponse {
    result: Result;
}
export interface ConnectorUpdateStatusRequest extends RequestBase {
    /** The unique identifier of the connector to be updated */
    connector_id: Id;
    status: ConnectorConnectorStatus;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        connector_id?: never;
        status?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        connector_id?: never;
        status?: never;
    };
}
export interface ConnectorUpdateStatusResponse {
    result: Result;
}
export interface DanglingIndicesDeleteDanglingIndexRequest extends RequestBase {
    /** The UUID of the index to delete. Use the get dangling indices API to find the UUID. */
    index_uuid: Uuid;
    /** This parameter must be set to true to acknowledge that it will no longer be possible to recove data from the dangling index. */
    accept_data_loss: boolean;
    /** Specify timeout for connection to master */
    master_timeout?: Duration;
    /** Explicit operation timeout */
    timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index_uuid?: never;
        accept_data_loss?: never;
        master_timeout?: never;
        timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index_uuid?: never;
        accept_data_loss?: never;
        master_timeout?: never;
        timeout?: never;
    };
}
export type DanglingIndicesDeleteDanglingIndexResponse = AcknowledgedResponseBase;
export interface DanglingIndicesImportDanglingIndexRequest extends RequestBase {
    /** The UUID of the index to import. Use the get dangling indices API to locate the UUID. */
    index_uuid: Uuid;
    /** This parameter must be set to true to import a dangling index.
      * Because Elasticsearch cannot know where the dangling index data came from or determine which shard copies are fresh and which are stale, it cannot guarantee that the imported data represents the latest state of the index when it was last in the cluster. */
    accept_data_loss: boolean;
    /** Specify timeout for connection to master */
    master_timeout?: Duration;
    /** Explicit operation timeout */
    timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index_uuid?: never;
        accept_data_loss?: never;
        master_timeout?: never;
        timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index_uuid?: never;
        accept_data_loss?: never;
        master_timeout?: never;
        timeout?: never;
    };
}
export type DanglingIndicesImportDanglingIndexResponse = AcknowledgedResponseBase;
export interface DanglingIndicesListDanglingIndicesDanglingIndex {
    index_name: string;
    index_uuid: string;
    creation_date_millis: EpochTime<UnitMillis>;
    node_ids: Ids;
}
export interface DanglingIndicesListDanglingIndicesRequest extends RequestBase {
    /** All values in `body` will be added to the request body. */
    body?: string | {
        [key: string]: any;
    };
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    };
}
export interface DanglingIndicesListDanglingIndicesResponse {
    dangling_indices: DanglingIndicesListDanglingIndicesDanglingIndex[];
}
export interface EnrichPolicy {
    enrich_fields: Fields;
    indices: Indices;
    match_field: Field;
    query?: QueryDslQueryContainer;
    name?: Name;
    elasticsearch_version?: string;
}
export type EnrichPolicyType = 'geo_match' | 'match' | 'range';
export interface EnrichSummary {
    config: Partial<Record<EnrichPolicyType, EnrichPolicy>>;
}
export interface EnrichDeletePolicyRequest extends RequestBase {
    /** Enrich policy to delete. */
    name: Name;
    /** Period to wait for a connection to the master node. */
    master_timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        name?: never;
        master_timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        name?: never;
        master_timeout?: never;
    };
}
export type EnrichDeletePolicyResponse = AcknowledgedResponseBase;
export type EnrichExecutePolicyEnrichPolicyPhase = 'SCHEDULED' | 'RUNNING' | 'COMPLETE' | 'FAILED' | 'CANCELLED';
export interface EnrichExecutePolicyExecuteEnrichPolicyStatus {
    phase: EnrichExecutePolicyEnrichPolicyPhase;
    step?: string;
}
export interface EnrichExecutePolicyRequest extends RequestBase {
    /** Enrich policy to execute. */
    name: Name;
    /** Period to wait for a connection to the master node. */
    master_timeout?: Duration;
    /** If `true`, the request blocks other enrich policy execution requests until complete. */
    wait_for_completion?: boolean;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        name?: never;
        master_timeout?: never;
        wait_for_completion?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        name?: never;
        master_timeout?: never;
        wait_for_completion?: never;
    };
}
export interface EnrichExecutePolicyResponse {
    status?: EnrichExecutePolicyExecuteEnrichPolicyStatus;
    task?: TaskId;
}
export interface EnrichGetPolicyRequest extends RequestBase {
    /** Comma-separated list of enrich policy names used to limit the request.
      * To return information for all enrich policies, omit this parameter. */
    name?: Names;
    /** Period to wait for a connection to the master node. */
    master_timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        name?: never;
        master_timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        name?: never;
        master_timeout?: never;
    };
}
export interface EnrichGetPolicyResponse {
    policies: EnrichSummary[];
}
export interface EnrichPutPolicyRequest extends RequestBase {
    /** Name of the enrich policy to create or update. */
    name: Name;
    /** Period to wait for a connection to the master node. */
    master_timeout?: Duration;
    /** Matches enrich data to incoming documents based on a `geo_shape` query. */
    geo_match?: EnrichPolicy;
    /** Matches enrich data to incoming documents based on a `term` query. */
    match?: EnrichPolicy;
    /** Matches a number, date, or IP address in incoming documents to a range in the enrich index based on a `term` query. */
    range?: EnrichPolicy;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        name?: never;
        master_timeout?: never;
        geo_match?: never;
        match?: never;
        range?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        name?: never;
        master_timeout?: never;
        geo_match?: never;
        match?: never;
        range?: never;
    };
}
export type EnrichPutPolicyResponse = AcknowledgedResponseBase;
export interface EnrichStatsCacheStats {
    node_id: Id;
    count: integer;
    hits: integer;
    hits_time_in_millis: DurationValue<UnitMillis>;
    misses: integer;
    misses_time_in_millis: DurationValue<UnitMillis>;
    evictions: integer;
    size_in_bytes: long;
}
export interface EnrichStatsCoordinatorStats {
    executed_searches_total: long;
    node_id: Id;
    queue_size: integer;
    remote_requests_current: integer;
    remote_requests_total: long;
}
export interface EnrichStatsExecutingPolicy {
    name: Name;
    task: TasksTaskInfo;
}
export interface EnrichStatsRequest extends RequestBase {
    /** Period to wait for a connection to the master node. */
    master_timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        master_timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        master_timeout?: never;
    };
}
export interface EnrichStatsResponse {
    /** Objects containing information about each coordinating ingest node for configured enrich processors. */
    coordinator_stats: EnrichStatsCoordinatorStats[];
    /** Objects containing information about each enrich policy that is currently executing. */
    executing_policies: EnrichStatsExecutingPolicy[];
    /** Objects containing information about the enrich cache stats on each ingest node. */
    cache_stats?: EnrichStatsCacheStats[];
}
export interface EqlEqlHits<TEvent = unknown> {
    /** Metadata about the number of matching events or sequences. */
    total?: SearchTotalHits;
    /** Contains events matching the query. Each object represents a matching event. */
    events?: EqlHitsEvent<TEvent>[];
    /** Contains event sequences matching the query. Each object represents a matching sequence. This parameter is only returned for EQL queries containing a sequence. */
    sequences?: EqlHitsSequence<TEvent>[];
}
export interface EqlEqlSearchResponseBase<TEvent = unknown> {
    /** Identifier for the search. */
    id?: Id;
    /** If true, the response does not contain complete search results. */
    is_partial?: boolean;
    /** If true, the search request is still executing. */
    is_running?: boolean;
    /** Milliseconds it took Elasticsearch to execute the request. */
    took?: DurationValue<UnitMillis>;
    /** If true, the request timed out before completion. */
    timed_out?: boolean;
    /** Contains matching events and sequences. Also contains related metadata. */
    hits: EqlEqlHits<TEvent>;
    /** Contains information about shard failures (if any), in case allow_partial_search_results=true */
    shard_failures?: ShardFailure[];
}
export interface EqlHitsEvent<TEvent = unknown> {
    /** Name of the index containing the event. */
    _index: IndexName;
    /** Unique identifier for the event. This ID is only unique within the index. */
    _id: Id;
    /** Original JSON body passed for the event at index time. */
    _source: TEvent;
    /** Set to `true` for events in a timespan-constrained sequence that do not meet a given condition. */
    missing?: boolean;
    fields?: Record<Field, any[]>;
}
export interface EqlHitsSequence<TEvent = unknown> {
    /** Contains events matching the query. Each object represents a matching event. */
    events: EqlHitsEvent<TEvent>[];
    /** Shared field values used to constrain matches in the sequence. These are defined using the by keyword in the EQL query syntax. */
    join_keys?: any[];
}
export interface EqlDeleteRequest extends RequestBase {
    /** Identifier for the search to delete.
      * A search ID is provided in the EQL search API's response for an async search.
      * A search ID is also provided if the request’s `keep_on_completion` parameter is `true`. */
    id: Id;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        id?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        id?: never;
    };
}
export type EqlDeleteResponse = AcknowledgedResponseBase;
export interface EqlGetRequest extends RequestBase {
    /** Identifier for the search. */
    id: Id;
    /** Period for which the search and its results are stored on the cluster.
      * Defaults to the keep_alive value set by the search’s EQL search API request. */
    keep_alive?: Duration;
    /** Timeout duration to wait for the request to finish.
      * Defaults to no timeout, meaning the request waits for complete search results. */
    wait_for_completion_timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        id?: never;
        keep_alive?: never;
        wait_for_completion_timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        id?: never;
        keep_alive?: never;
        wait_for_completion_timeout?: never;
    };
}
export type EqlGetResponse<TEvent = unknown> = EqlEqlSearchResponseBase<TEvent>;
export interface EqlGetStatusRequest extends RequestBase {
    /** Identifier for the search. */
    id: Id;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        id?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        id?: never;
    };
}
export interface EqlGetStatusResponse {
    /** Identifier for the search. */
    id: Id;
    /** If true, the search request is still executing. If false, the search is completed. */
    is_partial: boolean;
    /** If true, the response does not contain complete search results. This could be because either the search is still running (is_running status is false), or because it is already completed (is_running status is true) and results are partial due to failures or timeouts. */
    is_running: boolean;
    /** For a running search shows a timestamp when the eql search started, in milliseconds since the Unix epoch. */
    start_time_in_millis?: EpochTime<UnitMillis>;
    /** Shows a timestamp when the eql search will be expired, in milliseconds since the Unix epoch. When this time is reached, the search and its results are deleted, even if the search is still ongoing. */
    expiration_time_in_millis?: EpochTime<UnitMillis>;
    /** For a completed search shows the http status code of the completed search. */
    completion_status?: integer;
}
export interface EqlSearchRequest extends RequestBase {
    /** The name of the index to scope the operation */
    index: Indices;
    /** Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified) */
    allow_no_indices?: boolean;
    /** Whether to expand wildcard expression to concrete indices that are open, closed or both. */
    expand_wildcards?: ExpandWildcards;
    /** Indicates whether network round-trips should be minimized as part of cross-cluster search requests execution */
    ccs_minimize_roundtrips?: boolean;
    /** If true, missing or closed indices are not included in the response. */
    ignore_unavailable?: boolean;
    /** EQL query you wish to run. */
    query: string;
    case_sensitive?: boolean;
    /** Field containing the event classification, such as process, file, or network. */
    event_category_field?: Field;
    /** Field used to sort hits with the same timestamp in ascending order */
    tiebreaker_field?: Field;
    /** Field containing event timestamp. Default "@timestamp" */
    timestamp_field?: Field;
    /** Maximum number of events to search at a time for sequence queries. */
    fetch_size?: uint;
    /** Query, written in Query DSL, used to filter the events on which the EQL query runs. */
    filter?: QueryDslQueryContainer | QueryDslQueryContainer[];
    keep_alive?: Duration;
    keep_on_completion?: boolean;
    wait_for_completion_timeout?: Duration;
    /** Allow query execution also in case of shard failures.
      * If true, the query will keep running and will return results based on the available shards.
      * For sequences, the behavior can be further refined using allow_partial_sequence_results */
    allow_partial_search_results?: boolean;
    /** This flag applies only to sequences and has effect only if allow_partial_search_results=true.
      * If true, the sequence query will return results based on the available shards, ignoring the others.
      * If false, the sequence query will return successfully, but will always have empty results. */
    allow_partial_sequence_results?: boolean;
    /** For basic queries, the maximum number of matching events to return. Defaults to 10 */
    size?: uint;
    /** Array of wildcard (*) patterns. The response returns values for field names matching these patterns in the fields property of each hit. */
    fields?: QueryDslFieldAndFormat | Field | (QueryDslFieldAndFormat | Field)[];
    result_position?: EqlSearchResultPosition;
    runtime_mappings?: MappingRuntimeFields;
    /** By default, the response of a sample query contains up to `10` samples, with one sample per unique set of join keys. Use the `size`
      * parameter to get a smaller or larger set of samples. To retrieve more than one sample per set of join keys, use the
      * `max_samples_per_key` parameter. Pipes are not supported for sample queries. */
    max_samples_per_key?: integer;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
        allow_no_indices?: never;
        expand_wildcards?: never;
        ccs_minimize_roundtrips?: never;
        ignore_unavailable?: never;
        query?: never;
        case_sensitive?: never;
        event_category_field?: never;
        tiebreaker_field?: never;
        timestamp_field?: never;
        fetch_size?: never;
        filter?: never;
        keep_alive?: never;
        keep_on_completion?: never;
        wait_for_completion_timeout?: never;
        allow_partial_search_results?: never;
        allow_partial_sequence_results?: never;
        size?: never;
        fields?: never;
        result_position?: never;
        runtime_mappings?: never;
        max_samples_per_key?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
        allow_no_indices?: never;
        expand_wildcards?: never;
        ccs_minimize_roundtrips?: never;
        ignore_unavailable?: never;
        query?: never;
        case_sensitive?: never;
        event_category_field?: never;
        tiebreaker_field?: never;
        timestamp_field?: never;
        fetch_size?: never;
        filter?: never;
        keep_alive?: never;
        keep_on_completion?: never;
        wait_for_completion_timeout?: never;
        allow_partial_search_results?: never;
        allow_partial_sequence_results?: never;
        size?: never;
        fields?: never;
        result_position?: never;
        runtime_mappings?: never;
        max_samples_per_key?: never;
    };
}
export type EqlSearchResponse<TEvent = unknown> = EqlEqlSearchResponseBase<TEvent>;
export type EqlSearchResultPosition = 'tail' | 'head';
export interface EsqlAsyncEsqlResult extends EsqlEsqlResult {
    /** The ID of the async query, to be used in subsequent requests to check the status or retrieve results.
      *
      * Also available in the `X-Elasticsearch-Async-Id` HTTP header. */
    id?: string;
    /** Indicates whether the async query is still running or has completed.
      *
      * Also available in the `X-Elasticsearch-Async-Is-Running` HTTP header. */
    is_running: boolean;
}
export interface EsqlEsqlClusterDetails {
    status: EsqlEsqlClusterStatus;
    indices: string;
    took?: DurationValue<UnitMillis>;
    _shards?: EsqlEsqlShardInfo;
    failures?: EsqlEsqlShardFailure[];
}
export interface EsqlEsqlClusterInfo {
    total: integer;
    successful: integer;
    running: integer;
    skipped: integer;
    partial: integer;
    failed: integer;
    details: Record<string, EsqlEsqlClusterDetails>;
}
export type EsqlEsqlClusterStatus = 'running' | 'successful' | 'partial' | 'skipped' | 'failed';
export interface EsqlEsqlColumnInfo {
    name: string;
    type: string;
}
export type EsqlEsqlFormat = 'csv' | 'json' | 'tsv' | 'txt' | 'yaml' | 'cbor' | 'smile' | 'arrow';
export interface EsqlEsqlResult {
    took?: DurationValue<UnitMillis>;
    is_partial?: boolean;
    all_columns?: EsqlEsqlColumnInfo[];
    columns: EsqlEsqlColumnInfo[];
    values: FieldValue[][];
    /** Cross-cluster search information. Present if `include_ccs_metadata` was `true` in the request
      * and a cross-cluster search was performed. */
    _clusters?: EsqlEsqlClusterInfo;
    /** Profiling information. Present if `profile` was `true` in the request.
      * The contents of this field are currently unstable. */
    profile?: any;
}
export interface EsqlEsqlShardFailure {
    shard: integer;
    index: IndexName | null;
    node?: NodeId;
    reason: ErrorCause;
}
export interface EsqlEsqlShardInfo {
    total: integer;
    successful?: integer;
    skipped?: integer;
    failed?: integer;
}
export interface EsqlTableValuesContainer {
    integer?: EsqlTableValuesIntegerValue[];
    keyword?: EsqlTableValuesKeywordValue[];
    long?: EsqlTableValuesLongValue[];
    double?: EsqlTableValuesLongDouble[];
}
export type EsqlTableValuesIntegerValue = integer | integer[];
export type EsqlTableValuesKeywordValue = string | string[];
export type EsqlTableValuesLongDouble = double | double[];
export type EsqlTableValuesLongValue = long | long[];
export interface EsqlAsyncQueryRequest extends RequestBase {
    /** If `true`, partial results will be returned if there are shard failures, but the query can continue to execute on other clusters and shards.
      * If `false`, the query will fail if there are any failures.
      *
      * To override the default behavior, you can set the `esql.query.allow_partial_results` cluster setting to `false`. */
    allow_partial_results?: boolean;
    /** The character to use between values within a CSV row.
      * It is valid only for the CSV format. */
    delimiter?: string;
    /** Indicates whether columns that are entirely `null` will be removed from the `columns` and `values` portion of the results.
      * If `true`, the response will include an extra section under the name `all_columns` which has the name of all the columns. */
    drop_null_columns?: boolean;
    /** A short version of the Accept header, e.g. json, yaml.
      *
      * `csv`, `tsv`, and `txt` formats will return results in a tabular format, excluding other metadata fields from the response.
      *
      * For async requests, nothing will be returned if the async query doesn't finish within the timeout.
      * The query ID and running status are available in the `X-Elasticsearch-Async-Id` and `X-Elasticsearch-Async-Is-Running` HTTP headers of the response, respectively. */
    format?: EsqlEsqlFormat;
    /** By default, ES|QL returns results as rows. For example, FROM returns each individual document as one row. For the JSON, YAML, CBOR and smile formats, ES|QL can return the results in a columnar fashion where one row represents all the values of a certain column in the results. */
    columnar?: boolean;
    /** Specify a Query DSL query in the filter parameter to filter the set of documents that an ES|QL query runs on. */
    filter?: QueryDslQueryContainer;
    locale?: string;
    /** To avoid any attempts of hacking or code injection, extract the values in a separate list of parameters. Use question mark placeholders (?) in the query string for each of the parameters. */
    params?: FieldValue[];
    /** If provided and `true` the response will include an extra `profile` object
      * with information on how the query was executed. This information is for human debugging
      * and its format can change at any time but it can give some insight into the performance
      * of each part of the query. */
    profile?: boolean;
    /** The ES|QL query API accepts an ES|QL query string in the query parameter, runs it, and returns the results. */
    query: string;
    /** Tables to use with the LOOKUP operation. The top level key is the table
      * name and the next level key is the column name. */
    tables?: Record<string, Record<string, EsqlTableValuesContainer>>;
    /** When set to `true` and performing a cross-cluster query, the response will include an extra `_clusters`
      * object with information about the clusters that participated in the search along with info such as shards
      * count. */
    include_ccs_metadata?: boolean;
    /** The period to wait for the request to finish.
      * By default, the request waits for 1 second for the query results.
      * If the query completes during this period, results are returned
      * Otherwise, a query ID is returned that can later be used to retrieve the results. */
    wait_for_completion_timeout?: Duration;
    /** The period for which the query and its results are stored in the cluster.
      * The default period is five days.
      * When this period expires, the query and its results are deleted, even if the query is still ongoing.
      * If the `keep_on_completion` parameter is false, Elasticsearch only stores async queries that do not complete within the period set by the `wait_for_completion_timeout` parameter, regardless of this value. */
    keep_alive?: Duration;
    /** Indicates whether the query and its results are stored in the cluster.
      * If false, the query and its results are stored in the cluster only if the request does not complete during the period set by the `wait_for_completion_timeout` parameter. */
    keep_on_completion?: boolean;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        allow_partial_results?: never;
        delimiter?: never;
        drop_null_columns?: never;
        format?: never;
        columnar?: never;
        filter?: never;
        locale?: never;
        params?: never;
        profile?: never;
        query?: never;
        tables?: never;
        include_ccs_metadata?: never;
        wait_for_completion_timeout?: never;
        keep_alive?: never;
        keep_on_completion?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        allow_partial_results?: never;
        delimiter?: never;
        drop_null_columns?: never;
        format?: never;
        columnar?: never;
        filter?: never;
        locale?: never;
        params?: never;
        profile?: never;
        query?: never;
        tables?: never;
        include_ccs_metadata?: never;
        wait_for_completion_timeout?: never;
        keep_alive?: never;
        keep_on_completion?: never;
    };
}
export type EsqlAsyncQueryResponse = EsqlAsyncEsqlResult;
export interface EsqlAsyncQueryDeleteRequest extends RequestBase {
    /** The unique identifier of the query.
      * A query ID is provided in the ES|QL async query API response for a query that does not complete in the designated time.
      * A query ID is also provided when the request was submitted with the `keep_on_completion` parameter set to `true`. */
    id: Id;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        id?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        id?: never;
    };
}
export type EsqlAsyncQueryDeleteResponse = AcknowledgedResponseBase;
export interface EsqlAsyncQueryGetRequest extends RequestBase {
    /** The unique identifier of the query.
      * A query ID is provided in the ES|QL async query API response for a query that does not complete in the designated time.
      * A query ID is also provided when the request was submitted with the `keep_on_completion` parameter set to `true`. */
    id: Id;
    /** Indicates whether columns that are entirely `null` will be removed from the `columns` and `values` portion of the results.
      * If `true`, the response will include an extra section under the name `all_columns` which has the name of all the columns. */
    drop_null_columns?: boolean;
    /** A short version of the Accept header, for example `json` or `yaml`. */
    format?: EsqlEsqlFormat;
    /** The period for which the query and its results are stored in the cluster.
      * When this period expires, the query and its results are deleted, even if the query is still ongoing. */
    keep_alive?: Duration;
    /** The period to wait for the request to finish.
      * By default, the request waits for complete query results.
      * If the request completes during the period specified in this parameter, complete query results are returned.
      * Otherwise, the response returns an `is_running` value of `true` and no results. */
    wait_for_completion_timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        id?: never;
        drop_null_columns?: never;
        format?: never;
        keep_alive?: never;
        wait_for_completion_timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        id?: never;
        drop_null_columns?: never;
        format?: never;
        keep_alive?: never;
        wait_for_completion_timeout?: never;
    };
}
export type EsqlAsyncQueryGetResponse = EsqlAsyncEsqlResult;
export interface EsqlAsyncQueryStopRequest extends RequestBase {
    /** The unique identifier of the query.
      * A query ID is provided in the ES|QL async query API response for a query that does not complete in the designated time.
      * A query ID is also provided when the request was submitted with the `keep_on_completion` parameter set to `true`. */
    id: Id;
    /** Indicates whether columns that are entirely `null` will be removed from the `columns` and `values` portion of the results.
      * If `true`, the response will include an extra section under the name `all_columns` which has the name of all the columns. */
    drop_null_columns?: boolean;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        id?: never;
        drop_null_columns?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        id?: never;
        drop_null_columns?: never;
    };
}
export type EsqlAsyncQueryStopResponse = EsqlEsqlResult;
export interface EsqlGetQueryRequest extends RequestBase {
    /** The query ID */
    id: Id;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        id?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        id?: never;
    };
}
export interface EsqlGetQueryResponse {
    id: long;
    node: NodeId;
    start_time_millis: long;
    running_time_nanos: long;
    query: string;
    coordinating_node: NodeId;
    data_nodes: NodeId[];
}
export interface EsqlListQueriesBody {
    id: long;
    node: NodeId;
    start_time_millis: long;
    running_time_nanos: long;
    query: string;
}
export interface EsqlListQueriesRequest extends RequestBase {
    /** All values in `body` will be added to the request body. */
    body?: string | {
        [key: string]: any;
    };
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    };
}
export interface EsqlListQueriesResponse {
    queries: Record<TaskId, EsqlListQueriesBody>;
}
export interface EsqlQueryRequest extends RequestBase {
    /** A short version of the Accept header, e.g. json, yaml.
      *
      * `csv`, `tsv`, and `txt` formats will return results in a tabular format, excluding other metadata fields from the response. */
    format?: EsqlEsqlFormat;
    /** The character to use between values within a CSV row. Only valid for the CSV format. */
    delimiter?: string;
    /** Should columns that are entirely `null` be removed from the `columns` and `values` portion of the results?
      * Defaults to `false`. If `true` then the response will include an extra section under the name `all_columns` which has the name of all columns. */
    drop_null_columns?: boolean;
    /** If `true`, partial results will be returned if there are shard failures, but the query can continue to execute on other clusters and shards.
      * If `false`, the query will fail if there are any failures.
      *
      * To override the default behavior, you can set the `esql.query.allow_partial_results` cluster setting to `false`. */
    allow_partial_results?: boolean;
    /** By default, ES|QL returns results as rows. For example, FROM returns each individual document as one row. For the JSON, YAML, CBOR and smile formats, ES|QL can return the results in a columnar fashion where one row represents all the values of a certain column in the results. */
    columnar?: boolean;
    /** Specify a Query DSL query in the filter parameter to filter the set of documents that an ES|QL query runs on. */
    filter?: QueryDslQueryContainer;
    locale?: string;
    /** To avoid any attempts of hacking or code injection, extract the values in a separate list of parameters. Use question mark placeholders (?) in the query string for each of the parameters. */
    params?: FieldValue[];
    /** If provided and `true` the response will include an extra `profile` object
      * with information on how the query was executed. This information is for human debugging
      * and its format can change at any time but it can give some insight into the performance
      * of each part of the query. */
    profile?: boolean;
    /** The ES|QL query API accepts an ES|QL query string in the query parameter, runs it, and returns the results. */
    query: string;
    /** Tables to use with the LOOKUP operation. The top level key is the table
      * name and the next level key is the column name. */
    tables?: Record<string, Record<string, EsqlTableValuesContainer>>;
    /** When set to `true` and performing a cross-cluster query, the response will include an extra `_clusters`
      * object with information about the clusters that participated in the search along with info such as shards
      * count. */
    include_ccs_metadata?: boolean;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        format?: never;
        delimiter?: never;
        drop_null_columns?: never;
        allow_partial_results?: never;
        columnar?: never;
        filter?: never;
        locale?: never;
        params?: never;
        profile?: never;
        query?: never;
        tables?: never;
        include_ccs_metadata?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        format?: never;
        delimiter?: never;
        drop_null_columns?: never;
        allow_partial_results?: never;
        columnar?: never;
        filter?: never;
        locale?: never;
        params?: never;
        profile?: never;
        query?: never;
        tables?: never;
        include_ccs_metadata?: never;
    };
}
export type EsqlQueryResponse = EsqlEsqlResult;
export interface FeaturesFeature {
    name: string;
    description: string;
}
export interface FeaturesGetFeaturesRequest extends RequestBase {
    /** Period to wait for a connection to the master node. */
    master_timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        master_timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        master_timeout?: never;
    };
}
export interface FeaturesGetFeaturesResponse {
    features: FeaturesFeature[];
}
export interface FeaturesResetFeaturesRequest extends RequestBase {
    /** Period to wait for a connection to the master node. */
    master_timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        master_timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        master_timeout?: never;
    };
}
export interface FeaturesResetFeaturesResponse {
    features: FeaturesFeature[];
}
export type FleetCheckpoint = long;
export interface FleetGlobalCheckpointsRequest extends RequestBase {
    /** A single index or index alias that resolves to a single index. */
    index: IndexName | IndexAlias;
    /** A boolean value which controls whether to wait (until the timeout) for the global checkpoints
      * to advance past the provided `checkpoints`. */
    wait_for_advance?: boolean;
    /** A boolean value which controls whether to wait (until the timeout) for the target index to exist
      * and all primary shards be active. Can only be true when `wait_for_advance` is true. */
    wait_for_index?: boolean;
    /** A comma separated list of previous global checkpoints. When used in combination with `wait_for_advance`,
      * the API will only return once the global checkpoints advances past the checkpoints. Providing an empty list
      * will cause Elasticsearch to immediately return the current global checkpoints. */
    checkpoints?: FleetCheckpoint[];
    /** Period to wait for a global checkpoints to advance past `checkpoints`. */
    timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
        wait_for_advance?: never;
        wait_for_index?: never;
        checkpoints?: never;
        timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
        wait_for_advance?: never;
        wait_for_index?: never;
        checkpoints?: never;
        timeout?: never;
    };
}
export interface FleetGlobalCheckpointsResponse {
    global_checkpoints: FleetCheckpoint[];
    timed_out: boolean;
}
export interface FleetMsearchRequest extends RequestBase {
    /** A single target to search. If the target is an index alias, it must resolve to a single index. */
    index?: IndexName | IndexAlias;
    /** If false, the request returns an error if any wildcard expression, index alias, or _all value targets only missing or closed indices. This behavior applies even if the request targets other open indices. For example, a request targeting foo*,bar* returns an error if an index starts with foo but no index starts with bar. */
    allow_no_indices?: boolean;
    /** If true, network roundtrips between the coordinating node and remote clusters are minimized for cross-cluster search requests. */
    ccs_minimize_roundtrips?: boolean;
    /** Type of index that wildcard expressions can match. If the request can target data streams, this argument determines whether wildcard expressions match hidden data streams. */
    expand_wildcards?: ExpandWildcards;
    /** If true, concrete, expanded or aliased indices are ignored when frozen. */
    ignore_throttled?: boolean;
    /** If true, missing or closed indices are not included in the response. */
    ignore_unavailable?: boolean;
    /** Maximum number of concurrent searches the multi search API can execute. */
    max_concurrent_searches?: integer;
    /** Maximum number of concurrent shard requests that each sub-search request executes per node. */
    max_concurrent_shard_requests?: integer;
    /** Defines a threshold that enforces a pre-filter roundtrip to prefilter search shards based on query rewriting if the number of shards the search request expands to exceeds the threshold. This filter roundtrip can limit the number of shards significantly if for instance a shard can not match any documents based on its rewrite method i.e., if date filters are mandatory to match but the shard bounds and the query are disjoint. */
    pre_filter_shard_size?: long;
    /** Indicates whether global term and document frequencies should be used when scoring returned documents. */
    search_type?: SearchType;
    /** If true, hits.total are returned as an integer in the response. Defaults to false, which returns an object. */
    rest_total_hits_as_int?: boolean;
    /** Specifies whether aggregation and suggester names should be prefixed by their respective types in the response. */
    typed_keys?: boolean;
    /** A comma separated list of checkpoints. When configured, the search API will only be executed on a shard
      * after the relevant checkpoint has become visible for search. Defaults to an empty list which will cause
      * Elasticsearch to immediately execute the search. */
    wait_for_checkpoints?: FleetCheckpoint[];
    /** If true, returns partial results if there are shard request timeouts or shard failures.
      * If false, returns an error with no partial results.
      * Defaults to the configured cluster setting `search.default_allow_partial_results`, which is true by default. */
    allow_partial_search_results?: boolean;
    searches?: MsearchRequestItem[];
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
        allow_no_indices?: never;
        ccs_minimize_roundtrips?: never;
        expand_wildcards?: never;
        ignore_throttled?: never;
        ignore_unavailable?: never;
        max_concurrent_searches?: never;
        max_concurrent_shard_requests?: never;
        pre_filter_shard_size?: never;
        search_type?: never;
        rest_total_hits_as_int?: never;
        typed_keys?: never;
        wait_for_checkpoints?: never;
        allow_partial_search_results?: never;
        searches?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
        allow_no_indices?: never;
        ccs_minimize_roundtrips?: never;
        expand_wildcards?: never;
        ignore_throttled?: never;
        ignore_unavailable?: never;
        max_concurrent_searches?: never;
        max_concurrent_shard_requests?: never;
        pre_filter_shard_size?: never;
        search_type?: never;
        rest_total_hits_as_int?: never;
        typed_keys?: never;
        wait_for_checkpoints?: never;
        allow_partial_search_results?: never;
        searches?: never;
    };
}
export interface FleetMsearchResponse<TDocument = unknown> {
    docs: MsearchResponseItem<TDocument>[];
}
export interface FleetSearchRequest extends RequestBase {
    /** A single target to search. If the target is an index alias, it must resolve to a single index. */
    index: IndexName | IndexAlias;
    allow_no_indices?: boolean;
    analyzer?: string;
    analyze_wildcard?: boolean;
    batched_reduce_size?: long;
    ccs_minimize_roundtrips?: boolean;
    default_operator?: QueryDslOperator;
    df?: string;
    expand_wildcards?: ExpandWildcards;
    ignore_throttled?: boolean;
    ignore_unavailable?: boolean;
    lenient?: boolean;
    max_concurrent_shard_requests?: integer;
    preference?: string;
    pre_filter_shard_size?: long;
    request_cache?: boolean;
    routing?: Routing;
    scroll?: Duration;
    search_type?: SearchType;
    /** Specifies which field to use for suggestions. */
    suggest_field?: Field;
    suggest_mode?: SuggestMode;
    suggest_size?: long;
    /** The source text for which the suggestions should be returned. */
    suggest_text?: string;
    typed_keys?: boolean;
    rest_total_hits_as_int?: boolean;
    _source_excludes?: Fields;
    _source_includes?: Fields;
    q?: string;
    /** A comma separated list of checkpoints. When configured, the search API will only be executed on a shard
      * after the relevant checkpoint has become visible for search. Defaults to an empty list which will cause
      * Elasticsearch to immediately execute the search. */
    wait_for_checkpoints?: FleetCheckpoint[];
    /** If true, returns partial results if there are shard request timeouts or shard failures.
      * If false, returns an error with no partial results.
      * Defaults to the configured cluster setting `search.default_allow_partial_results`, which is true by default. */
    allow_partial_search_results?: boolean;
    aggregations?: Record<string, AggregationsAggregationContainer>;
    /** @alias aggregations */
    aggs?: Record<string, AggregationsAggregationContainer>;
    collapse?: SearchFieldCollapse;
    /** If true, returns detailed information about score computation as part of a hit. */
    explain?: boolean;
    /** Configuration of search extensions defined by Elasticsearch plugins. */
    ext?: Record<string, any>;
    /** Starting document offset. By default, you cannot page through more than 10,000
      * hits using the from and size parameters. To page through more hits, use the
      * search_after parameter. */
    from?: integer;
    highlight?: SearchHighlight;
    /** Number of hits matching the query to count accurately. If true, the exact
      * number of hits is returned at the cost of some performance. If false, the
      * response does not include the total number of hits matching the query.
      * Defaults to 10,000 hits. */
    track_total_hits?: SearchTrackHits;
    /** Boosts the _score of documents from specified indices. */
    indices_boost?: Partial<Record<IndexName, double>>[];
    /** Array of wildcard (*) patterns. The request returns doc values for field
      * names matching these patterns in the hits.fields property of the response. */
    docvalue_fields?: (QueryDslFieldAndFormat | Field)[];
    /** Minimum _score for matching documents. Documents with a lower _score are
      * not included in search results and results collected by aggregations. */
    min_score?: double;
    post_filter?: QueryDslQueryContainer;
    profile?: boolean;
    /** Defines the search definition using the Query DSL. */
    query?: QueryDslQueryContainer;
    rescore?: SearchRescore | SearchRescore[];
    /** Retrieve a script evaluation (based on different fields) for each hit. */
    script_fields?: Record<string, ScriptField>;
    search_after?: SortResults;
    /** The number of hits to return. By default, you cannot page through more
      * than 10,000 hits using the from and size parameters. To page through more
      * hits, use the search_after parameter. */
    size?: integer;
    slice?: SlicedScroll;
    sort?: Sort;
    /** Indicates which source fields are returned for matching documents. These
      * fields are returned in the hits._source property of the search response. */
    _source?: SearchSourceConfig;
    /** Array of wildcard (*) patterns. The request returns values for field names
      * matching these patterns in the hits.fields property of the response. */
    fields?: (QueryDslFieldAndFormat | Field)[];
    suggest?: SearchSuggester;
    /** Maximum number of documents to collect for each shard. If a query reaches this
      * limit, Elasticsearch terminates the query early. Elasticsearch collects documents
      * before sorting. Defaults to 0, which does not terminate query execution early. */
    terminate_after?: long;
    /** Specifies the period of time to wait for a response from each shard. If no response
      * is received before the timeout expires, the request fails and returns an error.
      * Defaults to no timeout. */
    timeout?: string;
    /** If true, calculate and return document scores, even if the scores are not used for sorting. */
    track_scores?: boolean;
    /** If true, returns document version as part of a hit. */
    version?: boolean;
    /** If true, returns sequence number and primary term of the last modification
      * of each hit. See Optimistic concurrency control. */
    seq_no_primary_term?: boolean;
    /** List of stored fields to return as part of a hit. If no fields are specified,
      * no stored fields are included in the response. If this field is specified, the _source
      * parameter defaults to false. You can pass _source: true to return both source fields
      * and stored fields in the search response. */
    stored_fields?: Fields;
    /** Limits the search to a point in time (PIT). If you provide a PIT, you
      * cannot specify an <index> in the request path. */
    pit?: SearchPointInTimeReference;
    /** Defines one or more runtime fields in the search request. These fields take
      * precedence over mapped fields with the same name. */
    runtime_mappings?: MappingRuntimeFields;
    /** Stats groups to associate with the search. Each group maintains a statistics
      * aggregation for its associated searches. You can retrieve these stats using
      * the indices stats API. */
    stats?: string[];
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
        allow_no_indices?: never;
        analyzer?: never;
        analyze_wildcard?: never;
        batched_reduce_size?: never;
        ccs_minimize_roundtrips?: never;
        default_operator?: never;
        df?: never;
        expand_wildcards?: never;
        ignore_throttled?: never;
        ignore_unavailable?: never;
        lenient?: never;
        max_concurrent_shard_requests?: never;
        preference?: never;
        pre_filter_shard_size?: never;
        request_cache?: never;
        routing?: never;
        scroll?: never;
        search_type?: never;
        suggest_field?: never;
        suggest_mode?: never;
        suggest_size?: never;
        suggest_text?: never;
        typed_keys?: never;
        rest_total_hits_as_int?: never;
        _source_excludes?: never;
        _source_includes?: never;
        q?: never;
        wait_for_checkpoints?: never;
        allow_partial_search_results?: never;
        aggregations?: never;
        aggs?: never;
        collapse?: never;
        explain?: never;
        ext?: never;
        from?: never;
        highlight?: never;
        track_total_hits?: never;
        indices_boost?: never;
        docvalue_fields?: never;
        min_score?: never;
        post_filter?: never;
        profile?: never;
        query?: never;
        rescore?: never;
        script_fields?: never;
        search_after?: never;
        size?: never;
        slice?: never;
        sort?: never;
        _source?: never;
        fields?: never;
        suggest?: never;
        terminate_after?: never;
        timeout?: never;
        track_scores?: never;
        version?: never;
        seq_no_primary_term?: never;
        stored_fields?: never;
        pit?: never;
        runtime_mappings?: never;
        stats?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
        allow_no_indices?: never;
        analyzer?: never;
        analyze_wildcard?: never;
        batched_reduce_size?: never;
        ccs_minimize_roundtrips?: never;
        default_operator?: never;
        df?: never;
        expand_wildcards?: never;
        ignore_throttled?: never;
        ignore_unavailable?: never;
        lenient?: never;
        max_concurrent_shard_requests?: never;
        preference?: never;
        pre_filter_shard_size?: never;
        request_cache?: never;
        routing?: never;
        scroll?: never;
        search_type?: never;
        suggest_field?: never;
        suggest_mode?: never;
        suggest_size?: never;
        suggest_text?: never;
        typed_keys?: never;
        rest_total_hits_as_int?: never;
        _source_excludes?: never;
        _source_includes?: never;
        q?: never;
        wait_for_checkpoints?: never;
        allow_partial_search_results?: never;
        aggregations?: never;
        aggs?: never;
        collapse?: never;
        explain?: never;
        ext?: never;
        from?: never;
        highlight?: never;
        track_total_hits?: never;
        indices_boost?: never;
        docvalue_fields?: never;
        min_score?: never;
        post_filter?: never;
        profile?: never;
        query?: never;
        rescore?: never;
        script_fields?: never;
        search_after?: never;
        size?: never;
        slice?: never;
        sort?: never;
        _source?: never;
        fields?: never;
        suggest?: never;
        terminate_after?: never;
        timeout?: never;
        track_scores?: never;
        version?: never;
        seq_no_primary_term?: never;
        stored_fields?: never;
        pit?: never;
        runtime_mappings?: never;
        stats?: never;
    };
}
export interface FleetSearchResponse<TDocument = unknown> {
    took: long;
    timed_out: boolean;
    _shards: ShardStatistics;
    hits: SearchHitsMetadata<TDocument>;
    aggregations?: Record<AggregateName, AggregationsAggregate>;
    _clusters?: ClusterStatistics;
    fields?: Record<string, any>;
    max_score?: double;
    num_reduce_phases?: long;
    profile?: SearchProfile;
    pit_id?: Id;
    _scroll_id?: ScrollId;
    suggest?: Record<SuggestionName, SearchSuggest<TDocument>[]>;
    terminated_early?: boolean;
}
export interface GraphConnection {
    doc_count: long;
    source: long;
    target: long;
    weight: double;
}
export interface GraphExploreControls {
    /** To avoid the top-matching documents sample being dominated by a single source of results, it is sometimes necessary to request diversity in the sample.
      * You can do this by selecting a single-value field and setting a maximum number of documents per value for that field. */
    sample_diversity?: GraphSampleDiversity;
    /** Each hop considers a sample of the best-matching documents on each shard.
      * Using samples improves the speed of execution and keeps exploration focused on meaningfully-connected terms.
      * Very small values (less than 50) might not provide sufficient weight-of-evidence to identify significant connections between terms.
      * Very large sample sizes can dilute the quality of the results and increase execution times. */
    sample_size?: integer;
    /** The length of time in milliseconds after which exploration will be halted and the results gathered so far are returned.
      * This timeout is honored on a best-effort basis.
      * Execution might overrun this timeout if, for example, a long pause is encountered while FieldData is loaded for a field. */
    timeout?: Duration;
    /** Filters associated terms so only those that are significantly associated with your query are included. */
    use_significance: boolean;
}
export interface GraphHop {
    /** Specifies one or more fields from which you want to extract terms that are associated with the specified vertices. */
    connections?: GraphHop;
    /** An optional guiding query that constrains the Graph API as it explores connected terms. */
    query?: QueryDslQueryContainer;
    /** Contains the fields you are interested in. */
    vertices: GraphVertexDefinition[];
}
export interface GraphSampleDiversity {
    field: Field;
    max_docs_per_value: integer;
}
export interface GraphVertex {
    depth: long;
    field: Field;
    term: string;
    weight: double;
}
export interface GraphVertexDefinition {
    /** Prevents the specified terms from being included in the results. */
    exclude?: string[];
    /** Identifies a field in the documents of interest. */
    field: Field;
    /** Identifies the terms of interest that form the starting points from which you want to spider out. */
    include?: (GraphVertexInclude | string)[];
    /** Specifies how many documents must contain a pair of terms before it is considered to be a useful connection.
      * This setting acts as a certainty threshold. */
    min_doc_count?: long;
    /** Controls how many documents on a particular shard have to contain a pair of terms before the connection is returned for global consideration. */
    shard_min_doc_count?: long;
    /** Specifies the maximum number of vertex terms returned for each field. */
    size?: integer;
}
export interface GraphVertexInclude {
    boost?: double;
    term: string;
}
export interface GraphExploreRequest extends RequestBase {
    /** Name of the index. */
    index: Indices;
    /** Custom value used to route operations to a specific shard. */
    routing?: Routing;
    /** Specifies the period of time to wait for a response from each shard.
      * If no response is received before the timeout expires, the request fails and returns an error.
      * Defaults to no timeout. */
    timeout?: Duration;
    /** Specifies or more fields from which you want to extract terms that are associated with the specified vertices. */
    connections?: GraphHop;
    /** Direct the Graph API how to build the graph. */
    controls?: GraphExploreControls;
    /** A seed query that identifies the documents of interest. Can be any valid Elasticsearch query. */
    query?: QueryDslQueryContainer;
    /** Specifies one or more fields that contain the terms you want to include in the graph as vertices. */
    vertices?: GraphVertexDefinition[];
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
        routing?: never;
        timeout?: never;
        connections?: never;
        controls?: never;
        query?: never;
        vertices?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
        routing?: never;
        timeout?: never;
        connections?: never;
        controls?: never;
        query?: never;
        vertices?: never;
    };
}
export interface GraphExploreResponse {
    connections: GraphConnection[];
    failures: ShardFailure[];
    timed_out: boolean;
    took: long;
    vertices: GraphVertex[];
}
export interface IlmActions {
    /** Phases allowed: warm, cold. */
    allocate?: IlmAllocateAction;
    /** Phases allowed: delete. */
    delete?: IlmDeleteAction;
    /** Phases allowed: hot, warm, cold. */
    downsample?: IlmDownsampleAction;
    /** The freeze action is a noop in 8.x */
    freeze?: EmptyObject;
    /** Phases allowed: hot, warm. */
    forcemerge?: IlmForceMergeAction;
    /** Phases allowed: warm, cold. */
    migrate?: IlmMigrateAction;
    /** Phases allowed: hot, warm, cold. */
    readonly?: EmptyObject;
    /** Phases allowed: hot. */
    rollover?: IlmRolloverAction;
    /** Phases allowed: hot, warm, cold. */
    set_priority?: IlmSetPriorityAction;
    /** Phases allowed: hot, cold, frozen. */
    searchable_snapshot?: IlmSearchableSnapshotAction;
    /** Phases allowed: hot, warm. */
    shrink?: IlmShrinkAction;
    /** Phases allowed: hot, warm, cold, frozen. */
    unfollow?: EmptyObject;
    /** Phases allowed: delete. */
    wait_for_snapshot?: IlmWaitForSnapshotAction;
}
export interface IlmAllocateAction {
    number_of_replicas?: integer;
    total_shards_per_node?: integer;
    include?: Record<string, string>;
    exclude?: Record<string, string>;
    require?: Record<string, string>;
}
export interface IlmDeleteAction {
    delete_searchable_snapshot?: boolean;
}
export interface IlmDownsampleAction {
    fixed_interval: DurationLarge;
    wait_timeout?: Duration;
}
export interface IlmForceMergeAction {
    max_num_segments: integer;
    index_codec?: string;
}
export interface IlmMigrateAction {
    enabled?: boolean;
}
export interface IlmPhase {
    actions?: IlmActions;
    min_age?: Duration;
}
export interface IlmPhases {
    cold?: IlmPhase;
    delete?: IlmPhase;
    frozen?: IlmPhase;
    hot?: IlmPhase;
    warm?: IlmPhase;
}
export interface IlmPolicy {
    phases: IlmPhases;
    /** Arbitrary metadata that is not automatically generated or used by Elasticsearch. */
    _meta?: Metadata;
}
export interface IlmRolloverAction {
    max_size?: ByteSize;
    max_primary_shard_size?: ByteSize;
    max_age?: Duration;
    max_docs?: long;
    max_primary_shard_docs?: long;
    min_size?: ByteSize;
    min_primary_shard_size?: ByteSize;
    min_age?: Duration;
    min_docs?: long;
    min_primary_shard_docs?: long;
}
export interface IlmSearchableSnapshotAction {
    snapshot_repository: string;
    force_merge_index?: boolean;
}
export interface IlmSetPriorityAction {
    priority?: integer;
}
export interface IlmShrinkAction {
    number_of_shards?: integer;
    max_primary_shard_size?: ByteSize;
    allow_write_after_shrink?: boolean;
}
export interface IlmWaitForSnapshotAction {
    policy: string;
}
export interface IlmDeleteLifecycleRequest extends RequestBase {
    /** Identifier for the policy. */
    name: Name;
    /** Period to wait for a connection to the master node. If no response is received before the timeout expires, the request fails and returns an error. */
    master_timeout?: Duration;
    /** Period to wait for a response. If no response is received before the timeout expires, the request fails and returns an error. */
    timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        name?: never;
        master_timeout?: never;
        timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        name?: never;
        master_timeout?: never;
        timeout?: never;
    };
}
export type IlmDeleteLifecycleResponse = AcknowledgedResponseBase;
export type IlmExplainLifecycleLifecycleExplain = IlmExplainLifecycleLifecycleExplainManaged | IlmExplainLifecycleLifecycleExplainUnmanaged;
export interface IlmExplainLifecycleLifecycleExplainManaged {
    action?: Name;
    action_time?: DateTime;
    action_time_millis?: EpochTime<UnitMillis>;
    age?: Duration;
    failed_step?: Name;
    failed_step_retry_count?: integer;
    index: IndexName;
    index_creation_date?: DateTime;
    index_creation_date_millis?: EpochTime<UnitMillis>;
    is_auto_retryable_error?: boolean;
    lifecycle_date?: DateTime;
    lifecycle_date_millis?: EpochTime<UnitMillis>;
    managed: true;
    phase?: Name;
    phase_time?: DateTime;
    phase_time_millis?: EpochTime<UnitMillis>;
    policy?: Name;
    previous_step_info?: Record<string, any>;
    repository_name?: string;
    snapshot_name?: string;
    shrink_index_name?: string;
    step?: Name;
    step_info?: Record<string, any>;
    step_time?: DateTime;
    step_time_millis?: EpochTime<UnitMillis>;
    phase_execution?: IlmExplainLifecycleLifecycleExplainPhaseExecution;
    time_since_index_creation?: Duration;
    skip: boolean;
}
export interface IlmExplainLifecycleLifecycleExplainPhaseExecution {
    phase_definition?: IlmPhase;
    policy: Name;
    version: VersionNumber;
    modified_date_in_millis: EpochTime<UnitMillis>;
}
export interface IlmExplainLifecycleLifecycleExplainUnmanaged {
    index: IndexName;
    managed: false;
}
export interface IlmExplainLifecycleRequest extends RequestBase {
    /** Comma-separated list of data streams, indices, and aliases to target. Supports wildcards (`*`).
      * To target all data streams and indices, use `*` or `_all`. */
    index: IndexName;
    /** Filters the returned indices to only indices that are managed by ILM and are in an error state, either due to an encountering an error while executing the policy, or attempting to use a policy that does not exist. */
    only_errors?: boolean;
    /** Filters the returned indices to only indices that are managed by ILM. */
    only_managed?: boolean;
    /** Period to wait for a connection to the master node. If no response is received before the timeout expires, the request fails and returns an error. */
    master_timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
        only_errors?: never;
        only_managed?: never;
        master_timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
        only_errors?: never;
        only_managed?: never;
        master_timeout?: never;
    };
}
export interface IlmExplainLifecycleResponse {
    indices: Record<IndexName, IlmExplainLifecycleLifecycleExplain>;
}
export interface IlmGetLifecycleLifecycle {
    modified_date: DateTime;
    policy: IlmPolicy;
    version: VersionNumber;
}
export interface IlmGetLifecycleRequest extends RequestBase {
    /** Identifier for the policy. */
    name?: Name;
    /** Period to wait for a connection to the master node. If no response is received before the timeout expires, the request fails and returns an error. */
    master_timeout?: Duration;
    /** Period to wait for a response. If no response is received before the timeout expires, the request fails and returns an error. */
    timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        name?: never;
        master_timeout?: never;
        timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        name?: never;
        master_timeout?: never;
        timeout?: never;
    };
}
export type IlmGetLifecycleResponse = Record<string, IlmGetLifecycleLifecycle>;
export interface IlmGetStatusRequest extends RequestBase {
    /** All values in `body` will be added to the request body. */
    body?: string | {
        [key: string]: any;
    };
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    };
}
export interface IlmGetStatusResponse {
    operation_mode: LifecycleOperationMode;
}
export interface IlmMigrateToDataTiersRequest extends RequestBase {
    /** If true, simulates the migration from node attributes based allocation filters to data tiers, but does not perform the migration.
      * This provides a way to retrieve the indices and ILM policies that need to be migrated. */
    dry_run?: boolean;
    /** The period to wait for a connection to the master node.
      * If no response is received before the timeout expires, the request fails and returns an error.
      * It can also be set to `-1` to indicate that the request should never timeout. */
    master_timeout?: Duration;
    legacy_template_to_delete?: string;
    node_attribute?: string;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        dry_run?: never;
        master_timeout?: never;
        legacy_template_to_delete?: never;
        node_attribute?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        dry_run?: never;
        master_timeout?: never;
        legacy_template_to_delete?: never;
        node_attribute?: never;
    };
}
export interface IlmMigrateToDataTiersResponse {
    dry_run: boolean;
    /** The name of the legacy index template that was deleted.
      * This information is missing if no legacy index templates were deleted. */
    removed_legacy_template: string;
    /** The ILM policies that were updated. */
    migrated_ilm_policies: string[];
    /** The indices that were migrated to tier preference routing. */
    migrated_indices: Indices;
    /** The legacy index templates that were updated to not contain custom routing settings for the provided data attribute. */
    migrated_legacy_templates: string[];
    /** The composable index templates that were updated to not contain custom routing settings for the provided data attribute. */
    migrated_composable_templates: string[];
    /** The component templates that were updated to not contain custom routing settings for the provided data attribute. */
    migrated_component_templates: string[];
}
export interface IlmMoveToStepRequest extends RequestBase {
    /** The name of the index whose lifecycle step is to change */
    index: IndexName;
    /** The step that the index is expected to be in. */
    current_step: IlmMoveToStepStepKey;
    /** The step that you want to run. */
    next_step: IlmMoveToStepStepKey;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
        current_step?: never;
        next_step?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
        current_step?: never;
        next_step?: never;
    };
}
export type IlmMoveToStepResponse = AcknowledgedResponseBase;
export interface IlmMoveToStepStepKey {
    /** The optional action to which the index will be moved. */
    action?: string;
    /** The optional step name to which the index will be moved. */
    name?: string;
    phase: string;
}
export interface IlmPutLifecycleRequest extends RequestBase {
    /** Identifier for the policy. */
    name: Name;
    /** Period to wait for a connection to the master node. If no response is received before the timeout expires, the request fails and returns an error. */
    master_timeout?: Duration;
    /** Period to wait for a response. If no response is received before the timeout expires, the request fails and returns an error. */
    timeout?: Duration;
    policy?: IlmPolicy;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        name?: never;
        master_timeout?: never;
        timeout?: never;
        policy?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        name?: never;
        master_timeout?: never;
        timeout?: never;
        policy?: never;
    };
}
export type IlmPutLifecycleResponse = AcknowledgedResponseBase;
export interface IlmRemovePolicyRequest extends RequestBase {
    /** The name of the index to remove policy on */
    index: IndexName;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
    };
}
export interface IlmRemovePolicyResponse {
    failed_indexes: IndexName[];
    has_failures: boolean;
}
export interface IlmRetryRequest extends RequestBase {
    /** The name of the indices (comma-separated) whose failed lifecycle step is to be retry */
    index: IndexName;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
    };
}
export type IlmRetryResponse = AcknowledgedResponseBase;
export interface IlmStartRequest extends RequestBase {
    /** Period to wait for a connection to the master node. If no response is received before the timeout expires, the request fails and returns an error. */
    master_timeout?: Duration;
    /** Period to wait for a response. If no response is received before the timeout expires, the request fails and returns an error. */
    timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        master_timeout?: never;
        timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        master_timeout?: never;
        timeout?: never;
    };
}
export type IlmStartResponse = AcknowledgedResponseBase;
export interface IlmStopRequest extends RequestBase {
    /** Period to wait for a connection to the master node. If no response is received before the timeout expires, the request fails and returns an error. */
    master_timeout?: Duration;
    /** Period to wait for a response. If no response is received before the timeout expires, the request fails and returns an error. */
    timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        master_timeout?: never;
        timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        master_timeout?: never;
        timeout?: never;
    };
}
export type IlmStopResponse = AcknowledgedResponseBase;
export interface IndicesAlias {
    /** Query used to limit documents the alias can access. */
    filter?: QueryDslQueryContainer;
    /** Value used to route indexing operations to a specific shard.
      * If specified, this overwrites the `routing` value for indexing operations. */
    index_routing?: Routing;
    /** If `true`, the alias is hidden.
      * All indices for the alias must have the same `is_hidden` value. */
    is_hidden?: boolean;
    /** If `true`, the index is the write index for the alias. */
    is_write_index?: boolean;
    /** Value used to route indexing and search operations to a specific shard. */
    routing?: Routing;
    /** Value used to route search operations to a specific shard.
      * If specified, this overwrites the `routing` value for search operations. */
    search_routing?: Routing;
}
export interface IndicesAliasDefinition {
    /** Query used to limit documents the alias can access. */
    filter?: QueryDslQueryContainer;
    /** Value used to route indexing operations to a specific shard.
      * If specified, this overwrites the `routing` value for indexing operations. */
    index_routing?: string;
    /** If `true`, the index is the write index for the alias. */
    is_write_index?: boolean;
    /** Value used to route indexing and search operations to a specific shard. */
    routing?: string;
    /** Value used to route search operations to a specific shard.
      * If specified, this overwrites the `routing` value for search operations. */
    search_routing?: string;
    /** If `true`, the alias is hidden.
      * All indices for the alias must have the same `is_hidden` value. */
    is_hidden?: boolean;
}
export interface IndicesCacheQueries {
    enabled: boolean;
}
export interface IndicesDataStream {
    /** Custom metadata for the stream, copied from the `_meta` object of the stream’s matching index template.
      * If empty, the response omits this property. */
    _meta?: Metadata;
    /** If `true`, the data stream allows custom routing on write request. */
    allow_custom_routing?: boolean;
    /** Information about failure store backing indices */
    failure_store?: IndicesFailureStore;
    /** Current generation for the data stream. This number acts as a cumulative count of the stream’s rollovers, starting at 1. */
    generation: integer;
    /** If `true`, the data stream is hidden. */
    hidden: boolean;
    /** Name of the current ILM lifecycle policy in the stream’s matching index template.
      * This lifecycle policy is set in the `index.lifecycle.name` setting.
      * If the template does not include a lifecycle policy, this property is not included in the response.
      * NOTE: A data stream’s backing indices may be assigned different lifecycle policies. To retrieve the lifecycle policy for individual backing indices, use the get index settings API. */
    ilm_policy?: Name;
    /** Name of the lifecycle system that'll manage the next generation of the data stream. */
    next_generation_managed_by: IndicesManagedBy;
    /** Indicates if ILM should take precedence over DSL in case both are configured to managed this data stream. */
    prefer_ilm: boolean;
    /** Array of objects containing information about the data stream’s backing indices.
      * The last item in this array contains information about the stream’s current write index. */
    indices: IndicesDataStreamIndex[];
    /** Contains the configuration for the data stream lifecycle of this data stream. */
    lifecycle?: IndicesDataStreamLifecycleWithRollover;
    /** Name of the data stream. */
    name: DataStreamName;
    /** If `true`, the data stream is created and managed by cross-cluster replication and the local cluster can not write into this data stream or change its mappings. */
    replicated?: boolean;
    /** If `true`, the next write to this data stream will trigger a rollover first and the document will be indexed in the new backing index. If the rollover fails the indexing request will fail too. */
    rollover_on_write: boolean;
    /** The settings specific to this data stream that will take precedence over the settings in the matching index
      * template. */
    settings: IndicesIndexSettings;
    /** Health status of the data stream.
      * This health status is based on the state of the primary and replica shards of the stream’s backing indices. */
    status: HealthStatus;
    /** If `true`, the data stream is created and managed by an Elastic stack component and cannot be modified through normal user interaction. */
    system?: boolean;
    /** Name of the index template used to create the data stream’s backing indices.
      * The template’s index pattern must match the name of this data stream. */
    template: Name;
    /** Information about the `@timestamp` field in the data stream. */
    timestamp_field: IndicesDataStreamTimestampField;
    /** The index mode for the data stream that will be used for newly created backing indices. */
    index_mode?: IndicesIndexMode;
}
export interface IndicesDataStreamFailureStore {
    /** If defined, it turns the failure store on/off (`true`/`false`) for this data stream. A data stream failure store
      * that's disabled (enabled: `false`) will redirect no new failed indices to the failure store; however, it will
      * not remove any existing data from the failure store. */
    enabled?: boolean;
    /** If defined, it specifies the lifecycle configuration for the failure store of this data stream. */
    lifecycle?: IndicesFailureStoreLifecycle;
}
export interface IndicesDataStreamFailureStoreTemplate {
    /** If defined, it turns the failure store on/off (`true`/`false`) for this data stream. A data stream failure store
      * that's disabled (enabled: `false`) will redirect no new failed indices to the failure store; however, it will
      * not remove any existing data from the failure store. */
    enabled?: boolean | null;
    /** If defined, it specifies the lifecycle configuration for the failure store of this data stream. */
    lifecycle?: IndicesFailureStoreLifecycleTemplate | null;
}
export interface IndicesDataStreamIndex {
    /** Name of the backing index. */
    index_name: IndexName;
    /** Universally unique identifier (UUID) for the index. */
    index_uuid: Uuid;
    /** Name of the current ILM lifecycle policy configured for this backing index. */
    ilm_policy?: Name;
    /** Name of the lifecycle system that's currently managing this backing index. */
    managed_by?: IndicesManagedBy;
    /** Indicates if ILM should take precedence over DSL in case both are configured to manage this index. */
    prefer_ilm?: boolean;
    /** The index mode of this backing index of the data stream. */
    index_mode?: IndicesIndexMode;
}
export interface IndicesDataStreamLifecycle {
    /** If defined, every document added to this data stream will be stored at least for this time frame.
      * Any time after this duration the document could be deleted.
      * When empty, every document in this data stream will be stored indefinitely. */
    data_retention?: Duration;
    /** The downsampling configuration to execute for the managed backing index after rollover. */
    downsampling?: IndicesDataStreamLifecycleDownsampling;
    /** If defined, it turns data stream lifecycle on/off (`true`/`false`) for this data stream. A data stream lifecycle
      * that's disabled (enabled: `false`) will have no effect on the data stream. */
    enabled?: boolean;
}
export interface IndicesDataStreamLifecycleDownsampling {
    /** The list of downsampling rounds to execute as part of this downsampling configuration */
    rounds: IndicesDownsamplingRound[];
}
export interface IndicesDataStreamLifecycleRolloverConditions {
    min_age?: Duration;
    max_age?: string;
    min_docs?: long;
    max_docs?: long;
    min_size?: ByteSize;
    max_size?: ByteSize;
    min_primary_shard_size?: ByteSize;
    max_primary_shard_size?: ByteSize;
    min_primary_shard_docs?: long;
    max_primary_shard_docs?: long;
}
export interface IndicesDataStreamLifecycleWithRollover extends IndicesDataStreamLifecycle {
    /** The conditions which will trigger the rollover of a backing index as configured by the cluster setting `cluster.lifecycle.default.rollover`.
      * This property is an implementation detail and it will only be retrieved when the query param `include_defaults` is set to true.
      * The contents of this field are subject to change. */
    rollover?: IndicesDataStreamLifecycleRolloverConditions;
}
export interface IndicesDataStreamOptions {
    /** If defined, it specifies configuration for the failure store of this data stream. */
    failure_store?: IndicesDataStreamFailureStore;
}
export interface IndicesDataStreamOptionsTemplate {
    failure_store?: IndicesDataStreamFailureStoreTemplate | null;
}
export interface IndicesDataStreamTimestampField {
    /** Name of the timestamp field for the data stream, which must be `@timestamp`. The `@timestamp` field must be included in every document indexed to the data stream. */
    name: Field;
}
export interface IndicesDataStreamVisibility {
    hidden?: boolean;
    allow_custom_routing?: boolean;
}
export interface IndicesDownsampleConfig {
    /** The interval at which to aggregate the original time series index. */
    fixed_interval: DurationLarge;
}
export interface IndicesDownsamplingRound {
    /** The duration since rollover when this downsampling round should execute */
    after: Duration;
    /** The downsample configuration to execute. */
    config: IndicesDownsampleConfig;
}
export interface IndicesFailureStore {
    enabled: boolean;
    indices: IndicesDataStreamIndex[];
    rollover_on_write: boolean;
}
export interface IndicesFailureStoreLifecycle {
    /** If defined, every document added to this data stream will be stored at least for this time frame.
      * Any time after this duration the document could be deleted.
      * When empty, every document in this data stream will be stored indefinitely. */
    data_retention?: Duration;
    /** If defined, it turns data stream lifecycle on/off (`true`/`false`) for this data stream. A data stream lifecycle
      * that's disabled (enabled: `false`) will have no effect on the data stream. */
    enabled?: boolean;
}
export interface IndicesFailureStoreLifecycleTemplate {
    /** If defined, every document added to this data stream will be stored at least for this time frame.
      * Any time after this duration the document could be deleted.
      * When empty, every document in this data stream will be stored indefinitely. */
    data_retention?: Duration | null;
    /** If defined, it turns data stream lifecycle on/off (`true`/`false`) for this data stream. A data stream lifecycle
      * that's disabled (enabled: `false`) will have no effect on the data stream. */
    enabled?: boolean;
}
export interface IndicesFielddataFrequencyFilter {
    max: double;
    min: double;
    min_segment_size: integer;
}
export type IndicesIndexCheckOnStartup = boolean | 'true' | 'false' | 'checksum';
export type IndicesIndexMode = 'standard' | 'time_series' | 'logsdb' | 'lookup';
export interface IndicesIndexRouting {
    allocation?: IndicesIndexRoutingAllocation;
    rebalance?: IndicesIndexRoutingRebalance;
}
export interface IndicesIndexRoutingAllocation {
    enable?: IndicesIndexRoutingAllocationOptions;
    include?: IndicesIndexRoutingAllocationInclude;
    initial_recovery?: IndicesIndexRoutingAllocationInitialRecovery;
    disk?: IndicesIndexRoutingAllocationDisk;
}
export interface IndicesIndexRoutingAllocationDisk {
    threshold_enabled?: boolean | string;
}
export interface IndicesIndexRoutingAllocationInclude {
    _tier_preference?: string;
    _id?: Id;
}
export interface IndicesIndexRoutingAllocationInitialRecovery {
    _id?: Id;
}
export type IndicesIndexRoutingAllocationOptions = 'all' | 'primaries' | 'new_primaries' | 'none';
export interface IndicesIndexRoutingRebalance {
    enable: IndicesIndexRoutingRebalanceOptions;
}
export type IndicesIndexRoutingRebalanceOptions = 'all' | 'primaries' | 'replicas' | 'none';
export interface IndicesIndexSegmentSort {
    field?: Fields;
    order?: IndicesSegmentSortOrder | IndicesSegmentSortOrder[];
    mode?: IndicesSegmentSortMode | IndicesSegmentSortMode[];
    missing?: IndicesSegmentSortMissing | IndicesSegmentSortMissing[];
}
export interface IndicesIndexSettingBlocks {
    read_only?: SpecUtilsStringified<boolean>;
    read_only_allow_delete?: SpecUtilsStringified<boolean>;
    read?: SpecUtilsStringified<boolean>;
    write?: SpecUtilsStringified<boolean>;
    metadata?: SpecUtilsStringified<boolean>;
}
export interface IndicesIndexSettingsKeys {
    index?: IndicesIndexSettings;
    mode?: string;
    routing_path?: string | string[];
    soft_deletes?: IndicesSoftDeletes;
    sort?: IndicesIndexSegmentSort;
    /** @remarks This property is not supported on Elastic Cloud Serverless. */
    number_of_shards?: integer | string;
    /** @remarks This property is not supported on Elastic Cloud Serverless. */
    number_of_replicas?: integer | string;
    number_of_routing_shards?: integer;
    check_on_startup?: IndicesIndexCheckOnStartup;
    codec?: string;
    routing_partition_size?: SpecUtilsStringified<integer>;
    load_fixed_bitset_filters_eagerly?: boolean;
    hidden?: boolean | string;
    auto_expand_replicas?: SpecUtilsWithNullValue<string>;
    merge?: IndicesMerge;
    search?: IndicesSettingsSearch;
    refresh_interval?: Duration;
    max_result_window?: integer;
    max_inner_result_window?: integer;
    max_rescore_window?: integer;
    max_docvalue_fields_search?: integer;
    max_script_fields?: integer;
    max_ngram_diff?: integer;
    max_shingle_diff?: integer;
    blocks?: IndicesIndexSettingBlocks;
    max_refresh_listeners?: integer;
    /** Settings to define analyzers, tokenizers, token filters and character filters.
      * Refer to the linked documentation for step-by-step examples of updating analyzers on existing indices. */
    analyze?: IndicesSettingsAnalyze;
    highlight?: IndicesSettingsHighlight;
    max_terms_count?: integer;
    max_regex_length?: integer;
    routing?: IndicesIndexRouting;
    gc_deletes?: Duration;
    default_pipeline?: PipelineName;
    final_pipeline?: PipelineName;
    lifecycle?: IndicesIndexSettingsLifecycle;
    provided_name?: Name;
    creation_date?: SpecUtilsStringified<EpochTime<UnitMillis>>;
    creation_date_string?: DateTime;
    uuid?: Uuid;
    version?: IndicesIndexVersioning;
    verified_before_close?: boolean | string;
    format?: string | integer;
    max_slices_per_scroll?: integer;
    translog?: IndicesTranslog;
    query_string?: IndicesSettingsQueryString;
    priority?: integer | string;
    top_metrics_max_size?: integer;
    analysis?: IndicesIndexSettingsAnalysis;
    settings?: IndicesIndexSettings;
    time_series?: IndicesIndexSettingsTimeSeries;
    queries?: IndicesQueries;
    /** Configure custom similarity settings to customize how search results are scored. */
    similarity?: Record<string, IndicesSettingsSimilarity>;
    /** Enable or disable dynamic mapping for an index. */
    mapping?: IndicesMappingLimitSettings;
    'indexing.slowlog'?: IndicesIndexingSlowlogSettings;
    /** Configure indexing back pressure limits. */
    indexing_pressure?: IndicesIndexingPressure;
    /** The store module allows you to control how index data is stored and accessed on disk. */
    store?: IndicesStorage;
}
export type IndicesIndexSettings = IndicesIndexSettingsKeys & {
    [property: string]: any;
};
export interface IndicesIndexSettingsAnalysis {
    analyzer?: Record<string, AnalysisAnalyzer>;
    char_filter?: Record<string, AnalysisCharFilter>;
    filter?: Record<string, AnalysisTokenFilter>;
    normalizer?: Record<string, AnalysisNormalizer>;
    tokenizer?: Record<string, AnalysisTokenizer>;
}
export interface IndicesIndexSettingsLifecycle {
    /** The name of the policy to use to manage the index. For information about how Elasticsearch applies policy changes, see Policy updates. */
    name?: Name;
    /** Indicates whether or not the index has been rolled over. Automatically set to true when ILM completes the rollover action.
      * You can explicitly set it to skip rollover. */
    indexing_complete?: SpecUtilsStringified<boolean>;
    /** If specified, this is the timestamp used to calculate the index age for its phase transitions. Use this setting
      * if you create a new index that contains old data and want to use the original creation date to calculate the index
      * age. Specified as a Unix epoch value in milliseconds. */
    origination_date?: long;
    /** Set to true to parse the origination date from the index name. This origination date is used to calculate the index age
      * for its phase transitions. The index name must match the pattern ^.*-{date_format}-\\d+, where the date_format is
      * yyyy.MM.dd and the trailing digits are optional. An index that was rolled over would normally match the full format,
      * for example logs-2016.10.31-000002). If the index name doesn’t match the pattern, index creation fails. */
    parse_origination_date?: boolean;
    step?: IndicesIndexSettingsLifecycleStep;
    /** The index alias to update when the index rolls over. Specify when using a policy that contains a rollover action.
      * When the index rolls over, the alias is updated to reflect that the index is no longer the write index. For more
      * information about rolling indices, see Rollover. */
    rollover_alias?: string;
    /** Preference for the system that manages a data stream backing index (preferring ILM when both ILM and DLM are
      * applicable for an index). */
    prefer_ilm?: boolean | string;
}
export interface IndicesIndexSettingsLifecycleStep {
    /** Time to wait for the cluster to resolve allocation issues during an ILM shrink action. Must be greater than 1h (1 hour).
      * See Shard allocation for shrink. */
    wait_time_threshold?: Duration;
}
export interface IndicesIndexSettingsTimeSeries {
    end_time?: DateTime;
    start_time?: DateTime;
}
export interface IndicesIndexState {
    aliases?: Record<IndexName, IndicesAlias>;
    mappings?: MappingTypeMapping;
    settings?: IndicesIndexSettings;
    /** Default settings, included when the request's `include_default` is `true`. */
    defaults?: IndicesIndexSettings;
    data_stream?: DataStreamName;
    /** Data stream lifecycle applicable if this is a data stream. */
    lifecycle?: IndicesDataStreamLifecycle;
}
export interface IndicesIndexTemplate {
    /** Name of the index template. */
    index_patterns: Names;
    /** An ordered list of component template names.
      * Component templates are merged in the order specified, meaning that the last component template specified has the highest precedence. */
    composed_of: Name[];
    /** Template to be applied.
      * It may optionally include an `aliases`, `mappings`, or `settings` configuration. */
    template?: IndicesIndexTemplateSummary;
    /** Version number used to manage index templates externally.
      * This number is not automatically generated by Elasticsearch. */
    version?: VersionNumber;
    /** Priority to determine index template precedence when a new data stream or index is created.
      * The index template with the highest priority is chosen.
      * If no priority is specified the template is treated as though it is of priority 0 (lowest priority).
      * This number is not automatically generated by Elasticsearch. */
    priority?: long;
    /** Optional user metadata about the index template. May have any contents.
      * This map is not automatically generated by Elasticsearch. */
    _meta?: Metadata;
    allow_auto_create?: boolean;
    /** If this object is included, the template is used to create data streams and their backing indices.
      * Supports an empty object.
      * Data streams require a matching index template with a `data_stream` object. */
    data_stream?: IndicesIndexTemplateDataStreamConfiguration;
    /** Marks this index template as deprecated.
      * When creating or updating a non-deprecated index template that uses deprecated components,
      * Elasticsearch will emit a deprecation warning. */
    deprecated?: boolean;
    /** A list of component template names that are allowed to be absent. */
    ignore_missing_component_templates?: Names;
}
export interface IndicesIndexTemplateDataStreamConfiguration {
    /** If true, the data stream is hidden. */
    hidden?: boolean;
    /** If true, the data stream supports custom routing. */
    allow_custom_routing?: boolean;
}
export interface IndicesIndexTemplateSummary {
    /** Aliases to add.
      * If the index template includes a `data_stream` object, these are data stream aliases.
      * Otherwise, these are index aliases.
      * Data stream aliases ignore the `index_routing`, `routing`, and `search_routing` options. */
    aliases?: Record<IndexName, IndicesAlias>;
    /** Mapping for fields in the index.
      * If specified, this mapping can include field names, field data types, and mapping parameters. */
    mappings?: MappingTypeMapping;
    /** Configuration options for the index. */
    settings?: IndicesIndexSettings;
    lifecycle?: IndicesDataStreamLifecycleWithRollover;
    data_stream_options?: IndicesDataStreamOptionsTemplate | null;
}
export interface IndicesIndexVersioning {
    created?: VersionString;
    created_string?: string;
}
export interface IndicesIndexingPressure {
    memory: IndicesIndexingPressureMemory;
}
export interface IndicesIndexingPressureMemory {
    /** Number of outstanding bytes that may be consumed by indexing requests. When this limit is reached or exceeded,
      * the node will reject new coordinating and primary operations. When replica operations consume 1.5x this limit,
      * the node will reject new replica operations. Defaults to 10% of the heap. */
    limit?: integer;
}
export interface IndicesIndexingSlowlogSettings {
    level?: string;
    source?: integer;
    reformat?: boolean;
    threshold?: IndicesIndexingSlowlogTresholds;
}
export interface IndicesIndexingSlowlogTresholds {
    /** The indexing slow log, similar in functionality to the search slow log. The log file name ends with `_index_indexing_slowlog.json`.
      * Log and the thresholds are configured in the same way as the search slowlog. */
    index?: IndicesSlowlogTresholdLevels;
}
export type IndicesIndicesBlockOptions = 'metadata' | 'read' | 'read_only' | 'write';
export type IndicesManagedBy = 'Index Lifecycle Management' | 'Data stream lifecycle' | 'Unmanaged';
export interface IndicesMappingLimitSettings {
    coerce?: boolean;
    total_fields?: IndicesMappingLimitSettingsTotalFields;
    depth?: IndicesMappingLimitSettingsDepth;
    nested_fields?: IndicesMappingLimitSettingsNestedFields;
    nested_objects?: IndicesMappingLimitSettingsNestedObjects;
    field_name_length?: IndicesMappingLimitSettingsFieldNameLength;
    dimension_fields?: IndicesMappingLimitSettingsDimensionFields;
    source?: IndicesMappingLimitSettingsSourceFields;
    ignore_malformed?: boolean | string;
}
export interface IndicesMappingLimitSettingsDepth {
    /** The maximum depth for a field, which is measured as the number of inner objects. For instance, if all fields are defined
      * at the root object level, then the depth is 1. If there is one object mapping, then the depth is 2, etc. */
    limit?: long;
}
export interface IndicesMappingLimitSettingsDimensionFields {
    /** [preview] This functionality is in technical preview and may be changed or removed in a future release.
      * Elastic will work to fix any issues, but features in technical preview are not subject to the support SLA of official GA features. */
    limit?: long;
}
export interface IndicesMappingLimitSettingsFieldNameLength {
    /** Setting for the maximum length of a field name. This setting isn’t really something that addresses mappings explosion but
      * might still be useful if you want to limit the field length. It usually shouldn’t be necessary to set this setting. The
      * default is okay unless a user starts to add a huge number of fields with really long names. Default is `Long.MAX_VALUE` (no limit). */
    limit?: long;
}
export interface IndicesMappingLimitSettingsNestedFields {
    /** The maximum number of distinct nested mappings in an index. The nested type should only be used in special cases, when
      * arrays of objects need to be queried independently of each other. To safeguard against poorly designed mappings, this
      * setting limits the number of unique nested types per index. */
    limit?: long;
}
export interface IndicesMappingLimitSettingsNestedObjects {
    /** The maximum number of nested JSON objects that a single document can contain across all nested types. This limit helps
      * to prevent out of memory errors when a document contains too many nested objects. */
    limit?: long;
}
export interface IndicesMappingLimitSettingsSourceFields {
    mode: IndicesSourceMode;
}
export interface IndicesMappingLimitSettingsTotalFields {
    /** The maximum number of fields in an index. Field and object mappings, as well as field aliases count towards this limit.
      * The limit is in place to prevent mappings and searches from becoming too large. Higher values can lead to performance
      * degradations and memory issues, especially in clusters with a high load or few resources. */
    limit?: long | string;
    /** This setting determines what happens when a dynamically mapped field would exceed the total fields limit. When set
      * to false (the default), the index request of the document that tries to add a dynamic field to the mapping will fail
      * with the message Limit of total fields [X] has been exceeded. When set to true, the index request will not fail.
      * Instead, fields that would exceed the limit are not added to the mapping, similar to dynamic: false.
      * The fields that were not added to the mapping will be added to the _ignored field. */
    ignore_dynamic_beyond_limit?: boolean | string;
}
export interface IndicesMerge {
    scheduler?: IndicesMergeScheduler;
}
export interface IndicesMergeScheduler {
    max_thread_count?: SpecUtilsStringified<integer>;
    max_merge_count?: SpecUtilsStringified<integer>;
}
export interface IndicesNumericFielddata {
    format: IndicesNumericFielddataFormat;
}
export type IndicesNumericFielddataFormat = 'array' | 'disabled';
export interface IndicesQueries {
    cache?: IndicesCacheQueries;
}
export interface IndicesRetentionLease {
    period: Duration;
}
export interface IndicesSearchIdle {
    after?: Duration;
}
export type IndicesSegmentSortMissing = '_last' | '_first';
export type IndicesSegmentSortMode = 'min' | 'MIN' | 'max' | 'MAX';
export type IndicesSegmentSortOrder = 'asc' | 'ASC' | 'desc' | 'DESC';
export interface IndicesSettingsAnalyze {
    max_token_count?: SpecUtilsStringified<integer>;
}
export interface IndicesSettingsHighlight {
    max_analyzed_offset?: integer;
}
export interface IndicesSettingsQueryString {
    lenient: SpecUtilsStringified<boolean>;
}
export interface IndicesSettingsSearch {
    idle?: IndicesSearchIdle;
    slowlog?: IndicesSlowlogSettings;
}
export type IndicesSettingsSimilarity = IndicesSettingsSimilarityBm25 | IndicesSettingsSimilarityBoolean | IndicesSettingsSimilarityDfi | IndicesSettingsSimilarityDfr | IndicesSettingsSimilarityIb | IndicesSettingsSimilarityLmd | IndicesSettingsSimilarityLmj | IndicesSettingsSimilarityScripted;
export interface IndicesSettingsSimilarityBm25 {
    type: 'BM25';
    b?: double;
    discount_overlaps?: boolean;
    k1?: double;
}
export interface IndicesSettingsSimilarityBoolean {
    type: 'boolean';
}
export interface IndicesSettingsSimilarityDfi {
    type: 'DFI';
    independence_measure: DFIIndependenceMeasure;
}
export interface IndicesSettingsSimilarityDfr {
    type: 'DFR';
    after_effect: DFRAfterEffect;
    basic_model: DFRBasicModel;
    normalization: Normalization;
}
export interface IndicesSettingsSimilarityIb {
    type: 'IB';
    distribution: IBDistribution;
    lambda: IBLambda;
    normalization: Normalization;
}
export interface IndicesSettingsSimilarityLmd {
    type: 'LMDirichlet';
    mu?: double;
}
export interface IndicesSettingsSimilarityLmj {
    type: 'LMJelinekMercer';
    lambda?: double;
}
export interface IndicesSettingsSimilarityScripted {
    type: 'scripted';
    script: Script | ScriptSource;
    weight_script?: Script | ScriptSource;
}
export interface IndicesSlowlogSettings {
    level?: string;
    source?: integer;
    reformat?: boolean;
    threshold?: IndicesSlowlogTresholds;
}
export interface IndicesSlowlogTresholdLevels {
    warn?: Duration;
    info?: Duration;
    debug?: Duration;
    trace?: Duration;
}
export interface IndicesSlowlogTresholds {
    query?: IndicesSlowlogTresholdLevels;
    fetch?: IndicesSlowlogTresholdLevels;
}
export interface IndicesSoftDeletes {
    /** Indicates whether soft deletes are enabled on the index. */
    enabled?: boolean;
    /** The maximum period to retain a shard history retention lease before it is considered expired.
      * Shard history retention leases ensure that soft deletes are retained during merges on the Lucene
      * index. If a soft delete is merged away before it can be replicated to a follower the following
      * process will fail due to incomplete history on the leader. */
    retention_lease?: IndicesRetentionLease;
}
export type IndicesSourceMode = 'disabled' | 'stored' | 'synthetic';
export interface IndicesStorage {
    type: IndicesStorageType;
    /** You can restrict the use of the mmapfs and the related hybridfs store type via the setting node.store.allow_mmap.
      * This is a boolean setting indicating whether or not memory-mapping is allowed. The default is to allow it. This
      * setting is useful, for example, if you are in an environment where you can not control the ability to create a lot
      * of memory maps so you need disable the ability to use memory-mapping. */
    allow_mmap?: boolean;
    /** How often store statistics are refreshed */
    stats_refresh_interval?: Duration;
}
export type IndicesStorageType = 'fs' | 'niofs' | 'mmapfs' | 'hybridfs' | string;
export interface IndicesTemplateMapping {
    aliases: Record<IndexName, IndicesAlias>;
    index_patterns: Name[];
    mappings: MappingTypeMapping;
    order: integer;
    settings: Record<string, any>;
    version?: VersionNumber;
}
export interface IndicesTranslog {
    /** How often the translog is fsynced to disk and committed, regardless of write operations.
      * Values less than 100ms are not allowed. */
    sync_interval?: Duration;
    /** Whether or not to `fsync` and commit the translog after every index, delete, update, or bulk request. */
    durability?: IndicesTranslogDurability;
    /** The translog stores all operations that are not yet safely persisted in Lucene (i.e., are not
      * part of a Lucene commit point). Although these operations are available for reads, they will need
      * to be replayed if the shard was stopped and had to be recovered. This setting controls the
      * maximum total size of these operations, to prevent recoveries from taking too long. Once the
      * maximum size has been reached a flush will happen, generating a new Lucene commit point. */
    flush_threshold_size?: ByteSize;
    retention?: IndicesTranslogRetention;
}
export type IndicesTranslogDurability = 'request' | 'REQUEST' | 'async' | 'ASYNC';
export interface IndicesTranslogRetention {
    /** This controls the total size of translog files to keep for each shard. Keeping more translog files increases
      * the chance of performing an operation based sync when recovering a replica. If the translog files are not
      * sufficient, replica recovery will fall back to a file based sync. This setting is ignored, and should not be
      * set, if soft deletes are enabled. Soft deletes are enabled by default in indices created in Elasticsearch
      * versions 7.0.0 and later. */
    size?: ByteSize;
    /** This controls the maximum duration for which translog files are kept by each shard. Keeping more
      * translog files increases the chance of performing an operation based sync when recovering replicas. If
      * the translog files are not sufficient, replica recovery will fall back to a file based sync. This setting
      * is ignored, and should not be set, if soft deletes are enabled. Soft deletes are enabled by default in
      * indices created in Elasticsearch versions 7.0.0 and later. */
    age?: Duration;
}
export interface IndicesAddBlockAddIndicesBlockStatus {
    name: IndexName;
    blocked: boolean;
}
export interface IndicesAddBlockRequest extends RequestBase {
    /** A comma-separated list or wildcard expression of index names used to limit the request.
      * By default, you must explicitly name the indices you are adding blocks to.
      * To allow the adding of blocks to indices with `_all`, `*`, or other wildcard expressions, change the `action.destructive_requires_name` setting to `false`.
      * You can update this setting in the `elasticsearch.yml` file or by using the cluster update settings API. */
    index: IndexName;
    /** The block type to add to the index. */
    block: IndicesIndicesBlockOptions;
    /** If `false`, the request returns an error if any wildcard expression, index alias, or `_all` value targets only missing or closed indices.
      * This behavior applies even if the request targets other open indices.
      * For example, a request targeting `foo*,bar*` returns an error if an index starts with `foo` but no index starts with `bar`. */
    allow_no_indices?: boolean;
    /** The type of index that wildcard patterns can match.
      * If the request can target data streams, this argument determines whether wildcard expressions match hidden data streams.
      * It supports comma-separated values, such as `open,hidden`. */
    expand_wildcards?: ExpandWildcards;
    /** If `false`, the request returns an error if it targets a missing or closed index. */
    ignore_unavailable?: boolean;
    /** The period to wait for the master node.
      * If the master node is not available before the timeout expires, the request fails and returns an error.
      * It can also be set to `-1` to indicate that the request should never timeout. */
    master_timeout?: Duration;
    /** The period to wait for a response from all relevant nodes in the cluster after updating the cluster metadata.
      * If no response is received before the timeout expires, the cluster metadata update still applies but the response will indicate that it was not completely acknowledged.
      * It can also be set to `-1` to indicate that the request should never timeout. */
    timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
        block?: never;
        allow_no_indices?: never;
        expand_wildcards?: never;
        ignore_unavailable?: never;
        master_timeout?: never;
        timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
        block?: never;
        allow_no_indices?: never;
        expand_wildcards?: never;
        ignore_unavailable?: never;
        master_timeout?: never;
        timeout?: never;
    };
}
export interface IndicesAddBlockResponse {
    acknowledged: boolean;
    shards_acknowledged: boolean;
    indices: IndicesAddBlockAddIndicesBlockStatus[];
}
export interface IndicesAnalyzeAnalyzeDetail {
    analyzer?: IndicesAnalyzeAnalyzerDetail;
    charfilters?: IndicesAnalyzeCharFilterDetail[];
    custom_analyzer: boolean;
    tokenfilters?: IndicesAnalyzeTokenDetail[];
    tokenizer?: IndicesAnalyzeTokenDetail;
}
export interface IndicesAnalyzeAnalyzeToken {
    end_offset: long;
    position: long;
    positionLength?: long;
    start_offset: long;
    token: string;
    type: string;
}
export interface IndicesAnalyzeAnalyzerDetail {
    name: string;
    tokens: IndicesAnalyzeExplainAnalyzeToken[];
}
export interface IndicesAnalyzeCharFilterDetail {
    filtered_text: string[];
    name: string;
}
export interface IndicesAnalyzeExplainAnalyzeTokenKeys {
    bytes: string;
    end_offset: long;
    keyword?: boolean;
    position: long;
    positionLength: long;
    start_offset: long;
    termFrequency: long;
    token: string;
    type: string;
}
export type IndicesAnalyzeExplainAnalyzeToken = IndicesAnalyzeExplainAnalyzeTokenKeys & {
    [property: string]: any;
};
export interface IndicesAnalyzeRequest extends RequestBase {
    /** Index used to derive the analyzer.
      * If specified, the `analyzer` or field parameter overrides this value.
      * If no index is specified or the index does not have a default analyzer, the analyze API uses the standard analyzer. */
    index?: IndexName;
    /** The name of the analyzer that should be applied to the provided `text`.
      * This could be a built-in analyzer, or an analyzer that’s been configured in the index. */
    analyzer?: string;
    /** Array of token attributes used to filter the output of the `explain` parameter. */
    attributes?: string[];
    /** Array of character filters used to preprocess characters before the tokenizer. */
    char_filter?: AnalysisCharFilter[];
    /** If `true`, the response includes token attributes and additional details. */
    explain?: boolean;
    /** Field used to derive the analyzer.
      * To use this parameter, you must specify an index.
      * If specified, the `analyzer` parameter overrides this value. */
    field?: Field;
    /** Array of token filters used to apply after the tokenizer. */
    filter?: AnalysisTokenFilter[];
    /** Normalizer to use to convert text into a single token. */
    normalizer?: string;
    /** Text to analyze.
      * If an array of strings is provided, it is analyzed as a multi-value field. */
    text?: IndicesAnalyzeTextToAnalyze;
    /** Tokenizer to use to convert text into tokens. */
    tokenizer?: AnalysisTokenizer;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
        analyzer?: never;
        attributes?: never;
        char_filter?: never;
        explain?: never;
        field?: never;
        filter?: never;
        normalizer?: never;
        text?: never;
        tokenizer?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
        analyzer?: never;
        attributes?: never;
        char_filter?: never;
        explain?: never;
        field?: never;
        filter?: never;
        normalizer?: never;
        text?: never;
        tokenizer?: never;
    };
}
export interface IndicesAnalyzeResponse {
    detail?: IndicesAnalyzeAnalyzeDetail;
    tokens?: IndicesAnalyzeAnalyzeToken[];
}
export type IndicesAnalyzeTextToAnalyze = string | string[];
export interface IndicesAnalyzeTokenDetail {
    name: string;
    tokens: IndicesAnalyzeExplainAnalyzeToken[];
}
export interface IndicesCancelMigrateReindexRequest extends RequestBase {
    /** The index or data stream name */
    index: Indices;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
    };
}
export type IndicesCancelMigrateReindexResponse = AcknowledgedResponseBase;
export interface IndicesClearCacheRequest extends RequestBase {
    /** Comma-separated list of data streams, indices, and aliases used to limit the request.
      * Supports wildcards (`*`).
      * To target all data streams and indices, omit this parameter or use `*` or `_all`. */
    index?: Indices;
    /** If `false`, the request returns an error if any wildcard expression, index alias, or `_all` value targets only missing or closed indices.
      * This behavior applies even if the request targets other open indices. */
    allow_no_indices?: boolean;
    /** Type of index that wildcard patterns can match.
      * If the request can target data streams, this argument determines whether wildcard expressions match hidden data streams.
      * Supports comma-separated values, such as `open,hidden`. */
    expand_wildcards?: ExpandWildcards;
    /** If `true`, clears the fields cache.
      * Use the `fields` parameter to clear the cache of specific fields only. */
    fielddata?: boolean;
    /** Comma-separated list of field names used to limit the `fielddata` parameter. */
    fields?: Fields;
    /** If `false`, the request returns an error if it targets a missing or closed index. */
    ignore_unavailable?: boolean;
    /** If `true`, clears the query cache. */
    query?: boolean;
    /** If `true`, clears the request cache. */
    request?: boolean;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
        allow_no_indices?: never;
        expand_wildcards?: never;
        fielddata?: never;
        fields?: never;
        ignore_unavailable?: never;
        query?: never;
        request?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
        allow_no_indices?: never;
        expand_wildcards?: never;
        fielddata?: never;
        fields?: never;
        ignore_unavailable?: never;
        query?: never;
        request?: never;
    };
}
export type IndicesClearCacheResponse = ShardsOperationResponseBase;
export interface IndicesCloneRequest extends RequestBase {
    /** Name of the source index to clone. */
    index: IndexName;
    /** Name of the target index to create. */
    target: Name;
    /** Period to wait for a connection to the master node.
      * If no response is received before the timeout expires, the request fails and returns an error. */
    master_timeout?: Duration;
    /** Period to wait for a response.
      * If no response is received before the timeout expires, the request fails and returns an error. */
    timeout?: Duration;
    /** The number of shard copies that must be active before proceeding with the operation.
      * Set to `all` or any positive integer up to the total number of shards in the index (`number_of_replicas+1`). */
    wait_for_active_shards?: WaitForActiveShards;
    /** Aliases for the resulting index. */
    aliases?: Record<IndexName, IndicesAlias>;
    /** Configuration options for the target index. */
    settings?: Record<string, any>;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
        target?: never;
        master_timeout?: never;
        timeout?: never;
        wait_for_active_shards?: never;
        aliases?: never;
        settings?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
        target?: never;
        master_timeout?: never;
        timeout?: never;
        wait_for_active_shards?: never;
        aliases?: never;
        settings?: never;
    };
}
export interface IndicesCloneResponse {
    acknowledged: boolean;
    index: IndexName;
    shards_acknowledged: boolean;
}
export interface IndicesCloseCloseIndexResult {
    closed: boolean;
    shards?: Record<string, IndicesCloseCloseShardResult>;
}
export interface IndicesCloseCloseShardResult {
    failures: ShardFailure[];
}
export interface IndicesCloseRequest extends RequestBase {
    /** Comma-separated list or wildcard expression of index names used to limit the request. */
    index: Indices;
    /** If `false`, the request returns an error if any wildcard expression, index alias, or `_all` value targets only missing or closed indices.
      * This behavior applies even if the request targets other open indices. */
    allow_no_indices?: boolean;
    /** Type of index that wildcard patterns can match.
      * If the request can target data streams, this argument determines whether wildcard expressions match hidden data streams.
      * Supports comma-separated values, such as `open,hidden`. */
    expand_wildcards?: ExpandWildcards;
    /** If `false`, the request returns an error if it targets a missing or closed index. */
    ignore_unavailable?: boolean;
    /** Period to wait for a connection to the master node.
      * If no response is received before the timeout expires, the request fails and returns an error. */
    master_timeout?: Duration;
    /** Period to wait for a response.
      * If no response is received before the timeout expires, the request fails and returns an error. */
    timeout?: Duration;
    /** The number of shard copies that must be active before proceeding with the operation.
      * Set to `all` or any positive integer up to the total number of shards in the index (`number_of_replicas+1`). */
    wait_for_active_shards?: WaitForActiveShards;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
        allow_no_indices?: never;
        expand_wildcards?: never;
        ignore_unavailable?: never;
        master_timeout?: never;
        timeout?: never;
        wait_for_active_shards?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
        allow_no_indices?: never;
        expand_wildcards?: never;
        ignore_unavailable?: never;
        master_timeout?: never;
        timeout?: never;
        wait_for_active_shards?: never;
    };
}
export interface IndicesCloseResponse {
    acknowledged: boolean;
    indices: Record<IndexName, IndicesCloseCloseIndexResult>;
    shards_acknowledged: boolean;
}
export interface IndicesCreateRequest extends RequestBase {
    /** Name of the index you wish to create.
      * Index names must meet the following criteria:
      *
      * * Lowercase only
      * * Cannot include `\`, `/`, `*`, `?`, `"`, `<`, `>`, `|`, ` ` (space character), `,`, or `#`
      * * Indices prior to 7.0 could contain a colon (`:`), but that has been deprecated and will not be supported in later versions
      * * Cannot start with `-`, `_`, or `+`
      * * Cannot be `.` or `..`
      * * Cannot be longer than 255 bytes (note thtat it is bytes, so multi-byte characters will reach the limit faster)
      * * Names starting with `.` are deprecated, except for hidden indices and internal indices managed by plugins */
    index: IndexName;
    /** Period to wait for a connection to the master node.
      * If no response is received before the timeout expires, the request fails and returns an error. */
    master_timeout?: Duration;
    /** Period to wait for a response.
      * If no response is received before the timeout expires, the request fails and returns an error. */
    timeout?: Duration;
    /** The number of shard copies that must be active before proceeding with the operation.
      * Set to `all` or any positive integer up to the total number of shards in the index (`number_of_replicas+1`). */
    wait_for_active_shards?: WaitForActiveShards;
    /** Aliases for the index. */
    aliases?: Record<Name, IndicesAlias>;
    /** Mapping for fields in the index. If specified, this mapping can include:
      * - Field names
      * - Field data types
      * - Mapping parameters */
    mappings?: MappingTypeMapping;
    /** Configuration options for the index. */
    settings?: IndicesIndexSettings;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
        master_timeout?: never;
        timeout?: never;
        wait_for_active_shards?: never;
        aliases?: never;
        mappings?: never;
        settings?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
        master_timeout?: never;
        timeout?: never;
        wait_for_active_shards?: never;
        aliases?: never;
        mappings?: never;
        settings?: never;
    };
}
export interface IndicesCreateResponse {
    index: IndexName;
    shards_acknowledged: boolean;
    acknowledged: boolean;
}
export interface IndicesCreateDataStreamRequest extends RequestBase {
    /** Name of the data stream, which must meet the following criteria:
      * Lowercase only;
      * Cannot include `\`, `/`, `*`, `?`, `"`, `<`, `>`, `|`, `,`, `#`, `:`, or a space character;
      * Cannot start with `-`, `_`, `+`, or `.ds-`;
      * Cannot be `.` or `..`;
      * Cannot be longer than 255 bytes. Multi-byte characters count towards this limit faster. */
    name: DataStreamName;
    /** Period to wait for a connection to the master node. If no response is received before the timeout expires, the request fails and returns an error. */
    master_timeout?: Duration;
    /** Period to wait for a response. If no response is received before the timeout expires, the request fails and returns an error. */
    timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        name?: never;
        master_timeout?: never;
        timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        name?: never;
        master_timeout?: never;
        timeout?: never;
    };
}
export type IndicesCreateDataStreamResponse = AcknowledgedResponseBase;
export interface IndicesCreateFromCreateFrom {
    /** Mappings overrides to be applied to the destination index (optional) */
    mappings_override?: MappingTypeMapping;
    /** Settings overrides to be applied to the destination index (optional) */
    settings_override?: IndicesIndexSettings;
    /** If index blocks should be removed when creating destination index (optional) */
    remove_index_blocks?: boolean;
}
export interface IndicesCreateFromRequest extends RequestBase {
    /** The source index or data stream name */
    source: IndexName;
    /** The destination index or data stream name */
    dest: IndexName;
    create_from?: IndicesCreateFromCreateFrom;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        source?: never;
        dest?: never;
        create_from?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        source?: never;
        dest?: never;
        create_from?: never;
    };
}
export interface IndicesCreateFromResponse {
    acknowledged: boolean;
    index: IndexName;
    shards_acknowledged: boolean;
}
export interface IndicesDataStreamsStatsDataStreamsStatsItem {
    /** Current number of backing indices for the data stream. */
    backing_indices: integer;
    /** Name of the data stream. */
    data_stream: Name;
    /** The data stream’s highest `@timestamp` value, converted to milliseconds since the Unix epoch.
      * NOTE: This timestamp is provided as a best effort.
      * The data stream may contain `@timestamp` values higher than this if one or more of the following conditions are met:
      * The stream contains closed backing indices;
      * Backing indices with a lower generation contain higher `@timestamp` values. */
    maximum_timestamp: EpochTime<UnitMillis>;
    /** Total size of all shards for the data stream’s backing indices.
      * This parameter is only returned if the `human` query parameter is `true`. */
    store_size?: ByteSize;
    /** Total size, in bytes, of all shards for the data stream’s backing indices. */
    store_size_bytes: long;
}
export interface IndicesDataStreamsStatsRequest extends RequestBase {
    /** Comma-separated list of data streams used to limit the request.
      * Wildcard expressions (`*`) are supported.
      * To target all data streams in a cluster, omit this parameter or use `*`. */
    name?: IndexName;
    /** Type of data stream that wildcard patterns can match.
      * Supports comma-separated values, such as `open,hidden`. */
    expand_wildcards?: ExpandWildcards;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        name?: never;
        expand_wildcards?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        name?: never;
        expand_wildcards?: never;
    };
}
export interface IndicesDataStreamsStatsResponse {
    /** Contains information about shards that attempted to execute the request. */
    _shards: ShardStatistics;
    /** Total number of backing indices for the selected data streams. */
    backing_indices: integer;
    /** Total number of selected data streams. */
    data_stream_count: integer;
    /** Contains statistics for the selected data streams. */
    data_streams: IndicesDataStreamsStatsDataStreamsStatsItem[];
    /** Total size of all shards for the selected data streams.
      * This property is included only if the `human` query parameter is `true` */
    total_store_sizes?: ByteSize;
    /** Total size, in bytes, of all shards for the selected data streams. */
    total_store_size_bytes: long;
}
export interface IndicesDeleteRequest extends RequestBase {
    /** Comma-separated list of indices to delete.
      * You cannot specify index aliases.
      * By default, this parameter does not support wildcards (`*`) or `_all`.
      * To use wildcards or `_all`, set the `action.destructive_requires_name` cluster setting to `false`. */
    index: Indices;
    /** If `false`, the request returns an error if any wildcard expression, index alias, or `_all` value targets only missing or closed indices.
      * This behavior applies even if the request targets other open indices. */
    allow_no_indices?: boolean;
    /** Type of index that wildcard patterns can match.
      * If the request can target data streams, this argument determines whether wildcard expressions match hidden data streams.
      * Supports comma-separated values, such as `open,hidden`. */
    expand_wildcards?: ExpandWildcards;
    /** If `false`, the request returns an error if it targets a missing or closed index. */
    ignore_unavailable?: boolean;
    /** Period to wait for a connection to the master node.
      * If no response is received before the timeout expires, the request fails and returns an error. */
    master_timeout?: Duration;
    /** Period to wait for a response.
      * If no response is received before the timeout expires, the request fails and returns an error. */
    timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
        allow_no_indices?: never;
        expand_wildcards?: never;
        ignore_unavailable?: never;
        master_timeout?: never;
        timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
        allow_no_indices?: never;
        expand_wildcards?: never;
        ignore_unavailable?: never;
        master_timeout?: never;
        timeout?: never;
    };
}
export type IndicesDeleteResponse = IndicesResponseBase;
export interface IndicesDeleteAliasIndicesAliasesResponseBody extends AcknowledgedResponseBase {
    errors?: boolean;
}
export interface IndicesDeleteAliasRequest extends RequestBase {
    /** Comma-separated list of data streams or indices used to limit the request.
      * Supports wildcards (`*`). */
    index: Indices;
    /** Comma-separated list of aliases to remove.
      * Supports wildcards (`*`). To remove all aliases, use `*` or `_all`. */
    name: Names;
    /** Period to wait for a connection to the master node.
      * If no response is received before the timeout expires, the request fails and returns an error. */
    master_timeout?: Duration;
    /** Period to wait for a response.
      * If no response is received before the timeout expires, the request fails and returns an error. */
    timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        index?: never;
        name?: never;
        master_timeout?: never;
        timeout?: never;
    });
    /** All values in `querystring` will be added to the request querystring. */
    querystring?: {
        [key: string]: any;
    } & {
        index?: never;
        name?: never;
        master_timeout?: never;
        timeout?: never;
    };
}
export type IndicesDeleteAliasResponse = IndicesDeleteAliasIndicesAliasesResponseBody;
export interface IndicesDeleteDataLifecycleRequest extends RequestBase {
    /** A comma-separated list of data streams of which the data stream lifecycle will be deleted; use `*` to get all data streams */
    name: DataStreamNames;
    /** Whether wildcard expressions should get expanded to open or closed indices (default: open) */
    expand_wildcards?: ExpandWildcards;
    /** Specify timeout for connection to master */
    master_timeout?: Duration;
    /** Explicit timestamp for the document */
    timeout?: Duration;
    /** All values in `body` will be added to the request body. */
    body?: string | ({
        [key: string]: any;
    } & {
        name?: never;
        expand_wildcards?: never;
        master_timeout?: never;
        timeout?: never;
    });
    /** All values in 