// Imports
import express from 'express';
import cors from 'cors';
import mongoose from 'mongoose';
import dotenv from 'dotenv';

// Route imports
import trackRoutes from './routes/trackRoutes.js';
import importRoutes from './routes/importRoutes.js';
import productRoutes from './routes/productRoutes.js';
import userRoutes from './routes/userRoutes.js';
import orderRoutes from './routes/ordersRoutes.js';
import authRoutes from './routes/authRoutes.js';
import adminRoutes from './routes/adminRoutes.js';
import adminOrders from './routes/adminOrders.js';
import aliexpressRoutes from './routes/aliexpressRoutes.js';

dotenv.config(); // Load environment variables

const app = express();

// Middleware setup
app.use(cors()); // Enable Cross-Origin Resource Sharing
app.use(express.json()); // Parse incoming JSON requests

// API Routes
app.use('/api/products/track', trackRoutes);         // Product tracking
app.use('/api/products/import', importRoutes);       // Product import
app.use('/api/products', productRoutes);             // Product management
app.use('/api/users', userRoutes);                   // User management
app.use('/api/orders', orderRoutes);                 // Order processing
app.use('/api/auth', authRoutes);                    // Authentication
app.use('/api/admin', adminRoutes);                  // Admin dashboard
app.use('/api/admin/orders', adminOrders);           // Admin order management
app.use('/api/aliexpress', aliexpressRoutes);        // AliExpress integration

// MongoDB connection
mongoose.connect(process.env.MONGO_URI, {
  useNewUrlParser: true,
  useUnifiedTopology: true,
})
.then(() => console.log("✅ MongoDB connected successfully"))
.catch(err => console.error("❌ MongoDB connection failed:", err));

// Start the server
const PORT = process.env.PORT || 3000;
app.listen(PORT, () => console.log(`🚀 Server is running on port ${PORT}`));

export default app;
