// config.js

import dotenv from 'dotenv';
dotenv.config();

const config = {
  port: process.env.PORT || 5000,
  nodeEnv: process.env.NODE_ENV || 'development',
  jwtSecret: process.env.JWT_SECRET || 'changeme',
  jwtExpiry: process.env.JWT_EXPIRY || '7d',
  databaseUrl: process.env.DATABASE_URL || process.env.MONGO_URI || 'mongodb://localhost:27017/myapp',
  elasticsearchUrl: process.env.ELASTICSEARCH_URL || 'http://localhost:9200',
  esUsername: process.env.ES_USERNAME || 'elastic',
  esPassword: process.env.ES_PASSWORD || 'changeme',
  paypalClientId: process.env.PAYPAL_CLIENT_ID || '',
  paypalSecret: process.env.PAYPAL_SECRET || '',
  mongoUrl: process.env.MONGO_URL || 'mongodb://localhost:27017' // Optional: separate Mongo URL
};

export default config;
