import mongoose from 'mongoose';
import config from '../config/config.js'; // Adjust path if needed

export const connectDB = async () => {
  try {
    const conn = await mongoose.connect(config.databaseUrl, {
      useNewUrlParser: true,
      useUnifiedTopology: true,
    });

    console.log(`✅ MongoDB Connected: ${conn.connection.host}`);
  } catch (error) {
    console.error(`❌ MongoDB Connection Error: ${error.message}`);
    process.exit(1);
  }
};
