// connections.js (or whatever filename you're using)

// config/elasticsearch.js
import { Client } from '@elastic/elasticsearch';


const esClient = new Client({
  node: config.elasticsearchUrl,
  auth: {
    username: config.esUsername,
    password: config.esPassword,
  },
});

export default esClient;


// ✅ ES Module style imports
import { Client as ESClient } from '@elastic/elasticsearch';
import { MongoClient } from 'mongodb';
import config from './config.js';

// 🟡 Elasticsearch connection
export const connectElasticsearch = async () => {
  const esClient = new ESClient({
    node: config.elasticsearchUrl,
    auth: {
      username: config.esUsername,
      password: config.esPassword,
    },
  });

  try {
    const health = await esClient.cluster.health();
    console.log(`✅ Elasticsearch Connected: ${health.body.status}`);
  } catch (error) {
    console.error(`❌ Elasticsearch Connection Error: ${error.message}`);
    process.exit(1);
  }

  return esClient;
};

// 🔵 MongoDB connection
export const connectMongoDB = async () => {
  const mongoUri = config.mongoUrl;
  const mongoClient = new MongoClient(mongoUri);

  try {
    await mongoClient.connect();
    console.log('✅ MongoDB Connected');
  } catch (error) {
    console.error(`❌ MongoDB Connection Error: ${error.message}`);
    process.exit(1);
  }

  return mongoClient;
};
