import axios from 'axios';
import { PAYPAL_CLIENT_ID, PAYPAL_SECRET } from './env.js';

export async function getPayPalAccessToken() {
  const res = await axios({
    url: 'https://api-m.sandbox.paypal.com/v1/oauth2/token',
    method: 'post',
    headers: {
      Authorization: `Basic ${Buffer.from(`${PAYPAL_CLIENT_ID}:${PAYPAL_SECRET}`).toString('base64')}`,
    },
    params: {
      grant_type: 'client_credentials',
    },
  });
  return res.data.access_token;
}

