import Admin from "../models/adminModel.js";
import Product from "../models/productModel.js";
import Order from "../models/orderModel.js";
import User from "../models/userModel.js"; // Assuming customer emails are stored here
import fetchAliExpressData from "../utils/fetchAliExpressData.js";
import jwt from "jsonwebtoken";
import bcrypt from "bcrypt";
import mailer from "./mailer.js";

// Admin Login
export const adminLogin = async (req, res) => {
  const { email, password } = req.body;
  const admin = await Admin.findOne({ email });
  if (!admin || !(await bcrypt.compare(password, admin.password))) {
    return res.status(401).json({ message: "Invalid credentials" });
  }
  const token = jwt.sign({ id: admin._id }, process.env.JWT_SECRET);
  res.json({ token });
};

// Reset Password (Placeholder)
export const resetPassword = async (req, res) => {
  // Implement OTP or reset link logic here
  res.status(501).json({ message: "Not implemented yet" });
};

// Update Admin Settings (Placeholder)
export const updateSettings = async (req, res) => {
  // Implement admin profile update logic here
  res.status(501).json({ message: "Not implemented yet" });
};

// Update Order Status
export const updateOrder = async (req, res) => {
  const { id } = req.params;
  const { status, tracking_number } = req.body;

  const order = await Order.findById(id).populate("product").populate("customer");
  if (!order) return res.status(404).json({ message: "Order not found" });

  order.status = status;
  order.tracking_number = tracking_number;
  await order.save();

  if (status === "Shipped") {
    await mailer.sendMail({
      from: process.env.MAIL_USER,
      to: order.customer.email,
      subject: "Your order has been shipped!",
      html: `
        <p>Your order <strong>${order.product.name}</strong> has been shipped.</p>
        <p>Tracking Number: <strong>${tracking_number}</strong></p>
      `,
    });
  }

  res.json({ success: true });
};

// Get All Products
export const getProducts = async (req, res) => {
  const products = await Product.find().sort({ _id: -1 });
  res.json(products);
};

// Create Product
export const createProduct = async (req, res) => {
  const { name, price, category } = req.body;
  const image_url = req.file ? `/uploads/${req.file.filename}` : null;

  const product = new Product({ name, price, category, image_url });
  await product.save();
  res.json(product);
};

// Update Product
export const updateProduct = async (req, res) => {
  const { id } = req.params;
  const updates = req.body;

  const product = await Product.findByIdAndUpdate(id, updates, { new: true });
  if (!product) return res.status(404).json({ message: "Product not found" });

  res.json(product);
};

// Delete Product
export const deleteProduct = async (req, res) => {
  await Product.findByIdAndDelete(req.params.id);
  res.sendStatus(204);
};

// Import AliExpress Product
export const importAliExpressProduct = async (req, res) => {
  const { url } = req.body;
  const data = await fetchAliExpressData(url);

  const product = new Product({
    name: data.name,
    price: data.price,
    category: data.category,
    image_url: data.image_url,
  });

  await product.save();
  res.json(product);
};
