// Import dependencies using ES module syntax
import esClient from '../db/connections.js';
import Product from './models/productModel.js';

// Define the function to fetch and store AliExpress product data
const fetchAliExpressProduct = async (url) => {
  // Simulate fetching product from RapidAPI or a scraper
  const productData = {
    name: "Sample Product",
    price: 19.99,
    image_url: "https://example.com/image.jpg",
    category: "electronics",
    source_url: url
  };

  // Save product to MongoDB
  const savedProduct = await Product.create(productData);

  // Index product in Elasticsearch
  await esClient.index({
    index: 'products',
    id: savedProduct._id.toString(),
    document: {
      name: productData.name,
      price: productData.price,
      image_url: productData.image_url,
      category: productData.category,
      source_url: productData.source_url
    }
  });

  // Return the product data
  return productData;
};


