// controllers/orderController.js
const Order = require("../models/orderModel.js");

// GET /api/orders
exports.getAllOrders = async (req, res) => {
  try {
    const orders = await Order.find();
    res.json(orders);
  } catch (err) {
    res.status(500).json({ error: "Failed to fetch orders" });
  }
};

// PUT /api/orders/:id
exports.updateOrderStatus = async (req, res) => {
  const { id } = req.params;
  const { status, tracking_number } = req.body;

  try {
    const updated = await Order.findByIdAndUpdate(
      id,
      { status, tracking_number },
      { new: true }
    );
    if (!updated) return res.status(404).json({ error: "Order not found" });
    res.json(updated);
  } catch (err) {
    res.status(500).json({ error: "Failed to update order" });
  }
};
