import pool from "../config/db.js";
import sampleProducts from "./sampleProducts.js";
import sampleUsers from "./sampleUsers.js";

const seedDatabase = async () => {
  try {
    await pool.query("DELETE FROM orders");
    await pool.query("DELETE FROM products");
    await pool.query("DELETE FROM users");

    for (const user of sampleUsers) {
      await pool.query(
        `INSERT INTO users (name, email, password, is_admin) VALUES ($1, $2, $3, $4)`,
        [user.name, user.email, user.password, user.isAdmin]
      );
    }

    for (const product of sampleProducts) {
      await pool.query(
        `INSERT INTO products (name, price, category, image_url, description, count_in_stock) VALUES ($1, $2, $3, $4, $5, $6)`,
        [
          product.name,
          product.price,
          product.category,
          product.image_url,
          product.description,
          product.count_in_stock,
        ]
      );
    }

    console.log("✅ Sample data inserted!");
    process.exit();
  } catch (err) {
    console.error("❌ Seed failed:", err);
    process.exit(1);
  }
};

seedDatabase();

