// src/db/connections.js
import mongoose from 'mongoose';
import { Client } from '@elastic/elasticsearch';
import dotenv from 'dotenv';

dotenv.config();

// MongoDB connection
export async function connectMongoDB() {
  try {
    await mongoose.connect(process.env.DATABASE_URL, {
      useNewUrlParser: true,
      useUnifiedTopology: true,
      ssl: process.env.NODE_ENV === 'production',
      sslValidate: process.env.NODE_ENV === 'production',
    });
    console.log('✅ MongoDB connected successfully');
  } catch (error) {
    console.error('❌ MongoDB connection error:', error);
    process.exit(1);
  }
}

// Elasticsearch connection
export async function connectElasticsearch() {
  try {
    const client = new Client({
      node: process.env.ELASTICSEARCH_URL,
      auth: {
        username: process.env.ELASTICSEARCH_USERNAME,
        password: process.env.ELASTICSEARCH_PASSWORD,
      },
      ssl: {
        rejectUnauthorized: process.env.NODE_ENV === 'production',
      },
    });

    const health = await client.cluster.health();
    console.log('✅ Elasticsearch cluster health:', health.body.status);
  } catch (error) {
    console.error('❌ Elasticsearch connection error:', error);
    process.exit(1);
  }
}
export default connectMongoDB;