// src/models/adminModel.js
import mongoose from 'mongoose';

const { Schema, model } = mongoose;

const adminSchema = new Schema(
  {
    email: {
      type: String,
      required: [true, 'Email is required'],
      unique: true,
      lowercase: true,
      trim: true,
      match: [/.+@.+\..+/, 'Please enter a valid email address']
    },
    passwordHash: {
      type: String,
      required: [true, 'Password hash is required']
    },
    role: {
      type: String,
      enum: ['superadmin', 'moderator', 'viewer'],
      default: 'moderator'
    },
    isActive: {
      type: Boolean,
      default: true
    },
    lastLogin: {
      type: Date
    }
  },
  {
    timestamps: true,
    collection: 'admins'
  }
);

const Admin = model('Admin', adminSchema);

export default Admin;
