import { Sequelize } from "sequelize";
import { Product } from "./Product.js";
import { Category } from "./Category.js";
import { Order } from "./Order.js";
import { User } from "./User.js";

const sequelize = new Sequelize(process.env.DATABASE_URL, {
  dialect: "postgres",
  logging: false,
});

// Initialize models
Product.initModel(sequelize);
Category.initModel(sequelize);
Order.initModel(sequelize);
User.initModel(sequelize);

// Define relationships
Product.belongsTo(Category);
Category.hasMany(Product);

Order.belongsTo(User);
User.hasMany(Order);

// Export models and sequelize instance
export {
  sequelize,
  Product,
  Category,
  Order,
  User,
};
