// models/userModel.js
import mongoose from 'mongoose';
import esClient from '../elastic/esClient.js'; // Ensure this path is correct

const userSchema = new mongoose.Schema({
  name: {
    type: String,
    required: true,
    trim: true
  },
  email: {
    type: String,
    required: true,
    unique: true
  },
  password: {
    type: String,
    required: true
  },
  age: {
    type: Number
  }
}, { timestamps: true });

// Elasticsearch sync after saving a user
userSchema.post('save', async function(doc) {
  try {
    await esClient.index({
      index: 'users',
      id: doc._id.toString(),
      body: {
        name: doc.name,
        email: doc.email,
        age: doc.age
      }
    });
  } catch (error) {
    console.error('Elasticsearch indexing error:', error);
  }
});

const User = mongoose.model('User', userSchema);

export default User;
