// Import Express and create a router instance
import express from "express";
const router = express.Router();

// Import the AliExpress controller functions
import aliexpressController from "../controllers/aliexpressController.js";

// Import middleware to protect admin-only routes
import { protectAdmin } from "../Middleware/authMiddleware.js";

// Route to search for products on AliExpress
router.get("/search", aliexpressController.searchAliExpressProducts);

// Route to import a product from AliExpress by URL (admin access only)
router.post("/import", protectAdmin, aliexpressController.importAliExpressProductByUrl);

// Export the router as default
export default router;