import express from 'express';
import { Router } from 'express';
import * as orderController from '../controllers/orderController.js';
import { protectUser, protectAdmin } from '../Middleware/authMiddleware.js';


router.post("/", protectUser, orderController.createOrder);
router.get("/", protectUser, orderController.getUserOrders);
router.get("/all", protectAdmin, orderController.getAllOrders);
router.put("/:id/status", protectAdmin, orderController.updateOrderStatus);
router.put("/:id/tracking", protectAdmin, orderController.updateTrackingNumber);

module.exports = router;


app.post('/api/orders', async (req, res) => {
  const { product_id, customer_email, quantity } = req.body;
  await db.query(
    'INSERT INTO orders (product_id, customer_email, quantity) VALUES ($1, $2, $3)',
    [product_id, customer_email, quantity]
  );
  res.json({ success: true });
});

app.get('/api/orders', async (req, res) => {
  const { email } = req.query;

  if (!email) return res.status(400).json({ error: 'Email required' });

  const result = await db.query(
    `SELECT o.*, p.name, p.image, p.price
     FROM orders o JOIN products p ON o.product_id = p.id
     WHERE o.customer_email = $1
     ORDER BY o.created_at DESC`,
    [email]
  );

  res.json(result.rows);
});

// routes/ordersRoutes.js
const router = express.Router();
import db from '../db/connections.js';


// GET /api/orders - Customer orders by email
router.get('/orders', async (req, res) => {
  const { email } = req.query;

  if (!email) return res.status(400).json({ error: 'Email required' });

  const result = await db.query(
    `SELECT o.*, p.name, p.image, p.price
     FROM orders o JOIN products p ON o.product_id = p.id
     WHERE o.customer_email = $1
     ORDER BY o.created_at DESC`,
    [email]
  );

  res.json(result.rows);
});

module.exports = router;



// GET /api/orders?email=user@example.com
router.get('/orders', async (req, res) => {
  const { email } = req.query;
  if (!email) return res.status(400).json({ error: 'Email required' });

  const result = await db.query(
    `SELECT o.*, p.name, p.image, p.price
     FROM orders o JOIN products p ON o.product_id = p.id
     WHERE o.customer_email = $1
     ORDER BY o.created_at DESC`,
    [email]
  );

  res.json(result.rows);
});

// POST /api/orders
router.post('/orders', async (req, res) => {
  const { product_id, customer_email, quantity } = req.body;
  await db.query(
    'INSERT INTO orders (product_id, customer_email, quantity) VALUES ($1, $2, $3)',
    [product_id, customer_email, quantity]
  );
  res.json({ success: true });
});

module.exports = router;

app.post('/api/orders', async (req, res) => {
  const { product_id, customer_email, quantity } = req.body;
  await db.query(
    'INSERT INTO orders (product_id, customer_email, quantity) VALUES ($1, $2, $3)',
    [product_id, customer_email, quantity]
  );
  res.json({ success: true });
});

app.get('/api/orders', async (req, res) => {
  const { email } = req.query;

  if (!email) return res.status(400).json({ error: 'Email required' });

  const result = await db.query(
    `SELECT o.*, p.name, p.image, p.price
     FROM orders o JOIN products p ON o.product_id = p.id
     WHERE o.customer_email = $1
     ORDER BY o.created_at DESC`,
    [email]
  );

  res.json(result.rows);

// routes/orderRoutes.js
const express = require("express");
const router = express.Router();
const { getAllOrders, updateOrderStatus } = require("../controllers/orderController");

router.get("/", getAllOrders);
router.put("/:id", updateOrderStatus);

module.exports = router;



});

