import express from 'express';
import axios from 'axios'; // Assuming you're using axios to fetch AliExpress data
import Product from '../models/productModel.js';
import esClient from '../config/elasticsearch.js';

const router = express.Router();

//
// 🌐 AliExpress Integration Routes (Direct Mongoose)
//

// Fetch product details from AliExpress (mocked for now)
router.post('/fetch', async (req, res) => {
  try {
    const { url } = req.body;

    // Replace this with actual scraping or API logic
    const response = await axios.get(`https://api.example.com/scrape?url=${encodeURIComponent(url)}`);
    const productData = response.data;

    res.json(productData);
  } catch (error) {
    res.status(500).json({ error: 'Failed to fetch product details', details: error.message });
  }
});

// Import product directly into MongoDB and Elasticsearch
router.post('/import', async (req, res) => {
  try {
    const { url } = req.body;

    // Fetch product data from AliExpress
    const response = await axios.get(`https://api.example.com/scrape?url=${encodeURIComponent(url)}`);
    const aliProduct = response.data;

    // Create and save to MongoDB
    const newProduct = new Product({
      name: aliProduct.name,
      description: aliProduct.description,
      price: aliProduct.price,
      category: aliProduct.category,
      images: aliProduct.images,
      sourceUrl: url,
    });

    await newProduct.save();

    // Index to Elasticsearch
    await esClient.index({
      index: 'products',
      id: newProduct._id.toString(),
      document: {
        name: newProduct.name,
        description: newProduct.description,
        price: newProduct.price,
        category: newProduct.category,
      },
    });

    res.status(201).json(newProduct);
  } catch (error) {
    res.status(500).json({ error: 'Failed to import product', details: error.message });
  }
});

export default router;