app.get('/api/track-orders', async (req, res) => {
  const { email } = req.query;
  if (!email) return res.status(400).json({ error: 'Email required' });

  const result = await db.query(
    `SELECT o.id, o.status, o.tracking_number, o.created_at, p.name, p.image
     FROM orders o JOIN products p ON o.product_id = p.id
     WHERE o.customer_email = $1
     ORDER BY o.created_at DESC`,
    [email]
  );

  res.json(result.rows);
});

