import express from 'express';
import {
  createUser,
  searchUser,
  getUserProfile,
  updateUserProfile
} from '../controllers/userController.js';
import { protectUser } from '../Middleware/authMiddleware.js';

const router = express.Router();

router.post('/', createUser);
router.get('/search', searchUser);
router.get('/me', protectUser, getUserProfile);
router.put('/me', protectUser, updateUserProfile);

export default router;