// seed/categories.js
import mongoose from 'mongoose';
import Category from './models/Category.js';

const categories = [
  { id: 1, name: "Electronics", slug: "electronics" },
  { id: 2, name: "Fashion", slug: "fashion" },
  { id: 3, name: "Beauty", slug: "beauty" },
  { id: 4, name: "Home & Garden", slug: "home-garden" },
];

async function seedCategories() {
  try {
    await mongoose.connect('mongodb://localhost:27017/your_database_name');
    await Category.deleteMany(); // Optional: clear existing data
    await Category.insertMany(categories);
    console.log('Categories seeded successfully!');
    mongoose.disconnect();
  } catch (error) {
    console.error('Error seeding categories:', error);
  }
}

seedCategories();
