require('dotenv').config();
const axios = require('axios');

const RAPIDAPI_KEY = process.env.RAPIDAPI_KEY;
const RAPIDAPI_HOST = 'ali-express1.p.rapidapi.com';

/**
 * Fetch product details from AliExpress via RapidAPI
 * @param {string} url - AliExpress product URL
 * @returns {Promise<Object>} - Product details
 */
const fetchAliExpressProduct = async (url) => {
  const options = {
    method: 'POST',
    url: `https://${RAPIDAPI_HOST}/product-details`,
    headers: {
      'X-RapidAPI-Key': RAPIDAPI_KEY,
      'X-RapidAPI-Host': RAPIDAPI_HOST,
    },
    data: { url },
  };

  const response = await axios.request(options);
  return response.data;
};

module.exports = { fetchAliExpressProduct };