import { Client } from '@elastic/elasticsearch';

const esClient = new Client({
  node: process.env.ELASTICSEARCH_URL || 'http://localhost:9200',
  auth: {
    username: process.env.ES_USERNAME || 'elastic',
    password: process.env.ES_PASSWORD || 'changeme',
  },
});

export const indexUser = async (user) => {
  await esClient.index({
    index: 'users',
    id: user._id.toString(),
    body: {
      name: user.name,
      email: user.email,
      age: user.age,
    },
  });
};

export const searchUsers = async (query) => {
  const result = await esClient.search({
    index: 'users',
    query: {
      match: { name: query },
    },
  });
  return result.hits.hits;
};
