const esClient = require('../elastic/esClient');

const initElasticsearch = async () => {
  const indexName = 'products';

  const exists = await esClient.indices.exists({ index: indexName });

  if (!exists) {
    await esClient.indices.create({
      index: indexName,
      body: {
        mappings: {
          properties: {
            name: { type: 'text' },
            price: { type: 'float' },
            image_url: { type: 'keyword' },
            category: { type: 'keyword' },
            source_url: { type: 'keyword' }
          }
        }
      }
    });
    console.log(`✅ Created Elasticsearch index: ${indexName}`);
  } else {
    console.log(`ℹ️ Elasticsearch index "${indexName}" already exists`);
  }
};

module.exports = initElasticsearch;
