import Order from '../models/orderModel.js';

export const createOrder = async (data) => {
  const order = new Order(data);
  return await order.save();
};

export const getOrdersByUser = async (userId) => {
  return await Order.find({ user: userId });
};

export const updateOrderStatus = async (orderId, status) => {
  return await Order.findByIdAndUpdate(orderId, { status }, { new: true });
};


const { Order } = require("../models");

exports.getAllOrders = async () => Order.findAll();
exports.getOrderById = async (id) => Order.findByPk(id);
exports.createOrder = async (data) => Order.create(data);
exports.updateOrder = async (id, updates) =>
  Order.update(updates, { where: { id } });
exports.deleteOrder = async (id) => Order.destroy({ where: { id } });

