const { MongoClient } = require("mongodb");
const { Client } = require("@elastic/elasticsearch");

// MongoDB setup
const mongoUri = "mongodb://localhost:27017";
const mongoClient = new MongoClient(mongoUri);
const dbName = "productDB";
const collectionName = "aliexpressProducts";

// Elasticsearch setup
const esClient = new Client({ node: "http://localhost:9200" });
const esIndex = "aliexpress_products";

export default async function fetchAliExpressData(url) {
  return {
    name: "Imported AliExpress Product",
    price: 25.99,
    category: "Electronics",
    image_url: "https://via.placeholder.com/150",
    source_url: url,
    imported_at: new Date(),
  };

  // Save to MongoDB
  await mongoClient.connect();
  const db = mongoClient.db(dbName);
  const collection = db.collection(collectionName);
  await collection.insertOne(productData);

  // Index to Elasticsearch
  await esClient.index({
    index: esIndex,
    document: productData,
  });

  return productData;
};
